﻿Imports System.Text
Imports System.Threading
Imports System.Globalization

Public Class FormStartUp

    Declare Function ChangeWindowMessageFilter Lib "user32.dll" (message As UInteger, dwFlag As UInteger) As Boolean

    Private Sub FormStartUp_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' check culture and set en, if not ja.
        ' 環境変数RNSF_LANG=JAでないならば英語モード
        Dim envlang As String = Environment.GetEnvironmentVariable("RNSF_LANG")

        If (Not envlang Is Nothing AndAlso envlang.ToUpper = "JA") Then
            Thread.CurrentThread.CurrentUICulture = New CultureInfo("ja", False)
        ElseIf ((Not envlang Is Nothing AndAlso envlang.ToUpper <> "JA") OrElse _
            (Not Thread.CurrentThread.CurrentUICulture.Name.StartsWith("ja") AndAlso Not Thread.CurrentThread.CurrentUICulture.Name.StartsWith("en"))) Then
            Thread.CurrentThread.CurrentUICulture = New CultureInfo("en", False)
            mw.modeJP = False
        ElseIf Thread.CurrentThread.CurrentUICulture.Name.StartsWith("en") Then
            mw.modeJP = False
        End If

        ' 一般アプリからのドロップを許可 - したいのだけど、なぜかうまくいってない。APIはtrueを返してくれているんだが…。
        ChangeWindowMessageFilter(&H233, 1) ' WM_DROPFILES, MSGFLT_ADD
        ChangeWindowMessageFilter(&H4A, 1)  ' WM_COPYDATA, MSGFLT_ADD
        ChangeWindowMessageFilter(&H49, 1)  ' 0x0049, MSGFLT_ADD

        ' コマンドラインの解析
        If Environment.GetCommandLineArgs.Count > 1 Then
            If String.Compare(Environment.GetCommandLineArgs(1), "/t", True) = 0 Then
                If Environment.GetCommandLineArgs.Count = 2 Then
                    MsgBox(mw.MJP("日時を変更したいファイル名またはフォルダ名を指定して下さい。", "Please specify the file or folder name to change timestamp."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, mw.MJP("ファイルのタイムスタンプ変更", "Change Timestamp"))
                Else
                    ' ファイルのタイムスタンプ変更のダイアログを表示
                    Dim fmCTS As New ChangeTimeStamp
                    fmCTS.setTargetName(Environment.GetCommandLineArgs(2))
                    fmCTS.ShowDialog()
                End If
                Me.Close()
                Return
            ElseIf String.Compare(Environment.GetCommandLineArgs(1), "/s", True) = 0 Then
                FormMainWindow.ButtonShutdown_Click(Nothing, Nothing)
                Me.Close()
                Return
            ElseIf String.Compare(Environment.GetCommandLineArgs(1), "/r", True) = 0 Then
                FormMainWindow.ButtonReboot_Click(Nothing, Nothing)
                Me.Close()
                Return
            ElseIf String.Compare(Environment.GetCommandLineArgs(1), "/l", True) = 0 Then
                FormMainWindow.ButtonLogoff_Click(Nothing, Nothing)
                Me.Close()
                Return
            ElseIf String.Compare(Environment.GetCommandLineArgs(1), "/f", True) = 0 Then
                FormMainWindow.ButtonForceReboot_Click(Nothing, Nothing)
                Me.Close()
                Return
            ElseIf String.Compare(Environment.GetCommandLineArgs(1), "/u", True) = 0 Then
                Dim stbut As New StringBuilder
                Dim i As Integer

                For i = 2 To Environment.GetCommandLineArgs.Count - 1
                    stbut.Append(Environment.GetCommandLineArgs(i))
                    stbut.Append(" ")
                Next

                Interaction.Shell(stbut.ToString, AppWinStyle.NormalFocus)
                Me.Close()
                Return
            End If
        End If

        ' メインウィンドウの表示
        Dim fmw As New FormMainWindow
        fmw.ShowDialog()

        ' スタートアップウィンドウをクローズ
        Me.Close()
    End Sub

    <System.Runtime.InteropServices.DllImport("user32.dll", SetLastError:=True)> _
    Public Shared Function ExitWindowsEx(ByVal uFlags As FormMainWindow.ExitWindows, _
    ByVal dwReason As Integer) As Boolean
    End Function

    <System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError:=True)> _
    Private Shared Function GetCurrentProcess() As IntPtr
    End Function

    <System.Runtime.InteropServices.DllImport("advapi32.dll", SetLastError:=True)> _
    Private Shared Function OpenProcessToken(ByVal ProcessHandle As IntPtr, _
    ByVal DesiredAccess As Integer, _
    ByRef TokenHandle As IntPtr) As Boolean
    End Function

    <System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError:=True)> _
    Private Shared Function CloseHandle(ByVal hHandle As IntPtr) As Boolean
    End Function

    <System.Runtime.InteropServices.DllImport("advapi32.dll", SetLastError:=True, _
        CharSet:=System.Runtime.InteropServices.CharSet.Auto)> _
    Private Shared Function LookupPrivilegeValue(ByVal lpSystemName As String, _
    ByVal lpName As String, _
    ByRef lpLuid As Long) As Boolean
    End Function

    <System.Runtime.InteropServices.StructLayout( _
        System.Runtime.InteropServices.LayoutKind.Sequential, Pack:=1)> _
    Private Structure TOKEN_PRIVILEGES
        Public PrivilegeCount As Integer
        Public Luid As Long
        Public Attributes As Integer
    End Structure

    <System.Runtime.InteropServices.DllImport("advapi32.dll", SetLastError:=True)> _
    Private Shared Function AdjustTokenPrivileges(ByVal TokenHandle As IntPtr, _
    ByVal DisableAllPrivileges As Boolean, _
    ByRef NewState As TOKEN_PRIVILEGES, _
    ByVal BufferLength As Integer, _
    ByVal PreviousState As IntPtr, _
    ByVal ReturnLength As IntPtr) As Boolean
    End Function

    'シャットダウンするためのセキュリティ特権を有効にする
    Public Shared Sub AdjustToken()
        Const TOKEN_ADJUST_PRIVILEGES As Integer = &H20
        Const TOKEN_QUERY As Integer = &H8
        Const SE_PRIVILEGE_ENABLED As Integer = &H2
        Const SE_SHUTDOWN_NAME As String = "SeShutdownPrivilege"

        If Environment.OSVersion.Platform <> PlatformID.Win32NT Then
            Return
        End If

        Dim procHandle As IntPtr = GetCurrentProcess()

        'トークンを取得する
        Dim tokenHandle As IntPtr
        OpenProcessToken(procHandle, _
            TOKEN_ADJUST_PRIVILEGES Or TOKEN_QUERY, tokenHandle)
        'LUIDを取得する
        Dim tp As New TOKEN_PRIVILEGES()
        tp.Attributes = SE_PRIVILEGE_ENABLED
        tp.PrivilegeCount = 1
        LookupPrivilegeValue(Nothing, SE_SHUTDOWN_NAME, tp.Luid)
        '特権を有効にする
        AdjustTokenPrivileges(tokenHandle, False, tp, 0, IntPtr.Zero, IntPtr.Zero)

        '閉じる
        CloseHandle(tokenHandle)
    End Sub

End Class

Public Class mw
    Public Shared modeJP As Boolean = True
    Public Shared Function MJP(jstr As String, estr As String) As String
        If mw.modeJP Then
            Return jstr
        Else
            Return estr
        End If
    End Function

    Private Function toTF(ByVal i As Integer) As Boolean
        If i = 0 Then
            Return False
        Else
            Return True
        End If
    End Function
End Class
