﻿Imports System.Text
Imports Microsoft.Win32

Public Class FormMainWindow

    Private bCloseCheck As Boolean = False
    Const strBetaVer As String = "β"
    Const strBetaVerEn As String = "beta"

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load


        ' [全]起動時に毎回実行タブの設定
        BootRunLoad(TabPage_AL_RUN, ListView_AL_RUN, Registry.LocalMachine, "SOFTWARE\Microsoft\Windows\CurrentVersion\Run")

        ' [全]起動時に1度だけ実行タブの設定
        BootRunLoad(TabPage_AL_ONCE, ListView_AL_ONCE, Registry.LocalMachine, "SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce")

        ' [個]ログオン時に毎回実行タブの設定
        BootRunLoad(TabPage_KO_RUN, ListView_KO_RUN, Registry.CurrentUser, "SOFTWARE\Microsoft\Windows\CurrentVersion\Run")

        ' [個]ログオン時に1度だけ実行タブの設定
        BootRunLoad(TabPage_KO_ONCE, ListView_KO_ONCE, Registry.CurrentUser, "SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce")

        ' 他の設定タブの設定
        OtherTabLoad(TabPageOther)

        ' バージョン情報タブの準備
        GetVersionInfo()

        ' 以降は、フォームクローズのチェックを行う
        bCloseCheck = True
    End Sub

    Private Sub BootRunLoad(tb As System.Windows.Forms.TabPage, lv As ListView, hive As Microsoft.Win32.RegistryKey, regsubkeyname As String)
        ' レジストリキーの読込
        Try
            ' 基礎情報を設定
            Dim ts As New TabStatus
            ts.tab = tb
            ts.lv = lv
            ts.hive = hive
            ts.regsubkeyname = regsubkeyname
            ts.changed = False

            ' 任意の情報を設定できるTagに基礎情報を設定
            tb.Tag = ts
            lv.Tag = ts

            ' レジストリからの読み出し
            Dim rkey As RegistryKey = hive.OpenSubKey(regsubkeyname)
            Dim strRegValueNames As String() = rkey.GetValueNames()
            Dim strValue As String
            Dim lvItem1 As ListViewItem

            ' 各値をリストビューへ吸い上げる
            For Each strRegValueName As String In strRegValueNames
                strValue = rkey.GetValue(strRegValueName)
                lvItem1 = lv.Items.Add(strRegValueName)
                lvItem1.SubItems.Add(strValue)
            Next

            rkey.Close()

        Catch ex As Exception
            MsgBox(ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)

        End Try

    End Sub

    Private Sub OtherTabLoad(tb As System.Windows.Forms.TabPage)
        ' レジストリキーの読込
        Try
            Dim rkey As RegistryKey
            ' 任意のフォルダからコマンドプロンプト
            Try
                ' レジストリからの読み出し
                rkey = Registry.ClassesRoot.OpenSubKey("Folder\Shell\RnsfCmdPromptP\command")
                If rkey.GetValue("") = "CMD.EXE /K PUSHD ""%1""" Then
                    CheckBoxFolderCmd.Checked = True

                End If
                rkey.Close()

                If CheckBoxFolderCmd.Checked Then
                    rkey = Registry.ClassesRoot.OpenSubKey("Folder\Shell\RnsfCmdPromptP")
                    TextBoxFolderCmd.Text = rkey.GetValue("")
                    rkey.Close()
                End If
            Catch
            End Try

            ' 任意のフォルダから管理者でコマンドプロンプト
            Try
                ' レジストリからの読み出し
                rkey = Registry.ClassesRoot.OpenSubKey("Folder\Shell\RnsfCmdPrompt3P\command")
                If rkey.GetValue("") = """" + Application.ExecutablePath + """ /u CMD.EXE /K PUSHD ""%1""" Then
                    CheckBoxFolderCmdAdmin.Checked = True
                End If
                rkey.Close()

                If CheckBoxFolderCmdAdmin.Checked Then
                    rkey = Registry.ClassesRoot.OpenSubKey("Folder\Shell\RnsfCmdPrompt3P")
                    TextBoxFolderCmdAdmin.Text = rkey.GetValue("")
                    rkey.Close()
                End If
            Catch
            End Try

            ' 任意のファイルに日時変更を加える
            Try
                ' レジストリからの読み出し
                rkey = Registry.ClassesRoot.OpenSubKey("*\Shell\RnsfTimeStamp\command")
                If rkey.GetValue("") = """" + Application.ExecutablePath + """ /T ""%1""" Then
                    CheckBoxFileTimeStamp.Checked = True

                End If
                rkey.Close()

                If CheckBoxFileTimeStamp.Checked Then
                    rkey = Registry.ClassesRoot.OpenSubKey("*\Shell\RnsfTimeStamp")
                    TextBoxFileTimeStamp.Text = rkey.GetValue("")
                    rkey.Close()
                End If
            Catch
            End Try

            ' 任意のフォルダに日時変更を加える
            Try
                ' レジストリからの読み出し
                rkey = Registry.ClassesRoot.OpenSubKey("Folder\Shell\RnsfTimeStamp\command")
                If rkey.GetValue("") = """" + Application.ExecutablePath + """ /T ""%1""" Then
                    CheckBoxFolderTimeStamp.Checked = True
                End If
                rkey.Close()

                If CheckBoxFolderTimeStamp.Checked Then
                    rkey = Registry.ClassesRoot.OpenSubKey("Folder\Shell\RnsfTimeStamp")
                    TextBoxFolderTimeStamp.Text = rkey.GetValue("")
                    rkey.Close()
                End If
            Catch
            End Try

            ' CHMの取り扱い範囲を広げる
            Try
                ' レジストリからの読み出し
                rkey = Registry.LocalMachine.OpenSubKey("SOFTWARE\Microsoft\HTMLHelp\1.x\ItssRestrictions")
                Select Case rkey.GetValue("MaxAllowedZone")
                    Case 4
                        RadioButton5.Checked = True

                    Case 3
                        RadioButton4.Checked = True

                    Case 2
                        RadioButton3.Checked = True

                    Case 1
                        RadioButton2.Checked = True

                    Case Else
                        RadioButton1.Checked = True
                End Select

                rkey.Close()
            Catch ex As Exception

            End Try

            ' 基礎情報を設定
            Dim ts As New TabStatus
            ts.tab = Nothing
            ts.lv = Nothing
            ts.hive = Nothing
            ts.regsubkeyname = Nothing
            ts.changed = False

            ' 任意の情報を設定できるTagに基礎情報を設定
            tb.Tag = ts

        Catch ex As Exception
            MsgBox(ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)

        End Try

    End Sub

    ' バージョン情報取得
    Private Sub GetVersionInfo()
        '    'AssemblyTitleの取得
        '    Dim asmttl As System.Reflection.AssemblyTitleAttribute = _
        '        CType(Attribute.GetCustomAttribute( _
        '            System.Reflection.Assembly.GetExecutingAssembly(), _
        '            GetType(System.Reflection.AssemblyTitleAttribute)),  _
        '                System.Reflection.AssemblyTitleAttribute)
        '    strSoftwareTitle = asmttl.Title

        '    'AssemblyCopyrightの取得
        '    Dim asmcpy As System.Reflection.AssemblyCopyrightAttribute = _
        '        CType(Attribute.GetCustomAttribute( _
        '            System.Reflection.Assembly.GetExecutingAssembly(), _
        '            GetType(System.Reflection.AssemblyCopyrightAttribute)),  _
        '                System.Reflection.AssemblyCopyrightAttribute)
        '    strCopyright = asmcpy.Copyright + vbCrLf + vbCrLf + "http://www.inasoft.org/"

        '自分自身のバージョン情報を取得する
        Dim ver As System.Diagnostics.FileVersionInfo = _
            System.Diagnostics.FileVersionInfo.GetVersionInfo( _
            System.Reflection.Assembly.GetExecutingAssembly().Location)
        LabelVersionString.Text = "version " & (ver.FileMajorPart - 8) & "." & ver.FileMinorPart & ver.FileBuildPart & mw.MJP(strBetaVer, strBetaVerEn)
        LabelCopyrightString.Text = ver.LegalCopyright


        AboutBox1.Text = mw.MJP( _
                         "　このプログラムはWindowsの環境設定を変更することを主な目的としています。元に戻せるかどうか不安な方は、重要なデータやレジストリのバックアップを取ってからご使用下さい。バックアップは専用のツールやWindows付属のツールをお使い下さい。" + vbCrLf + _
                         "　このプログラムはフリーソフトです。営利・非営利目的に関わらず無償で使用できますが、このプログラムを使用した際に何か障害が発生しても、当方では一切責任を負いませんのであらかじめご了承下さい。" + vbCrLf + _
                         "　このプログラムの紹介・再配布は(媒体を問わず)自由に行うことができます。再配布(転載・収録を含む)の際に事前に許可を得る必要はありません。また、紹介する際にアイコンや実行時画面を用いてもかまいません。本ソフトウェアの著作権上の規定は、日本国の法律に準拠することとします。その他の詳細な情報につきましては、付属のドキュメントを参照して下さい。" + vbCrLf + _
                         "" + vbCrLf + _
                         "※Windowsは米国Microsoft Corporationの米国およびその他の国における登録商標です。" + vbCrLf + _
                         "※その他、表示される会社名・製品名などは、一般に各社の登録商標もしくは商標です。", _
                         "This program will change the Windows environment settings. To revert whether Uneasy original, please use the back up of important data and registry. Backup, please use the dedicated tools and with the Windows tool. This program is free software. You can use free of charge regardless of the profit and non-profit purposes, but even if something fails when you use this program, please understand that it does not take any responsibility on our side. This introduction and re-distribution of the program can be done freely (regardless of the medium). You do not need to get prior permission at the time of re-distribution (including reprinting and recording). In addition, you can use an icon or run-time screen at the time of introduction. Provisions on the copyright of this software, we want to be governed by the laws of Japan. With regard to other detailed information, see the accompanying documentation. Windows is a registered trademark in the United States and other countries of United States Microsoft Corporation. Others, such as a company name, product name displayed is the general of their respective owners of the registered trademarks or trademarks.")

    End Sub

    Private Sub LinkLabel1_LinkClicked(sender As System.Object, e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles LinkLabel1.LinkClicked
        'リンク先に移動したことにする
        LinkLabel1.LinkVisited = True

        'ブラウザで開く
        System.Diagnostics.Process.Start(LinkLabel1.Text)
    End Sub

    Private Sub ButtonExit_Click(sender As System.Object, e As System.EventArgs) Handles ButtonExit.Click
        Me.Close()
    End Sub

    Private Sub Form1_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If bCloseCheck Then
            If Not MsgBox(mw.MJP("終了してもよろしいですか?", "Are you sure you want to quit?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
                e.Cancel = True
            End If
        End If
    End Sub

    ' キー項目の重複チェック
    Private Function lvHasKey(lv As ListView, key As String)
        For Each i1 As ListViewItem In lv.Items
            If (i1.Text = key) Then
                Return True
            End If
        Next
        Return False
    End Function

    Private Sub ButtonAdd_CMN_Click(tb As System.Windows.Forms.TabPage, lv As ListView)
        ' 共通の「追加」用プロシージャ
        Dim aedlg As New AddEditDialog

        aedlg.Text = mw.MJP("項目の追加", "Add")

        While True
            If DialogResult.OK = aedlg.ShowDialog() Then
                Dim lvitem As ListViewItem

                ' 追加しようとする項目に重複がないか確認
                If Not lvHasKey(lv, aedlg.TextBoxName.Text) Then
                    ' 項目の追加
                    lvitem = lv.Items.Add(aedlg.TextBoxName.Text)
                    lvitem.SubItems.Add(aedlg.TextBoxCmdLine.Text)

                    ' 変更ON
                    DirectCast(tb.Tag, TabStatus).changed = True
                    Return
                Else
                    MsgBox(mw.MJP("「任意の名前」が他の項目と重複しています。", "Item name is a duplicate of the other items."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation, aedlg.Text)
                End If
            Else
                ' キャンセル
                Return
            End If

            ' 入力しようとした項目に重複があったため、入力をやり直し
        End While
    End Sub

    Private Sub ButtonEdit_CMN_Click(tb As System.Windows.Forms.TabPage, lv As ListView)
        ' 共通の「編集」用プロシージャ
        Dim aedlg As New AddEditDialog

        If lv.SelectedItems.Count < 1 Then
            MsgBox(mw.MJP("編集したい項目を選択してください。", "Please select the item you want to edit."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation, mw.MJP("項目の編集", "Edit"))
            Return
        End If

        aedlg.Text = mw.MJP("項目の編集", "Edit")

        ' 編集前の値を入れる
        aedlg.TextBoxName.Text = lv.SelectedItems(0).Text
        aedlg.TextBoxCmdLine.Text = lv.SelectedItems(0).SubItems(1).Text

        While True
            If DialogResult.OK = aedlg.ShowDialog() Then
                ' 「任意の名前」が編集されていないならそのまま設定
                If aedlg.TextBoxName.Text = lv.SelectedItems(0).Text Then
                    lv.SelectedItems(0).SubItems(1).Text = aedlg.TextBoxCmdLine.Text

                    ' 変更ON
                    DirectCast(tb.Tag, TabStatus).changed = True

                    Return
                End If

                ' 入力検定
                ' 変更しようとする項目に重複がないか確認
                If lvHasKey(lv, aedlg.TextBoxName.Text) = False Then
                    ' 項目の追加
                    lv.SelectedItems(0).Text = aedlg.TextBoxName.Text
                    lv.SelectedItems(0).SubItems(1).Text = aedlg.TextBoxCmdLine.Text

                    ' 変更ON
                    DirectCast(tb.Tag, TabStatus).changed = True

                    Return
                Else
                    MsgBox(mw.MJP("「任意の名前」が他の項目と重複しています。", "Item name is a duplicate of the other items."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation, aedlg.Text)
                End If
            Else
                ' キャンセル
                Return
            End If

            ' 入力しようとした項目に重複があったため、入力をやり直し
        End While
    End Sub

    Private Sub ButtonDel_CMN_Click(tb As System.Windows.Forms.TabPage, lv As ListView)
        ' 共通の「削除」用プロシージャ
        If lv.SelectedItems.Count < 1 Then
            MsgBox(mw.MJP("削除したい項目を選択してください。", "Please select the item you want to delete."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation, mw.MJP("項目の削除", "Delete"))
            Return
        End If

        If MsgBox(mw.MJP("選択している項目を削除してもよろしいですか。", "Are you sure you want to delete a selected item?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, mw.MJP("項目の削除", "Delete")) = MsgBoxResult.Ok Then
            ' 削除
            lv.SelectedItems(0).Remove()

            ' 変更ON
            DirectCast(tb.Tag, TabStatus).changed = True
        End If

    End Sub

    Private Sub ButtonAdd_AL_RUN_Click(sender As System.Object, e As System.EventArgs) Handles ButtonAdd_AL_RUN.Click
        ' 共通の「追加」用プロシージャを呼び出し
        ButtonAdd_CMN_Click(TabPage_AL_RUN, ListView_AL_RUN)
    End Sub


    Private Sub ButtonEdit_AL_RUN_Click(sender As System.Object, e As System.EventArgs) Handles ButtonEdit_AL_RUN.Click
        ' 共通の「編集」用プロシージャを呼び出し
        ButtonEdit_CMN_Click(TabPage_AL_RUN, ListView_AL_RUN)
    End Sub


    Private Sub ButtonDel_AL_RUN_Click(sender As System.Object, e As System.EventArgs) Handles ButtonDel_AL_RUN.Click
        ' 共通の「削除」用プロシージャを呼び出し
        ButtonDel_CMN_Click(TabPage_AL_RUN, ListView_AL_RUN)
    End Sub

    Private Sub ButtonAdd_AL_ONCE_Click(sender As System.Object, e As System.EventArgs) Handles ButtonAdd_AL_ONCE.Click
        ' 共通の「追加」用プロシージャを呼び出し
        ButtonAdd_CMN_Click(TabPage_AL_ONCE, ListView_AL_ONCE)
    End Sub


    Private Sub ButtonEdit_AL_ONCE_Click(sender As System.Object, e As System.EventArgs) Handles ButtonEdit_AL_ONCE.Click
        ' 共通の「編集」用プロシージャを呼び出し
        ButtonEdit_CMN_Click(TabPage_AL_ONCE, ListView_AL_ONCE)
    End Sub


    Private Sub ButtonDel_AL_ONCE_Click(sender As System.Object, e As System.EventArgs) Handles ButtonDel_AL_ONCE.Click
        ' 共通の「削除」用プロシージャを呼び出し
        ButtonDel_CMN_Click(TabPage_AL_ONCE, ListView_AL_ONCE)
    End Sub

    Private Sub ButtonAdd_KO_RUN_Click(sender As System.Object, e As System.EventArgs) Handles ButtonAdd_KO_RUN.Click
        ' 共通の「追加」用プロシージャを呼び出し
        ButtonAdd_CMN_Click(TabPage_KO_RUN, ListView_KO_RUN)
    End Sub


    Private Sub ButtonEdit_KO_RUN_Click(sender As System.Object, e As System.EventArgs) Handles ButtonEdit_KO_RUN.Click
        ' 共通の「編集」用プロシージャを呼び出し
        ButtonEdit_CMN_Click(TabPage_KO_RUN, ListView_KO_RUN)
    End Sub


    Private Sub ButtonDel_KO_RUN_Click(sender As System.Object, e As System.EventArgs) Handles ButtonDel_KO_RUN.Click
        ' 共通の「削除」用プロシージャを呼び出し
        ButtonDel_CMN_Click(TabPage_KO_RUN, ListView_KO_RUN)
    End Sub

    Private Sub ButtonAdd_KO_ONCE_Click(sender As System.Object, e As System.EventArgs) Handles ButtonAdd_KO_ONCE.Click
        ' 共通の「追加」用プロシージャを呼び出し
        ButtonAdd_CMN_Click(TabPage_KO_ONCE, ListView_KO_ONCE)
    End Sub


    Private Sub ButtonEdit_KO_ONCE_Click(sender As System.Object, e As System.EventArgs) Handles ButtonEdit_KO_ONCE.Click
        ' 共通の「編集」用プロシージャを呼び出し
        ButtonEdit_CMN_Click(TabPage_KO_ONCE, ListView_KO_ONCE)
    End Sub


    Private Sub ButtonDel_KO_ONCE_Click(sender As System.Object, e As System.EventArgs) Handles ButtonDel_KO_ONCE.Click
        ' 共通の「削除」用プロシージャを呼び出し
        ButtonDel_CMN_Click(TabPage_KO_ONCE, ListView_KO_ONCE)
    End Sub

    Private Sub ListView_AL_RUN_MouseDoubleClick(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListView_AL_RUN.MouseDoubleClick
        If ListView_AL_RUN.SelectedItems.Count > 0 Then
            ' アイテムをダブルクリックで編集開始
            ButtonEdit_AL_RUN_Click(sender, e)
        End If
    End Sub

    Private Sub ListView_AL_ONCE_MouseDoubleClick(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListView_AL_ONCE.MouseDoubleClick
        If ListView_AL_ONCE.SelectedItems.Count > 0 Then
            ' アイテムをダブルクリックで編集開始
            ButtonEdit_AL_ONCE_Click(sender, e)
        End If
    End Sub

    Private Sub ListView_KO_RUN_MouseDoubleClick(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListView_KO_RUN.MouseDoubleClick
        If ListView_KO_RUN.SelectedItems.Count > 0 Then
            ' アイテムをダブルクリックで編集開始
            ButtonEdit_KO_RUN_Click(sender, e)
        End If
    End Sub

    Private Sub ListView_KO_ONCE_MouseDoubleClick(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListView_KO_ONCE.MouseDoubleClick
        If ListView_KO_ONCE.SelectedItems.Count > 0 Then
            ' アイテムをダブルクリックで編集開始
            ButtonEdit_KO_ONCE_Click(sender, e)
        End If
    End Sub

    Private Sub ContextMenuStrip1_Opening(sender As System.Object, e As System.ComponentModel.CancelEventArgs) Handles ContextMenuStrip1.Opening
        ' コンテキストメニューが開いたとき
        Dim lv As ListView = DirectCast(ContextMenuStrip1.SourceControl, ListView)

        If lv.SelectedItems.Count = 0 Then
            ' アイテムが選択されていなければ、編集・削除は非活性
            ContextMenuStrip1.Items(1).Enabled = False
            ContextMenuStrip1.Items(2).Enabled = False
        Else
            ContextMenuStrip1.Items(1).Enabled = True
            ContextMenuStrip1.Items(2).Enabled = True
        End If
    End Sub

    Private Sub ToolStripMenuItemAdd_Click(sender As System.Object, e As System.EventArgs) Handles ToolStripMenuItemAdd.Click
        ' コンテキストメニューの「追加」メニューをクリック
        Dim lv As ListView = DirectCast(ContextMenuStrip1.SourceControl, ListView)
        ButtonAdd_CMN_Click(DirectCast(lv.Tag, TabStatus).tab, lv)
    End Sub

    Private Sub ToolStripMenuItemEdit_Click(sender As System.Object, e As System.EventArgs) Handles ToolStripMenuItemEdit.Click
        ' コンテキストメニューの「編集」メニューをクリック
        Dim lv As ListView = DirectCast(ContextMenuStrip1.SourceControl, ListView)
        ButtonEdit_CMN_Click(DirectCast(lv.Tag, TabStatus).tab, lv)
    End Sub

    Private Sub ToolStripMenuItemDel_Click(sender As System.Object, e As System.EventArgs) Handles ToolStripMenuItemDel.Click
        ' コンテキストメニューの「削除」メニューをクリック
        Dim lv As ListView = DirectCast(ContextMenuStrip1.SourceControl, ListView)
        ButtonDel_CMN_Click(DirectCast(lv.Tag, TabStatus).tab, lv)
    End Sub

    Private Sub ButtonHelp_Click(sender As System.Object, e As System.EventArgs) Handles ButtonHelp.Click
        Try
            System.Diagnostics.Process.Start("RnsfLite.chm")
        Catch ex As Exception
            MsgBox(mw.MJP("RnsfLite.chmを開けません。", "Cannot open - RnsfLite.chm"), MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, mw.MJP("ヘルプを開く", "Help"))
        End Try

    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles ButtonOK.Click
        Dim bSaved As Boolean = False

        ' [適用]ボタン押下

        ' [全]起動時に毎回実行タブの設定
        If BootRunSave(TabPage_AL_RUN) Then
            bSaved = True
        End If

        ' [全]起動時に1度だけ実行タブの設定
        If BootRunSave(TabPage_AL_ONCE) Then
            bSaved = True
        End If

        ' [個]ログオン時に毎回実行タブの設定
        If BootRunSave(TabPage_KO_RUN) Then
            bSaved = True
        End If

        ' [個]ログオン時に1度だけ実行タブの設定
        If BootRunSave(TabPage_KO_ONCE) Then
            bSaved = True
        End If

        ' 他の設定タブの設定
        If OtherTabSave(TabPageOther) Then
            bSaved = True
        End If

        If bSaved Then
            MsgBox(mw.MJP("設定の書き込みが完了しました。", "Setting to the registry has been completed."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Information, Me.Text)
        Else
            MsgBox(mw.MJP("更新された設定はありません。", "There is no updated item."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Information, Me.Text)
        End If


    End Sub

    Private Function BootRunSave(tb As System.Windows.Forms.TabPage)
        ' ListView関連のレジストリキーの書き込み
        Try
            ' 基礎情報を設定
            Dim ts As TabStatus = DirectCast(tb.Tag, TabStatus)

            If ts.changed Then
                ' レジストリへ書き込み
                Dim rkey As RegistryKey = ts.hive.CreateSubKey(ts.regsubkeyname)

                ' キーの中の値を全て削除
                Dim strRegValueNames As String() = rkey.GetValueNames()
                For Each strRegValueName As String In strRegValueNames
                    rkey.DeleteValue(strRegValueName)
                Next

                ' リストビューの内容をすべて書き込み
                For Each item1 As ListViewItem In ts.lv.Items
                    rkey.SetValue(item1.Text, item1.SubItems(1).Text)
                Next
                rkey.Close()

                ' 変更フラグを元に戻す
                ts.changed = False

                Return True

            End If

        Catch ex As Exception
            MsgBox(ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)

        End Try

        Return False

    End Function

    Private Function OtherTabSave(tb As System.Windows.Forms.TabPage)
        ' レジストリキーの書き込み
        Try
            ' 基礎情報を設定
            Dim ts As TabStatus = DirectCast(tb.Tag, TabStatus)

            If ts.changed Then
                ' 任意のフォルダでコマンドプロンプトを開く
                Try
                    ' レジストリへ書き込み
                    If CheckBoxFolderCmd.Checked Then
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("Folder\Shell\RnsfCmdPromptP")
                        If TextBoxFolderCmd.Text = "" Then
                            TextBoxFolderCmd.Text = mw.MJP("コマンドプロンプト", "Command Prompt")
                        End If
                        rkey.SetValue("", TextBoxFolderCmd.Text)

                        Dim rkey2 As RegistryKey = rkey.CreateSubKey("command")
                        rkey2.SetValue("", "CMD.EXE /K PUSHD ""%1""")
                        rkey2.Close()
                        rkey.Close()
                    Else
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("Folder\Shell")
                        rkey.DeleteSubKeyTree("RnsfCmdPromptP")
                        rkey.Close()
                    End If
                Catch ex As Exception
                End Try

                ' 任意のフォルダでコマンドプロンプトを開く（管理者モード）
                Try
                    ' レジストリへ書き込み
                    If CheckBoxFolderCmdAdmin.Checked Then
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("Folder\Shell\RnsfCmdPrompt3P")
                        If TextBoxFolderCmdAdmin.Text = "" Then
                            TextBoxFolderCmdAdmin.Text = mw.MJP("管理者：コマンドプロンプト", "Command Prompt (as Administrator)")
                        End If
                        rkey.SetValue("", TextBoxFolderCmdAdmin.Text)

                        Dim rkey2 As RegistryKey = rkey.CreateSubKey("command")
                        rkey2.SetValue("", """" + Application.ExecutablePath + """ /u CMD.EXE /K PUSHD ""%1""")
                        rkey2.Close()
                        rkey.Close()
                    Else
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("Folder\Shell")
                        rkey.DeleteSubKeyTree("RnsfCmdPrompt3P")
                        rkey.Close()
                    End If
                Catch ex As Exception
                End Try

                ' ファイル日時の変更
                Try
                    ' レジストリへ書き込み
                    If CheckBoxFileTimeStamp.Checked Then
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("*\Shell\RnsfTimeStamp")
                        If TextBoxFileTimeStamp.Text = "" Then
                            TextBoxFileTimeStamp.Text = mw.MJP("ファイル日時の変更", "Change Timestamp")
                        End If
                        rkey.SetValue("", TextBoxFileTimeStamp.Text)

                        Dim rkey2 As RegistryKey = rkey.CreateSubKey("command")
                        rkey2.SetValue("", """" + Application.ExecutablePath + """ /T ""%1""")
                        rkey2.Close()
                        rkey.Close()
                    Else
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("*\Shell")
                        rkey.DeleteSubKeyTree("RnsfTimeStamp")
                        rkey.Close()
                    End If
                Catch ex As Exception
                End Try

                ' フォルダ日時の変更
                Try
                    ' レジストリへ書き込み
                    If CheckBoxFolderTimeStamp.Checked Then
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("Folder\Shell\RnsfTimeStamp")
                        If TextBoxFolderTimeStamp.Text = "" Then
                            TextBoxFolderTimeStamp.Text = mw.MJP("フォルダ日時の変更", "Change Timestamp")
                        End If
                        rkey.SetValue("", TextBoxFolderTimeStamp.Text)

                        Dim rkey2 As RegistryKey = rkey.CreateSubKey("command")
                        rkey2.SetValue("", """" + Application.ExecutablePath + """ /T ""%1""")
                        rkey2.Close()
                        rkey.Close()
                    Else
                        Dim rkey As RegistryKey = Registry.ClassesRoot.CreateSubKey("Folder\Shell")
                        rkey.DeleteSubKeyTree("RnsfTimeStamp")
                        rkey.Close()
                    End If
                Catch ex As Exception
                End Try

                Try
                    ' レジストリへ書き込み
                    Dim iMaxAllowedZone As Integer = 0

                    If RadioButton1.Checked Then
                        iMaxAllowedZone = 0
                    End If
                    If RadioButton2.Checked Then
                        iMaxAllowedZone = 1
                    End If
                    If RadioButton3.Checked Then
                        iMaxAllowedZone = 2
                    End If
                    If RadioButton4.Checked Then
                        iMaxAllowedZone = 3
                    End If
                    If RadioButton5.Checked Then
                        iMaxAllowedZone = 4
                    End If

                    Dim rkey As RegistryKey = Registry.LocalMachine.CreateSubKey("SOFTWARE\Microsoft\HTMLHelp\1.x\ItssRestrictions")
                    rkey.SetValue("MaxAllowedZone", iMaxAllowedZone)
                    rkey.Close()
                Catch ex As Exception
                    MsgBox(ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)

                End Try

                ' 変更フラグを元に戻す
                ts.changed = False

                Return True
            End If

        Catch ex As Exception
            MsgBox(ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)

        End Try

        Return False

    End Function

    Private Sub CheckBoxFolderCmd_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CheckBoxFolderCmd.CheckedChanged, TextBoxFolderCmd.TextChanged, _
                                                                                                         CheckBoxFolderCmdAdmin.CheckedChanged, TextBoxFolderCmdAdmin.TextChanged, _
                                                                                                         RadioButton1.CheckedChanged, RadioButton2.CheckedChanged, RadioButton3.CheckedChanged, RadioButton4.CheckedChanged, RadioButton5.CheckedChanged, _
                                                                                                         TextBoxFolderTimeStamp.TextChanged, TextBoxFileTimeStamp.TextChanged, _
                                                                                                         CheckBoxFolderTimeStamp.CheckedChanged, CheckBoxFileTimeStamp.CheckedChanged
        ' 基礎情報を設定
        If Not TabPageOther.Tag Is Nothing Then
            Dim ts As TabStatus = DirectCast(TabPageOther.Tag, TabStatus)
            ts.changed = True
        End If

        ' チェックボックス状態の変化により、他の要素の活性・非活性状態を変える
        Dim bCheked As Boolean

        ' フォルダからコマンドプロンプトを開く
        bCheked = CheckBoxFolderCmd.Checked
        LabelFolderCmd.Enabled = bCheked
        TextBoxFolderCmd.Enabled = bCheked
        If bCheked AndAlso TextBoxFolderCmd.Text = "" Then
            TextBoxFolderCmd.Text = mw.MJP("コマンドプロンプト", "Command Prompt")
        End If

        ' フォルダから管理者でコマンドプロンプトを開く
        bCheked = CheckBoxFolderCmdAdmin.Checked
        LabelFolderCmdAdmin.Enabled = bCheked
        TextBoxFolderCmdAdmin.Enabled = bCheked
        If bCheked AndAlso TextBoxFolderCmdAdmin.Text = "" Then
            TextBoxFolderCmdAdmin.Text = mw.MJP("管理者：コマンドプロンプト", "Command Prompt (as Administrator)")
        End If

        ' ファイルのタイムスタンプ変更
        bCheked = CheckBoxFileTimeStamp.Checked
        LabelFileTimeStamp.Enabled = bCheked
        TextBoxFileTimeStamp.Enabled = bCheked
        If bCheked AndAlso TextBoxFileTimeStamp.Text = "" Then
            TextBoxFileTimeStamp.Text = mw.MJP("ファイル日時の変更", "Change Timestamp")
        End If

        ' フォルダのタイムスタンプ変更
        bCheked = CheckBoxFolderTimeStamp.Checked
        LabelFolderTimeStamp.Enabled = bCheked
        TextBoxFolderTimeStamp.Enabled = bCheked
        If bCheked AndAlso TextBoxFolderTimeStamp.Text = "" Then
            TextBoxFolderTimeStamp.Text = mw.MJP("フォルダ日時の変更", "Change Timestamp")
        End If

    End Sub

    Public Enum ExitWindows
        EWX_LOGOFF = &H0
        EWX_SHUTDOWN = &H1
        EWX_REBOOT = &H2
        EWX_POWEROFF = &H8
        EWX_RESTARTAPPS = &H40
        EWX_FORCE = &H4
        EWX_FORCEIFHUNG = &H10
    End Enum

    Public Sub ButtonShutdown_Click(sender As System.Object, e As System.EventArgs) Handles ButtonShutdown.Click
        'シャットダウンする
        If MsgBox(mw.MJP("Windowsをシャットダウンしてもよろしいですか?", "Are you sure you want to shutdown?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            FormStartUp.AdjustToken()
            FormStartUp.ExitWindowsEx(ExitWindows.EWX_POWEROFF, 0)
            bCloseCheck = False
            Me.Close()
        End If
    End Sub

    Public Sub ButtonReboot_Click(sender As System.Object, e As System.EventArgs) Handles ButtonReboot.Click
        '再起動する
        If MsgBox(mw.MJP("Windowsを再起動してもよろしいですか?", "Are you sure you want to reboot?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            FormStartUp.AdjustToken()
            FormStartUp.ExitWindowsEx(ExitWindows.EWX_REBOOT, 0)
            bCloseCheck = False
            Me.Close()
        End If
    End Sub

    Public Sub ButtonLogoff_Click(sender As System.Object, e As System.EventArgs) Handles ButtonLogoff.Click
        'ログオフする()
        If MsgBox(mw.MJP("現在のユーザーからログオフしてもよろしいですか?", "Are you sure you want to log off?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            FormStartUp.AdjustToken()
            FormStartUp.ExitWindowsEx(ExitWindows.EWX_LOGOFF, 0)
            bCloseCheck = False
            Me.Close()
        End If
    End Sub

    Public Sub ButtonForceReboot_Click(sender As System.Object, e As System.EventArgs) Handles ButtonForceReboot.Click
        '強制再起動する
        If MsgBox(mw.MJP("Windowsを強制再起動してもよろしいですか?", "Are you sure you want to reboot force?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            FormStartUp.AdjustToken()
            FormStartUp.ExitWindowsEx(ExitWindows.EWX_REBOOT Or ExitWindows.EWX_FORCE, 0)
            bCloseCheck = False
            Me.Close()
        End If
    End Sub

    Private Sub ButtonShutdownLink_Click(sender As System.Object, e As System.EventArgs) Handles ButtonShutdownLink.Click
        'シャットダウンする
        If MsgBox(mw.MJP("Windowsをシャットダウンするショートカットをデスクトップに作成してもよろしいですか?", "Are you sure you want to craete a shortcut item to shutdown?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            CreateShortcut("/s", mw.MJP("Windowsをシャットダウン", "Shutdown"))
        End If
    End Sub

    Private Sub ButtonRebootLink_Click(sender As System.Object, e As System.EventArgs) Handles ButtonRebootLink.Click
        '再起動する
        If MsgBox(mw.MJP("Windowsを再起動するショートカットをデスクトップに作成してもよろしいですか?", "Are you sure you want to create a shortcut item to reboot?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            CreateShortcut("/r", mw.MJP("Windowsを再起動", "Reboot"))
        End If
    End Sub

    Private Sub ButtonLogoffLink_Click(sender As System.Object, e As System.EventArgs) Handles ButtonLogoffLink.Click
        'ログオフする()
        If MsgBox(mw.MJP("現在のユーザーからログオフするショートカットをデスクトップに作成してもよろしいですか?", "Are you sure you want to create a shortcut item to log off?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            CreateShortcut("/l", mw.MJP("現在のユーザーからログオフ", "Log off"))
        End If
    End Sub

    Private Sub ButtonForceRebootLink_Click(sender As System.Object, e As System.EventArgs) Handles ButtonForceRebootLink.Click
        '強制再起動する
        If MsgBox(mw.MJP("Windowsを強制再起動するショートカットをデスクトップに作成してもよろしいですか?", "Are you sure you want to create a shortcut item to reboot force?"), MsgBoxStyle.OkCancel Or MsgBoxStyle.Question, Me.Text) = MsgBoxResult.Ok Then
            CreateShortcut("/f", mw.MJP("Windowsを強制再起動", "Reboot Force"))
        End If
    End Sub

    Private Sub CreateShortcut(strCmdOption As String, strLinkName As String)
        Try
            '作成するショートカットのパス 
            Dim shortcutPath As String = System.IO.Path.Combine( _
                Environment.GetFolderPath(System.Environment.SpecialFolder.DesktopDirectory), _
                strLinkName + ".lnk")
            'ショートカットのリンク先 
            Dim targetPath As String = Application.ExecutablePath

            'WshShellを作成 
            Dim shell As New IWshRuntimeLibrary.WshShell()
            'ショートカットのパスを指定して、WshShortcutを作成 
            Dim shortcut As IWshRuntimeLibrary.IWshShortcut = _
                DirectCast(shell.CreateShortcut(shortcutPath),  _
                    IWshRuntimeLibrary.IWshShortcut)
            'リンク先 
            shortcut.TargetPath = targetPath
            'コマンドパラメータ 「リンク先」の後ろに付く 
            shortcut.Arguments = strCmdOption
            '作業フォルダ 
            shortcut.WorkingDirectory = Application.StartupPath
            'ショートカットキー（ホットキー） 
            shortcut.Hotkey = ""
            '実行時の大きさ 1が通常、3が最大化、7が最小化 
            shortcut.WindowStyle = 1
            'コメント 
            shortcut.Description = strLinkName + mw.MJP(" - いじくるLite", " - RnsfLite")
            'アイコンのパス 自分のEXEファイルのインデックス1のアイコン 
            shortcut.IconLocation = Application.ExecutablePath + ",1"

            'ショートカットを作成 
            shortcut.Save()

            '後始末
            System.Runtime.InteropServices.Marshal.FinalReleaseComObject(shortcut)
            System.Runtime.InteropServices.Marshal.FinalReleaseComObject(shell)

            MsgBox(mw.MJP(strLinkName + "するためのショートカットを作成しました。", "Create Shortcut has been completed."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Information, Me.Text)

        Catch ex As Exception
            MsgBox(mw.MJP(strLinkName + "するためのショートカットの作成に失敗しました - ", "Cannot create a shotcut item - ") + ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)

        End Try

    End Sub

End Class

Class TabStatus
    Public tab As System.Windows.Forms.TabPage
    Public lv As ListView
    Public hive As Microsoft.Win32.RegistryKey
    Public regsubkeyname As String
    Public changed As Boolean
End Class