﻿Public Class AddEditDialog

    Dim bCloseOk As Boolean = True

    Private Sub ButtonBrowse_Click(sender As System.Object, e As System.EventArgs) Handles ButtonBrowse.Click
        ' 「ファイルを開く」ダイアログを開く
        OpenFileDialog1.FileName = TextBoxCmdLine.Text
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            ' ファイルが選択された場合は、選択されたファイルのフルパスを入力ボックスへ入れる
            TextBoxCmdLine.Text = OpenFileDialog1.FileName
        End If
    End Sub

    Private Sub ButtonOK_Click(sender As System.Object, e As System.EventArgs) Handles ButtonOK.Click
        bCloseOk = True
        ' 入力検定

        If TextBoxName.Text = "" Then
            MsgBox(mw.MJP("「任意の名前」が空です。", "Please specify the item name."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation, Me.Text)
            bCloseOk = False
        ElseIf TextBoxCmdLine.Text = "" Then
            MsgBox(mw.MJP("「コマンドライン」が空です。", "Please specify the command line."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation, Me.Text)
            bCloseOk = False
        End If
    End Sub

    Private Sub ButtonCancel_Click(sender As System.Object, e As System.EventArgs) Handles ButtonCancel.Click
        ' キャンセルの場合は無条件でクローズ許可
        bCloseOk = True
    End Sub


    Private Sub AddEditDialog_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        ' OKを押した場合に条件が整わない場合は、フォームのクローズを許可しない
        If bCloseOk = False Then
            e.Cancel = True
        End If
    End Sub

    Private Sub TextBoxCmdLine_DragDrop(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles TextBoxCmdLine.DragDrop
        'コントロール内にドロップされたとき実行される
        'ドロップされたすべてのファイル名を取得する
        Dim fileName As String() = CType( _
            e.Data.GetData(DataFormats.FileDrop, False), _
            String())

        '入力ボックスへ設定
        TextBoxCmdLine.Text = fileName(0)

    End Sub

    Private Sub TextBoxCmdLine_DragEnter(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles TextBoxCmdLine.DragEnter
        ' ドラックを許可するかどうかを表示
        'コントロール内にドラッグされたとき実行される
        If e.Data.GetDataPresent(DataFormats.FileDrop) Then
            'ドラッグされたデータ形式を調べ、ファイルのときはコピーとする
            e.Effect = DragDropEffects.Copy
        Else
            'ファイル以外は受け付けない
            e.Effect = DragDropEffects.None
        End If
    End Sub

End Class