﻿Public Class ChangeTimeStamp

    Private strTargetName As String = Nothing    ' 日時変更するファイル名またはディレクトリ名
    Private bTypeDir As Boolean = False         ' strTargetName がファイルならFalse, フォルダならTrue
    Private bStopClose = False                  ' クローズしてはいけない場合True

    Public Sub setTargetName(strTargetName_ As String)
        strTargetName = strTargetName_
    End Sub

    Private Sub ChangeTimeStamp_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Try

            Dim dtCreateFileTime As Date
            Dim dtLastWriteTime As Date

            If strTargetName Is Nothing Then
                MsgBox(mw.MJP("日時を変更したいファイル名またはフォルダ名を指定して下さい。", "Please specify the file or folder name to change timestamp."), MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
                Me.Close()
                Return

            End If

            ' ファイル名またはフォルダ名を画面上へ設定
            TextBoxFileNames.Text = strTargetName

            If System.IO.File.Exists(strTargetName) Then
                ' 日時の変更対象はファイル
                bTypeDir = False

                ' 作成日時の取得
                dtCreateFileTime = System.IO.File.GetCreationTime(strTargetName)

                ' 最終更新日時（タイムスタンプ）の取得
                dtLastWriteTime = System.IO.File.GetLastWriteTime(strTargetName)

            ElseIf System.IO.Directory.Exists(strTargetName) Then
                ' 日時の変更対象はディレクトリ
                bTypeDir = True

                ' 作成日時の取得
                dtCreateFileTime = System.IO.Directory.GetCreationTime(strTargetName)

                ' 最終更新日時（タイムスタンプ）の取得
                dtLastWriteTime = System.IO.Directory.GetLastWriteTime(strTargetName)

                ' タイトルの変更
                Me.Text = mw.MJP("フォルダのタイムスタンプ変更", "Change Timestamp")
                LabelExplain.Text = mw.MJP("フォルダの各日時を変更します。", "Change Timestamp of the specified folder.")

                ' フォルダに対するチェックボックスを有効にする
                CheckBoxChangeTimeFiles.Enabled = True
                CheckBoxChangeTimeFolders.Enabled = True

            Else
                MsgBox(mw.MJP("指定されたファイル名またはフォルダ名は存在しません - ", "The file or folder not found. - ") + strTargetName, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
                Me.Close()
                Return

            End If

            ' 取得情報を画面へ表示
            ' 作成日時の取得
            dtpCreateFileTime.Value = dtCreateFileTime.AddMilliseconds(-dtCreateFileTime.Millisecond)
            nudCreateFileTime.Value = dtCreateFileTime.Millisecond
            ' 最終更新日時（タイムスタンプ）の取得
            dtpTimeStamp.Value = dtLastWriteTime.AddMilliseconds(-dtLastWriteTime.Millisecond)
            nudTimeStamp.Value = dtLastWriteTime.Millisecond

        Catch ex As Exception
            ' 予期せぬ例外
            MsgBox(ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
            Me.Close()
            Return

        End Try


    End Sub

    Private Sub ButtonCancel_Click(sender As System.Object, e As System.EventArgs) Handles ButtonCancel.Click
        ' 何もせずにダイアログをクローズ
        bStopClose = False
        Me.Close()
    End Sub


    Private Sub ButtonOK_Click(sender As System.Object, e As System.EventArgs) Handles ButtonOK.Click
        ' ファイルまたはディレクトリのタイムスタンプを変更
        Try
            Dim dtCreateFileTime As Date
            Dim dtLastWriteTime As Date

            ' 画面から作成日時の取得
            dtCreateFileTime = dtpCreateFileTime.Value.AddMilliseconds(nudCreateFileTime.Value)

            ' 画面から最終更新日時（タイムスタンプ）の取得
            dtLastWriteTime = dtpTimeStamp.Value.AddMilliseconds(nudTimeStamp.Value)

            If bTypeDir = False Then
                ' 日時の変更対象がファイルの場合
                System.IO.File.SetCreationTime(strTargetName, dtCreateFileTime)
                System.IO.File.SetLastWriteTime(strTargetName, dtLastWriteTime)

            Else
                ' 日時の変更対象がディレクトリの場合
                Try
                    System.IO.Directory.SetCreationTime(strTargetName, dtCreateFileTime)
                    System.IO.Directory.SetLastWriteTime(strTargetName, dtLastWriteTime)
                Catch ex As IO.IOException
                    ' 過去に開いたことがあるフォルダ？
                    MsgBox(mw.MJP("現在、このフォルダの日時を変更することはできません。このフォルダを開いている／開いたことのあるエクスプローラやプログラムを、いったん閉じて下さい - ", "Cannot Change Timestamp - ") + strTargetName, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
                    ' クローズしてはいけない
                    bStopClose = True
                    Return
                End Try

                ' このフォルダの配下にあるすべてのファイルの各日時も変更する
                If CheckBoxChangeTimeFiles.Checked Then
                    Dim files As String() = System.IO.Directory.GetFiles(strTargetName, "*", System.IO.SearchOption.AllDirectories)

                    For Each fname As String In files
                        Try
                            System.IO.File.SetCreationTime(fname, dtCreateFileTime)
                            System.IO.File.SetLastWriteTime(fname, dtLastWriteTime)
                        Catch ex As UnauthorizedAccessException
                            MsgBox(mw.MJP("アクセスできません - ", "Cannot Access - ") + fname, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
                        End Try
                    Next
                End If

                ' このフォルダの配下にあるすべてのサブフォルダの各日時も変更する
                If CheckBoxChangeTimeFolders.Checked Then
                    Dim subfolders As String() = System.IO.Directory.GetDirectories(strTargetName, "*", System.IO.SearchOption.AllDirectories)

                    For Each fname As String In subfolders
                        Try
                            System.IO.Directory.SetCreationTime(fname, dtCreateFileTime)
                            System.IO.Directory.SetLastWriteTime(fname, dtLastWriteTime)
                        Catch ex As IO.IOException
                            MsgBox(mw.MJP("現在、このフォルダの日時を変更することはできません。このフォルダを開いている／開いたことのあるエクスプローラやプログラムを、いったん閉じて下さい - ", "Cannot Change Timestamp - ") + fname, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
                        Catch ex As UnauthorizedAccessException
                            MsgBox(mw.MJP("アクセスできません - ", "Cannot Access - ") + fname, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
                        End Try
                    Next
                End If

            End If

            ' クローズして良い
            bStopClose = False
            Me.Close()

        Catch ex As IO.FileNotFoundException
            ' 指定したパスが見つからない
            MsgBox(mw.MJP("日時を変更しようとしたファイルまたはディレクトリが見つかりません - ", "The file or folder not found. -") + strTargetName, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
            ' クローズしてはいけない
            bStopClose = True

        Catch ex As ArgumentOutOfRangeException
            ' 指定したパスが見つからない
            MsgBox(mw.MJP("指定された日時が、設定可能範囲を超えています - ", "Out of range - Date/Time - ") + strTargetName, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
            ' クローズしてはいけない
            bStopClose = True

        Catch ex As UnauthorizedAccessException
            ' 指定したパスが見つからない
            MsgBox(mw.MJP("アクセスできません - ", "Cannot Access - ") + strTargetName, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
            ' クローズしてはいけない
            bStopClose = True

        Catch ex As Exception
            ' 予期せぬ例外
            MsgBox(ex.ToString, MsgBoxStyle.OkOnly Or MsgBoxStyle.Critical, Me.Text)
            ' クローズしてはいけない
            bStopClose = True

        End Try
    End Sub


    Private Sub ChangeTimeStamp_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        e.Cancel = bStopClose
    End Sub
End Class
