#include "stdafx.h"
#include "rnsf7.h"
#include "splash.h"

#define R7SWDL_TIMERID 13214

static HBITMAP hBitSplash;
static BYTE    splashAlpha;
static int     bx, by;
static DWORD   dwStartTime;

HWND      hSplashWnd;				// XvbVEBhẼnh

static LRESULT CALLBACK splashwindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch( message ) 
	{
		case WM_CREATE:
			if (splashAlpha != 255) {
				SetExl(hWnd, splashAlpha);
			}
			dwStartTime = GetTickCount();
			break;

		case WM_PAINT:
			{
				PAINTSTRUCT ps;
				HDC		  hdc, memdc;

				hdc = BeginPaint(hWnd, &ps);
				memdc = CreateCompatibleDC(hdc);
				SelectObject(memdc, hBitSplash);
				BitBlt(hdc, 0, 0, bx, by, memdc, 0, 0, SRCCOPY);
				DeleteDC(memdc);			
				EndPaint( hWnd, &ps );
			}
			break;

		case WM_TIMER: // XvbVEBhẺŁAOAṽbZ[W{bNXoĂƂ̎bIȑ΍ƂāANbNXvbVEBhE
			if ( wParam != R7SWDL_TIMERID ) {
				break;
			}
		case WM_LBUTTONUP:
		case WM_RBUTTONUP:
			KillTimer(hWnd, R7SWDL_TIMERID);
			DestroyWindow(hWnd);
			break;

		case WM_DESTROY:
			hSplashWnd = NULL;
			DeleteObject(hBitSplash);
			break;

		case R7SPL_DESTROY: // XvbVEBhEJĂ lParam ~bo߂ĂΑɕBłȂ wParam ~b҂Ă
			if ( GetTickCount() - dwStartTime < (DWORD)lParam ) {
				SetTimer(hWnd, R7SWDL_TIMERID, (DWORD)wParam, NULL);
			}
			else {
				DestroyWindow(hWnd);
			}
			break;

		default:
			return DefWindowProc( hWnd, message, wParam, lParam );
   }
   return 0;
}

HWND show_splash_window(const char *splash, BYTE alpha)
{
	WNDCLASSEX wcex;
	HWND hSplash;
	BITMAP bitmap;

	wcex.cbSize = sizeof(WNDCLASSEX); 
	wcex.style			= CS_NOCLOSE | CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)splashwindowProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInst;
	wcex.hIcon			= NULL;
	wcex.hCursor		= LoadCursor(NULL, IDC_WAIT);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= "Rnsf7Splash";
	wcex.hIconSm		= NULL;
	RegisterClassEx( &wcex );

	if (NULL == (hBitSplash = (HBITMAP)LoadImage(NULL, splash, IMAGE_BITMAP, 0, 0, LR_DEFAULTSIZE | LR_LOADFROMFILE))) {
		return NULL;
	}

	GetObject(hBitSplash, sizeof(BITMAP), &bitmap);
	splashAlpha = alpha;
	bx = bitmap.bmWidth;
	by = bitmap.bmHeight;

	hSplash = CreateWindowEx(WS_EX_TOPMOST | WS_EX_TOOLWINDOW, "Rnsf7Splash", "Rnsf7Splash", WS_POPUP | WS_BORDER, (GetSystemMetrics(SM_CXFULLSCREEN)-bx)/2, (GetSystemMetrics(SM_CYFULLSCREEN)-by)/2, bx, by, NULL, NULL, hInst, NULL);
	if ( hSplash ) {
		ShowWindow( hSplash, SW_SHOW );
		UpdateWindow( hSplash );
	}

	return hSplash;
}

void destroy_splash_window( void )
{
	if ( hSplashWnd && IsWindow(hSplashWnd) ) {
		DestroyWindow( hSplashWnd );
	}
}

// hSplashWnd ܂JĂA(1000msJĂ鎞ԂZA500ms\)
void fout_splash_window( void )
{
	if ( hSplashWnd && IsWindow(hSplashWnd) ) {
		SendMessage(hSplashWnd, R7SPL_DESTROY, (WPARAM)500, (LPARAM)1000);
		hSplashWnd = NULL;
	}
}
