#include "stdafx.h"
#include "RNSF7.h"
#include "regopendlg.h"
#include "commfunc.h"
#include "MainListview.h"

using namespace std;
using namespace boost;

static const char *regOpenKeyDlg_pszRegKey;

void regOpenKeyDlg(HWND hWnd, const char *pszRegKey, BOOL bFast)
{
	regOpenKeyDlg_pszRegKey = pszRegKey;
	DialogBoxParam(hInst, (LPCTSTR)IDD_REGOPENKEY, hWnd, (DLGPROC)regOpenKeyDlgProc, (LPARAM)bFast);
}

const wchar_t *hivekeyconv[] = {
	L"HKCR\\\\", L"HKEY_CLASSES_ROOT\\\\",
	L"HKCU\\\\", L"HKEY_CURRENT_USER\\\\",
	L"HKLM\\\\", L"HKEY_LOCAL_MACHINE\\\\",
	L"HKCC\\\\", L"HKEY_CURRENT_CONFIG\\\\",
	L"HKDD\\\\", L"HKEY_DYN_DATA\\\\",
	L"HKPD\\\\", L"HKEY_PERFORMANCE_DATA\\\\",
	L"HKPT\\\\", L"HKEY_PERFORMANCE_TEXT\\\\",
	L"HKPN\\\\", L"HKEY_PERFORMANCE_NLSTEXT\\\\",
	0, 0};

const wchar_t *z2h[] = {
	L"`", L"A",
	L"a", L"B",
	L"b", L"C",
	L"c", L"D",
	L"d", L"E",
	L"e", L"F",
	L"f", L"G",
	L"g", L"H",
	L"h", L"I",
	L"i", L"J",
	L"j", L"K",
	L"k", L"L",
	L"l", L"M",
	L"m", L"N",
	L"n", L"O",
	L"o", L"P",
	L"p", L"Q",
	L"q", L"R",
	L"r", L"S",
	L"s", L"T",
	L"t", L"U",
	L"u", L"V",
	L"v", L"W",
	L"w", L"X",
	L"x", L"Y",
	L"y", L"Z",
	L"", L"a",
	L"", L"b",
	L"", L"c",
	L"", L"d",
	L"", L"e",
	L"", L"f",
	L"", L"g",
	L"", L"h",
	L"", L"i",
	L"", L"j",
	L"", L"k",
	L"", L"l",
	L"", L"m",
	L"", L"n",
	L"", L"o",
	L"", L"p",
	L"", L"q",
	L"", L"r",
	L"", L"s",
	L"", L"t",
	L"", L"u",
	L"", L"v",
	L"", L"w",
	L"", L"x",
	L"", L"y",
	L"", L"z",
	L"O", L"0",
	L"P", L"1",
	L"Q", L"2",
	L"R", L"3",
	L"S", L"4",
	L"T", L"5",
	L"U", L"6",
	L"V", L"7",
	L"W", L"8",
	L"X", L"9",
	L"I", L"!",
	L"h", L"\"",
	L"", L"#",
	L"", L"$",
	L"", L"%",
	L"", L"&",
	L"f", L"'",
	L"i", L"(",
	L"j", L")",
	L"", L"=",
	L"[", L"-",
	L"`", L"~",
	L"O", L"^",
	L"b", L"|",
	L"", L"\\",
	L"", L"@",
	L"m", L"[",
	L"o", L"{",
	L"G", L";",
	L"{", L"+",
	L"F", L":",
	L"", L"*",
	L"n", L"]",
	L"p", L"}",
	L"C", L",",
	L"", L"<",
	L"D", L".",
	L"", L">",
	L"^", L"/",
	L"H", L"?",
	L"Q", L"_",
	L"@", L" ",
	L"", L" ",
	0, 0};

bool translateKey(HWND hDlg, const char *pszBefore)
{
	// ϊ̂߂ɁA܂SJISUnicode֕ϊB܂𓾂
	int len_vwb = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, pszBefore, -1, NULL, 0);
	if (len_vwb == 0) {
		return false;
	}

	// mۂAUnicodeϊ
	vector<wchar_t> vw_str;		// ϊO(Unicode)

	++len_vwb;
	vw_str.resize(len_vwb);
	if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, pszBefore, -1, &vw_str[0], len_vwb) ) {
		return false;
	}

	// ϊOAwidechar ϐ֑
	wstring w_str = &vw_str[0];

	// WIȐK\T[`EŜPsƂẼ}b`T
	regex_constants::match_flag_type flags = regex_constants::match_default |
											 regex_constants::match_single_line |
											 regex_constants::match_any;

	if (SendDlgItemMessage(hDlg, IDC_CHECK_ARROWEN, BM_GETCHECK, 0, 0) == BST_CHECKED) {
		//   \ ɕϊ
		wregex wre(L"", wregex::normal);
		w_str = regex_replace(w_str, wre, L"\\", flags);
	}
	if (SendDlgItemMessage(hDlg, IDC_CHECK_ZEN2HAN, BM_GETCHECK, 0, 0) == BST_CHECKED) {
		// SpiAt@xbgEELj𔼊pɕϊ
		for(int i=0 ; z2h[i] ; i+=2) {
			wregex wre(z2h[i], wregex::normal);
			w_str = regex_replace(w_str, wre, z2h[i+1], flags);
		}
	}
	if (SendDlgItemMessage(hDlg, IDC_CHECK_SPENSP, BM_GETCHECK, 0, 0) == BST_CHECKED) {
		// \  \ ɕϊ
		wregex wre(L" \\\\ ", wregex::normal);
		w_str = regex_replace(w_str, wre, L"\\", flags);
	}
	if (SendDlgItemMessage(hDlg, IDC_CHECK_ENEN, BM_GETCHECK, 0, 0) == BST_CHECKED) {
		// \\  \ ɕϊ
		wregex wre(L"\\\\\\\\", wregex::normal);
		w_str = regex_replace(w_str, wre, L"\\", flags);
	}
	if (SendDlgItemMessage(hDlg, IDC_CHECK_SPENSP, BM_GETCHECK, 0, 0) == BST_CHECKED) {
		// \  \ ɕϊ(P)
		wregex wre(L" \\\\ ", wregex::normal);
		w_str = regex_replace(w_str, wre, L"\\", flags);
	}
	if (SendDlgItemMessage(hDlg, IDC_CHECK_ENEN, BM_GETCHECK, 0, 0) == BST_CHECKED) {
		// \\  \ ɕϊ(P)
		wregex wre(L"\\\\\\\\", wregex::normal);
		w_str = regex_replace(w_str, wre, L"\\", flags);
	}
	if (SendDlgItemMessage(hDlg, IDC_CHECK_HIVE, BM_GETCHECK, 0, 0) == BST_CHECKED) {
		// nCû𐳎̂ɕϊ
		for(int i=0 ; hivekeyconv[i] ; i+=2) {
			wregex wre(hivekeyconv[i], wregex::normal);
			w_str = regex_replace(w_str, wre, hivekeyconv[i+1], flags);
		}
	}
#if _MSC_VER < 1500
#ifndef _WIN64
	// Windows Meł́Au}C Rs[^\vt
	if (winver < 500) {
		w_str.insert(0, L"}C Rs[^\\");
	}
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
	int len_wca = WideCharToMultiByte(GetACP(), 0, w_str.c_str(), -1, NULL, 0, NULL, NULL);
	if ( len_wca == 0 ) {
		return false;
	}
	++len_wca;

	vector<char>    vc_str;		// ϊ(SJIS)

	vc_str.resize(len_wca);
	if ( 0 == WideCharToMultiByte(GetACP(), 0, w_str.c_str(), -1, &vc_str[0], len_wca, NULL, NULL) ) {
		return NULL;
	}

	SetDlgItemText(hDlg, IDC_EDIT_REGKEY_AFTER, &vc_str[0]);

	return true;
}

// c[`bv
const struct DEFTOOLTIP rod_deftooltip[] = {
	{IDC_COMBO_REGKEY_BEFORE,"JWXg L[w肵܂BWebTCgL[Rs[y[Xg邱Ƃz肵Ă܂B"},
	{IDC_CHECK_ZEN2HAN,      "̓͗ɓ͂ꂽSp(At@xbgEEL)Apɕϊ܂B"},
	{IDC_CHECK_SPENSP,       "\\ ̑OオpXy[X1ň͂܂Ă悤ȏꍇɁApXy[X菜܂B"},
	{IDC_CHECK_ENEN,         "C̃vÕ\[XR[h \\ 2d˂Ă悤ȏꍇɁA\\ 1ɂ܂B"},
	{IDC_CHECK_ARROWEN,      "WXgWeby[Wɂ悤ȁAL[̋؂ '' pĂ悤ȏꍇɁA'\\' ɕϊ܂B"},
	{IDC_CHECK_HIVE,         "nCû̗𐳎̂ɕϊ܂B(HKCUHKEY_CURRENT_USER, HKLMHKEY_LOCAL_MACHINE)"},
	{IDOK,                   "ϊ̃WXgL[ŕ\Ă郌WXgL[AWXg GfB^ŊJ܂B"},
	{IDCANCEL,               "ɂ̃_CAO܂B"},
	{IDHELP,				 "̃_CAOɊւwv\܂B"},
	{0,0}};

// _CAÕAJ[Ɋւ
const DLGITEM dlgitems[] = {
	{IDC_COMBO_REGKEY_BEFORE,ANCHOR_TOPLEFTRIGHT},
	{IDC_EDIT_REGKEY_AFTER,  ANCHOR_BOTTOMLEFTRIGHT},
	{IDOK,                   ANCHOR_BOTTOMRIGHT},
	{IDCANCEL,               ANCHOR_BOTTOMRIGHT},
	{IDHELP,	             ANCHOR_BOTTOMRIGHT},
	{0,0}
};

INT_PTR CALLBACK regOpenKeyDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static SIZEDLG *sizedlg;
	static ComboboxQueue *cbq;
	static HICON hDlgIcon;

	switch (message) {
		case WM_INITDIALOG:
			{
				// ACR̐ݒ
				if (0 != ExtractIconEx("REGEDIT.EXE", 0, NULL, &hDlgIcon, 1)) {
					SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)hDlgIcon);
				}

				// c[`bv̐ݒ
				CreateToolTip(hInst, hDlg, rod_deftooltip);

				// _CAÕRg[̃AJ[o^
				sizedlg = new SIZEDLG(hDlg, dlgitems);
				sizedlg->SetMinMaxInfo(sizedlg->GetDefWidth(), sizedlg->GetDefHeight(), -1, sizedlg->GetDefHeight());

				// WXgݒǂݏo
				REG reg;
				if (reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_READONLY)) {
					// Sppϊ
					if (reg.ReadInteger("RegOpenKeyDlg_Zen2Han", 1) != 0) {
						SendDlgItemMessage(hDlg, IDC_CHECK_ZEN2HAN, BM_SETCHECK, BST_CHECKED, NULL);
					}
					// \  \ ɕϊ
					if (reg.ReadInteger("RegOpenKeyDlg_SpEnSp", 0) != 0) {
						SendDlgItemMessage(hDlg, IDC_CHECK_SPENSP, BM_SETCHECK, BST_CHECKED, NULL);
					}
					// \\  \ ɕϊ
					if (reg.ReadInteger("RegOpenKeyDlg_EnEn", 0) != 0) {
						SendDlgItemMessage(hDlg, IDC_CHECK_ENEN, BM_SETCHECK, BST_CHECKED, NULL);
					}
					//   \ ɕϊ
					if (reg.ReadInteger("RegOpenKeyDlg_ArrowEn", 0) != 0) {
						SendDlgItemMessage(hDlg, IDC_CHECK_ARROWEN, BM_SETCHECK, BST_CHECKED, NULL);
					}
					// Hivê𐳎̂ɕϊ
					if (reg.ReadInteger("RegOpenKeyDlg_Hive", 0) != 0) {
						SendDlgItemMessage(hDlg, IDC_CHECK_HIVE, BM_SETCHECK, BST_CHECKED, NULL);
					}
					reg.CloseKey();
				}

				char *pstr = NULL;
				if (regOpenKeyDlg_pszRegKey) {
					// w肳ꂽL[ftHglƂč̗p
					pstr = new_strcpy(regOpenKeyDlg_pszRegKey);
				}
				else {
					// WXgftHgiLastKeyjl̎擾
					if (reg.OpenKey(HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Regedit", TREG_OPEN_READONLY)) {
						pstr = reg.new_ReadString("LastKey");
						reg.CloseKey();
					}
				}

				if (pstr && pstr[0]) {
					char *phead = strstr(pstr, "HKEY_");
					if (phead) { // u}CRs[^vŎn܂ĂA菜
						SetDlgItemText(hDlg, IDC_COMBO_REGKEY_BEFORE, phead);
					}
					else {
						SetDlgItemText(hDlg, IDC_COMBO_REGKEY_BEFORE, pstr);
					}

					// ϊs
					if (false == translateKey(hDlg, phead ? phead : pstr)) {
						MessageBox(hDlg, "ϊɃG[܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
					}
				}
				safedelete(pstr);

				// tH[JX͓̓{bNX
				SetFocus(GetDlgItem(hDlg, IDC_COMBO_REGKEY_BEFORE));

				// R{{bNX̃Xg
				cbq = new ComboboxQueue();
				cbq->Init(hDlg, IDC_COMBO_REGKEY_BEFORE, 16, HKEY_CURRENT_USER, RNSF7REGKEY, "regopendlg_combo");
			}
			if ((BOOL)lParam == TRUE) {
				SendMessage(hDlg, WM_COMMAND, MAKEWPARAM(IDOK, 0), 0);
			}
			return (INT_PTR)FALSE;
				
		case WM_HELP: // wv̌Ăяo
			callhelp2(hDlg, "HLP000020.html");
			return (INT_PTR)TRUE;

		case WM_GETMINMAXINFO:
			// _CAO̍ŏTCY߂
			sizedlg->GetMinMaxInfo(lParam);
			return (INT_PTR)TRUE;

		case WM_SIZE:
			// TCY
			sizedlg->Resize(1);
			return (INT_PTR)TRUE;

		case WM_DESTROY:
			// R{{bNX̏j
			delete cbq;
			cbq = NULL;

			// TCŶ߂̏j
			delete sizedlg;
			sizedlg = NULL;

			// _CAOACR̔j
			if (hDlgIcon != NULL) {
				SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, 0);
				DestroyIcon(hDlgIcon);
				hDlgIcon = NULL;
			}
			return (INT_PTR)TRUE;

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_COMBO_REGKEY_BEFORE:
					if (HIWORD(wParam) == CBN_EDITCHANGE) {
						// ҏW{bNXҏWꂽ
					}
					else if (HIWORD(wParam) == CBN_SELCHANGE) {
						// R{{bNXŃXgI΂ꂽꍇ
						HWND hCombo = (HWND)lParam;

						// ϊOWXgL[擾(SJIS)B܂͒vZB
						int iCur = (int)SendMessage(hCombo, CB_GETCURSEL, 0, 0);
						int len_vcb = (int)SendMessage(hCombo, CB_GETLBTEXTLEN, (WPARAM)iCur, 0);
						if (len_vcb == 0) {
							// 񂪓͂ĂȂꍇ
							SetDlgItemText(hDlg, IDC_EDIT_REGKEY_AFTER, "");
							return (INT_PTR)TRUE;
						}

						// mۂAϊOWXgL[擾(SJIS)
						++len_vcb;
						char *pbuf = (char *)calloc(len_vcb, sizeof(char));
						if (pbuf == NULL) {
							MessageBox(hDlg, "L[߂̃܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
							return (INT_PTR)TRUE;
						}

						SendMessage(hCombo, CB_GETLBTEXT, (WPARAM)iCur, (LPARAM)pbuf);
						if (false == translateKey(hDlg, pbuf)) {
							MessageBox(hDlg, "ϊɃG[܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
						}
						safefree(pbuf);

						return (INT_PTR)TRUE;
					}
					else {
						return (INT_PTR)TRUE; // ҏWł͂Ȃ
					}
				case IDC_CHECK_ZEN2HAN: // Sppϊ
				case IDC_CHECK_SPENSP:  // \  \ ɕϊ
				case IDC_CHECK_ENEN:    // \\  \ ɕϊ
				case IDC_CHECK_ARROWEN: //   \ ɕϊ
				case IDC_CHECK_HIVE:    // Hivê𐳎̂ɕϊ
					// ϊs
					{
						// ϊOWXgL[擾(SJIS)B܂͒vZB
						int len_vcb = GetWindowTextLength(GetDlgItem(hDlg, IDC_COMBO_REGKEY_BEFORE));
						if (len_vcb == 0) {
							// 񂪓͂ĂȂꍇ
							SetDlgItemText(hDlg, IDC_EDIT_REGKEY_AFTER, "");
							return (INT_PTR)TRUE;
						}

						// mۂAϊOWXgL[擾(SJIS)
						++len_vcb;
						char *pbuf = (char *)calloc(len_vcb, sizeof(char));
						if (pbuf == NULL) {
							MessageBox(hDlg, "L[߂̃܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
							return (INT_PTR)TRUE;
						}

						GetDlgItemText(hDlg, IDC_COMBO_REGKEY_BEFORE, pbuf, len_vcb);
						if (false == translateKey(hDlg, pbuf)) {
							MessageBox(hDlg, "ϊɃG[܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
						}
						safefree(pbuf);
					}
					return (INT_PTR)TRUE;

				case IDHELP:
					callhelp2(hDlg, "HLP000020.html");
					return TRUE;

				case IDOK: // WXgGfB^J
					{
						// R{{bNX̓eL^
						int len = GetWindowTextLength(GetDlgItem(hDlg, IDC_COMBO_REGKEY_BEFORE));
						if (len > 0) {
							char *pbuf = (char *)calloc(len+1, sizeof(char));
							if (pbuf == NULL) {
								MessageBox(hDlg, "L[߂̃܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
								return (INT_PTR)TRUE;
							}
							GetDlgItemText(hDlg, IDC_COMBO_REGKEY_BEFORE, pbuf, len+1);
							cbq->Add(pbuf);
							free(pbuf);
						}
						
						// ΏۃWXgiϊj̎擾
						REG reg;
						if (reg.OpenKey(HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Regedit", TREG_OPEN_CREATE)) {
							BOOL bRes = reg.WriteStringFromEditbox("LastKey", hDlg, IDC_EDIT_REGKEY_AFTER, TREG_NORMAL_SZ);
							reg.CloseKey();

							if (bRes == FALSE) {
								MessageBox(hDlg, "L[߂̃܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
								return (INT_PTR)TRUE;
							}
						}
						else {
							dispErrorMessage(hDlg, MB_OK | MB_ICONSTOP, "L[w肵ăWXg GfB^J",
								             "WXgL['HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Regedit'݃ANZXŊJƂăG[ɂȂ܂BL[w肷邽߂̃WXgL[JȂ߁A𒆎~܂B\nAPI񍐂F", getLastErrorString(tRegGetLastError()), NULL, NULL, NULL, NULL);
							return (INT_PTR)TRUE;
						}
					}
					if ((HINSTANCE)32 >= ShellExecute(hDlg, "open", "regedit.exe", "-m", NULL, SW_SHOWNORMAL)) {
						MessageBox(hDlg, "uWXg GfB^v̋NɎs܂B", "L[w肵ăWXg GfB^J", MB_OK | MB_ICONSTOP);
					}
					// ̂܂܉
				case IDCANCEL:	// ̃_CAO
					{
						REG reg;
						if (reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_CREATE)) {
							// WXg֐ݒۑ
							reg.WriteInteger("RegOpenKeyDlg_Zen2Han", (int)SendDlgItemMessage(hDlg, IDC_CHECK_ZEN2HAN, BM_GETCHECK, 0, NULL)); // Sppϊ
							reg.WriteInteger("RegOpenKeyDlg_SpEnSp",  (int)SendDlgItemMessage(hDlg, IDC_CHECK_SPENSP,  BM_GETCHECK, 0, NULL)); // \  \ ɕϊ
							reg.WriteInteger("RegOpenKeyDlg_EnEn",    (int)SendDlgItemMessage(hDlg, IDC_CHECK_ENEN,    BM_GETCHECK, 0, NULL)); // \\  \ ɕϊ
							reg.WriteInteger("RegOpenKeyDlg_ArrowEn", (int)SendDlgItemMessage(hDlg, IDC_CHECK_ARROWEN, BM_GETCHECK, 0, NULL)); //   \ ɕϊ
							reg.WriteInteger("RegOpenKeyDlg_Hive",    (int)SendDlgItemMessage(hDlg, IDC_CHECK_HIVE,    BM_GETCHECK, 0, NULL)); // Hivê𐳎̂ɕϊ
							reg.CloseKey();
						}
						else {
							dispErrorMessage(hDlg, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[", "WXgL['HKEY_CURRENT_USER\\", RNSF7REGKEY,
											 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F", getLastErrorString(tRegGetLastError()), NULL, NULL);
						}

						EndDialog(hDlg, LOWORD(wParam));
					}
					return (INT_PTR)TRUE;
			}
			break;
	}
	return (INT_PTR)FALSE;
}
