#include "stdafx.h"
#include "RNSF7.h"
#include "kwd_search.h"
#include "kwd_treectrl.h"
#include "commfunc.h"
#include "OpenSetting.h"
#include "MainListview.h"

#define TIMERID		3155
#define TIMERWAIT	700

// c[r[ɍڂǉ(nLevel12̂ݎw\炵)
// (܂ŏ hwndTV = NULL ɂČĂяo)
HTREEITEM AddItemToTree(HWND hwndTV, LPSTR lpszItem, int nLevel, int id)
{
	TVITEM tvi;
	TVINSERTSTRUCT tvins;
	static HTREEITEM hPrev = (HTREEITEM)TVI_FIRST;
	static HTREEITEM hPrevRootItem = NULL;
	static HTREEITEM hPrevLev2Item = NULL;

	if (hwndTV == NULL) { // tvins.hInsertAfterɓ邽߂̃f[^
		hPrevRootItem = hPrevLev2Item = NULL;
        return hPrev = (HTREEITEM)TVI_FIRST;
	}

	// TVINSERTSTRUCT\̒́Agp郁o߂Ă
	tvi.mask = TVIF_TEXT | TVIF_PARAM;

	// eLXgݒ
	tvi.pszText = lpszItem;
	tvi.cchTextMax = lstrlen(lpszItem);

	// Cӂ̃f[^ݒ
	tvi.lParam = (LPARAM)id;

	tvins.item = tvi;
	tvins.hInsertAfter = hPrev;

	// etH_ƂȂf[^ݒiAxQ܂łΉĂȂ悤j
	if ( nLevel == 1 )
		tvins.hParent = TVI_ROOT;
	else if ( nLevel == 2 )
		tvins.hParent = hPrevRootItem;
	else
		tvins.hParent = hPrevLev2Item;

	// ACeǉ(SendMessage)
	hPrev = (HTREEITEM)SendMessage(hwndTV, TVM_INSERTITEM, 0, (LPARAM)&tvins);

	// ǉ̂߂Ƀnhۑ
	if ( nLevel == 1 )
		hPrevRootItem = hPrev;
	else if ( nLevel == 2 )
		hPrevLev2Item = hPrev;

	return hPrev;
}

typedef struct {
	HTREEITEM	hParentItem;
	string      group;
	HTREEITEM	hLastItem;
} TVGROUPS;

vector<TVGROUPS> tvg;

// œo^sĂc̃nhԂ
HTREEITEM AddRootItemToTree(HWND hwndTV, LPTSTR pszRootName)
{
	TVINSERTSTRUCT tvins;

	// c[r[̃O[vɊւSNA
	tvg.clear();
	tvg.reserve(RSCSTD);

	// [gɃACe}邽߂̏쐬
	tvins.hInsertAfter = (HTREEITEM)TVI_FIRST;
	tvins.hParent = TVI_ROOT;
	tvins.item.mask = TVIF_TEXT | TVIF_PARAM;
	tvins.item.pszText = pszRootName;
	tvins.item.lParam = (LPARAM)NULL;

	return (HTREEITEM)SendMessage(hwndTV, TVM_INSERTITEM, 0, (LPARAM)&tvins);
}

// ŋ@\ږ̒ǉsĂȂǂ𒲂ׂ
TVGROUPS *RegistOrSearchGroup(HWND hwndTV, HTREEITEM hRoot, const string &group)
{
	vector<TVGROUPS>::iterator iter;
	HTREEITEM hTreeItemAfter = (HTREEITEM)TVI_FIRST;

	for(iter=tvg.begin() ; iter!=tvg.end() ; ++iter) {
		if (iter->group.compare(group) == 0) {
			// œo^sĂc̃nhԂ
			return &iter[0];
		}
		hTreeItemAfter = iter->hParentItem;
	}

	// œo^sĂȂcV@\ږ쐬ĕԂ
	TVINSERTSTRUCT tvins;
	TVGROUPS       tvg0;

	tvins.hInsertAfter = hTreeItemAfter;
	tvins.hParent = hRoot;
	tvins.item.mask = TVIF_TEXT | TVIF_PARAM;
	tvins.item.pszText = (LPTSTR)group.c_str();
	tvins.item.lParam = (LPARAM)NULL;

	tvg0.hParentItem  = (HTREEITEM)SendMessage(hwndTV, TVM_INSERTITEM, 0, (LPARAM)&tvins);
	tvg0.group        = group;
	tvg0.hLastItem    = (HTREEITEM)TVI_FIRST;
	tvg.push_back(tvg0);

	return &(tvg.back());
}

bool AddItem(HWND hwndTV, HTREEITEM hRoot, const ITEMGROUP *ig)
{
	if(ig == NULL) {
		MessageBox(NULL, "G[FigNULLłB", "AddItem", MB_OK | MB_ICONSTOP);
		return false;
	}

	// ig->pszGroupNameo^̋@\ڂ̏ꍇ́Ao^s
	TVGROUPS *tvg1 = RegistOrSearchGroup(hwndTV, hRoot, ig->group);
	TVINSERTSTRUCT tvins;

	// tvg1.hParentItem̉ɁAig->pszTitle o^B
	tvins.hInsertAfter = tvg1->hLastItem;
	tvins.hParent = tvg1->hParentItem;
	tvins.item.mask = TVIF_TEXT | TVIF_PARAM;
	tvins.item.lParam = (LPARAM)ig;

	// ^CgɈHv
	string title;
	if (!(ig->bOS & btOSMask)) {
		title.append("(gps)");
	}
	title.append(ig->item);
	tvins.item.pszText = (LPSTR)(title.c_str());

	tvg1->hLastItem = (HTREEITEM)SendMessage(hwndTV, TVM_INSERTITEM, 0, (LPARAM)&tvins);

	return true;
}

void ExpandItems(HWND hwndTV)
{
	vector<TVGROUPS>::iterator iter;

	for(iter=tvg.begin() ; iter!=tvg.end() ; ++iter) {
		TreeView_Expand( hwndTV, iter->hParentItem, TVE_EXPAND );
	}
}

// c[`bv
const struct DEFTOOLTIP r8deftooltip[] = {
	{IDC_CHECK_ALWAYS_FIND,"{^ȂĂAŌ͂̕炵΂炭o߂猟Jn悤ɂ܂B"},
	{IDC_EDIT_SEARCH,      "w肵܂B"},
	{IDC_BUTTON_SEARCH,    "JnÃc[Kvȋ@\̍i荞݂s܂B"},
	{IDC_CHECK_SHOW_ENABLE_ONLY, "̊Ŏgp\Ǝv@\݂̂\܂B"},
	{IDC_BUTTON_STARTEDIT, "őIҏWڂ̕ҏWJn܂B"},
	{0,0}};

// _CAÕAJ[Ɋւ
const DLGITEM dlgitems[] = {
	{IDC_CHECK_ALWAYS_FIND,     ANCHOR_TOPRIGHT},
	{IDC_EDIT_SEARCH,           ANCHOR_TOPLEFTRIGHT},
	{IDC_BUTTON_SEARCH,         ANCHOR_TOPRIGHT},
	{IDC_CHECK_SHOW_ENABLE_ONLY,ANCHOR_TOPLEFT},
	{IDC_TREE1,                 ANCHOR_CENTER},
	{IDC_STATIC_TITLE,          ANCHOR_BOTTOMLEFTRIGHT},
	{IDC_EDIT_MESSAGE,          ANCHOR_BOTTOMLEFTRIGHT},
	{IDC_BUTTON_STARTEDIT,      ANCHOR_BOTTOMRIGHT},
	{0,0}
};

// L[[h_CAÕbZ[Wnh
INT_PTR CALLBACK MainKwdSearchDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static SIZEDLG *sizedlg;
	static ComboboxQueue *cbq;

	switch (message) {
		case WM_INITDIALOG:
			{
				// ACR̐ݒ
				HICON hIcon = (HICON)LoadImage(hInst, (LPCTSTR)IDI_FOLDER_BROWSE, IMAGE_ICON, 16, 16, LR_SHARED);
				SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)hIcon);

				// c[`bv̐ݒ
				CreateToolTip(hInst, hDlg, r8deftooltip);

				// _CAÕRg[̃AJ[o^
				sizedlg = new SIZEDLG(hDlg, dlgitems);

				// WXgݒǂݏo
				REG reg;
				if (reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_READONLY)) {
					// gp\Ȃ̂̂ݕ\
					if (reg.ReadInteger("SearchDlg_EnableOnly", 1) != 0) {
						SendDlgItemMessage(hDlg, IDC_CHECK_SHOW_ENABLE_ONLY, BM_SETCHECK, BST_CHECKED, NULL);
					}
					// {^ȂĂJn
					if (reg.ReadInteger("SearchDlg_AlwaysFind", 0) != 0) {
						SendDlgItemMessage(hDlg, IDC_CHECK_ALWAYS_FIND, BM_SETCHECK, BST_CHECKED, NULL);
						// {^͔񊈐
						EnableWindow(GetDlgItem(hDlg, IDC_BUTTON_SEARCH), FALSE);
					}

					if ( rnsf7RegRead("NoSaveSettings", 0) == 0 ) {
						// _CAÖʒuƃTCY
						WINDOWPLACEMENT wp;
						ZeroMemory(&wp, sizeof(wp));
						wp.length = sizeof(WINDOWPLACEMENT);
						if (1 == reg.ReadInteger("SearchDlg_Max")) {
							wp.showCmd = SW_SHOWMAXIMIZED;
						}
						else {
							wp.showCmd = SW_SHOWNORMAL;
						}

						wp.rcNormalPosition.left   = reg.ReadInteger("SearchDlg_wLeft");
						wp.rcNormalPosition.top    = reg.ReadInteger("SearchDlg_wTop");
						wp.rcNormalPosition.right  = reg.ReadInteger("SearchDlg_wWidth") + wp.rcNormalPosition.left;
						wp.rcNormalPosition.bottom = reg.ReadInteger("SearchDlg_wHeight") + wp.rcNormalPosition.top;

						// EBhE̍WʊOȂAEBhEʒuftHg̈ʒuɂ
						POINT pt = {wp.rcNormalPosition.left, wp.rcNormalPosition.top};
						if (NULL != MonitorFromPoint(pt, MONITOR_DEFAULTTONULL)) {
							SetWindowPlacement(hDlg, &wp);
						}
					}
					reg.CloseKey();
				}

				// p̍쐬
				if (readySearch(hDlg) == false) {
					EndDialog(hDlg, 0);
					return TRUE;
				}

				// c[r[̍ŏ̏
				startSearch(hDlg);

				// tH[JX͌{bNX
				SetFocus(GetDlgItem(hDlg, IDC_EDIT_SEARCH));

				// R{{bNX̃Xg
				cbq = new ComboboxQueue();
				cbq->Init(hDlg, IDC_EDIT_SEARCH, 16, HKEY_CURRENT_USER, RNSF7REGKEY, "kwdsearch_combo");
			}
			return (INT_PTR)FALSE;
				
		case WM_HELP: // wv̌Ăяo
			callhelp2(hDlg, "HLP000002.html");
			return TRUE;

		case WM_GETMINMAXINFO:
			// _CAO̍ŏTCY߂
			sizedlg->GetMinMaxInfo(lParam);
			return TRUE;

		case WM_SIZE:
			// TCY
			sizedlg->Resize(1);
			return TRUE;

		case WM_DESTROY:
			// R{{bNX̏j
			delete cbq;
			cbq = NULL;

			// TCŶ߂̏j
			delete sizedlg;
			sizedlg = NULL;

			// T[`p̏j
			// freeSearchData();  // j͂AƂĂB
			return TRUE;

		case WM_TIMER:
			if (wParam == (WPARAM)TIMERID) {
				startSearch(hDlg);
				KillTimer(hDlg, TIMERID);
			}
			return (INT_PTR)TRUE;

		case WM_NOTIFY:
			// c[r[̒ʒmbZ[W󂯎
			if (wParam == (WPARAM)IDC_TREE1) {
				LPNMTREEVIEW pnmtv = (LPNMTREEVIEW)lParam;
				LPNMHDR      lpnmh = (LPNMHDR)lParam; 

				if (pnmtv->hdr.code == TVN_SELCHANGED) { // c[r[őI̕ύX
					ITEMGROUP *pig = (ITEMGROUP *)pnmtv->itemNew.lParam;
					BOOL bStartEditEnable = FALSE;

					if (pig) {
						SetDlgItemText(hDlg, IDC_EDIT_MESSAGE, pig->keyword_show.c_str());
						if (pig->bOS & btOSMask) {
							// ҏWJn{^Lɂ
							bStartEditEnable = TRUE;
						}
					}
					else {
						if (num_of_items == 0) {
							SetDlgItemText(hDlg, IDC_EDIT_MESSAGE, "͂ꂽł͒oł܂Bē͂ĂB");
						}
						else {
							char s[256];
							wsprintf(s, "%d̕ҏWڂoĂ܂B\r\nҏWݒ荀ڂÃc[r[IAuIڂҏWv{^ĂB", num_of_items);
							SetDlgItemText(hDlg, IDC_EDIT_MESSAGE, s);
						}
					}
					EnableWindow(GetDlgItem(hDlg, IDC_BUTTON_STARTEDIT), bStartEditEnable);
				}
				else if (lpnmh->code == NM_DBLCLK) { // _uNbN
					// ҏW{^ɓ]
					SendMessage(hDlg, WM_COMMAND, MAKEWPARAM(IDC_BUTTON_STARTEDIT, 0), 0);
				}
			}
			return (INT_PTR)TRUE;

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_CHECK_ALWAYS_FIND: // {^ȂĂ
					if (SendDlgItemMessage(hDlg, IDC_CHECK_ALWAYS_FIND, BM_GETCHECK, 0, 0) == BST_CHECKED) {
						// {^𖳌
						EnableWindow(GetDlgItem(hDlg, IDC_BUTTON_SEARCH), FALSE);
						// Jn^C}ݒ肷B
						SetTimer(hDlg, TIMERID, TIMERWAIT, NULL);
					}
					else {
						// {^Lɖ߂
						EnableWindow(GetDlgItem(hDlg, IDC_BUTTON_SEARCH), TRUE);
					}
					return (INT_PTR)TRUE;

				case IDC_EDIT_SEARCH: // FҏW{bNXҏWꂽ
					if (HIWORD(wParam) == CBN_EDITCHANGE || HIWORD(wParam) == CBN_SELCHANGE) {
						if (SendDlgItemMessage(hDlg, IDC_CHECK_ALWAYS_FIND, BM_GETCHECK, 0, 0) == BST_CHECKED) {
							// {^ȂĂݒɂȂĂꍇA
							// Jn^C}ݒ肷B
							SetTimer(hDlg, TIMERID, TIMERWAIT, NULL);
						}
					}
					return (INT_PTR)TRUE;

				case IDC_CHECK_SHOW_ENABLE_ONLY: // p\Ȃ̂\Ȃ
					startSearch(hDlg);
					return (INT_PTR)TRUE;

				case IDC_BUTTON_SEARCH: // {^
					if (startSearch(hDlg)) {		// Jn
						// ͕R{{bNXɓo^
						int lenSearchText = GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT_SEARCH));
						if (lenSearchText > 0) {
							++lenSearchText;
							LPTSTR pbuf = (LPTSTR)calloc(lenSearchText, sizeof(TCHAR));
							if (pbuf) {
								GetDlgItemText(hDlg, IDC_EDIT_SEARCH, pbuf, lenSearchText);
								cbq->Add(pbuf);
								free(pbuf);
							}
						}
					}
					SetFocus(GetDlgItem(hDlg, IDC_TREE1));	// c[r[ɃtH[JXړ
					return (INT_PTR)TRUE;

				case IDCANCEL:	// ̃_CAO
					{
						KillTimer(hDlg, TIMERID);

						REG reg;
						if (reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_CREATE)) {
							// WXg֐ݒۑ
							reg.WriteInteger("SearchDlg_EnableOnly", (int)SendDlgItemMessage(hDlg, IDC_CHECK_SHOW_ENABLE_ONLY, BM_GETCHECK, 0, NULL)); // gp\Ȃ̂̂ݕ\
							reg.WriteInteger("SearchDlg_AlwaysFind", (int)SendDlgItemMessage(hDlg, IDC_CHECK_ALWAYS_FIND, BM_GETCHECK, 0, NULL)); // {^ȂĂJn

							// _CAÖʒuƃTCY
							WINDOWPLACEMENT wp;
							wp.length = sizeof(WINDOWPLACEMENT);
							if ( GetWindowPlacement(hDlg, &wp) ) {
								reg.WriteInteger("SearchDlg_Max",    wp.showCmd == SW_SHOWMAXIMIZED);
								reg.WriteInteger("SearchDlg_wLeft",  wp.rcNormalPosition.left);
								reg.WriteInteger("SearchDlg_wTop",   wp.rcNormalPosition.top);
								reg.WriteInteger("SearchDlg_wWidth", wp.rcNormalPosition.right - wp.rcNormalPosition.left);
								reg.WriteInteger("SearchDlg_wHeight",wp.rcNormalPosition.bottom - wp.rcNormalPosition.top);
							}
							reg.CloseKey();
						}
						else {
							dispErrorMessage(hDlg, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[", "WXgL['HKEY_CURRENT_USER\\", RNSF7REGKEY,
											 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F", getLastErrorString(tRegGetLastError()), NULL, NULL);
						}

						EndDialog(hDlg, LOWORD(wParam));
					}
					return (INT_PTR)TRUE;

				case IDC_BUTTON_STARTEDIT: // ҏWJn
					{
						// c[r[̃J[\ʒu𓾂āÄʒȕǂݎ
						HWND hTreeView = GetDlgItem(hDlg, IDC_TREE1);
						HTREEITEM hTreeCursor = TreeView_GetSelection(hTreeView);

						if (hTreeCursor != NULL) { // IȂI
							TVITEM tvi;

							tvi.mask = TVIF_PARAM;
							tvi.hItem = hTreeCursor;
							TreeView_GetItem(hTreeView, &tvi);

							if (tvi.lParam != 0) { // ACełȂI
								ITEMGROUP *ig = (ITEMGROUP *)tvi.lParam;
								if (ig->bOS & btOSMask) {
									openrsc(hDlg, ig->rsc.c_str(), ig->id.c_str());
								}

								// ͕R{{bNXɓo^
								int lenSearchText = GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT_SEARCH));
								if (lenSearchText > 0) {
									++lenSearchText;
									LPTSTR pbuf = (LPTSTR)calloc(lenSearchText, sizeof(TCHAR));
									if (pbuf) {
										GetDlgItemText(hDlg, IDC_EDIT_SEARCH, pbuf, lenSearchText);
										cbq->Add(pbuf);
										free(pbuf);
									}
								}
							}
						}
					}
					return (INT_PTR)TRUE;
			}
			break;
	}
	return (INT_PTR)FALSE;
}

void kwdDialog(HWND hWnd)
{
	DialogBox(hInst, (LPCTSTR)IDD_SEARCHDLG, hWnd, (DLGPROC)MainKwdSearchDialog);
}
