#include "stdafx.h"
#include "Rnsf7.h"
#include "MainWindow.h"
#include "OpenSetting.h"
#include "interprete.h"
#include "addctrl.h"
#include "refresh.h"
#include "SelIcon.h"
#include "lvedit.h"
#include "dlllib.h"
#include "helpdlg.h"
#include "opendlg.h"
#include "symbol.h"
#include "splash.h"
#include "MainSearchRsc.h"
#include "MainListview.h"
#include "filetypes.h"
#include "commfunc.h"
#include "chkaccr.h"
#include "pre_interprete.h"
#include "lvcsv.h"

#define R7OSSC_TIMERID	634
#define R7OSSC_TIMERWAIT 200 // X[XXN[ɍĕ`s߂̑҂

// #define DEBUG_LOGMODE				1	// Oo͂sꍇ(dout𗘗p)

// C^[o^C}̂Ƃѐ惉x
EXTERN char *pszEditDialogTimerLabel;

/* ჌xR-Scriptւ̕ϊ̗lqꍇ́A
   Rnsf7̃WXgL[DWORD̃GguDEBUG_LOWLEVEL_INTERPRETEvA
   l 1 ɂĉ */

// ֐
static void  movectrl( HWND hWnd, int vsa, int vsb );	 // XN[o[𑀍삵ƂɃRg[ړ

static short galabel( HWND hWnd, const char *rscname, const char *id, const char *alabel ); // id+alabel ƂxWv

static bool listview_edit( HWND hWnd, int iCtrl );		 // Xgr[FACe̕ҏW(2J)
static bool listview_delete( HWND hWnd, int iCtrl );	 // Xgr[FACe̍폜(2J)
static bool listview_new( HWND hWnd, int iCtrl );		 // Xgr[FACe̍쐬(2J)

static bool listview_n_edit( HWND hWnd, int iCtrl );	 // Xgr[FACe̕ҏW(nJ)
// static bool listview_n_delete( HWND hWnd, int iCtrl );	 // Xgr[FACe̍폜(nJ)
// Ă邱Ƃ n  2 Ȃ̂ŒPɒu
#define listview_n_delete(h,i) listview_delete(h,i)
static bool listview_n_new( HWND hWnd, int iCtrl );		 // Xgr[FACe̍쐬(nJ)

static int CALLBACK listview_pfnCompare(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort); // Xgr[F\[gɌĂяo֐
volatile bool running_settingdialog = 0;

// ҏW_CAÕftHgtH[JX̃Rg[ID
static const char *MainEditDlgProc_Focus;

bool bNotAddRecent;		// uŋߎg@\ځvւ̒ǉiXVjsȂtO

// ҏW_CAOJ
bool OpenSetting( HWND hParentWnd, const MLVI *mlvi, HWND hStatusBar )
{
	bool rv;

	if ( !mlvi )
		return false;

	rscname = mlvi->rsc_fname;
	g_item = mlvi->item;
	helpfile = mlvi->help;
	contextid = mlvi->contextid;

	running_settingdialog = 1;
	MainEditDlgProc_Focus = NULL;
	if ( -1 == DialogBox(hInst, (LPCTSTR)IDD_DIALOG1, hParentWnd, (DLGPROC)MainEditDlgProc) ) {
		// ł́AG[NƂ́AOɌt̃_CAO\̂ŁAŃG[bZ[W͕KvȂ
		rv = false;
	}
	else {
		rv = true;
	}
	running_settingdialog = 0;

	if ( mlvi == NULL ) {
		safefree( g_item );
		safefree( helpfile );
	}

	if ( hStatusBar ) {
		SendMessage(hStatusBar, SB_SETTEXT, 0, (LPARAM)(bCategory?"̃JeSꗗ番ޖIAËꗗݒҏWڂJĉB":"ݒҏWڂJĉB"));
	}
	return rv;
}

// ut@Cw肵ĊJv܂̓R}hCŎw肳ꂽꍇB
int  openrsc( HWND hWnd, const char *arg_rscname, const char *FocusID )
{
	int rv = 0, l;

	// " Ɉ͂܂ĂA" 菜
	if ( arg_rscname[0] == '\"' ) {
		rscname = _strdup( arg_rscname + 1 );
		if ( rscname ) {
			rv = lstrlen( rscname );
			if ( rscname[rv-1] == '\"' )
				rscname[rv-1] = 0;
		}
	}
	else {
		rscname = _strdup( arg_rscname );
	}

	l = lstrlen( rscname );
	if ( l > 4 && 0 == _stricmp(&rscname[l-4], ".rnd") ) {
		// _CAOԒ`Ƃĉ͂Kv
		HANDLE hFile;
		char *pbuf;
		DWORD it, tmp;
		BOOL  bflag;

		rndname = rscname;
		// * ł͂܂ĂA_CAOԂt@C֕ۑ
		// : ł͂܂ĂA_CAOԂt@CǂݍŃWXg֕ۑ
		if ( rndname[0] == '*' || rndname[0] == ':' ) {
			// rndt@Crsct@C𐶐
			for( tmp = lstrlen(rndname) ; (isKanji1(rndname,tmp-2) || rndname[tmp-1] != '\\') && rndname[tmp-1] != '*' ; tmp-- )
				;
			rscname = _strdup( &rndname[tmp] );
			tmp = lstrlen( rscname );
			if ( tmp > 2 ) {
				rscname[ tmp-2 ] = 's';
				rscname[ tmp-1 ] = 'c';
			}
		}
		else {
			hFile = CreateFile(rndname, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
			if ( hFile == INVALID_HANDLE_VALUE ) {
				destroy_splash_window();
				MessageBox( hWnd, "w肳ꂽt@CJ܂B", "_CAOԂt@Cǂݍ", MB_OK | MB_ICONSTOP );
				return FALSE;
			}

			// wb_̃`FbN(DIALOGHEADERSIZE bytes)
			pbuf = zalloc( DIALOGHEADERSIZE+1 );
			if ( !pbuf ) {
				CloseHandle( hFile );
				destroy_splash_window();
				MessageBox( hWnd, "邽߂̃sĂ܂B", "_CAOԂt@Cǂݍ", MB_OK | MB_ICONSTOP );
				return FALSE;
			}
			bflag = ReadFile( hFile, pbuf, DIALOGHEADERSIZE, &tmp, NULL );
			if ( bflag == 0 || (bflag != 0 && tmp == 0) ) {
				pbuf[0] = 0;
			}
			pbuf[DIALOGHEADERSIZE-1] = 0;
			pbuf[DIALOGHEADERIGNR] = '-'; // ʌ݊̂߂̓ǂݔ΂

			if ( strcmp(pbuf, DIALOGHEADER) != 0 ) {
				CloseHandle( hFile );
				destroy_splash_window();
				MessageBox( hWnd, "w肳ꂽt@C͏Ԃۑꂽt@Cł͂ȂAΉĂȂo[WłB", "_CAOԂt@Cǂݍ", MB_OK | MB_ICONSTOP );
				return FALSE;
			}
			safefree( pbuf );

			// rsct@Cǂݍ
			bflag = ReadFile(hFile, (LPVOID)&it, sizeof(it), &tmp, NULL);
			if ( bflag == 0 || (bflag != 0 && tmp == 0) ) it = 1;
		
			pbuf = zalloc( it );
			if ( pbuf ) {
				bflag = ReadFile(hFile, pbuf, it, &tmp, NULL);
				if ( bflag == 0 || (bflag != 0 && tmp == 0) ) it = 1;

				rscname = pbuf;
				// rscname Ɉp̂ pbuf Ă͂ȂȂ
			}
			else {
				destroy_splash_window();
				MessageBox( hWnd, "_CAOԓǂݍ݂̂߂ɕKvȃmۂł܂łB", "_CAOԂt@Cǂݍ", MB_OK | MB_ICONSTOP );
				return FALSE;
			}

			CloseHandle( hFile );
		}
	}
	else {
		rndname = NULL;
	}

	int ec = LR_USER_ERROR;
	{ // lr̓ĤŁÃXR[vł̎sɗ߂
		LOAD_RSC lr;
		if ( LR_OK == lr.source_load(rscname) ) {
			lr.searchItem(LR_SI_LOAD, NULL, 0, ec);
			if (ec == LR_OK) {
				g_item = _strdup( lr.searchItem(LR_SI_ITEM, rscname, 0, ec) ); // ^Cg
				helpfile = _strdup( lr.searchItem(LR_SI_HELP, "none", 0, ec) ); // wvt@C
				contextid = atou( lr.searchItem(LR_SI_CONTEXTID, "0", 0, ec) ); // wvID (.hlp̏ꍇ)
			}
			else {
				lr.errmes(hWnd);
			}
		}
		else {
			lr.errmes(hWnd);
		}
	}

	if (ec == LR_OK) {
		running_settingdialog = 1;
		MainEditDlgProc_Focus = FocusID;
		rv = (int)DialogBox(hInst, (LPCTSTR)IDD_DIALOG1, hWnd, (DLGPROC)MainEditDlgProc);
		running_settingdialog = 0;
	}

	safefree( g_item );
	safefree( helpfile );
	safefree( rscname );
	safefree( rndname );

	return rv?1:0;
}

// Rg[̕ύX
void ctrlChange( HWND hDlg, unsigned ctrl_no )
{
	if ( ctrl_no < nctrls ) {
		if ( !(rctrls[ctrl_no].flag_opt & CTRL_NOEFFECT ) ) {
			if ( rctrls[ctrl_no].flag_opt & 3 ) {
				system_refresh(GetParent(hDlg), hDlg, (BYTE)(rctrls[ctrl_no].flag_opt & 3));
			}
			stdButtonsStatus( hDlg, TRUE, -1, TRUE, TRUE, -1, -1, -1 );
		}
		rctrls[ctrl_no].changed = 1;
		if ( rctrls[ctrl_no].id[0] == ':' ) { // IDxAxփWv
			if ( 2 == rsc( hDlg, rscname, rctrls[ctrl_no].id, 0, NULL ) ) { // abortԂĂAҏWƂ͒f
				free_controls( hDlg, 0 );
				EndDialog(hDlg, 2);
			}
		}
	}
}

// OK/Kp{^̉i_CAOe̗Lj
// id: IDOK[OK]/IDYES[Kp] - ǂ̃{^Ă̊֐Ă΂邩
void okApply( HWND hDlg, int btnId )
{
	BOOL status_idcancel, status_idhelp, status_idretry, status_idsave, status_idload;
	HCURSOR OldCursor;
	short ret;

	SendMessage( GetParent(hDlg), R7MW_STATUS_BAR, 0, (LPARAM)"IsĂ܂..." );
	OldCursor = SetCursor( LoadCursor(NULL, IDC_WAIT) );

	// ʒm͒̂ŁA{^̓OCAEgĂB
	stdButtonStatus(hDlg, IDOK, FALSE);
	stdButtonStatus(hDlg, IDYES, FALSE);
	status_idcancel = stdButtonStatus(hDlg, IDCLOSE, FALSE);
	status_idretry = stdButtonStatus(hDlg, IDRETRY, FALSE);
	status_idhelp = stdButtonStatus(hDlg, IDHELP, FALSE);
	status_idsave = stdButtonStatus(hDlg, IDSAVE, FALSE);
	status_idload = stdButtonStatus(hDlg, IDLOAD, FALSE);

	/* WXg֏ */
	ret = rsc( hDlg, rscname, ":OK", 0, NULL );

	// XNvgAbortԂĂꍇ͏I𒆒f
	// XNvgG[ꍇI𒆒f
	// I܂ :OK xȂꍇ́A𑱍s
	if ( ret == 0 || ret == 3 ) {
		SendMessage( GetParent(hDlg), R7MW_STATUS_BAR, 0, (LPARAM)"ݒۑĂ܂..." );
		if ( 1 == free_controls( hDlg, btnId != IDYES ? 1 : 2 ) ) {
			destroy_splash_window();
			MessageBox(hDlg, "ꕔ̃WXgL[JƂłȂ߁AWXgGgւ݂̎邱Ƃł܂łB\n̐ݒlꂽ܂B\n\nڍׂȃG[𓾂ɂ́Auݒvj[uIvVvɂuݒۑAWXg݂ŃG[񍐂vɃ`FbNĂB", "ݒl̑", MB_OK | MB_ICONEXCLAMATION );
		}
		// system_refresh:Oɗ\񂵂ĂtbVs
		// system_refresh1ԂƁAċNv
		if ( system_refresh(GetParent(hDlg), hDlg, 4) == 1 || btnId != IDYES ) { // [OK]ȂIA[Apply](YES)Ȃ瑱s
			SetCursor( OldCursor );
			EndDialog(hDlg, 1);
			return;
		}
	}
	else {
		stdButtonStatus(hDlg, IDOK, TRUE);
		stdButtonStatus(hDlg, IDYES, TRUE);
	}

	stdButtonsStatus(hDlg, -1, status_idcancel, -1, status_idretry, status_idsave, status_idload, status_idhelp);

	// [Kp]āAWXgւ̈ʂ݂̏ς񂾂 :APPRY Ă
	rsc( hDlg, rscname, ":APPRY", 0, NULL );
	// [Kp]{^̓OCAEĝŁA[LZ]{^ɃJ[\u
	// (j[o[oĂꍇ́ANȂ낤)
	SetFocus(GetDlgItem(hDlg, IDCLOSE));

	SetCursor( OldCursor );
	SendMessage( GetParent(hDlg), R7MW_STATUS_BAR, 0, (LPARAM)"" );
}

// ҏW_CAOpvV[W
LRESULT CALLBACK MainEditDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	static UINT vsb;
	UINT vsa;
	SCROLLINFO si;
	static HMENU hLVMenu, hCBLMenu;
	static LONG  ddTop, ddHeight, ddLeft, ddWidth;
	static bool  abend_flag;
	static HWND  hHighLightCtrl;
	static HBRUSH hHighLightBrush;
	static COLORREF cHighLightColor = DEFAULT_HIGHLIGHTCOLOR;
	static UINT  iHighLightItem;
	static bool  bCloseButtonP;

	switch (message) {
		case WM_INITDIALOG:
			if ( rndname && rndname[0] == '*' ) {
				char s[MAX_PATH*2+60];

				wsprintf( s, "%sł...@@@@@[Shift]+[Esc]L[Œf܂", rscname );
				SendMessage( GetParent(hDlg), R7MW_STATUS_BAR, 0, (LPARAM)s );
			}
			else {
				SendMessage( GetParent(hDlg), R7MW_STATUS_BAR, 0, (LPARAM)"ҏW_CAOJĂ܂...@@@[Shift]+[Esc]L[Œf܂" );
			}

			SetWindowText(hDlg, g_item); // ^Cgo[ݒ
			helpdoc_start( g_item, 0 );
			abend_flag = 0;
			if ( 0 != rsc( hDlg, rscname, NULL, 0, NULL ) ) {
				// IłȂ΂̂܂܃Ti
				abend_flag = 1; // ُIꍇ́A_CAÕTCYۑȂ
				EndDialog(hDlg, -1);
			}
			else { // ʒɃ_CAOړ
				RECT rct;

				GetWindowRect(hDlg, &rct);	// ݂̃_CAÖʒu𓾂āATCYvZ
				// ݃_CAOuĂ郂j^
				HMONITOR hMon = MonitorFromRect(&rct, MONITOR_DEFAULTTONEAREST);
				MONITORINFO mi;
				mi.cbSize = sizeof(MONITORINFO);
				GetMonitorInfo(hMon, &mi);

				// ɌvZ
				rct.right  -= rct.left;
				rct.bottom -= rct.top;

				// VTCYvZ
				rct.left = mi.rcMonitor.left + (mi.rcMonitor.right  - mi.rcMonitor.left - rct.right ) / 2;
				rct.top  = mi.rcMonitor.top  + (mi.rcMonitor.bottom - mi.rcMonitor.top  - rct.bottom) / 2;

				ddTop    = rct.top;
				ddHeight = rct.bottom;
				ddLeft   = rct.left;
				ddWidth  = rct.right;

				// WXgÃ_CAÕTCY擾āAKp
				if ( rnsf7RegRead("NoSaveSettings", 0) == 0 ) {
					char fname[_MAX_FNAME*2], rscid[_MAX_FNAME*2+10];
					REG reg;

					if ( reg.OpenKey( HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_READONLY)) {
						_splitpath_s( rscname, NULL, 0, NULL, 0, fname, _countof(fname), NULL, 0 );
						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dTop");
						rct.top = reg.ReadInteger(rscid, rct.top);

						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dLeft");
						rct.left = reg.ReadInteger(rscid, rct.left);

						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dHeight");
						rct.bottom = reg.ReadInteger(rscid, rct.bottom);
						if ( rct.bottom < ddHeight/5 ) {
							rct.bottom = ddHeight/5;
						}

						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dWidth");
						rct.right = reg.ReadInteger(rscid, rct.right);

						reg.CloseKey();
					}
				}

				POINT pt = {rct.left, rct.top};
				if (NULL != MonitorFromPoint(pt, MONITOR_DEFAULTTONULL)) {
					// ꂩړ悤ƂEBhE̍WʓȂAֈړ
					MoveWindow(hDlg, rct.left, rct.top, rct.right, rct.bottom, TRUE);
				}
				else {
					// ꂩړ悤ƂEBhE̍WʊOȂA߂ĉʒֈړ
					GetWindowRect(hDlg, &rct);	// ݂̃_CAÖʒu𓾂āATCYvZ

					int x  = mi.rcMonitor.left + (mi.rcMonitor.right - mi.rcMonitor.left) / 2 - (rct.right - rct.left) / 2;
					int y = mi.rcMonitor.top + (mi.rcMonitor.bottom - mi.rcMonitor.top) / 2 - (rct.bottom - rct.top) / 2;

					SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
				}

				vsb = 0;

				if ( strcmp( helpfile, "none" ) == 0 ) { // wvȂ΃{^𖳌
                    stdButtonStatus( hDlg, IDHELP, FALSE );
				}

				helpdoc_end();

				hLVMenu = LoadMenu(hInst,(LPSTR)IDR_HBRMENU);
				hCBLMenu = LoadMenu(hInst,(LPSTR)IDR_CONTEXT_CBLMENU);
				SendMessage( GetParent(hDlg), R7MW_STATUS_BAR, 0, (LPARAM)"" );

				// VXej[ [OK],[Kp],[߂],[wv]] ǉ
				{
					HMENU hSysMenu;

					// }ɂ胁j[Ă̂ŁAtɒǉĂƂɂȂ
					hSysMenu = GetSystemMenu( hDlg, FALSE );
					InsertMenu( hSysMenu, 0, MF_SEPARATOR | MF_BYPOSITION, 0      , NULL );
					InsertMenu( hSysMenu, 0, MF_STRING    | MF_BYPOSITION, IDC_AKEY, "ANZ[^L[̊mF(&K)" );
					InsertMenu( hSysMenu, 0, MF_SEPARATOR | MF_BYPOSITION, 0      , NULL );
					InsertMenu( hSysMenu, 0, MF_STRING    | MF_BYPOSITION, IDHELP , "wv(&H)\tF1" );
					InsertMenu( hSysMenu, 0, MF_STRING    | MF_BYPOSITION, IDLOAD , "Ǎ(&L)" );
					InsertMenu( hSysMenu, 0, MF_STRING    | MF_BYPOSITION, IDSAVE , "ۑ(&W)" );
					InsertMenu( hSysMenu, 0, MF_STRING    | MF_BYPOSITION, IDRETRY, "߂(&R)" );
					InsertMenu( hSysMenu, 0, MF_STRING    | MF_BYPOSITION, IDYES  , "Kp(&A)" );
					InsertMenu( hSysMenu, 0, MF_STRING    | MF_BYPOSITION, IDOK   , "&OK" );
					DrawMenuBar( hDlg );
				}

				// _CAOԒ`֘A
				if ( rndname ) {
					if ( rndname[0] == '*' ) { // rndւ̏
						saveDialogStatus(hDlg, rndname+1);
						EndDialog( hDlg, 2 );
					}
					else if ( rndname[0] == ':' ) { // rnd̓ǂݍ+OK{^
						loadDialogStatus(hDlg, rndname+1);
						okApply(hDlg, IDOK);
						EndDialog( hDlg, 2 );
					}
					else { // rnd̓ǂݍ
						loadDialogStatus(hDlg, rndname);
					}
				}

				// tH[JX̐ݒ
				hHighLightCtrl = NULL;
				// nCCgACe̎w͏
				iHighLightItem = ERRORVALUE;

				if (MainEditDlgProc_Focus) {
					UINT i;

					if ( ERRORVALUE != (i = searchID(MainEditDlgProc_Focus)) ) {
						// MainEditDlgProc_Focus ŎRg[݂ꍇ
						hHighLightCtrl = rctrls[i].hCtrl;

						// Rg[̍ɁAACR쐬
						RECT rt;
						POINT pt;
						char snum[13];
						GetWindowRect(hHighLightCtrl, &rt);
						pt.x = rt.left; pt.y = rt.top;
						ScreenToClient(hDlg, &pt);
						wsprintf(snum, "#%d", IDI_FOCUS); // SS_ICON(CreateWindow)ɗ^ɂ́A"#num" Ń\[Xԍ^
						CreateWindow( WC_STATIC, snum, WS_CHILD|WS_VISIBLE|SS_ICON|SS_REALSIZEIMAGE,
							0, pt.y, 0, 0, hDlg, (HMENU)IDC_STATIC, hInst, NULL);

						// nCCgp̐Fݒ肷
						cHighLightColor = rnsf7RegRead("RkyHighLightColor", DEFAULT_HIGHLIGHTCOLOR);

						switch (rctrls[i].ctrl) {
							case ICON_BUTTON:
							case LVC_BUTTON_NEW:
							case LVC_BUTTON_EDIT:
							case LVC_BUTTON_DEL:
							case REF_BUTTON_FILE:
							case REF_BUTTON_FOLDER:
							case GOTO_BUTTON:
							case TODEFAULT_BUTTON:
							case COLOR_BUTTON:
							case MIN_GOTO_BUTTON:
								/* - ܂悢ACfBAł͂Ȃ̂ŁAƂ肠߂Ă
								// {^̔wiF͐ݒłȂ߁A
								// tbgX^Cɂ邱ƂőƂ̋ʂ
								SetWindowLongPtr(hHighLightCtrl, GWL_STYLE, GetWindowLongPtr(hHighLightCtrl, GWL_STYLE) | BS_FLAT);
								*/
								// nCCgpuV͍Ȃ
								hHighLightBrush = NULL;
								break;

							default:
								// Rg[̔wiFڗ邽߂̃uV
								hHighLightBrush = CreateSolidBrush(cHighLightColor); // nCCgpuV̍쐬
								break;
						}

						if ( rctrls[i].ctrl == LIST_CTRL ) {
							// `FbN{bNX̏ꍇ́AXgr[̔wiFݒs
							ListView_SetBkColor(hHighLightCtrl, cHighLightColor);
							ListView_SetTextBkColor(hHighLightCtrl, cHighLightColor);
						}
						else if (rctrls[i].ctrl == CHECK_CTRL && rctrls[i].i != ERRORVALUE) {
							// `FbN{bNXXg̏ꍇ́AXgr[̔wiF͔߂
							UINT c1, c2, c3;

							c1 = (cHighLightColor >> 16) & 0xff;
							c2 = (cHighLightColor >>  8) & 0xff;
							c3 =  cHighLightColor        & 0xff;

							c1 += ((0xff - c1) * 2 / 3);
							c2 += ((0xff - c2) * 2 / 3);
							c3 += ((0xff - c3) * 2 / 3);

							COLORREF cLightHighLight = (c1 << 16) | (c2 << 8) | c3;

							ListView_SetBkColor(hHighLightCtrl, cLightHighLight);
							ListView_SetTextBkColor(hHighLightCtrl, cLightHighLight);
							iHighLightItem = rctrls[i].i;
						}

						// tH[JX𓖂Ă
						SetFocus(hHighLightCtrl);

						// ɁAR-ScriptɃtH[JX𓖂Ăi`FbN{bNXXg̉\̂Łj
						SetFocusControl(MainEditDlgProc_Focus);
					}
					else {
						MessageBox(hDlg, "w肳ꂽڂ́Å݂ł͗pł܂B", "L[[h", MB_OK | MB_ICONWARNING);
					}
				}
			}

			// Vbg_EubN̗Ro^
			altShutdownBlockReasonCreate(hDlg, L"ҏWƒ");

			// L[{[htH[JX̐ݒsĂꍇAFALSEԂKvB
			// (XNvgłSetFocus̎gp or MainEditDlgProc_FocusɂtH[JXIDw)
			return 0;

		//case WM_CTLCOLORBTN:	// WM_CTLCOLORBTN̎gṕASӖȂ炵(MSDNwvQ)
		case WM_CTLCOLOREDIT:
		case WM_CTLCOLORSTATIC:
			// tH[JX̓Rg[ꍇ́AnCCgpuVŔwi`
			if ((HWND)lParam == hHighLightCtrl) {
				SetBkColor((HDC)wParam, cHighLightColor);
				return (LRESULT)hHighLightBrush;
			}
			else {
				// J[{^̃Tv
				for( UINT i=0 ; i<nctrls ; i++ ) {
					if (rctrls[i].ctrl == COLOR_BUTTON && (HWND)lParam == (HWND)rctrls[i].lParam) {
						if (rctrls[i].opt_p1 == 0 || rctrls[i].opt_u1 != rctrls[i].opt_u2) { // uV𐶐
							if (rctrls[i].opt_p1) DeleteObject(rctrls[i].opt_p1);
							rctrls[i].opt_p1 = CreateSolidBrush(GetColorButton(rctrls[i].id));
						}
						return (LRESULT)rctrls[i].opt_p1;
					}
				}
			}
			return 0;

		case WM_INITMENU:
			// VXej[̊eڂ̗LmF
			{
				HMENU hSysMenu;

				hSysMenu = GetSystemMenu( hDlg, FALSE );
				EnableMenuItem( hSysMenu, IDOK   , MF_BYCOMMAND | (stdButtonStatus(hDlg, IDOK   , -1) ? MF_ENABLED : MF_GRAYED));
				EnableMenuItem( hSysMenu, IDYES  , MF_BYCOMMAND | (stdButtonStatus(hDlg, IDYES  , -1) ? MF_ENABLED : MF_GRAYED));
				EnableMenuItem( hSysMenu, IDSAVE , MF_BYCOMMAND | (stdButtonStatus(hDlg, IDSAVE , -1) ? MF_ENABLED : MF_GRAYED));
				EnableMenuItem( hSysMenu, IDLOAD , MF_BYCOMMAND | (stdButtonStatus(hDlg, IDLOAD , -1) ? MF_ENABLED : MF_GRAYED));
				EnableMenuItem( hSysMenu, IDRETRY, MF_BYCOMMAND | (stdButtonStatus(hDlg, IDRETRY, -1) ? MF_ENABLED : MF_GRAYED));
				EnableMenuItem( hSysMenu, IDHELP , MF_BYCOMMAND | (stdButtonStatus(hDlg, IDHELP , -1) ? MF_ENABLED : MF_GRAYED));
			}
			return 1;

		case WM_SYSCOMMAND:
			// VXej[̌Ăяo
			switch( LOWORD(wParam) ) {
				case IDOK    :
				case IDYES   :
				case IDSAVE  :
				case IDLOAD  :
				case IDRETRY :
				case IDHELP  :
				case IDC_AKEY: // ANZ[^L[̊mF
					return SendMessage( hDlg, WM_COMMAND, LOWORD(wParam), NULL);

				default:
					return 0;
			}

		case WM_SIZE:	// EChẼTCY
			if ( addctrl( hDlg, AC_RESIZE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0) ) {
				// 0ȊOԂĂATCYɈʒu
				vsa = vsb;
				vsb = yctrls - dHeight;

				// o[̈ʒuXV
				si.cbSize = sizeof( SCROLLINFO );
				si.fMask = SIF_POS;
				si.nPos = vsb;
				SetScrollInfo(hDlg, SB_VERT, &si ,FALSE );
				movectrl(hDlg, vsa, vsb);
			}
			return 1;

		case WM_GETMINMAXINFO:	// EBhẼTCYE𐧌
			{
				MINMAXINFO *pmmi = (MINMAXINFO *)lParam;
				if ( pmmi ) {
					// ҏW_CAO̍̕ŏ͌ŒiXN[o[̗LŎ኱ωjAő͎w肵Ȃ
					pmmi->ptMinTrackSize.x = gDialogWidthMin;
					//pmmi->ptMaxTrackSize.x = 

					// ҏW_CAO̍̍ŏ͎w肵ȂBő́A_CAO̍ő咷
					//pmmi->ptMinTrackSize.y =
					pmmi->ptMaxTrackSize.y = yctrls;
				}
				return 1;
			}

		case WM_NOTIFY:
			{ /* (HWND)lParam AeRg[̃nh */
				LPNMHDR pnmh = (LPNMHDR)lParam;

				for( UINT i=0 ; i<nctrls ; i++ ) {
					if (rctrls[i].hCtrl == pnmh->hwndFrom) {
						if (rctrls[i].ctrl == LIST_CTRL) { // Xgr[ւnotify
							switch(pnmh->code) {
								case NM_DBLCLK : // _uNbN
									if ( GetLVCursor( rctrls[i].hCtrl ) >= 0 ) {

										if ( 2 != galabel( hDlg, rscname, rctrls[i].id, "_EDIT" ) ) {
											bool rv = 0;
											if ( rctrls[i].opt == 1 ) {
												rv = listview_n_edit( hDlg, i );
											}
											else {
												rv = listview_edit( hDlg, i );
											}

											if ( rv ) {
												ctrlChange( hDlg, i );
											}
										}
									}
									return 1;

								case LVN_COLUMNCLICK: // wb_NbNꂽ
									{// ComCtl ver.4.70OŁANMLISTVIEW ĝǂ́cs
										UINT i, m;
										LVITEM lvitem;

										m = ListView_GetItemCount( pnmh->hwndFrom );
										// ܂ lParam ɕבւɎg
										lvitem.mask = LVIF_PARAM;
										lvitem.iSubItem = 0;
										for(i=0 ; i<m ; i++) {
											lvitem.iItem = i;
											lvitem.lParam = (LPARAM)lvGetItemString( pnmh->hwndFrom, i, ((LPNMLISTVIEW)lParam)->iSubItem );
											ListView_SetItem(pnmh->hwndFrom, &lvitem);
										}
										// Ń\[g
										// (A\[g@ɍHvƂ́A 3ɕω邱Ƃɂ
										ListView_SortItems(pnmh->hwndFrom, (PFNLVCOMPARE)listview_pfnCompare, 0);

										// בւɎg
										for(i=0 ; i<m ; i++) {
											lvitem.iItem = i;
											ListView_GetItem(pnmh->hwndFrom, &lvitem);

											if ( lvitem.lParam ) {
												free( (void *)lvitem.lParam );
											}
										}
									}
									return 1;
							}
						}
						else if (rctrls[i].ctrl == CHKLIST_CTRL) { // `FbN{bNXXgւnotify
							switch(pnmh->code) {
								case LVN_KEYDOWN: // Xy[XL[
									if ( ((LPNMLVKEYDOWN)lParam)->wVKey != VK_SPACE ) {
										break;
									}
									// ̂܂܉
								case NM_DBLCLK: // _uNbN
								case NM_CLICK: // NbN
									{ // (ReLXgj[̂ƂɂALڂ܂)
										int  cur = GetLVCursor( rctrls[i].hCtrl );
										UINT ci;

										if ( cur != -1 ) {
											// `FbNԂ̔]i `FbN [`FbN]  `FbN  c j
											if ( ListCheck_Change( rctrls[i].hCtrl, cur, -1 ) ) {
												// Xgr[curԖڂ̃f[^AԖڂ̃Rg[Ȃ̂𒲂ׁA
												// ci֑
												for(ci=0 ; ci<nctrls ; ci++) {
													if ( rctrls[i].hCtrl == rctrls[ci].hCtrl && rctrls[ci].i == cur ) {
														break;
													}
												}

												// ListCheck_ChangełctrlChange𔭍sȂ̂ŁA͂Ŕs
												ctrlChange(hDlg, ci);
											}
										}
										return 1;
									}

								case NM_CUSTOMDRAW: // JX^h[
									if (rctrls[i].hCtrl == hHighLightCtrl && iHighLightItem != ERRORVALUE) {
										LPNMLVCUSTOMDRAW lplvcd = (LPNMLVCUSTOMDRAW)lParam;

										if (lplvcd->nmcd.dwDrawStage == CDDS_PREPAINT) {
											// _CAO{bNX͑fɒlԂȂ̂ŁA
											// DWLP_MSGRESULT oRĒlԂBreturnɂTRUE^B
											SetWindowLongPtr(hDlg, DWLP_MSGRESULT, CDRF_NOTIFYITEMDRAW);
											return TRUE;
										}
										else if (lplvcd->nmcd.dwDrawStage == CDDS_ITEMPREPAINT) {
											if (lplvcd->nmcd.dwItemSpec == iHighLightItem) {
												lplvcd->clrTextBk = cHighLightColor;
												SetWindowLongPtr(hDlg, DWLP_MSGRESULT, CDRF_DODEFAULT);
												return TRUE;
											}
										}
									}
							}
						}
						break;
					}
				}
				return 0;
			}

		case OSP_CTRL_KEYDOWN: // Rg[ŃL[ꂽ(Av` = WM_APP+1)
			// wParam: zL[R[h
			// lParam: LPOSPCKDP
			// A炩̗RCallWindowProcĂ΂̂ł΁AOSP_CTRL_KEYDOWN1Ԃ
			switch((int)wParam) {
				case VK_DELETE:
				case VK_INSERT:
				case VK_SPACE:
					if (((LPOSPCKDP)lParam)->ctrl == LIST_CTRL) { // Xgr[ւnotify
						bool rv = 0;

						if ((int)wParam == VK_INSERT) {
							if ( 2 != galabel( hDlg, rscname, rctrls[((LPOSPCKDP)lParam)->iCtrl].id, "_NEW" ) ) {
								if ( rctrls[((LPOSPCKDP)lParam)->iCtrl].opt == 1 ) {
									rv = listview_n_new( hDlg, ((LPOSPCKDP)lParam)->iCtrl );
								}
								else {
									rv = listview_new( hDlg, ((LPOSPCKDP)lParam)->iCtrl );
								}
							}
						}
						else if ( GetLVCursor( ((LPOSPCKDP)lParam)->hCtrl ) >= 0 ) { // 1ȏ̑I
							if ((int)wParam ==  VK_DELETE) {
								if ( 2 != galabel( hDlg, rscname, rctrls[((LPOSPCKDP)lParam)->iCtrl].id, "_DELETE" ) ) {
									if ( rctrls[((LPOSPCKDP)lParam)->iCtrl].opt == 1 ) {
										rv = listview_n_delete( hDlg, ((LPOSPCKDP)lParam)->iCtrl );
									}
									else {
										rv = listview_delete( hDlg, ((LPOSPCKDP)lParam)->iCtrl );
									}
								}
							}
							else if ((int)wParam ==  VK_SPACE) {
								if ( 2 != galabel( hDlg, rscname, rctrls[((LPOSPCKDP)lParam)->iCtrl].id, "_EDIT" ) ) {
									if ( rctrls[((LPOSPCKDP)lParam)->iCtrl].opt == 1 ) {
										rv = listview_n_edit( hDlg, ((LPOSPCKDP)lParam)->iCtrl );
									}
									else {
										rv = listview_edit( hDlg, ((LPOSPCKDP)lParam)->iCtrl );
									}
								}
							}
						}

						if ( rv ) {
							ctrlChange(hDlg, ((LPOSPCKDP)lParam)->iCtrl);
						}
						((LPOSPCKDP)lParam)->retval = 0; // ftHg̃vV[WĂ΂Ȃ
						return 0;
					}
					break;

				case VK_PRIOR:
				case VK_NEXT:
					// ݁AsGfBbg{bNXAXgr[Rg[ɃtH[JX
					// Ă̂ł΁AXN[̓Rg[ɑ΂čsB
					if (((LPOSPCKDP)lParam)->ctrl == LIST_CTRL || ((LPOSPCKDP)lParam)->ctrl == MULTI_EDIT) { // Xgr[܂͕sҏW{bNX
						SCROLLINFO si;

						ZeroMemory(&si, sizeof(SCROLLINFO));
						si.cbSize = sizeof(SCROLLINFO);
						si.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
						GetScrollInfo(((LPOSPCKDP)lParam)->hCtrl, SB_VERT, &si);

						if ( ((int)wParam == VK_PRIOR && si.nPos > si.nMin) || ((int)wParam == VK_NEXT && si.nPos < si.nMax - (int)si.nPage) ) {
							((LPOSPCKDP)lParam)->retval = 1; // ftHg̃vV[WĂ
							return 0;
						}
					}
					// łȂ΁A_CAOɑ΂ăXN[sB
					vsa = vsb;

					if ( (int)wParam ==  VK_PRIOR ) { // PageUp
						if (vsb > dHeight) {
							vsb -= dHeight;
						}
						else {
							vsb = 0;
						}
					}
					else if ((int)wParam ==  VK_NEXT) { // PageDown
						if (vsb+2*dHeight < yctrls) {
							vsb += dHeight;
						}
						else {
							vsb = yctrls - dHeight;
						}
					}

					// o[̈ʒuXV
					si.cbSize = sizeof( SCROLLINFO );
					si.fMask = SIF_POS;
					si.nPos = vsb;
					SetScrollInfo(hDlg, SB_VERT, &si ,TRUE );
					movectrl(hDlg, vsa, vsb);

					((LPOSPCKDP)lParam)->retval = 0; // ftHg̃vV[WĂ΂Ȃ
					return 0;

				case 'W':
					if (GetAsyncKeyState(VK_CONTROL) < 0) {
						// Ctrl+W : 
						SendMessage(hDlg, WM_COMMAND, MAKEWPARAM(IDCANCEL, 0), 0);
						((LPOSPCKDP)lParam)->retval = 0; // ftHg̃vV[WĂ΂Ȃ
						return 0;
					}
					break;
			}
			((LPOSPCKDP)lParam)->retval = 1; // ftHg̃vV[WĂ
			return 1;

		case OSP_CTRL_CHAR: // Rg[ŃL[ꂽAR[h󂯎(Av` = WM_APP+5)
			// wParam: R[h
			// lParam: LPOSPCKDP
			switch((int)wParam) {
				case CTRL_A: // ׂđI
					if (((LPOSPCKDP)lParam)->ctrl == LIST_CTRL) { // Xgr[ւnotify
						if ( (rctrls[((LPOSPCKDP)lParam)->iCtrl].flag_opt & LV_MULTISELECT) && ListView_GetItemCount(((LPOSPCKDP)lParam)->hCtrl) > 0 ) { // IŁAAڂ1ȏ㑶݂
							int n = ListView_GetItemCount(((LPOSPCKDP)lParam)->hCtrl);

							for(int j=0 ; j<n ; j++) {
								ListView_SetItemState(((LPOSPCKDP)lParam)->hCtrl, j, LVIS_SELECTED, LVIS_SELECTED );
							}
							((LPOSPCKDP)lParam)->retval = 0; // ftHg̃vV[WĂ΂Ȃ
							return 0;
						}
					}
					else if (((LPOSPCKDP)lParam)->ctrl == EDIT_CTRL || ((LPOSPCKDP)lParam)->ctrl == MULTI_EDIT) {
						SendMessage( ((LPOSPCKDP)lParam)->hCtrl, EM_SETSEL, (WPARAM)0, (LPARAM)-1 );  
						((LPOSPCKDP)lParam)->retval = 0; // ftHg̃vV[WĂ΂Ȃ
						return 0;
					}
					break;
			}
			((LPOSPCKDP)lParam)->retval = 1; // ftHg̃vV[WĂ
			return 0;

		case WM_CONTEXTMENU: // ENbNj[
			{
				for( UINT i=0 ; i<nctrls ; i++ ) {
					if (rctrls[i].hCtrl == (HWND)wParam) {
						if ( rctrls[i].ctrl == LIST_CTRL ) { // Xgr[
							HMENU hMenu;
							POINT pt;
							bool  rv = 0;

							GetCursorPos(&pt);
							hMenu = GetSubMenu(hLVMenu, 0);
							SetMenuDefaultItem(hMenu, IDC_BUTTON_EDIT, FALSE);

							if ( -1 != GetLVCursor( rctrls[i].hCtrl ) ) {
								EnableMenuItem(hMenu, IDC_BUTTON_EDIT, MF_ENABLED | MF_BYCOMMAND );
								EnableMenuItem(hMenu, IDC_BUTTON_DELETE, MF_ENABLED | MF_BYCOMMAND );
							}
							else { // IڂȂ
								EnableMenuItem(hMenu, IDC_BUTTON_EDIT, MF_GRAYED | MF_BYCOMMAND );
								EnableMenuItem(hMenu, IDC_BUTTON_DELETE, MF_GRAYED | MF_BYCOMMAND );
								EnableMenuItem(hMenu, IDM_ALLSELECT, MF_GRAYED | MF_BYCOMMAND );
								EnableMenuItem(hMenu, IDM_SELECTCHANGE, MF_GRAYED | MF_BYCOMMAND );
							}

							if ( (rctrls[i].flag_opt & LV_MULTISELECT) && ListView_GetItemCount(rctrls[i].hCtrl) > 0 ) { // IŁAAڂ1ȏ㑶݂
								EnableMenuItem(hMenu, IDM_ALLSELECT, MF_ENABLED | MF_BYCOMMAND );
								EnableMenuItem(hMenu, IDM_SELECTCHANGE, MF_ENABLED | MF_BYCOMMAND );
							}
							else {
								EnableMenuItem(hMenu, IDM_ALLSELECT, MF_GRAYED | MF_BYCOMMAND );
								EnableMenuItem(hMenu, IDM_SELECTCHANGE, MF_GRAYED | MF_BYCOMMAND );
							}

							switch( (int)TrackPopupMenuEx(hMenu, TPM_RETURNCMD, pt.x, pt.y, hDlg, NULL) ) {
								case IDC_BUTTON_EDIT: // I𒆂̃ACeҏW
									if ( 2 != galabel( hDlg, rscname, rctrls[i].id, "_EDIT" ) ) {
										if ( rctrls[i].opt == 1 ) { // L[Xg܂͈ʂ̃Xgr[
											rv = listview_n_edit( hDlg, i );
										}
										else { // lXg
											rv = listview_edit( hDlg, i );
										}
									}
									break;

								case IDC_BUTTON_DELETE: // I𒆂̃ACe폜
									if ( 2 != galabel( hDlg, rscname, rctrls[i].id, "_DELETE" ) ) {
										if ( rctrls[i].opt == 1 ) { // L[Xg܂͈ʂ̃Xgr[
											rv = listview_n_delete( hDlg, i );
										}
										else { // lXg
											rv = listview_delete( hDlg, i );
										}
									}
									break;

								case IDC_BUTTON_NEW: // ACe̐VK쐬
									if ( 2 != galabel( hDlg, rscname, rctrls[i].id, "_NEW" ) ) {
										if ( rctrls[i].opt == 1 ) { // L[Xg܂͈ʂ̃Xgr[
											rv = listview_n_new( hDlg, i );
										}
										else { // lXg
											rv = listview_new( hDlg, i );
										}
									}
									break;

								case IDM_ALLSELECT: // SẴACeI
									{
										int n = ListView_GetItemCount(rctrls[i].hCtrl);

										for(int j=0 ; j<n ; j++) {
											ListView_SetItemState(rctrls[i].hCtrl, j, LVIS_SELECTED, LVIS_SELECTED );
										}
									}
									break;

								case IDM_SELECTCHANGE: // ACȇIԂ؂ւ
									{
										int n = ListView_GetItemCount(rctrls[i].hCtrl);

										for(int j=0 ; j<n ; j++) {
											if ( LVIS_SELECTED == ListView_GetItemState(rctrls[i].hCtrl, j, LVIS_SELECTED ) ) {
												ListView_SetItemState(rctrls[i].hCtrl, j, 0, LVIS_SELECTED );
											}
											else {
												ListView_SetItemState(rctrls[i].hCtrl, j, LVIS_SELECTED, LVIS_SELECTED );
											}
										}
									}
									break;

								case IDM_CSV_SAVE:	// CSVt@C֏o
									lvSaveToCsv(hDlg, rctrls[i].hCtrl,
										        rctrls[i].opt != 1 ? 2 : lvCountColumn((const char **)rctrls[i].text));
									break;
								case IDM_CSV_LOAD:	// CSVt@Ći㏑j
									if (rctrls[i].id[0] == ':') {
										if (IDCANCEL == MessageBox(hDlg, "݁A\Ăf[^͏ACSVt@Cf[^ǂ݂܂B\r\n"
											                             "̕ҏWڂ́Aȓ͌`KvƂĂ\܂Bt@C̃f[^̓ǂݍ݂sꍇAf[^̓eɂĂ"
																		 "sN邩܂B\r\n"
																		 "s܂?", "CSVt@C", MB_OKCANCEL | MB_ICONQUESTION)) {
											break;
										}
									}
									else {
										if (IDCANCEL == MessageBox(hDlg, "݁A\Ăf[^͏ACSVt@Cf[^ǂ݂܂B\r\n"
																		 "s܂?", "CSVt@C", MB_OKCANCEL | MB_ICONQUESTION)) {
											break;
										}
									}
									rv = lvLoadFromCsv(hDlg, rctrls[i].hCtrl,
										        rctrls[i].opt != 1 ? 2 : lvCountColumn((const char **)rctrls[i].text));
									break;
								case IDM_CSV_APPEND: // CSVt@Cǉ
									if (rctrls[i].id[0] == ':') {
										if (IDCANCEL == MessageBox(hDlg, "݁A\Ăf[^̌ɁACSVt@Cf[^ǂ݂Aǉ܂B\r\n"
											                             "̕ҏWڂ́Aȓ͌`KvƂĂ\܂Bt@C̃f[^̓ǂݍ݂sꍇAf[^̓eɂĂ"
																		 "sN邩܂B\r\n"
																		 "s܂?", "CSVt@C(ǉ)", MB_OKCANCEL | MB_ICONQUESTION)) {
											break;
										}
									}
									else {
										if (IDCANCEL == MessageBox(hDlg, "݁A\Ăf[^̌ɁACSVt@Cf[^ǂ݂Aǉ܂B\r\n"
																		 "s܂?", "CSVt@C(ǉ)", MB_OKCANCEL | MB_ICONQUESTION)) {
											break;
										}
									}
									rv = lvAppendFromCsv(hDlg, rctrls[i].hCtrl,
										        rctrls[i].opt != 1 ? 2 : lvCountColumn((const char **)rctrls[i].text));
									break;
							}

							if ( rv ) {
								ctrlChange(hDlg, i);
							}

							return 1;
						}
						else if ( rctrls[i].ctrl == CHKLIST_CTRL ) { // `FbN{bNXXg̃ReLXgj[
							HMENU hMenu;
							POINT pt;
							int   cur = 0;
							UINT  ci, cj, cn;
							union CBL_FLAG fCbl;

							GetCursorPos(&pt);
							hMenu = GetSubMenu(hCBLMenu, 0);
							SetMenuDefaultItem(hMenu, ID_CBLMENU_CLICK, FALSE);

							cur = GetLVCursor( (HWND)wParam );
							EnableMenuItem(hMenu, ID_CBLMENU_CLICK, MF_GRAYED | MF_BYCOMMAND );
							EnableMenuItem(hMenu, ID_CBLMENU_ALLON, MF_GRAYED | MF_BYCOMMAND );
							EnableMenuItem(hMenu, ID_CBLMENU_ALLOFF, MF_GRAYED | MF_BYCOMMAND );
							EnableMenuItem(hMenu, ID_CBLMENU_ALLNODET, MF_GRAYED | MF_BYCOMMAND );

							// I𒆂̍ڂ`FbN{bNXȂ΁Au`FbNԂ̕ύXvL
							if ( -1 != cur ) {
								fCbl.u = lvGetLParam( (HWND)wParam, cur );
								if ( fCbl.b.disable == TRUE && (fCbl.b.type == 2 || fCbl.b.type == 3) ) {
									EnableMenuItem(hMenu, ID_CBLMENU_CLICK, MF_ENABLED | MF_BYCOMMAND );
								}
							}

							cn = ListView_GetItemCount( (HWND)wParam );
							// `FbNɂȂ鍀ڂ1ȏ゠΁AuׂĔ`FbNvL
							for(cj=0 ; cj<cn ; cj++) {
								fCbl.u = lvGetLParam( (HWND)wParam, cj );
								if ( fCbl.b.disable == TRUE && fCbl.b.type == 3 && fCbl.b.state != 2 ) {
									EnableMenuItem(hMenu, ID_CBLMENU_ALLNODET, MF_ENABLED | MF_BYCOMMAND );
									break;
								}
							}

							// `FbNԂɂȂĂȂڂ1ȏ゠΁Auׂă`FbNvL
							for(cj=0 ; cj<cn ; cj++) {
								fCbl.u = lvGetLParam( (HWND)wParam, cj );
								if ( fCbl.b.disable == TRUE && (fCbl.b.type == 2 || fCbl.b.type == 3) && fCbl.b.state != 1 ) {
									EnableMenuItem(hMenu, ID_CBLMENU_ALLON, MF_ENABLED | MF_BYCOMMAND );
									break;
								}
							}

							// `FbNԂɂȂĂȂڂ1ȏ゠΁Auׂă`FbNvL
							for(cj=0 ; cj<cn ; cj++) {
								fCbl.u = lvGetLParam( (HWND)wParam, cj );
								if ( fCbl.b.disable == TRUE && (fCbl.b.type == 2 || fCbl.b.type == 3) && fCbl.b.state != 0 ) {
									EnableMenuItem(hMenu, ID_CBLMENU_ALLOFF, MF_ENABLED | MF_BYCOMMAND );
									break;
								}
							}

							switch( (int)TrackPopupMenuEx(hMenu, TPM_RETURNCMD, pt.x, pt.y, hDlg, NULL) ) {
								case ID_CBLMENU_CLICK: // IԂ̔]
									// `FbNԂ̔]i `FbN [`FbN]  `FbN  c j
									if ( ListCheck_Change( (HWND)wParam, cur, -1 ) ) {
										// Xgr[curԖڂ̃f[^AԖڂ̃Rg[Ȃ̂𒲂ׁA
										// ci֑
										for(ci=0 ; ci<nctrls ; ci++) {
											if ( (HWND)wParam == rctrls[ci].hCtrl && rctrls[ci].i == cur ) {
												break;
											}
										}

										// ListCheck_ChangełctrlChange𔭍sȂ̂ŁA͂Ŕs
										ctrlChange(hDlg, ci);
									}
									break;

								case ID_CBLMENU_ALLON: // ׂă`FbNԂɂ
									for(cj=0 ; cj<cn ; cj++) {
										fCbl.u = lvGetLParam( (HWND)wParam, cj );
										if ( fCbl.b.disable == TRUE && (fCbl.b.type == 2 || fCbl.b.type == 3) ) {
											if ( ListCheck_Change( (HWND)wParam, cj, 1 ) ) {
												// Xgr[cjԖڂ̃f[^AԖڂ̃Rg[Ȃ̂𒲂ׁA
												// ci֑
												for(ci=0 ; ci<nctrls ; ci++) {
													if ( (HWND)wParam == rctrls[ci].hCtrl && rctrls[ci].i == cj ) {
														break;
													}
												}

												// ListCheck_ChangełctrlChange𔭍sȂ̂ŁA͂Ŕs
												ctrlChange(hDlg, ci);
											}
										}
									}
									break;

								case ID_CBLMENU_ALLOFF: // ׂă`FbN
									for(cj=0 ; cj<cn ; cj++) {
										fCbl.u = lvGetLParam( (HWND)wParam, cj );
										if ( fCbl.b.disable == TRUE && (fCbl.b.type == 2 || fCbl.b.type == 3) ) {
											if ( ListCheck_Change( (HWND)wParam, cj, 0 ) ) {
												// Xgr[cjԖڂ̃f[^AԖڂ̃Rg[Ȃ̂𒲂ׁA
												// ci֑
												for(ci=0 ; ci<nctrls ; ci++) {
													if ( (HWND)wParam == rctrls[ci].hCtrl && rctrls[ci].i == cj ) {
														break;
													}
												}

												// ListCheck_ChangełctrlChange𔭍sȂ̂ŁA͂Ŕs
												ctrlChange(hDlg, ci);
											}
										}
									}
									break;

								case ID_CBLMENU_ALLNODET: // \Ȃ̂SĔ`FbNɂ
									for(cj=0 ; cj<cn ; cj++) {
										fCbl.u = lvGetLParam( (HWND)wParam, cj );
										if ( fCbl.b.disable == TRUE && fCbl.b.type == 3 ) {
											if ( ListCheck_Change( (HWND)wParam, cj, 2 ) ) {
												// Xgr[cjԖڂ̃f[^AԖڂ̃Rg[Ȃ̂𒲂ׁA
												// ci֑
												for(ci=0 ; ci<nctrls ; ci++) {
													if ( (HWND)wParam == rctrls[ci].hCtrl && rctrls[ci].i == cj ) {
														break;
													}
												}

												// ListCheck_ChangełctrlChange𔭍sȂ̂ŁA͂Ŕs
												ctrlChange(hDlg, ci);
											}
										}
									}
									break;
							}

                            return 1;
						}
						break;
					}
				}

				{
					// Ƀj[oƂł͂ȂƂŉENbNꂽꍇ̓VXej[\
					POINT  pt;

					GetCursorPos( &pt );
					//  VXej[̕\
					PostMessage( hDlg, 0x0313, 0, MAKELPARAM( pt.x, pt.y )); // 0x0313 : `̒lVXej[\
				}
				return 1;
			}

		case OSP_CTRL_GETFOCUS: //qEBhEtH[JX󂯎(= WM_APP : Av`bZ[W)
			// (int)wParam : qEBhEyW
			// (int)lParam : qEBhE̍
			vsa = vsb;
			if ( (int)wParam < 0 ) { // qEBhEyW0菬
				vsb += (int)wParam;
			}
			else { // qEBhEyWeEBhE̍傫
				RECT rt;

				GetClientRect( hDlg, &rt );
				if ( rt.bottom < (int)wParam + (int)lParam ) {
					vsb += ((int)wParam + (int)lParam - rt.bottom);
				}
			}

			if ( vsa != vsb ) {
				// o[̈ʒuXV
				si.cbSize = sizeof( SCROLLINFO );
				si.fMask = SIF_POS;
				si.nPos = vsb;
				SetScrollInfo(hDlg, SB_VERT, &si ,TRUE );
				movectrl(hDlg, vsa, vsb);
			}
			return 1;

		case WM_VSCROLL:
			if ( (HWND)lParam == NULL ) { // XN[o[
				if ( GetUpdateRect(hDlg, NULL, FALSE) == 0 ) {
					vsa = vsb;
					switch( LOWORD(wParam) ) {
						case SB_LINEDOWN:
							if (vsb+10 < yctrls - dHeight)
								vsb += 10;
							else
								vsb = yctrls - dHeight;
							break;

						case SB_LINEUP:
							if (vsb > 10)
								vsb -= 10;
							else
								vsb = 0;
							break;

						case SB_THUMBTRACK: // XN[Ȃ\邩ǂ
							if ( 2 == rnsf7RegRead("NoQuickScrool", 0) )
								return 1;
							// ̂܂܉
						case SB_THUMBPOSITION: // XN[IƂɕ\
							vsb = HIWORD( wParam );
							break;

						case SB_PAGEDOWN:
							if (vsb+2*dHeight < yctrls)
								vsb += dHeight;
							else
								vsb = yctrls - dHeight;
							break;

						case SB_PAGEUP:
							if (vsb > dHeight)
								vsb -= dHeight;
							else
								vsb = 0;
							break;

						default:
							return 0;
					}

					// o[̈ʒuXV
					si.cbSize = sizeof( SCROLLINFO );
					si.fMask = SIF_POS;
					si.nPos = vsb;
					SetScrollInfo(hDlg, SB_VERT, &si ,TRUE );
					movectrl(hDlg, vsa, vsb);
				}
				return 1;
			}
			else { // XsRg[
				UINT i;
				char s[13];

				for( i=0 ; i<nctrls ; i++ ) {
					if (rctrls[i].hCtrl == (HWND)lParam) {
						if (rctrls[i].ctrl == SPIN_CTRL) {
							UINT x;

							GetWindowText(rctrls[i-1].hCtrl, s, 12);
							x = atou( s );
							if (rctrls[i].byte_min < rctrls[i].bit_max) { // őEŏl̐ݒ肪ʏ킾ꍇ
								// Shift, CtrlĂAl
								if ( GetAsyncKeyState(VK_SHIFT)&0x8000 ) {
									x -= ((5000 - HIWORD(wParam)) * rctrls[i].opt_u2);
								}
								else if ( GetAsyncKeyState(VK_CONTROL)&0x8000 ) {
									if ( HIWORD(wParam) < 5000 ) {
										x = rctrls[i].byte_min;
									}
									else if ( HIWORD(wParam) > 5000 ) {
										x = rctrls[i].bit_max;
									}
								}
								else {
                                    x -= ((5000 - HIWORD(wParam)) * rctrls[i].opt_u1);
								}

								// l͈̔̓`FbNƑ
								char itbuf[16];
								if (rctrls[i].byte_min <= x && x <= rctrls[i].bit_max) {
									if ( 0 == _ultoa_s(x, itbuf, _countof(itbuf), 10) ) {
										SetWindowText(rctrls[i-1].hCtrl, itbuf );
									}
								}
								else {
									if ( 0 == _ultoa_s(rctrls[i].byte_min, itbuf, _countof(itbuf), 10) ) {
										SetWindowText(rctrls[i-1].hCtrl, itbuf );
									}
								}
							}
							else { // őEŏl̐ݒ肪tꍇ - {^̌ʂtɂ
								// Shift, CtrlĂAl
								if ( GetAsyncKeyState(VK_SHIFT)&0x8000 ) {
									x += ((5000 - HIWORD(wParam)) * rctrls[i].opt_u2);
								}
								else if ( GetAsyncKeyState(VK_CONTROL)&0x8000 ) {
									if ( HIWORD(wParam) < 5000 ) {
										x = rctrls[i].bit_max;
									}
									else if ( HIWORD(wParam) > 5000 ) {
										x = rctrls[i].byte_min;
									}
								}
								else {
                                    x += ((5000 - HIWORD(wParam)) * rctrls[i].opt_u1);
								}

								// l͈̔̓`FbNƑ
								char itbuf[16];
								if (rctrls[i].bit_max <= x && x <= rctrls[i].byte_min) {
									if ( 0 == _ultoa_s(x, itbuf, _countof(itbuf), 10) ) {
										SetWindowText(rctrls[i-1].hCtrl, itbuf );
									}
								}
								else {
									if ( 0 == _ultoa_s(rctrls[i].byte_min, itbuf, _countof(itbuf), 10) ) {
										SetWindowText(rctrls[i-1].hCtrl, itbuf );
									}
								}
							}

							// XsRg[̃|WV
							SendMessage(rctrls[i].hCtrl, UDM_SETPOS, 0, (LPARAM) MAKELONG((short) 5000, 0));
							break;
						}
					}
				}

				return 1;
			}

		case 0x020A: // }EXzC[ (= WM_MOUSEWHEEL)
			{
				short zDelta = HIWORD(wParam);

				if ( GetUpdateRect(hDlg, NULL, FALSE) == 0 ) {
					vsa = vsb;
					int aLineHeight = SCALEY(32);
					if (zDelta < 0) { // ɉ]
						if (vsb+aLineHeight < yctrls - dHeight)
							vsb += aLineHeight;
						else
							vsb = yctrls - dHeight;
					}
					else { // ɉ]
						if (vsb > aLineHeight)
							vsb -= aLineHeight;
						else
							vsb = 0;
					}

					// o[̈ʒuXV
					si.cbSize = sizeof( SCROLLINFO );
					si.fMask = SIF_POS;
					si.nPos = vsb;
					SetScrollInfo(hDlg, SB_VERT, &si ,TRUE );
					movectrl(hDlg, vsa, vsb);
				}
				return 1;
			}			
			

		case WM_HELP:
			if ( 2 != rsc( hDlg, rscname, ":HELP", 0, NULL ) ) { // abortłȂ
				callhelp( hDlg, helpfile, contextid );
			}
			return 1;

		case WM_TIMER:
			switch((int)wParam) {
				case R7OSSC_TIMERID:
					// }EXXN[܂̓XN[o[ɂXN[ɌĂ΂
					// _CAOɍőOʃEBhEꍇ̑΍
					KillTimer( hDlg, R7OSSC_TIMERID );
					InvalidateRect( hDlg, NULL, TRUE );
					return 1;

				case EDITDIALOG_TIMERID:
					// SetTimer ֐ɂC^[o^C}(XNvg͖)
					if ( pszEditDialogTimerLabel != NULL &&  pszEditDialogTimerLabel[0] == ':' ) {
						if ( 2 == rsc( hDlg, rscname, pszEditDialogTimerLabel, 0, NULL ) ) {
							// abortԂĂAҏWƂ͒f
							free_controls( hDlg, 0 );
							EndDialog(hDlg, 2);
						}
					}
					return 1;
			}
			break;

		case WM_DESTROY:
			FreeDllLibrary();
			{ // j[̔j
				HMENU hMenu = GetMenu( hDlg );
				if ( hMenu ) {
                    SetMenu( hDlg, NULL );
					DestroyMenu( hMenu );
				}
			}
			DestroyMenu( hLVMenu );
			DestroyMenu( hCBLMenu );
			// ̃_CAÕTCY擾āAWXg֕ۑ
			if ( abend_flag == 0 ) { // JnُIĂꍇ́A_CAÕTCYۑȂ
				RECT rt;
				char fname[_MAX_FNAME*2], rscid[_MAX_FNAME*2+10];
				REG reg;

				if ( reg.OpenKey( HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_CREATE)) {
					if ( reg.ReadInteger("NoSaveSettings", 0) == 0 ) {
						GetWindowRect(hDlg, &rt);

						_splitpath_s( rscname, NULL, 0, NULL, 0, fname, _countof(fname), NULL, 0 );

						// ҏW_CAO̍ۑ
						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dHeight");
						if ( ddHeight != rt.bottom - rt.top ) {
							reg.WriteInteger(rscid, rt.bottom - rt.top);
						}
						else {
							reg.DeleteValue( rscid );
						}

						// ҏW_CAO̕ۑ
						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dWidth");
						if ( ddWidth != rt.right - rt.left ) {
							reg.WriteInteger(rscid, rt.right - rt.left);
						}
						else {
							reg.DeleteValue( rscid );
						}

						// ҏW_CAȌWۑ
						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dTop");
						if ( ddTop != rt.top ) {
							reg.WriteInteger(rscid, rt.top);
						}
						else {
							reg.DeleteValue( rscid );
						}

						// ҏW_CAO̍Wۑ
						lstrcpy(rscid, fname);
						lstrcat(rscid, ".dLeft");
						if ( ddLeft != rt.left ) {
							reg.WriteInteger(rscid, rt.left);
						}
						else {
							reg.DeleteValue( rscid );
						}
					}
					reg.CloseKey();
				}
				else {
					dispErrorMessage(hDlg, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[", "WXgL['HKEY_CURRENT_USER\\", RNSF7REGKEY,
									 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F", getLastErrorString(tRegGetLastError()), NULL, NULL);
				}
			}
			// _CAOACR̔j
			{
				HICON hDialogIcon = (HICON)SendMessage(hDlg, WM_GETICON, ICON_SMALL, NULL);
				if ( hDialogIcon ) {
					SendMessage(hDlg, WM_SETICON, ICON_SMALL, NULL);
					DestroyIcon(hDialogIcon);
				}
			}
			// nCCgpuV̍폜
			if (hHighLightBrush) {
				DeleteObject(hHighLightBrush);
				hHighLightBrush = NULL;
			}
			// C^[o^C}̂Ƃѐ惉x
			if (pszEditDialogTimerLabel) {
				safefree(pszEditDialogTimerLabel);
				KillTimer(hDlg, EDITDIALOG_TIMERID);
			}

			// Vbg_EubN̗R
			altShutdownBlockReasonDestroy(hDlg);

			return 1;

		case WM_DROPFILES:
			{
				POINT pt;
				RECT rt;

				GetCursorPos( &pt );
				// qRg[Ńhbvꂽ̂łȂ`FbN
				// (qRg[̒Ńhbv͕̂ҏW{bNX̂)
				for(UINT i=0 ; i<nctrls ; i++) {
					if ( (rctrls[i].ctrl == EDIT_CTRL && rctrls[i].opt != 1) || rctrls[i].ctrl == MULTI_EDIT ) {
						GetWindowRect( rctrls[i].hCtrl, &rt );
						if ( rt.left <= pt.x && pt.x <= rt.right && rt.top <= pt.y && pt.y <= rt.bottom ) {
                            return SendMessage( rctrls[i].hCtrl, message, wParam, lParam );
						}
					}
				}

				char rndfname[MAX_PATH*2];

				DragQueryFile((HDROP)wParam, 0, rndfname, _countof(rndfname));
				DragFinish((HDROP)wParam);

				if ( IDYES == MessageBox( hDlg, "݂̃_CAȌԂ́Ahbvꂽt@CǂݏoꂽԂŏ㏑܂B\n낵ł?\n\nقȂōꂽrndt@Cǂݍ܂ȂłBOSقȂiWindows XPōꂽrndt@CVistaɓꂽAx86łōꂽrndt@Cx64łɓꂽ肷jꍇAWXg̎gقȂ邱ƂA\ʌʂƂ܂B", "_CAȌԂt@Cǂݍ", MB_YESNO | MB_ICONQUESTION ) ) {
					loadDialogStatus( hDlg, rndfname );
				}

				return 1;
			}

		case WM_QUERYENDSESSION: // WindowsZbV̏I
			if (IsWindowEnabled(hDlg)) {
				// [~]{^V~[g
				bCloseButtonP = false;
				SendMessage(hDlg, WM_COMMAND, MAKEWPARAM(IDCANCEL,0), 0);
				// [LZ]{^Ă̂ȂAҏWpȂ̂ŁAZbV̏IubNȂƂȂ
				SetWindowLongPtr(hDlg, DWLP_MSGRESULT, bCloseButtonP ? FALSE : TRUE);
			}
			return 1;

		case WM_COMMAND:
			{
				int pushedButton = LOWORD(wParam);

				switch ( pushedButton ) {
					case IDC_AKEY: // ANZ[^L[̊mF
						show_chkaccr( hDlg );
						break;

					case IDCANCEL: // EBhEE[~]{^
						if ( FALSE == stdButtonStatus(hDlg, IDOK, -1) || 0 == rnsf7RegRead("EscSave", 0) ) {
							; // pushedButton = IDCANCEL;
						}
						else {
							switch( MessageBox(hDlg, "ݕҏW̓éAۑELĂ܂B\nۑEL܂?", "ۑ̊mF", MB_YESNOCANCEL | MB_ICONQUESTION) ) {
								case IDYES:
									pushedButton = IDYES;
									break;

								case IDNO:
									pushedButton = IDCLOSE;
									break;

								case IDCANCEL:
									bCloseButtonP = true;
									return 1;
							}                            
						}
						// ̂܂܉
					case IDOK:	// OK{^
						SetFocus( GetDlgItem(hDlg, LOWORD(wParam)) );
						if ( LOWORD(wParam) == IDOK ) {
							if ( rnsf7RegRead("CheckOK", 1) ) {
								if (IDYES != MessageBox( hDlg, "Őݒ肵eۑELÃ_CAO܂B\n낵ł?", "[OK]̊mF", MB_YESNO | MB_ICONQUESTION )) {
									return 1;
								}
							}
							pushedButton = IDYES;
						}
						// ̂܂܉
					case IDYES:	// Kp{^
						SetFocus( GetDlgItem(hDlg, LOWORD(wParam)) );
						if ( LOWORD(wParam) == IDYES ) {
							if ( rnsf7RegRead("CheckApply", 1) ) {
								if (IDYES != MessageBox( hDlg, "Őݒ肵eۑAL܂B\n낵ł?", "[Kp]̊mF", MB_YESNO | MB_ICONQUESTION )) {
									bCloseButtonP = true;
									return 1;
								}
							}
						}
						if ( pushedButton == IDYES ) {
							// pushdButton͋U邱Ƃ̂ŁAwParamۂɉꂽ
							// {^擾ĂB
							okApply( hDlg, LOWORD(wParam) == IDYES ? IDYES : IDOK );
							return 1;
						}
						// ̂܂܉
					case IDCLOSE:	// LZ{^
						SetFocus( GetDlgItem(hDlg, LOWORD(wParam)) );
						if ( LOWORD(wParam) == IDCLOSE || pushedButton == IDCANCEL ) {
							if ( stdButtonStatus(hDlg, IDOK, -1) && rnsf7RegRead("CheckESC", 1) ) {
								if (IDYES != MessageBox( hDlg, "Őݒ肵eۑÃ_CAO܂B\n낵ł?", "[LZ]̊mF", MB_YESNO | MB_ICONQUESTION )) {
									bCloseButtonP = true;
									return 1;
								}
							}
						}
						if ( 2 != rsc( hDlg, rscname, ":CANCEL", 0, NULL ) ) {  // XNvgAbortԂĂꍇ͏I𒆒f
							free_controls( hDlg, 0 );
							EndDialog(hDlg, 2);
						}
						return 1;

					case IDRETRY:	// ߂
						SetFocus( GetDlgItem(hDlg, LOWORD(wParam)) );
						if ( rnsf7RegRead("CheckRetry", 1) ) {
							if (IDYES != MessageBox( hDlg, "̃_CAOJƂ̏Ԃɖ߂܂B\n낵ł?", "[߂]̊mF", MB_YESNO | MB_ICONQUESTION ))
								return 1;
						}
						if ( 2 != rsc( hDlg, rscname, ":RETRY", 0,NULL ) ) { // abortłȂ
							restore_controls();
							rsc( hDlg, rscname, ":AFTERRETRY", 0, NULL );
							stdButtonStatus(hDlg, IDRETRY, FALSE);
						}
						// [OK][Kp]{^̓OCAEĝŁA[LZ]{^ɃJ[\u
						// (j[o[oĂꍇ́ANȂ낤)
						SetFocus(GetDlgItem(hDlg, IDCLOSE));
						return 1;

					case IDHELP:	// wv{^
						SetFocus( GetDlgItem(hDlg, LOWORD(wParam)) );
						if ( 2 != rsc( hDlg, rscname, ":HELP", 0, NULL ) ) { // abortłȂ
							callhelp( hDlg, helpfile, contextid );
						}
						return 1;

					case IDSAVE:	// ۑ{^
						SetFocus( GetDlgItem(hDlg, LOWORD(wParam)) );
						if ( 2 != rsc( hDlg, rscname, ":IDSAVE", 0, NULL ) ) { // abortłȂ
							char fname[MAX_PATH*2], basefname[_MAX_FNAME*2];

							// ftHgrsct@C̊gq.rndɕς̂\B
							_splitpath_s(rscname, NULL, 0, NULL, 0, basefname, _countof(basefname), NULL, 0);
							_makepath_s(fname, _countof(fname), NULL, NULL, basefname, ".rnd");

							if ( saveDialog( hDlg, SOFTWARENAME"_CAO(*.rnd)\0*.rnd\0ׂẴt@C(*.*)\0*.*\0", fname, _countof(fname), "_CAȌԂt@C֕ۑ", "rnd" ) ) {
								if ( saveDialogStatus( hDlg, fname ) ) {
									MessageBox( hDlg, "_CAȌԂt@C֕ۑ܂B", "_CAȌԂۑ", MB_OK | MB_ICONINFORMATION );
								}
							}
						}
						return 1;

					case IDLOAD:	// Ǎ{^
						SetFocus( GetDlgItem(hDlg, LOWORD(wParam)) );
						if ( 2 != rsc( hDlg, rscname, ":IDLOAD", 0, NULL ) ) { // abortłȂ
							char fname[MAX_PATH*2], basefname[_MAX_FNAME*2];

							// ftHgrsct@C̊gq.rndɕς̂\B
							_splitpath_s(rscname, NULL, 0, NULL, 0, basefname, _countof(basefname), NULL, 0);
							_makepath_s(fname, _countof(fname), NULL, NULL, basefname, ".rnd");

							if ( openDialog( hDlg, SOFTWARENAME"_CAO(*.rnd)\0*.rnd\0ׂẴt@C(*.*)\0*.*\0", fname, _countof(fname), "_CAȌԂt@Cǂݍ", "rnd" ) ) {
								if ( IDYES == MessageBox( hDlg, "݂̃_CAȌԂ́Aw肳ꂽt@CǂݏoꂽԂŏ㏑܂B\n낵ł?\n\nقȂōꂽrndt@Cǂݍ܂ȂłBOSقȂiWindows XPōꂽrndt@CVistaɓꂽAx86łōꂽrndt@Cx64łɓꂽ肷jꍇAWXg̎gقȂ邱ƂA\ʌʂƂ܂B", "_CAȌԂt@Cǂݍ", MB_YESNO | MB_ICONQUESTION ) ) {
									if ( 1 == loadDialogStatus( hDlg, fname ) )
										MessageBox( hDlg, "t@C_CAȌԂǂݍ݂܂B", "_CAȌԂǂݍ", MB_OK | MB_ICONINFORMATION );
								}
							}
						}
						return 1;

					case IDNO: // eRg[
						{ /* (HWND)lParam AeRg[̃nh */
							for( UINT i=0 ; i<nctrls ; i++ ) {
								if (rctrls[i].hCtrl == (HWND)lParam) {
									if (rctrls[i].ctrl == REF_BUTTON_FILE) { // t@C̎Q
										char fname[MAX_PATH*2] = "";

										GetWindowText(rctrls[i-1].hCtrl, fname, _countof(fname));
										if ( openDialog( hDlg, FILETYPES, fname, _countof(fname), "t@C̑I", NULL ) ) {
											SetWindowText(rctrls[i-1].hCtrl, fname);
											SetFocus( rctrls[i-1].hCtrl );
										}
										break;
									}                                 
									else if (rctrls[i].ctrl == REF_BUTTON_FOLDER) { // tH_̎Q
										char chPutFolder[MAX_PATH*2] = "";

										GetWindowText(rctrls[i-1].hCtrl, chPutFolder, _countof(chPutFolder));
										if ( browseFolder( hDlg, chPutFolder, "tH_̑I" ) ) {
											SetWindowText(rctrls[i-1].hCtrl, chPutFolder);
											SetFocus( rctrls[i-1].hCtrl );
										}
										break;
									}

									else if (rctrls[i].ctrl == TODEFAULT_BUTTON) { // ftHg֖߂{^
										if ( rctrls[i].opt == 1 ) { // l̏ꍇ
											char itbuf[16];
											// l̏ꍇi-2Ȃ̂́AAbv_ERg[i-1ɐݒuĂ邽
											if ( 0 == _ultoa_s(rctrls[i-2].def_dw, itbuf, _countof(itbuf), 10) ) {
												SetWindowText(rctrls[i-2].hCtrl, itbuf);
											}
										}
										else {
											SetWindowText(rctrls[i-1].hCtrl, rctrls[i-1].def_sz);
										}
										SetFocus( rctrls[i-1].hCtrl );							
										break;
									}

									else if (rctrls[i].ctrl == ICON_BUTTON) { // ACR̎Q
										char *szIconName;
										int  length;

										length = GetWindowTextLength( rctrls[i].hCtrl );
										szIconName = zalloc(length + 1);
										if ( szIconName ) {
											GetWindowText(rctrls[i].hCtrl, szIconName, length+1);
											if ( IDOK == selicon( hDlg, &szIconName) ) {
												SetIconBox( rctrls[i].id, szIconName );
												ctrlChange(hDlg, i);
											}

											safefree( szIconName );
										}
										break;
									}

									else if ( rctrls[i].ctrl == LVC_BUTTON_NEW ) { // VK
										if ( 2 != rsc( hDlg, rscname, rctrls[i].id, 0, NULL ) ) {
											bool rv = 0;

											if ( rctrls[i-1].opt == 1 ) // keylist
												rv = listview_n_new( hDlg, i-1 );
											else // valuelist
												rv = listview_new( hDlg, i-1 );

											if ( rv ) {
												ctrlChange(hDlg, i-1);
											}
										}
										break;
									}
									else if ( rctrls[i].ctrl == LVC_BUTTON_EDIT ) { // ҏW
										if ( 2 != rsc( hDlg, rscname, rctrls[i].id, 0, NULL) ) {
											bool rv = 0;

											if ( rctrls[i-2].opt == 1 ) { // keylist
												rv = listview_n_edit( hDlg, i-2 );
											}
											else { // valuelist
												rv = listview_edit( hDlg, i-2 );
											}

											if ( rv ) {
												ctrlChange(hDlg, i-2);
											}
										}
										break;
									}
									else if ( rctrls[i].ctrl == LVC_BUTTON_DEL ) { // 폜
										if ( 2 != rsc( hDlg, rscname, rctrls[i].id, 0, NULL ) ) {
											bool rv = 0;

											if ( rctrls[i-3].opt == 1 ) { // keylist
												rv = listview_n_delete( hDlg, i-3 );
											}
											else { // valuelist
												rv = listview_delete( hDlg, i-3 );
											}

											if ( rv ) {
												ctrlChange(hDlg, i-3);
											}
										}
										break;
									}

									else if ( rctrls[i].ctrl == GOTO_BUTTON || rctrls[i].ctrl == MIN_GOTO_BUTTON ) { // x֔ԃ{^
										ctrlChange(hDlg, i);
										break;
									}

									else if ( rctrls[i].ctrl == COLOR_BUTTON ) { // FI
										CHOOSECOLOR cc;
										static COLORREF CustColors[16] = {RGB(0,0,0), RGB(0,0,255), RGB(0,255,255), RGB(0,255,0), RGB(255,0,255), RGB(255,0,0), RGB(255,255,0), RGB(255,255,255), RGB(0,0,127), RGB(0,127,127), RGB(0,127,0), RGB(127,0,127), RGB(127,0,0), RGB(127,127,0), RGB(127,127,127), RGB(192,192,192)};

										// WXgJX^J[擾
										REG reg;

										if (reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_READONLY)) {
											COLORREF CustColors0[16];

											if (reg.ReadString("CustColors", (char *)CustColors0, sizeof(CustColors0))) {
												memcpy(CustColors, CustColors0, sizeof(CustColors0));
											}
											reg.CloseKey();
										}

										ZeroMemory(&cc, sizeof(cc));
										cc.lStructSize = sizeof(cc);
										cc.hwndOwner = hDlg;
										cc.rgbResult = GetColorButton( rctrls[i].id );
										cc.lpCustColors = CustColors;
										cc.Flags= CC_FULLOPEN | CC_RGBINIT;

										if ( ChooseColor( &cc ) ) {
											SetColorButton( rctrls[i].id, cc.rgbResult );
											ctrlChange(hDlg, i);

											// WXgփJX^J[ۑ
											if (reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_CREATE)) {
												reg.WriteBinary("CustColors", (char *)CustColors, sizeof(CustColors));
												reg.CloseKey();
											}
											else {
												dispErrorMessage(hDlg, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[", "WXgL['HKEY_CURRENT_USER\\", RNSF7REGKEY,
																 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F", getLastErrorString(tRegGetLastError()), NULL, NULL);
											}

											// _CAOĕ`
											InvalidateRect((HWND)rctrls[i].lParam, NULL, TRUE);
										}
										break;
									}

									else if ( rctrls[i].ctrl == CHECK_CTRL ) { // `FbN{bNX
										// Auto3statełȂꍇ(=3stateON/OFF̏ԂɂJڂȂꍇ)́AŃ`FbNԂω
										if (rctrls[i].opt != 1) {
											if (BST_UNCHECKED != SendMessage(rctrls[i].hCtrl, BM_GETCHECK, 0, 0)) {
												SendMessage(rctrls[i].hCtrl, BM_SETCHECK, BST_UNCHECKED, 0);
											}
											else {
												SendMessage(rctrls[i].hCtrl, BM_SETCHECK, BST_CHECKED, 0);
											}
										}

										// Rg[̕ύXʒm
										ctrlChange(hDlg, i);

										break;
									}

									else if ( rctrls[i].ctrl == EDIT_CTRL || rctrls[i].ctrl == MULTI_EDIT ) { // ҏW{bNX
										// lpGfBbg{bNXꍇ́AeĎ
										// lɂȂĂȂA㏑
										if ( rctrls[i].opt == 1 ) {
											char *buf;
											volatile static bool sflag = 0;

											if ( sflag == 0 ) { // Z}tH
												int bsize;
												sflag = 1;

												bsize = GetWindowTextLength(rctrls[i].hCtrl) + 1;
												if ( bsize > 1 ) {
													buf = zalloc( bsize );
													if ( buf ) {
														DWORD curx;
														char itbuf[16];

														GetWindowText( rctrls[i].hCtrl, buf, bsize );
														// ͐l̐K
														if ( 0 == _ultoa_s(atou(buf), itbuf, _countof(itbuf), 10) ) {
															if ( _stricmp(itbuf, buf) != 0 ) {
																SendMessage( rctrls[i].hCtrl, EM_GETSEL, (WPARAM)&curx, NULL); // J[\ʒuQbg
																SetWindowText( rctrls[i].hCtrl, itbuf );
																SendMessage( rctrls[i].hCtrl, EM_SETSEL, (WPARAM)curx, (LPARAM)curx); // ŃQbgJ[\ʒuZbg
															}
														}
														free ( buf );

														// ͈̓`FbN
														buf = zalloc( bsize = GetWindowTextLength(rctrls[i].hCtrl) + 1 );
														if ( buf ) {
															UINT  iint, min, max;

															GetWindowText( rctrls[i].hCtrl, buf, bsize );
															iint = atou( buf );

															if ( rctrls[i].bit_max < rctrls[i].byte_min ) {
																// őEŏtɂȂĂꍇ
																min = rctrls[i].bit_max;
																max = rctrls[i].byte_min;
															}
															else {
																min = rctrls[i].byte_min;
																max = rctrls[i].bit_max;
															}

															if ( HIWORD(wParam) == EN_KILLFOCUS && iint < min ) {
																char itbuf[16];
																// ͓rōŏlɂȂ肪A݂͍ŏl̃`FbN̓tH[JXuԂ̂ݍs
																SendMessage( rctrls[i].hCtrl, EM_GETSEL, (WPARAM)&curx, NULL); // J[\ʒuQbg
																if ( 0 == _ultoa_s(min, itbuf, _countof(itbuf), 10) ) {
																	SetWindowText( rctrls[i].hCtrl, itbuf );
																}
																SendMessage( rctrls[i].hCtrl, EM_SETSEL, (WPARAM)curx, (LPARAM)curx); // ŃQbgJ[\ʒuZbg
															}
															else if ( iint > max ) {
																char itbuf[16];

																iint /= 10;
																if ( iint > max )
																	iint /= 10;

																SendMessage( rctrls[i].hCtrl, EM_GETSEL, (WPARAM)&curx, NULL); // J[\ʒuQbg
																if ( 0 == _ultoa_s(iint, itbuf, _countof(itbuf), 10) ) {
																	SetWindowText( rctrls[i].hCtrl, itbuf );
																}
																SendMessage( rctrls[i].hCtrl, EM_SETSEL, (WPARAM)curx, (LPARAM)curx); // ŃQbgJ[\ʒuZbg
															}

															free ( buf );
														}
													}
												}
												sflag = 0;
											}
										}

										if ( HIWORD(wParam) == EN_CHANGE ) {
											ctrlChange(hDlg, i);
										}
										break;
									}

									else if ( rctrls[i].ctrl == COMBO_CTRL ) { // R{{bNX
										if ( HIWORD(wParam) == CBN_SELCHANGE ) {
											ctrlChange(hDlg, i);
										}
										break;
									}

								}
							}
						
						}
						return 1;
				}
				break;
			}
	}
	return 0;
}

// G[bZ[Wpo
static void errout( HWND hWnd, const char *text, const char *text2, const char *text3 )
{
	char *szOuttext = zalloc( lstrlen(text) + lstrlen(text2) + lstrlen(text3) + 1 );

	if ( szOuttext ) {
		lstrcpy( szOuttext, text );
		lstrcat( szOuttext, text2 );
		lstrcat( szOuttext, text3 );

		destroy_splash_window();
		MessageBox(hWnd, szOuttext, "R-Script", MB_OK | MB_ICONEXCLAMATION);

		safefree( szOuttext );
	}
}

#if DEBUG_LOGMODE
void dout( const char *text ) //textt@C֏oifobOpj
{
	FILE *fp;

	if ( NULL != (fp = fopen( "debugout.txt", "at") ) ) {
		fputs(text, fp);
		fputs("\n", fp);
		fclose( fp );
	}
}
#endif /* DEBUG_LOGMODE */

// XNvg̓ǂݏoƉ (߂l 0:I 1:ُI 2:XNvg̒fw 3:labelŎw肵xȂ)
static short rsc_aux( HWND hWnd, const char *fname, const char *label, bool icall, void (*callbackfunc)() )
{
	short ra_rv = 0;
	char *rv = NULL;
	char buf[350];
	unsigned char f_var_must_def = 0;
	HICON	dialogIcon = NULL;		// _CAÕACRnh
	LOAD_RSC lr;
	list<RSCLINES>::const_iterator vrli, vrlend, vrlitmp;
	stack<list<RSCLINES>::const_iterator> gosub_stack;

	// \[X[hE͂
	if ( LR_OK != lr.source_load(fname) ) {
		destroy_splash_window();
		lr.errmes(hWnd);
		return 1;
	}

	// vC^vg
	if ( LR_OK != lr.pre_interprete() ) {
		destroy_splash_window();
		lr.errmes(hWnd);
		return 1;
	}

	// `̓ǂݏo
	{ 
		const char *p;
		char *fnameico = NULL;
		int len, ec;
		
		p = lr.searchItem( LR_SI_MUSTDEFVAR, "OFF", 0, ec );
		if ( 0 == _stricmp( p, "ON" ) || 0 == strcmp( p, "1" ) || 0 == _stricmp( p, "YES" ) )
			f_var_must_def = 1;
				
		len = lstrlen( fname );
		if ( len > 3 ) {
            fnameico = _strdup( fname );
			if ( fnameico ) {
				fnameico[len-3] = 'i';
				fnameico[len-2] = 'c';
				fnameico[len-1] = 'o';
			}
		}
		if ( fnameico == NULL ) {
            fnameico = _strdup( "none" );
		}

		p = lr.searchItem( LR_SI_ICON, fnameico, 0, ec );
		/**/ // vOt@C̎̏Ȃ
		LoadIconFromFileEx(p, NULL, &dialogIcon);
		if ( !dialogIcon ) {
			LoadIconFromFileEx(p, &dialogIcon, NULL);
		}
		safefree( fnameico );
	}

	vrlend = lr.vrl.end();
	if ( label ) { // labelw肳Ăꍇ͂̃x߂n߂
		if ( dialogIcon ) {
			DestroyIcon( dialogIcon );
		}
			
		vrli = lr.GoTo( label );
		if ( vrli == vrlend ) { // xȂꍇ
			return 3;
		}

		// :uninst, :try sꍇ́Aϐ͏
		if ( icall && (_stricmp(label, ":uninst") == 0 || _stricmp(label, ":try") == 0) ) {
			free_variables();	// ÕXNvgsŎgϐ̏
		}

		must_def_value( f_var_must_def ); // ϐ̏K{Ƃ邩ǂ͒`ɋK肳Ă
	}
	else { // labelw肳ĂȂꍇ́A擪߂n߂
		// 
		vrli = lr.vrl.begin();
		free_variables();	// ÕXNvgsŎgϐ̏
		addctrl(hWnd, AC_INIT, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0); // Rg[̒ǉJn
		system_refresh(GetParent(hWnd), hWnd, 0); // tbV@ɂė\Ă
		must_def_value( f_var_must_def ); // XNvgŕϐ̏K{Ƃ邩ǂ͒`ɋK肳Ă
		// _CAOփACR̐ݒ
		if ( !callbackfunc ) {
			SendMessage( hWnd, WM_SETICON, ICON_SMALL, (LPARAM)(dialogIcon?dialogIcon:hDefaultRscSmallIcon) );
		}
		else {
			if ( dialogIcon ) {
				DestroyIcon( dialogIcon );
			}
		}
	}

	// lexG[񕜂Ɏs邱Ƃ悤Ȃ̂Ń_~[̕
	interprete( hWnd, "DUMMY=0\n" ); 

	// R[obN֐̌Ăяo
	if ( callbackfunc ) {
		callbackfunc();
	}

	while( vrli != lr.vrl.end() ) {
		if ( vrli->line != "\n" ) {
			// destroy_splash_window();
			// char itbuf[16];
			// MessageBox( hWnd, sct[line_no], itoa10ex(line_no, itbuf), MB_OK); // Debug
			rv = interprete( hWnd, vrli->line.c_str() );

			// XNvgs Shift+Esc ꂽAf邩ǂK˂
			if ( (GetAsyncKeyState(VK_SHIFT)&0x8000) && (GetAsyncKeyState(VK_ESCAPE)&0x8000) ) {
				int r;
				char buf[300+MAX_PATH*2];

				wsprintf(buf, "%s%dsڂsłB\nShift+EscL[܂̂ŁAf̊mF܂B\n\nXNvg𐳏I(Exit)ꍇ[͂]A\nXNvgُI(Abort)ꍇ[]A\nfwāAXNvg̎spꍇ[LZ]ĉB", vrli->fname.c_str(), vrli->line_num );
				destroy_splash_window();
				r = MessageBox( hWnd, buf, "fmF", MB_YESNOCANCEL | MB_DEFBUTTON3 );
				if ( r == IDYES ) {
					rv = "exit";
				}
				else if ( r == IDNO ) {
					rv = "abort";
				}
			}
			if ( rv != NULL && rv[0] != 0 ) {
				if (rv[0] == ':') { // ':'Ŏn܂镶񂪕ԂĂlabelփWv
					if ( vrlend == (vrlitmp = lr.GoTo(rv)) ) {
						wsprintf(buf, "%s %d :\n", vrli->fname.c_str(), vrli->line_num);
						errout( hWnd, buf, rv, "\nx܂B" );
						ra_rv = 1;
						break;
					}
					else {
						vrli = vrlitmp;
						continue;
					}
				}
				else if ( strncmp(rv, "GOSUB :", 7) == 0 ) { // "GOSUB :"Ŏn܂镶񂪕ԂĂlabelփTu[`R[
					gosub_stack.push( vrli );

					if (vrlend == (vrlitmp = lr.GoTo(rv+6))) {
						wsprintf(buf, "%s %d :\n", vrli->fname.c_str(), vrli->line_num);
						errout( hWnd, buf, rv+6, "\nGOSUBx܂B" );
						ra_rv = 1;
						break;
					}
					else {
						vrli = vrlitmp;
						continue;
					}
				}
				else if ( strcmp(rv, "return") == 0 ) { // "return" ƕԂĂATu[`̋A
					if ( gosub_stack.empty() ) {
						wsprintf(buf, "t@C:%s %ds :\n", vrli->fname.c_str(), vrli->line_num);
						errout( hWnd, buf, "", "\nG[Fsreturn݂Ă܂B\n\nGOSUBĂȂԂreturng܂B" );
						ra_rv = 1;
						break;
					}
					else {
						vrli = gosub_stack.top();
						gosub_stack.pop();
					}
				}
				else if ( strcmp(rv, "nextline") == 0 ) { // "nextline" ƕԂĂA̍s͔΂(if΍)
					++vrli;
				}
				else if ( strcmp(rv, "exit") == 0 ) { // "exit" ƕԂĂAI
					ra_rv = 0;
					break; // I
				}
				else if ( strcmp(rv, "abort") == 0 ) { // "abort" ƕԂĂAf
					ra_rv = 2; // f
					break;
				}
				else { // ̑̃G[
					wsprintf(buf, "t@C:%s %ds :\n", vrli->fname.c_str(), vrli->line_num);
					errout( hWnd, buf, rv, "" );
					ra_rv = 1;
					break;
				}
			}
		}
		++vrli;
	}

	if ( !label && !callbackfunc ) { // s߂n߂̂ȂAI̋łɂ[OK][LZ]Ȃǂ̃{^̒ǉƁAIs
		addctrl(hWnd, AC_FINISH, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0); // I

		// uŋߎg@\ځv̈ꗗւ̒ǉ
		if (!bNotAddRecent) { // }~tOĂȂꍇ̂݁AǉiXVjs
			REG reg;
			int i;
			char s[20], s2[20], *name;
			char v[20], v2[20];

			if ( reg.OpenSubKey(HKEY_CURRENT_USER, RNSF7REGKEY, "R7RECENT", TREG_OPEN_CREATE) ) {
				for(i=1 ; i<=RECENTMAX ; ++i) {
					wsprintf(s, "r7r_item%d", i);
					name = reg.new_ReadString(s);

					if ( name == NULL ) {
						break;
					}
					else if ( strcmp(name, g_item) == 0 ) {
						safedelete(name);
						break;
					}
					safedelete(name);
				}

				for(; i>=2 ; --i) {
					wsprintf(s, "r7r_item%d", i-1);
					wsprintf(s2, "r7r_item%d", i);
					wsprintf(v, "r7r_rsc%d", i-1);
					wsprintf(v2, "r7r_rsc%d", i);

					reg.RenValue(s, s2);
					reg.RenValue(v, v2);
				}
				reg.WriteString("r7r_item1", g_item, TREG_NORMAL_SZ);
				reg.WriteString("r7r_rsc1",  rscname);

				reg.CloseKey();

				// uŋߎg@\ځvj[𑝌
				bR7recentChange = 1;
			}
			else {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[", "WXgL['HKEY_CURRENT_USER\\", RNSF7REGKEY, "\\R7RECENT",
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F", getLastErrorString(tRegGetLastError()), NULL);
			}
		}
	}

	return ra_rv; // I
}

// 1sXNvgsAʂ𐔒lŕԂ
unsigned int rsc1line( HWND hWnd, const char *script )
{
	char *order;

	free_variables();	// ÕXNvgsŎgϐ̏
	must_def_value( 0 );	// ϐ͕̏K{ƂȂ
	interprete( hWnd, "DUMMY=0\n" ); // _~[s

	order = zalloc( lstrlen(script) + 8 );
	if ( order ) {
		lstrcpy( order, "DUMMY=" );
		lstrcat( order, script );
		lstrcat( order, "\n" );
		interprete( hWnd, order );
		safefree( order );
	}

	return getVariable( "DUMMY" );
}

// rsc_aux() ́A" ň͂܂ꂽt@CłȂJgfBNgŒȂ̂ŁA邽߂̃JvZ֐
short rsc( HWND hWnd, const char *fname, const char *label, bool icall, void (*callbackfunc)() )
{
	static bool s; // Z}tH
	short rv = 1;

	if ( s == 0 ) {
		s = 1;
		{
			char *fname2 = NULL; // fname  " Ɉ͂܂Ăꍇ̉̈
			int  i;

			// " Ɉ͂܂ĂA" 菜
			if ( fname[0] == '\"' ) {
				fname2 = _strdup( fname + 1 );
				if ( fname2 ) {
					i = lstrlen( fname2 );
					if ( fname2[i-1] == '\"' )
						fname2[i-1] = 0;
				}
			}
			else {
				fname2 = _strdup( fname );
			}

			if ( fname2 ) {
				if( rnsf7RegRead("CDRSC", 0) == 1 && strchr(fname2, '\\' ) ) {
					// RSCt@ĈꏊJgfBNgƂ
					char oldcd[MAX_PATH*2], newcd[MAX_PATH*2];
					char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2];
			
					_splitpath_s(fname2, drv, _countof(drv), dir, _countof(dir), NULL, 0, NULL, 0);
					_makepath_s(newcd, _countof(newcd), drv, dir, NULL, NULL);
					GetCurrentDirectory( _countof(oldcd), oldcd );
					SetCurrentDirectory( newcd );
					rv = rsc_aux( hWnd, fname2, label, 0, NULL );
					SetCurrentDirectory( oldcd );
				}
				else {
					rv = rsc_aux( hWnd, fname2, label, icall, callbackfunc );
				}
				safefree( fname2 );
			}
		}
		s = 0;
	}
	return rv;
}



static HWND me_DlgWnd; // 2̊֐ł̂ݎg

// _CAÕXN[o[삳ꂽƂɁARg[Ĕzu
static BOOL CALLBACK ecwEnumFunc( HWND hChild, LPARAM lParam)
{
	RECT rt;
	POINT pt;

	if ( GetParent( hChild ) == me_DlgWnd ) { // EBhE͒TȂ
		GetWindowRect(hChild, &rt);
		pt.x = rt.left; pt.y = rt.top;
		ScreenToClient(me_DlgWnd, &pt);
		pt.y -= (int)lParam;
		SetWindowPos(hChild, 0, pt.x, pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOREDRAW);
	}
	return TRUE;
}

static void movectrl( HWND hWnd, int vsa, int vsb )
{
	// vsa:ړOyW, vsb:ړyW
	int dy = vsb - vsa;

	if (dy != 0) { // ړĕ`͂߂
		HDC     hdc, memdc;
		HBITMAP hbmp;
		RECT	rt, rt2;
		int     noQuickScrool;

		me_DlgWnd = hWnd;
		EnumChildWindows(hWnd, (WNDENUMPROC)ecwEnumFunc, (LPARAM)(vsb-vsa));
		noQuickScrool = rnsf7RegRead("NoQuickScrool", 0);

		switch ( noQuickScrool ) {
			case 2: // XN[o[̃hbOI_ōĕ`
			case 1:	// ɉʑŜĕ`悷
				InvalidateRect(hWnd, NULL, TRUE);
				break;

			case 0: // Kvȕĕ`悷邪AőOʃEBhE΍̂߂ɁAŏIIȍĕ`200msɃEBhEŜĕ`悷
				KillTimer( hWnd, R7OSSC_TIMERID );
				// Iɍĕ`悷
				GetClientRect(hWnd, &rt);

				hdc = GetDC( hWnd );
				memdc = CreateCompatibleDC( hdc );
				hbmp = CreateCompatibleBitmap(hdc, rt.right, rt.bottom);
				SelectObject(memdc, hbmp);

				rt2.left = 0;
				rt2.right = rt.right;

				if ( dy > 0 ) { // ւ̈ړ
					BitBlt(memdc, 0, 0, rt.right, rt.bottom-dy, hdc, 0, dy, SRCCOPY);
					BitBlt(hdc, 0, 0, rt.right, rt.bottom-dy, memdc, 0, 0, SRCCOPY);
					rt2.top = rt.bottom-dy;
					rt2.bottom = rt.bottom;
				}
				else { // ւ̈ړ( dy͕̐ )
					BitBlt(memdc, 0, 0, rt.right, rt.bottom+dy, hdc, 0, 0, SRCCOPY);
					BitBlt(hdc, 0, -dy, rt.right, rt.bottom, memdc, 0, 0, SRCCOPY);
					rt2.top = 0;
					rt2.bottom = -dy;
				}

				DeleteDC( memdc );
				DeleteObject(hbmp);
				ReleaseDC( hWnd, hdc );
				InvalidateRect(hWnd, &rt2, TRUE);

				// ̕`悪IWM_TIMERĂяoAʑŜĕ`悳
				// (_CAOɍőOʃEBhEƂ̑΍)
				SetTimer( hWnd, R7OSSC_TIMERID, R7OSSC_TIMERWAIT, NULL );
				break;
		}
	}
}

// Xgr[FACe̕ҏW(2J)
static bool listview_edit( HWND hWnd, int iCtrl )
{
	int m, n = GetLVCursor( rctrls[iCtrl].hCtrl );
	char *itemname, *itemdata;
	bool rv = false;

	if ( n == -1 ) {
		MessageBox(hWnd, "ҏWڂIĉB", "ҏW", MB_OK | MB_ICONSTOP);
		return false;
	}

	m = ListView_GetItemCount( rctrls[iCtrl].hCtrl );

	for(; n<m ; n++) {
		if ( LVIS_SELECTED == ListView_GetItemState(rctrls[iCtrl].hCtrl, n, LVIS_SELECTED) ) {
			itemname = lvGetItemString( rctrls[iCtrl].hCtrl, n, 0 );
			if ( itemname ) {
				itemdata = lvGetItemString( rctrls[iCtrl].hCtrl, n, 1 );
				if ( itemdata ) {
					if ( lv_edititem(hWnd, &itemname, &itemdata, rctrls[iCtrl].hCtrl, rctrls[iCtrl].def_sz, rctrls[iCtrl].text) ) {
						ListView_SetItemText(rctrls[iCtrl].hCtrl, n, 0, itemname);
						ListView_SetItemText(rctrls[iCtrl].hCtrl, n, 1, itemdata);
						SetFocus( rctrls[iCtrl].hCtrl );

						safefree( itemname );
						safefree( itemdata );
						rv = true;
					}
					else {
						safefree( itemname );
						safefree( itemdata );
						rv = false;
					}
				}
				else {
					MessageBox( hWnd, "ҏWɕKvȃ܂B", "ҏW", MB_OK | MB_ICONSTOP );
				}
				safefree( itemname );
			}
			else {
				MessageBox( hWnd, "ҏWɕKvȃ܂B", "ҏW", MB_OK | MB_ICONSTOP );
			}
		}
	}
	SetFocus( rctrls[iCtrl].hCtrl );

	return rv;
}

// Xgr[FACe̍폜(2J)
static bool listview_delete( HWND hWnd, int iCtrl )
{
	int n = GetLVCursor( rctrls[iCtrl].hCtrl ), i, j, m;
	char *str, *itemname;
	
	if ( n == -1 ) {
		MessageBox(hWnd, "폜ڂIĉB", "폜", MB_OK | MB_ICONSTOP);
		return false;
	}

	// ڂIĂȂ?
	j = 1;
	m = ListView_GetItemCount( rctrls[iCtrl].hCtrl );

	for(i=n+1 ; i<m ; i++) {
		if ( LVIS_SELECTED == ListView_GetItemState(rctrls[iCtrl].hCtrl, i, LVIS_SELECTED) ) {
			j++;
		}
	}

	if ( j == 1 ) {
		itemname = ListView_GetText( rctrls[iCtrl].id, n, 0 );
		if ( itemname ) {
			str = zalloc( lstrlen(itemname) + 30 );
			if ( str ) {
				wsprintf(str, " %s 폜܂B", itemname);
				safefree( itemname );
				if ( IDOK == MessageBox(hWnd, str, "폜", MB_OKCANCEL | MB_ICONQUESTION ) ) {
					SetFocus( rctrls[iCtrl].hCtrl );
					safefree(str);
					return ( TRUE == ListView_DeleteItem(rctrls[iCtrl].hCtrl, n) );
				}
				else {
					safefree(str);
					return false;
				}
			}

			safefree(itemname);
		}

		MessageBox( hWnd, "폜ɕKvȃ܂B", "폜", MB_OK | MB_ICONSTOP );
		return false;
	}
	else {
		char str[50];
		wsprintf(str, "%d̍ڂ폜܂B", j);
		if ( IDOK == MessageBox(hWnd, str, "폜", MB_OKCANCEL | MB_ICONQUESTION ) ) {
			SetFocus( rctrls[iCtrl].hCtrl );
			for(i=n ; i<m ; i++) {
				if ( LVIS_SELECTED == ListView_GetItemState(rctrls[iCtrl].hCtrl, i, LVIS_SELECTED) ) {
					if ( ListView_DeleteItem(rctrls[iCtrl].hCtrl, i) ) {
						m--;
						i--;
					}
				}
			}
			return true;
		}
		else {
			return false;
		}
	}
}

// Xgr[FACe̍쐬(2J)
static bool listview_new( HWND hWnd, int iCtrl )
{
	int n;
	char *itemname = NULL, *itemdata = NULL;
	LVITEM lvitem;

	if ( lv_edititem(hWnd, &itemname, &itemdata, rctrls[iCtrl].hCtrl, rctrls[iCtrl].def_sz, rctrls[iCtrl].text) ) {
		n = ListView_GetItemCount(rctrls[iCtrl].hCtrl);
		ListView_SetItemCount(rctrls[iCtrl].hCtrl, n+1);
		lvitem.mask = LVIF_TEXT;
		lvitem.iItem = n;
		lvitem.iSubItem = 0;
		lvitem.pszText = itemname;
		ListView_InsertItem(rctrls[iCtrl].hCtrl, &lvitem);
		ListView_SetItemText(rctrls[iCtrl].hCtrl,  n, 1, itemdata);
		ListView_SetItemState(rctrls[iCtrl].hCtrl, n, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
		SetFocus( rctrls[iCtrl].hCtrl );

		safefree( itemname );
		safefree( itemdata );
		return true;
	}
	else {
		return false;
	}
}

// Xgr[FACe̕ҏW(nJ)
static bool listview_n_edit( HWND hWnd, int iCtrl )
{
	bool rv = false;
	int  m, n = GetLVCursor( rctrls[iCtrl].hCtrl );

	if ( n == -1 ) {
		MessageBox(hWnd, "ҏWڂIĉB","ҏW",MB_OK | MB_ICONSTOP);
		return false;
	}

	m = ListView_GetItemCount( rctrls[iCtrl].hCtrl );

	for(; n<m ; n++) {
		if ( LVIS_SELECTED == ListView_GetItemState(rctrls[iCtrl].hCtrl, n, LVIS_SELECTED) ) {
			if ( lv_edititem_n( hWnd, rctrls[iCtrl].hCtrl, n, (char **)rctrls[iCtrl].text ) ) {
				rv = true;
			}
		}
	}
	SetFocus( rctrls[iCtrl].hCtrl );

	return rv;
}

// Xgr[FACe̍폜(nJ)
// 폜ɂẮA2Ĵ̂Ƃ邱Ƃ͕ςȂ߁A}NƂ
/*
static bool listview_n_delete( HWND hWnd, int iCtrl )
{
	
	return listview_delete( hWnd, iCtrl );
}*/

// Xgr[FACe̍쐬(nJ)
static bool listview_n_new( HWND hWnd, int iCtrl )
{
	bool rv;

	rv = lv_edititem_n( hWnd, rctrls[iCtrl].hCtrl, -1, (char **)rctrls[iCtrl].text );
	SetFocus( rctrls[iCtrl].hCtrl );

	return rv;
}

// Xgr[piႤprłǂǁj
// id  : Ŏn܂ĂāA alabel tāA̖Õx݂ĂÃxĂяo
static short galabel( HWND hWnd, const char *rscname, const char *id, const char *alabel )
{
	if ( id[0] == ':' ) { // IDxA _EDIT txփWv
		char *lvelabel = zalloc( lstrlen(id) + lstrlen(alabel) + 1 );

		if ( lvelabel ) {
			int rrv;

			lstrcpy( lvelabel, id );
			lstrcat( lvelabel, alabel );
			rrv = rsc( hWnd, rscname, lvelabel, 0, NULL );
			safefree( lvelabel );

			return (short)rrv;
		}

		return 1; // s
	}

	return 0; // xł͂Ȃꍇ͐IƂȂ
}

// Xgr[F\[gɌĂяo֐(R[obN֐)
static int CALLBACK listview_pfnCompare(LPARAM lParam1, LPARAM lParam2, LPARAM)
{
	return strcmp((char *)lParam1, (char *)lParam2);
}
