// ItemProp.cpp :
// ACẽvpeB

#include "stdafx.h"
#include "RNSF7.h"
#include "MainWindow.h"
#include "refresh.h"
#include "ItemProp.h"
#include "MainListview.h"
#include "commfunc.h"
#include "pre_interprete.h"

static LPMLVI pmlvi;

static const struct DEFTOOLTIP vertooltips[] = {
	{IDC_EDIT_FNAME, "XNvgt@C̃tpX"}, 
	{IDC_EDIT_ITEM , "̋@\ڂ̖(Item)"},
	{IDC_EDIT_INFO , "̋@\ڂ̐(Information)"},
	{IDC_EDIT_ICON , "̋@\ڂ̃ACR̃t@CƔԍ(Icon)"},
	{IDC_EDIT_HELP , "wvt@C܂̓wv̕\@(Help)"},
	{IDC_EDIT_AUTH , "̋@\ڂ̍Җ(Author)"},
	{IDC_EDIT_URL  , "̋@\ڂ̐쌳URL(URL)"},
	{IDC_EDIT_CATE , "̋@\ڂ̃JeS(Category)"},
	{IDC_EDIT_TRY  , SOFTWARENAME"NɁACEBhËꗗɕԏ(Try)"},
	{IDC_EDIT_MUST , "`MustDefVar̒l"},
	{IDC_EDIT_SIZE , "XNvgt@C̑傫(oCgP)"},
	{IDC_EDIT_FTIME, "̃t@C̍ŏIXV(^CX^v)"},
	{IDC_EDIT_CTIME, "̃t@Cŏɍ쐬ꂽ"},
	{IDC_EDIT_ATIME, "̃t@CŌɃANZXꂽ"},
	{IDC_EDIT_INC  , "̃XNvgt@C荞łTuXNvgt@C̈ꗗ(Include)"},
	{IDC_EDIT_ATTR , "XNvgt@C̑\n(A:A[JCuAC:kAE:ÍAH:BAO:ItCAR:ǍpAS:VXeAT:ꎞ)"},
	{IDCANCEL,  "̃_CAO܂"},
	{0,0}};

// Xe[^Xo[ɑ郁bZ[W
LRESULT CALLBACK ItemPropProc(HWND hDlg, UINT mes, WPARAM wParam, LPARAM)
{
	switch (mes) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// if ( rnsf7RegRead("NoDefFont", 0) == 0 ) {
			//	SetChildWindowFont( hDlg );
			// }
			makeToolTip(hDlg, vertooltips);
			SendDlgItemMessage( hDlg, IDC_STATIC_ICON, STM_SETICON, (WPARAM)(pmlvi->hicon      ? pmlvi->hicon      :
	                                                                         pmlvi->hSmallIcon ? pmlvi->hSmallIcon :
	                                                                         hDefaultRscIcon), NULL);
			{
				char *title, *tmp;

				title = _strdup( pmlvi->rsc_fname );
				tmp = realloc_strcat( title, "̃vpeB" );
				if ( tmp ) {
					title = tmp;
				}
				SetWindowText( hDlg, title );
                safefree( title );
			}

			// łɎ擾ς݂̊e̕\
			{
				char fname[MAX_PATH*2];
				LPTSTR pfname;

				lstrcpy( fname, pmlvi->rsc_fname );
				GetFullPathName( pmlvi->rsc_fname, _countof(fname), fname, &pfname );
				SetDlgItemText( hDlg, IDC_EDIT_FNAME, fname );
			}

			{
				// `̓ǂݏo
				LOAD_RSC lr;
				int      ec;

				if ( LR_OK == lr.source_load(pmlvi->rsc_fname) ) {
					lr.searchItem(LR_SI_LOAD, 0, 0, ec);
					if ( ec == LR_OK ) {
						SetDlgItemText( hDlg, IDC_EDIT_ITEM , pmlvi->item );
						SetDlgItemText( hDlg, IDC_EDIT_INFO , pmlvi->info );
						SetDlgItemText( hDlg, IDC_EDIT_ICON , lr.searchItem(LR_SI_ICON, "", 0, ec) );
						SetDlgItemText( hDlg, IDC_EDIT_HELP , pmlvi->help );
						SetDlgItemText( hDlg, IDC_EDIT_AUTH , pmlvi->author );
						SetDlgItemText( hDlg, IDC_EDIT_URL  , pmlvi->url );
						SetDlgItemText( hDlg, IDC_EDIT_CATE , pmlvi->category );
						SetDlgItemText( hDlg, IDC_EDIT_TRY  , lr.searchItem(LR_SI_TRY, "", 0, ec) );
						SetDlgItemText( hDlg, IDC_EDIT_MUST , lr.searchItem(LR_SI_MUSTDEFVAR, "", 0, ec) );

						char sbuf[60], cmbuf[16];

						wsprintf(sbuf, "%soCg (%sKB)", commaex(pmlvi->fsize, cmbuf), comma((0 < pmlvi->fsize && pmlvi->fsize < 2048)?1:pmlvi->fsize/1024));
						SetDlgItemText( hDlg, IDC_EDIT_SIZE , sbuf );

						char *includes = NULL, *tmp;
						const char *p;
						int i = 0;

						while ( NULL != (p = lr.searchItem(LR_SI_INCLUDE, NULL, i++, ec)) ) {
							if ( i > 1 ) {
								tmp = realloc_strcat( includes, ", " );
								if ( tmp ) {
									includes = tmp;
								}
							}
							tmp = realloc_strcat( includes, p );
							if ( tmp ) {
								includes = tmp;
							}
						}
						if ( includes ) {
							SetDlgItemText( hDlg, IDC_EDIT_INC , includes );
							safefree(includes);
						}
						else {
							SetDlgItemText( hDlg, IDC_EDIT_INC , "Ȃ" );
						}
					}
				}
			}

			// 擾ĂȂ̕\i炽Ƀt@C擾j
			{
				char szTimeDate[80], szAttrStr[80];
				SYSTEMTIME st;
				WIN32_FIND_DATA520 wfd;
				HANDLE hFind;

				// VXe^CɕϊĂ當ɕϊ
				FileTimeToSystemTime(&(pmlvi->ft), &st);
				wsprintf(szTimeDate, "%4d/%2d/%2d %2d:%02d:%02d", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wDay );
				SetDlgItemText( hDlg, IDC_EDIT_FTIME, szTimeDate );

				// 쐬ƃANZX̓t@C擾
				hFind = FindFirstFile520( pmlvi->rsc_fname, &wfd );
				if ( hFind != INVALID_HANDLE_VALUE) {
					FileTimeToSystemTime(&(wfd.ftCreationTime), &st);
					wsprintf(szTimeDate, "%4d/%2d/%2d %2d:%02d:%02d", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wDay );
					SetDlgItemText( hDlg, IDC_EDIT_CTIME, szTimeDate );

					FileTimeToSystemTime(&(wfd.ftLastAccessTime), &st);
					wsprintf(szTimeDate, "%4d/%2d/%2d %2d:%02d:%02d", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wDay );
					SetDlgItemText( hDlg, IDC_EDIT_ATIME, szTimeDate );

					FindClose( hFind );

					// t@C̎擾
					szAttrStr[0] = 0;
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_ARCHIVE ) {
						lstrcat(szAttrStr, "A\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_COMPRESSED ) {
						lstrcat(szAttrStr, "C\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY ) {
						lstrcat(szAttrStr, "D\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_ENCRYPTED ) {
						lstrcat(szAttrStr, "E\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN ) {
						lstrcat(szAttrStr, "H\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_OFFLINE ) {
						lstrcat(szAttrStr, "O\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_READONLY ) {
						lstrcat(szAttrStr, "R\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_SYSTEM ) {
						lstrcat(szAttrStr, "S\r\n");
					}
					if ( wfd.dwFileAttributes&FILE_ATTRIBUTE_TEMPORARY ) {
						lstrcat(szAttrStr, "T\r\n");
					}
					SetDlgItemText( hDlg, IDC_EDIT_ATTR, szAttrStr );
				}
				else {
					char *perrmes = getLastErrorString(GetLastError());

					SetDlgItemText( hDlg, IDC_EDIT_CTIME, perrmes );
					SetDlgItemText( hDlg, IDC_EDIT_ATIME, perrmes );
				}
			}

			return 1;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDCANCEL:
                    EndDialog(hDlg, 2);
					return 1;
			}
			break;
	}
	return 0;
}

int openItemProp(HWND hWnd, const LPMLVI _pMlvi)
{
	pmlvi = _pMlvi;
	return (int)DialogBox(hInst, (LPCSTR)IDD_ITEMPROP, hWnd, (DLGPROC)ItemPropProc);
}
