/*
	symbol.h
	^ϐ/^ϐ̎舵
*/

#include "stdafx.h"
#include "symbol.h"
#include "token.h"
#include "addctrl.h"
#include "splash.h"
#include "function.h"

typedef struct {  // ^ϐ
	char *name;
	unsigned int integer;
} VARIABLE, *PVARIABLE;

typedef struct {  // ^ϐ
	char *name;
	char *text;
} VARIABLE_D, *PVARIABLE_D;

unsigned int nsyms = 0;			// ^ϐ̐
unsigned int nsyms_d = 0;		// ^ϐ̐
unsigned int nsyms_a = 0;		// ^z̐
unsigned int nsyms_d_a = 0;		// ^z̐

static unsigned char flag_must_def_value;	// złȂϐ͗p̑OɑKv

PVARIABLE     variables = NULL;			// ^ϐ
PVARIABLE_D   variables_d = NULL;		// ^ϐ
PVARIABLE_A   variables_a = NULL;		// ^z
PVARIABLE_D_A variables_d_a = NULL;		// ^z

typedef struct {		// ϐ(萔)
	const char name[32];
	unsigned int cvalue;
} CVALUES, *PCVALUES;

CVALUES cvalues[] = { // ϐ̈ꗗBAt@xbgɃ\[gĂ
	 { "cb_dword",							CB_DWORD },
	 { "check_dword",						CHECK_DWORD },
	 { "check_sz01",						CHECK_SZ01 },
	 { "check_sztf",						CHECK_SZTF },
	 { "check_szyn",						CHECK_SZYN },
	 { "ctrl_needadmin",					CTRL_NEEDADMIN },
	 { "ctrl_noeffect",						CTRL_NOEFFECT },
	 { "ctrl_normal",						CTRL_NORMAL },
	 { "ctrl_notify",						CTRL_NOTIFY },
	 { "ctrl_reboot",						CTRL_REBOOT },
	 { "ctrl_refresh",						CTRL_REFRESH },
	 { "delete_default",					DELETE_DEFAULT },
//	 { "dummy",								0 },	// ϐ̋ύXɂO[2006/10/23]
	 { "edit_binary",						EDIT_BINARY },
	 { "edit_button",						EDIT_BUTTON },
	 { "edit_default",						EDIT_DEFAULT },
	 { "edit_filename",						EDIT_FILENAME },
	 { "edit_folder",						EDIT_FOLDER },
	 { "edit_password",						EDIT_PASSWORD },
	 { "edit_readonly",						EDIT_READONLY },
	 { "edit_sz",							EDIT_SZ },
	 { "error",								ERRORVALUE },
	 { "errorvalue",						ERRORVALUE },
	 { "false",								FALSE },
	 { "iever",								0 },	// IEVersion (ォ)
	 { "isnt",								0 },	// isNT (ォ)
	 { "lowvalue",							MININTEGER },
	 { "lv_delete_novalue",					LV_DELETE_NOVALUE },
	 { "lv_dword",							LV_DWORD },
	 { "lv_middle",							LV_MIDDLE },
	 { "lv_multiselect",					LV_MULTISELECT },
	 { "lv_small",							LV_SMALL },
	 { "lv_sortheader",						LV_SORTHEADER },
	 { "maxinteger",						MAXINTEGER },
	 { "maybe_expand",						MAYBE_EXPAND },
	 { "mininteger",						MININTEGER },
	 { "nil",								0 },
	 { "no",								0 },
	 { "nothing",							0 },
	 { "nul",								0 },
	 { "null",								0 },
	 { "reg_binary",						REG_BINARY },
	 { "reg_dword",							REG_DWORD },
	 { "reg_dword_big_endian",				REG_DWORD_BIG_ENDIAN },
	 { "reg_dword_little_endian",			REG_DWORD_LITTLE_ENDIAN },
	 { "reg_expand_sz",						REG_EXPAND_SZ },
	 { "reg_full_resource_descriptor",		REG_FULL_RESOURCE_DESCRIPTOR },
	 { "reg_link",							REG_LINK },
	 { "reg_multi_sz",						REG_MULTI_SZ },
	 { "reg_none",							0 },
	 { "reg_qword",							REG_QWORD },
	 { "reg_qword_little_endian",			REG_QWORD_LITTLE_ENDIAN },
	 { "reg_resource_list",					REG_RESOURCE_LIST },
	 { "reg_resource_requirements_list",	REG_RESOURCE_REQUIREMENTS_LIST },
	 { "reg_sz",							REG_SZ },
	 { "sz_expand",							SZ_EXPAND },
	 { "true",								TRUE },
	 { "winver",							0 },	// WinVer (ォ)
	 { "yes",								1 },
	 { "zero",								0 }
};
/*
ϐɂ
--------------------
ϐ́A萔񋟂邽߂̕ϐłAvOJnɏ܂B
ϐ̓ǂݏosƂ́Auʏϐvuϐv̏ɃT[`s܂B
ϐ̓At@xbgɃɊi[ĂAoCiT[`Ō܂B
ϐ̏osƂ́Aʏϐ̃T[`݂̂sAϐȂꍇ
ႦꂪϐƓOłƂĂAʏϐƂď܂B
ϐ̓ǂݏo͒ʏϐD悳܂̂ŁȀꍇAϐ̒l͖悤ɂȂ܂B
iȑÕo[Wł́Aϐ̃GAɏ݂sĂ̂łA
@ϐɂ鎞ԂAݒ莞ɏϐT[`̂ɂ鎞Ԃ
@lAO܂BʂƂĂ͓͓ɂȂ̂Łj
*/


// ^FV{ľ (FɂϐA߂l NO_VALUE : ݂Ȃ)
static unsigned symlook( const char *s )
{
	unsigned int i;

	if ( s ) {
		for(i=0 ; i<nsyms ; ++i) {
			if( strcmp(variables[i].name, s) == 0 ) { // 
				return i;	// gpς݂̕ϐ̏ꍇ́Aԍ(0`nsyms-1)Ԃ
			}
		}
	}

	return NO_VALUE;
}

// ^FV{ľ (FɂϐA߂l NO_VALUE : ݂Ȃ)
static unsigned symlook_d( const char *s )
{
	unsigned int i;

	if ( s ) {
		for(i=0 ; i<nsyms_d ; ++i) {
			if( strcmp(variables_d[i].name, s) == 0 ) { // 
				return i;	// gpς݂̕ϐ̏ꍇ́Aԍ(0`nsyms_d-1)Ԃ
			}
		}
	}

	return NO_VALUE;
}

// ^zFV{ľ (FɂϐA߂l NO_VALUE : ݂Ȃ)
static unsigned symlook_a( const char *s )
{
	unsigned int i;

	if ( s ) {
		for(i=0 ; i<nsyms_a ; ++i) {
			if( strcmp(variables_a[i].name, s) == 0 ) { // 
				return i;	// gpς݂̕ϐ̏ꍇ́Aԍ(0`nsyms_a-1)Ԃ
			}
		}
	}

	return NO_VALUE;
}

// ^zFV{ľ (FɂϐA߂l NO_VALUE : ݂Ȃ)
static unsigned symlook_d_a( const char *s )
{
	unsigned int i;

	if ( s ) {
		for(i=0 ; i<nsyms_d_a ; ++i) {
			if( strcmp(variables_d_a[i].name, s) == 0 ) { // 
				return i;	// gpς݂̕ϐ̏ꍇ́Aԍ(0`nsyms_d_a-1)Ԃ
			}
		}
	}

	return NO_VALUE;
}

// ^Fϐ̓e𓾂
unsigned int getVariable( const char *s )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
		int s_len = lstrlen(s);
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook( s_lc );	// łɎgpς݂̕ϐǂ𒲂ׂ

		if ( r == NO_VALUE ) {

			// ɏϐ(萔ϐ)T
			PCVALUES pcvalue = (PCVALUES)bsearch(s_lc, cvalues, _countof(cvalues), sizeof(CVALUES), strcmp);

			safefree(s_lc);

			if ( pcvalue ) {
				return pcvalue->cvalue;
			}

			// ϐȂ
			if ( flag_must_def_value ) { // ǂݏoɐݒvꍇ
				char *mes = malloc( s_len + 200 );

				if ( mes ) {
					wsprintf( mes, "̃XNvgŗpĂϐ%śAȂ܂ܓǂݏoĂ܂B\n(XNvg`MustDefVarLɂȂĂ邽߁Ǎxo͂Ă܂)", s);
					destroy_splash_window();
					MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
					safefree( mes );
				}
			}

			return 0;	// OK gp̕ϐ̏ꍇ͋Ƃ݂Ȃ0Ԃ
		}
		else {
			safefree(s_lc);
			return variables[r].integer; // OK gpς݂̕ϐ̏ꍇ͂̒gԂ
		}
	}
	else {
		MessageBox( NULL, "getVariable: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}
}

// ^zFϐ̓e𓾂( s:ϐ i:Y(0-) v:li[, ߂l 0: 1:s)
unsigned int getVariable_a( const char *s, unsigned int i, unsigned int *v )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_a( s_lc );	// łɎgpς݂̕ϐǂ𒲂ׂ
		safefree(s_lc);

		if ( r == NO_VALUE || v == NULL) {
			return 1;		// NG 錾̔z or G[
		}
		else {
			if ( i >= variables_a[r].num ) {
				return 1;	// NG z̗vfԍ̎wԈႢ
			}
			else {
				*v = variables_a[r].pinteger[i];
				return 0;	// OK 
			}
		}
	}
	else {
		MessageBox( NULL, "getVariable_a: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 1;			// NG s
	}
}

// ^Fϐ̓e𓾂
char *getVariable_d( const char *s )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
		int s_len = lstrlen(s);
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_d( s_lc );	// łɎgpς݂̕ϐǂ𒲂ׂ
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			if ( flag_must_def_value ) {
				char *mes = malloc( s_len + 200 );

				if ( mes ) {
					wsprintf( mes, "̃XNvgŗpĂϐ%śAȂ܂ܓǂݏoĂ܂B\n(XNvg`MustDefVarLɂȂĂ邽߁Ǎxo͂Ă܂)", s);
					destroy_splash_window();
					MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
					safefree( mes );
				}
			}
			return ""; // OK ϐȂ΁A̕ϐłƂ݂Ȃ
		}
		else {
			return variables_d[r].text; // OK ϐ΁A̕ϐ̒gԂ
		}
	}
	else {
		MessageBox( NULL, "getVariable_d: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return "";		// NG s
	}
}

// ^zFϐ̓e𓾂( s:ϐ i:Y(0-) ߂l NULL:s NULLȊO:)
char *getVariable_d_a( const char *s, unsigned int i )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_d_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return NULL; // NG 錾ĂȂz
		}
		else {
			if ( i >= variables_d_a[r].num ) {
				return NULL; // NG z̗vfԍ̎wԈႢ
			}
			else {
				return variables_d_a[r].ptext[i]; // OK 
			}
		}
	}
	else {
		MessageBox( NULL, "getVariable_d_a: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NULL;			// NG s
	}
}

// ^Fϐɏ
unsigned int setVariable( const char *s, unsigned int new_i )
{
	unsigned r;			// ϐԍ
	PVARIABLE tmp;		// z̃ĝ߂̃e||C^
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook( s_lc );

		if ( r == NO_VALUE ) {
			// ϐ݂ĂȂ΍쐬
			if ( nsyms >= 0xffffffff/sizeof(VARIABLE) ) {
				safefree(s_lc);
				return 1; // gpłϐ̐̌E
			}
			tmp = realloc(variables, (nsyms+1)*sizeof(VARIABLE));
			if ( tmp == NULL ) {
				safefree(s_lc);
				return 1; // NG ̈mۂłȂ
			}
			else {
				variables = tmp;
				variables[nsyms].name = s_lc;
				variables[nsyms].integer = new_i;
				++nsyms;
				return 0; // OK 
			}		
		}
		else {
			safefree(s_lc);
			variables[r].integer = new_i;
			return 0; // OK 
		}
	}
	else {
		MessageBox( NULL, "setVariable: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 1;			// NG s
	}
}

// ^zFϐɏ
unsigned int setVariable_a( const char *s, unsigned int i, unsigned int new_i )
{
	unsigned r;			// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return 1; // NG 錾ĂȂz
		}
		else {
			if ( i >= variables_a[r].num )
				return 1; // NG z̗vfԍ̎wԈႦĂ
			variables_a[r].pinteger[i] = new_i;
			return 0; // OK 
		}
	}
	else {
		MessageBox( NULL, "setVariable_a: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 1;	// NG s
	}
}

// ^Fϐɏ
unsigned int setVariable_d( const char *s, const char *new_text )
{
	unsigned r;			// ϐԍ
	PVARIABLE_D tmp;	// z̃ĝ߂̃e||C^
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_d( s_lc );

		if ( r == NO_VALUE ) { // ϐ݂ĂȂ΍쐬
			if ( nsyms_d >= 0xffffffff/sizeof(VARIABLE_D) ) {
				safefree(s_lc);
				return 1; // gpłϐ̐̌E
			}
			tmp = realloc(variables_d, (nsyms_d+1)*sizeof(VARIABLE_D));
			if ( tmp == NULL ) {
				safefree(s_lc);
				return 1; // NG ̈̊mۂɎs
			}
			else {
				variables_d = tmp;
				variables_d[nsyms_d].name = s_lc;
				variables_d[nsyms_d].text = _strdup( new_text );

				if ( variables_d[nsyms_d].text == NULL) {
					safefree( s_lc );
					return 1; // NG ̈̊mۂɎs
				}
				else {
					++nsyms_d;
					return 0; // OK 
				}
			}		
		}
		else {
			safefree( s_lc );
			safefree( variables_d[r].text );
			variables_d[r].text = _strdup( new_text );
			if ( variables_d[r].text ) {
				return 0; // OK 
			}
			else {
				return 1; // NG Ȃ
			}
		}
	}
	else {
		MessageBox( NULL, "setVariable_d: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 1;	// NG s
	}
}

// ^zFϐɏ
unsigned int setVariable_d_a( const char *s, unsigned int i, const char *new_text )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_d_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return 1; // NG 錾ĂȂz
		}
		else {
			if ( i >= variables_d_a[r].num ) {
				return 1; // NG z̗vfԍ̎wԈႦĂ
			}
			safefree( variables_d_a[r].ptext[i] );
			variables_d_a[r].ptext[i] = _strdup( new_text );
			if ( variables_d_a[r].ptext[i] ) {
				return 0; // OK 
			}
			else {
				return 1; // NG Ȃ
			}
		}
	}
	else {
		MessageBox( NULL, "setVariable_d_a: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 1;	// NG s
	}
}

// ^Fϐɒǉŏ (+=Zq΍)
unsigned int addVariable_d( const char *s, const char *add_text )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )
		r = symlook_d( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) { // ϐ݂ĂȂꍇ́A󕶎ւ̒ǉƂ݂Ȃ
			return setVariable_d( s, add_text );
		}
		else {
			char *tmp, *addcopy;

			addcopy = _strdup( add_text ); // |C^Ƃ variables_d[r].text == add_text ƂƂ蓾̂
			if ( addcopy == NULL ) {
				return 1; // NG ̈̊mۂɎs
			}

			tmp = realloc( variables_d[r].text, strlen(variables_d[r].text) + strlen(add_text) + 1 );

			if ( tmp == NULL ) {
				safefree( addcopy );
				return 1; // NG ̈̊mۂɎs
			}
			else {
				variables_d[r].text = lstrcat(tmp, addcopy);
				safefree( addcopy );
				return 0; // OK 
			}
		}
	}
	else {
		MessageBox( NULL, "addVariable_d: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 1;	// NG s
	}
}

// ^zFϐɒǉŏ (+=Zq΍)
unsigned int addVariable_d_a( const char *s, unsigned int i, const char *add_text )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )
		r = symlook_d_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return 1;	// NG:z񂪐錾ĂȂ
		}
		else {
			char *tmp, *addcopy;

			if ( i >= variables_d_a[r].num ) {
				return 1; // NG z̗vfԍ̎wԈႦĂ
			}

			addcopy = _strdup( add_text ); // |C^Ƃ variables_d_a[r].ptext[i] == add_text ƂƂ蓾̂
			if ( addcopy == NULL ) {
				return 1; // NG ̈̊mۂɎs
			}

			tmp = realloc( variables_d_a[r].ptext[i], strlen(variables_d_a[r].ptext[i]) + strlen(add_text) + 1 );

			if ( tmp == NULL ) {
				safefree( addcopy );
				return 1; // NG ̈̊mۂɎs
			}
			else {
				variables_d_a[r].ptext[i] = lstrcat(tmp, addcopy);
				safefree( addcopy );
				return 0; // OK 
			}
		}
	}
	else {
		MessageBox( NULL, "addVariable_d_a: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return 1;	// NG s
	}
}

// vOJnɌĂяoAIɕω鏉ϐ̐ݒ
void first_init_constvalues( void )
{
	PCVALUES pcvalue;

	// isNT̏iisNT : Windows  NTnłȂBNTnȂ1AłȂȂ0j
	pcvalue = bsearch("isnt", cvalues, _countof(cvalues), sizeof(CVALUES), strcmp);
	if (pcvalue) {
		pcvalue->cvalue = (unsigned int)isNT;
	}
	else {
		MessageBox(NULL, "(const)isNT܂BJւAB", "R-Script Initializer", MB_OK | MB_ICONEXCLAMATION);
	}

	// WinVeȑiWinVer : Windows ̃o[Wԍ ~100 +  ŕ\j
	pcvalue = bsearch("winver", cvalues, _countof(cvalues), sizeof(CVALUES), strcmp);
	if (pcvalue) {
		pcvalue->cvalue = (unsigned int)winver;
	}
	else {
		MessageBox(NULL, "(const)WinVer܂BJւAB", "R-Script Initializer", MB_OK | MB_ICONEXCLAMATION);
	}

	// IEVeȑiIEVer : Internet Explorer̃o[Wԍ̐j
	pcvalue = bsearch("iever", cvalues, _countof(cvalues), sizeof(CVALUES), strcmp);
	if (pcvalue) {
		pcvalue->cvalue = (unsigned int)iever;
	}
	else {
		MessageBox(NULL, "(const)IEVer܂BJւAB", "R-Script Initializer", MB_OK | MB_ICONEXCLAMATION);
	}
}

// ׂĂ̕ϐNA
void free_variables( void )
{
	unsigned int i;

	if( nsyms ) {
		for(i=0 ; i<nsyms ; ++i) {
			safefree( variables[i].name );
		}
		safefree( variables );
		nsyms = 0;
	}

	if( nsyms_d ) {
		for(i=0 ; i<nsyms_d ; ++i) {
			safefree( variables_d[i].text );
			safefree( variables_d[i].name );
		}
		safefree( variables_d );
		nsyms_d = 0;
	}

	if( nsyms_a ) {
		for(i=0 ; i<nsyms_a ; ++i) {
			safefree( variables_a[i].pinteger );
			safefree( variables_a[i].name );
		}
		safefree( variables_a );
		nsyms_a = 0;
	}

	if( nsyms_d_a ) {
		for(i=0 ; i<nsyms_d_a ; ++i) {
			if ( variables_d_a[i].ptext ) {
				unsigned int n;

				for(n=0 ; n<variables_d_a[i].num ; ++n ) {
					safefree( variables_d_a[i].ptext[n] );
				}
				safefree( variables_d_a[i].ptext );
			}
			safefree( variables_d_a[i].name );
		}
		safefree( variables_d_a );
		nsyms_d_a = 0;
	}

	must_def_value( 0 ); // złȂϐ́Ap̑ȎsKv͂Ȃij

	// t@CI[v[heLXg^VO[h֖߂
	fmode_bin = fmode_wide = 0;
}

void must_def_value( unsigned char onoff )
{
	 flag_must_def_value = onoff;
}

// ^zm ( 0 ` n-1 )
unsigned int array_variables( const char *s, unsigned int n )
{
	char *s_lc;			// ϐ

	if ( n >= 0xffffffff/sizeof(unsigned int) || nsyms_a >= 0xffffffff/sizeof(VARIABLE_A) ) {
		return 1; // NG E𒴂zvf
	}

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		if ( NO_VALUE != symlook_a( s_lc ) ) {
			safefree(s_lc);
			return 1; // NG 錾ς݂̔zϐ
		}
		else if ( n == 0 ) {
			safefree(s_lc);
			return 0; // OK vꂽ̈̑傫[ꍇ́AȂ       
		}
		else {
			PVARIABLE_A tmp;

			tmp = (VARIABLE_A *)realloc(variables_a, (nsyms_a+1)*sizeof(VARIABLE_A));
			if ( tmp == NULL ) {
				safefree(s_lc);
				return 1; // NG ̈mۂłȂ
			}
			else {
				variables_a = tmp;
				variables_a[nsyms_a].name = s_lc;

				variables_a[nsyms_a].num = n;
				variables_a[nsyms_a].pinteger = (unsigned int *)calloc( n, sizeof(unsigned int) );
				if ( variables_a[nsyms_a].pinteger ) {
					++nsyms_a;
					return 0; // OK 
				}
				else {
					safefree(s_lc);
					return 1; // NG ̈mۂłȂ
				}
			}
		}
	}
	else {
		MessageBox( NULL, "array_variables: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NO_VALUE;	// NG s
	}
}

// ^zm ( 0 ` n-1 )
unsigned int array_variables_d( const char *s, unsigned int n )
{
	char *s_lc;			// ϐ

	if ( n >= 0xffffffff/sizeof(char *) || nsyms_d_a >= 0xffffffff/sizeof(VARIABLE_D_A) ) {
		return 1; // NG E𒴂zvf
	}

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		if ( NO_VALUE != symlook_d_a( s_lc ) ) {
			safefree(s_lc);
			return 1; // NG 錾ς݂̕ϐ
		}
		else if ( n == 0 ) {
			safefree(s_lc);
			return 0; // OK vꂽ̈̑傫[ꍇ́AȂ       
		}
		else {
			PVARIABLE_D_A tmp;

			tmp = (PVARIABLE_D_A)realloc(variables_d_a, (nsyms_d_a+1)*sizeof(VARIABLE_D_A));
			if ( tmp == NULL ) {
				safefree(s_lc);
				return 1; // NG ̈mۂłȂ
			}
			else {
				variables_d_a = tmp;
				variables_d_a[nsyms_d_a].num = n;
				variables_d_a[nsyms_d_a].name = s_lc;
				variables_d_a[nsyms_d_a].ptext = (char **)calloc( n, sizeof(char *) );
				if ( variables_d_a[nsyms_d_a].ptext ) {
					// mۂꂽẑׂĂ "" Ă
					unsigned int i;

					for(i=0 ; i<n ; ++i) {
						variables_d_a[nsyms_d_a].ptext[i] = _strdup( "" );
						if ( variables_d_a[nsyms_d_a].ptext[i] == NULL ) {
							// ̈mۂłȂ
							do {
								safefree( variables_d_a[nsyms_d_a].ptext[--i] );
							} while( i > 0 );
							safefree(variables_d_a[nsyms_d_a].ptext);
							safefree(s_lc);
							return 1; // NG ̈mۂłȂ
						}
					}

					++nsyms_d_a;
					return 0; // OK 
				}
				else {
					safefree(s_lc);
					return 1; // NG ̈mۂłȂ
				}
			}
		}
	}
	else {
		MessageBox( NULL, "array_variables_d: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NO_VALUE;	// NG s
	}
}

// ^zTCY ( 0 ` n-1 )
unsigned int resize_variables( const char *s, unsigned int n )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	if ( n >= 0xffffffff/sizeof(unsigned int) ) {
		return 1; // NG E𒴂zvf
	}

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return array_variables(s, n); // 錾̔z񂾂ꍇ́A錾
		}
		else {
			unsigned int *tmp;
			unsigned int i;

			if ( n > variables_a[r].num ) { // z񂪑Ȃꍇ
				tmp = (unsigned int *)realloc( variables_a[r].pinteger, n*sizeof(unsigned int) );
				if ( tmp ) {
					variables_a[r].pinteger = tmp;
					for(i=variables_a[r].num ; i<n ; ++i) {
						variables_a[r].pinteger[i] = 0;
					}
					variables_a[r].num = n;
					return 0; // OK 
				}
				else {
					return 1;  // NG ̈mۂłȂ
				}
			}
			else if ( n < variables_a[r].num ) { // z񂪏ȂȂꍇ
				if ( n == 0 ) // z̑傫0ɎgpƂꍇ́A傫1̔z񂪏
					n = 1;
				tmp = (unsigned int *)realloc( variables_a[r].pinteger, n*sizeof(unsigned int) );
				if ( tmp ) {
					variables_a[r].pinteger = tmp;
					variables_a[r].num = n;
					return 0; // OK 
				}
				else {
					return 1;  // NG ̈mۂłȂ
				}
			}
			else {
				return 0; // OK z̗vfςȂꍇAȂ
			}
		}
	}
	else {
		MessageBox( NULL, "resize_variables: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NO_VALUE;	// NG s
	}
}

// ^zTCY ( 0 ` n-1 )
unsigned int resize_variables_d( const char *s, unsigned int n )
{
	unsigned int r;		// ϐԍ
	char *s_lc;			// ϐ

	if ( n >= 0xffffffff/sizeof(char *) ) {
		return 1; // NG E𒴂zvf
	}

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )

		r = symlook_d_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return array_variables_d(s, n); // 錾̔z񂾂ꍇ́A錾
		}
		else {
			char **tmp;
			unsigned int i;

			if ( n > variables_d_a[r].num ) { // z񂪑Ȃꍇ
				tmp = (char **)realloc( variables_d_a[r].ptext, n*sizeof(char *) );
				if ( tmp ) {
					variables_d_a[r].ptext = tmp;
					for(i=variables_d_a[r].num ; i<n ; ++i) {
						variables_d_a[r].ptext[i] = _strdup( "" );
						if ( variables_d_a[r].ptext[i] == NULL ) {
							do {
								safefree( variables_d_a[r].ptext[--i] );
							} while( i > variables_d_a[r].num );
							return 1; // NG ̈̊mۂɎs
						}
					}
					variables_d_a[r].num = n;
					return 0; // OK 
				}
				else {
					return 1;  // NG ̈mۂłȂ
				}
			}
			else if ( n < variables_d_a[r].num ) { // z񂪏ȂȂꍇ
				if ( n == 0 ) { // z̑傫0ɎgpƂꍇ́A傫1̔z񂪏
					n = 1;
				}

				for(i=variables_d_a[r].num-1 ; i>=n ; i--) {
					safefree( variables_d_a[r].ptext[i] );
				}

				tmp = (char **)realloc( variables_d_a[r].ptext, n*sizeof(char *) );
				if ( tmp ) {
					variables_d_a[r].ptext = tmp;
					variables_d_a[r].num = n;
					return 0; // OK 
				}
				else {
					return 1;  // NG ̈mۂłȂ
				}
			}
			else {
				return 0; // OK z̗vfςȂꍇAȂ
			}
		}
	}
	else {
		MessageBox( NULL, "resize_variables_d: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NO_VALUE;	// NG s
	}
}

// ^z̃TCY擾 ( NO_VALUE : G[ )
unsigned int sizeof_variables( const char *s )
{
	unsigned int r;			// ϐԍ
	char *s_lc;				// T[`̂߂̕ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )
		r = symlook_a(s_lc);
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return NO_VALUE;
		}
		else {
			return variables_a[r].num;
		}
	}
	else {
		MessageBox( NULL, "sizeof_variables: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NO_VALUE;	// NG s
	}
}

// ^z̃TCY擾 ( NO_VALUE : G[ )
unsigned int sizeof_variables_d( const char *s )
{
	unsigned int r;			// ϐԍ
	char *s_lc;				// T[`̂߂̕ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )
		r = symlook_d_a(s_lc);
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return NO_VALUE;
		}
		else {
			return variables_d_a[r].num;
		}
	}
	else {
		MessageBox( NULL, "sizeof_variables_d: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NO_VALUE;	// NG s
	}
}

// l^z s \vf̐擪|C^Ԃ
PVARIABLE_A search_pointer_a( const char *s )
{
	unsigned int r;			// ϐԍ
	char *s_lc;				// T[`̂߂̕ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )
		r = symlook_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return NULL;
		}
		else {
			return &variables_a[r];
		}
	}
	else {
		MessageBox( NULL, "search_pointer_a: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NULL;	// NG s
	}
}

// ^z s \vf̐擪|C^Ԃ
PVARIABLE_D_A search_pointer_d_a( const char *s )
{
	unsigned int r;			// ϐԍ
	char *s_lc;				// T[`̂߂̕ϐ

	s_lc = _strdup(s);
	if ( s_lc ) {
#pragma warning( disable : 4996 )
		_strlwr(s_lc);			// ϐ
#pragma warning( default : 4996 )
		r = symlook_d_a( s_lc );
		safefree(s_lc);

		if ( r == NO_VALUE ) {
			return NULL;
		}
		else {
			return &variables_d_a[r];
		}
	}
	else {
		MessageBox( NULL, "search_pointer_d_a: Ɨp̃sĂ܂B", "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
		return NULL;	// NG s
	}
}
