#include "stdafx.h"
#include "Rnsf7.h"
#include "commfunc.h"
#include "pre_interprete.h"
#include "splash.h"

using namespace std;
using namespace boost;

// \[X̃[h
// @F\[Xt@C
// ߂lFG[R[h
int LOAD_RSC::source_load(const char *rsc)
{
	if ( rsc == NULL ) {
		return pre_errcode = LR_BADPARAM;
	}

	// t@C_uR[e[V͂͂
	if ( rsc[0] == '"' ) {
		rscfname = rsc+1;
		rscfname = rscfname.substr(0, rscfname.size()-1);
	}
	else {
		rscfname = rsc;
	}

	try {
		if ( !tFileExist(rsc) ) {
			return pre_errcode = LR_NOFILE;
		}

		char cEncodeFlag = ENCODE_SJIS;

		FILE *fp;
		long fsize;
		UINT64 qwSize = getFileSizeQ(rsc);

		if ( qwSize == -1 ) {
			// G[(-1==0xffffffffffffffff)̏ꍇ͎舵Ȃ
			return pre_errcode = LR_CANNOTOPEN;
		}
		else if ( qwSize >= 2u*1024u*1024u*1024u-16u ) {
			// t@CTCY2GBȏ̏ꍇ͎舵Ȃ
			return pre_errcode = LR_TOOLARGE;
		}

		if ( 0 != fopen_s(&fp, rscfname.c_str(), "rb") ) {
			return pre_errcode = LR_CANNOTOPEN;
		}

		// t@CwidecharAmultibyte𒲂ׂ
		// (lCeBuňwidecharUnicode[LE]̂)
		// [BOM̎]
		//   ff fe    c Unicode (Little Endian)
		//   fe ff    c Unicode (Big Endian)
		//   ef bb bf c UTF-8
		// L̂łȂ΁AShift-JISƌȂďs
		{ int b1 = 0, b2 = 0, b3 = 0;
			b1 = fgetc(fp);
			b2 = fgetc(fp);
			if (b1 == 0xff) {
				if (b2 == 0xfe) {
					cEncodeFlag = ENCODE_UNICODE_LE;
				}
			}
			else if (b1 == 0xfe) {
				if (b2 == 0xff) {
					cEncodeFlag = ENCODE_UNICODE_BE;
				}
			}
			else if (b1 == 0xef) {
				if (b2 == 0xbb) {
					b3 = fgetc(fp);
					if (b3 == 0xbf) {
						cEncodeFlag = ENCODE_UTF8;
					}
				}
			}
			// ȊOENCODE_SJIS(l)
		}

		// t@C|C^擪ɖ߂
		fseek(fp, 0, SEEK_SET);

		// t@C̃TCYv
		fsize = (long)qwSize;

		if ( fsize == 0 ) {
			fclose(fp);
            return pre_errcode = LR_BADFILE;
		}

		// vector̃m
		// rsct@Cǂݍ
		if (cEncodeFlag == ENCODE_UNICODE_LE || cEncodeFlag == ENCODE_UNICODE_BE) { // widechar̃t@C
			int mb_fsize;	// }`oCgŃt@CTCY

			fsize -= 2;								// -2BOM̕
			vector<unsigned char> wsrc(fsize+2);	// +2͏I[NULL̕

			fseek(fp, 2, SEEK_SET);					// BOM΂
			if ( 1 > fread(&wsrc[0], fsize, 1, fp) ) {
				fclose(fp);
				return pre_errcode = LR_BADFILE;
			}
			wsrc[fsize-2] = wsrc[fsize-1] = 0;
			if (cEncodeFlag == ENCODE_UNICODE_BE) {
				unsigned char ucTemp;
				// BELE ֏㉺oCgւ
				for(long i=0 ; i<fsize-2 ; i+=2) {
					ucTemp = wsrc[i];
					wsrc[i] = wsrc[i+1];
					wsrc[i+1] = ucTemp;
				}
			}

			mb_fsize = WideCharToMultiByte(GetACP(), 0, (LPCWSTR)&wsrc[0], -1, NULL, 0, NULL, NULL);
			nsrc.resize(mb_fsize+1);
			fsize = WideCharToMultiByte(GetACP(), 0, (LPCWSTR)&wsrc[0], -1, &nsrc[0], mb_fsize, NULL, NULL);
			--fsize;
		}
		else if (cEncodeFlag == ENCODE_UTF8) { // UTF-8̃t@C
			// UTF8  Unicode[LE]  Shift-JIS ̏ɃGR[hs
			int mb_fsize;			// }`oCg(SJIS)Ńt@CTCY
			int wc_fsize;			// ChLN^(Unicode)Ńt@CTCY
			string  src_utf8;

			fsize -= 3;								// -3BOM̕

			// UTF-8Ƃăt@Cǂݍ
			fseek(fp, 3, SEEK_SET);					// BOM΂
			nsrc.resize(fsize+1);					// +1͏I[NULL̕
			if ( 1 > fread(&nsrc[0], fsize, 1, fp) ) {
				fclose(fp);
				return pre_errcode = LR_BADFILE;
			}
			nsrc[fsize] = 0;

			// UTF-8Unicode[LE]ϊ
			wc_fsize = MultiByteToWideChar(CP_UTF8, 0, &nsrc[0], -1, NULL, 0);
			vector<wchar_t> wsrc(wc_fsize+1);
			MultiByteToWideChar(CP_UTF8, 0, &nsrc[0], -1, &wsrc[0], wc_fsize);

			// Unicode[LE]SJISϊ
			mb_fsize = WideCharToMultiByte(GetACP(), 0, (LPCWSTR)&wsrc[0], -1, NULL, 0, NULL, NULL);
			nsrc.resize(mb_fsize+1);
			fsize = WideCharToMultiByte(GetACP(), 0, (LPCWSTR)&wsrc[0], -1, &nsrc[0], mb_fsize, NULL, NULL);
			--fsize;
		}
		else { // ׂ̑͂SJIS
			nsrc.resize(fsize+1);
			if ( 1 > fread(&nsrc[0], fsize, 1, fp) ) {
				fclose(fp);
				return pre_errcode = LR_BADFILE;
			}
			nsrc[fsize] = 0;
		}
		fclose(fp);

		if ( fsize <= 0 ) {
			return pre_errcode = LR_BADFILE;
		}
	}
	catch(bad_alloc) {
		return pre_errcode = LR_OUT_OF_MEMORY;
	}
	catch(out_of_range) {
		return pre_errcode = LR_OUT_OF_RANGE;
	}
	catch(std::exception e) {
		str_er = e.what();
		return pre_errcode = LR_ERROR_STR;
	}
	catch(...) {
		return pre_errcode = LR_ERROR;
	}

	return pre_errcode = LR_OK;
}

// `̉
// @F
//   pszItemName c ACel LR_SI_ Ŏn܂B
//   pszDefault	 c ACẽftHglB
//   iIncNo      c IncludeǂޏꍇA߂IncludeǂނB(zero based index)
//   iErrorCode  c G[R[hiQƁjB
// ߂lFG[R[h
const char * LOAD_RSC::searchItem(int iLoadItem, const char *pszDefault, int iIncNo, int &iErrorCode)
{
	iErrorCode = pre_errcode = LR_OK;

	try {
		if (iLoadItem == LR_SI_LOAD) {
			if (done_LR_SI_LOAD == true) {
				// łLR_SI_LOADŌĂ΂Ă
				iErrorCode = pre_errcode = LR_OK;
				return pszDefault;
			}

			// [Np̃GAm
			vector<char> tsrc(nsrc);

			// %%Ti%%͒`̏I[j
			char *pszline, *pc = NULL;
			pszline = strtok_s(&tsrc[0], "\r\n", &pc);

			if (!pszline) {
				iErrorCode = pre_errcode = LR_NOPP;
				return pszDefault;
			}

			do {
				if ( 0 == strncmp(pszline, "%%", 2) ) { // %%ɓB
					done_LR_SI_LOAD = true;
					iErrorCode = pre_errcode = LR_OK;
					return pszDefault;
				}

				// ̉
				int i = 0;

				// (1)܂A^uorXy[XłȂƂ܂Ői
				for(; pszline[i] == ' ' || pszline[i] == '\t'; ++i)
					;

				// (2)I[炨܂
				if ( pszline[i] == '\0' )
					continue;

				// (3)I[łȂ΁AӒl̍ŏ̕łƌȂ
				char *pszItemNameLeft = &pszline[i];

				// (4)^uorXy[XorCR[ɂȂƂ܂Ői
				for(; pszline[i] != ' ' && pszline[i] != '\t' && pszline[i] != '=' && pszline[i] != '\0' ; ++i)
					;

				// (5)I[炨܂
				if ( pszline[i] == '\0' )
					continue;

				// (6)I[łȂ΁AI[ƂB
				//    pszItemNameLeftAACe̐擪AhXƂȂ
				pszline[i] = '\0';

				// (7)^uorXy[XorCR[łȂƂ܂Ői
				//    ACel̐擪AhXƂȂ
				++i;
				for(; pszline[i] == ' ' || pszline[i] == '\t' || pszline[i] == '=' || pszline[i] == '\0' ; ++i)
					;

				if ( _stricmp(pszItemNameLeft, "ITEM") == 0 ) {
					strItem = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "INFORMATION") == 0 ) {
					strInformation = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "ICON") == 0 ) {
					strIcon = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "HELP") == 0 ) {
					strHelp = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "CONTEXTID") == 0 ) {
					strConTextId = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "AUTHOR") == 0 ) {
					strAuthor = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "URL") == 0 ) {
					strUrl = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "CATEGORY") == 0 ) {
					strCategory = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "TRY") == 0 ) {
					strTry = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "MUSTDEFVAR") == 0 ) {
					strMustDefVar = &pszline[i];
				}
				else if ( _stricmp(pszItemNameLeft, "INCLUDE") == 0 ) {
					if ( pszline[i] == '"' ) {
						string strline(&pszline[i+1]);
						if ( strline.size() >= 1 ) {
							vstrInclude.push_back(strline.substr(0, strline.size()-1));
						}
						else { // " At@CȂĂ܂isjȂƂ
							strline = &pszline[i];
							vstrInclude.push_back(strline);
						}
					}
					else {
						string strline(&pszline[i]);
						if ( strline.size() >= 1 ) {
							vstrInclude.push_back(strline);
						}
					}
				}
				continue;
			} while(NULL != (pszline = strtok_s(NULL, "\r\n", &pc)));
			iErrorCode = pre_errcode = LR_NOPP;
			return pszDefault;
		}
		else {
			// ܂LR_SI_LOAĎďoςłȂ΁Aς܂Ă܂B
			if (done_LR_SI_LOAD == false) {
				int ec;

				searchItem(LR_SI_LOAD, NULL, 0, ec);
				if (ec != LR_OK) {
					iErrorCode = pre_errcode = ec;
					return pszDefault;
				}
			}

			switch(iLoadItem) {
				case LR_SI_ITEM:
					iErrorCode = pre_errcode = LR_OK;
					return strItem.empty() ? pszDefault : strItem.c_str();

				case LR_SI_INFORMATION:
					iErrorCode = pre_errcode = LR_OK;
					return strInformation.empty() ? pszDefault : strInformation.c_str();

				case LR_SI_ICON:
					iErrorCode = pre_errcode = LR_OK;
					return strIcon.empty() ? pszDefault : strIcon.c_str();

				case LR_SI_HELP:
					iErrorCode = pre_errcode = LR_OK;
					return  strHelp.empty() ? pszDefault : strHelp.c_str();

				case LR_SI_CONTEXTID:
					iErrorCode = pre_errcode = LR_OK;
					return strConTextId.empty() ? pszDefault : strConTextId.c_str();

				case LR_SI_AUTHOR:
					iErrorCode = pre_errcode = LR_OK;
					return strAuthor.empty() ? pszDefault : strAuthor.c_str();

				case LR_SI_URL:
					iErrorCode = pre_errcode = LR_OK;
					return strUrl.empty() ? pszDefault : strUrl.c_str();

				case LR_SI_CATEGORY:
					iErrorCode = pre_errcode = LR_OK;
					return strCategory.empty() ? pszDefault : strCategory.c_str();

				case LR_SI_TRY:
					iErrorCode = pre_errcode = LR_OK;
					return strTry.empty() ? pszDefault : strTry.c_str();

				case LR_SI_MUSTDEFVAR:
					iErrorCode = pre_errcode = LR_OK;
					return strMustDefVar.empty() ? pszDefault : strMustDefVar.c_str();

				case LR_SI_INCLUDE:
					iErrorCode = pre_errcode = LR_OK;
					try {
						return vstrInclude.at(iIncNo).empty() ? pszDefault : vstrInclude.at(iIncNo).c_str();
					} //  OUT_OF_RANGEԂƂ́AȏincludeȂƂBȂ̂ŁAG[Ƃ͂IƂ݂ȂB
					catch(out_of_range) {
						return pszDefault;
					}

				default: // sȈw
					iErrorCode = pre_errcode = LR_BADPARAM;
					return pszDefault;
			}
		}
	}
	catch(bad_alloc) {
		iErrorCode = pre_errcode = LR_OUT_OF_MEMORY;
	}
	catch(out_of_range) {
		iErrorCode = pre_errcode = LR_OUT_OF_RANGE;
	}
	catch(std::exception e) {
		iErrorCode = pre_errcode = LR_ERROR_STR;
		str_er = e.what();
	}
	catch(...) {
		iErrorCode = pre_errcode = LR_ERROR;
	}
	return pszDefault;
}

// s̃Xy[Xs̃RgȂǂ菜
char *LOAD_RSC::regka(char *line)
{
	char *p = line;
	char wq = 0; // 񒆂ł邩ǂtOi " ܂ ' j
	char at = 0; // wq != 0 łƂAat = '@' ł΁A\GXP[vȂ

	if ( p && p[0] ) {
		// s̃Xy[X邢̓^u菜
        for(; *p == ' ' || *p == '\t' ; ++p)
			;

		// s̃Xy[XE^uERg菜
		char *q = p;

		for(; *q ; ++q) { // 񒆂ł͂Ȃ //, #, ; T
			if ( ISKANJI1M(*q) || (!at && *q == '\\') ) { // (SJIS1oCgڂAGXP[vȂ)
				++q; // ͊̕ĎΏۊO
				if ( *q == '\0' )
					break;
			}
			else if ( *q == '"' || *q == '\'' ) { // ̎n܂肾
				if ( wq == *q ) {
					// I
					wq = 0;
					at = 0;
				}
				else if ( wq == 0 ) { // Jn
					wq = *q;
					if ( q != p && *(q-1) == '@' ) { // @́AGXP[vV[PX𖳎̂
                        at = '@';
					}
				}
			}
			else {
				if ( wq == 0 ) {
					if ( *q == '#' || *q == ';' || (*q == '/' && *(q+1) == '/') ) { // Rg
						*q = '\0';
                        break;
					}
				}
			}
		}

		// skāAʂȃXy[X^uΎ菜
		if ( p != q ) {
			for(--q; p != q && (*q == '\t' || *q == ' ') ; --q) {
				*q = '\0';
			}
		}
	}

	if ( wq != 0 ) {
		pre_errcode = LR_TEXT_NOT_CLOSED;
	}
	else {
		pre_errcode = LR_OK;
	}

	return p;
}

bool strncmpi(const char *str1, const char *str2)
{
	size_t n = strlen(str2);

	for(size_t i=0 ; i<n ; ++i) {
		if ( toupper(str1[i]) != str2[i] ) {
			return false;
		}
	}

	return true;
}

char *get1line(char *buf)
{
	static char *pbuf;
	char *left = NULL;

	if ( buf ) { // ĂяoB2ڈȍ~̌ĂяobufNULLČĂяo
		pbuf = buf;
	}
	if ( pbuf && *pbuf ) {
		// left:ꂩԂ̍[
		left = pbuf;

		// pbuf:ꂩԂ̉E[BI[LɂȂ܂ŁACNg
		for(; !(*pbuf == '\r' || *pbuf == '\n' || *pbuf == '\0') ; ++pbuf)
			;

		// I[\rꍇ́A̎\nł邩ǂׂ
		if ( *pbuf == '\r' ) {
			*pbuf = '\0';
			++pbuf;
			if ( *pbuf == '\n' ) {
				*pbuf = '\0';
				++pbuf;
			}
		}
		// I[\nꍇ́APɂI[łƂĈ
		else if ( *pbuf == '\n' ) {
			*pbuf = '\0';
			++pbuf;
		}
		// I[\0ꍇ́Â܂܏I[łƂĈBȍ~̌ĂяołNULLԂ
	}

	// ȏsȂꍇAG[̏ꍇNULLԂ
	return left;
}

regex re_else("ELSE(\\s|\t)*$",  regex_constants::icase);
regex re_elif("ELSE(\\s|\t)+IF.*", regex_constants::icase);
regex re_break("BREAK[0-9]*", regex_constants::icase);
regex re_continue("CONTINUE[0-9]*", regex_constants::icase);

int LOAD_RSC::skip_until_blockclose(list<RSCLINES>::iterator &vrli)
{
	list<RSCLINES>::iterator vrlend = vrl.end();
	string::size_type lsize;

	while(vrli != vrlend) {
		lsize = vrli->line.size();

		// JbR
		if ( vrli->line[0] == '}' ) {
			// FI[nullł邱ƂÖقɎgĂ邽߁Aat() ͎g킸 operater[]() gĂ
			//       ̐AӏxXoꂷB
			return LR_OK;
		}
		// JbROɁAlXg { 
		else if ( lsize >= 1 && vrli->line.at(lsize-1) == '{' ) {
			int ec = analyze_blocks(vrli);
			if ( ec != LR_OK ) return ec;
		}
		else {
			// BREAK
			if ( regex_match(vrli->line, re_break) ) {
				unsigned int n = vrli->line.size() == 5 ? 1 : atoi(vrli->line.substr(5).c_str());
				unsigned int llsize = (unsigned int)(looplabel.size());
				
				if ( llsize >= n  )
					vrli->line = "GOTO " + looplabel.at(llsize-n) + "END";
				else
					return LR_WRONG_BREAK;
			}
			// CONTINUE
			else if ( regex_match(vrli->line, re_continue) ) {
				unsigned int n = vrli->line.size() == 8 ? 1 : atoi(vrli->line.substr(8).c_str());
				unsigned int llsize = (unsigned int)(looplabel.size());

				if ( llsize >= n )
					vrli->line = "GOTO " + looplabel.at(llsize-n) + "START";
				else
					return LR_WRONG_CONTINUE;
			}
			++vrli;
		}
	}
	return LR_NO_BLOCK_CLOSE;
}

// ubN̉́iċAĂяo֐j
int LOAD_RSC::analyze_blocks(list<RSCLINES>::iterator &vrli)
{
	list<RSCLINES>::iterator vrlend = vrl.end();

	for(; vrli != vrlend ; ++vrli) {
		// słȂāA
		if ( !vrli->line.empty() ) {
			string::size_type lsize = vrli->line.size();

			// s { łȂ
			if ( lsize >= 1 && vrli->line.at(lsize-1) == '{' ) {
				vrli->line.erase(lsize-1); // { 菜

				// ̍s̃t[ɂ郂m𒲂ׂB
				// Axi擪RjŎn܂ꍇl
				int i = 0;
				while ( vrli->line[i] == ':' ) {
					++i;
					while( vrli->line[i] != ' ' && vrli->line[i] != '\t' && vrli->line[i] != '\0' ) {
						if ( vrli->line[i] == '\0' )
							return LR_WRONG_BLOCK_OPEN;
						++i;
					}
					while( vrli->line[i] == ' ' || vrli->line[i] == '\t' )
						++i;
				}

				int cn_i = ++n_i;
				char itbuf[16];

				string strLabel(":_");
				if ( 0 == _ultoa_s(cn_i, itbuf, _countof(itbuf), 10) ) {
					strLabel += itbuf;	// ubNO\x̃x[X
				}

				if ( strncmpi(vrli->line.substr(i).c_str(), "IF") ) {
					vrli->line = "ELSE " + vrli->line + " " + strLabel + "NEXT0";
					vrli->fname;
					int iNext = 0;

					while(1) {
						int ec = skip_until_blockclose(vrli);
						if ( ec != LR_OK ) {
							return ec;
						}

						string::size_type lsizev = vrli->line.size();

						if ( lsizev >= 1 && vrli->line.at(lsizev-1) == '{' ) { // s {  - else/else if
							vrli->line.erase(lsizev-1); // { 菜

							RSCLINES rl;
							rl.fname    = vrli->fname;
							rl.line_num = vrli->line_num;
							rl.line     = "GOTO " + strLabel + "END";

							vrl.insert(vrli, rl);
							vrli->line.erase(0, 1); // } 菜

							// elseȂ̂else if Ȃ̂𔻒
							char itbuf[16];
							if ( regex_match(vrli->line, re_else) ) { // else
								if ( 0 == _ultoa_s(iNext, itbuf, _countof(itbuf), 10) ) {
									vrli->line = strLabel + "NEXT" + itbuf;
								}
								++iNext; // Î߂ɃCNgĂ
							}
							else if ( regex_match(vrli->line, re_elif) ) { // else if
								if ( 0 == _ultoa_s(iNext, itbuf, _countof(itbuf), 10) ) {
									vrli->line = strLabel + "NEXT" + itbuf + " " + vrli->line;
								}
								++iNext;
								if ( 0 == _ultoa_s(iNext, itbuf, _countof(itbuf), 10) ) {
									vrli->line += " " + strLabel + "NEXT" + itbuf;
								}
							}
							else {
								return LR_WRONG_BLOCK_OPEN;
							}
						}
						else { // s { łȂiIj
							char itbuf[16];

							if ( 0 == _ultoa_s(iNext, itbuf, _countof(itbuf), 10) ) {
								vrli->line = strLabel + "END " + strLabel + "NEXT" + itbuf;
							}
							return LR_OK;
						}
					}
				}
				else if ( strncmpi(vrli->line.substr(i).c_str(), "WHILE") ) {
					vrli->line = strLabel + "START " + vrli->line + " " + strLabel + "END";
					
					looplabel.push_back(strLabel);
					int ec = skip_until_blockclose(vrli);
					if ( ec != LR_OK ) {
						return ec;
					}
					looplabel.pop_back();
					vrli->line = "GOTO " + strLabel + "START";
					RSCLINES rl;
					rl.fname    = vrli->fname;
					rl.line_num = vrli->line_num;
					rl.line     = strLabel + "END";

					++vrli;
					vrl.insert(vrli, rl);
					return LR_OK;
				}
				else if ( strncmpi(vrli->line.substr(i).c_str(), "LOOP") ) {
					vrli->line = strLabel + "START " + "WHILE(1) " + strLabel + "END";

					looplabel.push_back(strLabel);
					int ec = skip_until_blockclose(vrli);
					if ( ec != LR_OK ) {
						return ec;
					}
					looplabel.pop_back();
					vrli->line = "GOTO " + strLabel + "START";
					RSCLINES rl;
					rl.fname    = vrli->fname;
					rl.line_num = vrli->line_num;
					rl.line     = strLabel + "END";

					++vrli;
					vrl.insert(vrli, rl);
					return LR_OK;
				}
				else if ( strncmpi(vrli->line.substr(i).c_str(), "FOR") ) {
					vrli->line += " " + strLabel + "END";

					RSCLINES rl;
					rl.fname    = vrli->fname;
					rl.line_num = vrli->line_num;
					rl.line     = strLabel + "START F0R " + vrli->line.substr(i);

					vrl.insert(++vrli, rl);

					looplabel.push_back(strLabel);
					int ec = skip_until_blockclose(vrli);
					if ( ec != LR_OK ) {
						return ec;
					}
					looplabel.pop_back();
					vrli->line = "GOTO " + strLabel + "START";

					rl.fname    = vrli->fname;
					rl.line_num = vrli->line_num;
					rl.line     = strLabel + "END";

					++vrli;
					vrl.insert(vrli, rl);
					return LR_OK;
				}
				else if ( strncmpi(vrli->line.substr(i).c_str(), "REPEAT") ) {
					vrli->line = strLabel + "START ";
					
					looplabel.push_back(strLabel);
					int ec = skip_until_blockclose(vrli);
					if ( ec != LR_OK ) {
						return ec;
					}
					looplabel.pop_back();
					vrli->line.erase(0,1);

					unsigned lsizev = (unsigned)(vrli->line.size());

					for(unsigned j=0;j<lsizev;++j) {
						if ( strncmpi(vrli->line.substr(j,5).c_str(), "UNTIL") ) {
							vrli->line.replace(j, 5, "WHILE");
							vrli->line += " " + strLabel + "START";

							RSCLINES rl;
							rl.fname    = vrli->fname;
							rl.line_num = vrli->line_num;
							rl.line     = strLabel + "END";

							++vrli;
							vrl.insert(vrli, rl);
							return LR_OK;
						}
					}
					return LR_WRONG_BLOCK_CLOSE;
				}
				else {
					return LR_WRONG_BLOCK_OPEN;
				}
			}
		}
	}

	return LR_OK;
}

// vC^vg
// ߂lFG[R[h
int LOAD_RSC::pre_interprete(void)
{
	bool bPreWriteFlag; // fobO[hǂ̔(ڍׂprewrite()Q)
	if ( 1 == rnsf7RegRead("DEBUG_LOWLEVEL_INTERPRETE", 0) ) {
		bPreWriteFlag = true;
	}
	else {
		bPreWriteFlag = false;
	}

	try {
		// ̈NA
		vrl.clear();
		
		// `̉
		int ec;
		bool pp_exist = 0;

		searchItem(LR_SI_LOAD, NULL, 0, ec);

		// ͒̍s
		int  nline = 0;

		// %%Ti%%͒`̏I[łA܂ł͍s̃JEgsȂj
		char *pszline;
		vector<char> tsrc(nsrc);

		pszline = get1line(&tsrc[0]);
		if (!pszline) {
			return pre_errcode = LR_NOPP;
		}

		do {
			if ( 0 == strncmp(pszline, "%%", 2) ) {
				pp_exist = 1;
				break;
			}
		}while(++nline,NULL != (pszline = get1line(NULL)));

		if ( !pp_exist ) { // %% Ȃ
			return pre_errcode = LR_NOPP;
		}

		++nline;
		pszline = get1line(NULL);

		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co

		// `I^`ȍ~̓ǂݍ
		RSCLINES rscline;
		if ( pszline ) {
			do {
				rscline.fname    = rscfname;
				rscline.line_num = nline + 1;
				rscline.line     = regka(pszline); // T[`Asƍs̗]vȃXy[XRg菜
				vrl.push_back(rscline);

				if ( pre_errcode == LR_TEXT_NOT_CLOSED ) {
					pre_errline = vrl.end();
					--pre_errline;
					return pre_errcode = LR_TEXT_NOT_CLOSED;
				}
			}while(++nline,NULL != (pszline = get1line(NULL)));
		}

		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co

		// eInclude̓ǂݍ
		{
			vector<char> n0src(nsrc);
			string       n0rscfname(rscfname);
			try {
				int iIncNo = 0;

				while(1) {
					nline = 0;
					source_load(vstrInclude.at(iIncNo).c_str());
					if ( NULL != (pszline = get1line(&nsrc[0])) ) {
						do {
							rscline.fname    = vstrInclude.at(iIncNo);
							rscline.line_num = nline + 1;
							rscline.line     = regka(pszline); // T[`Asƍs̗]vȃXy[XRg菜
							vrl.push_back(rscline);

							if ( pre_errcode == LR_TEXT_NOT_CLOSED ) {
								pre_errline = vrl.end();
								--pre_errline;
								return pre_errcode = LR_TEXT_NOT_CLOSED;
							}
						}while(++nline,NULL != (pszline = get1line(NULL)));
					}

					++iIncNo;
				}
			}
			catch(out_of_range) {
				; // vstrInclude.at(iIncNo)  out_of_range 𑗏oƂIƂ
			}
			nsrc = n0src;
			rscfname = n0rscfname;
		}

		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co

		// \[X+include̓ǂݍ݊
		// -------------------------------
		// sׂ镶̌A邢͂̋t̕

		list<RSCLINES>::iterator vrli = vrl.begin();
		list<RSCLINES>::iterator vrlend = vrl.end();

		for( ; vrli != vrlend ; ++vrli) {
			size_t i;

			// sׂ镶̌
			// Os̑ǂ𒲂ׂ
			// s̎n܂肪QZq邢͂RZq'?'Ŏn܂ĂAOs̑Ƃ݂Ȃ
			// '{' n܂ĂꍇOsɂ̂Ƃ݂Ȃ
			while(1) {
				if ( vrli != vrl.begin() &&
					(vrli->line[0] == '=' ||
					vrli->line[0] == '>' ||
					vrli->line[0] == '<' ||
					vrli->line[0] == '|' ||
					vrli->line[0] == '&' ||
					vrli->line[0] == '*' ||
					vrli->line[0] == '/' ||
					vrli->line[0] == '%' ||
					vrli->line[0] == '^' ||
					vrli->line[0] == '?' ||
					vrli->line[0] == ',' ||
					vrli->line[0] == ')' ||
					vrli->line[0] == '[' ||
					vrli->line[0] == ']' ||
					vrli->line[0] == '{' ||
					(vrli->line[0] == '-' && vrli->line[1] != '-') ||
					(vrli->line[0] == '+' && vrli->line[1] != '+'))) {

					list<RSCLINES>::iterator vrlib = vrli;
                    --vrlib; // vrlib  vrli ̑O̗vf\

					vrli->line = (vrlib->line + vrli->line);
					vrl.erase(vrlib);
					--vrli;
					continue;
				}
				break;
			}

			list<RSCLINES>::iterator vrlia = vrli;
			++vrlia; // vrlia  vrli ̗̎vf\

			// s'}'ō\ĂA̎̍s 'until', 'else' 
			// Ȃ΁A
			// Auntil, else Ɏ܂łɋsꍇ́A폜Ă
			if ( vrlia != vrlend && vrli->line == "}" ) {
				for(; vrlia != vrlend; ++vrlia) {
					if ( vrlia->line.empty() ) {
						vrl.erase(vrlia);
						vrlia = vrli;
					}
					else if ( strncmpi(vrlia->line.c_str(), "UNTIL ") ||
						      strncmpi(vrlia->line.c_str(), "UNTIL\t") ||
						      strncmpi(vrlia->line.c_str(), "UNTIL(") ||
							  strncmpi(vrlia->line.c_str(), "ELSE ") ||
							  strncmpi(vrlia->line.c_str(), "ELSE\t") ||
							  strncmpi(vrlia->line.c_str(), "ELSE{") ) {
						vrli->line += vrlia->line;
						vrli->line_num = vrlia->line_num;
						vrl.erase(vrlia);
						break;
					}
					else {
						break;
					}
				}
			}

			vrlia = vrli;
			++vrlia; // vrlia  vrli ̗̎vf\

			// s̏I肪QZq邢͂RZqŏIĂAs֑Ƃ݂Ȃ
			i = vrli->line.size();
			if ( i > 0 ) {
				--i;
				if ( vrlia != vrlend &&
					(vrli->line[i] == '=' ||
					vrli->line[i] == '>' ||
					vrli->line[i] == '<' ||
					vrli->line[i] == '|' ||
					vrli->line[i] == '&' ||
					vrli->line[i] == '*' ||
					vrli->line[i] == '/' ||
					vrli->line[i] == '%' ||
					vrli->line[i] == '^' ||
					vrli->line[i] == '?' ||
					vrli->line[i] == ':' ||
					vrli->line[i] == ',' ||
					vrli->line[i] == '(' ||
					vrli->line[i] == '[' ||
					(vrli->line[i] == '-' && (i != 0 && vrli->line[i-1] != '-')) ||
					(vrli->line[i] == '+' && (i != 0 && vrli->line[i-1] != '+')))) {

					vrlia->line = (vrli->line + vrlia->line);
					vrli->line = "";
				}
			}
		}

		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co

		// ----------------------------------------
		// JbR̉͂ƁAPs߂ւ̒u
		// op͓qȂ̂ŁAċAĂяoł܂Əł
		vrli = vrl.begin();
		vrlend = vrl.end();
		n_i = 0;
		looplabel.clear();
		while(vrli != vrlend) {
			ec = analyze_blocks(vrli);
			if ( ec != LR_OK ) {
				if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co
				pre_errline = vrli;
				return pre_errcode = ec;
			}
		}

		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co

		// ----------------------------------------
		// Ή },break,continue {^dx`FbN
		vrli = vrl.begin();
		vrlend = vrl.end();
		vector<string> strLabels;
		vector<string>::iterator isl;
		string newLabelName;

		for(nline = 1; vrli != vrlend ; ++vrli, ++nline) {
			if ( vrli->line[0] == '}' ) {
				pre_errline = vrli;
				return pre_errcode = LR_BLOCK_NOT_CLOSED;
			}
			// BREAK
			else if ( regex_match(vrli->line, re_break) ) {
				pre_errline = vrli;
				return pre_errcode = LR_WRONG_BREAK;
			}
			// CONTINUE
			else if ( regex_match(vrli->line, re_continue) ) {
				pre_errline = vrli;
				return pre_errcode = LR_WRONG_CONTINUE;
			}
			else {
				int i = 0, j;

				while ( vrli->line[i] == ':' ) {
					j = i + 1;
					while ( vrli->line[j] != ' ' && vrli->line[j] != '\t' && vrli->line[j] != '\0' )
						++j;

					newLabelName = vrli->line.substr(i,j-i);
					if ( !strLabels.empty() ) {
						for(isl = strLabels.begin(); isl != strLabels.end() ; ++isl) {
							if ( _stricmp(isl->c_str(), newLabelName.c_str()) == 0 ) {
								pre_errline = vrli;
								return pre_errcode = LR_OLLABEL;
							}
						}
					}
					strLabels.push_back(newLabelName);

					while ( vrli->line[j] == ' ' || vrli->line[j] == '\t' )
						++j;
					i = j;
				}
			}
		}

		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co

		// ----------------------------------------
		// ׂĂ̍s̍s\n
		vrli = vrl.begin();
		vrlend = vrl.end();
		for(; vrli != vrlend ; ++vrli) {
			vrli->line.push_back('\n');
		}

		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co

		return pre_errcode = LR_OK;
	}
	catch(bad_alloc) {
		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co
		return pre_errcode = LR_OUT_OF_MEMORY;
	}
	catch(out_of_range) {
		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co
		return pre_errcode = LR_OUT_OF_RANGE;
	}
	catch(std::exception e) {
		str_er = e.what();
		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co
		return pre_errcode = LR_ERROR_STR;
	}
	catch(...) {
		if ( bPreWriteFlag ) prewrite(); // fobO[h̏ꍇAro߂t@Co
		return pre_errcode = LR_ERROR;
	}
}

void LOAD_RSC::prewrite(void)
{
	// ----------------------------------------
	// vC^v^̏o͌ʂꍇ
	// Rnsf7̃WXgL[ɒluDEBUG_LOWLEVEL_INTERPRETEvA
	// (DWORD)1 B
	// ----------------------------------------
	// debugp - [if-elsewhileg]ዉ[ifgotô]@ϊ̃XNvgo
	string listname;
	FILE *op;
	string::size_type lsize;
	
	listname = rscfname + "_debug.txt";
	if ( 0 == fopen_s(&op, listname.c_str(), "wt") ) {
		list<RSCLINES>::iterator vrlend = vrl.end();

		for(list<RSCLINES>::iterator vrli = vrl.begin(); vrli != vrlend ; ++vrli) {
			fprintf(op, "%s[%d]:%s", vrli->fname.c_str(), vrli->line_num, vrli->line.c_str());
			lsize = vrli->line.size();
			if ( lsize == 0 || vrli->line.at(lsize-1) != '\n' ) {
                fputc('\n', op);
			}
		}
		fclose( op );
	}
}

list<RSCLINES>::const_iterator LOAD_RSC::GoTo(const char *szLabel) const
{
	list<RSCLINES>::const_iterator vrli = vrl.begin();
	list<RSCLINES>::const_iterator vrlend = vrl.end();

	for(; vrli != vrlend ; ++vrli) {
		int i = 0, j;
		while ( vrli->line[i] == ':' ) {
			j = i + 1;
			while ( vrli->line[j] != ' ' && vrli->line[j] != '\t' && vrli->line[j] != '\n' && vrli->line[j] != '\0' )
				++j;

			string strLabelName = vrli->line.substr(i,j-i);
			if ( _stricmp(strLabelName.c_str(), szLabel) == 0 ) {
				return vrli;
			}
			while ( vrli->line[j] == ' ' || vrli->line[j] == '\t' )
				++j;
			i = j;
		}
	}

	return vrli;
}

void LOAD_RSC::errmes(HWND hWnd) const
{
	// XvbVEBhE\ĂꍇɔA܂͏Ă
	destroy_splash_window();

	switch( pre_errcode ) {
		case LR_OK:
			MessageBox(hWnd, "G[ȂB", "R-Script Pre-Interprete", MB_OK | MB_ICONINFORMATION);
			break;

		case LR_BADPARAM:
			MessageBox(hWnd, "sȃp[^B", "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			break;

		case LR_NOFILE:
			{
				string mes("t@C܂B\r\n");
				mes += rscfname;
				mes += "\r\n\r\nt@C𒼂Ɏw肵Ăꍇ́At@CtpXŎw肵Ă݂ĂB\r\n"
					   "@\ڈꗗACɓAŋߎg@\ځANĂяoƂĂꍇ́AĂяoƂXNvgt@C݂ȂA폜Ă\܂B";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_TOOLARGE:
			{
				string mes("XNvgt@C̃TCY傫܂B戵\ȃt@C̃TCY2GBłB\r\n");
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_CANNOTOPEN:
			{
				string mes("t@CJ܂B\r\n");
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_BADFILE:
			{
				string mes("sȌ`̃t@CłB\r\n");
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_NOPP:
			{
				string mes("`̏I[(%%)܂B\r\n");
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_OUT_OF_MEMORY:
			{
				string mes("t@C͂邽߂̃܂B\r\n");
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_OUT_OF_RANGE:
			{
				string mes("OUT_OF_RANGEG[łB\r\nR-Script̓G[ł\܂B̔XNvgYāAJ֖₢킹ĉB\r\n");
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_NOITEM:
			{
				string mes("`̍ڂ܂B\r\n");
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_TEXT_NOT_CLOSED:
			{
				char itbuf[16];
				string mes("񂪕Ă܂B\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_BLOCK_NOT_CLOSED:
			{
				char itbuf[16];
				string mes("ubNĂ܂B{ ƖΉ } ܂B\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_WRONG_BLOCK_OPEN:
			{
				char itbuf[16];
				string mes("s { B\r\nif/while/loop/repeat/for ȊȌꏊ { g܂B\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_WRONG_BLOCK_CLOSE:
			{
				char itbuf[16];
				string mes("s } B\r\nsȈʒu } 邩A{ ƃyAɂȂĂȂ } ܂B\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_NO_BLOCK_OPEN:
			{
				char itbuf[16];
				string mes("̍sɂ { KvłB\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_NO_BLOCK_CLOSE:
			{
				string mes("} ܂B\r\n { ]Ă܂B\r\n");

				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_OLLABEL:
			{
				char itbuf[16];
				string mes("xdĂ܂B\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_WRONG_BREAK:
			{
				char itbuf[16];
				string mes("sbreakłB\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_WRONG_CONTINUE:
			{
				char itbuf[16];
				string mes("scontinuełB\r\n");

				mes += pre_errline->fname;
				mes += "\r\n";
				if ( 0 == _ultoa_s(pre_errline->line_num, itbuf, _countof(itbuf), 10) ) {
					mes += itbuf;
				}
				mes += "s";
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_ERROR:
			{
				string mes("G[łB\r\n͕słBR-Script̓G[ł\܂B̔XNvgYāAJ֖₢킹ĉB\r\n");

				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_ERROR_STR:
			{
				string mes("G[łB\r\nR-Script̓G[ł\܂B̔XNvgYāAJ֖₢킹ĉB\r\n");
				mes += "F";
				mes += str_er;
				mes += "\r\n";
				mes += rscfname;
				MessageBox(hWnd, mes.c_str(), "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;

		case LR_USER_ERROR:
			MessageBox(hWnd, "G[łB(pre_errcode = LR_USER_ERROR)", "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			break;

		default:
			{
				char buf[50];
				wsprintf(buf, "G[łB(pre_errcode = %d)", pre_errcode);
				MessageBox(hWnd, buf, "R-Script Pre-Interprete", MB_OK | MB_ICONSTOP);
			}
			break;
	}
}
