/* ֐̊Ǘƈ̊mFA֐̌Ăяo */

#include "stdafx.h"
#include "function.h"
#include "addctrl.h"
#include "refresh.h"
#include "token.h"
#include "dlllib.h"
#include "helpdlg.h"
#include "symbol.h"
#include "opendlg.h"
#include "splash.h"
#include "inputdlg.h"
#include "filetypes.h"
#include "cpp_func.h"
#include "LvEdit.h"
#include "commfunc.h"
#include <winerror.h>

// fread/fwrite/fappend̓ݒFfmodebinary() ŃeLXg[hoCi[h肷
unsigned char fmode_bin = 0;
// fread/fwrite/fappend̓ݒFfmodewide() ŃCh}`oCg肷
unsigned char fmode_wide = 0;

// C^[o^C}̂Ƃѐ惉x
char *pszEditDialogTimerLabel;

// ֐̍ő咷
#define FUNCLENGTH	28

#pragma warning( disable : 4100 )

// ̌^Ɛ`FbN
static int args_typecheck(const struct ARGS *args, const char *types)
{
	const struct ARGS *p = args;

	if (p == NULL) {
		if (types == NULL || types[0] == 0) {
			return 1; // OK
		}
		else {
			return 0; // NG
		}
	}

	do {
		switch ( p->type ) {
			case UFCT_ARG_INT:
				if (*types != 'i') {
					return 0; // NG
				}
				break;

			case UFCT_ARG_STRING:
				if (*types != 's') {
					return 0; // NG
				}
				break;

			case UFCT_ARG_INTS:
				if (*types != 'a') {
					return 0; // NG
				}
				break;

			case UFCT_ARG_STRINGS:
				if (*types != 'r') {
					return 0; // NG
				}
				break;
		}
		
		types++;
	} while( (p = p->next) != NULL );

	if ( *types == 0 ) { // argsI[ɒBƂAtypeI[ɒB?
		return 1; // OK
	}
	else {
		return 0; // NG
	}
}

// ֐Xgilԋp^j
typedef struct {
	const char func[FUNCLENGTH];
	unsigned int const (*pfunc) (HWND, const struct ARGS *, BYTE *);
} RFUNCS;

// ֐Xgiԋp^j
typedef struct {
	const char func[FUNCLENGTH];
	char * const (*pfuncd) (HWND, const struct ARGS *, BYTE *);
} RFUNCSD;


// bZ[W_CAO
// textout( bZ[W$ [, LvV$] )
unsigned int rfunc_textout(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, ARG2.text, MB_OK );
	}
	else if ( args_typecheck(args, "s") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, "bZ[W", MB_OK );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; //  // 
		return ERRORVALUE;
	}
}

// xbZ[W_CAO
// warning( bZ[W$ [, LvV$] )
unsigned int rfunc_warning(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, ARG2.text, MB_OK | MB_ICONEXCLAMATION );
	}
	else if ( args_typecheck(args, "s") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, "x", MB_OK | MB_ICONEXCLAMATION );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; //  // 
		return ERRORVALUE;
	}
}

// 񃁃bZ[W
// information( bZ[W$ [, LvV$] )
unsigned int rfunc_information(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, ARG2.text, MB_OK | MB_ICONINFORMATION );
	}
	else if ( args_typecheck(args, "s") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, "", MB_OK | MB_ICONINFORMATION );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; //  // 
		return ERRORVALUE;
	}
}

// G[bZ[W
// error( bZ[W$ [, LvV$] )
unsigned int rfunc_error(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, ARG2.text, MB_OK | MB_ICONSTOP );
	}
	else if ( args_typecheck(args, "s") ) {
		destroy_splash_window();
		return MessageBox( hWnd, ARG1.text, "G[", MB_OK | MB_ICONSTOP );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; //  // 
		return ERRORVALUE;
	}
}

// [U[ւ̖₢킹_CAO
// question( bZ[W$ [, LvV$] )
unsigned int rfunc_question(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		destroy_splash_window();
		return (IDYES == MessageBox( hWnd, ARG1.text, ARG2.text, MB_YESNO | MB_ICONQUESTION ));
	}
	else if ( args_typecheck(args, "s") ) {
		destroy_splash_window();
		return (IDYES == MessageBox( hWnd, ARG1.text, "₢킹", MB_YESNO | MB_ICONQUESTION ));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; //  // 
		return ERRORVALUE;
	}
}

// [U[ւ̖₢킹_CAO(OK, Cancel)
// question_okcancel( bZ[W$ [, LvV$] )
unsigned int rfunc_question_okcancel(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		destroy_splash_window();
		return (IDOK == MessageBox( hWnd, ARG1.text, ARG2.text, MB_OKCANCEL | MB_ICONQUESTION ));
	}
	else if ( args_typecheck(args, "s") ) {
		destroy_splash_window();
		return (IDOK == MessageBox( hWnd, ARG1.text, "₢킹", MB_OKCANCEL | MB_ICONQUESTION ));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// [U[ւ̖₢킹_CAO(yes, no, cancel)
// question_yesnocancel( bZ[W$ [, LvV$] )
unsigned int rfunc_question_yesnocancel(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	int rv = ERRORVALUE;

	if ( args_typecheck(args, "ss") ) {
		destroy_splash_window();
		rv = MessageBox( hWnd, ARG1.text, ARG2.text, MB_YESNOCANCEL | MB_ICONQUESTION );
	}
	else if ( args_typecheck(args, "s") ) {
		destroy_splash_window();
		rv = MessageBox( hWnd, ARG1.text, "₢킹", MB_YESNOCANCEL | MB_ICONQUESTION );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}

	switch( rv ) {
		case IDYES:
			return 1;
		case IDNO:
			return 0;
		default: // IDCANCEL:
			return ERRORVALUE;
	}
}

// t@C̍Đ
// playsound( t@C$, IvV )
unsigned int rfunc_playsound(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		BOOL bRet = FALSE;

		if (ARG1.text[0] == 0) {
			// t@CȂĐ~
			bRet = PlaySound(NULL, NULL, 0);
		}
		else if (ARG2.integer == 0) {
			// 񓯊Đ
			bRet = PlaySound(ARG1.text, NULL, SND_SYNC | SND_FILENAME | SND_NODEFAULT);
		}
		else if (ARG2.integer == 1) {
			// Đ
			bRet = PlaySound(ARG1.text, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
		}
		else if (ARG2.integer == 2) {
			// [vĐ
			bRet = PlaySound(ARG1.text, NULL, SND_ASYNC | SND_LOOP | SND_FILENAME | SND_NODEFAULT);
		}
		
		return (int)bRet;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; //  // 
		return ERRORVALUE;
	}
}

// X^eBbNeLXg̔zu
// text( $ )
// text( $, x:̕ҏW{bNXȂǂzuŒxW )
unsigned int rfunc_text(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, 1, 0, 0, 0, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "si") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, 1, ARG2.integer, 0, 0, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// X^eBbNeLXg̔zu
// boldtext( $ )
unsigned int rfunc_boldtext(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, 1, 0, 0, 0, 0, 0, ARG1.text, 0, 0, 0, 2, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ̔zu
// border()
unsigned int rfunc_border(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, 1 , 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "i") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, ARG1.integer , 0, 0, 0, 0, 0, NULL, 0, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ͂ݘg̊Jn
unsigned int rfunc_startgroupbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, 1 , 0, 0, 0, 0, 0, ARG1.text, 0, 0, 0, 1, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ͂ݘg̏I
unsigned int rfunc_endgroupbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, 1 , 0, 0, 0, 0, 0, NULL, 0, 0, 0, 1, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNX̔zu
// checkbox( ID$, ftHg<0 or 1>, \镶$ [, key$, entry$, [(ValueOfCheck, ValueOfUnCheck) or (ValueOfCheck$, ValueOfUnCheck$)] [, flag] )
unsigned int rfunc_checkbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sisi") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, ARG4.integer, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sis") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, 0, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssi") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, ARG6.integer, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisss") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, 0, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, ARG8.integer, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, ARG6.integer, ARG7.integer, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, 0, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, ARG6.integer, ARG7.integer, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssssi") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, ARG8.integer, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, ARG6.text, ARG7.text, 0));
	}
	else if ( args_typecheck(args, "sisssss") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 0, 0, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, ARG6.text, ARG7.text, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNX̔zu(3state) [l폜Ă遁`FbN]
// checkbox3( ID$, \镶$, key$, entry$, [(ValueOfCheck, ValueOfUnCheck) or (ValueOfCheck$, ValueOfUnCheck$)] [, flag] )
// checkbox3( ID$, ftHg(<0:Ȃ | 1: | 2:`FbN>), \镶$ [, flag] )
unsigned int rfunc_checkbox3(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssssi") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, ARG5.integer, ARG3.text, ARG4.text, 0, 0, ARG2.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssssiii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, ARG7.integer, ARG3.text, ARG4.text, 0, 0, ARG2.text, ARG1.text, ARG5.integer, ARG6.integer, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssssssi") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, ARG7.integer, ARG3.text, ARG4.text, 0, 0, ARG2.text, ARG1.text, 1, 0, 0, 0, ARG5.text, ARG6.text, 0));
	}
	else if ( args_typecheck(args, "ssss") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, 0, ARG3.text, ARG4.text, 0, 0, ARG2.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssssii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, 0, ARG3.text, ARG4.text, 0, 0, ARG2.text, ARG1.text, ARG5.integer, ARG6.integer, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssssss") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, 0, ARG3.text, ARG4.text, 0, 0, ARG2.text, ARG1.text, 1, 0, 0, 0, ARG5.text, ARG6.text, 0));
	}
	else if ( args_typecheck(args, "sisi") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, ARG4.integer, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sis") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 1, 0, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, 1, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNX̔zu - WXgoCif[^̓̃rbg(0|1)ǂ/֏
// checkbox_bin( ID$, ftHg<0|1>, \镶$, Key$, Entry$, oCg?<0->, rbg?<0-7> [, ValueOfCheck, ValueOfUnCheck][, flag] )
unsigned int rfunc_checkbox_bin(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sisssiii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 2, ARG8.integer, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, ARG6.integer, ARG7.integer, 1, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiiiii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 2, ARG8.integer, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, ARG6.integer, ARG7.integer, ARG9.integer, ARG10.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 2, 0, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, ARG6.integer, ARG7.integer, 1, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiiii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 2, 0, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, ARG6.integer, ARG7.integer, ARG8.integer, ARG9.integer, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNX̔zu - WXgDWORDf[^̓̃rbg(0|1)ǂ/֏
// checkbox_bindw( ID$, ftHg<0|1>, \镶$, Key$, Entry$, rbg?<0-31> [, ValueOfCheck, ValueOfUnCheck][, flag] )
unsigned int rfunc_checkbox_bindw(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sisssii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 3, ARG7.integer, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 0, ARG6.integer, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiiii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 3, ARG7.integer, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 0, ARG6.integer, ARG8.integer, ARG9.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssi") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 3, 0, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 0, ARG6.integer, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiii") ) {
		return (NULL != addctrl(hWnd, CHECK_CTRL, 3, 0, ARG4.text, ARG5.text, 0, ARG2.integer, ARG3.text, ARG1.text, 0, ARG6.integer, ARG7.integer, ARG8.integer, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ҏW{bNX̔zu - l
// editbox_num( ID$, ftHg [, key$, entry$] [, Pʎw$] [, ŏl, ől [, 1, 2] ] [, flag] )
unsigned int rfunc_editbox_num(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sii") ) { // tO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG3.integer, 0, 0, 0, ARG2.integer, 0, ARG1.text, 0, 0xffffffff, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "si") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, 0, 0, 0, ARG2.integer, 0, ARG1.text, 0, 0xffffffff, 1, 1, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sissi") ) { // L[AGgAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG5.integer, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, 0, 0xffffffff, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "siss") ) { // L[AGg
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, 0, 0xffffffff, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "siiii") ) { // őAŏAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG5.integer, 0, 0, 0, ARG2.integer, 0, ARG1.text, ARG3.integer, ARG4.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "siiiiii") ) { // őAŏAPCQCtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG7.integer, 0, 0, 0, ARG2.integer, 0, ARG1.text, ARG3.integer, ARG4.integer, ARG5.integer, ARG6.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "siii") ) { // őAŏAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, 0, 0, 0, ARG2.integer, 0, ARG1.text, ARG3.integer, ARG4.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "siiiii") ) { // őAŏAPCQ
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, 0, 0, 0, ARG2.integer, 0, ARG1.text, ARG3.integer, ARG4.integer, ARG5.integer, ARG6.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sissiii") ) { // L[AGgAőAŏAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG7.integer, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, ARG5.integer, ARG6.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sissiiiii") ) { // L[AGgAőAŏAPCQCtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG9.integer, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, ARG5.integer, ARG6.integer, ARG7.integer, ARG8.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sissii") ) { // L[AGgAőAŏ
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, ARG5.integer, ARG6.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sissiiii") ) { // L[AGgAőAŏAPAQ
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, ARG5.integer, ARG6.integer, ARG7.integer, ARG8.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisi") ) { // PʁAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG4.integer, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, 0, 0xffffffff, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sis") ) { // P
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, 0, 0xffffffff, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssi") ) { // L[AGgAPʁAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG6.integer, ARG3.text, ARG4.text, 0, ARG2.integer, ARG5.text, ARG1.text, 0, 0xffffffff, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisss") ) { // L[AGgAP
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, ARG3.text, ARG4.text, 0, ARG2.integer, ARG5.text, ARG1.text, 0, 0xffffffff, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisiii") ) { // PʁAőAŏAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG6.integer, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, ARG4.integer, ARG5.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisiiiii") ) { // PʁAőAŏAPCQAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG8.integer, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, ARG4.integer, ARG5.integer, ARG6.integer, ARG7.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisii") ) { // PʁAőAŏ
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, ARG4.integer, ARG5.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisiiii") ) { // PʁAőAŏAPAQ
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, 0, 0, 0, ARG2.integer, ARG3.text, ARG1.text, ARG4.integer, ARG5.integer, ARG6.integer, ARG7.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiii") ) { // L[AGgAPʁAőAŏAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG8.integer, ARG3.text, ARG4.text, 0, ARG2.integer, ARG5.text, ARG1.text, ARG6.integer, ARG7.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiiiii") ) { // L[AGgAPʁAőAŏAPCQAtO
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, ARG10.integer, ARG3.text, ARG4.text, 0, ARG2.integer, ARG5.text, ARG1.text, ARG6.integer, ARG7.integer, ARG8.integer, ARG9.integer, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssii") ) { // L[AGgAPʁAőAŏ
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, ARG3.text, ARG4.text, 0, ARG2.integer, ARG5.text, ARG1.text, ARG6.integer, ARG7.integer, 1, 5, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssiiii") ) { // L[AGgAPʁAőAŏAPCQ
		return (NULL != addctrl(hWnd, EDIT_CTRL, 1, 0, ARG3.text, ARG4.text, 0, ARG2.integer, ARG5.text, ARG1.text, ARG6.integer, ARG7.integer, ARG8.integer, ARG9.integer, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ҏW{bNX̔zu -  - WXgǂݍ/֏
// editbox( ID$, ftHg$ [, Key$, Entry$] [, Qƃ{^̖O$] [, flag] )
unsigned int rfunc_editbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssi") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, ARG3.integer, 0, 0, ARG2.text, 0, "Q...", ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ss") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, 0, 0, 0, ARG2.text, 0, "Q...", ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sssi") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, ARG4.integer, 0, 0, ARG2.text, 0, ARG3.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sss") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, 0, 0, 0, ARG2.text, 0, ARG3.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssssi") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, ARG5.integer, ARG3.text, ARG4.text, ARG2.text, 0, "Q...", ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssss") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, 0, ARG3.text, ARG4.text, ARG2.text, 0, "Q...", ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sssssi") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, ARG6.integer, ARG3.text, ARG4.text, ARG2.text, 0, ARG5.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sssss") ) {
		return (NULL != addctrl(hWnd, EDIT_CTRL, 0, 0, ARG3.text, ARG4.text, ARG2.text, 0, ARG5.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ACRҏW{^̔zu - WXgǂݍ/֏
// icon( ID$, ftHg$ [, Key$, Entry$] [, flag] )
unsigned int rfunc_icon(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssi") ) {
		return (NULL != addctrl(hWnd, ICON_BUTTON, 0, ARG3.integer, 0, 0, ARG2.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0) );
	}
	else if ( args_typecheck(args, "ss") ) {
		return (NULL != addctrl(hWnd, ICON_BUTTON, 0, 0, 0, 0, ARG2.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0) );
	}
	else if ( args_typecheck(args, "ssssi") ) {
		return (NULL != addctrl(hWnd, ICON_BUTTON, 0, ARG5.integer, ARG3.text, ARG4.text, ARG2.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0) );
	}
	else if ( args_typecheck(args, "ssss") ) {
		return (NULL != addctrl(hWnd, ICON_BUTTON, 0, 0, ARG3.text, ARG4.text, ARG2.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0) );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// lXg - WXgǂݍ/֏
// ValueList( ID$, Key$, l̈Ӗ$, f[^̈Ӗ$ [, VK{^̖O$, ҏW{^̖O$, 폜{^̖O$] [, flag] )
unsigned int rfunc_ValueList(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	MULTISTRING mulstr;

	if ( args_typecheck(args, "ssssi") ) {
		mulstr.str1 = "VK...";
		mulstr.str2 = "ҏW...";
		mulstr.str3 = "폜";
		return (NULL != addctrl(hWnd, LIST_CTRL, 0, ARG5.integer, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssss") ) {
		mulstr.str1 = "VK...";
		mulstr.str2 = "ҏW...";
		mulstr.str3 = "폜";
		return (NULL != addctrl(hWnd, LIST_CTRL, 0, 0, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sssssssi") ) {
		mulstr.str1 = ARG5.text;
		mulstr.str2 = ARG6.text;
		mulstr.str3 = ARG7.text;
		return (NULL != addctrl(hWnd, LIST_CTRL, 0, ARG8.integer, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sssssss") ) {
		mulstr.str1 = ARG5.text;
		mulstr.str2 = ARG6.text;
		mulstr.str3 = ARG7.text;
		return (NULL != addctrl(hWnd, LIST_CTRL, 0, 0, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// L[Xg - WXgǂݍ/֏
// keyList( ID$, Key$, l̔z$[], Ӗ̔z$[], f[^̈Ӗ$, [VK{^̖O$, ҏW{^̖O$, 폜{^̖O$] [, flag] )
unsigned int rfunc_KeyList(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	MULTISTRING mulstr;

	if ( args_typecheck(args, "ssrri") ) {
		mulstr.str1 = "VK...";
		mulstr.str2 = "ҏW...";
		mulstr.str3 = "폜";
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, ARG5.integer, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssrr") ) {
		mulstr.str1 = "VK...";
		mulstr.str2 = "ҏW...";
		mulstr.str3 = "폜";
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, 0, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssrrsssi") ) {
		mulstr.str1 = ARG5.text;
		mulstr.str2 = ARG6.text;
		mulstr.str3 = ARG7.text;
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, ARG8.integer, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ssrrsss") ) {
		mulstr.str1 = ARG5.text;
		mulstr.str2 = ARG6.text;
		mulstr.str3 = ARG7.text;
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, 0, ARG2.text, (char *)&mulstr, ARG3.text, 0, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ̃Xgr[
// CreateListView( ID$, l̔z$[], [VK{^̖O$, ҏW{^̖O$, 폜{^̖O$] [, flag] )
unsigned int rfunc_CreateListView(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	MULTISTRING mulstr;

	if ( args_typecheck(args, "sri") ) {
		mulstr.str1 = "VK...";
		mulstr.str2 = "ҏW...";
		mulstr.str3 = "폜";
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, ARG3.integer, 0, (char *)&mulstr, 0, 0, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sr") ) {
		mulstr.str1 = "VK...";
		mulstr.str2 = "ҏW...";
		mulstr.str3 = "폜";
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, 0, 0, (char *)&mulstr, 0, 0, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "srsssi") ) {
		mulstr.str1 = ARG3.text;
		mulstr.str2 = ARG4.text;
		mulstr.str3 = ARG5.text;
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, ARG6.integer, 0, (char *)&mulstr, 0, 0, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "srsss") ) {
		mulstr.str1 = ARG3.text;
		mulstr.str2 = ARG4.text;
		mulstr.str3 = ARG5.text;
		return (NULL != addctrl(hWnd, LIST_CTRL, 1, 0, 0, (char *)&mulstr, 0, 0, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[E`FbN{bNXXg̃ACe̐𓾂
// ListViewGetNum( ID$ )
unsigned int rfunc_ListViewGetNum(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return ListView_GetNum( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[E`FbN{bNXXg̃J[\ʒuݒ肷
// ListViewSetCursor( ID$, n )
unsigned int rfunc_ListViewSetCursor(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return ListView_SetCursor( ARG1.text, ARG2.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[E`FbN{bNXXǵA݃J[\̒uĂs̔ԍԂiJ[\uĂȂERRORVALUEj
// ListViewGetCursor( ID$ )
unsigned int rfunc_ListViewGetCursor(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return ListView_GetCursor( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[E`FbN{bNXXgnsiɕZbg
// ListViewSetText( ID$, n, i , $ )
unsigned int rfunc_ListViewSetText(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "siis") ) {
		return ListView_SetText( ARG1.text, ARG2.integer, ARG3.integer, ARG4.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[ɍڂǉiǉw邾ŁAݒListViewSetTextŁj
// ListViewAdd( ID$, ꍀږ$ )
unsigned int rfunc_ListViewAdd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return ListView_Add( ARG1.text, ARG2.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[isڂ̍ڂ폜
// ListViewDelete( ID$, i )
unsigned int rfunc_ListViewDelete(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return ListView_Del( ARG1.text, ARG2.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// lXgr[̍ڂ̓ȕsҏWsidelim$Ŏw肳ꂽ1؂ƂāAsɒuĕҏWj
// ListViewMultiLineEdit( item$[], data$[], delim$ )
unsigned int rfunc_ListViewMultiLineEdit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "rrs") ) {
		char *buf1 = getVariable_d_a(ARG2.text, 0);
		char *buf2 = getVariable_d_a(ARG2.text, 1);
		BOOL bRet;

		if (buf1) buf1 = _strdup(buf1);
		else      buf1 = _strdup("");
		if (buf2) buf2 = _strdup(buf2);
		else      buf2 = _strdup("");

		bRet = lv_edititem_m(hWnd, &buf1, &buf2, getVariable_d_a(ARG1.text, 0), getVariable_d_a(ARG1.text, 1), ARG3.text);

		if (bRet) {
			resize_variables_d(ARG2.text, 2);
			setVariable_d_a(ARG2.text, 0, buf1);
			free(buf1);
			setVariable_d_a(ARG2.text, 1, buf2);
			free(buf2);
			return 1;
		}
		else {
			free(buf1);
			free(buf2);
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[E`FbN{bNXXg̓̃J(c)A
// ListViewSearch( ID$, c, $ )
// 񂪌΍ڔԍԂAȂ ERROR Ԃ
unsigned int rfunc_ListViewSearch(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sis") ) {
		return ListView_Search( ARG1.text, ARG2.integer, ARG3.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Xgr[E`FbN{bNXXgnsڂ]ԂɂȂĂ邩ǂ𒲂ׂ
// ListView_isSelected( ID$, n )
unsigned int rfunc_ListView_isSelected(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return ListView_isSelected( ARG1.text, ARG2.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}


// {^쐬i{^ƁAxɃWvj
// CreateButton( {^ꂽƂɔ΂郉x$, LvV$ [, flag] )
unsigned int rfunc_CreateButton(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssi") ) {
		return (NULL != addctrl(hWnd, GOTO_BUTTON, 0, ARG3.integer, 0, 0, 0, 0, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "ss") ) {
		return (NULL != addctrl(hWnd, GOTO_BUTTON, 0, 0, 0, 0, 0, 0, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// FI{^쐬
// ColorButton( ID$, ftHg [, Key$, Entry$][, flag] )
unsigned int rfunc_ColorButton(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sissi") ) {
		return (NULL != addctrl(hWnd, COLOR_BUTTON, 0, ARG5.integer, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "siss") ) {
		return (NULL != addctrl(hWnd, COLOR_BUTTON, 0, 0, ARG3.text, ARG4.text, 0, ARG2.integer, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sii") ) {
		return (NULL != addctrl(hWnd, COLOR_BUTTON, 0, ARG3.integer, 0, 0, 0, ARG2.integer, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "si") ) {
		return (NULL != addctrl(hWnd, COLOR_BUTTON, 0, 0, 0, 0, 0, ARG2.integer, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// FI{^l擾
// GetColorButton( ID$ )
unsigned int rfunc_GetColorButton(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return GetColorButton( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// FI{^֒lݒ
// SetColorButton( ID$, color )
unsigned int rfunc_SetColorButton(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return SetColorButton( ARG1.text, ARG2.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// s̃X^eBbNeLXg̔zu
// multitext( s, $ )
unsigned int rfunc_multitext(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "is") ) {
		return (NULL != addctrl(hWnd, TEXT_CTRL, ARG1.integer, 0, 0, 0, 0, 0, ARG2.text, 0, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// sҏW{bNX̔zu - WXgǂݍ/֏݁iREG_MULTI_SZŏށj
// multiedit( ID$, s, ftHg$ [, Key$, Entry$], flag )
unsigned int rfunc_multiedit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sisi") ) {
		return (NULL != addctrl(hWnd, MULTI_EDIT, ARG2.integer, ARG4.integer, 0, 0, ARG3.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sis") ) {
		return (NULL != addctrl(hWnd, MULTI_EDIT, ARG2.integer, 0, 0, 0, ARG3.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisssi") ) {
		return (NULL != addctrl(hWnd, MULTI_EDIT, ARG2.integer, ARG6.integer, ARG4.text, ARG5.text, ARG3.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "sisss") ) {
		return (NULL != addctrl(hWnd, MULTI_EDIT, ARG2.integer, 0, ARG4.text, ARG5.text, ARG3.text, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R{{bNX̍쐬
// ComboBox( ID$, 񃊃Xg$[], J[\ʒu [, flag] )
unsigned int rfunc_ComboBox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "srii") )
		return (NULL != addctrl(hWnd, COMBO_CTRL, 0, ARG4.integer, 0, 0, 0, ARG3.integer, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	else if ( args_typecheck(args, "sri") )
		return (NULL != addctrl(hWnd, COMBO_CTRL, 0, 0, 0, 0, 0, ARG3.integer, ARG2.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R{{bNX̍쐬(REG_SZp)
// ComboBox_sz( ID$, KEY$, Entry$, 񃊃Xg$[], 񃊃XgɊevfɑΉREG_SZ̒lXg$[], J[\ʒu [, flag] )
unsigned int rfunc_ComboBox_sz(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sssrrii") )
		return (NULL != addctrl( hWnd, COMBO_CTRL, 0, ARG7.integer, ARG2.text, ARG3.text, ARG5.text, ARG6.integer, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0) );
	else if ( args_typecheck(args, "sssrri") )
		return (NULL != addctrl( hWnd, COMBO_CTRL, 0, 0, ARG2.text, ARG3.text, ARG5.text, ARG6.integer, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0) );
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R{{bNX̍쐬(REG_DWORDp)
// ComboBox_dw( ID$, KEY$, Entry$, 񃊃Xg$[], 񃊃XgɊevfɑΉREG_DWORD̒lXg[], J[\ʒu [, flag] )
unsigned int rfunc_ComboBox_dw(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sssraii") )
		return (NULL != addctrl( hWnd, COMBO_CTRL, 1, ARG7.integer, ARG2.text, ARG3.text, ARG5.text, ARG6.integer, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	else if ( args_typecheck(args, "sssrai") )
		return (NULL != addctrl( hWnd, COMBO_CTRL, 1, 0, ARG2.text, ARG3.text, ARG5.text, ARG6.integer, ARG4.text, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R{{bNX̃J[\ʒu𓾂
// GetComboBoxCursor( ID$ )
unsigned int rfunc_GetComboBoxCursor(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return GetComboBoxCursor( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R{{bNX̃J[\ʒuݒ
// SetComboBoxCursor( ID$, n )
unsigned int rfunc_SetComboBoxCursor(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return SetComboBoxCursor( ARG1.text, ARG2.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNXXg̍쐬Jni̐쐬CheckBoxText́AXgr[̒Ɏ߂j
// StartCheckBoxList( ID$[, flag] )
unsigned int rfunc_StartCheckBoxList(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (NULL != addctrl(hWnd, CHKLIST_CTRL, 0, 0, 0, 0, 0, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else if ( args_typecheck(args, "si") ) {
		return (NULL != addctrl(hWnd, CHKLIST_CTRL, 0, ARG2.integer, 0, 0, 0, 0, 0, ARG1.text, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNXXg̍쐬I
// EndCheckBoxList()
unsigned int rfunc_EndCheckBoxList(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return (NULL != addctrl(hWnd, CHKLIST_CTRL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Rg[Ԃ(㉺)Ԃ󂯂
// space()
// space( Ԋu )
unsigned int rfunc_space(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		addctrl(hWnd, AC_DOWN, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		return 1;
	}
	else if ( args_typecheck(args, "i") ) {
		UINT i;

		for(i=0 ; i<ARG1.integer ; i++) {
			addctrl(hWnd, AC_DOWN, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		}

		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// S^XNւ̒ʒmsȉł͗\񂷂邾j
// notify()
unsigned int rfunc_notify(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		system_refresh(GetParent(hWnd), hWnd, 1); // PȒʒm\
		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// VFɎhāAS^XNւ̒ʒmsȉł͗\񂷂邾j
// refresh()
unsigned int rfunc_refresh(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		system_refresh(GetParent(hWnd), hWnd, 2); // ACRTCYuύX@̒ʒm\
		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// OSċNȉł͗\񂷂邾j
// reboot()
unsigned int rfunc_reboot(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		system_refresh(GetParent(hWnd), hWnd, 3); // OS̍ċN\
		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ϐݒ
// SetEnv( ϐ$, g$ )
unsigned int rfunc_setenv(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return (SetEnvironmentVariable(ARG1.text, ARG2.text) != 0)?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ̊ HKLM z̃L[ɏ݃ANZXł邩H
// isStandardAccount()
unsigned int rfunc_isStandardAccount(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return bCannotWriteHKLM == TRUE ? 1 : 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Windows NTn?
// isNT()
unsigned int rfunc_isnt(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return isNT;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Windows̃o[Wԍ major*100 + minor ŕԂ
// GetWindowsVersion()
unsigned int rfunc_GetWindowsVersion(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return winver;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Internet Explorermajor version
// GetIEVersion()
unsigned int rfunc_GetIEVersion(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return  iever;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// OS̊eo[W擾
// GetOSInfo(info)
unsigned int rfunc_GetOSInfo(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		if ( _stricmp(ARG1.text, "isNT") == 0 ) {
			return isNT;	// Windows NTnȂ1AłȂȂ 0
		}
		else if ( _stricmp(ARG1.text, "IEver") == 0 ) {
			return iever;	// 擾\ȂIẼW[o[W
		}
		else if ( _stricmp(ARG1.text, "winver") == 0 ) {
			return winver;	// Windows ̃o[W(major*100+minor)
		}
		else if ( _stricmp(ARG1.text, "is64bit") == 0 ) {
			// Rnsf7.exex64px86pԂisWindowsbitł͂ȂƂɒ!!j
#ifdef _WIN64
			return 1;
#else
			return 0;
#endif
		}
		else if ( _stricmp(ARG1.text, "wow64") == 0 ) {
			// Rnsf7.exeWOW64zœĂ邩ǂԂix86łRnsf.exex64 OSœĂꍇ̂1j
#ifdef _WIN64
			return 0;
#else
			return tf_IsWow64Process();
#endif
		}
		else {
			OSVERSIONINFOEX oviex;

			ZeroMemory( &oviex, sizeof(OSVERSIONINFOEX) );
			oviex.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
			GetVersionEx((OSVERSIONINFO *)&oviex);

			if ( _stricmp(ARG1.text, "Major") == 0 ) {
				return oviex.dwMajorVersion;	// Windows̃W[o[W
			}
			else if ( _stricmp(ARG1.text, "Minor") == 0 ) {
				return oviex.dwMinorVersion;	// Windows̃}Ci[o[W
			}
			else if ( _stricmp(ARG1.text, "Build") == 0 ) {
				return oviex.dwBuildNumber;		// Windows̃rhio
			}
			else if ( _stricmp(ARG1.text, "Platform") == 0 ) {
				return oviex.dwPlatformId;		// Windows̃vbgtH[ID(0:Win32s 1:Win9x 2:WinNT)
			}
			else if ( _stricmp(ARG1.text, "SPMajor") == 0 ) {
				return oviex.wServicePackMajor;	// T[rXpbÑW[o[W
			}
			else if ( _stricmp(ARG1.text, "SPMinor") == 0 ) {
				return oviex.wServicePackMinor;	// T[rXpbÑ}Ci[o[W
			}
			else if ( _stricmp(ARG1.text, "SuiteMask") == 0 ) {
				return oviex.wSuiteMask;	// erbg̑gݍ킹ŁAOS̏\
											// VER_SUITE_SMALLBUSINESS             0x00000001
											// VER_SUITE_ENTERPRISE                0x00000002
											// VER_SUITE_BACKOFFICE                0x00000004
											// VER_SUITE_COMMUNICATIONS            0x00000008
											// VER_SUITE_TERMINAL                  0x00000010
											// VER_SUITE_SMALLBUSINESS_RESTRICTED  0x00000020
											// VER_SUITE_EMBEDDEDNT                0x00000040
											// VER_SUITE_DATACENTER                0x00000080
											// VER_SUITE_SINGLEUSERTS              0x00000100
											// VER_SUITE_PERSONAL                  0x00000200
											// VER_SUITE_BLADE                     0x00000400
											// VER_SUITE_EMBEDDED_RESTRICTED       0x00000800
			}
			else if ( _stricmp(ARG1.text, "ProductType") == 0 ) {
				return oviex.wProductType;	// ǉ(0:Ή 1:Workstation(Professional, Home)
											//			2:hCRg[ 3:NTT[o)
			}
			else if ( _stricmp(ARG1.text, "ProductInfo") == 0 ) { // Vistaȍ~
				typedef BOOL (WINAPI *PFUNC_GetProductInfo)(DWORD, DWORD, DWORD, DWORD, PDWORD);
				PFUNC_GetProductInfo pGetProductInfo = NULL;
				// GetProcAddressɂAKernel32.dllGetProductInfõAhX𒼐ڎ擾
				pGetProductInfo = (PFUNC_GetProductInfo)GetProcAddress(GetModuleHandle("kernel32.dll"), "GetProductInfo");

				if (pGetProductInfo) {
					DWORD dwReturnedProductType = 0;

				   // GetProductInfǒďo
					if ( pGetProductInfo(oviex.dwMajorVersion, oviex.dwMinorVersion, oviex.wServicePackMajor, oviex.wServicePackMinor, &dwReturnedProductType) ) {
						// 
						return dwReturnedProductType;
					}
				}
			}
		}

		return ERRORVALUE;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// OS̗lXȏ擾
// GetSystemMetrics(nIndex)
unsigned int rfunc_GetSystemMetrics(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		return GetSystemMetrics(ARG1.integer);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ̃rbg1ɂƂ̒l𓾂
// bit( n )
unsigned int rfunc_bit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		return ( 1 << ARG1.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// (Shift-JIS)1oCgڂǂ𒲂ׂ
// isKanji1( str$, n )
unsigned int rfunc_isKanji1(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return ( isKanji1(ARG1.text, ARG2.integer) );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNX̓e𓾂
// GetCheckBox( ID$ )
unsigned int rfunc_getcheckbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return GetCheckBox( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ҏW{bNX̓e𐔒lœ
// GetEditBoxNum( ID$ )
unsigned int rfunc_geteditboxnum(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return atoi( GetEditBox( ARG1.text ) );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// `FbN{bNX̏Ԃݒ
// SetCheckBox( ID$, <0|1|2> )
unsigned int rfunc_setcheckbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return SetCheckBox( ARG1.text, ARG2.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ҏW{bNX̓e𐔒lŐݒ肷
// SetEditBoxNum( ID$, l )
unsigned int rfunc_seteditboxnum(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		char itbuf[16];
		BOOL rv = ERRORVALUE;

		if ( 0 == _ultoa_s(ARG2.integer, itbuf, _countof(itbuf), 10) ) {
			rv = SetEditBox( ARG1.text, itbuf );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ҏW{bNX̓e𕶎Őݒ肷
// SetEditBox( ID$, $ )
unsigned int rfunc_seteditbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return SetEditBox( ARG1.text, ARG2.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ACRݒ肷
// SetIconBox( ID$, ACR$ )
unsigned int rfunc_seticonbox(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return SetIconBox( ARG1.text, ARG2.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// eLXgE`FbN{bNXE{^̕ݒ肷
// SetTextCtrl( ID$, $ )
unsigned int rfunc_settextctrl(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return SetTextCtrl( ARG1.text, ARG2.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ̕𓾂
// strlen( $ )
unsigned int rfunc_strlen(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return lstrlen( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// z̑傫𓾂/̕𓾂
// sizeof( <l | $ | ^z$[] | l^z[]> )
unsigned int rfunc_sizeof(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "r") ) {
		return sizeof_variables_d( ARG1.text );
	}
	else if ( args_typecheck(args, "a") ) {
		return sizeof_variables( ARG1.text );
	}
	else if ( args_typecheck(args, "s") ) {
		return lstrlen( ARG1.text )+1;
	}
	else if ( args_typecheck(args, "i") ) {
		return sizeof(UINT);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// 񒆂n(0`)ڂ̕R[h𓾂
// GetAsciiCode( $, n )
unsigned int rfunc_GetAsciiCode(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		if ( (UINT)lstrlen(ARG1.text) > ARG2.integer ) {
			return (unsigned)( ARG1.text[ARG2.integer] );
		}
		return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// 񒆂̓̃rbg𓾂
// GetStrBit( $, oCg?<0->, rbg?<0-7> )
unsigned int rfunc_getstrbit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sii") ) {
		if ( strlen(ARG1.text) > (size_t)ARG2.integer )
			return (int)( ((unsigned char)ARG1.text[ARG2.integer] >> ARG3.integer) & 1 );
		else
			return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// sҏW{bNX̍s𓾂
// GetMultiEditLineCount( ID$ )
unsigned int rfunc_GetMultiEditLineCount(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return GetMultiEditLineCount( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// sҏW{bNX̓e`FbNB`FbNʂ checkMultiEdit() ̖߂lQƁB
// CheckMultiEdit( ID$ )
unsigned int rfunc_checkmultiedit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return checkMultiEdit( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// sҏW{bNXA
// MultiEditSearch( ID$, text$ )
// 񂪌΍ڔԍԂAȂ ERROR Ԃ
unsigned int rfunc_MultiEditSearch(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return MultiEdit_Search( ARG1.text, ARG2.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXg֐̏
// RegWriteInt( Key$, Entry$,  )
// RegWriteInteger( Key$, Entry$,  )
unsigned int rfunc_regwriteint(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssi") ) {
		HKEY hKey;

		if (NULL != (hKey = tRegOpenKey( NULL, ARG1.text, 1 )) ) {
			UINT rv;

			rv = (UINT)tRegWriteInteger( hKey, ARG2.text, ARG3.integer );
			if (!rv) {
				LONG lasterr = tRegGetLastError();
				if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteInt)", "WXgL['", ARG1.text,
									 "'̃Gg'",ARG2.text,"'ւ݂̏sƂăG[ɂȂ܂B\nAPI񍐂F",
									 getLastErrorString(lasterr));
				}
			}
			RegCloseKey( hKey );
			return rv;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteInt)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXg֕̏
// RegWriteSz( Key$, Entry$, $ )
// RegWriteString( Key$, Entry$, $ )
unsigned int rfunc_regwritesz(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		HKEY hKey;
		UINT rv;

		if (NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_CREATE )) ) {
			rv = (UINT)tRegWriteString( hKey, ARG2.text, ARG3.text, TREG_SZ );
			if (!rv) {
				LONG lasterr = tRegGetLastError();
				if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteSz)", "WXgL['", ARG1.text,
									 "'̃Gg'",ARG2.text,"'ւ݂̏sƂăG[ɂȂ܂B\nAPI񍐂F",
									 getLastErrorString(lasterr));
				}
			}
			RegCloseKey( hKey );
			return rv;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteSz)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXg֓WJ̏
// RegWriteExpandSz( Key$, Entry$, $ )
// RegWriteExpandString( Key$, Entry$, $ )
unsigned int rfunc_regwriteexpandsz(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		HKEY hKey;
		UINT rv;

		if (NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_CREATE )) ) {
			rv = (UINT)tRegWriteString( hKey, ARG2.text, ARG3.text, TREG_EXPAND_SZ );
			if (!rv) {
				LONG lasterr = tRegGetLastError();
				if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteExpandSz)", "WXgL['", ARG1.text,
									 "'̃Gg'",ARG2.text,"'ւ݂̏sƂăG[ɂȂ܂B\nAPI񍐂F",
									 getLastErrorString(lasterr));
				}
			}
			RegCloseKey( hKey );
			return rv;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteExpandSz)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgփoCif[^̏ (bytew肷`)
// RegWriteByte( Key$, Entry$, oCg<0->,<0-255> )
unsigned int rfunc_regwritebyte(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssii") ) {
		HKEY hKey;
		int  l;
		UINT rv;
		char *buf;

		if (NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_CREATE )) ) {
			l = tRegValueExist( hKey, ARG2.text );
			if (l <= 0) {
				l = ARG3.integer+1;
				buf = (char *)calloc( 1, l );
			}
			else if ( l <= (signed)ARG3.integer ) {
				l = ARG3.integer+1;
				buf = (char *)calloc( 1, l );
				tRegReadString( hKey, ARG2.text, buf, l );
			}
			else {
				buf = (char *)calloc( 1, l );
				tRegReadString( hKey, ARG2.text, buf, l );
			}
				
			buf[ ARG3.integer ] = (char)ARG4.integer;

			rv = (UINT)tRegWriteBinary( hKey, ARG2.text, buf, l );
			if (!rv) {
				LONG lasterr = tRegGetLastError();
				if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteByte)", "WXgL['", ARG1.text,
									 "'̃Gg'",ARG2.text,"'ւ݂̏sƂăG[ɂȂ܂B\nAPI񍐂F",
									 getLastErrorString(lasterr));
				}
			}
			RegCloseKey( hKey );
			safefree( buf );

			return rv;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteByte)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgփoCif[^̏ (bitw肷`)
// RegWriteBit( Key$, Entry$, oCg<0->, rbg<0-7>, <0|1> )
unsigned int rfunc_regwritebit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssiii") ) {
		HKEY hKey;
		int  l;
		UINT rv;
		char *buf;

		if (NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_CREATE )) ) {
			l = tRegValueExist( hKey, ARG2.text );
			if (l <= 0) {
				l = ARG3.integer+1;
				buf = (char *)calloc( 1, l );
			}
			else if ( l <= (signed)ARG3.integer ) {
				l = ARG3.integer+1;
				buf = (char *)calloc( 1, l );
				tRegReadString( hKey, ARG2.text, buf, l );
			}
			else {
				buf = (char *)calloc( 1, l );
				tRegReadString( hKey, ARG2.text, buf, l );
			}

			if ( ARG5.integer != 0 ) {
				buf[ARG3.integer] |= (1 << ARG4.integer);
			}
			else {
				buf[ARG3.integer] &= (~(1 << ARG4.integer));
			}

			rv = tRegWriteBinary( hKey, ARG2.text, buf, l );
			if (!rv) {
				LONG lasterr = tRegGetLastError();
				if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteBit)", "WXgL['", ARG1.text,
									 "'̃Gg'",ARG2.text,"'ւ݂̏sƂăG[ɂȂ܂B\nAPI񍐂F",
									 getLastErrorString(lasterr));
				}
			}
			RegCloseKey( hKey );
			safefree( buf );

			return rv;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteBit)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXg琔l̓ǂݏo
// RegReadInt( Key$, Entry$, ftHg )
// RegReadInteger( Key$, Entry$, ftHg )
unsigned int rfunc_regreadint(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssi") ) {
		HKEY hKey;
		UINT rv;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			rv = tRegReadInteger(hKey, ARG2.text, ARG3.integer);
			RegCloseKey( hKey );
		}
		else
			rv = ARG3.integer;

		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXg̃oCil̃oCg̓ǂݏo
// RegReadByte( Key$, Entry$, ftHg<0-255>, oCg?<0-> )
unsigned int rfunc_regreadbyte(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssii") ) {
		HKEY hKey;
		unsigned char *value = NULL;
		int  l = 0, rv = ERRORVALUE;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			if ( 0 < (l = tRegValueExist(hKey, ARG2.text)) && l > (signed)ARG4.integer) {
				value = (unsigned char *)zalloc( l );
				if ( value ) {
					tRegReadString(hKey, ARG2.text, (char *)value, l);
					rv = value[ ARG4.integer ];
					safefree( value );
				}
			}
			else {
				rv = ARG3.integer;
			}
			RegCloseKey( hKey );
		}
		else
			rv = ARG3.integer;

		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXg̃oCil̃rbg̓ǂݏo
// RegReadBit( Key$, Entry$, ftHg<0|1>, oCg?<0->, rbg?<0-7> )
unsigned int rfunc_regreadbit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssiii") ) {
		HKEY hKey;
		unsigned char *value = NULL;
		int  l = 0, rv = ERRORVALUE;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			if ( 0 < (l = tRegValueExist(hKey, ARG2.text)) && l > (signed)ARG4.integer) {
				value = (unsigned char *)zalloc( l );
				if ( value ) {
					tRegReadString(hKey, ARG2.text, (char *)value, l);
					rv = ((value[ ARG4.integer ] >> ARG5.integer) & 1);
					safefree( value );
				}
			}
			else {
				rv = ARG3.integer;
			}
			RegCloseKey( hKey );
		}
		else {
			rv = ARG3.integer;
		}

		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgl폜
// RegDeleteValue( Key$, Entry$ )
unsigned int rfunc_regdeletevalue(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		HKEY hKey;
		UINT rv;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, 0)) ) {
			LONG lasterr = RegDeleteValue(hKey, ARG2.text);
			if (lasterr != ERROR_SUCCESS) {
				if (lasterr != ERROR_FILE_NOT_FOUND && rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegDeleteValue)", "WXgL['", ARG1.text,
									 "'̃Gg'",ARG2.text,"'폜悤ƂăG[ɂȂ܂B\nAPI񍐂F",
									 getLastErrorString(lasterr));
				}
				rv = 0;
			}
			else {
				rv = 1;
			}

			RegCloseKey( hKey );
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && lasterr != ERROR_FILE_NOT_FOUND && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegDeleteValue)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			rv = 0;
		}

		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgL[ׂ̂Ă̒l폜iTuL[̒܂ł͍폜Ȃj
// RegDeleteAllValue( Key$, Entry$ )
unsigned int rfunc_regdeleteallvalue(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		HKEY hKey;
		UINT rv = FALSE;
		LONG lasterr;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, 0)) ) {
			int i;
			DWORD numValues;       // TuL[̐
			DWORD lenMaxValueName; // TuL[̍ő咷

			if (ERROR_SUCCESS == (lasterr = RegQueryInfoKey(hKey, NULL, 0, NULL, NULL, NULL, NULL, &numValues, &lenMaxValueName, NULL, NULL, NULL))) {
				if (numValues > 0) {
					char **valuenames = (char **)calloc(numValues, sizeof(char *));   // l邽߂̃Xg̃m
					char *valuename1 = (char *)calloc(lenMaxValueName+1, sizeof(WCHAR)); // P̒l邽߂̃mہiƂ肠ő咷ŊmہjBWinNTRegQueryInfoKey͕PʂŕԂ̂ŁAoCgPʂw肷Ƃ̓TCYsizeof(WCHARA){Kv

					// l񋓂ȂAlXg֊i[ĂBɃm
					for(i=0 ; i<(int)numValues ; ++i) {
						lenMaxValueName = (lenMaxValueName + 1) * sizeof(WCHAR);
						RegEnumValue(hKey, i, valuename1, &lenMaxValueName, NULL, NULL, NULL, NULL);
						valuenames[i] = _strdup(valuename1);
					}

					// P̒l邽߂̃́A͂svȂ̂ō폜
					safefree(valuename1);

					rv = TRUE;
					// XgɊi[ꂽlɍ폜Ă
					for(i=0 ; i<(int)numValues ; ++i) {
						if (ERROR_SUCCESS != (lasterr = RegDeleteValue(hKey, valuenames[i]))) {
							rv = FALSE; // 1ł폜sAS̓IɎs
							if (rnsf7RegRead("regErrorMessage", 0)) {
								dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegDeleteAllValue)", "WXgL['", ARG1.text,
												 "'̃Gg'",valuenames[i],"'폜悤ƂăG[ɂȂ܂B\nAPI񍐂F",
												 getLastErrorString(lasterr));
							}
						}
					}

					// XgɊi[ꂽl̃GAJ
					for(i=(int)numValues-1 ; i>=0 ; --i) {
						safefree(valuenames[i]);
					}
					safefree(valuenames);
				}
			}
			else {
				if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegDeleteAllValue)", "WXgL['", ARG1.text,
									 "'𒲂ׂ悤ƂăG[ɂȂ܂B\nAPI񍐂F",
									 getLastErrorString(lasterr), NULL, NULL);
				}
			}

			RegCloseKey( hKey );
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && lasterr != ERROR_FILE_NOT_FOUND && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegDeleteAllValue)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			rv = 0;
		}

		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgL[쐬
// RegCreateKey( Key$ )
// RegCreateKey( Key$, SubKey$ )
unsigned int rfunc_regcreatekey(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	HKEY hKey;

	if ( args_typecheck(args, "s") ) {
		if ( NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_CREATE)) ) {
            RegCloseKey( hKey );
			return 1;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegCreateKey/1)", "WXgL['", ARG1.text,
								 "'낤ƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			return 0;
		}
	}
	else if ( args_typecheck(args, "ss") ) {
		if ( NULL != (hKey = tRegOpenSubKey(NULL, ARG1.text, ARG2.text, TREG_OPEN_CREATE)) ) {
			RegCloseKey( hKey );
			return 1;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegCreateKey/2)", "WXgL['", ARG1.text, "\\", ARG2.text,
								 "'낤ƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr));
			}
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgL[폜
// RegDeleteKey( Key$ )
// RegDeleteKey( Key$, SubKey$ )
unsigned int rfunc_regdeletekey(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	char *key, *subkey = NULL;
	BYTE one_param_flag = 0;

	if ( args_typecheck(args, "s") ) {
		UINT i;

		if ( strchr(ARG1.text, '\\') == 0 )
			return 0;

		one_param_flag = 1;
		key = _strdup(ARG1.text); // 킯ɂ͂Ȃ̂ŁAm
		for( i=lstrlen(key)-1 ; i>0 ; i-- ) {
			if ( key[i] == '\\' && !isKanji1(key,i-1) ) {
				key[i] = 0;
				subkey = &key[i+1];
				break;
			}
		}
		if ( subkey == NULL ) {
			safefree(key);
			return 0;
		}
	}
	else if ( args_typecheck(args, "ss") ) {
		key = ARG1.text;
		subkey = ARG2.text;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}

	{
		HKEY hKey = 0;
		UINT rv = 0;
		LONG lasterr = ERROR_SUCCESS;

		if ( strchr(key,'\\') == 0 ) {
			hKey = tRegHiveKey( key );
			if ( hKey ) {
                rv = (ERROR_SUCCESS == (lasterr = RegDeleteKey(hKey, subkey)));
			}
		}
		if (NULL != (hKey = tRegOpenKey(NULL, key, 0)) ) {
			rv = (ERROR_SUCCESS == (lasterr = RegDeleteKey(hKey, subkey)));
			RegCloseKey( hKey );
		}
		else {
			lasterr = tRegGetLastError();
		}

		if (lasterr != ERROR_SUCCESS && lasterr != ERROR_FILE_NOT_FOUND && rnsf7RegRead("regErrorMessage", 0)) {
			dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegDeleteKey)", "WXgL['", key,
							 "'̃TuL['",subkey,"'폜悤ƂăG[ɂȂ܂B\nAPI񍐂F",
							 getLastErrorString(lasterr));
		}

		if (one_param_flag) { // p[^P̏ꍇAkeystrdup̂ŁAŉ
			safefree(key);
		}

		return rv;
	}
}

// WXgl݂̑mF (l݂1A݂Ȃ0Ԃ)
// RegValueExist( Key$, Entry$ )
unsigned int rfunc_RegValueExist(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		HKEY hKey;
		int  rv;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			rv = tRegValueExist(hKey, ARG2.text);
			RegCloseKey( hKey );
			return (rv != -1);
		}
		else {
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgL[ʂ̃TuL[ƍ폜
// RegDeleteSubKeys( Key$ )
// RegDeleteSubKeys( Key$, SubKey$ )
unsigned int rfunc_regdeletesubkeys(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	char *key, *subkey = NULL;
	BYTE one_param_flag = 0;

	if ( args_typecheck(args, "s") ) {
		UINT i;

		if ( strchr(ARG1.text, '\\') == 0 )
			return 0;

		one_param_flag = 1;
		key = _strdup(ARG1.text); // 킯ɂ͂Ȃ̂ŁAm
		for( i=lstrlen(key)-1 ; i>0 ; i-- ) {
			if ( key[i] == '\\' && !isKanji1(key,i-1) ) {
				key[i] = 0;
				subkey = &key[i+1];
				break;
			}
		}
		if ( subkey == NULL ) {
			safefree(key);
			return 0;
		}
	}
	else if ( args_typecheck(args, "ss") ) {
		key = ARG1.text;
		subkey = ARG2.text;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}

	{
		HKEY hKey = 0;
		UINT rv = 0;

		if ( strchr(key,'\\') == 0 ) {
			hKey = tRegHiveKey( key );
			if ( hKey ) {
                rv = (TRUE == tRegDeleteSubKey(hKey, subkey));
			}
		}
		if (NULL != (hKey = tRegOpenKey(NULL, key, 0)) ) {
			rv = (TRUE == tRegDeleteSubKey(hKey, subkey));
			RegCloseKey( hKey );
		}

		if (rv != TRUE) {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && lasterr != ERROR_FILE_NOT_FOUND && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegDeleteSubKeys)", "WXgL['", key,
								 "'̃TuL['",subkey,"'폜悤ƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr));
			}
		}

		if (one_param_flag) { // p[^P̏ꍇAkeystrdup̂ŁAŉ
			safefree(key);
		}

		return rv;
	}
}

// WXgl̃TCYԂ (l݂Ȃ-1Ԃ)
// RegValueSize( Key$, Entry$ )
unsigned int rfunc_RegValueSize(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		HKEY hKey;
		int  rv; // tRegValueExist̕ԋplint^

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			rv = tRegValueExist(hKey, ARG2.text);
			RegCloseKey( hKey );
			return rv; // -1ERRORVALUEɕϊ邱Ƃ҂Ă
		}
		else {
			return ERRORVALUE;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgľ^Ԃ (l݂Ȃ0Ԃ)
// RegValueType( Key$, Entry$ )
unsigned int rfunc_RegValueType(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		HKEY hKey;
		UINT rv;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			rv = tRegValueType(hKey, ARG2.text);
			RegCloseKey( hKey );
			return rv;
		}
		else {
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgL[݂̑mF (݂1A݂Ȃ0Ԃ)
// RegKeyExist( Key$ )
unsigned int rfunc_RegKeyExist(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		HKEY hKey;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			RegCloseKey( hKey );
			return 1;
		}
		else {
			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgGgύXi1As0Ԃj
// RegRenameValue( Key$, OldName$, NewName$ )
unsigned int rfunc_RegRenameValue(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		HKEY hKey;
		int  rv = FALSE;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, 0)) ) {
			rv = tRegRenValue(hKey, ARG2.text, ARG3.text);
			if (rv != TRUE) {
				LONG lasterr = tRegGetLastError();
				if (rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegRenameValue)", "WXgL['", ARG1.text,
								 "'̃Gg'",ARG2.text,"'̖OύX悤ƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr));
				}
			}
			RegCloseKey( hKey );
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && lasterr != ERROR_FILE_NOT_FOUND && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegRenameValue)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
		}

		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// (OSɂĂ͎gȂ)
// WXgL[̃l[
unsigned int rfunc_regrenamekey(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		HKEY hKey;
		int  rv = FALSE;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, 0)) ) {
			rv = tRegRenameKey(hKey, ARG2.text, ARG3.text);
			if (rv != ERROR_SUCCESS) {
				if (rnsf7RegRead("regErrorMessage", 0)) {
					dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegRenameKey)", "WXgL['", ARG1.text,
								 "'̃TuL['",ARG2.text,"'̖OύX悤ƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(rv));
				}
			}
			RegCloseKey( hKey );
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && lasterr != ERROR_FILE_NOT_FOUND && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegRenameKey)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
		}

		return rv == 0 ? TRUE : FALSE;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@C琔lǂݍ
// iniReadInt( file$, section$, key$, default )
// iniReadInteger( file$, section$, key$, default )
unsigned int rfunc_iniReadInt(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sssi") ) {
		return GetPrivateProfileInt( ARG2.text, ARG3.text, ARG4.integer, ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@Cɐl
// iniWriteInt( file$, section$, key$, value )
// iniWriteInteger( file$, section$, key$, value )
unsigned int rfunc_iniWriteInt(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sssi") ) {
		char itbuf[16];

		if ( 0 != _ultoa_s(ARG4.integer, itbuf, _countof(itbuf), 10) ) {
			// G[̏ꍇ"err"𖄂ߍ
			lstrcpy(itbuf, "err");
		}
		return WritePrivateProfileString( ARG2.text, ARG3.text, itbuf, ARG1.text )?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@Cɕ
// iniWriteString( file$, section$, key$, value$ )
unsigned int rfunc_iniWriteString(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssss") ) {
		return WritePrivateProfileString( ARG2.text, ARG3.text, ARG4.text, ARG1.text )?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@CL[
// iniDeleteKey( file$, section$, key$ )
unsigned int rfunc_iniDeleteKey(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		return WritePrivateProfileString( ARG2.text, ARG3.text, NULL, ARG1.text )?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@CZNV̐𓾂
// iniNumSection( file$ )
unsigned int rfunc_iniNumSection(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return tiniNumSection( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@C̃ZNVL[̐𓾂
// iniNumKey( file$, section$ )
unsigned int rfunc_iniNumKey(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return tiniNumKey( ARG1.text, ARG2.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@CoCif[^ǂݍ
// iniReadBinary( inifile$, section$, key$, ints[] )
unsigned int rfunc_iniReadBinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sssa") ) {
		unsigned len, i, rv;
		unsigned char *value;

		len = sizeof_variables( ARG4.text );
		if ( len != NO_VALUE ) {
			value = (unsigned char *)calloc( len, 1 );
			if ( value ) {
				if ( GetPrivateProfileStruct( ARG2.text, ARG3.text, value, len, ARG1.text ) ) {
					for(i=0 ; i<len ; i++) {
						setVariable_a(ARG4.text, i, (UINT)value[i]);
					}
					rv = 1;
				}
				else {
					rv = 0; // ǂݍݎs
				}

				safefree( value );
				return rv;
			}
			else {
				return 0; // s
			}
		}
		else {
			char *mes;

			mes = zalloc( strlen(ARG4.text) + 200 );
			if ( mes ) {
				wsprintf( mes, "iniReadBinary()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂BWXgւ݂͍̏s܂B", ARG4.text);
				destroy_splash_window();
				MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
				safefree( mes );
			}

			return 0;
		}	
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@CɃoCif[^
// iniWriteBinary( inifile$, section$, key$, ints[] )
unsigned int rfunc_iniWriteBinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sssa") ) {
		unsigned len, u, i, rv;
		unsigned char *value;

		len = sizeof_variables( ARG4.text );
		if ( len != NO_VALUE ) {
			value = (unsigned char *)calloc( len, 1 );
			if ( value ) {
				for(i=0 ; i<len ; i++) {
					getVariable_a(ARG4.text, i, &u);
					value[i] = (unsigned char)u;
				}
				rv = WritePrivateProfileStruct( ARG2.text, ARG3.text, value, len, ARG1.text )?1:0;
				safefree( value );
				return rv;
			}
			else {
				return 0; // s
			}
		}
		else {
			char *mes;

			mes = zalloc( strlen(ARG4.text) + 200 );
			if ( mes ) {
				wsprintf( mes, "iniWriteBinary()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂BWXgւ݂͍̏s܂B", ARG4.text);
				destroy_splash_window();
				MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
				safefree( mes );
			}

			return 0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// 𐔒lɕϊi0+$ łϊłj
// toInt( $ )
unsigned int rfunc_toInt(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return atou( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Rg[L
// Enable( ID$ )
unsigned int rfunc_enable(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (UINT)DisableControl( ARG1.text, TRUE );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// Rg[𖳌iOCAEgj
// Disable( ID$ )
unsigned int rfunc_disable(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (UINT)DisableControl( ARG1.text, FALSE );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// w肳ꂽIDIɃWXgɏƂ铮~(w1̂ݗL)
// Stop( ID$ )
unsigned int rfunc_stop(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (UINT)StopControl( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// w肳ꂽIDIɃWXgɏƂ铮s悤ɂ(w1̂ݗL)
// Active( ID$ )
unsigned int rfunc_active(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (UINT)ActiveControl( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// w肳ꂽID̃Rg[ɃtH[JX킹
// SetFocus( ID$ )
unsigned int rfunc_setfocus(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (UINT)SetFocusControl( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// DLL̊֐Ăяo(߂l͐l)
// CallDll( DLLt@C$, ֐$, ... )
unsigned int rfunc_CallDll(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args != NULL && args->type == UFCT_ARG_STRING && args->next != NULL && args->next->type == UFCT_ARG_STRING ) {
		HINSTANCE lib;
		RSC_CALLDLL_INT func;
		UINT rv;
		struct ARGS *p_args;

		lib = LoadDllLibrary( ARG1.text );
		if ( lib == NULL ) {
			*result = UFS_NOTFOUNDDLL;
			return ERRORVALUE;
		}
		func = (RSC_CALLDLL_INT)GetProcAddress( lib, ARG2.text );
		if ( func == NULL ) {
			*result = UFS_NOTFOUNDDLLFUNC;
			return ERRORVALUE;
		}

		// zϐ̖OĂ镔́A̔zϐ\\̂̃|C^ɍւ
		{
			p_args = args->next->next;

			while ( p_args ) {
				if ( p_args->type == UFCT_ARG_INTS ) {
					p_args->v.pva = search_pointer_a( p_args->v.text );
				}
				else if ( p_args->type == UFCT_ARG_STRINGS ) {
					p_args->v.pvda = search_pointer_d_a( p_args->v.text );
				}
				p_args = p_args->next;
			} 
		}
		rv = func( hWnd, args->next->next );
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// st@CĂяo
// CallExe( R}hC$ )		- siI܂ő҂B߂lErrorLevelj
unsigned int rfunc_CallExe(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		STARTUPINFO sinfo;
		PROCESS_INFORMATION pinfo;
		UINT		rv;
		HANDLE		hph;

		ZeroMemory( &sinfo, sizeof( STARTUPINFO ) );
		ZeroMemory( &pinfo, sizeof( PROCESS_INFORMATION ) );
		sinfo.cb = sizeof( STARTUPINFO );
		sinfo.dwFlags = STARTF_USESHOWWINDOW;
		sinfo.wShowWindow = SW_SHOWNORMAL;
		
		if ( CreateProcess( NULL, ARG1.text, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
			WaitForInputIdle( pinfo.hProcess, INFINITE );
			WaitForSingleObject( pinfo.hProcess, INFINITE );
			if ( isNT ) hph = OpenProcess( PROCESS_QUERY_INFORMATION, FALSE, pinfo.dwProcessId );
			GetExitCodeProcess(pinfo.hProcess, (LPDWORD)&rv);
			if ( isNT ) CloseHandle(hph);

			CloseHandle(pinfo.hProcess);
			return rv;
		}
		else {
			*result = UFC_CANTRUNEXE;
            return ERRORVALUE;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// st@CĂяo
// CallExeAsync( R}hC$ )	- 񓯊siI܂ő҂ȂB߂l0j
unsigned int rfunc_CallExeAsync(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		STARTUPINFO sinfo;
		PROCESS_INFORMATION pinfo;

		ZeroMemory( &sinfo, sizeof( STARTUPINFO ) );
		ZeroMemory( &pinfo, sizeof( PROCESS_INFORMATION ) );
		sinfo.cb = sizeof( STARTUPINFO );
		sinfo.dwFlags = STARTF_USESHOWWINDOW;
		sinfo.wShowWindow = SW_SHOWNORMAL;
		
		if ( CreateProcess( NULL, ARG1.text, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
			CloseHandle(pinfo.hProcess);
			return 0;
		}
		else {
			*result = UFC_CANTRUNEXE;
            return ERRORVALUE;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R}hCĂяo(߂l0)
// CallCmd( R}hC$ )		- siI܂ő҂j
unsigned int rfunc_CallCmd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		STARTUPINFO sinfo;
		PROCESS_INFORMATION pinfo;

		ZeroMemory( &sinfo, sizeof( STARTUPINFO ) );
		ZeroMemory( &pinfo, sizeof( PROCESS_INFORMATION ) );
		sinfo.cb = sizeof( STARTUPINFO );
		sinfo.dwFlags = STARTF_USESHOWWINDOW;
		sinfo.wShowWindow = SW_SHOWNORMAL;
		
		if ( !CreateProcess( NULL, ARG1.text, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
			char *cl = (char *)zalloc(lstrlen(ARG1.text) + 30);

			if ( cl ) {
				lstrcpy(cl, isNT?"CMD.EXE /C ":"COMMAND.COM /C ");
				lstrcat(cl, ARG1.text);
				if ( !CreateProcess( NULL, cl, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
					lstrcpy(cl, isNT?"CMD.EXE /C START ":"COMMAND.COM /C START ");
					lstrcat(cl, ARG1.text);
					if ( !CreateProcess( NULL, cl, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
						safefree( cl );
						return ERRORVALUE;
					}
				}

				safefree( cl );
			}
			else {
                return ERRORVALUE;
			}
		}

		// R}hAĂ܂ŃEFCg
		WaitForInputIdle( pinfo.hProcess, INFINITE );
		WaitForSingleObject( pinfo.hProcess, INFINITE );
		CloseHandle(pinfo.hProcess);

		return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R}hCĂяo(߂l0)
// CallCmdAsync( R}hC$ )	- 񓯊siI܂ő҂Ȃj
unsigned int rfunc_CallCmdAsync(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		STARTUPINFO sinfo;
		PROCESS_INFORMATION pinfo;

		ZeroMemory( &sinfo, sizeof( STARTUPINFO ) );
		ZeroMemory( &pinfo, sizeof( PROCESS_INFORMATION ) );
		sinfo.cb = sizeof( STARTUPINFO );
		sinfo.dwFlags = STARTF_USESHOWWINDOW;
		sinfo.wShowWindow = SW_SHOWNORMAL;
		
		if ( !CreateProcess( NULL, ARG1.text, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
			char *cl = (char *)zalloc(lstrlen(ARG1.text) + 30);

			if ( cl ) {
				lstrcpy(cl, isNT?"CMD.EXE /C ":"COMMAND.COM /C ");
				lstrcat(cl, ARG1.text);
				if ( !CreateProcess( NULL, cl, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
					lstrcpy(cl, isNT?"CMD.EXE /C START ":"COMMAND.COM /C START ");
					lstrcat(cl, ARG1.text);
					if ( !CreateProcess( NULL, cl, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &sinfo, &pinfo ) ) {
						safefree( cl );
						return ERRORVALUE;
					}
				}

				safefree( cl );
			}
			else {
                return ERRORVALUE;
			}
		}

		CloseHandle(pinfo.hProcess);

		return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// L[̒̃TuL[擾
// RegNumKey( Key$ )
unsigned int rfunc_RegNumKey(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		if ( strchr(ARG1.text,'\\') == 0 ) {
			HKEY hKey;
			DWORD subkeys = 0;

			hKey = tRegHiveKey( ARG1.text );
			RegQueryInfoKey( hKey, NULL, NULL, NULL, &subkeys, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			return subkeys;
		}
		else {
			HKEY hKey;
			DWORD subkeys = 0;

			if ( NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_READONLY )) ) {
                RegQueryInfoKey( hKey, NULL, NULL, NULL, &subkeys, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				RegCloseKey( hKey );
			}
			return subkeys;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// L[̒̒l̐擾
// RegNumValue( Key$ )
unsigned int rfunc_RegNumValue(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		if ( strchr(ARG1.text,'\\') == 0 ) {
			HKEY hKey;
			DWORD values = 0;

			hKey = tRegHiveKey( ARG1.text );
			RegQueryInfoKey( hKey, NULL, NULL, NULL, NULL, NULL, NULL, &values, NULL, NULL, NULL, NULL);
			return values;
		}
		else {
			HKEY hKey;
			DWORD values = 0;

			if ( NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_READONLY )) ) {
                RegQueryInfoKey( hKey, NULL, NULL, NULL, NULL, NULL, NULL, &values, NULL, NULL, NULL, NULL);
				RegCloseKey( hKey );
			}
			return values;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgGgoCiœǂݏo
// RegReadBinary( Key$, Entry$, int[] )
unsigned int rfunc_RegReadBinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssa") ) {
		HKEY hKey;
		unsigned i, len, retval = 0;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			if (0 < (len = tRegValueExist( hKey, ARG2.text ))) {
				if ( 0 == resize_variables( ARG3.text, len ) ) {
					char *value = mtRegReadString(hKey, ARG2.text, NULL);
					if ( value ) {
						retval = 1;
						for(i=0 ; i<len ; i++) {
							setVariable_a(ARG3.text, i, (unsigned int)value[i]);
						}
						safefree( value );
					}
				}
			}

			RegCloseKey( hKey );
			return retval;
		}
		else
			return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// WXgGgoCiŏo
// RegWriteBinary( Key$, Entry$, int[], type )
unsigned int rfunc_RegWriteBinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssai") ) {
		HKEY hKey;
		unsigned retval = 0;
		unsigned i, len, u;
		LONG lasterr;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_CREATE)) ) {
			len = sizeof_variables( ARG3.text );
			if ( len != NO_VALUE ) {
				unsigned char *value = (unsigned char *)calloc( len, 1 );
				if ( value ) {
					for(i=0 ; i<len ; i++) {
						getVariable_a(ARG3.text, i, &u);
						value[i] = (unsigned char)u;
					}

					if (ERROR_SUCCESS == (lasterr = RegSetValueEx( hKey, ARG2.text, 0, ARG4.integer, value, len ))) {
						retval = 1;
					}
					else if (rnsf7RegRead("regErrorMessage", 0)) {
						dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteBinary)", "WXgL['", ARG1.text, "'̃Gg'", ARG2.text,
								 "'֏ƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr));
					}

					safefree( value );
				}
			}
			else {
				char *mes;

				mes = zalloc( strlen(ARG3.text) + 200 );
				if ( mes ) {
					wsprintf( mes, "RegWriteBinary()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂BWXgւ݂͍̏s܂B", ARG3.text);
					destroy_splash_window();
					MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
					safefree( mes );
				}
			}

			RegCloseKey( hKey );
			return retval;
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteBinary)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
			return 0; // WXgL[JȂ
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// w肳ꂽID݂邩ǂ
// isID( ID$ )
unsigned int rfunc_isID(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		UINT i;

		for(i=0 ; i<nctrls ; i++) {
			if ( rctrls[i].id && _stricmp(rctrls[i].id, ARG1.text) == 0 ) {
				return 1;
			}
		}
		return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// w肳ꂽID̃Rg[L
// isIDEnabled( ID$ )
unsigned int rfunc_isIDEnabled(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		UINT i;

		for(i=0 ; i<nctrls ; i++) {
			if ( rctrls[i].id && _stricmp(rctrls[i].id, ARG1.text) == 0 ) {
				return (IsWindowEnabled( rctrls[i].hCtrl )!=0)?1:0;
			}
		}
		return ERRORVALUE;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// _CAOɑ݂Rg[̐Ԃ
// numID()
unsigned int rfunc_numID(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return nctrls;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// _CAOJĂA܂́A[Kp]ĂAύXꂽ
// isChanged( id$ )
unsigned int rfunc_isChanged(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return isChanged( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ҏW_CAÕ^Cgݒ肷
// SetDialogTitle( $ )
unsigned int rfunc_SetDialogTitle(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return ( 0 != SetWindowText(hWnd, ARG1.text) );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// [̃^Cgݒ肷
// SetWindowTitle( $ )
unsigned int rfunc_SetWindowTitle(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return ( 0 != SetWindowText(GetParent(hWnd), ARG1.text) );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// 1̒當2TA(0-)ŌԂ(Ȃ΃G[(0xffffffff)Ԃ
// strstr( 1$, 2 )
unsigned int rfunc_strstr(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		char *p;

		p = sjisstr( ARG1.text, ARG2.text );
		if ( p )
			return (int)(p - ARG1.text);
		else
			return ERRORVALUE;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// 1̒當2TA(0-)ŌԂ(Ȃ΃G[(0xffffffff)Ԃ, p召ʂȂ
// strstri( 1$, 2 )
unsigned int rfunc_strstri(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		char *p;
		UINT r = ERRORVALUE;

		p = sjisstri(ARG1.text, ARG2.text);
		if ( p ) {
			r = (UINT)(p - ARG1.text);
		}
		return r;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@CRs[
// CopyFile( src$, dst$, FailIfExists )
unsigned int rfunc_CopyFile(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssi") ) {
		return (CopyFile( ARG1.text, ARG2.text, ARG3.integer ) != 0)?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@CQRs[
// CopyFiles( src$, dst$ )
unsigned int rfunc_CopyFiles(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		SHFILEOPSTRUCT fos;
		char *s, *d;
		int  rv = 0;

		s = calloc( lstrlen(ARG1.text)+2, 1 );
		if ( s ) {
			lstrcpy(s, ARG1.text);
			d = calloc( lstrlen(ARG2.text)+2, 1 );
			if ( d ) {
				lstrcpy(d, ARG2.text);
				fos.hwnd = hWnd;
				fos.wFunc = FO_COPY;
				fos.pFrom = s;
				fos.pTo = d;
				fos.fFlags = FOF_NOCONFIRMMKDIR;
				fos.fAnyOperationsAborted = FALSE;
				fos.hNameMappings = 0;
				fos.lpszProgressTitle = "t@C̃Rs[";
				rv = (SHFileOperation( &fos ) == 0)?1:0;
				safefree( d );
			}
			safefree( s );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@Cړ
// MoveFile( src$, dst$ )
unsigned int rfunc_MoveFile(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return (MoveFile( ARG1.text, ARG2.text ) != 0)?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@CQړ
// MoveFiles( src$, dst$ )
unsigned int rfunc_MoveFiles(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		SHFILEOPSTRUCT fos;
		char *s, *d;
		int  rv = 0;

		s = calloc( lstrlen(ARG1.text)+2, 1 );
		if ( s ) {
			lstrcpy(s, ARG1.text);
			d = calloc( lstrlen(ARG2.text)+2, 1 );
			if ( d ) {
				lstrcpy(d, ARG2.text);
				fos.hwnd = hWnd;
				fos.wFunc = FO_MOVE;
				fos.pFrom = s;
				fos.pTo = d;
				fos.fFlags = FOF_NOCONFIRMMKDIR;
				fos.fAnyOperationsAborted = FALSE;
				fos.hNameMappings = 0;
				fos.lpszProgressTitle = "t@C̈ړ";
				rv = (SHFileOperation( &fos ) == 0)?1:0;
				safefree( d );
			}
			safefree( s );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@C폜
// DeleteFile( file$ )
unsigned int rfunc_DeleteFile(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (DeleteFile( ARG1.text ) != 0)?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@CQ폜
// DeleteFiles( files$ )
unsigned int rfunc_DeleteFiles(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		SHFILEOPSTRUCT fos;
		char *p;
		int  rv = 0;

		// \0\0ŏIĂobt@邽߁A̒+2ŏ
		p = calloc( lstrlen(ARG1.text)+2, 1 );
		if ( p ) {
			lstrcpy( p, ARG1.text );
			fos.hwnd = hWnd;
			fos.wFunc = FO_DELETE;
			fos.pFrom = p;
			fos.pTo = NULL;
			fos.fFlags = FOF_NOCONFIRMMKDIR | FOF_NOCONFIRMATION;
			fos.fAnyOperationsAborted = FALSE;
			fos.hNameMappings = 0;
			fos.lpszProgressTitle = "t@C̍폜";
			rv = (SHFileOperation( &fos ) == 0)?1:0;
            safefree( p );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// tH_폜
// deletedirectory( folder$ )
unsigned int rfunc_DeleteDirectory(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (RemoveDirectory( ARG1.text ) != 0)?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// tH_̒̃t@CEtH_ċAIɍ폜B֎~͉Bgpō폜łȂꍇ͖ďs
// wtH_̂̂폜̂ł͂ȂAwtH_̒gɂ鎖ɒӁB
// EmptyDirectory( folder$ )
// EmptyDirectory( folder$, beforeDays ) c w肵Oɍ쐬ꂽ̂폜(beforeDays=0ŎwȂƓB11O, 22O, c)
unsigned int rfunc_EmptyDirectory(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (emptyDir( ARG1.text, NULL ) != 0)?1:0;
	}
	else if ( args_typecheck(args, "si") ) {
		if (ARG2.integer == 0) {
			return (emptyDir( ARG1.text, NULL ) != 0)?1:0;
		}
		else {
			SYSTEMTIME st;
			FILETIME ft;
			UINT64 ui64;

			// ݂̓t𓾂FILETIME^ɕϊAUINT64^100nsPʎԂ֍ĉ߁B
			GetSystemTime(&st);
			SystemTimeToFileTime(&st, &ft);
			ui64 = (UINT64)ft.dwHighDateTime<<32 | (UINT64)ft.dwLowDateTime;

			// 100nsPʎԂŁAARG2.integer O̎ԂvZ
			ui64 -= (UINT64)ARG2.integer * (UINT64)10000000 * (UINT64)60 * (UINT64)60 * (UINT64)24;

			// ĂFILETIME^֖߂
			ft.dwHighDateTime = (DWORD)(ui64>>32);
			ft.dwLowDateTime = (DWORD)(ui64&0xffffffff);

			return (emptyDir( ARG1.text, &ft ) != 0)?1:0;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// tH_쐬
// createdirectory( folder$ )
unsigned int rfunc_createdirectory(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (CreateDirectory( ARG1.text, NULL ) != 0)?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// V[gJbg쐬
// createshortcut( file$, arg$, link$ [, iconfile$, iconno ] )
unsigned int rfunc_createshortcut(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		return (UINT)MakeLink(ARG1.text, ARG2.text, ARG3.text);
	}
	else if ( args_typecheck(args, "ssssi") ) {
		return (UINT)MakeLinkIcon(ARG1.text, ARG2.text, ARG3.text, ARG4.text, ARG5.integer);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@C݂̑mF
// fileexist( file$ )
unsigned int rfunc_fileexist(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return (UINT)tFileExist(ARG1.text);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ChJ[hpĎw肵Oɍvt@C擾
// SearchFiles( wildcard$, files$[] )
unsigned int rfunc_SearchFiles(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sr") ) {
		HANDLE hFind;
		WIN32_FIND_DATA520 wfd;
		UINT nfound;

		nfound = 0;
		if ( INVALID_HANDLE_VALUE != (hFind = FindFirstFile520(ARG1.text, &wfd)) ) {
			do {
				if ( !(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) ) {
					if ( 0 == resize_variables_d( ARG2.text, nfound+1 ) ) {
						setVariable_d_a( ARG2.text, nfound++, wfd.cFileName );
					}
					else { // G[
						break;
					}
				}
			} while( FindNextFile520(hFind, &wfd) );
			FindClose( hFind );
		}
		return nfound;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ChJ[hpĎw肵OɍvfBNg擾
// SearchDirectorys( wildcard$, dirs$[] )
unsigned int rfunc_SearchDirectorys(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sr") ) {
		HANDLE hFind;
		WIN32_FIND_DATA520 wfd;
		UINT nfound;

		nfound = 0;
		if ( INVALID_HANDLE_VALUE != (hFind = FindFirstFile520(ARG1.text, &wfd)) ) {
			do {
				if ( wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {
					if ( 0 == resize_variables_d( ARG2.text, nfound+1 ) ) {
						setVariable_d_a( ARG2.text, nfound++, wfd.cFileName );
					}
					else { // G[
						break;
					}
				}
			} while( FindNextFile520(hFind, &wfd) );
			FindClose( hFind );
		}
		return nfound;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̔N()擾
// GetCurrentYear()
unsigned int rfunc_GetCurrentYear(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wYear;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̌擾
// GetCurrentMonth() [1=1, ...]
unsigned int rfunc_GetCurrentMonth(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wMonth;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̓擾
// GetCurrentDay()
unsigned int rfunc_GetCurrentDay(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wDay;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̔N()擾
// GetCurrentDayOfWeek() [j=0, ...]
unsigned int rfunc_GetCurrentDayOfWeek(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wDayOfWeek;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̎Ԃ擾
// GetCurrentHour()
unsigned int rfunc_GetCurrentHour(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wHour;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̕擾
// GetCurrentMinute()
unsigned int rfunc_GetCurrentMinute(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wMinute;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̕b擾
// GetCurrentSecond()
unsigned int rfunc_GetCurrentSecond(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wSecond;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̃~b擾
// GetCurrentMilliseconds()
unsigned int rfunc_GetCurrentMilliseconds(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		SYSTEMTIME st;

		GetLocalTime( &st );
		return (UINT)st.wMilliseconds;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ݂̎ݒ
// SetCurrentTime()
unsigned int rfunc_SetCurrentTime(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "iiiiiii") ) {
		SYSTEMTIME st;

		st.wYear         = (WORD)ARG1.integer;
		st.wMonth        = (WORD)ARG2.integer;
		st.wDay          = (WORD)ARG3.integer;
		st.wHour         = (WORD)ARG4.integer;
		st.wMinute       = (WORD)ARG5.integer;
		st.wSecond       = (WORD)ARG6.integer;
		st.wMilliseconds = (WORD)ARG7.integer;
		return (SetLocalTime( &st ) != 0)?1:0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}


// fwrite/fappend/fread() p̃eLXg^oCi[hiftHgFeLXg(0)j
// FModeBinary( mode )
unsigned int rfunc_FModeBinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		if ( ARG1.integer != 0 ) {
            fmode_bin = 1;
		}
		else {
			fmode_bin = 0;
		}
		return (unsigned)fmode_bin;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// fwrite/fappend/fread() p̃Ch^}`oCg[hiftHgF}`oCg(0)j
// ȂA}`oCgw̏ꍇ́AÖق̂ɃoCi[hƂȂ
// FModeWide( mode )
unsigned int rfunc_FModeWide(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		if ( ARG1.integer != 0 ) {
            fmode_wide = 1; // IUTF-16(LE)Shift-JISϊsiOIɂUTF-16gAIɂShift-JISgj
		}
		else {
			fmode_wide = 0;
		}
		return (unsigned)fmode_wide;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@Cւ̏(㏑)
// fwrite( fname$, data$ )
// fwrite( fname$, lines$[] )
unsigned int rfunc_fwrite(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		FILE *fp;
		UINT rv = 0;

		if ( 0 == fopen_s(&fp, ARG1.text, (fmode_wide || fmode_bin) ? "wb" : "wt") ) {
			if ( fmode_wide == 1 ) {
				LPWSTR wstr = NULL;
                int    iWstrSize = 0;

				iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, ARG2.text, -1, wstr, 0);
				if ( iWstrSize > 0 ) {
					iWstrSize+=2;

					wstr = (LPWSTR)calloc(iWstrSize, sizeof(WCHAR));
					if ( wstr ) {
						iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, ARG2.text, -1, wstr, iWstrSize);
						if ( iWstrSize > 0 ) {
							// BOM̏
							fputwc( 0xfeff, fp );
							// {̂̏
							rv = (EOF != fputws( wstr, fp ));
						}
						safefree( wstr );
					}
				}
			}
			else {
				rv = (EOF != fputs( ARG2.text, fp ));
			}
			fclose( fp );
		}
		return rv;
	}
	else if ( args_typecheck(args, "sr") ) {
		FILE *fp;
		UINT rv = 0, len, i;

		len = sizeof_variables_d( ARG2.text );
		if ( len == NO_VALUE ) {
			char *mes;

			mes = zalloc( strlen(ARG4.text) + 200 );
			if ( mes ) {
				wsprintf( mes, "FWrite()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂Bt@Cւ݂͍̏s܂B", ARG4.text);
				destroy_splash_window();
				MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
				safefree( mes );
			}
			return 0;
		}
		if ( 0 == fopen_s(&fp, ARG1.text, (fmode_wide || fmode_bin) ? "wb" : "wt") ) {
			if ( fmode_wide == 1 ) {
				// BOM̏
				fputwc( 0xfeff, fp );
			}

			for(i=0 ; i<len ; i++) {
				char *v = getVariable_d_a(ARG2.text, i);

				if ( v[0] ) {
					if ( fmode_wide == 1 ) {
						LPWSTR wstr = NULL;
						int    iWstrSize = 0;

						iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, v, -1, wstr, 0);
						if ( iWstrSize > 0 ) {
							iWstrSize+=2;

							wstr = (LPWSTR)calloc(iWstrSize, sizeof(WCHAR));
							if ( wstr ) {
								iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, v, -1, wstr, iWstrSize);
								if ( iWstrSize > 0 ) {
									rv = (EOF != fputws( wstr, fp ));
								}
								safefree( wstr );
							}
						}
					}
					else {
						rv = (EOF != fputs( v, fp ));
					}

					if ( rv == 0 ) {
						break;
					}
				}

				if ( fmode_wide == 1 ) {
					rv = (EOF != fputws( fmode_bin ? L"\r\n" : L"\n", fp ));
				}
				else {
					rv = (EOF != fputs( fmode_bin ? "\r\n" : "\n", fp ));
				}

				if ( rv == 0 ) {
					break;
				}
			}
			fclose( fp );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@Cւ̏(ǋL)
// fappend( fname$, data$ )
// fappend( fname$, lines$[] )
unsigned int rfunc_fappend(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		FILE *fp;
		UINT rv = 0;
		DWORD fesize = 0;

		fesize = getFileSize( ARG1.text );
		if ( 0 == fopen_s(&fp, ARG1.text, (fmode_wide || fmode_bin) ? "ab" : "at") ) {
			if ( fmode_wide == 1 ) {
				LPWSTR wstr = NULL;
                int    iWstrSize = 0;

				iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, ARG2.text, -1, wstr, 0);
				if ( iWstrSize > 0 ) {
					iWstrSize+=2;

					wstr = (LPWSTR)calloc(iWstrSize, sizeof(WCHAR));
					if ( wstr ) {
						iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, ARG2.text, -1, wstr, iWstrSize);
						if ( iWstrSize > 0 ) {
							// t@C̐擪Ȃ΁ABOM̏
							if ( fesize == 0 || fesize == -1 ) {
								fputwc( 0xfeff, fp );
							}
							// {̂̏
							rv = (EOF != fputws( wstr, fp ));
						}
						safefree( wstr );
					}
				}
			}
			else {
				rv = (EOF != fputs( ARG2.text, fp ));
			}
			fclose( fp );
		}
		return rv;
	}
	else if ( args_typecheck(args, "sr") ) {
		FILE *fp;
		UINT rv = 0, len, i;
		DWORD fesize = 0;

		len = sizeof_variables_d( ARG2.text );
		if ( len == NO_VALUE ) {
			char *mes;

			mes = zalloc( strlen(ARG4.text) + 200 );
			if ( mes ) {
				wsprintf( mes, "FAppend()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂Bt@Cւ݂͍̏s܂B", ARG4.text);
				destroy_splash_window();
				MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
				safefree( mes );
			}
			return 0;
		}

		fesize = getFileSize( ARG1.text );
		if ( 0 == fopen_s(&fp, ARG1.text, (fmode_wide || fmode_bin) ? "ab" : "at") ) {
			if ( fmode_wide == 1 && (fesize == 0 || fesize == -1) ) {
				// BOM̏
				fputwc( 0xfeff, fp );
			}

			for(i=0 ; i<len ; i++) {
				char *v = getVariable_d_a(ARG2.text, i);

				if ( v[0] ) {
					if ( fmode_wide == 1 ) {
						LPWSTR wstr = NULL;
						int    iWstrSize = 0;

						iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, v, -1, wstr, 0);
						if ( iWstrSize > 0 ) {
							iWstrSize+=2;

							wstr = (LPWSTR)calloc(iWstrSize, sizeof(WCHAR));
							if ( wstr ) {
								iWstrSize = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, v, -1, wstr, iWstrSize);
								if ( iWstrSize > 0 ) {
									rv = (EOF != fputws( wstr, fp ));
								}
								safefree( wstr );
							}
						}
					}
					else {
						rv = (EOF != fputs( v, fp ));
					}
				}

				if ( fmode_wide == 1 ) {
					rv = (EOF != fputws( fmode_bin ? L"\r\n" : L"\n", fp ));
				}
				else {
					rv = (EOF != fputs( fmode_bin ? "\r\n" : "\n", fp ));
				}

				if ( rv == 0 ) {
					break;
				}
			}
			fclose( fp );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@CeLXg[hŊJAes𕶎^zɓ
// fread( fname$, lines$[] )
unsigned int rfunc_fread(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sr") ) {
		FILE *fp;
		UINT64 qwSize = 0;
		UINT fsize = 0, i, rv = 0;
		char *buf, *p;

		qwSize = getFileSizeQ(ARG1.text);
		if ( qwSize >= 2u*1024u*1024u*1024u-16u ) {
			// G[(-1==0xffffffffffffffff)܂̓t@CTCY2GBȏ̏ꍇ͎舵Ȃ
            return 0;
		}
		fsize = (UINT)qwSize;

		if ( 0 == fopen_s(&fp, ARG1.text, (fmode_wide || fmode_bin) ? "rb" : "rt") ) {
			buf = zalloc(fsize+2);
			if ( buf ) {
				i = 0;
				while( !feof(fp) ) {
					buf[0] = 0;
					if ( fmode_wide == 1 ) {
						LPWSTR wbuf = (LPWSTR)zalloc(fsize+2);
						fgetws( wbuf, fsize, fp );
						WideCharToMultiByte(GetACP(), 0, (wbuf[0] == 0xfeff)?wbuf+1:wbuf, -1, buf, fsize+2, NULL, NULL);
					}
					else {
						fgets( buf, fsize, fp );
					}

					if ( 0 == resize_variables_d( ARG2.text, i+1 ) ) {
						p = strchr(buf, '\n'); // sL͎菜
						if ( p ) {
							*p = 0;
						}
						p = strchr(buf, '\r'); // sL͎菜
						if ( p ) {
							*p = 0;
						}
						setVariable_d_a( ARG2.text, i, buf );
						rv = 1;
						i++;
					}
					else { // G[
						rv = 0;
					}
				}
				safefree( buf );
			}
			else {
                rv = 0;
			}
			fclose( fp );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// t@CTCYԂ
// getfsize( fname$ )
unsigned int rfunc_getfsize(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		UINT64 qwSize = 0;

		qwSize = getFileSizeQ(ARG1.text);
		if ( qwSize >= 2u*1024u*1024u*1024u-16u ) {
			// G[(-1==0xffffffffffffffff)܂̓t@CTCY2GBȏ̏ꍇ͎舵Ȃ
            return ERRORVALUE;
		}

		return (UINT)qwSize;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// oCi[hŃt@Cǂݍ
// freadbinary( fname$, ints[] )
unsigned int rfunc_freadbinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sa") ) {
		FILE *fp;
		UINT fsize = 0, rv = 0, i;
		unsigned char *buf;
		UINT64 qwSize = 0;

		qwSize = getFileSizeQ(ARG1.text);
		if ( qwSize >= 2u*1024u*1024u*1024u/4u-16u ) {
			// G[(-1==0xffffffffffffffff)܂̓t@CTCY2GBȏ̏ꍇ͎舵Ȃ
            return 0;
		}
		fsize = (UINT)qwSize;

		if ( 0 == fopen_s(&fp, ARG1.text, "rb") ) {
			buf = (unsigned char *)zalloc( fsize+1 );
			if ( buf ) {
				rv = (UINT)fread( buf, fsize, 1, fp );
				if ( 0 == resize_variables( ARG2.text, fsize ) ) {
					for(i=0 ; i<fsize ; i++) {
						setVariable_a(ARG2.text, i, (unsigned int)buf[i]);
					}
                    rv = 1;							
				}
				safefree( buf );
			}
			fclose( fp );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// oCi[hŃt@C֏
// fwritebinary( fname$, ints[] )
unsigned int rfunc_fwritebinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sa") ) {
		FILE *fp;
		UINT fsize = 0, rv = 0, i, v;
		unsigned char *buf;

		if ( 0 == fopen_s(&fp, ARG1.text, "wb") ) {
			fsize = sizeof_variables(ARG2.text); // t@CTCY
			if ( fsize != ERRORVALUE ) {
				buf = calloc( fsize, 1 );
				if ( buf ) {
					for(i=0 ; i<fsize ; i++) {
						getVariable_a(ARG2.text, i, &v);
						buf[i] = (unsigned char)v;
					}

					rv = (UINT)fwrite( buf, fsize, 1, fp );
					safefree( buf );
				}
			}
			else {
				char *mes;

				mes = zalloc( strlen(ARG4.text) + 200 );
				if ( mes ) {
					wsprintf( mes, "FWriteBinary()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂Bt@Cւ݂͍̏s܂B", ARG4.text);
					destroy_splash_window();
					MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
					safefree( mes );
				}
			}
			fclose( fp );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// oCi[hŃt@C֏
// fappendbinary( fname$, ints[] )
unsigned int rfunc_fappendbinary(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sa") ) {
		FILE *fp;
		UINT fsize = 0, rv = 0, i, v;
		unsigned char *buf;

		if ( 0 == fopen_s(&fp, ARG1.text, "ab") ) {
			fsize = sizeof_variables(ARG2.text); // t@CTCY
			if ( fsize != ERRORVALUE ) {
				buf = calloc( fsize, 1 );
				if ( buf ) {
					for(i=0 ; i<fsize ; i++) {
						getVariable_a(ARG2.text, i, &v);
						buf[i] = (unsigned char)v;
					}

					rv = (UINT)fwrite( buf, fsize, 1, fp );
					safefree( buf );
				}
			}
			else {
				char *mes;

				mes = zalloc( strlen(ARG4.text) + 200 );
				if ( mes ) {
					wsprintf( mes, "FWriteBinary()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂Bt@Cւ݂͍̏s܂B", ARG4.text);
					destroy_splash_window();
					MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
					safefree( mes );
				}
			}
			fclose( fp );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// sGg當^z֓ǂݍ
// RegReadMultiString( Key$, entry$, var$[] )
unsigned int rfunc_RegReadMultiString(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssr") ) {
		HKEY hKey;
		char *buf;
		DWORD n, i, j;
		DWORD bufsize;

		if ( NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
            buf = mtRegReadMultiStringDirect(hKey, ARG2.text, &bufsize);
			RegCloseKey( hKey );
			if ( buf ) {
				n = numMultiString( buf, bufsize );
				resize_variables_d(ARG3.text, n);
				for(i=j=0 ; i<n ; i++) { 
					setVariable_d_a(ARG3.text, i, &buf[j]);
					while ( buf[j] ) { // \0܂ŃXLbv
						j++;
					}
					j++;
				}
				safefree( buf );
				return 1;
			}
		}
		return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// ^z񂩂畡sGg֏
// RegWriteMultiString( Key$, entry$, var$[] )
unsigned int rfunc_RegWriteMultiString(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssr") ) {
		HKEY hKey;
		char *buf, *p;
		DWORD n, i, byte, j;
		int rv = 0;

		if ( NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_CREATE)) ) {
			// ^zϐ̊ez𒲂ׁAsɉoCgKv𒲂ׂ
			n = sizeof_variables_d( ARG3.text );
			for(i=byte=0 ; i<n ; i++) {
				p = getVariable_d_a(ARG3.text, i);
				if ( p == NULL ) {
					char *mes = zalloc( strlen(ARG3.text) + 200 );
					if ( mes ) {
						RegCloseKey( hKey );
						wsprintf( mes, "RegReadMultiString()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂Bt@Cւ݂͍̏s܂B", ARG3.text);
						destroy_splash_window();
						MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
						safefree( mes );
						return 0;
					}
				}

				byte += (lstrlen( p ) + 1);
			}
			byte++;

			buf = calloc( byte, 1 );
			if ( buf ) {
				for(i=j=0 ; i<n ; i++) {
					p = getVariable_d_a(ARG3.text, i);
					lstrcpy(&buf[j], p);
					j += (lstrlen( p ) + 1);
				}

				rv = tRegWriteMultiStringDirect(hKey, ARG2.text, buf, byte);
				if (!rv) {
					LONG lasterr = tRegGetLastError();
					if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
						dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteMultiString)", "WXgL['", ARG1.text, "'̃Gg'", ARG2.text,
										 "'֏݂sƂăG[ɂȂ܂B\nAPI񍐂F",
										 getLastErrorString(lasterr));
					}
				}
				RegCloseKey( hKey );

				safefree( buf );
				return rv;
			}
			RegCloseKey( hKey );
		}
		else {
			LONG lasterr = tRegGetLastError();
			if (lasterr != ERROR_SUCCESS && rnsf7RegRead("regErrorMessage", 0)) {
				dispErrorMessage(hWnd, MB_OK | MB_ICONSTOP, "WXgւ̏ݒG[(RegWriteMultiString)", "WXgL['", ARG1.text,
								 "'݃ANZXŊJƂăG[ɂȂ܂B\nAPI񍐂F",
								 getLastErrorString(lasterr), NULL, NULL);
			}
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@CZNVۂƓǂݍ
// iniReadSection( inifile$, section$, var$[] )
unsigned int rfunc_iniReadSection(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssr") ) {
		char *buf;
		DWORD n, i, j;

		buf = mtiniReadSection(ARG1.text, ARG2.text);
		if ( buf ) {
			n = numMultiString( buf, 0 );
			resize_variables_d(ARG3.text, n);
			for(i=j=0 ; i<n ; i++) { 
				setVariable_d_a(ARG3.text, i, &buf[j]);
				while ( buf[j] ) { // \0܂ŃXLbv
					j++;
				}
				j++;
			}
			safefree( buf );
			return 1;
		}
		return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// init@CփZNVۂƏ
// iniWriteSection( inifile$, section$, var$[] )
unsigned int rfunc_iniWriteSection(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssr") ) {
		char *buf, *p;
		DWORD n, i, byte, j;
		BOOL  rv = 0;

		// ^zϐ̊ez𒲂ׁAsɉoCgKv𒲂ׂ
		n = sizeof_variables_d( ARG3.text );
		for(i=byte=0 ; i<n ; i++) {
			p = getVariable_d_a(ARG3.text, i);
			if ( p == NULL ) {
				char *mes = zalloc( strlen(ARG3.text) + 200 );
				if ( mes ) {
					wsprintf( mes, "iniWriteSection()ŗpĂz%s[]́A錾Ȃ܂܎gĂ܂Bt@Cւ݂͍̏s܂B", ARG3.text);
					destroy_splash_window();
					MessageBox(NULL, mes, "R-Scriptx", MB_OK | MB_ICONEXCLAMATION);
					safefree( mes );
					return 0;
				}
			}

			byte += (lstrlen( p ) + 1);
		}
		byte++;

		buf = calloc( byte, 1 );
		if ( buf ) {
			for(i=j=0 ; i<n ; i++) {
				p = getVariable_d_a(ARG3.text, i);
				lstrcpy(&buf[j], p);
				j += (lstrlen( p ) + 1);
			}

			rv = tiniWriteSection(ARG1.text, ARG2.text, buf);
			safefree( buf );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// R}hCw肳ꂽp[^̐ԋp
// GetIParamNum()
unsigned int rfunc_GetIParamNum(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		// ɁAw肳ꂽp^̐(C^v^RSCt@CAꂼ1Ɛ)Ԃ
		return __argc;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// z֗vfǉ
// ArrayAdd(name[], expr, ...)
unsigned int rfunc_ArrayAdd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	const struct ARGS *p = args;	// |C^
	unsigned int numint = 0;		// ǉvf
	unsigned int orgsize = 0;		// IWi̔zvfi錾̔z0j
	unsigned int rv = 0, i = 0;		// ߂lۑpƃJE^p

	if ( p->type == UFCT_ARG_INTS && p->next ) {
		numint = 0;
		// ̌^mFȂAǉvfJEg
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_INT ) {
				numint++;
			}
			else if ( p->type == UFCT_ARG_INTS ) {
				unsigned tmpn = sizeof_variables( p->v.text );
				if ( tmpn == NO_VALUE ) {
					return 0;	// G[F錾̔z
				}
                numint += tmpn;
			}
			else {
				*result = UFC_MISSMATCH_ARGS; // 
				return ERRORVALUE;
			}
		}

		// zTCYiAz񂪑݂Ȃꍇ͐VK쐬j
		orgsize = sizeof_variables( ARG1.text );
		if ( orgsize == NO_VALUE ) {
			orgsize = 0;
		}
		rv = resize_variables( ARG1.text, orgsize + numint );

		if ( rv == 1 ) {
			return 0;	// G[Fs
		}

		// l̑
		i = orgsize;
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_INT ) {
				setVariable_a(ARG1.text, i, p->v.integer);
				++i;
			}
			else if ( p->type == UFCT_ARG_INTS ) {
				unsigned n = sizeof_variables( p->v.text );
				unsigned j, t;
				for( j=0 ; j<n ; ++j ) {
					getVariable_a(p->v.text,  j, &t);
					setVariable_a(ARG1.text, i+j, t);
				}
				i += n;
			}
		}
		return 1;
	}
	else if ( p->type == UFCT_ARG_STRINGS && p->next && p->next->type == UFCT_ARG_STRING ) {
		numint = 0;
		// ̌^mFȂAǉvfJEg
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_STRING ) {
				numint++;
			}
			else if ( p->type == UFCT_ARG_STRINGS ) {
				unsigned tmpn = sizeof_variables_d( p->v.text );
				if ( tmpn == NO_VALUE ) {
					return 0;	// G[F錾̔z
				}
                numint += tmpn;
			}
			else {
				*result = UFC_MISSMATCH_ARGS; // 
				return ERRORVALUE;
			}
		}

		// zTCYiAz񂪑݂Ȃꍇ͐VK쐬j
		orgsize = sizeof_variables_d( ARG1.text );
		if ( orgsize == NO_VALUE ) {
			orgsize = 0;
		}
		rv = resize_variables_d( ARG1.text, orgsize + numint );

		if ( rv == 1 ) {
			return 0;	// G[Fs
		}

		// l̑
		i = orgsize;
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_STRING ) {
				setVariable_d_a(ARG1.text, i, p->v.text);
				++i;
			}
			else /*if ( p->type == UFCT_ARG_STRINGS )*/ {
				unsigned n = sizeof_variables_d( p->v.text );
				unsigned j;
				char *t;
				for( j=0 ; j<n ; ++j ) {
					t = getVariable_d_a(p->v.text, j);
					setVariable_d_a(ARG1.text, i+j, t);
				}
				i += n;
			}
		}
		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}


// z̏ƃTCY
// ArrayInit(name[], expr, ... )
unsigned int rfunc_ArrayInit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	const struct ARGS *p = args;	// |C^
	unsigned int numint = 0;		// iVźjvf
	unsigned int rv = 0, i = 0;		// ߂lۑpƃJE^p

	if ( p->type == UFCT_ARG_INTS && p->next ) {
		numint = 0;
		// ̌^mFȂAiVźjvfJEg
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_INT ) {
				numint++;
			}
			else if ( p->type == UFCT_ARG_INTS ) {
				unsigned tmpn = sizeof_variables( p->v.text );
				if ( tmpn == NO_VALUE ) {
					return 0;	// G[F錾̔z
				}
                numint += tmpn;
			}
			else {
				*result = UFC_MISSMATCH_ARGS; // 
				return ERRORVALUE;
			}
		}

		// zm
		rv = array_variables( ARG1.text, numint );

		if ( rv == 1 ) {
			return 0;	// G[Fs܂arrayinitŕϐ̍ėp
		}

		// l̑
		i = 0;
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_INT ) {
				setVariable_a(ARG1.text, i, p->v.integer);
				++i;
			}
			else if ( p->type == UFCT_ARG_INTS ) {
				unsigned n = sizeof_variables( p->v.text );
				unsigned j, t;
				for( j=0 ; j<n ; ++j ) {
					getVariable_a(p->v.text,  j, &t);
					setVariable_a(ARG1.text, i+j, t);
				}
				i += n;
			}
		}

		return 1;
	}
	else if ( p->type == UFCT_ARG_STRINGS && p->next ) {
		numint = 0;
		// ̌^mFȂAiVźjvfJEg
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_STRING ) {
				numint++;
			}
			else if ( p->type == UFCT_ARG_STRINGS ) {
				unsigned tmpn = sizeof_variables_d( p->v.text );
				if ( tmpn == NO_VALUE ) {
					return 0;	// G[F錾̔z
				}
                numint += tmpn;
			}
			else {
				*result = UFC_MISSMATCH_ARGS; // 
				return ERRORVALUE;
			}
		}

		// zm
		rv = array_variables_d( ARG1.text, numint );

		if ( rv == 1 ) {
			return 0;	// G[Fs܂arrayinitŕϐ̍ėp
		}

		// l̑
		i = 0;
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_STRING ) {
				setVariable_d_a(ARG1.text, i, p->v.text);
				++i;
			}
			else /*if ( p->type == UFCT_ARG_STRINGS )*/ {
				unsigned n = sizeof_variables_d( p->v.text );
				unsigned j;
				char *t;
				for( j=0 ; j<n ; ++j ) {
					t = getVariable_d_a(p->v.text, j);
					setVariable_d_a(ARG1.text, i+j, t);
				}
				i += n;
			}
		}

		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// z̏ƃTCY
// ResizeInit(name[], expr, ... )
unsigned int rfunc_ResizeInit(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	const struct ARGS *p = args;	// |C^
	unsigned int numint = 0;		// iVźjvf
	unsigned int rv = 0, i = 0;		// ߂lۑpƃJE^p

	if ( p->type == UFCT_ARG_INTS && p->next ) {
		numint = 0;
		// ̌^mFȂAiVźjvfJEg
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_INT ) {
				numint++;
			}
			else if ( p->type == UFCT_ARG_INTS ) {
				unsigned tmpn = sizeof_variables( p->v.text );
				if ( tmpn == NO_VALUE ) {
					return 0;	// G[F錾̔z
				}
                numint += tmpn;
			}
			else {
				*result = UFC_MISSMATCH_ARGS; // 
				return ERRORVALUE;
			}
		}

		// zmہi܂̓TCYj
		rv = resize_variables( ARG1.text, numint );

		if ( rv == 1 ) {
			return 0;	// G[Fs܂arrayinitŕϐ̍ėp
		}

		// l̑
		i = 0;
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_INT ) {
				setVariable_a(ARG1.text, i, p->v.integer);
				++i;
			}
			else if ( p->type == UFCT_ARG_INTS ) {
				unsigned n = sizeof_variables( p->v.text );
				unsigned j, t;
				for( j=0 ; j<n ; ++j ) {
					getVariable_a(p->v.text,  j, &t);
					setVariable_a(ARG1.text, i+j, t);
				}
				i += n;
			}
		}

		return 1;
	}
	else if ( p->type == UFCT_ARG_STRINGS && p->next ) {
		numint = 0;
		// ̌^mFȂAiVźjvfJEg
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_STRING ) {
				numint++;
			}
			else if ( p->type == UFCT_ARG_STRINGS ) {
				unsigned tmpn = sizeof_variables_d( p->v.text );
				if ( tmpn == NO_VALUE ) {
					return 0;	// G[F錾̔z
				}
                numint += tmpn;
			}
			else {
				*result = UFC_MISSMATCH_ARGS; // 
				return ERRORVALUE;
			}
		}

		// zmہi܂̓TCYj
		rv = resize_variables_d( ARG1.text, numint );

		if ( rv == 1 ) {
			return 0;	// G[Fs܂arrayinitŕϐ̍ėp
		}

		// l̑
		i = 0;
		for( p = args->next ; p ; p = p->next ) {
			if ( p->type == UFCT_ARG_STRING ) {
				setVariable_d_a(ARG1.text, i, p->v.text);
				++i;
			}
			else /*if ( p->type == UFCT_ARG_STRINGS )*/ {
				unsigned n = sizeof_variables_d( p->v.text );
				unsigned j;
				char *t;
				for( j=0 ; j<n ; ++j ) {
					t = getVariable_d_a(p->v.text, j);
					setVariable_d_a(ARG1.text, i+j, t);
				}
				i += n;
			}
		}

		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}


// K\pāÃ}b`(BoostCuɂ)
// regex_match( str, re [, option] )
// str : Ώە
// re  : K\
// option : IvV(i,g,s)
// ߂l : 0 - }b`, 1 - }b`, ERRORVALUE - G[
unsigned int rfunc_RegEx_Match(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return cpp_regex_match(ARG1.text, ARG2.text, "");
	}
	else if ( args_typecheck(args, "sss") ) {
		return cpp_regex_match(ARG1.text, ARG2.text, ARG3.text);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// K\pāÃ}b`T[`(BoostCuɂ)
// regex_match( str, re [, option] )
// str : Ώە
// re  : K\
// option : IvV(i,g,s)
// ߂l : }b`ʒu (ERRORVALUE - ȂG[)
unsigned int rfunc_RegEx_Search(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ss") ) {
		return cpp_regex_search(ARG1.text, ARG2.text, "", NULL, NULL);
	}
	else if ( args_typecheck(args, "sss") ) {
		return cpp_regex_search(ARG1.text, ARG2.text, ARG3.text, NULL, NULL);
	}
	else if ( args_typecheck(args, "ssaa") ) {
		return cpp_regex_search(ARG1.text, ARG2.text, "", ARG3.text, ARG4.text);
	}
	else if ( args_typecheck(args, "sssaa") ) {
		return cpp_regex_search(ARG1.text, ARG2.text, ARG3.text, ARG4.text, ARG5.text);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// w莞Ԃ̃EFCgiщʂ̍ĕ`j
// sleep( n )
// n : Ŏw肵Ԃ~܂i~bPʁj
// ߂l : 1
unsigned int rfunc_sleep(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		MSG msg;

		// _CAO̍ĕ`
		if ( hWnd ) {
			while( PeekMessage(&msg, hWnd, WM_PAINT, WM_PAINT, PM_REMOVE) ) {
				DispatchMessage(&msg);
			}
		}

		// EFCg
		if ( ARG1.integer == 0xFFFFFFFF ) { // 0xFFFFFFFF(INFINITE)͓ȈӖ
			Sleep(ARG1.integer-1);
			Sleep(1);
		}
		else {
			Sleep(ARG1.integer);
		}

		// _CAO̍ĕ`
		if ( hWnd ) {
			while( PeekMessage(&msg, hWnd, WM_PAINT, WM_PAINT, PM_REMOVE) ) {
				DispatchMessage(&msg);
			}
		}

		return 1;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return ERRORVALUE;
	}
}

// JgfBNg擾iŌ \ t܂j
// GetCurrentDirectory$()
char *rfunc_getcurrentdirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char   cdir[MAX_PATH*2];
		size_t i;
			
		GetCurrentDirectory(_countof(cdir), cdir);
		i = strlen( cdir );
		if ( cdir[i-1] != '\\' || isKanji1(cdir,(int)i-2) ) {
			cdir[i] = '\\';
			cdir[i+1] = 0;
		}
		return _strdup(cdir);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// WindowsfBNg擾iŌ \ t܂j
// GetWindowsDirectory$()
char *rfunc_getwindowsdirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char    wdir[MAX_PATH*2];
		size_t  i;

		GetWindowsDirectory(wdir, _countof(wdir));
		i = strlen( wdir );
		if ( wdir[i-1] != '\\' || isKanji1(wdir,(int)i-2) ) {
			wdir[i] = '\\';
			wdir[i+1] = 0;
		}
		return _strdup(wdir);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// SystemfBNg擾iŌ \ t܂j
// GetSystemDirectory$()
char *rfunc_getsystemdirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char   sdir[MAX_PATH*2];
		size_t i;

		GetSystemDirectory(sdir, _countof(sdir));
		i = strlen( sdir );
		if ( sdir[i-1] != '\\' || isKanji1(sdir,(int)i-2) ) {
			sdir[i] = '\\';
			sdir[i+1] = 0;
		}
		return _strdup(sdir);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// s̃XNvg݂fBNgԂiŌ \ t܂j
// GetRscDirectory$()
char *rfunc_GetRscDirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		int  i;

		// s̃XNvgtpXwȂAŌ\\TāA̎\0邱ƂɂpX݂̂Qbc
		// łȂ΁AC^v^̃tpXԂ
		for( i=lstrlen(rscname)-1 ; i>0 ; i-- ) {
			if ( rscname[i] == '\\' && !isKanji1(rscname,i-1) ) {
				char *p;

				p = zalloc( i+3 );
				if ( p ) {
					lstrcpyn(p, rscname, i+2);
					p[i+2] = 0;
				}
				return p;
			}
		}

		return funccall_d( hWnd, "GetInterpreterDirectory$", args, result );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// C^v^݂fBNgԂiŌ \ t܂j
// GetInterpreterDirectory$()
char *rfunc_GetInterpreterDirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char exename[MAX_PATH*2];
		int  i;

		// C^v^̃tpX擾AŌ\\TāA̎\0邱ƂɂpX݂̂Qbc
		if ( GetModuleFileName(NULL, exename, _countof(exename)) ) {
			for( i = lstrlen(exename)-1 ; i>0 ; i-- ) {
				if ( exename[i] == '\\' && !isKanji1(exename,i-1) ) {
					exename[i+1] = 0;
					break;
				}
			}

			return _strdup( exename );
		}

		return 0;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// s̃XNvg̃t@CԂiCj[̒ʏ̌ĂяoƁApX͕t܂j
// GetRscName$()
char *rfunc_GetRscName_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		return _strdup(rscname);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ϐ擾
// GetEnv$( ϐ$ )
char *rfunc_getenv_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		char *value, *tmp;
		DWORD i;
			
		value = zalloc( 2 );
		if ( value ) {
			i = GetEnvironmentVariable(ARG1.text, value, 2);
			if ( i > 1 ) {
				tmp = (char *)realloc( value, i );
				if ( tmp ) {
					value = tmp;
					GetEnvironmentVariable(ARG1.text, value, i);
				}
				else {
					value[0] = 0;
				}
			}
			else if ( i == 0 ) {
				value[0] = 0;
			}
		}
		return value;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ϐWJ̕擾
// ExpandEnvironmentStrings$( $ )
char *rfunc_ExpandEnvironmentStrings_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		char *value;
		DWORD i;
			
		value = zalloc( 5 );
		if ( value ) {
			i = ExpandEnvironmentStrings(ARG1.text, value, 2);
			if ( i > 2 ) {
				i = i*2 + 1;
				safefree( value );
				value = zalloc( i );
				if ( value ) {
					if ( 0 != ExpandEnvironmentStrings(ARG1.text, value, i) ) {
						// mۂȂ傫ɐ؂߂
						char *tmp = realloc(value, lstrlen(value)+1);
						if ( tmp ) {
							value = tmp;
						}
					}
				}
				else {
					value[0] = 0;
				}
			}
			else if ( i == 0 ) {
				value[0] = 0;
			}
		}
		return value;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// WXg當擾
// RegReadSz$( Key$, Entry$, ftHg$ )
// RegReadString$( Key$, Entry$, ftHg$ )
char *rfunc_regreadsz_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		HKEY hKey;
		char *value;
		int  l;

		if (NULL != (hKey = tRegOpenKey(NULL, ARG1.text, TREG_OPEN_READONLY)) ) {
			if (0 < (l = tRegValueExist( hKey, ARG2.text ))) {
				value = zalloc( l+1 );
				if ( value ) {
					tRegReadString( hKey, ARG2.text, value, l+1 );
				}
			}
			else {
				value = _strdup( ARG3.text );
			}

			RegCloseKey( hKey );
			return value;
		}
		else
			return _strdup( ARG3.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ҏW{bNX當擾, ܂̓ACR{^ACR擾
// `FbN{bNXE{^̕擾
// GetEditBox$( ID$ )
// GetIconName$( ID$ )EGetIconBox$( ID$ )
// GetTextCtrl$( ID$ )
char *rfunc_geteditbox_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return GetEditBox( ARG1.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// 啶ɕϊ
// _strupr$( $ )
char *rfunc_strupr_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return sjisupr(_strdup(ARG1.text));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ɕϊ
// strlwr$( $ )
char *rfunc_strlwr_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return sjislwr(_strdup(ARG1.text));
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ̓̃oCg𓾂 (Ƃ)
// GetStrByte$( $, oCg?<0-> )
char *rfunc_getstrbyte_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		char s[2];

		if (strlen( ARG1.text ) > (size_t)ARG2.integer ) {
			s[0] = ARG1.text[ARG2.integer];
			s[1] = 0;
			return _strdup( s );
		}
		else {
			return _strdup( "" );
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ̍灛܂ł𔲂o
// left$( $, o )
char *rfunc_left_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		char *s, *p;

		if (strlen( ARG1.text ) > (size_t)ARG2.integer ) {
			s = _strdup( ARG1.text );
			s[ ARG2.integer ] = 0;
			p = _strdup( s );
			safefree( s );
			return p;
		}
		else {
			return _strdup( ARG1.text );
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ̉E灛܂ł𔲂o
// right$( $, o )
char *rfunc_right_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		size_t i;

		i = strlen( ARG1.text );
		if ( i > (size_t)ARG2.integer ) {
			return _strdup( &(ARG1.text[i-(size_t)ARG2.integer]) );
		}
		else {
			return _strdup( ARG1.text );
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ̐^񒆂́oCgڂ灛𔲂o
// mid$( $, oCg, o )
// substr$( $, oCg, o )
// substring$( $, oCg, o )
char *rfunc_mid_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sii") ) {
		char *s, *p;

		if ( strlen( ARG1.text ) > (size_t)ARG2.integer ) {
			s = _strdup( &(ARG1.text[ARG2.integer]) );
			if ( strlen( &(ARG1.text[ARG2.integer]) ) > (size_t)ARG3.integer ) {
				s[ ARG3.integer ] = 0;
				p = _strdup( s );
				safefree( s );
				return p;
			}
			else {
				return s;
			}
		}
		else
			return _strdup( "" );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// init@C當ǂ
// iniReadString$( file$, section$, key$, default$ )
char *rfunc_iniReadString_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssss") ) {
		return mtiniReadString( ARG1.text, ARG2.text, ARG3.text, ARG4.text );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// l𕶎ɕϊi""+l łϊłj
// toStr$( l[, ] )
char *rfunc_toStr_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		char itbuf[16], *rv = NULL;

		if ( 0 == _ultoa_s(ARG1.integer, itbuf, _countof(itbuf), 10) ) {
			rv = _strdup(itbuf);
		}
		return rv;
	}
	else if ( args_typecheck(args, "ii") ) { // 
		char itbuf[16];
		UINT len, i;

		if ( 0 == _ultoa_s(ARG1.integer, itbuf, _countof(itbuf), 10) ) {
			len = lstrlen(itbuf);
			if ( len >= ARG2.integer ) { // w肳ꂽAłɑ
				return _strdup( itbuf ); // ̂܂ܕԂ
			}
			else { // łȂꍇ́A0₤
				char *r;

				r = zalloc( ARG2.integer + 1 );
				if ( r ) {
					for(i=0 ; i<ARG2.integer-len ; i++) {
						r[i] = '0';
					}
					lstrcpy(&r[i], itbuf);
				}
				return r;
			}
		}
		else {
			return NULL;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// l𕄍tłƌȂAɕϊ
// SignedtoStr$( l )
char *rfunc_SignedToStr_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		return _strdup( s_itoa10( ARG1.integer ) );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// l2iƌȂĕɕϊ
// toStr2$( l )
char *rfunc_toStr2_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		char s[33];
		UINT i, j;

		// ARG1.integer  2iɕϊ
		for( i=j=0 ; i<32 ; i++ ) {
            s[j] = (char)((((unsigned)ARG1.integer >> (31-i)) & 1) + '0');
			if ( j ) {
				j++;
			}
			else {
				if ( s[0] == '1' ) {
					j = 1;
				}
			}
		}
		if ( j ) {
            s[j] = 0;
		}
		else {
			s[0] = '0';
			s[1] = 0;
		}
		return _strdup( s );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// l8iƌȂĕɕϊ
// toStr8$( l )
char *rfunc_toStr8_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		char s[15];

		wsprintf(s, "%o", ARG1.integer); // ARG1.integer  8iɕϊ
		return _strdup( s );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// l16iƌȂĕɕϊ
// toStr16$( l )
char *rfunc_toStr16_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		char s[10];

		wsprintf(s, "%x", ARG1.integer); // ARG1.integer  16iɕϊ
		return _strdup( s );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// R[hnɑΉ镶̕𐶐
// AsciiCode$( n )
char *rfunc_AsciiCode_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		unsigned char s[2];

		s[0] = (unsigned char)ARG1.integer;
		s[1] = 0;
		return _strdup( (char *)s );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// DLL̊֐Ăяo(߂l͕)
// CallDll$( DLLt@C$, ֐$, ... )
char *rfunc_CallDll_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args != NULL && args->type == UFCT_ARG_STRING && args->next != NULL && args->next->type == UFCT_ARG_STRING ) {
		HINSTANCE lib;
		RSC_CALLDLL_STRING func;
		HGLOBAL hMem;
		char    *p ,*q;

		lib = LoadLibrary( ARG1.text );
		if ( lib == NULL ) {
			*result = UFS_NOTFOUNDDLL;
			return 0;
		}
		func = (RSC_CALLDLL_STRING)GetProcAddress( lib, ARG2.text );
		if ( func == NULL ) {
			*result = UFS_NOTFOUNDDLLFUNC;
			return 0;
		}

		// zϐ̖OĂ镔́A̔zϐ\\̂̃|C^ɍւ
		{
			struct ARGS *p_args = args->next->next;

			while ( p_args ) {
				if ( p_args->type == UFCT_ARG_INTS ) {
					p_args->v.pva = search_pointer_a( p_args->v.text );
				}
				else if ( p_args->type == UFCT_ARG_STRINGS ) {
					p_args->v.pvda = search_pointer_d_a( p_args->v.text );
				}
				p_args = p_args->next;
			} 
		}

		hMem = func( hWnd, args->next->next );
		if ( hMem && (NULL != (p = (char *)GlobalLock( hMem ))) ) {
			q = _strdup( p );
			GlobalUnlock( hMem );
			safegfree( hMem );
		}
		else {
			q = _strdup( "" );
		}
		FreeLibrary( lib );
		return q;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// L[̒iԖڂ̃TuL[̖O擾
// EnumKey$( Key$, i )
char *rfunc_EnumKey_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		if ( strchr(ARG1.text,'\\') == 0 ) {
			HKEY hKey;
			DWORD len = 0;
			char *name = NULL;

			hKey = tRegHiveKey( ARG1.text );
			RegQueryInfoKey( hKey, NULL, NULL, NULL, NULL, &len, NULL, NULL, NULL, NULL, NULL, NULL);
			len = (len+1)*sizeof(WCHAR); // WinNTnł̑΍
			name = zalloc( len );
			if ( name ) {
				if ( ERROR_SUCCESS == RegEnumKeyEx( hKey, ARG2.integer, name, &len, NULL, NULL, NULL, NULL ) ) {
					// mۂꂽ𕶎̑傫܂Ő؂߂
					char *tmp = realloc( name, lstrlen(name)+1 );
					if ( tmp ) {
						name = tmp;
					}
				}
				else {
					safefree( name );
					name = _strdup( "" );
				}
			}
			return name;
		}
		else {
			HKEY hKey;
			DWORD len = 0;
			char *name;

			if ( NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_READONLY )) ) {
				RegQueryInfoKey( hKey, NULL, NULL, NULL, NULL, &len, NULL, NULL, NULL, NULL, NULL, NULL);
				len = (len+1)*sizeof(WCHAR); // WinNTnł̑΍
				name = zalloc( len );
				if ( name ) {
					if ( ERROR_SUCCESS == RegEnumKeyEx( hKey, ARG2.integer, name, &len, NULL, NULL, NULL, NULL ) ) {
						// mۂꂽ𕶎̑傫܂Ő؂߂
						char *tmp = realloc( name, lstrlen(name)+1 );
						if ( tmp ) {
							name = tmp;
						}
					}
					else {
						safefree( name );
						name = _strdup( "" );
					}
				}
				RegCloseKey( hKey );
			}
			else {
				name = _strdup( "" );
			}
			return name;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// L[̒iԖڂ̒l̖O擾
// EnumValue$( Key$, i )
char *rfunc_EnumValue_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		if ( strchr(ARG1.text,'\\') == 0 ) {
			HKEY hKey;
			DWORD len = 0;
			char *name;

			hKey = tRegHiveKey( ARG1.text );
			RegQueryInfoKey( hKey, NULL, NULL, NULL, NULL, NULL, NULL, NULL, &len, NULL, NULL, NULL);
			len = (len+1)*sizeof(WCHAR); // WinNTnł̑΍
			name = zalloc( len );
			if ( name ) {
				if ( ERROR_SUCCESS == RegEnumValue( hKey, ARG2.integer, name, &len, NULL, NULL, NULL, NULL ) ) {
					// mۂꂽ𕶎̑傫܂Ő؂߂
					char *tmp = realloc( name, lstrlen(name)+1 );
					if ( tmp ) {
						name = tmp;
					}
				}
				else {
                    safefree( name );
					name = _strdup( "" );
				}
			}
			return name;
		}
		else {
			HKEY hKey;
			DWORD len = 0;
			char *name;

			if ( NULL != (hKey = tRegOpenKey( NULL, ARG1.text, TREG_OPEN_READONLY )) ) {
				RegQueryInfoKey( hKey, NULL, NULL, NULL, NULL, NULL, NULL, NULL, &len, NULL, NULL, NULL);
				len = (len+1)*sizeof(WCHAR); // WinNTnł̑΍
				name = zalloc( len );
				if ( name ) {
					if ( ERROR_SUCCESS == RegEnumValue( hKey, ARG2.integer, name, &len, NULL, NULL, NULL, NULL ) ) {
						// mۂꂽ𕶎̑傫܂Ő؂߂
						char *tmp = realloc( name, lstrlen(name)+1 );
						if ( tmp ) {
							name = tmp;
						}
					}
					else {
						safefree( name );
						name = _strdup( "" );
					}
				}
				RegCloseKey( hKey );
			}
			else {
				name = _strdup( "" );
			}
			return name;
		}
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// init@CZNV
// iniEnumSection$( file$, i )
// file$󕶎̏ꍇ́AWin.ini猟
char *rfunc_iniEnumSection_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		char *retp = mtiniEnumSection( ARG1.text[0]?ARG1.text:NULL, ARG2.integer );

		if ( retp == NULL ) {
			retp = _strdup( "" );
		}

		return retp;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// init@C̃ZNVL[
// iniEnumKey$( file$, section$, i )
char *rfunc_iniEnumKey_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "ssi") ) {
		char *retp = mtiniEnumKey( ARG1.text, ARG2.text, ARG3.integer );
		
		if ( retp == NULL ) {
			retp = _strdup( "" );
		}

		return retp;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// Xgr[E`FbN{bNXXgnsi當𓾂
// ListViewGetText$( ID$, n, i )
char *rfunc_ListViewGetText_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sii") ) {
		return ListView_GetText( ARG1.text, ARG2.integer, ARG3.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// sҏW{bNX̍s𓾂
// GetMultiEditLine$( ID$, n )
char *rfunc_GetMultiEditLine_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		return GetMultiEditLine( ARG1.text, ARG2.integer );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// w肳ꂽgq̊֘AÂꂽOԂ(ɖOȂΊgq̂̂O)
// ܂A.bmpɑ΂ Paint.Picture A.exeɑ΂exefileȂ
// .lzh.ziṕAŴ̂Ȃ̂ŁAɉĂȂ.lzh.zipgԂ
// GetExtName( ext$ )
char *rfunc_GetExtName_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		HKEY hkey;
		char *extc;

		if ( NULL != (hkey = tRegOpenKey( HKEY_CLASSES_ROOT, ARG1.text, TREG_OPEN_READONLY )) ) {
			extc = mtRegReadString( hkey, "", NULL );
			RegCloseKey( hkey );
			if ( extc == NULL ) {
				extc = _strdup( ARG1.text );
			}
			else {
				if ( extc[0] != 0 && NULL != (hkey = tRegOpenKey( HKEY_CLASSES_ROOT, extc, TREG_OPEN_READONLY )) ) {
					RegCloseKey( hkey );
				}
				else {
                    safefree( extc );
					extc = _strdup( ARG1.text );
				}
			}
			
		}
		else {
			extc = _strdup( ARG1.text );
		}

		return extc;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// _CAOɑ݂iԖڂ̃Rg[IDԂ
// enumID$( i )
char *rfunc_enumID_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		return _strdup( (nctrls>ARG1.integer && rctrls[ARG1.integer].id) ? rctrls[ARG1.integer].id : "" );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// _CAO̎w肳ꂽID̃Rg[̎ނ𒲂ׂ
// GetControlType$( s )
char *rfunc_GetControlType_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		return _strdup( getControlType( ARG1.text ) );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ҏW_CAÕ^CgԂ
// GetDialogTitle$()
char *rfunc_GetDialogTitle_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		int len;
		char *buf;

		len = GetWindowTextLength( hWnd ) + 2;
		buf = zalloc( len );
		if ( buf ) {
			GetWindowText( hWnd, buf, len+1 );
		}
		return buf;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// [̃^CgԂ
// GetWindowTitle$()
char *rfunc_GetWindowTitle_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		int len;
		char *buf;

		len = GetWindowTextLength( GetParent(hWnd) ) + 1;
		buf = zalloc( len );
		if ( buf ) {
			GetWindowText( GetParent(hWnd), buf, len );
		}
		return buf;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ݂̃[U[̃fXNgbv̕tH_Ԃ
// GetDesktopDirectory$()
char *rfunc_GetDesktopDirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char *tmp = NULL, *buf2 = NULL;
		int  len = 0;

		tmp = GetDesktopFolder();
		len = lstrlen(tmp);

		if ( tmp[len-1] == '\\' && !isKanji1(tmp,len-2) ) {
			return _strdup( tmp );
		}
		else {
            buf2 = zalloc( len + 2 );
			if ( buf2 ) {
				lstrcpy( buf2, tmp );
				lstrcat( buf2, "\\" );
			}
		}

		return buf2;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// S[U[̃fXNgbv̕tH_Ԃ
// GetCommonDesktopDirectory$()
char *rfunc_GetCommonDesktopDirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char *tmp = NULL, *buf2 = NULL;
		int  len = 0;

		tmp = GetCommonDesktopFolder();
		len = lstrlen(tmp);

		if ( tmp[len-1] == '\\' && !isKanji1(tmp,len-2) ) {
			return _strdup( tmp );
		}
		else {
            buf2 = zalloc( len + 2 );
			if ( buf2 ) {
				lstrcpy( buf2, tmp );
				lstrcat( buf2, "\\" );
			}
		}

		return buf2;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ݂̃[U[̃fXNgbv̕tH_Ԃ
// GetProgramDirectory$()
char *rfunc_GetProgramDirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char *tmp = NULL, *buf2 = NULL;
		int  len = 0;

		tmp = GetProgramFolder();
		if ( !tmp ) {
            return NULL;
		}

		len = lstrlen(tmp);

		if ( tmp[len-1] == '\\' && !isKanji1(tmp,len-2) ) {
			return _strdup( tmp );
		}
		else {
            buf2 = zalloc( len + 2 );
			if ( buf2 ) {
				lstrcpy( buf2, tmp );
				lstrcat( buf2, "\\" );
			}
		}

		return buf2;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// S[U[̃fXNgbv̕tH_Ԃ
// GetCommonProgramDirectory$()
char *rfunc_GetCommonProgramDirectory_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char *tmp = NULL, *buf2 = NULL;
		int  len = 0;

		tmp = GetCommonProgramFolder();
		if ( !tmp ) {
            return NULL;
		}

		len = lstrlen(tmp);

		if ( tmp[len-1] == '\\' && !isKanji1(tmp,len-2) ) {
			return _strdup( tmp );
		}
		else {
            buf2 = zalloc( len + 2 );
			if ( buf2 ) {
				lstrcpy( buf2, tmp );
				lstrcat( buf2, "\\" );
			}
		}

		return buf2;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// Jt@CI
// SelectOpenFile$( _CAÕ^Cg$ )
char *rfunc_SelectOpenFile_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		char fname[MAX_PATH*2] = "";

		openDialog( hWnd, FILETYPES, fname, _countof(fname), ARG1.text, NULL );
		return _strdup( fname );
	}
	else if ( args_typecheck(args, "ss") ) {
		char fname[MAX_PATH*2] = "";

		if (lstrlen(ARG2.text) < _countof(fname)) {
			lstrcpy( fname, ARG2.text );
		}
		openDialog( hWnd, FILETYPES, fname, _countof(fname), ARG1.text, NULL );
		return _strdup( fname );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// ۑt@CI܂͓͂
// SelectSaveFile$( _CAÕ^Cg$ )
char *rfunc_SelectSaveFile_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		char fname[MAX_PATH*2] = "";

		saveDialog( hWnd, FILETYPES, fname, _countof(fname), ARG1.text, NULL );
		return _strdup( fname );
	}
	else if ( args_typecheck(args, "ss") ) {
		char fname[MAX_PATH*2] = "";

		if (lstrlen(ARG2.text) < _countof(fname)) {
			lstrcpy(fname, ARG2.text);
		}
		saveDialog( hWnd, FILETYPES, fname, _countof(fname), ARG1.text, NULL );
		return _strdup( fname );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// tH_I
// SelectFolder$( _CAÕ^Cg$ )
char *rfunc_SelectFolder_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
        char chPutFolder[MAX_PATH*2] = "";

		browseFolder( hWnd, chPutFolder, ARG1.text );
		return _strdup( chPutFolder );
	}
	if ( args_typecheck(args, "ss") ) {
        char chPutFolder[MAX_PATH*2] = "";

		if (lstrlen(ARG2.text) < _countof(chPutFolder)) {
			lstrcpy(chPutFolder, ARG2.text);
		}
		browseFolder( hWnd, chPutFolder, ARG1.text );
		return _strdup( chPutFolder );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// wvhLg̓I
// ǉāÂ܂܂̕ԋp

// wvɑŃeLXgǉ(&rA\n\\par, \t\\tab)
// dhelps$( section$ )
char *rfunc_dhelps_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		helpdoc_section( ARG1.text, 0 );
		return _strdup( ARG1.text );            
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// wvɃeLXgǉ(\n\\par, \t\\tab)
// dhelp$( paragraph$ )
char *rfunc_dhelp_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		helpdoc_text( ARG1.text, 0 );
		return _strdup( ARG1.text );            
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// wvOK{^ɊւwveLXgǉ(\n\\par, \t\\tab)
// dhelpbuttons$()
char *rfunc_dhelpbuttons_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		char *text = " {\\b\\cf13 [OK]}ƁAݒ̗LsAKvɉăVXe̍ċNv܂BVXe̍ċNvꂽꍇ́AȂׂ₩ɃVXeċNĉB\n {\\b\\cf13 [LZ]}ƁȀōsݒ͑SăLZ܂BO[Kp({\\ul A})]Ăꍇ́AKpォ̕ύXLZ܂B\n {\\b\\cf13 [Kp({\\ul A})]}ƁAݒ̗LsAҏW𑱍sł܂B\n {\\b\\cf13 [߂({\\ul R})]}ƁAݒ_CAOJꂽƂ̏Ԃɖ߂܂B\n {\\b\\cf13 [ۑ({\\ul S})]}ƁA݂̐ݒ_CAȌԂt@C֕ۑ܂B\n {\\b\\cf13 [Ǎ({\\ul L})]}ƁAݒ_CAȌԂt@Cǂݏo܂B\n {\\b\\cf13 [wv({\\ul H})]}ƁAݕ\̃_CAOɊւwv\܂B\n";

		helpdoc_text( text, 0 );
		return _strdup( text );            
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// t@C̓ǂݍ
// fread$( fname$ )
// fread$( fname$, line )
char *rfunc_fread_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		FILE *fp;
		UINT fsize = 0;
		char *buf;
		UINT64 qwSize = 0;

		qwSize = getFileSizeQ(ARG1.text);
		if ( qwSize >= 2u*1024u*1024u*1024u-16u ) {
			// G[(-1==0xffffffffffffffff)܂̓t@CTCY2GBȏ̏ꍇ͎舵Ȃ
            return _strdup( "" );
		}
		fsize = (UINT)qwSize+1;

		if ( 0 == fopen_s(&fp, ARG1.text, (fmode_wide || fmode_bin) ? "rb" : "rt") ) {
			buf = zalloc( fsize+2 );
			if ( buf ) {
				if ( fmode_wide == 1 ) {
					LPWSTR wbuf = (LPWSTR)zalloc(fsize+2);

					if ( wbuf ) {
						fread(wbuf, fsize, 1, fp);
						// BOMn܂ĂA𖳎
						WideCharToMultiByte(GetACP(), 0, (wbuf[0] == 0xfeff)?wbuf+1:wbuf, -1, buf, fsize+2, NULL, NULL);
						safefree(wbuf);
					}
				}
				else {
                    fread(buf, fsize, 1, fp);
				}
			}
			else {
				buf = _strdup( "" );
			}

			fclose( fp );
		}
		else {
			buf = _strdup( "" );
		}
		return buf;
	}
	else if ( args_typecheck(args, "si") ) {
		FILE *fp;
		UINT fsize = 0, i;
		char *buf, *rv;
		UINT64 qwSize = 0;

		qwSize = getFileSizeQ(ARG1.text);
		if ( qwSize >= 2u*1024u*1024u*1024u-16u ) {
			// G[(-1==0xffffffffffffffff)܂̓t@CTCY2GBȏ̏ꍇ͎舵Ȃ
            return _strdup( "" );
		}
		fsize = (UINT)qwSize+1;

		if ( 0 == fopen_s(&fp, ARG1.text, (fmode_wide || fmode_bin) ? "rb" : "rt") ) {
			buf = zalloc( fsize+2 );
			if ( buf ) {
				for(i=0 ; i<=ARG2.integer ; i++) {
					buf[0] = 0;
					if ( fmode_wide == 1 ) {
						LPWSTR wbuf = (LPWSTR)zalloc(fsize+2);

						if ( wbuf ) {
							fgetws( wbuf, fsize, fp );
							// Psڂ̓ǂݍ݂̏ꍇABOMn܂ĂA𖳎
							WideCharToMultiByte(GetACP(), 0, (i == 0 && wbuf[0] == 0xfeff)?wbuf+1:wbuf, -1, buf, fsize+2, NULL, NULL);
							safefree(wbuf);
						}
					}
					else {
						fgets(buf, fsize, fp);
					}
				}
				i = (UINT)strlen( buf );
				if ( buf[i] == '\n' || buf[i] =='\r' ) { // s̉sL͎菜
					buf[i] = 0;
				}
				rv = _strdup( buf );
				safefree( buf );
            }
			else {
				rv = _strdup( "" );
			}

			fclose( fp );
		}
		else {
			rv = _strdup( "" );
		}
		return rv;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// [U[當̓͂󂯕t
// input$( default$, text$, caption$ )
char *rfunc_input_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		return inputdlg(hWnd, ARG1.text, ARG2.text, ARG3.text);
		// inputdlg  malloc ŊmۂԂ
	}
	else if ( args_typecheck(args, "ss") ) {
		return inputdlg(hWnd, ARG1.text, ARG2.text, "");
		// inputdlg  malloc ŊmۂԂ
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// [U[pX[h̓͂󂯕t
// inputpassword$( default$, text$, caption$ )
char *rfunc_inputpassword_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		return inputdlg_password(hWnd, ARG1.text, ARG2.text, ARG3.text);
		// inputdlg  malloc ŊmۂԂ
	}
	else if ( args_typecheck(args, "ss") ) {
		return inputdlg_password(hWnd, ARG1.text, ARG2.text, "pX[h");
		// inputdlg  malloc ŊmۂԂ
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// str$repb$repa$ɒuԂ
// replace$( str$, repb$[, repa$] )
char *rfunc_replace_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		return replacestr(ARG1.text, ARG2.text, ARG3.text);
	}
	else if ( args_typecheck(args, "ss") ) {
		return replacestr(ARG1.text, ARG2.text, "");
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// 񒆂=O̕o
// BeforeEq$( str$ )
char *rfunc_BeforeEq_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		char *str1;
		char *p_eq, *p_st;

		str1 = _strdup( ARG1.text );
		if ( str1 ) {
			p_eq = strchr( str1, '=' );
			if ( p_eq ) {
				char *tmp;

				// =̍̉̕ẼXy[XETABr
				// Xy[XETABΉĂ
				while( str1 < p_eq ) {
					if ( *(p_eq-1) == ' ' || *(p_eq-1) == '\t' ) {
						p_eq--;
					}
					else {
						break;
					}
				}

				*p_eq = 0;

				// =̍̍̃̕Xy[XETABr
				// Xy[XETABΏオĂ
				p_st = str1;
				while( p_st < p_eq ) {
					if ( *p_st == ' ' || *p_st == '\t' ) {
						p_st++;
					}
					else {
						break;
					}
				}

				tmp = _strdup(p_st);
				if ( tmp ) {
					safefree( str1 );
					str1 = tmp;
				}

				return str1;
			}
			safefree( str1 );
		}

		return _strdup( "" );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// 񒆂=̕o
// AfterEq$( str$ )
char *rfunc_AfterEq_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		char *str1;
		char *p_eq, *p_ed;

		str1 = _strdup( ARG1.text );
		if ( str1 ) {
			p_eq = strchr( str1, '=' );
			if ( p_eq ) {
				char *rv;

				p_eq++;

				// =̉E̍̃̕Xy[XETABr
				// Xy[XETAB΂Ă
				while( *p_eq ) {
					if ( *p_eq == ' ' || *p_eq == '\t' ) {
						p_eq++;
					}
					else {
						break;
					}
				}

				// =̉Ẻ̕ẼXy[XETABr
				p_ed = p_eq + lstrlen(p_eq);
				while( p_eq < p_ed ) {
					if ( *(p_ed-1) == ' ' || *(p_ed-1) == '\t' ) {
						p_ed--;
					}
					else {
						break;
					}
				}
				*p_ed = 0;

				rv = _strdup( p_eq );
				if ( rv ) {
					safefree( str1 );
					str1 = rv;
				}

				return str1;
			}
			safefree( str1 );
		}

		return _strdup( "" );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// R}hCŎw肳ꂽnԖڂ̃p[^Ԃ
// GetIParam$( n ) c (__argv)
// GetIParam$() c w肳ꂽR}hĈ܂ܕԂ(GetCommandLine API)
char *rfunc_GetIParam_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "i") ) {
		return _strdup( ( (unsigned)__argc > ARG1.integer ) ? __argv[ARG1.integer] : "" );
	}
	else if ( args_typecheck(args, "") ) {
		return _strdup( GetCommandLine() );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// OS̊eo[W擾(ԋpo[W)
// GetOSInfo$(info)
char *rfunc_GetOSInfo_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "s") ) {
		OSVERSIONINFOEX oviex;

		ZeroMemory( &oviex, sizeof(OSVERSIONINFOEX) );
		oviex.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
		GetVersionEx((OSVERSIONINFO *)&oviex);

		if ( _stricmp(ARG1.text, "CSDVersion") == 0 ) {
			return _strdup( oviex.szCSDVersion );	// ǉiɃT[rXpbNj
		}

		return _strdup( "" );
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// Ԃ
// FormatString$( format$, arg1, ... )
char *rfunc_FormatString_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args->type == UFCT_ARG_STRING ) {
		struct ARGS *p;
		char *f = args->v.text, *f2;	// 
		char *o = _strdup("");			// ԋp
		char c1[2]="x", c2[3]="xx";	// P̕Rs[pƈ

		while( *f ) {
			if ( ISKANJI1M( *f ) ) { // ̂PoCg
				if ( f[1] ) {
					c2[0] = f[0];
					c2[1] = f[1];
                    o = realloc_strcat(o, c2);
					f++;
				}
				else {
                    break;
				}
			}
			else if ( *f == '{' ) { // 荞ݍ[( {index[,[-]W][:C*]} cc {0,-10:X3} : 0Ԗڈl10[Ȃ̓Xy[X]ŁA316i擪0n܂ )
				int  width = 0, keta = 0, msize;
                char index, type = 's', i;
				char *pf;

				f++;
				if ( *f == '{' ) {	// {{  { ƕ\
					c1[0] = *f;
                    o = realloc_strcat(o, c1);
					f++;
				}
				else {
					f2 = strchr(f, '}');	// '}' 𔭌
					if ( f2 ) {
						index = (char)atoi(f);
					}
					else {
						break;
					}

					if ( f[0] == '}' ) { // ؂Ȃ͏I
						f = f2;
						continue;
					}

					// CfbNX擾
					index = (char)atoi(f);

					// 擾i̐Ȃ獶lA̐ȂElAۂ̌葫Ȃꍇ͎ۂ̌ƂȂj
					//                                           ۂ̌葽ꍇ́AȂ̓Xy[XŖ߂
					pf = strchr(f, ',');
					if ( pf && pf < f2 ) {
						pf++;
                        width = atoi(pf);
					}

					// ƌ擾iPڂAQڈȍ~B͏ȗj
					// Fu - 10ilAo - 8ilAx - 16il[10`15a`f]
					//           s -                  X - 16il[10`15A`F]
					// Fۂ̌葫Ȃꍇ́Aۂ̌ƂȂ
					//       ۂ̌葽ꍇ́AȂ0ŕB
					pf = strchr(f, ':');
					if ( pf && pf < f2 ) {
						pf++;
						switch ( *pf ) {
							case 'u':
							case 'U':
								type = 'u';
								break;

							case 'o':
							case 'O':
								type = 'o';
								break;

							case 'x':
							case 'X':
								type = *pf;
								break;

							default : // 's'z
								type = 's';
								break;
						}
                        keta = atoi(pf+1);
					}

					// ܂ł̏ɕ\s
					p = args->next;
					for(i=0 ; i<index ; i++) {
						if ( p ) {
							p = p->next;
						}
					}

					if ( p ) {
						char *pbuf, *pbuf2, fmt[15];
						// 12, width, keta, ̒ŁAł傫+1Amۂ郁TCYƂ
						msize = 12;
						if ( msize < width ) {
							msize = width;
						}
						if ( msize < keta ) {
							msize = keta;
						}
						if ( p->type == UFCT_ARG_STRING && msize < lstrlen(p->v.text) ) {
                            msize = lstrlen(p->v.text);
						}
						msize++;

						pbuf = zalloc(msize);
						pbuf2 = zalloc(msize);
						if ( pbuf && pbuf2 ) {
							if ( type == 'u' ) {
								unsigned int u;

								if ( p->type == UFCT_ARG_STRING ) {
									u = atou(p->v.text);
								}
								else if ( p->type == UFCT_ARG_INT ) {
									u = p->v.integer;
								}
								else {
									u = 0;
								}
								wsprintf(fmt, "%%0%uu", keta);
								wsprintf(pbuf, fmt, u);

								wsprintf(fmt, "%%%ds", width);
								wsprintf(pbuf2, fmt, pbuf);

								o = realloc_strcat(o, pbuf2);
							}
							else if ( type == 'o' ) {
								unsigned int u;

								if ( p->type == UFCT_ARG_STRING ) {
									u = atou(p->v.text);
								}
								else if ( p->type == UFCT_ARG_INT ) {
									u = p->v.integer;
								}
								else {
									u = 0;
								}
								wsprintf(fmt, "%%0%uo", keta);
								wsprintf(pbuf, fmt, u);

								wsprintf(fmt, "%%%ds", width);
								wsprintf(pbuf2, fmt, pbuf);

								o = realloc_strcat(o, pbuf2);
							}
							else if ( type == 'x' ) {
								unsigned int u;

								if ( p->type == UFCT_ARG_STRING ) {
									u = atou(p->v.text);
								}
								else if ( p->type == UFCT_ARG_INT ) {
									u = p->v.integer;
								}
								else {
									u = 0;
								}
								wsprintf(fmt, "%%0%ux", keta);
								wsprintf(pbuf, fmt, u);

								wsprintf(fmt, "%%%ds", width);
								wsprintf(pbuf2, fmt, pbuf);

								o = realloc_strcat(o, pbuf2);
							}
							else if ( type == 'X' ) {
								unsigned int u;

								if ( p->type == UFCT_ARG_STRING ) {
									u = atou(p->v.text);
								}
								else if ( p->type == UFCT_ARG_INT ) {
									u = p->v.integer;
								}
								else {
									u = 0;
								}
								wsprintf(fmt, "%%0%uX", keta);
								wsprintf(pbuf, fmt, u);

								wsprintf(fmt, "%%%ds", width);
								wsprintf(pbuf2, fmt, pbuf);

								o = realloc_strcat(o, pbuf2);
							}
							else if ( type == 's' ) {
								char itbuf[16];
								char *s = "err";

								if ( p->type == UFCT_ARG_STRING ) {
									s = p->v.text;
								}
								else if ( p->type == UFCT_ARG_INT ) {
									if ( 0 == _ultoa_s(p->v.integer, itbuf, _countof(itbuf), 10) ) {
										s = itbuf;
									}
								}
								else {
									s = "";
								}

								wsprintf(fmt, "%%%ds", width);
								wsprintf(pbuf2, fmt, s);

								o = realloc_strcat(o, pbuf2);
							}
						}
						safefree(pbuf2);
						safefree(pbuf);
					}


					f = f2;
				}
			}
			else {
				c1[0] = f[0];
				o = realloc_strcat(o, c1);
			}
			f++;
		}

		return o;
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// K\pāA̒us(BoostCuɂ)
// regex_replace( str, re, rep [, option] )
// str : Ώە
// re  : K\
// rep : u㕶itH[}bgj
// option : IvV(i,g,s)
// ߂l : u㕶
char *rfunc_Regex_Replace_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		return cpp_regex_replace(ARG1.text, ARG2.text, ARG3.text, "");
	}
	else if ( args_typecheck(args, "ssss") ) {
		return cpp_regex_replace(ARG1.text, ARG2.text, ARG3.text, ARG4.text);
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// C^[o^C}̐ݒ
// SetTimer(label$, msec)
// label$ : ^CAEg̎ɌĂяo郉x
// msec : ^CAEg܂ł̎ԁi~bPʁj
// ߂lF1 - A0 - s
unsigned int rfunc_SetTimer(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "si") ) {
		if (ARG1.text[0] == 0 || ARG2.integer == 0) {
			// Ƃѐ惉x0̏ꍇA܂́AԂȌꍇ́A^C}
			if (KillTimer(hWnd, EDITDIALOG_TIMERID) != 0) {
				safefree(pszEditDialogTimerLabel);
				return 1; // 
			}
		}
		else {
			if (EDITDIALOG_TIMERID == SetTimer(hWnd, EDITDIALOG_TIMERID, ARG2.integer, NULL)) {
				safefree(pszEditDialogTimerLabel);
				pszEditDialogTimerLabel = _strdup(ARG1.text);
				if (pszEditDialogTimerLabel) {
					return 1; // 
				}
				else {
					// sɂ鎸s̏ꍇ́A^C}𖳌
					KillTimer(hWnd, EDITDIALOG_TIMERID);
				}
			}
		}
		return 0; // s
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// C^[o^C}̉
// KillTimer()
// ߂lF1 - A0 - s
unsigned int rfunc_KillTimer(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "") ) {
		if (KillTimer(hWnd, EDITDIALOG_TIMERID) != 0) {
			safefree(pszEditDialogTimerLabel);
			return 1; // 
		}
		return 0; // s
	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// sҏWsidelim$Ŏw肳ꂽ1؂ƂāAsɒuĕҏWj
// MultiLineEdit$( item$, data$, delim$ )
char *rfunc_MultiLineEdit_dd(HWND hWnd, const struct ARGS *args, BYTE *result)
{
	if ( args_typecheck(args, "sss") ) {
		char *buf1 = _strdup("");
		char *buf2 = _strdup(ARG2.text);

		if (lv_edititem_m(hWnd, &buf1, &buf2, NULL, ARG1.text, ARG3.text)) {
			free(buf1);
			return buf2;
		}
		else {
			free(buf2);
			free(buf1);
			return _strdup(ARG2.text);
		}

	}
	else {
		*result = UFC_MISSMATCH_ARGS; // 
		return 0;
	}
}

// lԋp^֐ꗗiׂďŋLqAAt@xbgɃ\[g邱Ɓj
// ӁBSORTR}hƁA"_" < "3" Astrcmp ł "_" > "3" ł̂Œӂ邱ƁB
const RFUNCS rfuncs[] = {
	{"active",rfunc_active},
	{"arrayadd",rfunc_ArrayAdd},
	{"arrayinit",rfunc_ArrayInit},
	{"bit",rfunc_bit},
	{"boldtext",rfunc_boldtext},
	{"border",rfunc_border},
	{"callcmd",rfunc_CallCmd},
	{"callcmdasync",rfunc_CallCmdAsync},
	{"calldll",rfunc_CallDll},
	{"callexe",rfunc_CallExe},
	{"callexeasync",rfunc_CallExeAsync},
	{"checkbox",rfunc_checkbox},
	{"checkbox3",rfunc_checkbox3},
	{"checkbox_bin",rfunc_checkbox_bin},
	{"checkbox_bindw",rfunc_checkbox_bindw},
	{"checkmultiedit",rfunc_checkmultiedit},
	{"colorbutton",rfunc_ColorButton},
	{"combobox",rfunc_ComboBox},
	{"combobox_dw",rfunc_ComboBox_dw},
	{"combobox_sz",rfunc_ComboBox_sz},
	{"copyfile",rfunc_CopyFile},
	{"copyfiles",rfunc_CopyFiles},
	{"createbutton",rfunc_CreateButton},
	{"createdirectory",rfunc_createdirectory},
	{"createlistview",rfunc_CreateListView},
	{"createshortcut",rfunc_createshortcut},
	{"deletedirectory",rfunc_DeleteDirectory},
	{"deletefile",rfunc_DeleteFile},
	{"deletefiles",rfunc_DeleteFiles},
	{"disable",rfunc_disable},
	{"editbox",rfunc_editbox},
	{"editbox_num",rfunc_editbox_num},
	{"emptydirectory",rfunc_EmptyDirectory},
	{"enable",rfunc_enable},
	{"endcheckboxlist",rfunc_EndCheckBoxList},
	{"endgroupbox",rfunc_endgroupbox},
	{"error",rfunc_error},
	{"fappend",rfunc_fappend},
	{"fappendbinary",rfunc_fappendbinary},
	{"fileexist",rfunc_fileexist},
	{"fmodebinary",rfunc_FModeBinary},
	{"fmodewide",rfunc_FModeWide},
	{"fread",rfunc_fread},
	{"freadbinary",rfunc_freadbinary},
	{"fwrite",rfunc_fwrite},
	{"fwritebinary",rfunc_fwritebinary},
	{"getasciicode",rfunc_GetAsciiCode},
	{"getcheckbox",rfunc_getcheckbox},
	{"getcolorbutton",rfunc_GetColorButton},
	{"getcomboboxcursor",rfunc_GetComboBoxCursor},
	{"getcurrentday",rfunc_GetCurrentDay},
	{"getcurrentdayofweek",rfunc_GetCurrentDayOfWeek},
	{"getcurrenthour",rfunc_GetCurrentHour},
	{"getcurrentmilliseconds",rfunc_GetCurrentMilliseconds},
	{"getcurrentminute",rfunc_GetCurrentMinute},
	{"getcurrentmonth",rfunc_GetCurrentMonth},
	{"getcurrentsecond",rfunc_GetCurrentSecond},
	{"getcurrentyear",rfunc_GetCurrentYear},
	{"geteditboxnum",rfunc_geteditboxnum},
	{"getfsize",rfunc_getfsize},
	{"getieversion",rfunc_GetIEVersion},
	{"getiparamnum",rfunc_GetIParamNum},
	{"getmultieditlinecount",rfunc_GetMultiEditLineCount},
	{"getosinfo",rfunc_GetOSInfo},
	{"getstrbit",rfunc_getstrbit},
	{"getsystemmetrics",rfunc_GetSystemMetrics},
	{"getwindowsversion",rfunc_GetWindowsVersion},
	{"icon",rfunc_icon},
	{"information",rfunc_information},
	{"inideletekey",rfunc_iniDeleteKey},
	{"ininumkey",rfunc_iniNumKey},
	{"ininumsection",rfunc_iniNumSection},
	{"inireadbinary",rfunc_iniReadBinary},
	{"inireadint",rfunc_iniReadInt},
	{"inireadinteger",rfunc_iniReadInt},
	{"inireadsection",rfunc_iniReadSection},
	{"iniwritebinary",rfunc_iniWriteBinary},
	{"iniwriteint",rfunc_iniWriteInt},
	{"iniwriteinteger",rfunc_iniWriteInt},
	{"iniwritesection",rfunc_iniWriteSection},
	{"iniwritestring",rfunc_iniWriteString},
	{"ischanged",rfunc_isChanged},
	{"isid",rfunc_isID},
	{"isidenabled",rfunc_isIDEnabled},
	{"iskanji1",rfunc_isKanji1},
	{"isnt",rfunc_isnt},
	{"isstandardaccount",rfunc_isStandardAccount},
	{"keylist",rfunc_KeyList},
	{"killtimer",rfunc_KillTimer},
	{"listview_isselected",rfunc_ListView_isSelected},
	{"listviewadd",rfunc_ListViewAdd},
	{"listviewdelete",rfunc_ListViewDelete},
	{"listviewgetcursor",rfunc_ListViewGetCursor},
	{"listviewgetnum",rfunc_ListViewGetNum},
	{"listviewmultilineedit",rfunc_ListViewMultiLineEdit},
	{"listviewsearch",rfunc_ListViewSearch},
	{"listviewsetcursor",rfunc_ListViewSetCursor},
	{"listviewsettext",rfunc_ListViewSetText},
	{"messagebox",rfunc_textout},
	{"movefile",rfunc_MoveFile},
	{"movefiles",rfunc_MoveFiles},
	{"multiedit",rfunc_multiedit},
	{"multieditsearch",rfunc_MultiEditSearch},
	{"multitext",rfunc_multitext},
	{"notify",rfunc_notify},
	{"numid",rfunc_numID},
	{"playsound",rfunc_playsound},
	{"question",rfunc_question},
	{"question_okcancel",rfunc_question_okcancel},
	{"question_yesnocancel",rfunc_question_yesnocancel},
	{"reboot",rfunc_reboot},
	{"refresh",rfunc_refresh},
	{"regcreatekey",rfunc_regcreatekey},
	{"regdeleteallvalue",rfunc_regdeleteallvalue},
	{"regdeletekey",rfunc_regdeletekey},
	{"regdeletesubkeys",rfunc_regdeletesubkeys},
	{"regdeletevalue",rfunc_regdeletevalue},
	{"regex_match",rfunc_RegEx_Match},
	{"regex_search",rfunc_RegEx_Search},
	{"regkeyexist",rfunc_RegKeyExist},
	{"regnumkey",rfunc_RegNumKey},
	{"regnumvalue",rfunc_RegNumValue},
	{"regreadbinary",rfunc_RegReadBinary},
	{"regreadbit",rfunc_regreadbit},
	{"regreadbyte",rfunc_regreadbyte},
	{"regreadint",rfunc_regreadint},
	{"regreadinteger",rfunc_regreadint},
	{"regreadmultistring",rfunc_RegReadMultiString},
	{"regrenamekey",rfunc_regrenamekey},
	{"regrenamevalue",rfunc_RegRenameValue},
	{"regvalueexist",rfunc_RegValueExist},
	{"regvaluesize",rfunc_RegValueSize},
	{"regvaluetype",rfunc_RegValueType},
	{"regwritebinary",rfunc_RegWriteBinary},
	{"regwritebit",rfunc_regwritebit},
	{"regwritebyte",rfunc_regwritebyte},
	{"regwriteexpandstring",rfunc_regwriteexpandsz},
	{"regwriteexpandsz",rfunc_regwriteexpandsz},
	{"regwriteint",rfunc_regwriteint},
	{"regwriteinteger",rfunc_regwriteint},
	{"regwritemultistring",rfunc_RegWriteMultiString},
	{"regwritestring",rfunc_regwritesz},
	{"regwritesz",rfunc_regwritesz},
	{"resizeinit",rfunc_ResizeInit},
	{"searchdirectorys",rfunc_SearchDirectorys},
	{"searchfiles",rfunc_SearchFiles},
	{"setcheckbox",rfunc_setcheckbox},
	{"setcolorbutton",rfunc_SetColorButton},
	{"setcomboboxcursor",rfunc_SetComboBoxCursor},
	{"setcurrenttime",rfunc_SetCurrentTime},
	{"setdialogtitle",rfunc_SetDialogTitle},
	{"seteditbox",rfunc_seteditbox},
	{"seteditboxnum",rfunc_seteditboxnum},
	{"setenv",rfunc_setenv},
	{"setfocus",rfunc_setfocus},
	{"seticonbox",rfunc_seticonbox},
	{"settextctrl",rfunc_settextctrl},
	{"settimer",rfunc_SetTimer},
	{"setwindowtitle",rfunc_SetWindowTitle},
	{"sizeof",rfunc_sizeof},
	{"sleep",rfunc_sleep},
	{"space",rfunc_space},
	{"startcheckboxlist",rfunc_StartCheckBoxList},
	{"startgroupbox",rfunc_startgroupbox},
	{"stop",rfunc_stop},
	{"strlen",rfunc_strlen},
	{"strstr",rfunc_strstr},
	{"strstri",rfunc_strstri},
	{"text",rfunc_text},
	{"textout",rfunc_textout},
	{"toint",rfunc_toInt},
	{"valuelist",rfunc_ValueList},
	{"warning",rfunc_warning},
};

// ԋp^֐ꗗiׂďŋLqAAt@xbgɃ\[g邱Ɓj
const RFUNCSD rfuncsd[] = {
	{"aftereq$",rfunc_AfterEq_dd},
	{"asciicode$",rfunc_AsciiCode_dd},
	{"beforeeq$",rfunc_BeforeEq_dd},
	{"calldll$",rfunc_CallDll_dd},
	{"dhelp$",rfunc_dhelp_dd},
	{"dhelpbuttons$",rfunc_dhelpbuttons_dd},
	{"dhelps$",rfunc_dhelps_dd},
	{"enumid$",rfunc_enumID_dd},
	{"enumkey$",rfunc_EnumKey_dd},
	{"enumvalue$",rfunc_EnumValue_dd},
	{"expandenvironmentstrings$",rfunc_ExpandEnvironmentStrings_dd},
	{"formatstring$",rfunc_FormatString_dd},
	{"fread$",rfunc_fread_dd},
	{"getcommondesktopdirectory$",rfunc_GetCommonDesktopDirectory_dd},
	{"getcommonprogramdirectory$",rfunc_GetCommonProgramDirectory_dd},
	{"getcontroltype$",rfunc_GetControlType_dd},
	{"getcurrentdirectory$",rfunc_getcurrentdirectory_dd},
	{"getdesktopdirectory$",rfunc_GetDesktopDirectory_dd},
	{"getdialogtitle$",rfunc_GetDialogTitle_dd},
	{"geteditbox$",rfunc_geteditbox_dd},
	{"getenv$",rfunc_getenv_dd},
	{"getextname$",rfunc_GetExtName_dd},
	{"geticonbox$",rfunc_geteditbox_dd},
	{"geticonname$",rfunc_geteditbox_dd},
	{"getinterpreterdirectory$",rfunc_GetInterpreterDirectory_dd},
	{"getiparam$",rfunc_GetIParam_dd},
	{"getmultieditline$",rfunc_GetMultiEditLine_dd},
	{"getosinfo$",rfunc_GetOSInfo_dd},
	{"getprogramdirectory$",rfunc_GetProgramDirectory_dd},
	{"getrscdirectory$",rfunc_GetRscDirectory_dd},
	{"getrscname$",rfunc_GetRscName_dd},
	{"getstrbyte$",rfunc_getstrbyte_dd},
	{"getsystemdirectory$",rfunc_getsystemdirectory_dd},
	{"gettextctrl$",rfunc_geteditbox_dd},
	{"getwindowsdirectory$",rfunc_getwindowsdirectory_dd},
	{"getwindowtitle$",rfunc_GetWindowTitle_dd},
	{"inienumkey$",rfunc_iniEnumKey_dd},
	{"inienumsection$",rfunc_iniEnumSection_dd},
	{"inireadstring$",rfunc_iniReadString_dd},
	{"input$",rfunc_input_dd},
	{"inputpassword$",rfunc_inputpassword_dd},
	{"left$",rfunc_left_dd},
	{"listviewgettext$",rfunc_ListViewGetText_dd},
	{"mid$",rfunc_mid_dd},
	{"multilineedit$", rfunc_MultiLineEdit_dd},
	{"regex_replace$",rfunc_Regex_Replace_dd},
	{"regreadstring$",rfunc_regreadsz_dd},
	{"regreadsz$",rfunc_regreadsz_dd},
	{"replace$",rfunc_replace_dd},
	{"right$",rfunc_right_dd},
	{"selectfolder$",rfunc_SelectFolder_dd},
	{"selectopenfile$",rfunc_SelectOpenFile_dd},
	{"selectsavefile$",rfunc_SelectSaveFile_dd},
	{"signedtostr$",rfunc_SignedToStr_dd},
	{"strlwr$",rfunc_strlwr_dd},
	{"strupr$",rfunc_strupr_dd},
	{"substr$",rfunc_mid_dd},
	{"substring$",rfunc_mid_dd},
	{"tostr$",rfunc_toStr_dd},
	{"tostr16$",rfunc_toStr16_dd},
	{"tostr2$",rfunc_toStr2_dd},
	{"tostr8$",rfunc_toStr8_dd},
};

// lԋp^֐̌ďo
unsigned int funccall(HWND hWnd, const char *funcname, const struct ARGS *args, BYTE *result)
{
	char funclwr[FUNCLENGTH+1] = "";	// G[$tčĎs邽߂ "+1"
	RFUNCS *prfunc;

	if ( strlen(funcname) < FUNCLENGTH ) { // ֐̒S֐̒Z琳폈
		                                   // ({AłFUNCLENGTHł͂Ȃ_countofg
		                                   //  Ƃ낾AƂ$t邩Ȃs
		                                   //  gȂłBȉl)
		// ֐ɂĂiƂŃT[`ɎԂȂ悤ɂ邽߁j
		strcpy_s(funclwr, FUNCLENGTH, funcname);
		_strlwr_s(funclwr, FUNCLENGTH);

		// R-Script֐oCiT[`
		prfunc = (RFUNCS *)bsearch(funclwr, rfuncs, _countof(rfuncs), sizeof(RFUNCS), strcmp);

		if (prfunc) { // ֐
			*result = UFC_SUCCESS;
			return prfunc->pfunc(hWnd, args, result);
		}
		else {	// ֐Ȃ
			// $tׂHȂ̂łT[`
			RFUNCSD *prfuncd;

			strcat_s(funclwr, _countof(funclwr), "$");
			prfuncd = (RFUNCSD *)bsearch(funclwr, rfuncsd, _countof(rfuncsd), sizeof(RFUNCSD), strcmp);

			if (prfuncd) {
				// $t֐qbg$t悤ɃG[bZ[Wo͂
				*result = UFS_NEED_DOLLAR;
			}
			else {
				// ł֐Ȃ
				*result = UFC_UNKNOWN_FUNCNAME;
			}
		}
	}
	else {
		// ֐ُɒꍇ́A֐ȂƂɂďI
		*result = UFC_UNKNOWN_FUNCNAME;
	}

	// G[
	return 0xfffffffe;

}

// ԋp^֐̌ďo
// (߂lstrdupŊmۂł̂ŁAfreeŉ邱)
char *funccall_d(HWND hWnd, const char *funcname, const struct ARGS *args, BYTE *result)
{
	char funclwr[FUNCLENGTH] = "";
	RFUNCSD *prfuncd;

	if ( strlen(funcname) < _countof(funclwr) ) { // ֐̒S֐̒Z琳폈
		// ֐ɂĂiƂŃT[`ɎԂȂ悤ɂ邽߁j
		strcpy_s(funclwr, _countof(funclwr), funcname);
		_strlwr_s(funclwr, _countof(funclwr));

		// R-Script֐oCiT[`
		prfuncd = (RFUNCSD *)bsearch(funclwr, rfuncsd, _countof(rfuncsd), sizeof(RFUNCSD), strcmp);

		if (prfuncd) { // ֐
			*result = UFC_SUCCESS;
			return prfuncd->pfuncd(hWnd, args, result);
		}
		else {	// ֐Ȃ
			*result = UFC_UNKNOWN_FUNCNAME;
		}
	}
	else {
		// ֐ُɒꍇ́A֐ȂƂɂďI
		*result = UFC_UNKNOWN_FUNCNAME;
	}

	// G[
	return 0;
}
