#include "stdafx.h"
#include "rnsf7.h"
#include "cpp_func.h"
#include "symbol.h"

using namespace std;
using namespace boost;

// K\Ƀ}b`Ă邩𒲂ׂ
unsigned int cpp_regex_match(const char *str, const char *re, const char *option)
{
	bool re_opt_i = 0;		// 啶E𖳎
	bool re_opt_s = 0;		// ׂĂsƂĈ
	bool re_opt_g = 0;		// S}b`

	if ( str == NULL || re == NULL ) { // `FbN
		return ERRORVALUE;
	}

	if ( option ) { // IvV̉
		if ( strchr(option, 'i') != NULL )
			re_opt_i = 1;
		if ( strchr(option, 's') != NULL )
			re_opt_s = 1;
		if ( strchr(option, 'g') != NULL )
			re_opt_g = 1;
	}

	try {
		vector<wchar_t> vw;		// [NGA

		// K\̏
		// Boostregex́Â܂܂łMultiByteɑΉȂ
		//  WideChar ɕϊ

		int i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, re, -1, NULL, 0);
		if ( i == 0 ) {
			return ERRORVALUE;
		}
		vw.resize(i+1);
		if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, re, -1, &vw[0], i+1) ) {
			return ERRORVALUE;
		}
		wstring w_re = &vw[0];
		wregex wre(w_re, (re_opt_i ? wregex::icase : wregex::normal));

		// Ώە̏
		// l̗Rɂ WideChar ɕϊ

		i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, str, -1, NULL, 0);
		if ( i == 0 ) {
			return ERRORVALUE;
		}
		vw.resize(i+1);
		if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, str, -1, &vw[0], i+1) ) {
			return ERRORVALUE;
		}
		wstring w_str = &vw[0];

		regex_constants::match_flag_type flags = regex_constants::match_default;
		if ( re_opt_s )
			flags |= regex_constants::match_single_line;
		if ( re_opt_g )
			flags |= regex_constants::match_any;

		return regex_match(w_str, wre, flags) ? TRUE : FALSE;
	}
	catch(...) {
		return ERRORVALUE;
	}
}

// Unicode ȕ̕AShift-JISȕɂĕԂip֐j
unsigned int wclen2mblen(const char *str, unsigned int po)
{
	unsigned int i;

	for(i=0 ; str[i] ; ++i ) {
		if ( po-- == 0  ) {
            break;
		}
		if ( ISKANJI1M(str[i]) ) {
			++i;
			if ( str[i] == 0 )
				break;
		}
	}

	return i;
}

// K\ŃT[`s
unsigned int cpp_regex_search(const char *str, const char *re, const char *option, const char *startpoints, const char *lengths)
{
	bool re_opt_i = 0;		// 啶E𖳎
	bool re_opt_s = 0;		// ׂĂsƂĈ
	bool re_opt_g = 0;		// S}b`

	if ( str == NULL || re == NULL ) { // `FbN
		return ERRORVALUE;
	}

	if ( option ) { // IvV̉
		if ( strchr(option, 'i') != NULL )
			re_opt_i = 1;
		if ( strchr(option, 's') != NULL )
			re_opt_s = 1;
		if ( strchr(option, 'g') != NULL )
			re_opt_g = 1;
	}

	try {
		vector<wchar_t> vw;		// [NGA

		// K\̏
		// Boostregex́Â܂܂łMultiByteɑΉȂ
		//  WideChar ɕϊ

		int i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, re, -1, NULL, 0);
		if ( i == 0 ) {
			return ERRORVALUE;
		}
		vw.resize(i+1);
		if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, re, -1, &vw[0], i+1) ) {
			return ERRORVALUE;
		}
		wstring w_re = &vw[0];
		wregex wre(w_re, (re_opt_i ? wregex::icase : wregex::normal));

		// Ώە̏
		// l̗Rɂ WideChar ɕϊ

		i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, str, -1, NULL, 0);
		if ( i == 0 ) {
			return ERRORVALUE;
		}
		vw.resize(i+1);
		if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, str, -1, &vw[0], i+1) ) {
			return ERRORVALUE;
		}
		wstring w_str = &vw[0];

		regex_constants::match_flag_type flags = regex_constants::match_default;
		if ( re_opt_s )
			flags |= regex_constants::match_single_line;
		if ( re_opt_g )
			flags |= regex_constants::match_any;

		wsmatch wresult;
		unsigned num = 0;

		wsregex_iterator it( w_str.begin(), w_str.end(), wre, flags );
		wsregex_iterator end;

		if ( startpoints && lengths ) {
			resize_variables(startpoints, 0);
			resize_variables(lengths, 0);
		}

		for(; it!=end; ++it) {
			++num;
			if ( startpoints && lengths ) {
				unsigned ip = (unsigned)it->position(), ip2;
				unsigned il = (unsigned)it->length();

				resize_variables(startpoints, num);
				resize_variables(lengths, num);

				setVariable_a(startpoints, num-1, ip2 = wclen2mblen(str, ip));
				setVariable_a(lengths, num-1, wclen2mblen(str+ip2, il));
			}
		}

		return num;
	}
	catch(...) {
		return ERRORVALUE;
	}
}

// K\ŕus
char *cpp_regex_replace(const char *str, const char *re, const char *rep, const char *option)
{
	bool re_opt_i = 0;		// 啶E𖳎
	bool re_opt_s = 0;		// ׂĂsƂĈ
	bool re_opt_g = 0;		// S}b`

	if ( str == NULL || re == NULL || rep == NULL ) { // `FbN
		return NULL;
	}

	if ( option ) { // IvV̉
		if ( strchr(option, 'i') != NULL )
			re_opt_i = 1;
		if ( strchr(option, 's') != NULL )
			re_opt_s = 1;
		if ( strchr(option, 'g') != NULL )
			re_opt_g = 1;
	}

	try {
		vector<wchar_t> vw;		// [NGA

		// K\̏
		// Boostregex́Â܂܂łMultiByteɑΉȂ
		//  WideChar ɕϊ

		int i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, re, -1, NULL, 0);
		if ( i == 0 ) {
			return NULL;
		}
		vw.resize(i+1);
		if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, re, -1, &vw[0], i+1) ) {
			return NULL;
		}
		wstring w_re = &vw[0];
		wregex wre(w_re, (re_opt_i ? wregex::icase : wregex::normal));

		// Ώە̏
		// l̗Rɂ WideChar ɕϊ

		i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, str, -1, NULL, 0);
		if ( i == 0 ) {
			return NULL;
		}
		vw.resize(i+1);
		if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, str, -1, &vw[0], i+1) ) {
			return NULL;
		}
		wstring w_str = &vw[0];

		// u㕶̏
		// l̗Rɂ WideChar ɕϊ

		i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, rep, -1, NULL, 0);
		if ( i == 0 ) {
			return NULL;
		}
		vw.resize(i+1);
		if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, rep, -1, &vw[0], i+1) ) {
			return NULL;
		}
		wstring w_rep = &vw[0];

		regex_constants::match_flag_type flags = regex_constants::match_default;
		if ( re_opt_s )
			flags |= regex_constants::match_single_line;
		if ( re_opt_g )
			flags |= regex_constants::match_any;

		wstring w_after = regex_replace(w_str, wre, w_rep, flags);
		// u㕶WideCharł邽߁AMultiByteɕϊ

		i = WideCharToMultiByte(GetACP(), 0, w_after.c_str(), -1, NULL, 0, NULL, NULL);
		if ( i == 0 ) {
			return NULL;
		}

		vector<char> vc;
		vc.resize(i+1);

		if ( 0 == WideCharToMultiByte(GetACP(), 0, w_after.c_str(), -1, &vc[0], i+1, NULL, NULL) ) {
			return NULL;
		}

		return _strdup(&vc[0]);
	}
	catch(...) {
		return NULL;
	}
}

static LPCSTR DlgProc_ShowOutputDlg_szMessage;
static LPCSTR DlgProc_ShowOutputDlg_szTitle;
static LPCSTR DlgProc_ShowOutputDlg_szOutput;
static int    DlgProc_ShowOutputDlg_flag;

// A[JCoDLL̏o̓bZ[W\邽߂̃_CAO
static LRESULT CALLBACK DlgProc_ShowOutputDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM)
{
	switch( message ) {
		case WM_INITDIALOG:
			{
				LPSTR iKindIcon = 0;

				// flag\ׂACR̎ނm
				if ( DlgProc_ShowOutputDlg_flag & MB_ICONINFORMATION ) {
					iKindIcon = IDI_INFORMATION;
				}
				else if ( DlgProc_ShowOutputDlg_flag & MB_ICONQUESTION ) {
					iKindIcon = IDI_QUESTION;
				}
				else if ( DlgProc_ShowOutputDlg_flag & MB_ICONEXCLAMATION ) {
					iKindIcon = IDI_WARNING;
				}
				else if ( DlgProc_ShowOutputDlg_flag & MB_ICONSTOP ) {
					iKindIcon = IDI_ERROR;
				}

				// WACRǂݏoĐݒ
				if ( iKindIcon ) {
					HICON hIcon = LoadIcon(NULL, iKindIcon);
					if ( hIcon ) {
						SendDlgItemMessage(hDlg, IDC_STATIC_ICON, STM_SETICON, (WPARAM)hIcon, NULL);
					}
				}

				// bZ[W\
				SetWindowText(GetDlgItem(hDlg, IDC_STATIC_TEXT), DlgProc_ShowOutputDlg_szMessage);

				// ^Cgo[ݒ
				SetWindowText(hDlg, DlgProc_ShowOutputDlg_szTitle);

				// o̓bZ[Wݒ
				SetWindowText(GetDlgItem(hDlg, IDC_OUTPUTLOG), DlgProc_ShowOutputDlg_szOutput);

				// J[\ԍŌɈړ
				SendDlgItemMessage(hDlg, IDC_OUTPUTLOG, EM_LINESCROLL, 0, lstrlen(DlgProc_ShowOutputDlg_szOutput));
				SendDlgItemMessage(hDlg, IDC_OUTPUTLOG, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDCANCEL:
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
			}
			break;
	}
    return FALSE;	
}

INT_PTR ShowOutputDlg( HWND hDlg, LPCSTR szMessage, LPCSTR szTitle, LPCSTR szOutput, int flag )
{
	DlgProc_ShowOutputDlg_szMessage = szMessage ? szMessage : "";
	DlgProc_ShowOutputDlg_szTitle   = szTitle   ? szTitle   : "";
	DlgProc_ShowOutputDlg_szOutput  = szOutput  ? szOutput  : "";
	DlgProc_ShowOutputDlg_flag      = flag;

	return DialogBox(hInst, (LPCTSTR)IDD_OUTPUTDLG, hDlg, (DLGPROC)DlgProc_ShowOutputDlg);
}

// tH_̒̃t@CEtH_ċAIɍ폜B֎~͉Bgpō폜łȂꍇ͖ďs
// wtH_̂̂폜̂ł͂ȂAwtH_̒gɂ鎖ɒӁB
// ߂lF-1=p^G[/ُ 0=1ȏ̃t@CEtH_ō폜s(Ssor)  1:
int emptyDir(const char *folder, FILETIME *bf_ft)
{
	int iResult = 1;

	if (folder == NULL || folder[0] == 0) {
		return -1;
	}

	// NTn̏ꍇUnicodeŃtH_Et@CƌȂāAUnicodep֐̎擾sB
	if (isNT) {
		// Unicodegɂ鏈
		wchar_t *wzFolder = mb2wc(folder);
		if (wzFolder == NULL) return -1;
		iResult = emptyDirectoryW(wzFolder, bf_ft);
		safefree(wzFolder);
	}
	else {
		// ANSIł̏
		iResult = emptyDirectoryA(folder, bf_ft);
	}

	return iResult;
}
