/*
	trnsunit.c
	Pʕϊp{ԋp֐
*/

#include "stdafx.h"
#include "trnsunit.h"

#define UC(a,b) ( (_stricmp(u1,(a))==0 && _stricmp(u2,(b))==0) || (_stricmp(u2,(a))==0 && _stricmp(u1,(b))==0) )

static unsigned int uia( const char *u1, const char *u2 )
{
	if ( u1 && u2 ) {
		if ( UC("B","KB") || UC("KB","MB") || UC("MB","GB") || UC("GB","TB") || UC("TB","EB") )
			return 1024;
		else if ( UC("B","MB") || UC("KB","GB") || UC("MB","TB") || UC("TB","EB") )
			return 1024*1024;
		else if ( UC("B","GB") || UC("KB","TB") || UC("MB","EB") )
			return 1024*1024*1024;
		else if ( UC("MSEC","SEC") )
			return 1000;
		else if ( UC("MSEC","MIN") )
			return 60*1000;
		else if ( UC("MSEC","HOUR") )
			return 60*60*1000;
		else if ( UC("MSEC","DAY") )
			return 24*60*60*1000;
		else if ( UC("SEC","MIN") || UC("MIN","HOUR") )
			return 60;
		else if ( UC("SEC","HOUR") )
			return 60*60;
		else if ( UC ("SEC","DAY") )
			return 24*60*60;
		else if ( UC("MIN","HOUR") )
			return 60;
		else if ( UC("MIN","DAY") )
			return 1440;
		else if ( UC("HOUR","DAY") )
			return 24;
	}

	return 1;
}

unsigned int transunit( const char *unitunit )
{
	char *u1, *u2;
	unsigned int rv = 1;
	unsigned u1l, u2l;

	if ( unitunit != NULL && unitunit[0] != 0 ) {
		u1 = calloc( u1l = lstrlen(unitunit)+1, 1 );
		if ( u1 ) {
			u2 = calloc( u2l = lstrlen(unitunit)+1, 1 );
			if ( u2 ) {
				if ( 2 == sscanf_s( unitunit, "%s %s", u1, u1l, u2, u2l ) ) {
					rv = uia(u1, u2);
				}
				safefree( u2 );
			}
			safefree( u1 );
		}
	}

	return rv;
}
