#include "stdafx.h"

#define OWN__SIZEDLG__

#include "sizedlg.h"

SIZEDLG::~SIZEDLG()
{
	hDlg = NULL;
	if ( dlgitemdata ) {
		delete[] dlgitemdata;
		dlgitemdata = NULL;
	}
}

bool SIZEDLG::Create(HWND hWnd, const DLGITEM *dlgitems)
{
	RECT  rc, rcdlg, rcdlg0;	// Rg[_CAÕTCY𓾂
	POINT po1, po2;				// ScreenToClientWnϊ
	int   n;					// dlgitemsɗ^ꂽJEg

	// ɊւG[`FbN
	if ( hWnd == NULL || dlgitems == NULL ) {
		return false;
	}

	// _CAÕnhRs[
	hDlg = hWnd;

	// \̏
	if ( dlgitemdata ) {
		delete[] dlgitemdata;
		dlgitemdata = NULL;
	}

	// dlgitems̗vf𐔂Adlgitemdatãm
	for(n = 0; dlgitems[n].iCtrl != 0; ++n)
		;
	++n;
	dlgitemdata = new DLGITEMDATA[n];
	ZeroMemory(dlgitemdata, sizeof(DLGITEMDATA)*n);

	// _CAÕNCAg̈ɊւW̎擾
	GetClientRect(hDlg, &rcdlg);

	// _CAÔɊւW̎擾
	// i_CAȌTCYAftHg̍ŏTCYj
	GetWindowRect(hDlg, &rcdlg0);
	defwidth  = minwidth  = rcdlg0.right  - rcdlg0.left;
	defheight = minheight = rcdlg0.bottom - rcdlg0.top;
	maxwidth  = maxheight = -1; // ̍őTCY͖`

	// ACẽnhRs[B܂eW𐶐
	for(n = 0; dlgitems[n].iCtrl != 0; ++n) {
		// ACeƃAJ[Rs[
		dlgitemdata[n].hItem = GetDlgItem(hWnd, dlgitems[n].iCtrl);
		dlgitemdata[n].anchor = dlgitems[n].anchor;

		// ACe݂ȂΏJn
		if ( dlgitemdata[n].hItem ) {
			// ACéA_CAOォ̍WɊւ̎擾
			GetWindowRect(dlgitemdata[n].hItem, &rc);
			po1.x = rc.left;
			po1.y = rc.top;
			ScreenToClient(hDlg, &po1);

			// ACéA_CAOE̍WɊւ̎擾
			po2.x = rc.right;
			po2.y = rc.bottom;
			ScreenToClient(hDlg, &po2);

			switch(dlgitems[n].anchor) {
				/*case ANCHOR_TOPLEFT:
					// ɉȂ
					break;*/

				case ANCHOR_TOPRIGHT:
					// dx:_CAOEƃACe̍L
					dlgitemdata[n].dx = rcdlg.right - po1.x;
					// dy:YWL
					dlgitemdata[n].dy = po1.y;
					break;

				case ANCHOR_BOTTOMLEFT:
					// dx:XWL
					dlgitemdata[n].dx = po1.x;
					// dy:_CAOƃACe̍L
					dlgitemdata[n].dy = rcdlg.bottom - po1.y;
					break;

				case ANCHOR_BOTTOMRIGHT:
					// dx:_CAOEƃACe̍L
					dlgitemdata[n].dx = rcdlg.right - po1.x;
					// dy:_CAOƃACe̍L
					dlgitemdata[n].dy = rcdlg.bottom - po1.y;
					break;

				case ANCHOR_TOPLEFTRIGHT:
					// dx:_CAO̕ƃACe̍̕L
					dlgitemdata[n].dx = (rcdlg.right - rcdlg.left) - (rc.right - rc.left);
					// dy:ACe̍L
					dlgitemdata[n].dy = po2.y - po1.y;
					break;

				case ANCHOR_CENTER:
					// dx:_CAO̕ƃACe̍̕L
					dlgitemdata[n].dx = (rcdlg.right - rcdlg.left) - (rc.right - rc.left);
					// dy:_CAO̍ƃACe̍̍L
					dlgitemdata[n].dy = (rcdlg.bottom - rcdlg.top) - (rc.bottom - rc.top);
					break;

				case ANCHOR_BOTTOMLEFTRIGHT:
					// dx:_CAO̕ƃACe̍̕L
					dlgitemdata[n].dx = (rcdlg.right - rcdlg.left) - (rc.right - rc.left);
					// dy:_CAOƃACe̍L
					dlgitemdata[n].dy = rcdlg.bottom - po1.y;
					// dx2:ACeXWL
					dlgitemdata[n].dx2 = po1.x;
					// dy2:ACe̍L
					dlgitemdata[n].dy2 = po2.y - po1.y;
					break;
			}
		}
	}

	// ŏIf[^̃}[N}
	dlgitemdata[n].anchor = ANCHOR_END;

	return true;
}

bool SIZEDLG::Add(HWND hItem, unsigned char anchor)
{
	if (!hItem) {
		return false;
	}

	int n, m;
	// vfJEg
	for(n=0 ; dlgitemdata[n].anchor != ANCHOR_END ; ++n) {
		if (dlgitemdata[n].hItem == hItem) {
			// o^ςُ݂I
			return false;
		}
	}
	m = n + 2;
	DLGITEMDATA *temp_dlgitemdata = new DLGITEMDATA[m];
	if (!temp_dlgitemdata) {
		return false;
	}
	
	memcpy(temp_dlgitemdata, dlgitemdata, sizeof(DLGITEMDATA)*n);
	temp_dlgitemdata[n].hItem = hItem;
	temp_dlgitemdata[n].anchor = anchor;

	delete dlgitemdata;
	dlgitemdata = temp_dlgitemdata;

	RECT  rcdlg, rc;
	POINT po1, po2;

	// _CAÕNCAg̈ɊւW̎擾
	GetClientRect(hDlg, &rcdlg);

	// ACéA_CAOォ̍WɊւ̎擾
	GetWindowRect(dlgitemdata[n].hItem, &rc);
	po1.x = rc.left;
	po1.y = rc.top;
	ScreenToClient(hDlg, &po1);

	// ACéA_CAOE̍WɊւ̎擾
	po2.x = rc.right;
	po2.y = rc.bottom;
	ScreenToClient(hDlg, &po2);

	switch(anchor) {
		/*case ANCHOR_TOPLEFT:
			// ɉȂ
			break;*/

		case ANCHOR_TOPRIGHT:
			// dx:_CAOEƃACe̍L
			dlgitemdata[n].dx = rcdlg.right - po1.x;
			// dy:YWL
			dlgitemdata[n].dy = po1.y;
			break;

		case ANCHOR_BOTTOMLEFT:
			// dx:XWL
			dlgitemdata[n].dx = po1.x;
			// dy:_CAOƃACe̍L
			dlgitemdata[n].dy = rcdlg.bottom - po1.y;
			break;

		case ANCHOR_BOTTOMRIGHT:
			// dx:_CAOEƃACe̍L
			dlgitemdata[n].dx = rcdlg.right - po1.x;
			// dy:_CAOƃACe̍L
			dlgitemdata[n].dy = rcdlg.bottom - po1.y;
			break;

		case ANCHOR_TOPLEFTRIGHT:
			// dx:_CAO̕ƃACe̍̕L
			dlgitemdata[n].dx = (rcdlg.right - rcdlg.left) - (rc.right - rc.left);
			// dy:ACe̍L
			dlgitemdata[n].dy = po2.y - po1.y;
			break;

		case ANCHOR_CENTER:
			// dx:_CAO̕ƃACe̍̕L
			dlgitemdata[n].dx = (rcdlg.right - rcdlg.left) - (rc.right - rc.left);
			// dy:_CAO̍ƃACe̍̍L
			dlgitemdata[n].dy = (rcdlg.bottom - rcdlg.top) - (rc.bottom - rc.top);
			break;

		case ANCHOR_BOTTOMLEFTRIGHT:
			// dx:_CAO̕ƃACe̍̕L
			dlgitemdata[n].dx = (rcdlg.right - rcdlg.left) - (rc.right - rc.left);
			// dy:_CAOƃACe̍L
			dlgitemdata[n].dy = rcdlg.bottom - po1.y;
			// dx2:ACeXWL
			dlgitemdata[n].dx2 = po1.x;
			// dy2:ACe̍L
			dlgitemdata[n].dy2 = po2.y - po1.y;
			break;
	}
	
	// ŏIf[^̃}[N}
	dlgitemdata[n+1].hItem  = 0;
	dlgitemdata[n+1].anchor = ANCHOR_END;

	return true;
}

bool SIZEDLG::Add(HWND hWnd, int iItem, unsigned char anchor)
{
	return Add(GetDlgItem(hWnd, iItem), anchor);
}

bool SIZEDLG::Resize(bool bRedraw)
{
	if ( hDlg ) {
		RECT rcdlg;
		int  n;

		// V_CAOTCY擾
		GetClientRect(hDlg, &rcdlg);

		for(n=0; dlgitemdata[n].anchor != ANCHOR_END ; ++n) {
			if (dlgitemdata[n].hItem) {
				switch(dlgitemdata[n].anchor) {
					case ANCHOR_TOPRIGHT:
						// dx:_CAOEƃACe̍LĂ
						// dy:YWLĂ
						SetWindowPos(dlgitemdata[n].hItem, 0, rcdlg.right - dlgitemdata[n].dx, dlgitemdata[n].dy, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
						break;

					case ANCHOR_BOTTOMLEFT:
						// dx:XWLĂ
						// dy:_CAOƃACe̍LĂ
						SetWindowPos(dlgitemdata[n].hItem, 0, dlgitemdata[n].dx, rcdlg.bottom - dlgitemdata[n].dy, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
						break;

					case ANCHOR_BOTTOMRIGHT:
						// dx:_CAOEƃACe̍LĂ
						// dy:_CAOƃACe̍LĂ
						SetWindowPos(dlgitemdata[n].hItem, 0, rcdlg.right - dlgitemdata[n].dx, rcdlg.bottom - dlgitemdata[n].dy, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
						break;

					case ANCHOR_TOPLEFTRIGHT:
						// dx:_CAO̕ƃACe̍̕LĂ
						// dy:ACe̍LĂ
						SetWindowPos(dlgitemdata[n].hItem, 0, 0, 0, (rcdlg.right - rcdlg.left) - dlgitemdata[n].dx, dlgitemdata[n].dy, SWP_NOMOVE | SWP_NOZORDER);
						break;

					case ANCHOR_CENTER:
						// dx:_CAO̕ƃACe̍̕LĂ
						// dy:_CAO̍ƃACe̍̍LĂ
						SetWindowPos(dlgitemdata[n].hItem, 0, 0, 0, (rcdlg.right - rcdlg.left) - dlgitemdata[n].dx, (rcdlg.bottom - rcdlg.top) - dlgitemdata[n].dy, SWP_NOMOVE | SWP_NOZORDER);
						break;

					case ANCHOR_BOTTOMLEFTRIGHT:
						// dx:_CAO̕ƃACe̍̕LĂ
						// dy:_CAOƃACe̍LĂ
						// dx2:ACeXWLĂ
						// dy2:ACe̍LĂ
						SetWindowPos(dlgitemdata[n].hItem, 0, dlgitemdata[n].dx2, rcdlg.bottom - dlgitemdata[n].dy, (rcdlg.right - rcdlg.left) - dlgitemdata[n].dx, dlgitemdata[n].dy2, SWP_NOZORDER);
						break;
				}
			}
		}

		if ( bRedraw ) {
			// ʂ̍ĕ`
			InvalidateRect(hDlg, NULL, TRUE);
		}

		return true;
	}
	return false;
}

BOOL SIZEDLG::GetMinMaxInfo(LPARAM lParam)
{
	MINMAXINFO *pmmi = (MINMAXINFO *)lParam;

	if ( pmmi ) {
		if ( minwidth != -1 ) {
			pmmi->ptMinTrackSize.x = minwidth;    // ŏ(_CAO̍ŏ̕ftHg)
		}
		if ( minheight != -1 ) {
			pmmi->ptMinTrackSize.y = minheight;   // ŏ(_CAO̍ŏ̍ftHg)
		}
		if ( maxwidth != -1 ) {
			pmmi->ptMaxTrackSize.x = maxwidth;    // ő啝 - ftHg͎wȂ
		}
		if ( maxheight != -1 ) {
			pmmi->ptMaxTrackSize.y = maxheight;   // ő卂 - ftHg͎wȂ
		}

		return TRUE;
	}
	else {
		return FALSE;
	}
}
