// regclass.cpp : RnsfтV[YpWXgNX/ʃCu
/*

@Copyright(C) 2002-2011 INASOFT /Ayacy

@́AREGCLASS.LIB 𐶐邽߂̃\[XvOłB
@C++ŃWXgeՂɈ߂̃NXCuƁACŃWXgeՂ
@߂̃CułB

*/

#include "stdafx.h"

#define OWN__REGCLASS__

#include "regclass.h"

#define zalloc(n)     ((char *)calloc((n),sizeof(char)))
#define walloc(n)     ((wchar_t *)calloc((n),sizeof(wchar_t)))

static bool modeJP = 1, useMessage = 1;
static bool bDisableReflectionKey = false;
static LONG tRegLastError = ERROR_SUCCESS; // ŌɔWXgnWindows APĨG[R[hi҃fobOp̂߁AׂĂŎ擾ł킯ł͂Ȃj

// Cũo[W̎擾
LibExport DWORD tRegGetVersion(void)
{
	return REGCLASS_VERSIONNUMBER;
}

// pꃂ[hւ̐؂ւ
LibExport VOID  tRegEnglishMode(BOOL flag)
{
	modeJP = flag ? false : true;
}

// m[bZ[W[hւ̐؂ւ
LibExport VOID  tRegNoMessageMode(BOOL flag)
{
	useMessage = flag ? false : true;
}

// ̃CuŊJWXgɂāAWXg̃tNVsȂ
LibExport VOID  tRegDisableReflectionKeyMode(BOOL flag)
{
	bDisableReflectionKey = flag ? true : false;
}

// w肵L[̃nhɂāAWXg̃tNVsȂ
LibExport LONG  tRegDisableReflectionKey(HKEY hBase)
{
	typedef LONG (WINAPI *LPFN_REGDISABLEREFLECTIONKEY) (HKEY);
	LPFN_REGDISABLEREFLECTIONKEY fnRegDisableReflectionKey =
		(LPFN_REGDISABLEREFLECTIONKEY)GetProcAddress(GetModuleHandle("Advapi32"), "RegDisableReflectionKey");

	if (fnRegDisableReflectionKey) {
		return fnRegDisableReflectionKey(hBase);
	}

	return ERROR_BAD_ENVIRONMENT;
}

// ŌɔWXgnWindows APĨG[R[hi҃fobOp̂߁AׂĂŎ擾ł킯ł͂Ȃj
LibExport LONG  tRegGetLastError(void)
{
	return tRegLastError;
}

// tRegGetLastErrorԂl
LibExport VOID  tRegClearLastError(void)
{
	tRegLastError = ERROR_SUCCESS;
}

// fXgN^
REGA::~REGA()
{
	if ( hkey ) {
	    CloseKey();
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"WXgN[Y܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in REGA::~REGA().","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}
}

REGW::~REGW()
{
	if ( hkey ) {
	    CloseKey();
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"WXgN[Y܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in REGW::~REGW().",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}
}

// L[̃I[v/쐬 <NX>
bool REGA::OpenKey(HKEY root, const char *subkey, DWORD flag)
{ // root:JĂL[ subkey:ꂩJL[ flag:TREG_OPEN_CREATE=݂Ȃ΍쐬, TREG_OPEN_READONLY=ǂݍ݂̂݃[h
    if ( hkey ) {
		CloseKey();
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"WXgL[𑽏dI[v悤Ƃ̂ŕی삵܂(REGA::OpenKey())B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in REGA::OpenKey().","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}

	hkey = tRegOpenKey(root, subkey, flag);

	return hkey?true:false;
}

bool REGW::OpenKey(HKEY root, const wchar_t *subkey, DWORD flag)
{ // root:JĂL[ subkey:ꂩJL[ flag:TREG_OPEN_CREATE=݂Ȃ΍쐬, TREG_OPEN_READONLY=ǂݍ݂̂݃[h
    if ( hkey ) {
		CloseKey();
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"WXgL[𑽏dI[v悤Ƃ̂ŕی삵܂(REGW::OpenKey())B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in REGW::OpenKey().",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}

	hkey = tRegOpenKeyW(root, subkey, flag);

	return hkey?true:false;
}

// WXgL[J
LibExport HKEY tRegOpenKeyA(HKEY root, const char *subkey, DWORD flag)
{ // root:JĂL[ subkey:ꂩJL[ flag:0=݉\ȃ[hŌĂяo TREG_OPEN_CREATE=݂Ȃ΍쐬, TREG_OPEN_READONLY=ǂݍ݂̂݃[h
	DWORD wh;
	HKEY  hkey;

	tRegLastError = ERROR_SUCCESS;

	if ( subkey ) {
		if (root == NULL) {
			hkey = tRegHiveKeyA( subkey );
			if ( hkey ) {
				return hkey;
			}
			else {
				if (0 == strncmp(subkey, "HKEY_CLASSES_ROOT\\", 18)) {
					root = HKEY_CLASSES_ROOT;
					subkey += 18;
				}
				else if (0 == strncmp(subkey, "HKCR\\", 5)) {
					root = HKEY_CLASSES_ROOT;
					subkey += 5;
				}
				else if (0 == strncmp(subkey, "HKEY_CURRENT_USER\\", 18)) {
					root = HKEY_CURRENT_USER;
					subkey += 18;
				}
				else if (0 == strncmp(subkey, "HKCU\\", 5)) {
					root = HKEY_CURRENT_USER;
					subkey += 5;
				}
				else if (0 == strncmp(subkey, "HKEY_LOCAL_MACHINE\\", 19)) {
					root = HKEY_LOCAL_MACHINE;
					subkey += 19;
				}
				else if (0 == strncmp(subkey, "HKLM\\", 5)) {
					root = HKEY_LOCAL_MACHINE;
					subkey += 5;
				}
				else if (0 == strncmp(subkey, "HKEY_USERS\\", 11)) {
					root = HKEY_USERS;
					subkey += 11;
				}
				else if (0 == strncmp(subkey, "HKEY_CURRENT_CONFIG\\", 20)) {
					root = HKEY_CURRENT_CONFIG;
					subkey += 20;
				}
				else if (0 == strncmp(subkey, "HKCC\\", 5)) {
					root = HKEY_CURRENT_CONFIG;
					subkey += 5;
				}
				else if (0 == strncmp(subkey, "HKEY_DYN_DATA\\", 14)) {
					root = HKEY_DYN_DATA;
					subkey += 14;
				}
				else if (0 == strncmp(subkey, "HKDD\\", 5)) {
					root = HKEY_DYN_DATA;
					subkey += 5;
				}
				else if (0 == strncmp(subkey, "HKEY_PERFORMANCE_DATA\\", 22)) {
					root = HKEY_PERFORMANCE_DATA;
					subkey += 22;
				}
				else if (0 == strncmp(subkey, "HKPD\\", 5)) {
					root = HKEY_PERFORMANCE_DATA;
					subkey += 5;
				}
				else if (0 == strncmp(subkey, "HKEY_PERFORMANCE_TEXT\\", 22)) {
					root = HKEY_PERFORMANCE_TEXT;
					subkey += 22;
				}
				else if ( 0 == strncmp(subkey, "HKPT\\", 5)) {
					root = HKEY_PERFORMANCE_TEXT;
					subkey += 5;
				}
				else if (0 == strncmp(subkey, "HKEY_PERFORMANCE_NLSTEXT\\", 25)) {
					root = HKEY_PERFORMANCE_NLSTEXT;
					subkey += 25;
				}
				else if (0 == strncmp(subkey, "HKPN\\", 5)) {
					root = HKEY_PERFORMANCE_NLSTEXT;
					subkey += 5;
				}
				else {
					return NULL;
				}
			}
		}

		if (ERROR_SUCCESS == (tRegLastError = RegOpenKeyEx(root, subkey, 0, (flag & TREG_OPEN_READONLY) ? KEY_READ : KEY_ALL_ACCESS, &hkey))) {
			if (bDisableReflectionKey) tRegDisableReflectionKey(hkey);
			return hkey;
		}

		if ((flag & TREG_OPEN_CREATE) && ERROR_SUCCESS == (tRegLastError = RegCreateKeyEx(root, subkey, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &wh))) {
			if (bDisableReflectionKey) tRegDisableReflectionKey(hkey);
			return hkey;
		}
	}

	return NULL;
}

LibExport HKEY tRegOpenKeyW(HKEY root, const wchar_t *subkey, DWORD flag)
{ // root:JĂL[ subkey:ꂩJL[ flag:0=݉\ȃ[hŌĂяo TREG_OPEN_CREATE=݂Ȃ΍쐬, TREG_OPEN_READONLY=ǂݍ݂̂݃[h
	DWORD wh;
	HKEY  hkey;

	tRegLastError = ERROR_SUCCESS;

	if ( subkey ) {
		if (root == NULL) {
			hkey = tRegHiveKeyW( subkey );
			if ( hkey ) {
				return hkey;
			}
			else {
				if (0 == wcsncmp(subkey, L"HKEY_CLASSES_ROOT\\", 18)) {
					root = HKEY_CLASSES_ROOT;
					subkey += 18;
				}
				else if (0 == wcsncmp(subkey, L"HKCR\\", 5)) {
					root = HKEY_CLASSES_ROOT;
					subkey += 5;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_CURRENT_USER\\", 18)) {
					root = HKEY_CURRENT_USER;
					subkey += 18;
				}
				else if (0 == wcsncmp(subkey, L"HKCU\\", 5)) {
					root = HKEY_CURRENT_USER;
					subkey += 5;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_LOCAL_MACHINE\\", 19)) {
					root = HKEY_LOCAL_MACHINE;
					subkey += 19;
				}
				else if (0 == wcsncmp(subkey, L"HKLM\\", 5)) {
					root = HKEY_LOCAL_MACHINE;
					subkey += 5;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_USERS\\", 11)) {
					root = HKEY_USERS;
					subkey += 11;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_CURRENT_CONFIG\\", 20)) {
					root = HKEY_CURRENT_CONFIG;
					subkey += 20;
				}
				else if (0 == wcsncmp(subkey, L"HKCC\\", 5)) {
					root = HKEY_CURRENT_CONFIG;
					subkey += 5;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_DYN_DATA\\", 14)) {
					root = HKEY_DYN_DATA;
					subkey += 14;
				}
				else if (0 == wcsncmp(subkey, L"HKDD\\", 5)) {
					root = HKEY_DYN_DATA;
					subkey += 5;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_PERFORMANCE_DATA\\", 22)) {
					root = HKEY_PERFORMANCE_DATA;
					subkey += 22;
				}
				else if (0 == wcsncmp(subkey, L"HKPD\\", 5)) {
					root = HKEY_PERFORMANCE_DATA;
					subkey += 5;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_PERFORMANCE_TEXT\\", 22)) {
					root = HKEY_PERFORMANCE_TEXT;
					subkey += 22;
				}
				else if ( 0 == wcsncmp(subkey, L"HKPT\\", 5)) {
					root = HKEY_PERFORMANCE_TEXT;
					subkey += 5;
				}
				else if (0 == wcsncmp(subkey, L"HKEY_PERFORMANCE_NLSTEXT\\", 25)) {
					root = HKEY_PERFORMANCE_NLSTEXT;
					subkey += 25;
				}
				else if (0 == wcsncmp(subkey, L"HKPN\\", 5)) {
					root = HKEY_PERFORMANCE_NLSTEXT;
					subkey += 5;
				}
				else {
					return NULL;
				}
			}
		}

		if (ERROR_SUCCESS == (tRegLastError = RegOpenKeyExW(root, subkey, 0, (flag & TREG_OPEN_READONLY) ? KEY_READ : KEY_ALL_ACCESS, &hkey))) {
			if (bDisableReflectionKey) tRegDisableReflectionKey(hkey);
			return hkey;
		}

		if ((flag & TREG_OPEN_CREATE) && ERROR_SUCCESS == (tRegLastError = RegCreateKeyExW(root, subkey, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey, &wh))) {
			if (bDisableReflectionKey) tRegDisableReflectionKey(hkey);
			return hkey;
		}
	}

	return NULL;
}

// ^ꂽTuL[̃I[v/쐬 <NX>
bool REGA::OpenSubKey(HKEY root, const char *subkey, const char *subsubkey, DWORD flag)
{
    if ( hkey ) {
		CloseKey();
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"WXgL[𑽏dI[v悤Ƃ̂ŕی삵܂(REGA::OpenSubKey)B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in REGA::OpenSubKey().","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}

	hkey = tRegOpenSubKey(root, subkey, subsubkey, flag);

	return hkey?true:false;
}

bool REGW::OpenSubKey(HKEY root, const wchar_t *subkey, const wchar_t *subsubkey, DWORD flag)
{
    if ( hkey ) {
		CloseKey();
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"WXgL[𑽏dI[v悤Ƃ̂ŕی삵܂(REGW::OpenSubKey)B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in REGW::OpenSubKey().",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}

	hkey = tRegOpenSubKeyW(root, subkey, subsubkey, flag);

	return hkey?true:false;
}

// ^ꂽTuL[̃I[v/쐬
LibExport HKEY tRegOpenSubKeyA(HKEY root, const char *subkey, const char *subsubkey, DWORD flag)
{
	char *keyname;
	HKEY hkey = NULL;

	// NULLꍇ̊e΍
	if ( subkey == NULL && subsubkey != NULL ) {
		return tRegOpenKey(root, subsubkey, flag);
	}
	else if ( subkey != NULL && subsubkey == NULL ) {
		return tRegOpenKey(root, subkey, flag);
	}
	else if ( subkey == NULL && subsubkey == NULL ) {
		return NULL;
	}

	keyname = zalloc(lstrlen(subkey) + lstrlen(subsubkey) + 2); // subkey\\ĂȂƂl+2

	if ( keyname ) { // set_new_handler(0) ΍
		lstrcpy(keyname, subkey);
		if (keyname[lstrlen(subkey)-1] != '\\') {
			lstrcat(keyname, "\\");
		}
		lstrcat(keyname, subsubkey);

		hkey = tRegOpenKey(root, keyname, flag);
		free(keyname);
	}

	return hkey;
}

LibExport HKEY tRegOpenSubKeyW(HKEY root, const wchar_t *subkey, const wchar_t *subsubkey, DWORD flag)
{
	wchar_t *keyname;
	HKEY hkey = NULL;

	// NULLꍇ̊e΍
	if ( subkey == NULL && subsubkey != NULL ) {
		return tRegOpenKeyW(root, subsubkey, flag);
	}
	else if ( subkey != NULL && subsubkey == NULL ) {
		return tRegOpenKeyW(root, subkey, flag);
	}
	else if ( subkey == NULL && subsubkey == NULL ) {
		return NULL;
	}

	keyname = walloc(lstrlenW(subkey) + lstrlenW(subsubkey) + 2); // subkey\\ĂȂƂl+2

	if ( keyname ) { // set_new_handler(0) ΍
		lstrcpyW(keyname, subkey);
		if (keyname[lstrlenW(subkey)-1] != L'\\') {
			lstrcatW(keyname, L"\\");
		}
		lstrcatW(keyname, subsubkey);

		hkey = tRegOpenKeyW(root, keyname, flag);
		free(keyname);
	}

	return hkey;
}


// l݂TCYԂA݂Ȃ-1Ԃ
LibExport int  tRegValueExistA(HKEY hkey, const char *ValueName)
{ // hkey:WXgL[ ValueName:݂mFl̖O 
	int size = -1;

	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ ValueExistA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ValueExistA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return -1;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey,ValueName,NULL,NULL,NULL,(unsigned long *)&size))) {
		return size;
	}
	else {
		return -1;
	}
}

LibExport int  tRegValueExistW(HKEY hkey, const wchar_t *ValueName)
{ // hkey:WXgL[ ValueName:݂mFl̖O 
	int size = -1;

	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ ValueExistW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ValueExistW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return -1;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey,ValueName,NULL,NULL,NULL,(unsigned long *)&size))) {
		return size;
	}
	else {
		return -1;
	}
}

// l݂TCYԂA݂Ȃ0Ԃ
LibExport DWORD tRegValueSizeA(HKEY hkey, const char *ValueName)
{ // hkey:WXgL[ ValueName:TCYm肽l̖O 
	DWORD size = 0;

	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ ValueSizeA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ValueSizeA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey,ValueName,NULL,NULL,NULL,&size))) {
		return size;
	}
	else {
		return 0;
	}
}

LibExport DWORD tRegValueSizeW(HKEY hkey, const wchar_t *ValueName)
{ // hkey:WXgL[ ValueName:TCYm肽l̖O 
	DWORD size = 0;

	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ ValueSizeW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ValueSizeW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey,ValueName,NULL,NULL,NULL,&size))) {
		return size;
	}
	else {
		return 0;
	}
}

// ľ^Ԃ (l݂^ԂA݂Ȃ 0 Ԃ)
LibExport DWORD tRegValueTypeA(HKEY hkey, const char *ValueName)
{
	DWORD type = 0;

	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ ValueTypeA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ValueTypeA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return (DWORD)-1;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey,ValueName,NULL,&type,NULL,NULL))) {
		return type;
	}
	else {
		return 0;
	}
}

LibExport DWORD tRegValueTypeW(HKEY hkey, const wchar_t *ValueName)
{
	DWORD type = 0;

	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ ValueTypeW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ValueTypeW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return (DWORD)-1;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey,ValueName,NULL,&type,NULL,NULL))) {
		return type;
	}
	else {
		return 0;
	}
}

// ̓ǂݍ
LibExport BOOL tRegReadStringA(HKEY hkey, const char *ValueName, char *Value, int size)
{
	tRegLastError = ERROR_SUCCESS;

	if (ValueName == NULL || Value == NULL) {
		return FALSE;
	}

	Value[0] = 0;
	if (hkey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ ReadStringA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ReadStringA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey,ValueName,NULL,NULL,(LPBYTE)Value,(LPDWORD)&size)))?TRUE:FALSE;
}

LibExport BOOL tRegReadStringW(HKEY hkey, const wchar_t *ValueName, wchar_t *Value, int size)
{
	tRegLastError = ERROR_SUCCESS;

	if (ValueName == NULL || Value == NULL) {
		return FALSE;
	}

	Value[0] = 0;
	if (hkey == NULL) {
		MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ ReadStringW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ReadStringW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

	size *= sizeof(wchar_t);

	return (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey,ValueName,NULL,NULL,(LPBYTE)Value,(LPDWORD)&size)))?TRUE:FALSE;
}

// lH
static BOOL isNumberA( const char *str )
{
	if ( str && (str[0] == '-' || str[0] == '+' || ('0' <= str[0] && str[0] <= '9')) ) {
		for(int i=1 ; str[i] ; i++) {
			if ( !('0' <= str[i] && str[i] <= '9') ) {
				return FALSE;
			}
		}
		return TRUE;
	}
	return FALSE;
}

static BOOL isNumberW( const wchar_t *str )
{
	if ( str && (str[0] == L'-' || str[0] == L'+' || (L'0' <= str[0] && str[0] <= L'9')) ) {
		for(int i=1 ; str[i] ; i++) {
			if ( !(L'0' <= str[i] && str[i] <= L'9') ) {
				return FALSE;
			}
		}
		return TRUE;
	}
	return FALSE;
}

// l̓ǂݍ
LibExport DWORD tRegReadIntegerA(HKEY hkey, const char *ValueName, DWORD Def)
{
    DWORD Integer = Def, size = 0, type = 0;
	char *data;

/*
REG_DWORD   ̂܂ܐlƂĎ擾
REG_QWORD@ ͂߂̂SoCg𐔒lƂĎ擾
REG_DWORD_BIG_ENDIAN@ gGfBAɕϊAlƂĎ擾

REG_BINARY  4oCgȓ̕𐔒lƂĎ擾
@@@@@@@(ۂɂ̋ɈˑĂӏ邽)

REG_SZ, REG_MULTI_SZ  j[bN`FbN(̕񂪐lƂđÓ
REG_EXPAND_SZ @@@@@̔)sAlƌȂΐlɂA
@@@@@@@@@@@@łȂ΃ftHgl̗pB

̑̃WXg^  ftHgl̗pB
*/
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ ReadIntegerA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ReadIntegerA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}
	else {
		// KvȃoCg͂炩ߒׂ
		if ( ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey, ValueName, NULL, &type, NULL, (LPDWORD)&size))) {
			size++;
			data = zalloc(size);

			if ( data ) {
				if ( ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey, ValueName, NULL, &type, (LPBYTE)data, (LPDWORD)&size))) {
					switch( type ) {
						case REG_DWORD: // == REG_DWORD_LITTLE_ENDIAN
						case REG_BINARY:
						case REG_QWORD: // == REG_QWORD_LITTLE_ENDIAN
							CopyMemory(&Integer, data, 4);
							break;

						case REG_DWORD_BIG_ENDIAN:
							{
								char tmp;

								tmp = data[3];
								data[3] = data[0];
								data[0] = tmp;
								tmp = data[2];
								data[2] = data[1];
								data[1] = tmp;

								CopyMemory(&Integer, data, 4);
							}
							break;

						case REG_SZ:
						case REG_MULTI_SZ:
						case REG_EXPAND_SZ:
							if ( isNumberA( data ) ) {
								Integer = atoi( data );
							}
							break;
					}
				}
				free( data );
			}
		}
	}

	return Integer;
}

LibExport DWORD tRegReadIntegerW(HKEY hkey, const wchar_t *ValueName, DWORD Def)
{
    DWORD Integer = Def, size = 0, type = 0;
	wchar_t *data;

	tRegLastError = ERROR_SUCCESS;

/*
REG_DWORD   ̂܂ܐlƂĎ擾
REG_QWORD@ ͂߂̂SoCg𐔒lƂĎ擾
REG_DWORD_BIG_ENDIAN@ gGfBAɕϊAlƂĎ擾

REG_BINARY  4oCgȓ̕𐔒lƂĎ擾
@@@@@@@(ۂɂ̋ɈˑĂӏ邽)

REG_SZ, REG_MULTI_SZ  j[bN`FbN(̕񂪐lƂđÓ
REG_EXPAND_SZ @@@@@̔)sAlƌȂΐlɂA
@@@@@@@@@@@@łȂ΃ftHgl̗pB

̑̃WXg^  ftHgl̗pB
*/

	if (hkey == NULL) {
		if( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ ReadIntegerW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ReadIntegerW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}
	else {
		// KvȃoCg͂炩ߒׂ
		if ( ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey, ValueName, NULL, &type, NULL, &size))) {
			size++;
			data = (wchar_t *)calloc(size, 1);

			if ( data ) {
				if ( ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey, ValueName, NULL, &type, (LPBYTE)data, &size))) {
					switch( type ) {
						case REG_DWORD: // == REG_DWORD_LITTLE_ENDIAN
						case REG_BINARY:
						case REG_QWORD: // == REG_QWORD_LITTLE_ENDIAN
							CopyMemory(&Integer, data, 4);
							break;

						case REG_DWORD_BIG_ENDIAN:
							{
								wchar_t tmp;

								tmp = data[3];
								data[3] = data[0];
								data[0] = tmp;
								tmp = data[2];
								data[2] = data[1];
								data[1] = tmp;

								CopyMemory(&Integer, data, 4);
							}
							break;

						case REG_SZ:
						case REG_MULTI_SZ:
						case REG_EXPAND_SZ:
							if ( isNumberW( data ) ) {
								Integer = _wtoi( data );
							}
							break;
					}
				}
				free( data );
			}
		}
	}

	return Integer;
}

// ̏
LibExport BOOL tRegWriteStringA(HKEY hkey, const char *ValueName, const char *Value, char rws_expand_flag)
{
	DWORD			flag = REG_SZ, flag2 = 0;
	int				i = 0, n = 0;

	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ WriteStringA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in WriteStringA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	if (rws_expand_flag == TREG_EXPAND_SZ) { // (=1) mɓWJ
		flag = REG_EXPAND_SZ;
	}
	else if (rws_expand_flag == TREG_MAYBE_SZ) { // (=2) ЂƂƓWJ
		for(i=n=0 ; Value[i] ; i++) {
			if(Value[i] == '%') {
				n++;
			}
		}
		if (n >= 2)
			flag = REG_EXPAND_SZ;
	}
	else if (rws_expand_flag == TREG_NORMAL_SZ) { // (=3) mɒʏ핶
		;
	}
	else { // TREG_SZ(=0) w莞́AWXgWJ񂾂AWJ
		if (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey,ValueName,NULL,&flag2,NULL,NULL))) {
			if (flag2 == REG_EXPAND_SZ) {
				flag = REG_EXPAND_SZ;
			}
		}
	}

#ifndef _WIN64
	// Windows95 / NT4 ł́AftHgGg͓WJɂłȂ
	OSVERSIONINFO	verinfo;
	verinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&verinfo);
	if ( verinfo.dwPlatformId != VER_PLATFORM_WIN32_NT ) {
		if (HIWORD(verinfo.dwBuildNumber)) {
			verinfo.dwMajorVersion = (DWORD)(HIWORD(verinfo.dwBuildNumber) >> 8);
			verinfo.dwMinorVersion = (DWORD)(HIWORD(verinfo.dwBuildNumber) & 0xff);
		}
		else { // WinXPɂUłƎv
			verinfo.dwMajorVersion = 5;
			verinfo.dwMinorVersion = 1;
		}
	}
	if (ValueName[0] == 0 && verinfo.dwMajorVersion == 4 && verinfo.dwMinorVersion == 0) {
		flag = REG_SZ;
	}
#endif /* _WIN64 */

	return (ERROR_SUCCESS == (tRegLastError = RegSetValueEx(hkey,ValueName,NULL,flag,(const unsigned char *)Value,lstrlen(Value)+1)));
}

LibExport BOOL tRegWriteStringW(HKEY hkey, const wchar_t *ValueName, const wchar_t *Value, char rws_expand_flag)
{
	DWORD			flag = REG_SZ, flag2 = 0;
	int				i = 0, n = 0;
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ WriteStringW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in WriteStringW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	if (rws_expand_flag == TREG_EXPAND_SZ) { // (=1) mɓWJ
		flag = REG_EXPAND_SZ;
	}
	else if (rws_expand_flag == TREG_MAYBE_SZ) { // (=2) ЂƂƓWJ
		for(i=n=0 ; Value[i] ; i++) {
			if(Value[i] == L'%') {
				n++;
			}
		}
		if (n >= 2)
			flag = REG_EXPAND_SZ;
	}
	else if (rws_expand_flag == TREG_NORMAL_SZ) { // (=3) mɒʏ핶
		;
	}
	else { // TREG_SZ(=0) w莞́AWXgWJ񂾂AWJ
		if (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey,ValueName,NULL,&flag2,NULL,NULL))) {
			if (flag2 == REG_EXPAND_SZ) {
				flag = REG_EXPAND_SZ;
			}
		}
	}

#ifndef _WIN64
	// Windows95 / NT4 ł́AftHgGg͓WJɂłȂ
	OSVERSIONINFO	verinfo;
	verinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&verinfo);
	if ( verinfo.dwPlatformId != VER_PLATFORM_WIN32_NT ) {
		if (HIWORD(verinfo.dwBuildNumber)) {
			verinfo.dwMajorVersion = (DWORD)(HIWORD(verinfo.dwBuildNumber) >> 8);
			verinfo.dwMinorVersion = (DWORD)(HIWORD(verinfo.dwBuildNumber) & 0xff);
		}
		else { // WinXPɂUłƎv
			verinfo.dwMajorVersion = 5;
			verinfo.dwMinorVersion = 1;
		}
	}
	if (ValueName[0] == 0 && verinfo.dwMajorVersion == 4 && verinfo.dwMinorVersion == 0) {
		flag = REG_SZ;
	}
#endif /* _WIN64 */

	return (ERROR_SUCCESS == (tRegLastError = RegSetValueExW(hkey,ValueName,NULL,flag,(const unsigned char *)Value,sizeof(wchar_t)*(lstrlenW(Value)+1))));
}

// l̏
LibExport BOOL tRegWriteIntegerA(HKEY hkey,const char *ValueName, DWORD Integer)
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ WriteIntegerA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in WriteIntegerA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegSetValueEx(hkey,ValueName,NULL,REG_DWORD,(LPBYTE)&Integer,sizeof(DWORD))))?TRUE:FALSE;
}

LibExport BOOL tRegWriteIntegerW(HKEY hkey,const wchar_t *ValueName, DWORD Integer)
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ WriteIntegerW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in WriteIntegerW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegSetValueExW(hkey,ValueName,NULL,REG_DWORD,(LPBYTE)&Integer,sizeof(DWORD))))?TRUE:FALSE;
}

// oCif[^̏
LibExport BOOL tRegWriteBinaryA(HKEY hkey, const char *ValueName, const char *Value, int size)
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ WriteBinaryA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in WriteBinaryA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegSetValueEx(hkey,ValueName,NULL,REG_BINARY,(const unsigned char *)Value,size)))?TRUE:FALSE;
}

LibExport BOOL tRegWriteBinaryW(HKEY hkey, const wchar_t *ValueName, const char *Value, int size)
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ WriteBinaryW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in WriteBinaryW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegSetValueExW(hkey,ValueName,NULL,REG_BINARY,(const unsigned char *)Value,size)))?TRUE:FALSE;
}

// JĂL[̉̃L[폜 <NX>
bool REGA::DeleteKey(const char *subkey) const
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ REGA::DeleteKey s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in REGA::DeleteKey().","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegDeleteKey(hkey, subkey)));
}

bool REGW::DeleteKey(const wchar_t *subkey) const
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ REGW::DeleteKey s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in REGW::DeleteKey().",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegDeleteKeyW(hkey, subkey)));
}

// JĂL[̉̃L[폜(ɉ̃L[Sč폜) <NX>
bool REGA::DeleteSubKey(const char *subkey) const
{
	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ REGA::DeleteSubKey s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in REGA::DeleteSubKey().","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	return tRegDeleteSubKeyA(hkey, subkey) ? true : false;
}

bool REGW::DeleteSubKey(const wchar_t *subkey) const
{
	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ REGW::DeleteSubKeyW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in REGW::DeleteSubKey().",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	return tRegDeleteSubKeyW(hkey, subkey) ? true : false;
}

// JĂL[̉̒l폜 <NX>
bool REGA::DeleteValue(const char *valuename) const
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ REGA::DeleteValue s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in REGA::DeleteValue().","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegDeleteValue(hkey, valuename)));
}

bool REGW::DeleteValue(const wchar_t *valuename) const
{
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ REGW::DeleteValue s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in REGW::DeleteValue().",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return false;
	}
	return (ERROR_SUCCESS == (tRegLastError = RegDeleteValueW(hkey, valuename)));
}

// WXg̃N[Y <NX>
bool REGA::CloseKey(void)
{
	tRegLastError = ERROR_SUCCESS;

	if ( hkey ) {
		tRegLastError = RegCloseKey(hkey);
		hkey = NULL;
		return (tRegLastError == ERROR_SUCCESS);
	}
	else {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"WXg𑽏dN[Y悤Ƃ̂ŕی삵܂(REGA::CloseKey)B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in REGA::CloseKey().","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}
	return false;
}

bool REGW::CloseKey(void)
{
	tRegLastError = ERROR_SUCCESS;

	if ( hkey ) {
		tRegLastError = RegCloseKey(hkey);
		hkey = NULL;
		return (tRegLastError == ERROR_SUCCESS);
	}
	else {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"WXg𑽏dN[Y悤Ƃ̂ŕی삵܂(REGW::CloseKey)B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in REGW::CloseKey().",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
	}
	return false;
}

// WXg當ǂݍ݁Â܂܃GfBbg{bNX
LibExport BOOL tRegReadStringForEditboxA(HKEY hkey, const char *ValueName, HWND hDlg, int nIDDlgItem, const char *Def)
{
	int n;
	char *str = 0;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ ReadStringForEditboxA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ReadStringForEditboxA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = tRegValueExist(hkey, ValueName);

	if (n <= 0) {
		SetDlgItemText(hDlg, nIDDlgItem, Def);
		return FALSE;
	}
	else {
		str = zalloc(n);
		if ( str ) { // set_new_handler(0) ΍
			tRegReadStringA(hkey, ValueName, str, n);
			SetDlgItemText(hDlg, nIDDlgItem, str);
			free(str);
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
}

LibExport BOOL tRegReadStringForEditboxW(HKEY hkey, const wchar_t *ValueName, HWND hDlg, int nIDDlgItem, const wchar_t *Def)
{
	int n;
	wchar_t *str = 0;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ ReadStringForEditboxW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ReadStringForEditboxW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = tRegValueExistW(hkey, ValueName);

	if (n <= 0) {
		SetDlgItemTextW(hDlg, nIDDlgItem, Def);
		return FALSE;
	}
	else {
		str = walloc(n+1);
		if ( str ) { // set_new_handler(0) ΍
			tRegReadStringW(hkey, ValueName, str, n);
			SetDlgItemTextW(hDlg, nIDDlgItem, str);
			free(str);
			return TRUE;
		}
		else {
			return FALSE;
		}
	}
}

// WXg琔lǂ݂ƂÂ܂܃GfBbg{bNX
LibExport BOOL tRegReadIntegerForEditboxA(HKEY hkey, const char *ValueName, HWND hDlg, int nIDDlgItem, DWORD Def, BOOL bSigned)
{
    DWORD n;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ ReadIntegerForEditboxA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ReadIntegerForEditboxA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = tRegReadIntegerA(hkey, ValueName, Def);
	return SetDlgItemInt(hDlg, nIDDlgItem, n, bSigned);
}

LibExport BOOL tRegReadIntegerForEditboxW(HKEY hkey, const wchar_t *ValueName, HWND hDlg, int nIDDlgItem, DWORD Def, BOOL bSigned)
{
    DWORD n;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ ReadIntegerForEditboxW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ReadIntegerForEditboxW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = tRegReadIntegerW(hkey, ValueName, Def);
	return SetDlgItemInt(hDlg, nIDDlgItem, n, bSigned);
}

// GfBbg{bNX當̏݁iftHgΉj
LibExport BOOL tRegWriteStringFromEditboxDefA(HKEY hkey, const char *ValueName, HWND hDlg, int nIDDlgItem, const char *Def)
{
	char *s = 0;
	int  n;
	BOOL result = FALSE;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ WriteStringFromEditBoxA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in WriteStringFromEditBoxA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = GetWindowTextLength(GetDlgItem(hDlg, nIDDlgItem))+1;
	s = zalloc(n);
	if ( s ) { // set_new_handler(0) ΍
		s[0] = 0;
		GetDlgItemText(hDlg, nIDDlgItem, s, n);
		result = tRegWriteStringA(hkey, ValueName, s[0]?s:Def, 0);
		free(s);
	}

	return result;
}

LibExport BOOL tRegWriteStringFromEditboxDefW(HKEY hkey, const wchar_t *ValueName, HWND hDlg, int nIDDlgItem, const wchar_t *Def)
{
	wchar_t *s = 0;
	int  n;
	BOOL result = FALSE;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ WriteStringFromEditBoxW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in WriteStringFromEditBoxW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = GetWindowTextLengthW(GetDlgItem(hDlg, nIDDlgItem))+1;
	s = walloc(n);
	if ( s ) { // set_new_handler(0) ΍
		s[0] = 0;
		GetDlgItemTextW(hDlg, nIDDlgItem, s, n);
		result = tRegWriteStringW(hkey, ValueName, s[0]?s:Def, 0);
		free(s);
	}

	return result;
}

// GfBbg{bNX當ǂ݂ƂÂ܂܃WXg
LibExport BOOL tRegWriteStringFromEditboxA(HKEY hkey, const char *ValueName, HWND hDlg, int nIDDlgItem, char rws_expand_flag)
{
	int n;
	BOOL result = FALSE;
	char *str = 0;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ WriteStringFromEditboxA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in WriteStringFromEditboxA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = GetWindowTextLength(GetDlgItem(hDlg, nIDDlgItem))+1;
	str = zalloc(n);
	if ( str ) { // set_new_handler(0) ΍
		str[0] = 0;
		GetDlgItemText(hDlg, nIDDlgItem, str, n);
		result = tRegWriteStringA(hkey, ValueName, str, rws_expand_flag);
		free(str);
	}

	return result;
}

LibExport BOOL tRegWriteStringFromEditboxW(HKEY hkey, const wchar_t *ValueName, HWND hDlg, int nIDDlgItem, char rws_expand_flag)
{
	int n;
	BOOL result = FALSE;
	wchar_t *str = 0;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ WriteStringFromEditboxW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in WriteStringFromEditboxW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	n = GetWindowTextLengthW(GetDlgItem(hDlg, nIDDlgItem))+1;
	str = walloc(n);
	if ( str ) { // set_new_handler(0) ΍
		str[0] = 0;
		GetDlgItemTextW(hDlg, nIDDlgItem, str, n);
		result = tRegWriteStringW(hkey, ValueName, str, rws_expand_flag);
		free(str);
	}

	return result;
}

// GfBbg{bNX琔lǂ݂ƂÂ܂܃WXg
LibExport BOOL tRegWriteIntegerFromEditboxA(HKEY hkey, const char *ValueName, HWND hDlg, int nIDDlgItem)
{
	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ WriteIntegerFromEditboxA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in WriteIntegerFromEditboxA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	return tRegWriteIntegerA(hkey, ValueName, GetDlgItemInt(hDlg, nIDDlgItem, NULL, 0));
}

LibExport BOOL tRegWriteIntegerFromEditboxW(HKEY hkey, const wchar_t *ValueName, HWND hDlg, int nIDDlgItem)
{
	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ WriteIntegerFromEditboxW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in WriteIntegerFromEditboxW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	return tRegWriteIntegerW(hkey, ValueName, GetDlgItemInt(hDlg, nIDDlgItem, NULL, 0));
}

// (new)ReadString ⏕֐
static char *aux_ReadStringA(HKEY hkey, const char *ValueName, const char *Def, int *lpn)
{
	int size = 0;
	char *p = 0;
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL,modeJP?"JĂȂL[Ώۂ (new)RegReadStringA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in (new)ReadString.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		size = 0;
	}
	else {
        size = tRegValueExist(hkey, ValueName);
	}

	if ( size <= 0 ) {
		if ( Def ) {
			if ( lpn ) {
				*lpn = lstrlen( Def ) + 1;
			}
			return _strdup(Def);
		}
		else {
			return NULL;
		}
	}

	p = zalloc( size+1 );
	if (p && ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hkey,ValueName,NULL,NULL,(unsigned char *)p,(unsigned long *)&size))) {
		size /= sizeof(char);
		
		if ( lpn ) {
			*lpn = size + 1;
		}
		p[size] = 0;
		return p;
	}
	else
		return NULL;
}

static wchar_t *aux_ReadStringW(HKEY hkey, const wchar_t *ValueName, const wchar_t *Def, int *lpn)
{
	int size = 0;
	wchar_t *p = 0;
	tRegLastError = ERROR_SUCCESS;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ (new)RegReadStringW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in (new)ReadString.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		}
		size = 0;
	}
	else {
        size = tRegValueExistW(hkey, ValueName);
	}

	if ( size <= 0 ) {
		if ( Def ) {
			if ( lpn ) {
				*lpn = lstrlenW( Def ) + 1;
			}
			return _wcsdup(Def);
		}
		else {
			return NULL;
		}
	}

	p = walloc( size+1 );
	if (p && ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hkey,ValueName,NULL,NULL,(unsigned char *)p,(unsigned long *)&size))) {
		size /= sizeof(wchar_t);
		
		if ( lpn ) {
			*lpn = size + 1;
		}
		p[size] = 0;
		return p;
	}
	else
		return NULL;
}

// ̏ƃWXg當̃[hB߂l͂Ƃ delete[] 邱ƁI <NX>
char* REGA::new_ReadString(const char *ValueName, const char *Def) const
{
	int n = 0;
	char *p = 0, *r = 0;

	p = aux_ReadStringA(hkey, ValueName, Def, &n);
	if ( p ) {
		r = new char [ n ];
		if ( r ) { // set_new_handler(0) ΍
			memcpy(r, p, n*sizeof(char));
		}
		free( p );
		return r;
	}
	return NULL;
}

wchar_t* REGW::new_ReadString(const wchar_t *ValueName, const wchar_t *Def) const
{
	int n = 0;
	wchar_t *p = 0, *r = 0;

	p = aux_ReadStringW(hkey, ValueName, Def, &n);
	if ( p ) {
		r = new wchar_t [ n ];
		if ( r ) { // set_new_handler(0) ΍
			memcpy(r, p, n*sizeof(wchar_t));
		}
		free( p );
		return r;
	}
	return NULL;
}

// ̊mۂƕ̓ǂݍ - Ƃfree邱
LibExport char *mtRegReadStringA(HKEY hkey, const char *ValueName, const char *Def)
{
	return aux_ReadStringA(hkey, ValueName, Def, NULL);
}

LibExport wchar_t *mtRegReadStringW(HKEY hkey, const wchar_t *ValueName, const wchar_t *Def)
{
	return aux_ReadStringW(hkey, ValueName, Def, NULL);
}

// REG_MULTI_SZf[^ǂݍ݁A\0\r\nɕϊvalueɓ
LibExport BOOL tRegReadMultiStringA(HKEY hkey, const char *ValueName, char *value, int size)
{
	int i, j;
	char *data;
	DWORD type = 0;
	bool last_is_nl = 0;

	if (ValueName == NULL || value == NULL || size == 0)
		return FALSE;

	value[0] = 0;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL, modeJP?"JĂȂL[Ώۂ ReadMultiStringA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in ReadMultiStringA.","Registry Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	data = mtRegReadString(hkey, ValueName, 0);

	if ( data == NULL ) { // l݂Ȃꍇ
		return FALSE;
	}

	type = tRegValueType(hkey, ValueName);
	if ( type == REG_SZ || type == REG_EXPAND_SZ ) { // REG_MULTI_SZł͂Ȃꍇ
		if ( lstrlen(data) < size ) {
			lstrcpy(value, data);
			free( data );
			return TRUE;
		}
		else {
			free( data );
			return FALSE;
		}
	}
	else if ( type == REG_MULTI_SZ ) { // REG_MULTI_SZ ꍇ \0\r\n ɕϊ
		for(i=j=0 ; j<size ; i++,j++) {
			if ( data[i] == '\0' ) {
				if ( last_is_nl ) {
					value[j] = 0;
					break;
				}
				else {
					value[j] = '\r';
					value[++j] = '\n';
					last_is_nl = 1;
				}
			}
			else {
				value[j] = data[i];
				last_is_nl = 0;
			}
		}

		free( data );

		if (j == size) {
			value[0] = 0;
			return FALSE;
		}

		return TRUE;
	}

	return FALSE; // G[
}

LibExport BOOL tRegReadMultiStringW(HKEY hkey, const wchar_t *ValueName, wchar_t *value, int size)
{
	int i, j;
	wchar_t *data;
	DWORD type = 0;
	bool last_is_nl = 0;

	if (ValueName == NULL || value == NULL || size == 0)
		return FALSE;

	value[0] = 0;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL, modeJP?L"JĂȂL[Ώۂ ReadMultiStringW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in ReadMultiStringW.",L"Registry Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	data = mtRegReadStringW(hkey, ValueName, 0);

	if ( data == NULL ) { // l݂Ȃꍇ
		return FALSE;
	}

	type = tRegValueTypeW(hkey, ValueName);
	if ( type == REG_SZ || type == REG_EXPAND_SZ ) { // REG_MULTI_SZł͂Ȃꍇ
		if ( lstrlenW(data) < size ) {
			lstrcpyW(value, data);
			free( data );
			return TRUE;
		}
		else {
			free( data );
			return FALSE;
		}
	}
	else if ( type == REG_MULTI_SZ ) { // REG_MULTI_SZ ꍇ \0\r\n ɕϊ
		for(i=j=0 ; j<size ; i++,j++) {
			if ( data[i] == L'\0' ) {
				if ( last_is_nl ) {
					value[j] = 0;
					break;
				}
				else {
					value[j] = L'\r';
					value[++j] = L'\n';
					last_is_nl = 1;
				}
			}
			else {
				value[j] = data[i];
				last_is_nl = 0;
			}
		}

		free( data );

		if (j == size) {
			value[0] = 0;
			return FALSE;
		}

		return TRUE;
	}

	return FALSE; // G[
}

// \r\n\0ɕϊAREG_MULTI_SZփf[^
LibExport BOOL tRegWriteMultiStringA(HKEY hkey, const char *ValueName, const char *value)
{
	char *data = 0;
	int  i, j;
	bool last_is_cr = 0;
	tRegLastError = ERROR_SUCCESS;

	if (ValueName == NULL || value == NULL)
		return FALSE;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBox(NULL, modeJP?"JĂȂL[Ώۂ WriteMultiStringA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in WriteMultiStringA.","Registry Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	data = zalloc(lstrlen(value)+2);

	if ( data ) { // set_new_handler(0) ΍
		for(i=j=0 ; value[i] ; i++,j++) {
			if ( value[i] == '\r' ) {
				if ( last_is_cr ) {
					i++;
					j--;
				}
				else {
					data[j] = 0;
					i++;
					if ( value[i] == 0 )
						break;
					last_is_cr = 1;
				}
			}
			else {
				data[j] = value[i];
				last_is_cr = 0;
			}
		}

		data[j] = 0;
		if ( !last_is_cr )
			data[++j] = 0;

		tRegLastError = RegSetValueEx(hkey,ValueName,NULL,REG_MULTI_SZ,(const unsigned char *)data, j+1);
		free(data);

		return (tRegLastError == ERROR_SUCCESS)?TRUE:FALSE;
	}
	else { // s
		return FALSE;
	}
}

LibExport BOOL tRegWriteMultiStringW(HKEY hkey, const wchar_t *ValueName, const wchar_t *value)
{
	wchar_t *data = 0;
	int  i, j;
	bool last_is_cr = 0;
	tRegLastError = ERROR_SUCCESS;

	if (ValueName == NULL || value == NULL)
		return FALSE;

	if (hkey == NULL) {
		if ( useMessage ) {
			MessageBoxW(NULL, modeJP?L"JĂȂL[Ώۂ WriteMultiStringW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in WriteMultiStringW.",L"Registry Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return FALSE;
	}

	data = walloc(lstrlenW(value)+2);

	if ( data ) { // set_new_handler(0) ΍
		for(i=j=0 ; value[i] ; i++,j++) {
			if ( value[i] == L'\r' ) {
				if ( last_is_cr ) {
					i++;
					j--;
				}
				else {
					data[j] = 0;
					i++;
					if ( value[i] == 0 )
						break;
					last_is_cr = 1;
				}
			}
			else {
				data[j] = value[i];
				last_is_cr = 0;
			}
		}

		data[j] = 0;
		if ( !last_is_cr )
			data[++j] = 0;

		tRegLastError = RegSetValueExW(hkey,ValueName,NULL,REG_MULTI_SZ,(const unsigned char *)data, j+1);
		free(data);

		return (tRegLastError == ERROR_SUCCESS)?TRUE:FALSE;
	}
	else { // s
		return FALSE;
	}
}

// (new)ReadMultiString⏕֐
static char *aux_ReadMultiStringA(HKEY hkey, const char *ValueName, int *lpn)
{
	char *p = 0;
	DWORD type = 0, l, i, j, n;
	tRegLastError = ERROR_SUCCESS;

	if ( hkey == NULL ) {
		if ( useMessage ) {
			MessageBox(NULL, modeJP?"JĂȂL[Ώۂ (new)ReadMultiStringA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in (new)ReadMultiStringA.","Registry Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return NULL;
	}

	if ( ValueName == NULL || ERROR_SUCCESS != (tRegLastError = RegQueryValueEx(hkey, ValueName, 0, &type, NULL, &l))) {
		return NULL;
	}

	if ( type == REG_SZ || type == REG_EXPAND_SZ ) { // REG_MULTI_SZł͂Ȃꍇ
		return aux_ReadStringA( hkey, ValueName, 0, lpn );
	}
	else if ( type == REG_MULTI_SZ ) { // REG_MULTI_SZꍇ - ܂ \0 ̐𐔂A\0\r\nɕϊ̃TCY𒲂ׂ
		p = (char *)calloc( l, 1 );
		if ( p ) {
			RegQueryValueEx(hkey, ValueName, 0, &type, (LPBYTE)p, &l);
			l /= sizeof(char);

			for(i=j=0; i<l ; i++) {
				if ( p[i] == '\0' )
					j++;
			}

			n = i+j; // \0\r\nɕϊ̃TCY i+j-1. Ō\0𑫂i+j.
			free( p );

			p = zalloc( n );
			if ( p ) {
				tRegReadMultiStringA(hkey, ValueName, p, n);
				if ( lpn ) {
					*lpn = n;
				}
				return p;
			}
		}
	}

	return NULL; // s܂̓G[
}

static wchar_t *aux_ReadMultiStringW(HKEY hkey, const wchar_t *ValueName, int *lpn)
{
	wchar_t *p = 0;
	DWORD type = 0, l, i, j, n;
	tRegLastError = ERROR_SUCCESS;

	if ( hkey == NULL ) {
		if ( useMessage ) {
			MessageBoxW(NULL, modeJP?L"JĂȂL[Ώۂ (new)ReadMultiStringW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in (new)ReadMultiStringW.",L"Registry Class",MB_OK | MB_ICONEXCLAMATION);
		}
		return NULL;
	}

	if ( ValueName == NULL || ERROR_SUCCESS != (tRegLastError = RegQueryValueExW(hkey, ValueName, 0, &type, NULL, &l))) {
		return NULL;
	}

	if ( type == REG_SZ || type == REG_EXPAND_SZ ) { // REG_MULTI_SZł͂Ȃꍇ
		return aux_ReadStringW( hkey, ValueName, 0, lpn );
	}
	else if ( type == REG_MULTI_SZ ) { // REG_MULTI_SZꍇ - ܂ \0 ̐𐔂A\0\r\nɕϊ̃TCY𒲂ׂ
		p = (wchar_t *)calloc( l, 1 );
		if ( p ) {
			RegQueryValueExW(hkey, ValueName, 0, &type, (LPBYTE)p, &l);
			l /= sizeof(wchar_t);

			for(i=j=0; i<l ; i++) {
				if ( p[i] == L'\0' )
					j++;
			}

			n = i+j; // \0\r\nɕϊ̃TCY i+j-1. Ō\0𑫂i+j.
			free( p );

			p = walloc( n );
			if ( p ) {
				tRegReadMultiStringW(hkey, ValueName, p, n);
				if ( lpn ) {
					*lpn = n;
				}
				return p;
			}
		}
	}

	return NULL; // s܂̓G[
}


// REG_MULTI_SZf[^ǂݍ݁A\0\r\nɕϊāÄmۂĕԋp(Ƃdelete[]邱) <NX>
char* REGA::new_ReadMultiString(const char *ValueName) const
{
	char *p = 0, *r = 0;
	int  n = 0;
	
	p = aux_ReadMultiStringA(hkey, ValueName, &n);

	if ( p ) {
        r = new char [ n ];
		if ( r ) { // set_new_handler(0) ΍
            memcpy(r, p, n*sizeof(char));
		}
		free( p );
		return r;
	}
	return NULL;
}

wchar_t* REGW::new_ReadMultiString(const wchar_t *ValueName) const
{
	wchar_t *p = 0, *r = 0;
	int  n = 0;
	
	p = aux_ReadMultiStringW(hkey, ValueName, &n);

	if ( p ) {
        r = new wchar_t [ n ];
		if ( r ) { // set_new_handler(0) ΍
            memcpy(r, p, n*sizeof(wchar_t));
		}
		free( p );
		return r;
	}
	return NULL;
}

// REG_MULTI_SZf[^ǂݍ݁A\0\r\nɕϊāÄmۂĕԋp(Ƃfree邱)
LibExport char *mtRegReadMultiStringA(HKEY hkey, const char *ValueName)
{
	return aux_ReadMultiStringA(hkey, ValueName, NULL);
}

LibExport wchar_t *mtRegReadMultiStringW(HKEY hkey, const wchar_t *ValueName)
{
	return aux_ReadMultiStringW(hkey, ValueName, NULL);
}

// hkSource\\source  hkDest\\dest ցAlRs[AhkSource\\source ׂ̂Ă̒l폜
LibExport BOOL tRegMoveValuesA(HKEY hkSource, const char *source, HKEY hkDest, const char *dest)
{
	REG   reg1, reg2;
	DWORD n = 0,vn = 0,vl = 0,vtype = 0, maxValueNameLen = 0, maxValueLen = 0;
	char  *valuename = 0, *valuedata = 0;
	BOOL  bflag = FALSE;

	if (reg1.OpenKey(hkSource, source, true)) {
		RegQueryInfoKey(reg1.GetHKey(), NULL, NULL, NULL, NULL, NULL, NULL, NULL, &maxValueNameLen, &maxValueLen, NULL, NULL);
		maxValueNameLen += 5;
		valuename = zalloc(maxValueNameLen);
		if ( valuename ) { // set_new_handler(0) ΍
			maxValueLen += 5;
			valuedata = zalloc(maxValueLen);
			if ( valuedata ) { // set_new_handler(0) ΍
				if (reg2.OpenKey(hkDest, dest, true)) {
					// lRs[
					n = 0;
					while( (vn = maxValueNameLen, vl = maxValueLen), ERROR_NO_MORE_ITEMS != RegEnumValue(reg1.GetHKey(),n,valuename,&vn,0,&vtype,(unsigned char *)valuedata,&vl) ) {
						RegSetValueEx(reg2.GetHKey(), valuename,0,vtype,(unsigned char *)valuedata,vl);
						n++;
					}

					// Rs[̒l폜
					n = 0;
					while( (vn = maxValueNameLen, vl = maxValueLen), ERROR_NO_MORE_ITEMS != RegEnumValue(reg2.GetHKey(),n,valuename,&vn,0,&vtype,(unsigned char *)valuedata,&vl) ) {
						reg1.DeleteValue(valuename);
						n++;
					}

					reg2.CloseKey();
					bflag = TRUE;
				}
				free(valuedata);
			}
			free(valuename);
		}
		reg1.CloseKey();
	}

	return bflag;
}

// hkSource\\source  hkDest\\dest ցAlRs[AhkSource\\source ׂ̂Ă̒l폜
LibExport BOOL tRegMoveValuesW(HKEY hkSource, const wchar_t *source, HKEY hkDest, const wchar_t *dest)
{
	REGW    reg1, reg2;
	DWORD   n = 0,vn = 0,vl = 0,vtype = 0, maxValueNameLen = 0, maxValueLen = 0;
	wchar_t *valuename = 0;
	char    *valuedata = 0;
	BOOL    bflag = FALSE;

	if (reg1.OpenKey(hkSource, source, true)) {
		RegQueryInfoKeyW(reg1.GetHKey(), NULL, NULL, NULL, NULL, NULL, NULL, NULL, &maxValueNameLen, &maxValueLen, NULL, NULL);
		maxValueNameLen += 5;
		valuename = walloc(maxValueNameLen);
		if ( valuename ) { // set_new_handler(0) ΍
			maxValueLen += 5;
			valuedata = zalloc(maxValueLen);
			if ( valuedata ) { // set_new_handler(0) ΍
				if (reg2.OpenKey(hkDest, dest, true)) {
					// lRs[
					n = 0;
					while( (vn = maxValueNameLen, vl = maxValueLen), ERROR_NO_MORE_ITEMS != RegEnumValueW(reg1.GetHKey(),n,valuename,&vn,0,&vtype,(unsigned char *)valuedata,&vl) ) {
						RegSetValueExW(reg2.GetHKey(), valuename, 0, vtype, (unsigned char *)valuedata, vl);
						n++;
					}

					// Rs[̒l폜
					n = 0;
					while( (vn = maxValueNameLen, vl = maxValueLen), ERROR_NO_MORE_ITEMS != RegEnumValueW(reg2.GetHKey(),n,valuename,&vn,0,&vtype,(unsigned char *)valuedata,&vl) ) {
						reg1.DeleteValue(valuename);
						n++;
					}

					reg2.CloseKey();
					bflag = TRUE;
				}
				free(valuedata);
			}
			free(valuename);
		}
		reg1.CloseKey();
	}

	return bflag;
}

// init@C̃ZNV̐𐔂
LibExport DWORD tiniNumSectionA( const char *inifile )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	char *lpBuf = 0;

	if ( inifile == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = zalloc(dwSize)) ) {
		dwr = GetPrivateProfileSectionNames( lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileSectionNames()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			for(i=n=0 ; !(lpBuf[i] == '\0' && lpBuf[i+1] == '\0') ; i++) {
				if ( lpBuf[i+1] == '\0' ) {
					n++;
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return n;
}

LibExport DWORD tiniNumSectionW( const wchar_t *inifile )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	wchar_t *lpBuf = 0;

	if ( inifile == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = walloc(dwSize)) ) {
		dwr = GetPrivateProfileSectionNamesW( lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileSectionNames()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			for(i=n=0 ; !(lpBuf[i] == L'\0' && lpBuf[i+1] == L'\0') ; i++) {
				if ( lpBuf[i+1] == L'\0' ) {
					n++;
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return n;
}


// init@C̃ZNṼL[̐𐔂
LibExport DWORD tiniNumKeyA( const char *inifile, const char *section )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	char *lpBuf = 0;

	if ( inifile == NULL || section == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = zalloc(dwSize)) ) {
		dwr = GetPrivateProfileString( section, NULL, "", lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileString()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			for(i=n=0 ; !(lpBuf[i] == '\0' && lpBuf[i+1] == '\0') ; i++) {
				if ( lpBuf[i+1] == '\0' ) {
					n++;
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return n;
}

LibExport DWORD tiniNumKeyW( const wchar_t *inifile, const wchar_t *section )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	wchar_t *lpBuf = 0;

	if ( inifile == NULL || section == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = walloc(dwSize)) ) {
		dwr = GetPrivateProfileStringW( section, NULL, L"", lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileString()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			for(i=n=0 ; !(lpBuf[i] == L'\0' && lpBuf[i+1] == L'\0') ; i++) {
				if ( lpBuf[i+1] == L'\0' ) {
					n++;
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return n;
}

// init@C當ǂݍ(gIfree邱)
LibExport char *mtiniReadStringA( const char *inifile, const char *section, const char *key, const char *def )
{
	DWORD dwSize = 1024, dwr = 0;
	char *lpBuf = NULL;

	if ( section == NULL || key == NULL || def == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = zalloc(dwSize)) ) {
		dwr = GetPrivateProfileString( section, key, def, lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 1 ) { // GetPrivateProfileString()̎dlɂAI[o[̍ۂɂ dwSize-1 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł̂ŁATCY𒲐
			char *tmp = (char *)realloc(lpBuf, sizeof(char) * (lstrlen(lpBuf)+1));

			if ( tmp ) {
				lpBuf = tmp;
			}
			break;
		}
	}

	if ( lpBuf == NULL ) { // 擾ɎsĂꍇ
        lpBuf = _strdup( def );
	}

	return lpBuf;
}

LibExport wchar_t *mtiniReadStringW( const wchar_t *inifile, const wchar_t *section, const wchar_t *key, const wchar_t *def )
{
	DWORD dwSize = 1024, dwr = 0;
	wchar_t *lpBuf = NULL;

	if ( section == NULL || key == NULL || def == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = walloc(dwSize)) ) {
		dwr = GetPrivateProfileStringW( section, key, def, lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 1 ) { // GetPrivateProfileString()̎dlɂAI[o[̍ۂɂ dwSize-1 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł̂ŁATCY𒲐
			wchar_t *tmp = (wchar_t *)realloc(lpBuf, sizeof(wchar_t) * (lstrlenW(lpBuf)+1));

			if ( tmp ) {
				lpBuf = tmp;
			}
			break;
		}
	}

	if ( lpBuf == NULL ) { // 擾ɎsĂꍇ
        lpBuf = _wcsdup( def );
	}

	return lpBuf;
}

// init@CZNV(gIfree邱)
LibExport char *mtiniEnumSectionA( const char *inifile, DWORD num )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	char *lpBuf = NULL, *retp = NULL;

	while( NULL != (lpBuf = zalloc(dwSize)) ) {
		dwr = GetPrivateProfileSectionNames( lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileSectionNames()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			if ( num == 0 ) {
				retp = _strdup( lpBuf );
			}
			else {
				for(i=n=0 ; !(lpBuf[i] == '\0' && lpBuf[i+1] == '\0') ; i++) {
					if ( lpBuf[i+1] == '\0' ) {
						if ( ++n == num ) {
							retp = _strdup( &lpBuf[i+2] );
							break;
						}
					}
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return retp;
}

LibExport wchar_t *mtiniEnumSectionW( const wchar_t *inifile, DWORD num )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	wchar_t *lpBuf = NULL, *retp = NULL;

	while( NULL != (lpBuf = walloc(dwSize)) ) {
		dwr = GetPrivateProfileSectionNamesW( lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileSectionNames()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			if ( num == 0 ) {
				retp = _wcsdup( lpBuf );
			}
			else {
				for(i=n=0 ; !(lpBuf[i] == L'\0' && lpBuf[i+1] == L'\0') ; i++) {
					if ( lpBuf[i+1] == L'\0' ) {
						if ( ++n == num ) {
							retp = _wcsdup( &lpBuf[i+2] );
							break;
						}
					}
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return retp;
}

// init@C̃ZNVL[(gIfree邱)
LibExport char *mtiniEnumKeyA( const char *inifile, const char *section, DWORD num )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	char *lpBuf = NULL, *retp = NULL;

	if ( section == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = zalloc(dwSize)) ) {
		dwr = GetPrivateProfileString( section, NULL, "", lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileString()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			if ( num == 0 ) {
				retp = _strdup( lpBuf );
			}
			else {
				for(i=n=0 ; !(lpBuf[i] == '\0' && lpBuf[i+1] == '\0') ; i++) {
					if ( lpBuf[i+1] == '\0' ) {
						if ( ++n == num ) {
							retp = _strdup( &lpBuf[i+2] );
							break;
						}
					}
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return retp;
}

LibExport wchar_t *mtiniEnumKeyW( const wchar_t *inifile, const wchar_t *section, DWORD num )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	wchar_t *lpBuf = NULL, *retp = NULL;

	if ( section == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = walloc(dwSize)) ) {
		dwr = GetPrivateProfileStringW( section, NULL, L"", lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileString()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			// lpBuf̒JEg
			DWORD i;

			if ( num == 0 ) {
				retp = _wcsdup( lpBuf );
			}
			else {
				for(i=n=0 ; !(lpBuf[i] == L'\0' && lpBuf[i+1] == L'\0') ; i++) {
					if ( lpBuf[i+1] == L'\0' ) {
						if ( ++n == num ) {
							retp = _wcsdup( &lpBuf[i+2] );
							break;
						}
					}
				}
			}

			free( lpBuf ); lpBuf = NULL;
			break;
		}
	}

	return retp;
}

// nCu(ŏʃWXgL[)̖OAnCũnh֕ϊ
LibExport HKEY  tRegHiveKeyA(const char *hive)
{
	if ( hive ) {
		if (0 == _strcmpi(hive, "HKEY_CLASSES_ROOT") || 0 == _strcmpi(hive, "HKCR")) {
			return HKEY_CLASSES_ROOT;
		}
		else if (0 == _strcmpi(hive, "HKEY_CURRENT_USER") || 0 == _strcmpi(hive, "HKCU")) {
			return HKEY_CURRENT_USER;
		}
		else if (0 == _strcmpi(hive, "HKEY_LOCAL_MACHINE") || 0 == _strcmpi(hive, "HKLM")) {
			return HKEY_LOCAL_MACHINE;
		}
		else if (0 == _strcmpi(hive, "HKEY_USERS")) {
			return HKEY_USERS;
		}
		else if (0 == _strcmpi(hive, "HKEY_CURRENT_CONFIG") || 0 == _strcmpi(hive, "HKCC")) {
			return HKEY_CURRENT_CONFIG;
		}
		else if (0 == _strcmpi(hive, "HKEY_DYN_DATA") || 0 == _strcmpi(hive, "HKDD")) {
			return HKEY_DYN_DATA;
		}
		else if (0 == _strcmpi(hive, "HKEY_PERFORMANCE_DATA") || 0 == _strcmpi(hive, "HKPD")) {
			return HKEY_PERFORMANCE_DATA;
		}
		else if (0 == _strcmpi(hive, "HKEY_PERFORMANCE_TEXT") || 0 == _strcmpi(hive, "HKPT")) {
			return HKEY_PERFORMANCE_TEXT;
		}
		else if (0 == _strcmpi(hive, "HKEY_PERFORMANCE_NLSTEXT") || 0 == _strcmpi(hive, "HKPN")) {
			return HKEY_PERFORMANCE_NLSTEXT;
		}
	}

	return NULL;
}

LibExport HKEY  tRegHiveKeyW(const wchar_t *hive)
{
	if ( hive ) {
		if (0 == _wcsicmp(hive, L"HKEY_CLASSES_ROOT") || 0 == _wcsicmp(hive, L"HKCR")) {
			return HKEY_CLASSES_ROOT;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_CURRENT_USER") || 0 == _wcsicmp(hive, L"HKCU")) {
			return HKEY_CURRENT_USER;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_LOCAL_MACHINE") || 0 == _wcsicmp(hive, L"HKLM")) {
			return HKEY_LOCAL_MACHINE;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_USERS")) {
			return HKEY_USERS;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_CURRENT_CONFIG") || 0 == _wcsicmp(hive, L"HKCC")) {
			return HKEY_CURRENT_CONFIG;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_DYN_DATA") || 0 == _wcsicmp(hive, L"HKDD")) {
			return HKEY_DYN_DATA;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_PERFORMANCE_DATA") || 0 == _wcsicmp(hive, L"HKPD")) {
			return HKEY_PERFORMANCE_DATA;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_PERFORMANCE_TEXT") || 0 == _wcsicmp(hive, L"HKPT")) {
			return HKEY_PERFORMANCE_TEXT;
		}
		else if (0 == _wcsicmp(hive, L"HKEY_PERFORMANCE_NLSTEXT") || 0 == _wcsicmp(hive, L"HKPN")) {
			return HKEY_PERFORMANCE_NLSTEXT;
		}
	}

	return NULL;
}

// TuL[̍폜(̉ɂTuL[ׂč폜)
LibExport BOOL  tRegDeleteSubKeyA(HKEY hkey, const char *subkey)
{
	DWORD sk = 0, sklen = 0, i, buflen = 0;
	HKEY hsubkey;
	char **subkeys = 0, *subkeyname = 0;
	tRegLastError = ERROR_SUCCESS;

	if (ERROR_SUCCESS == (tRegLastError = RegOpenKeyEx(hkey, subkey, 0, KEY_ALL_ACCESS, &hsubkey))) {
		if (bDisableReflectionKey) tRegDisableReflectionKey(hkey);

		RegQueryInfoKey(hsubkey, NULL, NULL, NULL, &sk, &sklen, NULL, NULL, NULL, NULL, NULL, NULL);
		if ( sk > 0 ) { // TuL[ł΁A폜Ă
			subkeys = (char **)malloc( sk*sizeof(char *) );
			if ( subkeys ) {
				buflen = (sklen+1)*2;
				subkeyname = zalloc( buflen );
				if ( subkeyname ) {
					for(i=0 ; i<sk ; i++) {
						buflen = (sklen+1)*2;
						RegEnumKeyEx(hsubkey, i, subkeyname, &buflen, NULL, NULL, NULL, NULL);
						subkeys[i] = _strdup( subkeyname );
					}
					free( subkeyname );

					for(i=0 ; i<sk ; i++) {
						if ( subkeys[i] ) {
							tRegDeleteSubKey( hsubkey, subkeys[i] );
							free( subkeys[i] );
						}
					}
				}
				free( subkeys );
			}
		}
		RegCloseKey( hsubkey );
	}
	else {
		return FALSE;
	}

	return (tRegLastError = RegDeleteKeyA(hkey, subkey)) == ERROR_SUCCESS ? TRUE : FALSE ;
}

LibExport BOOL  tRegDeleteSubKeyW(HKEY hkey, const wchar_t *subkey)
{
	DWORD sk = 0, sklen = 0, i, buflen = 0;
	HKEY hsubkey;
	wchar_t **subkeys = 0, *subkeyname = 0;
	tRegLastError = ERROR_SUCCESS;

	if (ERROR_SUCCESS == (tRegLastError = RegOpenKeyExW(hkey, subkey, 0, KEY_ALL_ACCESS, &hsubkey))) {
		if (bDisableReflectionKey) tRegDisableReflectionKey(hkey);

		RegQueryInfoKeyW(hsubkey, NULL, NULL, NULL, &sk, &sklen, NULL, NULL, NULL, NULL, NULL, NULL);
		if ( sk > 0 ) { // TuL[ł΁A폜Ă
			subkeys = (wchar_t **)malloc( sk*sizeof(wchar_t *) );
			if ( subkeys ) {
				buflen = (sklen+1)*2;
				subkeyname = walloc( buflen );
				if ( subkeyname ) {
					for(i=0 ; i<sk ; i++) {
						buflen = (sklen+1)*2;
						RegEnumKeyExW(hsubkey, i, subkeyname, &buflen, NULL, NULL, NULL, NULL);
						subkeys[i] = _wcsdup( subkeyname );
					}
					free( subkeyname );

					for(i=0 ; i<sk ; i++) {
						if ( subkeys[i] ) {
							tRegDeleteSubKeyW( hsubkey, subkeys[i] );
							free( subkeys[i] );
						}
					}
				}
				free( subkeys );
			}
		}
		RegCloseKey( hsubkey );
	}
	else {
		return FALSE;
	}

	return (tRegLastError = RegDeleteKeyW(hkey, subkey)) == ERROR_SUCCESS ? TRUE : FALSE ;
}

// sWXgǂݍ
LibExport BOOL  tRegReadMultiStringDirectA(HKEY hKey, const char *entry, char *buf, LPDWORD psize)
{
	DWORD size = 0;
	DWORD type = 0;
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ RegReadMultiStringDirectA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in RegReadMultiStringDirect.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

	if ( psize == NULL || entry == NULL || buf == NULL ) {
        return FALSE;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hKey, entry, NULL, &type, NULL, &size))) {
		switch( type ) {
			case REG_SZ:
			case REG_EXPAND_SZ:
				if ( *psize > size/sizeof(char) ) {
                    ZeroMemory(buf, *psize);
					return (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hKey, entry, NULL, NULL, (LPBYTE)buf, psize))) ? TRUE : FALSE;
				}
				break;

			case REG_MULTI_SZ:
				if ( *psize >= size/sizeof(char) ) {
					return (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hKey, entry, NULL, NULL, (LPBYTE)buf, psize))) ? TRUE : FALSE;
				}
				break;
		}
	}
	return FALSE;
}

LibExport BOOL  tRegReadMultiStringDirectW(HKEY hKey, const wchar_t *entry, wchar_t *buf, LPDWORD psize)
{
	DWORD size = 0;
	DWORD type = 0;
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ RegReadMultiStringDirectW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in RegReadMultiStringDirectW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

	if ( psize == NULL || entry == NULL || buf == NULL ) {
        return FALSE;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hKey, entry, NULL, &type, NULL, &size))) {
		switch( type ) {
			case REG_SZ:
			case REG_EXPAND_SZ:
				if ( *psize > size/sizeof(wchar_t) ) {
                    ZeroMemory(buf, *psize);
					return (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hKey, entry, NULL, NULL, (LPBYTE)buf, psize))) ? TRUE : FALSE;
				}
				break;

			case REG_MULTI_SZ:
				if ( *psize >= size/sizeof(wchar_t) ) {
					return (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hKey, entry, NULL, NULL, (LPBYTE)buf, psize))) ? TRUE : FALSE;
				}
				break;
		}
	}
	return FALSE;
}

// sWXgǂݍ (Ƃfree邱)
LibExport char *mtRegReadMultiStringDirectA(HKEY hKey, const char *entry, LPDWORD psize)
{
	DWORD size = tRegValueSize(hKey, entry);
	char *buf = 0;

	if ( size == 0 || psize == NULL ) {
		return NULL;
	}
	buf = (char *)malloc( ++size );
	*psize = size;
	if ( buf ) {
		if ( TRUE == tRegReadMultiStringDirectA(hKey, entry, buf, psize) ) {
			return buf;
		}
		free( buf );
	}
	return NULL;
}

LibExport wchar_t *mtRegReadMultiStringDirectW(HKEY hKey, const wchar_t *entry, LPDWORD psize)
{
	DWORD size = tRegValueSizeW(hKey, entry);
	wchar_t *buf = 0;

	if ( size == 0 || psize == NULL ) {
		return NULL;
	}
	buf = walloc( ++size );
	*psize = size * sizeof(wchar_t);
	if ( buf ) {
		if ( TRUE == tRegReadMultiStringDirectW(hKey, entry, buf, psize) ) {
			return buf;
		}
		free( buf );
	}
	return NULL;
}

// sWXgǂݍ (Ƃdelete[]邱)
char* REGA::new_ReadMultiStringDirect(const char *entry, LPDWORD psize) const
{
	DWORD size = tRegValueSizeA(hkey, entry);
	char *buf = 0;

	if ( size == 0 || psize == NULL ) {
		return NULL;
	}
	++size;
	buf = new char [ size ];
	if ( buf ) {
		*psize = size;
		if ( TRUE == tRegReadMultiStringDirectA(hkey, entry, buf, psize) ) {
			return buf;
		}
		free(buf);
	}
	return NULL;
}

wchar_t* REGW::new_ReadMultiStringDirect(const wchar_t *entry, LPDWORD psize) const
{
	DWORD size = tRegValueSizeW(hkey, entry);
	wchar_t *buf = 0;

	if ( size == 0 || psize == NULL ) {
		return NULL;
	}
	++size;
	buf = new wchar_t [ size ];
	if ( buf ) {
		*psize = size * sizeof(wchar_t);
		if ( TRUE == tRegReadMultiStringDirectW(hkey, entry, buf, psize) ) {
			return buf;
		}
		free(buf);
	}
	return NULL;
}

// sWXg֏
LibExport BOOL  tRegWriteMultiStringDirectA(HKEY hKey, const char *entry, const char *buf, DWORD bufsize)
{
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ RegWriteMultiStringDirectA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in RegWriteMultiStringDirectA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

	return (ERROR_SUCCESS == (tRegLastError = RegSetValueEx(hKey, entry, NULL, REG_MULTI_SZ, (const BYTE *)buf, bufsize*sizeof(char))));
}

LibExport BOOL  tRegWriteMultiStringDirectW(HKEY hKey, const wchar_t *entry, const wchar_t *buf, DWORD bufsize)
{
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ RegWriteMultiStringDirectW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in RegWriteMultiStringDirectW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

	return (ERROR_SUCCESS == (tRegLastError = RegSetValueExW(hKey, entry, NULL, REG_MULTI_SZ, (const BYTE *)buf, bufsize*sizeof(wchar_t))));
}
/**/
// init@C̃ZNVۂƓǂݍ
LibExport BOOL tiniReadSectionA( const char *inifile, const char *section, char *buf, DWORD bufsize )
{
	DWORD n;

	if ( inifile == NULL || section == NULL || buf == NULL || bufsize == 0 ) {
		return FALSE;
	}

	n = GetPrivateProfileSection( section, buf, bufsize, inifile );
	if ( n == 0 || n == bufsize-2 ) {
        return FALSE;
	}
	else {
		return TRUE;
	}
}

LibExport BOOL tiniReadSectionW( const wchar_t *inifile, const wchar_t *section, wchar_t *buf, DWORD bufsize )
{
	DWORD n;

	if ( inifile == NULL || section == NULL || buf == NULL || bufsize == 0 ) {
		return FALSE;
	}

	n = GetPrivateProfileSectionW( section, buf, bufsize, inifile );
	if ( n == 0 || n == bufsize-2 ) {
        return FALSE;
	}
	else {
		return TRUE;
	}
}

// init@C̃ZNVۂƓǂݍ(gIfree邱)
LibExport char *mtiniReadSectionA( const char *inifile, const char *section )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	char *lpBuf = NULL, *retp = NULL;

	if ( inifile == NULL || section == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = zalloc(dwSize)) ) {
		dwr = GetPrivateProfileSection( section, lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileSection()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			n = 0;
			while( !(lpBuf[n] == 0 && lpBuf[n+1] == 0) ) {
				n++;
			}
			n += 2;

			retp = (char *)realloc(lpBuf, n*sizeof(char));
			if ( !retp ) {
				retp = lpBuf;
			}
			break;
		}
	}

	return retp;
}

LibExport wchar_t *mtiniReadSectionW( const wchar_t *inifile, const wchar_t *section )
{
	DWORD dwSize = 1024, dwr = 0, n = 0;
	wchar_t *lpBuf = NULL, *retp = NULL;

	if ( inifile == NULL || section == NULL ) {
		return NULL;
	}

	while( NULL != (lpBuf = walloc(dwSize)) ) {
		dwr = GetPrivateProfileSectionW( section, lpBuf, dwSize, inifile );
		if ( dwr == dwSize - 2 ) { // GetPrivateProfileSection()̎dlɂAI[o[̍ۂɂ dwSize-2 Ԃ
			// āATCY2{ɂăgC
			free( lpBuf );
			dwSize *= 2;
			if ( dwSize < dwr ) { // ʁAȂĂ܂I[o[t[
				lpBuf = NULL;
				break;
			}
		}
		else { // 擾ł
			n = 0;
			while( !(lpBuf[n] == 0 && lpBuf[n+1] == 0) ) {
				n++;
			}
			n += 2;

			retp = (wchar_t *)realloc(lpBuf, n*sizeof(wchar_t));
			if ( !retp ) {
				retp = lpBuf;
			}
			break;
		}
	}

	return retp;
}

// init@C̃ZNVۂƏ
LibExport BOOL tiniWriteSectionA( const char *inifile, const char *section, const char *buf )
{
	if ( inifile == NULL || section == NULL || buf == NULL ) {
		return FALSE;
	}

	return (WritePrivateProfileSection( section, buf, inifile ) != 0) ? TRUE : FALSE;
}

LibExport BOOL tiniWriteSectionW( const wchar_t *inifile, const wchar_t *section, const wchar_t *buf )
{
	if ( inifile == NULL || section == NULL || buf == NULL ) {
		return FALSE;
	}

	return (WritePrivateProfileSectionW( section, buf, inifile ) != 0) ? TRUE : FALSE;
}

// s(s\0ŋ؂I[\0\0)̍s𒲂ׂ
// mszsize ɂ msz ̃TCYw肷邪A 0 ɂƁAP \0\0 I[ƌȂ
LibExport DWORD numMultiStringA(const char *msz, DWORD mszsize)
{
	DWORD n = 0, i;

	if ( msz && mszsize != 1 ) {
		for(i=0 ; mszsize == 0 || i<mszsize ; i++) {
			if ( msz[i] == '\0' ) {
                n++;

				if ( mszsize == 0 ) {
					if ( msz[i+1] == '\0' ) {
						return n;
					}
				}
			}
		}
		n--;
	}

	return n;
}

LibExport DWORD numMultiStringW(const wchar_t *msz, DWORD mszsize)
{
	DWORD n = 0, i;

	if ( msz && mszsize != 1 ) {
		for(i=0 ; mszsize == 0 || i<mszsize ; i++) {
			if ( msz[i] == L'\0' ) {
                n++;

				if ( mszsize == 0 ) {
					if ( msz[i+1] == L'\0' ) {
						return n;
					}
				}
			}
		}
		n--;
	}

	return n;
}

// WXgGg̖OύX
LibExport BOOL  tRegRenValueA(HKEY hKey, const char *oldname, const char *newname)
{
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ RenValueA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in RenValueA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}

	if ( tRegCopyValueA(hKey, oldname, newname) ) {
		if ( ERROR_SUCCESS == (tRegLastError = RegDeleteValue(hKey, oldname))) {
			return TRUE;
		}
	}

	return FALSE;
}

LibExport BOOL  tRegRenValueW(HKEY hKey, const wchar_t *oldname, const wchar_t *newname)
{
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBoxW(NULL,modeJP?L"JĂȂL[Ώۂ RenValueW s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":L"An error has occurred in RenValueW.",L"Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}

	if ( tRegCopyValueW(hKey, oldname, newname) ) {
		if ( ERROR_SUCCESS == (tRegLastError = RegDeleteValueW(hKey, oldname))) {
			return TRUE;
		}
	}

	return FALSE;
}

// WXgGg̃Rs[
LibExport BOOL  tRegCopyValueA(HKEY hKey, const char *srcname, const char *destname)
{
	DWORD type = 0;
	DWORD size = 0;
	char *buf = 0;
	BOOL  rv = FALSE;
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ CopyValueA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in CopyValueA.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}

	if ( srcname == NULL || destname == NULL ) {
		return 0;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hKey,srcname,NULL,&type,NULL,&size))) {
		buf = zalloc(size);
		if ( buf ) {
			if (ERROR_SUCCESS == (tRegLastError = RegQueryValueEx(hKey,srcname,NULL,NULL,(LPBYTE)buf,&size))) {
				if ( ERROR_SUCCESS == (tRegLastError = RegSetValueEx(hKey, destname, NULL, type, (CONST BYTE *)buf, size))) {
                    rv = TRUE;
				}
			}
			free( buf );
		}
	}

	return rv;
}

LibExport BOOL  tRegCopyValueW(HKEY hKey, const wchar_t *srcname, const wchar_t *destname)
{
	DWORD type = 0;
	DWORD size = 0;
	char  *buf = 0;
	BOOL  rv = FALSE;
	tRegLastError = ERROR_SUCCESS;

	if (hKey == NULL) {
		MessageBox(NULL,modeJP?"JĂȂL[Ώۂ CopyValueA s悤Ƃ̂ŕی삵܂B\ñbZ[W\ꂽAݕҏWĂ/Ă_CAO̖OAbZ[W̓eƋɐmɍ҂܂ŕ񍐂ĉB":"An error has occurred in CopyValueW.","Registory Class",MB_OK | MB_ICONEXCLAMATION);
		return 0;
	}

	if ( srcname == NULL || destname == NULL ) {
		return 0;
	}

	if (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hKey,srcname,NULL,&type,NULL,&size))) {
		buf = zalloc(size);
		if ( buf ) {
			if (ERROR_SUCCESS == (tRegLastError = RegQueryValueExW(hKey,srcname,NULL,NULL,(LPBYTE)buf,&size))) {
				if ( ERROR_SUCCESS == (tRegLastError = RegSetValueExW(hKey, destname, NULL, type, (CONST BYTE *)buf, size))) {
                    rv = TRUE;
				}
			}
			free( buf );
		}
	}

	return rv;
}

// GetPrivateProfileString̎dlɂA "  ' ň͂܂ĂƁAꂪ菜Ă܂̂ŁA' ň͂ĂB
BOOL writePrivateProfileStringCTA( const char *lpAppName, const char *lpKeyName, const char *lpString, const char *lpFileName )
{
	if ( lpString[0] == '"' || lpString[0] == '\'' ) {
		char *lpString2 = zalloc(lstrlen(lpString)+3);
		BOOL bRes = FALSE;

		if ( lpString2 ) {
			lpString2[0] = '\'';
			lstrcat( lpString2, lpString );
			lstrcat( lpString2, "'" );

			bRes = WritePrivateProfileString( lpAppName, lpKeyName, lpString2, lpFileName );
			free( lpString2 );
		}

		return bRes;
	}
	else {
		return WritePrivateProfileString( lpAppName, lpKeyName, lpString, lpFileName );
	}
}

BOOL writePrivateProfileStringCTW( const wchar_t *lpAppName, const wchar_t *lpKeyName, const wchar_t *lpString, const wchar_t *lpFileName )
{
	if ( lpString[0] == L'"' || lpString[0] == L'\'' ) {
		wchar_t *lpString2 = walloc(lstrlenW(lpString)+3);
		BOOL bRes = FALSE;

		if ( lpString2 ) {
			lpString2[0] = L'\'';
			lstrcatW( lpString2, lpString );
			lstrcatW( lpString2, L"'" );

			bRes = WritePrivateProfileStringW( lpAppName, lpKeyName, lpString2, lpFileName );
			free( lpString2 );
		}

		return bRes;
	}
	else {
		return WritePrivateProfileStringW( lpAppName, lpKeyName, lpString, lpFileName );
	}
}

static const BYTE unicode_ini_default[] = {0xFF,0xFE,0x0D,0x00,0x0A,0x00}; // "<BOM><cr><lf>"

LibExport BOOL CreateUnicodeIniA(const char *inifile)
{
	// init@C݂ĂȂꍇAUnicodeinis쐬
	FILE *fp;
	
	if (0 == fopen_s(&fp, inifile, "rb")) {
		fclose(fp); // init@C݂
		return TRUE;
	}
	else {
		if (0 == fopen_s(&fp, inifile, "wb")) {
			fwrite(unicode_ini_default, sizeof(unicode_ini_default), 1, fp);
			fclose(fp);
			return TRUE;
		}
		return FALSE;
	}
}

LibExport BOOL CreateUnicodeIniW(const wchar_t *inifile)
{
	// init@C݂ĂȂꍇAUnicodeinis쐬
	FILE *fp;
	
	
	if (0 == _wfopen_s(&fp, inifile, L"rb")) {
		fclose(fp); // init@C݂
		return TRUE;
	}
	else {
		if (0 == _wfopen_s(&fp, inifile, L"wb")) {
			fwrite(unicode_ini_default, sizeof(unicode_ini_default), 1, fp);
			fclose(fp);
			return TRUE;
		}
		return FALSE;
	}
}

// Iɂ͎gȂȂ邩Ȃ֐ NtRenameKey (Ntdll.dll) AƂ肠Ăяo߂̊֐
LibExport LONG tRegRenameKeyW( HKEY hKey, const wchar_t *lpWSubKeyName, const wchar_t *lpWNewName )
{
	typedef LONG (WINAPI *LPFN_REGRENAMEKEY) (HKEY, LPCWSTR, LPCWSTR);
	LPFN_REGRENAMEKEY fnRegRenameKey =
		(LPFN_REGRENAMEKEY)GetProcAddress(GetModuleHandle("advapi32.dll"), "RegRenameKey");

	if (fnRegRenameKey) {
		return fnRegRenameKey(hKey, lpWSubKeyName, lpWNewName);
	}

	return ERROR_BAD_ENVIRONMENT;
}

LibExport LONG tRegRenameKeyA( HKEY hKey, const char *lpSubKeyName, const char *lpNewName )
{
	int iLength;
	LPWSTR lpWSubKeyName, lpWNewName;
	LONG lStatus = ERROR_BAD_ENVIRONMENT;
	
	// lpSubKeyNameiύXOTuL[́jUnicodeϊ
	iLength = MultiByteToWideChar(CP_ACP, 0, lpSubKeyName, -1, NULL, 0) + 1;
	lpWSubKeyName = (LPWSTR)calloc(iLength, sizeof(WCHAR));
	if (lpWSubKeyName) {
		if (0 < MultiByteToWideChar(CP_ACP, 0, lpSubKeyName, -1, lpWSubKeyName, iLength)) {

			// lpNewNameiύXTuL[́jUnicodeϊ
			iLength = MultiByteToWideChar(CP_ACP, 0, lpNewName, -1, NULL, 0) + 1;
			lpWNewName = (LPWSTR)calloc(iLength, sizeof(WCHAR));
			if (lpWNewName) {
				if (0 < MultiByteToWideChar(CP_ACP, 0, lpNewName, -1, lpWNewName, iLength)) {
					lStatus = tRegRenameKeyW(hKey, lpWSubKeyName, lpWNewName);
				}
				free(lpWNewName);
			}
			else {
				lStatus = ERROR_NOT_ENOUGH_MEMORY;
			}
		}
		free(lpWSubKeyName);
	}
	else {
		lStatus = ERROR_NOT_ENOUGH_MEMORY;
	}

	return lStatus;
}

