#include "stdafx.h"
#include "Rnsf7.h"
#include "helpdlg.h"
#include "opendlg.h"
#include "refresh.h"
#include "resource.h"
#include "commfunc.h"

#define ADDSTRLEN	20480

HWND   hHelpWindow;
static char *rtf, *hlpwndtitle;
static size_t rtf_len, rtf_size;
static BOOL lastcall = 0; // OɌĂ΂ꂽ̂ helpdoc_section(0)Ahelpdoc_text(1)B

static struct DEFTOOLTIP helpfindtooltips[] = {
	{IDC_CHECK_GYAKU, "Ɍ܂B`FbNȂƁAɌ܂"},
	{IDC_EDIT1, "͂܂"}, 
	{IDC_CHECK_CASESENSITIVE, "pAt@xbg̑啶EʂɌ܂"},
	{IDOK,      "ɓ͂ꂽŌJn܂"},
	{IDCANCEL,  "JnɁÃ_CAO܂"},
	{0,0}};

// *rtfƁA̕ϐ
static void rtf_clear(void)
{
	safefree(rtf);
	rtf_len = rtf_size = 0;
}

// *rtfɕ𑫂֐iǉ镶̒킩Ăꍇj
static BOOL rtf_addstr2(const char *str, size_t addstrlen)
{
	if ( str ) {
		if ( rtf ) {
			size_t newstrlen = ((rtf_len + addstrlen) / ADDSTRLEN + 1) * ADDSTRLEN;

			if ( newstrlen > rtf_size ) {
				char *tmp = (char *)realloc(rtf, newstrlen);
				if ( tmp ) {
					rtf = tmp;
					rtf_size = newstrlen;
				}
				else {
					return FALSE;
				}
			}
			memcpy(rtf+rtf_len, str, addstrlen);
			rtf[rtf_len += addstrlen] = 0;
			return TRUE;
		}
		else {
			rtf_size = (addstrlen / ADDSTRLEN + 1) * ADDSTRLEN;

			rtf = (char *)malloc(rtf_size);
			if ( rtf ) {
				memcpy(rtf, str, addstrlen);
				rtf[rtf_len = addstrlen] = 0;
				return TRUE;
			}
			else {
				rtf_size = 0;
				return FALSE;
			}
		}
	}
	else {
		return FALSE;
	}
}

// *rtfɕ𑫂֐
static BOOL rtf_addstr(const char *str)
{
	if ( str ) {
		return rtf_addstr2(str, strlen(str));
	}
	else {
		return FALSE;
	}
}

// wveLXg̍쐬Jn
EXTERN BOOL helpdoc_start( const char *title, BYTE mode )
{
	lastcall = 0;

	rtf_clear();			 // łɃobt@mۂĂ
	safefree( hlpwndtitle ); // wvEBhẼ^Cgo[
	                         // hlpwndtitle = NULL ƃ^Cgo[ɂ́uwvvƂ\

	if ( title ) {
		hlpwndtitle = zalloc( strlen(title) + 9 );
		if ( hlpwndtitle ) {
			lstrcpy( hlpwndtitle, title );
			if ( mode == 0 ) {
				lstrcat( hlpwndtitle, "̃wv" );
			}
		}
	}

	// b`eLXg ver.1 Jn
	return rtf_addstr( "{\\rtf1\\ansi\\ansicpg932\\deff0\\deflang1033\\deflangfe1041\\fs20{\\colortbl;\\red0\\green0\\blue0;\\red0\\green0\\blue255;\\red0\\green255\\blue255;\\red0\\green255\\blue0;\\red255\\green0\\blue255;\\red255\\green0\\blue0;\\red255\\green255\\blue0;\\red255\\green255\\blue255;\\red0\\green0\\blue127;\\red0\\green127\\blue127;\\red0\\green127\\blue0;\\red127\\green0\\blue127;\\red127\\green0\\blue0;\\red127\\green127\\blue0;\\red127\\green127\\blue127;\\red192\\green192\\blue192;}" );
}

// wveLXgɑǉ(&Ɣr. \n, \t  \\par, \\tab ɕϊ.)
EXTERN BOOL helpdoc_section( const char *str, BYTE mode )
{
	int  i, j;
	char *str2;
	BOOL rv = TRUE, sw;

	if ( rtf == NULL ) { // obt@mۂĂȂAmۂ
		if ( FALSE == helpdoc_start( NULL, mode ) ) {
			return FALSE;
		}
	}

	// ŕǉ (OɌĂ΂ꂽ̂text̕Ȃs)
	if (!rtf_addstr( mode==1?(lastcall!=0?"\\par\\par{\\b\\fs24\\cf9 ":"{\\b\\fs24\\cf9 "):
	                         (lastcall!=0?"\\par\\par{\\b\\fs22\\cf9 ":"{\\b\\fs22\\cf9 ") )) {
		return FALSE;
	}

	if ( mode == 0 ) {
		// ANZ[V\&܂܂ĂArŁǍ1ɉ
		// ASHIFT JIS̑2oCgڂꍇ͔rȂ
		// &2ꍇ2߂͍̂폜Ȃ
		sw = 0; // &2Ăꍇ2߂&͍폜Ȃ߂̃tO
		str2 = (char *)malloc( strlen(str)*6+1 );
		if ( str2 ) {
			for(i=j=0 ; str[i] ; i++) {
				if ( str[i] == '&' ) {
					if ( i > 0 && (sw == 1 || isKanji1( str, i-1 )) ) { // O&łȂA̑PoCgڂłȂ
						str2[j++] = str[i];
						if ( sw == 1 ) { // O&ꍇ́A邪Ả[h
							str2[j++] = '}';
							sw = 0;
						}
					}
					else {
						str2[j++] = '{';
						str2[j++] = '\\';
						str2[j++] = 'u';
						str2[j++] = 'l';
						str2[j++] = ' ';
						sw = 1;
					}
				}
				else {
					str2[j++] = str[i];
					if ( sw == 1 ) { // O&ꍇ́A邪Ả[h
						str2[j++] = '}';
						sw = 0;
					}
				}
			}
			str2[j] = 0;
			// ̒ǉ helpdoc_text ɔC( \\par, \\tab ̏̂ )
			lastcall = 1;
			rv = helpdoc_text( str2, mode );
			lastcall = 0;
			safefree( str2 );
		}
	}
	else {
		lastcall = 1;
		rv = helpdoc_text( str, mode );
		lastcall = 0;
	}

	// \\b` ̕JbR
	
	if ( !rtf_addstr2("}", 1) ) {
		return FALSE;
	}

	return rv;
}

// wveLXgɕǉ(\n, \t  \\par, \\tab ɕϊ.)
EXTERN BOOL helpdoc_text( const char *str, BYTE mode )
{
	UINT lastr = 0; // rtf ɒǉׂ
	UINT i = 0;     // JE^
	char *astr;		// rtf ɒǉׂwƂɂȂ|C^

	if ( rtf == NULL ) { // obt@mۂĂȂAmۂ
		if ( FALSE == helpdoc_start( NULL, mode ) ) {
			return FALSE;
		}
	}

	// rtfɒǉׂJEg
	if ( lastcall != 1 ) { // OɌĂ΂ꂽ̂section̕Ȃs(\\par )
		lastr = 6; // \0Ă
	}
	else {
		lastr = 1; // \0𐔂Ă
	}

	for(i=0 ; str[i] ; i++) {
		switch( str[i] ) {
			case '\n': // \n\\par ɒu
			case '\t': // \t\\tab ɒu
				lastr += 5;
				break;

			case '{': // {  \\{ ɒu邩Ȃ
			case '}': // }  \\} ɒu邩Ȃ
			case '\\': // \\  \\\\ ɒu邩Ȃ
				lastr += 2;

			default:  // ʏ̕
				lastr++;
		}
	}
	// Ōɉst
	lastr += 5;

	// ǉׂ́AƂ lastr ł邱Ƃ킩̂ł̃̕mۂ
	astr = zalloc( lastr );
	if ( astr == NULL ) {
		return FALSE;
	}

	// rtfɒǉׂĂ
	if ( lastcall != 1 ) { // OɌĂ΂ꂽ̂section̕Ȃs(\\par )
		lstrcat(astr, "\\par ");
	}

	for(i=0 ; str[i] ; i++) {
		switch( str[i] ) {
			case '\n': // \n\\par ɒu
				lstrcat(astr, "\\par ");
				break;

			case '\t': // \t\\tab ɒu
				lstrcat(astr, "\\tab ");
				break;

			default:  // ʏ̕
				if ( mode != 0 || ISKANJI1M(str[i]) ) { // ̑1oCg߂A̎ { } \ ̂ꂩAO \ 
														// mode != 0 ̏ꍇ́AƂ͊֌WȂ
					UINT len = lstrlen(astr);

					if ( mode == 0 ) { // mode == 0 ̏ꍇ́Ȃ2oCgڂ̔ɂȂ
						astr[len++] = str[i++];
					}

					if ( str[i] == 0 )
						;
					else if ( str[i] == '{' || str[i] == '}' || str[i] == '\\' ) {
						astr[len++] = '\\';
						astr[len] = str[i];
					}
					else {
						astr[len] = str[i];
					}
					break;
				}
				astr[ (UINT)lstrlen(astr) ] = str[i];
				break;				
		}
	}
	// Ōɉst
	lstrcat(astr, "\\par ");

	// ŌɈCɒǉ
	if ( !rtf_addstr(astr) ) {
		safefree(astr);
		return FALSE;
	}
	safefree(astr);

	lastcall = 1;
	return TRUE;
}

// wveLXgւ̕ǉI
EXTERN BOOL helpdoc_end( void )
{
	if ( rtf == NULL ) { // obt@mۂĂȂAmۂ
		if ( FALSE == helpdoc_start( NULL, 0 ) ) {
			return FALSE;
		}
	}

	// \\rtf1 ̕JbR
	if ( rtf_addstr2("}", 1) ) {
		return TRUE;
	}
	else {
		return FALSE;
	}
}

static WNDPROC re_OldProc;

// RichEdit̃EBhEvV[W(TuNX)
EXTERN LRESULT CALLBACK re_NewProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch( message ) {
		case WM_KEYDOWN:
			switch( wParam ) {
				case VK_ESCAPE: // Î߂ [Esc] 󂯎̂
					DestroyWindow( GetParent(hWnd) );
					return 0; // ftHg̃vV[WĂ΂ɂ̂܂܏I

				case VK_F3: // ̂߂ [F3] 󂯎̂
					SendMessage(GetParent(hWnd), WM_COMMAND, (WPARAM)MAKEWPARAM(IDM_FINDNEXT, 0), 0);
					return 0; // ftHg̃vV[WĂ΂ɂ̂܂܏I
			}
			break;

		case WM_CHAR: // L[͎󂯎
			switch( wParam ) {
				case CTRL_F: // 
					SendMessage(GetParent(hWnd), WM_COMMAND, MAKEWPARAM(IDM_FIND, 0), 0);
					return 0; // ftHg̃vV[WĂ΂ɂ̂܂܏I

				case CTRL_S: // Z[uit@C֕ۑj
					SendMessage(GetParent(hWnd), WM_COMMAND, MAKEWPARAM(IDM_HELPSAVEFILE, 0), 0);
					return 0; // ftHg̃vV[WĂ΂ɂ̂܂܏I

				case CTRL_W: // 
					SendMessage(GetParent(hWnd), WM_COMMAND, MAKEWPARAM(IDM_CLOSE, 0), 0);
					return 0; // ftHg̃vV[WĂ΂ɂ̂܂܏I
			}
			break;

		// VXej[EBhẼj[L[{[h爵߂̎d|
		case WM_KEYUP:
		case WM_SYSKEYDOWN:
		case WM_SYSCHAR:
		//case WM_SYSCOMMAND:	// WM_SYSCOMMAND ܂Ŏ~߂Ă܂ƁAXN[o[̍NbNn삪ׂĖɂȂĂ܂lqB
		case WM_SYSKEYUP:
			return SendMessage(GetParent(hWnd), message, wParam, lParam);
	}

	// ftHg̃vV[WR[
	return CallWindowProc(re_OldProc, hWnd, message, wParam, lParam);
}

// wvJ
static BYTE helpdoc_open_mode = 0;
EXTERN HWND helpdoc_open( HWND hParent, BYTE mode )
{
	if ( hHelpWindow ) { // łɃwvEBhEJĂAȂ
		DestroyWindow( hHelpWindow );
	}

	helpdoc_open_mode = mode;
	hHelpWindow = CreateWindow( "helpdlg_rnsf7", hlpwndtitle?hlpwndtitle:"wv",  WS_CAPTION | WS_POPUPWINDOW | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
		                        (GetSystemMetrics(SM_CXFULLSCREEN)-635)/2, 32, 630, GetSystemMetrics(SM_CYFULLSCREEN)-64, hParent, NULL, hInst, NULL);

	if ( hHelpWindow == NULL ) {
		MessageBox( hParent, "VXeG[ɂAr[EBhEJ܂B", hlpwndtitle?hlpwndtitle:"wv", MB_OK | MB_ICONSTOP );
		return NULL;
	}

	ShowWindow(hHelpWindow, SW_SHOWNORMAL);
	UpdateWindow( hHelpWindow );

	return hHelpWindow;
}

static size_t byteread = 0; // EditStreamCallback ͉oCg܂œǂ񂾂
static DWORD CALLBACK EditStreamCallback(DWORD, LPBYTE pbBuf, LONG cb, LONG *pcb)
{
	char *rtfbuf = rtf + byteread;
	size_t len;

	len = rtf_len - byteread;

	if ( (size_t)cb < len ) {
		len = (size_t)cb;
	}

	*pcb = (LONG)len;
	byteread += len;

	memcpy( pbBuf, rtfbuf, len );

	return 0;
}

// _CAÕAJ[Ɋւ
const DLGITEM dlgitems[] = {
	{IDC_EDIT1,					ANCHOR_TOPLEFTRIGHT},
	{IDOK,						ANCHOR_TOPRIGHT},
	{IDCANCEL,					ANCHOR_TOPRIGHT},
	{0,0}
};

// _CAOvV[W
static char **findbuf, *checkbox, *checkboxtip;
static BOOL *hf_up, *hf_ncs;
static LRESULT CALLBACK findProc( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	static ComboboxQueue *cbq;
	static SIZEDLG *sizedlg;

	switch (message) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// if ( rnsf7RegRead("NoDefFont", 0) == 0 ) {
			// 	SetChildWindowFont( hDlg );
			// }
			helpfindtooltips[0].tip = checkboxtip?checkboxtip:"";
			makeToolTip(hDlg, helpfindtooltips);
			if ( *findbuf ) { // ̏ݒ
                SetDlgItemText( hDlg, IDC_EDIT1, *findbuf );
				if ( *findbuf[0] ) { // 1ȏ゠[Jn]Lɂ
                    EnableWindow( GetDlgItem(hDlg, IDOK), TRUE );
				}
			}
			if ( checkbox ) {
				ShowWindow( GetDlgItem(hDlg, IDC_CHECK_GYAKU), SW_SHOW );
				SetDlgItemText(hDlg, IDC_CHECK_GYAKU, checkbox);
				if ( *hf_up ) { // ֌
					SendDlgItemMessage(hDlg, IDC_CHECK_GYAKU, BM_SETCHECK, BST_CHECKED, 0);
				}
			}
			if ( *hf_ncs ) { // case-sensitivełȂ/̑̃`FbN
				SendDlgItemMessage(hDlg, IDC_CHECK_CASESENSITIVE, BM_SETCHECK, BST_CHECKED, 0);
			}

			// _CAOACRݒ
			SendMessage( hDlg, WM_SETICON, ICON_SMALL, (LPARAM)LoadIcon(hInst, (LPCSTR)IDI_FILE_BROWSE) );

			// R{{bNX̃Xg
			cbq = new ComboboxQueue();
			cbq->Init(hDlg, IDC_EDIT1, 16, HKEY_CURRENT_USER, RNSF7REGKEY, "scriptsearch_combo");

			// _CAÕRg[̃AJ[o^
			sizedlg = new SIZEDLG(hDlg, dlgitems);
			sizedlg->SetMinMaxInfo(sizedlg->GetDefWidth(), sizedlg->GetDefHeight(), -1, sizedlg->GetDefHeight());

			return TRUE;

		case WM_DROPFILES: // ҏW{bNXt@Chbvꂽ
			{
				int n; // hbvꂽt@C̐
				int i; // JE^
				int len; // ҏW{bNXɂłɑ݂镶̃oCg
				char fname[MAX_PATH*2];
				char *buf;

				n = DragQueryFile((HDROP)wParam, (UINT)-1, NULL, 0);
				for(i=0 ; i<n ; i++) {
					if (_countof(fname) > DragQueryFile((HDROP)wParam, i, fname, _countof(fname))) {
                        len = GetWindowTextLength( GetDlgItem(hDlg, IDC_EDIT1) );
						if ( len > 0 ) { // łɕ񂪓Ăꍇ́AɃXy[XĂǉ
							buf = (char *)malloc( len + lstrlen(fname) + 2 );
							if ( buf ) {
								GetDlgItemText( hDlg, IDC_EDIT1, buf, len+1 );
								lstrcat(buf, " ");
								lstrcat(buf, fname);
								SetDlgItemText(hDlg, IDC_EDIT1, buf);
								safefree( buf );
							}
						}
						else { // ܂񂪓ĂȂꍇ́Â܂ܐݒ
                            SetDlgItemText(hDlg, IDC_EDIT1, fname);
						}
					}
				}
			}
			break;

		case WM_DESTROY:
			// TCŶ߂̏j
			delete sizedlg;
			sizedlg = NULL;

			// R{{bNX̏j
			delete cbq;
			cbq = NULL;

			return TRUE;

		case WM_GETMINMAXINFO:
			// _CAO̍ŏTCY߂
			sizedlg->GetMinMaxInfo(lParam);
			return TRUE;

		case WM_SIZE:
			// TCY
			sizedlg->Resize(1);
			return TRUE;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					safefree( *findbuf );
					{
						int len = GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT1)) + 1;
						*findbuf = zalloc( len );
						if ( *findbuf ) {
							GetDlgItemText( hDlg, IDC_EDIT1, *findbuf, len );
							*hf_up = (BST_CHECKED == SendDlgItemMessage(hDlg, IDC_CHECK_GYAKU, BM_GETCHECK, 0, 0))?1:0;
							*hf_ncs = (BST_CHECKED == SendDlgItemMessage(hDlg, IDC_CHECK_CASESENSITIVE, BM_GETCHECK, 0, 0))?1:0;

							// R{{bNX֓o^
							cbq->Add(*findbuf);

							EndDialog(hDlg, 1);
							return TRUE;
						}
					}
                    MessageBox( hDlg, "܂B", "", MB_OK | MB_ICONSTOP );					
					// ̂܂܉
				case IDCANCEL:
					EndDialog(hDlg, 0);
					return TRUE;

				case IDC_EDIT1:
					if (HIWORD(wParam) == CBN_EDITCHANGE) {
						EnableWindow(GetDlgItem(hDlg,IDOK),(GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT1)))?TRUE:FALSE);
					}
					else if (HIWORD(wParam) == CBN_SELCHANGE) {
						EnableWindow(GetDlgItem(hDlg,IDOK), TRUE);
					}
					return TRUE;
			}
			break;
	}
	return FALSE;
}

EXTERN int findDialog( HWND hWnd, char **findbuf_l, BOOL *hf_up_l, BOOL *hf_ncs_l, char *checkbox_l, char *checkboxtip_l )
{
	findbuf = findbuf_l;
	hf_up = hf_up_l;
	hf_ncs = hf_ncs_l;
	checkbox = checkbox_l;
	checkboxtip = checkboxtip_l;
	return (int)DialogBox(hInst, (LPCTSTR)IDD_HELPFIND, hWnd, (DLGPROC)findProc);
}

EXTERN LRESULT CALLBACK HlpProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static HWND hRichEdit;
	static HMODULE hLibRichEdit;
	static HMENU hContextHelpMenu;
	static char *findbuf;
	static BOOL hf_up, hf_ncs;
	static HFONT hFont;
	BOOL   findflag = 0;

	switch (message) {
		case WM_CREATE:
			{
				RECT rc;

				GetClientRect( hWnd, &rc );

				// b`GfBbgRg[̐
				hLibRichEdit = LoadLibrary_System32( "RICHED20.DLL" );
				hRichEdit = CreateWindowEx( WS_EX_CLIENTEDGE, RICHEDIT_CLASS, "Dynamic Help for Rnsf7", WS_TABSTOP | WS_CHILD | WS_VISIBLE | WS_BORDER | ES_NOIME | ES_LEFT | ES_MULTILINE | ES_READONLY | WS_VSCROLL | ES_NOHIDESEL | (helpdoc_open_mode==1?WS_HSCROLL:0),
					                        rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, hWnd, (HMENU)IDC_RICHEDIT, hInst, NULL );
				if ( !hRichEdit ) {
					DestroyWindow( hWnd );
				}
				else {
					//URLo@\gݍ
					SendMessage(hRichEdit, EM_AUTOURLDETECT, (WPARAM)TRUE, 0);

					// b`GfBbg̃Cxg}XNݒ
					LRESULT dwEvent = SendMessage(hRichEdit, EM_GETEVENTMASK, 0, 0);
					dwEvent |= ENM_MOUSEEVENTS | ENM_SELCHANGE | ENM_LINK;
					SendMessage(hRichEdit, EM_SETEVENTMASK, 0, (LPARAM)dwEvent);

					// W̃tHgݒ
					if ( helpdoc_open_mode == 1 ) {
						hFont = CreateFont(16,0,0,0,FW_MEDIUM,0,0,0,SHIFTJIS_CHARSET,OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,FIXED_PITCH | FF_DONTCARE, "lr SVbN");
					}
					else {
						hFont = CreateFont(18,0,0,0,FW_MEDIUM,0,0,0,SHIFTJIS_CHARSET,OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,VARIABLE_PITCH | FF_DONTCARE, "lr oSVbN");
					}
					SendMessage( hRichEdit, WM_SETFONT, (WPARAM)hFont, 0 );
					if ( rtf ) {
						EDITSTREAM eds;
						eds.dwCookie = 0;
						eds.dwError = 0;
						eds.pfnCallback = (EDITSTREAMCALLBACK)EditStreamCallback;

						// b`GfBbg̃TCY 64,000 K؂ȃTCY֕ύX
						Edit_LimitText(hRichEdit, lstrlen(rtf)+16);

						// b`GfBbg rtf ̓e^
						byteread = 0;
						SendMessage( hRichEdit, EM_STREAMIN, SF_RTF, (LPARAM)&eds);
					}

					re_OldProc = (WNDPROC)GetWindowLongPtr( hRichEdit, GWLP_WNDPROC );
					SetWindowLongPtr( hRichEdit, GWLP_WNDPROC, (LONG_PTR)re_NewProc );

					SetFocus( hRichEdit );
				}


				if ( helpdoc_open_mode == 0 ) { // \[Xr[[hł̓t@C̕ۑB
					EnableMenuItem(GetSubMenu(GetMenu(hWnd),0), IDM_HELPSAVEFILE, MF_BYCOMMAND | MF_ENABLED);
				}

				// ReLXgj[̃[h
				hContextHelpMenu = LoadMenu(hInst,(LPSTR)IDR_CONTEXT_MENUHELP);
			}
			break;

		case WM_NOTIFY:
			if (wParam == (WPARAM)IDC_RICHEDIT) { // b`GfBbg̒ʒmbZ[W
				LPNMHDR lpN = (LPNMHDR)lParam;
				ENLINK *penlk;
				char szURL[2048]; // URLő咷2048܂ŁBȏ͖ƂB

				switch (lpN->code) { // URLIȕNbNꍇ̏
					case EN_LINK:
						penlk = (ENLINK *)lParam;
						if (penlk->msg == WM_LBUTTONDOWN) {
							// 񂪒疳
							if (penlk->chrg.cpMax != -1 && penlk->chrg.cpMax - penlk->chrg.cpMin < _countof(szURL)) {
								SendMessage(hRichEdit, EM_EXSETSEL, 0, (LPARAM)(&(penlk->chrg)));
								if (0 < SendMessage(hRichEdit, EM_GETSELTEXT, 0, (LPARAM)szURL)) {   // 擾
									ShellExecute(hWnd, "open", szURL, NULL, NULL, SW_SHOWNORMAL); // ftHguEǓĂяo
								}
							}
						}
						break;
				}
			}
			break;

		case WM_SIZE: // EBhẼTCYύX
			{
				RECT rc;

				GetClientRect( hWnd, &rc );
				MoveWindow( hRichEdit, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, TRUE );
			}
			break;

		case WM_DESTROY:
			// e
			if ( hRichEdit ) {
				SetWindowLongPtr( hRichEdit, GWLP_WNDPROC, (LONG_PTR)re_OldProc ); // TuNX
				DestroyWindow( hRichEdit );	// EBhE̔j
				hRichEdit = NULL;
			}
			if ( hLibRichEdit ) {
				FreeLibrary( hLibRichEdit );
				hLibRichEdit = NULL;
			}
			if ( hContextHelpMenu ) {
				DestroyMenu( hContextHelpMenu );
				hContextHelpMenu = NULL;
			}
			if ( hFont ) {
				DeleteObject( hFont );
				hFont = NULL;
			}
			hHelpWindow = NULL;
			break;

		case WM_CONTEXTMENU:
			if ( (HWND)wParam == hRichEdit ) {
				POINT pt;
				HMENU hMenu = GetSubMenu(hContextHelpMenu, 0);

				if ( hMenu ) {
					GetCursorPos(&pt);
	
					// j[\
					TrackPopupMenuEx(hMenu, 0, pt.x, pt.y, hWnd, NULL);
				}
			}
			else {
				// VXej[}EX爵߂̎d|
				return DefWindowProc( hWnd, message, wParam, lParam );
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDM_CLOSE: // 
					DestroyWindow( hWnd );
					break;

				case IDM_COPY: // Rs[iL[{[hCtrl+CƂG~[gj
					SetFocus( hRichEdit );
					Sleep(100);	// ȂƂȂԂu
					keybd_event( VK_LCONTROL, 0, 0, 0 );
					keybd_event( 'C',	  0, 0, 0 );
					keybd_event( 'C',	  0, KEYEVENTF_KEYUP, 0 );
					keybd_event( VK_LCONTROL, 0, KEYEVENTF_KEYUP, 0 );
					break;

				case IDM_ALLSELECT: // ׂđI
					SendMessage( hRichEdit, EM_SETSEL, (WPARAM)0, (LPARAM)-1 );  
					break;

				case IDM_HELPSAVEFILE: // t@C֕ۑ
					if ( rtf && helpdoc_open_mode == 0 ) {
						char fname[MAX_PATH*2] = "";
						HANDLE hFile;	// t@Cnh
						DWORD  wtn;

						if ( saveDialog( hWnd, "b`eLXgt@C(*.rtf)\0*.rtf\0ׂẴt@C(*.*)\0*.*\0", fname, _countof(fname), "wvt@C֕ۑ", "rtf" ) ) {
							hFile = CreateFile(fname, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
							if ( hFile == INVALID_HANDLE_VALUE ) {
								MessageBox( hWnd, "w肳ꂽt@CJ܂B", "wvt@C֕ۑ", MB_OK | MB_ICONSTOP );
							}
							else {
								if ( WriteFile( hFile, rtf, lstrlen(rtf), &wtn, NULL ) ) {
									MessageBox( hWnd, "wvt@C֕ۑ܂B", "wvt@C֕ۑ", MB_OK | MB_ICONINFORMATION );
								}
								else {
									MessageBox( hWnd, "w肳ꂽt@C֏߂܂łB", "wvt@C֕ۑ", MB_OK | MB_ICONSTOP );
								}
								CloseHandle( hFile );
							}
						}
					}
					break;

				case IDM_FINDNEXT: // 
					if ( findbuf ) {
						// ͂̕XLbv邽߂̃tOݒ
						findflag = 1;
					}
					// A܂x͂ƂȂ΁AV͂
					// ̂܂܉
				case IDM_FIND: // 
					hf_ncs = rnsf7RegRead( "hf_ncsh", 0 );
					while(1) {
						if ( findflag || findDialog(hWnd, &findbuf, &hf_up, &hf_ncs, NULL, NULL) ) {
							FINDTEXT ft;
							int pos;

							if ( findbuf ) {
								rnsf7RegWrite( "hf_ncsh", hf_ncs );
								SendMessage( hRichEdit, EM_GETSEL, 0, (LPARAM)(&(ft.chrg.cpMin)) );
								ft.chrg.cpMax = -1;
								ft.lpstrText = findbuf;

								pos = (int)SendMessage( hRichEdit, EM_FINDTEXT, (WPARAM)(FR_DOWN | (hf_ncs?0:FR_MATCHCASE)), (LPARAM)&ft );
								if ( pos != -1 ) { // ݂
									SendMessage( hRichEdit, EM_SETSEL, (WPARAM)pos, (LPARAM)pos + lstrlen(findbuf) ); // I
									SendMessage( hRichEdit, EM_SCROLLCARET, 0, 0 ); // J[\̌ʒu܂ŃXN[
								}
								else {
									MessageBox( hWnd, "͌܂łB", "", MB_OK | MB_ICONEXCLAMATION );
								}

								// _CAOJĂƂ́A_CAOĕ\
								if ( findflag == 0 ) {
                                    continue;
								}
							}
						}
						break;
					}
					break;
			}
			break;

		case WM_ACTIVATE:
			SetFocus( hRichEdit );
			break;

		case WM_HELP: // dwv̌Ăяo͋֎~
			return TRUE;

		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}
