#include "stdafx.h"
#include "dlllib.h"

typedef struct {
	char *dll;
	HMODULE hModule;
} DLLSTOCK, *LPDLLSTOCK;

static UINT maxds = 0;
static LPDLLSTOCK ds = NULL;

HMODULE LoadDllLibrary( const char *dll )
{
	LPDLLSTOCK tmp;
	UINT i;

	if ( dll ) {
		if ( ds ) {
			for(i=0 ; i<maxds ; i++) {
				if ( ds[i].dll && 0 == _stricmp(ds[i].dll, dll) ) {
					return ds[i].hModule;
				}
			}
		}

		tmp = (LPDLLSTOCK)realloc(ds, sizeof(DLLSTOCK)*(maxds+1));
		if ( tmp ) {
			ds = tmp;

			ds[maxds].dll = _strdup( dll );
			ds[maxds].hModule = LoadLibrary( dll );
			return ds[maxds++].hModule;
		}
	}
	return NULL;
}

void FreeDllLibrary(void)
{
	UINT i;

	if ( ds ) {
		for(i=0 ; i<maxds ; i++) {
			safefree( ds[i].dll );

			if ( ds[i].hModule ) {
				FreeLibrary( ds[i].hModule );
			}
		}

		safefree( ds );
		maxds = 0;
	}
}
