#include "stdafx.h"

#define OWN__COMBOBOXQUEUE__

#include "ComboboxQueue.h"

// fXgN^(ANSI)
ComboboxQueueA::~ComboboxQueueA()
{
	if (szStrings != NULL) {
		if (num > 0) {
			for(--num ; num>=0 ; --num) {
				if (szStrings[num]) {
					free(szStrings[num]);
					szStrings[num] = NULL;
				}
			}
			num = 0;
		}
		free(szStrings);
		szStrings = NULL;
	}
	if (strSubkey != NULL) {
		free(strSubkey);
		strSubkey = NULL;
	}
	if (strValue != NULL) {
		free(strValue);
		strValue = NULL;
	}
}

// fXgN^(Unicode)
ComboboxQueueW::~ComboboxQueueW()
{
	if (szStrings != NULL) {
		if (num > 0) {
			for(--num ; num>=0 ; --num) {
				if (szStrings[num]) {
					free(szStrings[num]);
					szStrings[num] = NULL;
				}
			}
			num = 0;
		}
		free(szStrings);
		szStrings = NULL;
	}
	if (strSubkey != NULL) {
		free(strSubkey);
		strSubkey = NULL;
	}
	if (strValue != NULL) {
		free(strValue);
		strValue = NULL;
	}
}

// `Ə(ANSI)
bool ComboboxQueueA::Init(HWND hCtrl, int num, HKEY hRoot, const char *szSubkey, const char *szValue)
{
	if (hCtrl == NULL || num <= 0 || szSubkey == NULL || szValue == NULL) {
		// G[
		return false;
	}

	this->hRoot = hRoot;
	strSubkey = _strdup(szSubkey);
	strValue = _strdup(szValue);
	this->hCtrl = hCtrl;
	this->num = num;
	szStrings = NULL;

	DWORD  dwSize;				// ǂ݂Ƃl̃TCY
	DWORD  dwType;				// ǂ݂Ƃľ^
	LPSTR  mszData;				// ǂ݂Ƃlꏊ
	bool   bRet = false;		// ߂l
	HKEY   hKey;

	// num̕i|C^ji[̈m
	szStrings = (char **)calloc(num, sizeof(char *));
	if (szStrings == NULL) {
		// s
		return false;
	}

	if (ERROR_SUCCESS == RegOpenKeyExA(hRoot, szSubkey, 0, KEY_READ, &hKey)) {
		if (ERROR_SUCCESS != RegQueryValueExA(hKey, szValue, NULL, &dwType, NULL, &dwSize)) {
			// lȂcĂяo
			bRet = true;
		}
		else if (dwType != REG_MULTI_SZ || dwSize <= 0) {
			// ľ^قȂA邢́Al̃TCY0 c VK쐬ŁAȍ~㏑
			bRet = true;
		}
		else {
			++dwSize;
			mszData = (LPSTR)calloc(dwSize+2, sizeof(char));
			if (mszData) {
				LONG lRes = RegQueryValueExA(hKey, szValue, NULL, NULL, (LPBYTE)mszData, &dwSize);
				if (lRes == ERROR_SUCCESS) {
					DWORD i = 0;
					int   n = 0;
					bRet = true;

					for(; n < num ; ++n) {
						szStrings[n] = _strdup(&mszData[i]);
						if (szStrings[n] == NULL) {
							// s
							bRet = false;
							break;
						}
						SendMessageA(hCtrl, CB_ADDSTRING, 0, (LPARAM)&mszData[i]);

						// ̕܂ŃXLbv
						//  \0 ̘AI
						while(mszData[i] != 0) {
							++i;
						}
						if (mszData[++i] == 0) {
							break; // \0̘A𔭌
						}
					}
				}
				free(mszData);
			}
		}

		RegCloseKey(hKey);
	}
	else {
		// L[Ȃ c Ăяo
		bRet = true;
	}

	return bRet;
}

// `Ə(Unicode)
bool ComboboxQueueW::Init(HWND hCtrl, int num, HKEY hRoot, const wchar_t *szSubkey, const wchar_t *szValue)
{
	if (hCtrl == NULL || num <= 0 || szSubkey == NULL || szValue == NULL) {
		// G[
		return false;
	}

	this->hRoot = hRoot;
	strSubkey = _wcsdup(szSubkey);
	strValue = _wcsdup(szValue);
	this->hCtrl = hCtrl;
	this->num = num;
	szStrings = NULL;

	DWORD  dwSize;				// ǂ݂Ƃl̃TCY
	DWORD  dwType;				// ǂ݂Ƃľ^
	LPWSTR mszData;			// ǂ݂Ƃlꏊ
	bool   bRet = false;		// ߂l
	HKEY   hKey;

	// num̕i|C^ji[̈m
	szStrings = (wchar_t **)calloc(num, sizeof(wchar_t *));
	if (szStrings == NULL) {
		// s
		return false;
	}

	if (ERROR_SUCCESS == RegOpenKeyExW(hRoot, szSubkey, 0, KEY_READ, &hKey)) {
		if (ERROR_SUCCESS != RegQueryValueExW(hKey, szValue, NULL, &dwType, NULL, &dwSize)) {
			// lȂcĂяo
			bRet = true;
		}
		else if (dwType != REG_MULTI_SZ || dwSize <= 0) {
			// ľ^قȂA邢́Al̃TCY0 c VK쐬ŁAȍ~㏑
			bRet = true;
		}
		else {
			++dwSize;
			mszData = (LPWSTR)calloc(dwSize+2, sizeof(wchar_t));
			if (mszData) {
				LONG lRes = RegQueryValueExW(hKey, szValue, NULL, NULL, (LPBYTE)mszData, &dwSize);
				if (lRes == ERROR_SUCCESS) {
					DWORD i = 0;
					int   n = 0;
					bRet = true;

					for(; n < num ; ++n) {
						szStrings[n] = _wcsdup(&mszData[i]);
						if (szStrings[n] == NULL) {
							// s
							bRet = false;
							break;
						}
						SendMessageW(hCtrl, CB_ADDSTRING, 0, (LPARAM)&mszData[i]);

						// ̕܂ŃXLbv
						//  \0 ̘AI
						while(mszData[i] != 0) {
							++i;
						}
						if (mszData[++i] == 0) {
							break; // \0̘A𔭌
						}
					}
				}
				free(mszData);
			}
		}

		RegCloseKey(hKey);
	}
	else {
		// L[Ȃ c Ăяo
		bRet = true;
	}

	return bRet;
}


// `Ə(ANSI)
bool ComboboxQueueA::Init(HWND hWnd, int iCtrl, int num, HKEY hRoot, const char *szSubkey, const char *szValue)
{
	return Init(GetDlgItem(hWnd, iCtrl), num, hRoot, szSubkey, szValue);
}

// `Ə(Unicode)
bool ComboboxQueueW::Init(HWND hWnd, int iCtrl, int num, HKEY hRoot, const wchar_t *szSubkey, const wchar_t *szValue)
{
	return Init(GetDlgItem(hWnd, iCtrl), num, hRoot, szSubkey, szValue);
}

// szTextǉBKvɉāAÂ͍폜B(ANSI)
bool ComboboxQueueA::Add(const char *szText)
{
	int iListCount;	// ۂɉ̃f[^邩𒲂ׂinum͂܂Ńobt@̗ʂ\j

	// łɓo^ς݂̕?
	for(iListCount=0 ; szStrings[iListCount] != NULL && iListCount < num ; ++iListCount) {
		if (lstrcmpA(szStrings[iListCount], szText) == 0) {
			// o^ςݕ񂾂cԂ̕בւiAł0Ԗڂ̏ꍇ͉Ȃj
			if (iListCount == 0) {
				return true;
			}
			char *tmp = szStrings[iListCount];

			for(; iListCount > 0 ; --iListCount) {
				szStrings[iListCount] = szStrings[iListCount-1];
			}
			szStrings[0] = tmp;

			// WXgւ̏
			return regist_strings();
		}
	}

	// Vo^镶
	char *strNew = _strdup(szText);
	if (strNew == NULL) {
		return false; // s
	}

	// o^I[o[ꍇ́Ãf[^폜
	if (iListCount >= num) {
		free(szStrings[iListCount-1]);
		--iListCount;
	}

	// Ԃ̕בւ
	for(; iListCount > 0 ; --iListCount) {
		szStrings[iListCount] = szStrings[iListCount-1];
	}
	
	// o^
	szStrings[0] = strNew;

	// WXgւ̏
	return regist_strings();
}

// szTextǉBKvɉāAÂ͍폜B(Unicode)
bool ComboboxQueueW::Add(const wchar_t *szText)
{
	int iListCount;	// ۂɉ̃f[^邩𒲂ׂinum͂܂Ńobt@̗ʂ\j

	// łɓo^ς݂̕?
	for(iListCount=0 ; szStrings[iListCount] != NULL && iListCount < num ; ++iListCount) {
		if (lstrcmpW(szStrings[iListCount], szText) == 0) {
			// o^ςݕ񂾂cԂ̕בւiAł0Ԗڂ̏ꍇ͉Ȃj
			if (iListCount == 0) {
				return true;
			}
			wchar_t *tmp = szStrings[iListCount];

			for(; iListCount > 0 ; --iListCount) {
				szStrings[iListCount] = szStrings[iListCount-1];
			}
			szStrings[0] = tmp;

			// WXgւ̏
			return regist_strings();
		}
	}

	// Vo^镶
	wchar_t *strNew = _wcsdup(szText);
	if (strNew == NULL) {
		return false; // s
	}

	// o^I[o[ꍇ́Ãf[^폜
	if (iListCount >= num) {
		free(szStrings[iListCount-1]);
		--iListCount;
	}

	// Ԃ̕בւ
	for(; iListCount > 0 ; --iListCount) {
		szStrings[iListCount] = szStrings[iListCount-1];
	}
	
	// o^
	szStrings[0] = strNew;

	// WXgւ̏
	return regist_strings();
}

// WXgւ݂̏ƁAR{{bNXւ̓o^(ANSI)
bool ComboboxQueueA::regist_strings()
{
	HKEY hKey;
	bool bRet = true;
	int  iListCount = 0;	// ۂɉ̃f[^邩𒲂ׂinum͂܂Ńobt@̗ʂ\j
	int  iLoop;

	// WXgւ̏
	if (ERROR_SUCCESS == RegCreateKeyEx(hRoot, strSubkey, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL)) {
		DWORD dwLenAll = 1;		// Ō\0\0Ɨ̂ŁAŌ1]vɏ
		// ̑S̒vZ
		for(iListCount=0 ; szStrings[iListCount] != NULL && iListCount < num ; ++iListCount) {
			dwLenAll += (DWORD)lstrlen(szStrings[iListCount]);
			++dwLenAll; // I[ \0 ̕
		}

		// vZꂽ̒̕mۂAmultisz
		LPSTR mszData = (LPSTR)calloc(dwLenAll, sizeof(char));
		if (mszData) {
			DWORD dwPointer = 0;

			for(iLoop=0 ; iLoop<iListCount ; ++iLoop) {
				lstrcpy(&mszData[dwPointer], szStrings[iLoop]);
				dwPointer += (DWORD)lstrlen(szStrings[iLoop]);
				++dwPointer; // I[ \0 ̕
			}

			RegSetValueEx(hKey, strValue, 0, REG_MULTI_SZ, (LPBYTE)mszData, dwLenAll*sizeof(char));
			free(mszData);
		}
		else {
			bRet = false;	// s
		}
		RegCloseKey(hKey);
	}
	else {
		bRet = false;	// WXgJȂ
	}

	// R{{bNX̑Sf[^폜
	for(iLoop = (int)SendMessageA(hCtrl, CB_GETCOUNT, 0, 0) ; iLoop>0 ; --iLoop) {
		SendMessageA(hCtrl, CB_DELETESTRING, 0, 0);
	}

	// R{{bNXւ̓o^
	for(iLoop=0 ; iLoop<iListCount ; ++iLoop) {
		SendMessageA(hCtrl, CB_ADDSTRING, 0, (LPARAM)szStrings[iLoop]);
	}

	return bRet;
}

// WXgւ݂̏ƁAR{{bNXւ̓o^(Unicode)
bool ComboboxQueueW::regist_strings()
{
	HKEY hKey;
	bool bRet = true;
	int  iListCount = 0;	// ۂɉ̃f[^邩𒲂ׂinum͂܂Ńobt@̗ʂ\j
	int  iLoop;

	// WXgւ̏
	if (ERROR_SUCCESS == RegCreateKeyExW(hRoot, strSubkey, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL)) {
		DWORD dwLenAll = 1;		// Ō\0\0Ɨ̂ŁAŌ1]vɏ
		// ̑S̒vZ
		for(iListCount=0 ; szStrings[iListCount] != NULL && iListCount < num ; ++iListCount) {
			dwLenAll += (DWORD)lstrlenW(szStrings[iListCount]);
			++dwLenAll; // I[ \0 ̕
		}

		// vZꂽ̒̕mۂAmultisz
		LPWSTR mszData = (LPWSTR)calloc(dwLenAll, sizeof(wchar_t));
		if (mszData) {
			DWORD dwPointer = 0;

			for(iLoop=0 ; iLoop<iListCount ; ++iLoop) {
				lstrcpyW(&mszData[dwPointer], szStrings[iLoop]);
				dwPointer += (DWORD)lstrlenW(szStrings[iLoop]);
				++dwPointer; // I[ \0 ̕
			}

			RegSetValueExW(hKey, strValue, 0, REG_MULTI_SZ, (LPBYTE)mszData, dwLenAll*sizeof(wchar_t));
			free(mszData);
		}
		else {
			bRet = false;	// s
		}
		RegCloseKey(hKey);
	}
	else {
		bRet = false;	// WXgJȂ
	}

	// R{{bNX̑Sf[^폜
	for(iLoop = (int)SendMessageW(hCtrl, CB_GETCOUNT, 0, 0) ; iLoop>0 ; --iLoop) {
		SendMessageW(hCtrl, CB_DELETESTRING, 0, 0);
	}

	// R{{bNXւ̓o^
	for(iLoop=0 ; iLoop<iListCount ; ++iLoop) {
		SendMessageW(hCtrl, CB_ADDSTRING, 0, (LPARAM)szStrings[iLoop]);
	}

	return bRet;
}
