// SelIcon.cpp - ACRI_CAO

#include "stdafx.h"
#include "rnsf7.h"
#include "selicon.h"
#include "MainWindow.h"
#include "addctrl.h"
#include "opendlg.h"
#include "MainSearchRsc.h"
#include "MainListview.h"
#include "commfunc.h"

static LRESULT CALLBACK selicon_dlgproc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
static bool SetListViewData(HWND hwnd_ListView, char *IconFile);
static BOOL DeleteImageList(HWND hwnd_ListView);
static void SelIconOk(HWND hDlg, HWND hwndListView);
static char **iconfile;

static const struct DEFTOOLTIP siToolTip[] = {
	{IDC_BUTTON2,"t@Cꗗ̒IсA̓͗֓܂"},
	{IDC_BUTTON1,"t@C𒼐ړ͂ꍇɁAACR̈ꗗXV܂"},
	{IDOK       ,"ACȒI肵Ã_CAO܂"},
	{IDCANCEL   ,"ACȒILZÃ_CAO܂"},
	{IDHELP     ,"̃_CAOɊւwv\܂"},
	{0,0}};

// _CAÕAJ[Ɋւ
const DLGITEM dlgitems[] = {
	{IDC_EDIT3,					ANCHOR_TOPLEFTRIGHT},
	{IDC_BUTTON2,				ANCHOR_TOPRIGHT},
	{IDC_LIST1,					ANCHOR_CENTER},
	{IDC_CHECK_SHOW_ENABLE_ONLY,ANCHOR_TOPLEFT},
	{IDC_BUTTON1,               ANCHOR_BOTTOMLEFT},
	{IDC_STATIC1,				ANCHOR_BOTTOMLEFT},
	{IDOK,						ANCHOR_BOTTOMRIGHT},
	{IDCANCEL,					ANCHOR_BOTTOMRIGHT},
	{IDHELP,					ANCHOR_BOTTOMRIGHT},
	{0,0}
};

int selicon( HWND hWndParent, char **icon )
{
	iconfile = icon;
	return (int)DialogBox(hInst, (LPSTR)IDD_SELICON, hWndParent, (DLGPROC)selicon_dlgproc);
}

LRESULT CALLBACK selicon_dlgproc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	char *IconFile;
	int  IconNo,i;
	HWND hwndListView = GetDlgItem(hDlg, IDC_LIST1);
	char buf[520];
	static SIZEDLG *sizedlg;

	switch( message ) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// SetChildWindowFont( hDlg );
			makeToolTip(hDlg, siToolTip);
			IconFile = zalloc(lstrlen(*iconfile)+1);
			if ( IconFile ) {
				// *iconfile  IconFile  IconNo ɕ
				i = IconNo = 0;
				do {
					if ((*iconfile)[i] == ',') {
						IconFile[i] = 0;
						IconNo = atoi(&((*iconfile)[i+1]));
						break;
					}
					IconFile[i] = (*iconfile)[i];
				} while( (*iconfile)[i++] );

				SetDlgItemText(hDlg,IDC_EDIT3,IconFile);
				SetListViewData(hwndListView, IconFile);
				if (IconNo >= 0) {
					POINT pt;

					ListView_SetItemState(hwndListView, IconNo, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED );
					ListView_GetItemPosition(hwndListView, IconNo, &pt);
					ListView_Scroll(hwndListView, 0, pt.y);
				}
				safefree(IconFile);
			}
			// t@C̃hbO&hbv
			DragAcceptFiles(hDlg, true);

			// _CAÕRg[̃AJ[o^
			sizedlg = new SIZEDLG(hDlg, dlgitems);

			// _CAÕACRݒ
			SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)hIconSelIcon);
			return TRUE;

		case WM_DROPFILES:
			DragQueryFile((HDROP)wParam, 0, buf, 519);
			SetDlgItemText(hDlg, IDC_EDIT3, buf);
			DragFinish((HDROP)wParam);
			SetForegroundWindow(hDlg);
			DeleteImageList(hwndListView);
			if (false == SetListViewData(hwndListView, buf)) {
				MessageBox(hDlg,"t@CɃACR܂܂Ă܂B","ACRI",MB_OK | MB_ICONSTOP);
			}
			ListView_SetItemState(hwndListView, 0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED );
			SetFocus(GetDlgItem(hDlg,IDC_EDIT3));
			return TRUE;

		case WM_NOTIFY:
			if ((int)wParam == IDC_LIST1) {
				LPNMHDR  lpnmh = (LPNMHDR) lParam;

				if ( lpnmh->code == NM_DBLCLK ) {
                    if ( GetLVCursor( hwndListView ) >= 0 )
                        SendMessage( hDlg, WM_COMMAND, (WPARAM)IDOK, 0);
				}
			}
			return TRUE;

		case WM_HELP:
			callhelp2(hDlg, "HLP000004.html");
			return TRUE;

		case WM_GETMINMAXINFO:
			// _CAO̍ŏTCY߂
			sizedlg->GetMinMaxInfo(lParam);
			return TRUE;

		case WM_SIZE:
			// TCY
			sizedlg->Resize(1);
			return TRUE;

		case WM_DESTROY:
			// TCŶ߂̏j
			delete sizedlg;
			sizedlg = NULL;
			return TRUE;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					GetDlgItemText(hDlg, IDC_EDIT3, buf, 520);
					i = GetLVCursor(hwndListView);
					if ((buf[0] && i >= 0) || !buf[0]) {
						SelIconOk(hDlg, hwndListView);
						EndDialog(hDlg,1);
					}
					else
						MessageBox(hDlg,"ACR1IĉB\nACRꍇ́At@CɂĂ[OK]{^ĉB","ACRI",MB_OK | MB_ICONSTOP);
					return TRUE;

				case IDCANCEL:
					DeleteImageList(hwndListView);
					EndDialog(hDlg,0);
					return TRUE;

				case IDHELP:
					callhelp2(hDlg,  "HLP000004.html");
					return TRUE;

				case IDC_BUTTON2: // Q...
					GetDlgItemText(hDlg, IDC_EDIT3, buf, 519);

					if ( !openDialog( hDlg, "ACR܂ރt@C(*.exe,*.dll,*.ico)\0*.exe;*.dll;*.ico\0"
						                    "st@C(*.exe)\0*.exe\0"
						                    "_Ci~bNNCu(*.dll)\0*.dll\0"
						                    "ACRt@C(*.ico)\0*.ico\0"
						                    "ׂẴt@C(*.*)\0*.*\0\0",
											buf, 519, "ACRt@C̑I", NULL ) ) {
						return TRUE;
					}
					SetDlgItemText(hDlg, IDC_EDIT3, buf);
					SetFocus(GetDlgItem(hDlg, IDC_EDIT3));
					// IDC_BUTTON1 ɗ
				case IDC_BUTTON1: // XgXV
					GetDlgItemText(hDlg,IDC_EDIT3,buf,519);
					DeleteImageList(hwndListView);
					if (false == SetListViewData(hwndListView, buf)) {
						if (buf[0])
							MessageBox(hDlg,"t@CɃACR܂܂ĂȂAt@C܂B","ACRI",MB_OK | MB_ICONSTOP);
						else
							MessageBox(hDlg,"[ACR]ɃACR܂܂t@Cw肵ĉB\n܂[Q]At@CGNXv[ȂǂhbO邱Ƃł܂B\nt@C̏Ԃ[OK]ƁAACR̎w肪ȂAɂȂ܂B","ACRI",MB_OK | MB_ICONEXCLAMATION);
					}
					ListView_SetItemState(hwndListView, 0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED );
					return TRUE;
			}
			break;
	}
    return FALSE;
}

bool SetListViewData(HWND hwndListView, char *IconFile)
{
	int			IconMax,i;
    HIMAGELIST  himlLarge;
	LVITEM      lvitem;
	char		buf[11];

#pragma warning( disable : 4311 )
	IconMax = (int)ExtractIcon(hInst, IconFile, (UINT)-1);
#pragma warning( default : 4311 )

	himlLarge = ImageList_Create(32, 32, ILC_COLOR32 | ILC_MASK, 1, 0);
	for(i=0 ; i<IconMax ; i++)
		ImageList_AddIcon(himlLarge,ExtractIcon(hInst, IconFile, i));
	ListView_SetImageList(hwndListView, himlLarge, LVSIL_NORMAL);

	ListView_DeleteAllItems(hwndListView);
	ListView_SetItemCount(hwndListView, IconMax);

	for(i=0 ; i<IconMax ; i++) {
		lvitem.mask = LVIF_TEXT | LVIF_IMAGE;
		lvitem.iImage = lvitem.iItem = i;
		lvitem.iSubItem = 0;
		wsprintf(buf,"%u",i); lvitem.pszText = buf;
		ListView_InsertItem(hwndListView, &lvitem);
	}

	return (IconMax > 0);
}

void SelIconOk(HWND hDlg, HWND hwndListView)
{ // 񃁃A߂ė̈mۂĂB
	char buf[520];
	int  IconNo;

	safefree( *iconfile );

	GetDlgItemText(hDlg,IDC_EDIT3,buf,519);
	IconNo = GetLVCursor(hwndListView);
	if (buf[0] == 0) {
		*iconfile = (char *)malloc(1);
		if ( *iconfile ) {
			*iconfile[0] = 0;
		}
	}
	else {
		char itbuf[16];

		if ( 0 == _ultoa_s(IconNo, itbuf, _countof(itbuf), 10) ) {
			*iconfile = (char *)malloc( lstrlen(buf)+lstrlen(itbuf)+2 );
			if ( *iconfile ) {
				wsprintf(*iconfile,"%s,%d",buf,IconNo);
			}
		}
	}
	DeleteImageList(hwndListView);		
}

BOOL DeleteImageList(HWND hwndListView)
{
	int IconMax,i;
	HICON	hIcon;
	HIMAGELIST himl = ListView_GetImageList(hwndListView, LVSIL_NORMAL);

	IconMax = ImageList_GetImageCount(himl);
	for(i=0 ; i<IconMax ; i++) {
		hIcon = ImageList_ExtractIcon(0,himl,i);
		if ( hIcon ) {
			DestroyIcon( hIcon );
		}
	}
	return ImageList_Destroy(himl);
}
