// MainNavigator.cpp :
// CEChẼirQ[^

#include "stdafx.h"
#include "RNSF7.h"
#include "MainWindow.h" 
#include "MainNavigator.h"
#include "MainStatusBar.h"
#include "OpenSetting.h"
#include "symbol.h"
#include "commfunc.h"

bool StartNavigator = 0;
HFONT ui_font = NULL, bold_font = NULL, uline_font = NULL;
static char *item, *info, *rsc_fname, *author, *url, *category, *bitmap, *wavsound;
static int  MLVNavColor = 2; // Of[VJ[iftHgF΁j
static int  MLVNavItemY = 10;	 // ACe̕\YW
static int  MLVNavInfoY = 80;	 // ̕\YW
static int  MLVNavBitmapY = 130; // G̕\YW
static int  MLVNavLinkY = 130;	 // NbJueLXgYW
static bool flag_from_on = 0;

typedef struct {
	char *navlink;			// NbJueLXg̃ftHg
	char *ClickableNavi_s;	// NbJueLXg̉ϕ
	int   ClickableNavi_y;  // NbJueLXg̍YW
	int   ClickableNavi_x;  // NbJueLXg̍XW
	int   ClickableNavi_h;  // NbJueLXg̍
	int   ClickableNavi_r;	// NbJueLXg̉EXW
	int   ClickableNavi_m;	// hWndWM_COMMANDŔ΂p^
} NAVCT, *PNAVCT;

#define NUM_NAVCT	3
static NAVCT navct[NUM_NAVCT];

void OpenNavigator(HWND hWnd, HWND hCategoryTreeView, HWND hMainListView, HWND hStatusBar)
{
	// irQ[^̕\
	if ( bNavigator ) {
		HDC hdc = GetDC( hWnd );
		if ( hdc ) {
			flag_from_on = 1;
			ShowNavigator(hWnd, hdc, hCategoryTreeView, hMainListView, hStatusBar);
			flag_from_on = 0;
			ReleaseDC(hWnd, hdc);
		}
	}
}

void callback_nav( void )
{
	setVariable_d( "NAVIGATOR_ITEM$", item );
	setVariable_d( "NAVIGATOR_INFORMATION$", info );
	setVariable_d( "NAVIGATOR_RSCFILE$", rsc_fname );
	setVariable_d( "NAVIGATOR_AUTHOR$", author );
	setVariable_d( "NAVIGATOR_URL$", url );
	setVariable_d( "NAVIGATOR_CATEGORY$", category );
	setVariable_d( "NAVIGATOR_BITMAP$", bitmap );
	setVariable_d( "NAVIGATOR_SOUND$", wavsound );

	setVariable_d( "NAVIGATOR_LINK_1$", navct[0].navlink );
	setVariable_d( "NAVIGATOR_LINK_2$", navct[1].navlink );
	setVariable_d( "NAVIGATOR_LINK_3$", navct[2].navlink );

	setVariable( "NAVIGATOR_COLOR", MLVNavColor );
	setVariable( "NAVIGATOR_ITEM_Y", MLVNavItemY );
	setVariable( "NAVIGATOR_INFO_Y", MLVNavInfoY );
	setVariable( "NAVIGATOR_BITMAP_Y", MLVNavBitmapY );
	setVariable( "NAVIGATOR_LINK_Y", MLVNavLinkY );
}

void ShowNavigator(HWND hWnd, HDC hdc, HWND hCategoryTreeView, HWND hMainListView, HWND hStatusBar)
{
	int gx, gy, gw, gh, i, n, curSel;
	HPEN    hPen;
	HGDIOBJ OldPen, OldBrush;
	RECT    rt, rt2;
	static int last_gx = -2, last_gy = -2, last_gw = -2, last_gh = -2, lastSel = -2;
	static char *sitem, *sinfo, *sbitmap, *swavsound;
	bool    bDefNav = true;	// ftHg̃irQ[^H

	if ( hdc && StartNavigator && bNavigator ) {
		// irQ[^\̈̈ʒuƃTCY𒲂ׂB
		// JeS\Ăꍇ̓TCY̎擾͔rIeՂAłȂꍇ͋Ȇŋ߂邱ƂɂȂB
		if ( hCategoryTreeView ) {
			// JeS\Ă
			GetWindowRect(hCategoryTreeView, &rt);
			gx = 0;
			gy = rt.bottom - rt.top + RBAR_WIDTH;
			gw = rt.right - rt.left;
		}
		else {
			// JeS\ĂȂ
			GetWindowRect(hMainListView, &rt);
			GetWindowRect(hWnd, &rt2);
			gx = gy = 0;

			int border = GetSystemMetrics(SM_CXSIZEFRAME)*3/2;
			if (border < 8) border = 8;

			gw = rt.left - rt2.left - border;
		}

		GetClientRect(hWnd      , &rt);
		GetClientRect(hStatusBar, &rt2);
		gh = rt.bottom - gy - rt2.bottom;

		// gx,gy:irQ[^̈̍  gw,gh:irQ[^̈̕ƍ

		if ( !ui_font ) {
			ui_font = CreateFont(12,0,0,0, FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,VARIABLE_PITCH  | FF_DONTCARE,/*(winver >= 410 && rnsf7RegRead("NoDefFont", 0) == 0)?"MS UI Gothic":*/"lr oSVbN");
		}
		if ( !bold_font ) {
			bold_font = CreateFont(16,0,0,0,FW_BOLD | FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,VARIABLE_PITCH  | FF_DONTCARE,/*(winver >= 410 && rnsf7RegRead("NoDefFont", 0) == 0)?"MS UI Gothic":*/"lr oSVbN");
		}
		if ( !uline_font ) {
			uline_font = CreateFont(12,0,0,0, FW_NORMAL,0,1,0,SHIFTJIS_CHARSET,OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,VARIABLE_PITCH  | FF_DONTCARE,/*(winver >= 410 && rnsf7RegRead("NoDefFont", 0) == 0)?"MS UI Gothic":*/"lr oSVbN");
		}

		curSel = GetLVCursor( hMainListView );

		if ( curSel >= 0 ) {
			// Xgr[̎wꂽԍẢԖڂ̍ڂ𒲂ׂ
			curSel = (int)lvGetLParam(hMainListView, curSel);
		}

		// O̕`ƕωȂ΁AÔ܂ܕ\
		if ( running_settingdialog == 0 && (lastSel != curSel || last_gx != gx || last_gy != gy || last_gw != gw || last_gh != gh) ) {
			// ω΁A\eiłrscsBWM_PAINTRƂȂrscĂяoȂ悤ɂBWM_PAINT͕ҏW_CAO\ɂĂ΂Ă܂j
			if ( mlvi && curSel >= 0 ) {
				item = mlvi[curSel].item;
				info = mlvi[curSel].info;
				rsc_fname = mlvi[curSel].rsc_fname;
				author = mlvi[curSel].author;
				url = mlvi[curSel].url;
				category = mlvi[curSel].category;
			}
			else {
				item = "";
				info = bCategory?"̃JeSꗗ番ޖIAËꗗݒҏWڂJĉB":"ݒҏWڂJĉB";;
				rsc_fname = "";
				author = "";
				url = "";
				category = "";
			}

			MLVNavColor = 2; // Of[VJ[iftHgF΁j
			MLVNavItemY = 10;	 // ACe̕\YW
			MLVNavInfoY = 80;	 // ̕\YW
			MLVNavBitmapY = 130; // G̕\YW
			MLVNavLinkY = 130; // NbJueLXgYW
			bitmap = "";
			wavsound = "";
			if ( curSel >= 0 ) {
				navct[0].navlink = "̍ڂJ";
				navct[0].ClickableNavi_m = ID_SETTINGS_OPEN;
				navct[1].navlink = "\[X\";
				navct[1].ClickableNavi_m = IDM_VIEWSOURCE;

				// u̍ڂ̃wvvp\ǂ
				if ( !mlvi || mlvi[curSel].help == 0 || _stricmp(mlvi[curSel].help, "none") == 0 || _stricmp(mlvi[curSel].help, "dynamic") == 0 ) {
					navct[2].navlink = "vpeB";
					navct[2].ClickableNavi_m = IDM_ITEMPROP; // wv\ɁAACẽvpeB\
				}
				else { // p\
					navct[2].navlink = "̍ڂ̃wv";
					navct[2].ClickableNavi_m = IDM_ITEMHELP;
				}
			}
			else {
				navct[0].navlink = "IvV";
				navct[0].ClickableNavi_m = ID_SETTINGS_SETTING;
				navct[1].navlink = "wv";
				navct[1].ClickableNavi_m = IDM_HELP_HELP;
				navct[2].navlink = "I";
                navct[2].ClickableNavi_m = IDM_SETTINGS_EXIT;
			}

			lastSel = curSel;
			last_gx = gx;
			last_gy = gy;
			last_gw = gw;
			last_gh = gh;

			REG reg;
			char *navigator;

			safefree( sitem );
			sitem      = _strdup( item );
			safefree( sinfo );
			sinfo      = _strdup( info );
			safefree( sbitmap );
			sbitmap    = _strdup( bitmap );
			safefree( swavsound );
			swavsound  = _strdup( wavsound );

			safefree( navct[0].ClickableNavi_s );
			navct[0].ClickableNavi_s = _strdup( navct[0].navlink );
			safefree( navct[1].ClickableNavi_s );
			navct[1].ClickableNavi_s = _strdup( navct[1].navlink );
			safefree( navct[2].ClickableNavi_s );
			navct[2].ClickableNavi_s = _strdup( navct[2].navlink );

			if ( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY,TREG_OPEN_READONLY) ) {
				navigator = reg.new_ReadString( "navigator", "ftHg" );
				if ( navigator ) {
					// irQ[Vrscs
					if ( tFileExist( navigator ) && 0 == rsc( hWnd, navigator, NULL, 0, callback_nav ) ) {
						safefree( sitem );
						sitem      = _strdup(getVariable_d( "NAVIGATOR_ITEM$" ));
						safefree( sinfo );
						sinfo      = _strdup(getVariable_d( "NAVIGATOR_INFORMATION$" ));
						safefree( sbitmap );
						sbitmap    = _strdup(getVariable_d( "NAVIGATOR_BITMAP$" ));
						safefree( swavsound );
						swavsound  = _strdup(getVariable_d( "NAVIGATOR_SOUND$" ));

						safefree( navct[0].ClickableNavi_s );
						navct[0].ClickableNavi_s = _strdup(getVariable_d( "NAVIGATOR_LINK_1$" ));
						safefree( navct[1].ClickableNavi_s );
						navct[1].ClickableNavi_s = _strdup(getVariable_d( "NAVIGATOR_LINK_2$" ));
						safefree( navct[2].ClickableNavi_s );
						navct[2].ClickableNavi_s = _strdup(getVariable_d( "NAVIGATOR_LINK_3$" ));

						MLVNavColor = getVariable( "NAVIGATOR_COLOR" );
						MLVNavItemY = getVariable( "NAVIGATOR_ITEM_Y" );
						MLVNavInfoY = getVariable( "NAVIGATOR_INFO_Y" );
						MLVNavBitmapY = getVariable( "NAVIGATOR_BITMAP_Y" );
						MLVNavLinkY = getVariable( "NAVIGATOR_LINK_Y" );

						if ( swavsound && swavsound[0] ) {
							PlaySound(NULL, 0, 0);
							PlaySound(swavsound, 0, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
						}
						else {
							PlaySound(NULL, 0, 0);
						}

						bDefNav = false;
					}
					safedelete( navigator );
				}
				reg.CloseKey();
			}
		}
		else {
			if ( flag_from_on ) {
				// OƔׂăJ[\ʒuɕωAWM_PAINŤĂяołȂ΁A`sȂ
                return;
			}
		}

		// irQ[^̈
		n = (gh<64)?gh:64;

		// Of[VGA艺͔
		OldPen = SelectObject(hdc, GetStockObject(WHITE_PEN));
		OldBrush = SelectObject(hdc, GetStockObject(WHITE_BRUSH));

		if ( n == 64 ) {
			Rectangle(hdc, gx, gy+n, gx+gw, gy+gh);
		}
		// Of[V
		for(i=0 ; i<n ; i++) {
			hPen = CreatePen(PS_SOLID,1,RGB((MLVNavColor&4)?255:i*4,(MLVNavColor&2)?255:i*4,(MLVNavColor&1)?255:i*4));
			if ( hPen ) {
				SelectObject(hdc, hPen);
				MoveToEx(hdc, gx, gy+i, NULL);
				LineTo(hdc, gw + gx, gy+i);
				SelectObject(hdc, OldPen);
				DeleteObject(hPen);
			}
		}
		SelectObject(hdc, OldBrush);

		// rbg}bv
		if (bDefNav) {
			// ftHg̃irQ[^̏ꍇ́Aʍɂ[̃S\
			if (gh > 245) {
				static HBITMAP hBmp_logos;
				if (!hBmp_logos) {
					hBmp_logos = (HBITMAP)LoadBitmap(hInst, (LPCSTR)IDB_SMALL_LOGO);
				}
				if (hBmp_logos) {
					HDC memDC;
					BITMAP bitmap;

					memDC = CreateCompatibleDC(hdc);
					if ( memDC ) {
						SelectObject(memDC, hBmp_logos);
						GetObject(hBmp_logos, sizeof(BITMAP), &bitmap);
						BitBlt(hdc, bitmap.bmWidth/16, gy+gh-bitmap.bmHeight-bitmap.bmHeight/4, gw-bitmap.bmWidth/16, bitmap.bmHeight, memDC, 0, 0, SRCCOPY);
						DeleteDC(memDC);
					}
				}
			}
		}
		else {
			if ( MLVNavBitmapY >= 0 && sbitmap && sbitmap[0] ) {
				HBITMAP hBmp = (HBITMAP)LoadImage(hInst, sbitmap, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
				if ( hBmp ) {
					HDC memDC;
					BITMAP bitmap;

					memDC = CreateCompatibleDC(hdc);
					if ( memDC ) {
						SelectObject(memDC, hBmp);
						GetObject(hBmp, sizeof(BITMAP), &bitmap);
						BitBlt(hdc, gx, gy+MLVNavBitmapY, gw, gh-MLVNavBitmapY, memDC, 0, 0, SRCCOPY);
						DeleteDC(memDC);
					}
					DeleteObject( hBmp );
				}
			}
		}

		// NbJueLXg
		SetBkMode(hdc, TRANSPARENT);
		OldPen = SelectObject(hdc, uline_font);

		if ( MLVNavLinkY >= 0 ) {
			int by, j;
			SIZE sz;

			by = gy + MLVNavLinkY + 32;

			for(j=0 ; j<NUM_NAVCT ; j++) {
				// NbJueLXg̏cZo
				GetTextExtentPoint32(hdc, "I", 1, &sz);
				navct[j].ClickableNavi_h = sz.cy + 2;

				// NbJueLXg̍WZo
				navct[j].ClickableNavi_x = gx + 20;
                navct[j].ClickableNavi_y = by + navct[j].ClickableNavi_h * j;

				// NbJueLXg̍ČvZ
				// (̈悩͂ݏoĂ܂ꍇ͐؂)
				if ( navct[j].ClickableNavi_y + navct[j].ClickableNavi_h >= gy + gh ) {
					if ( navct[j].ClickableNavi_y  < gy + gh ) {
						navct[j].ClickableNavi_h = gy + gh - navct[j].ClickableNavi_y;
					}
				}

				// NbJueLXg̉Zo
				GetTextExtentPoint32(hdc, navct[j].ClickableNavi_s, lstrlen(navct[j].ClickableNavi_s), &sz);
				navct[j].ClickableNavi_r = ( navct[j].ClickableNavi_x + sz.cx > gx + gw - 1 ) ? gx + gw - 1 : navct[j].ClickableNavi_x + sz.cx;

				// wvȂ or irQ[^̈̓sŗp\ǂ
				if ( navct[j].ClickableNavi_m == 0 || navct[j].ClickableNavi_y >= gy + gh ) {
					navct[j].ClickableNavi_y = -1;
				}
			}

			// irQ[^̈̂ANbJueLXg̕`s
			MoveMouseOnNavigator( hWnd, -1, -1 ); // `̂
		}
		else { // irQ[^XNvg̎wMLVNavLinkY̐ɃZbgꂽAirQ[^͔\
			for(int j=0 ; j<NUM_NAVCT ; j++) {
				navct[j].ClickableNavi_y = -1;
			}
		}

		// eLXgiACeƐj̕\
		SetTextColor( hdc, RGB(0,0,0) );
		SetBkMode( hdc, TRANSPARENT );
		
		rt.left = gx + 4;
		rt.right = gx + gw - 4;
		rt.bottom = gy + gh;
		if ( MLVNavItemY >= 0 ) {
			rt.top = gy + MLVNavItemY;
			SelectObject(hdc, bold_font);
			DrawText(hdc, sitem, -1, &rt, DT_LEFT | DT_WORDBREAK | DT_NOPREFIX | DT_EXPANDTABS);
		}
		if ( MLVNavInfoY >= 0 ) {
			rt.top = gy + MLVNavInfoY;
			SelectObject(hdc, ui_font);
			DrawText(hdc, sinfo, -1, &rt, DT_LEFT | DT_WORDBREAK | DT_NOPREFIX | DT_EXPANDTABS);
		}
		SelectObject(hdc, OldPen);
	}
}

// irQ[^Ń}EX
void MoveMouseOnNavigator( HWND hWnd, int mx, int my )
{
	if ( StartNavigator && bNavigator ) {
		HDC hdc;
		HGDIOBJ hOldFont;
		RECT rt;
		bool mcursorf = 0;
		HCURSOR hCursor;
		static bool last_statusbar_state = 0;

		hdc = GetDC( hWnd );
		if ( hdc ) {
			hOldFont = SelectObject(hdc, uline_font);
			SetBkMode( hdc, TRANSPARENT );

			for(int j=0 ; j<NUM_NAVCT ; j++) {
				if ( navct[j].ClickableNavi_y >= 0 ) {
					rt.top    = navct[j].ClickableNavi_y;
					rt.left   = navct[j].ClickableNavi_x;
					rt.bottom = navct[j].ClickableNavi_y+navct[j].ClickableNavi_h;
					rt.right  = navct[j].ClickableNavi_r;
					if ( rt.left <= mx && mx < rt.right && rt.top <= my && my < rt.bottom ) {
						// }EXJ[\NbJueLXgɂ
						// ԂAJ[\̌`nhJ[\ɂ
						SetTextColor( hdc, RGB(0xff, 0, 0) );
						mcursorf = 1;
						setStatusBarHelp( navct[j].ClickableNavi_m );
					}
					else {
						// }EXJ[\NbJueLXgɂ
						// 
						SetTextColor( hdc, RGB(0, 0, 0xff) );
					}

					// NbJueLXg`is͂Ȃj
					DrawText(hdc, navct[j].ClickableNavi_s, -1, &rt, DT_LEFT | DT_NOPREFIX | DT_EXPANDTABS);
				}
			}

			SelectObject(hdc, hOldFont);
			ReleaseDC(hWnd, hdc);

			// }EXJ[\ω
			if ( NULL != (hCursor = LoadCursor(NULL, (winver>400 && mcursorf)?IDC_HAND:IDC_ARROW)) ) {
				SetCursor( hCursor );
			}

			// Xe[^Xo[̕\
			if ( mcursorf == 0 ) {
				if ( last_statusbar_state == 1 ) {
					setStatusBarText( NULL, 0 );
					last_statusbar_state = 0;
				}
			}
			else {
				last_statusbar_state = 1;
			}
		}
	}
}

// irQ[^Ń}EXNbNꂽ
void ClickButtonOnNavigator( HWND hWnd, int mx, int my )
{
	if ( StartNavigator && bNavigator ) {
		for(int j=0 ; j<NUM_NAVCT ; j++) {
			if ( navct[j].ClickableNavi_y >= 0 ) {
				if ( navct[j].ClickableNavi_x <= mx && mx < navct[j].ClickableNavi_r && navct[j].ClickableNavi_y <= my && my < navct[j].ClickableNavi_y+navct[j].ClickableNavi_h ) {
					MoveMouseOnNavigator( hWnd, -1, -1 );// ԂiłȂƁAr[Ƀ_CAONbJueLXgɔ킳āA_CAOƂɁAԂr[ɎcĂ܂j
					SendMessage(hWnd, WM_COMMAND, MAKELONG(navct[j].ClickableNavi_m, 0), 0); // bZ[WM
					break;
				}
			}
		}
	}
}
