// MainCategory.cpp :
// CEChE̍̃JeS{bNX

#include "stdafx.h"
#include "RNSF7.h"
#include "MainWindow.h"
#include "MainCategory.h"
#include "MainNavigator.h"
#include "MainListview.h"

static WNDPROC OrgCategoryTreeViewProc;
HTREEITEM htSearch, htRoot;

// Xgr[ŉꂽEnterL[Ԃǂ
LRESULT CALLBACK NewCategoryTreeViewProc(HWND hWnd, UINT mes, WPARAM wParam, LPARAM lParam)
{
	switch (mes) {
		case WM_KEYDOWN:
			switch( wParam ) {
				case VK_TAB:
				case VK_RETURN:
					SetFocus( hMainListView );
			}
			break;

		case WM_LBUTTONUP:
			SendMessage( GetParent(hWnd), mes, wParam, lParam );
			break;

		case WM_MOUSEMOVE:
			{
				HWND hParent = GetParent(hWnd);
				POINT po;
				po.x = LOWORD(lParam);  // horizontal position of cursor 
				po.y = HIWORD(lParam);  // vertical position of cursor 

				ClientToScreen(hWnd, &po);
				rebarMove( hParent, (int)wParam, &po );
				MoveMouseOnNavigator( hParent, -1, -1 );
			}
			break;
	}

	return (CallWindowProc(OrgCategoryTreeViewProc, hWnd, mes, wParam, lParam));
}

// c[r[ɍڂǉ(nLevel12̂ݎw\炵)
// (܂ŏ hwndTV = NULL ɂČĂяo)
HTREEITEM AddItemToTree(HWND hwndTV, LPSTR lpszItem, int nLevel, int iImageOpen, int iImageClose, int id)
{
	TVITEM tvi;
	TVINSERTSTRUCT tvins;
	static HTREEITEM hPrev = (HTREEITEM)TVI_FIRST;
	static HTREEITEM hPrevRootItem = NULL;
	static HTREEITEM hPrevLev2Item = NULL;

	if ( hwndTV == NULL ) { // tvins.hInsertAfterɓ邽߂̃f[^
		hPrevRootItem = hPrevLev2Item = NULL;
        return hPrev = (HTREEITEM)TVI_FIRST;
	}

	tvi.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;

	// eLXgݒ
	tvi.pszText = lpszItem;
	tvi.cchTextMax = lstrlen(lpszItem);

	// IEĨACRԍݒ
	tvi.iImage = iImageClose;
	tvi.iSelectedImage = iImageOpen;

	// Cӂ̃f[^ݒ
	tvi.lParam = (LPARAM)id;

	tvins.item = tvi;
	tvins.hInsertAfter = hPrev;

	// etH_ƂȂf[^ݒiAxQ܂łΉĂȂ悤j
	if ( nLevel == 1 )
		tvins.hParent = TVI_ROOT;
	else if ( nLevel == 2 )
		tvins.hParent = hPrevRootItem;
	else
		tvins.hParent = hPrevLev2Item;

	// ACeǉ(SendMessage)
	hPrev = (HTREEITEM)SendMessage(hwndTV, TVM_INSERTITEM, 0, (LPARAM)&tvins);

	// ǉ̂߂Ƀnhۑ
	if ( nLevel == 1 )
		hPrevRootItem = hPrev;
	else if ( nLevel == 2 )
		hPrevLev2Item = hPrev;

	return hPrev;
}

// JeS\pXgr[Rg[̐
HWND createCategoryTreeView(HWND hWnd)
{
	HWND		hCategoryTreeView;
	int			n, i;

	hCategoryTreeView = CreateWindowEx(WS_EX_CLIENTEDGE, WC_TREEVIEW, "TreeView",
				          WS_TABSTOP | WS_CHILD | WS_VISIBLE | WS_BORDER | TVS_HASLINES | TVS_SHOWSELALWAYS/* | TVS_LINESATROOT | TVS_HASBUTTONS */,
						  0, 0, 0, 0, hWnd, (HMENU)IDC_CATEGORYTREEVIEW, hInst, NULL);

	if( !hCategoryTreeView ) {
		return NULL;
	}

	// ACRc[r[̃C[Wɒǉ
	TreeView_SetImageList(hCategoryTreeView, himlTreeSmall, TVSIL_NORMAL);

	if ( categorys ) {
		TreeView_DeleteAllItems( hCategoryTreeView );

		// ֐(staticȕϐ邽)
		AddItemToTree(NULL, 0, 0, 0, 0, 0);

		// nŏIԍɃZbg
		for(n=0 ; categorys[n] ; n++)
			;

		// m
		ListView_SetItemCount(hCategoryTreeView, n+2);

		// [gvfǉ
		htRoot = AddItemToTree( hCategoryTreeView, "ׂẴJeS", 1, 1, 1, -1 );

		// eJeSǉ
		for(i=0 ; i<n ; i++) {
			AddItemToTree( hCategoryTreeView, categorys[i], 2, 3, 0, i );
		}

		// ŏIڂ͌ʕ\p
		htSearch = AddItemToTree( hCategoryTreeView, ":XNvg(Ctrl+F)̌ʂ\܂", 1, 2, 2, -2 );

		// [gvfɃJ[\^A[gvfWJ
		TreeView_SelectItem( hCategoryTreeView, htRoot );
		TreeView_Expand( hCategoryTreeView, htRoot, TVE_EXPAND );

	}

	OrgCategoryTreeViewProc = (WNDPROC)GetWindowLongPtr(hCategoryTreeView, GWLP_WNDPROC);
	SetWindowLongPtr(hCategoryTreeView, GWLP_WNDPROC, (LONG_PTR)NewCategoryTreeViewProc); // Enter,TABL[󂯎邽߂̃tbN

	return hCategoryTreeView;
}
