// LvEdit.cpp - Xgr[̍ڕҏW_CAO

#include "stdafx.h"
#include "Rnsf7.h"
#include "LvEdit.h"
#include "opendlg.h"
#include "filetypes.h"
#include "addctrl.h"

static LRESULT CALLBACK lv2eDialog( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );	// ValueList(key:1-value:1)
static LRESULT CALLBACK lvmeDialog( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );	// ValueList(key:1-value:1 AsWJ)
static LRESULT CALLBACK lvneDialog( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam );	// ValueList(key:1-value:n)
static char *ml_itemname, *ml_itemdata, *ml_col1, *ml_col2;
static HWND ml_hListView, ml_hWnd;

// ------------------------------------------------------------------------------------------------
// ValueList(key:1-value:1)
// ------------------------------------------------------------------------------------------------
// ValueList̒ǉEҏW
bool lv_edititem(HWND hWnd, char **itemname, char **itemdata, HWND hListView, char *col1, char *col2)
{
	ml_hWnd = hWnd;
	ml_itemname = *itemname;
	ml_itemdata = *itemdata;
	ml_col1 = col1;
	ml_col2 = col2;
	ml_hListView = hListView;

	if ( IDOK == DialogBox(hInst, (LPCTSTR)IDD_EDIT_LV2, hWnd, (DLGPROC)lv2eDialog) ) {
		*itemname = ml_itemname;
		*itemdata = ml_itemdata;
        return true;
	}
	else {
		return false;
	}
}

// _CAÕAJ[Ɋւ
const DLGITEM dlgitems[] = {
	{IDC_EDIT1,					ANCHOR_TOPLEFTRIGHT},
	{IDC_EDIT2,					ANCHOR_TOPLEFTRIGHT},
	{IDC_FILE_BROWSE0,			ANCHOR_TOPRIGHT},
	{IDC_FILE_BROWSE,			ANCHOR_TOPRIGHT},
	{IDC_FOLDER_BROWSE0,		ANCHOR_TOPRIGHT},
	{IDC_FOLDER_BROWSE,			ANCHOR_TOPRIGHT},
	{IDOK,						ANCHOR_BOTTOMRIGHT},
	{IDCANCEL,					ANCHOR_BOTTOMRIGHT},
	{0,0}
};

// ValueList̒ǉEҏW_CAO
static LRESULT CALLBACK lv2eDialog( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	static SIZEDLG *sizedlg;

	switch( message ) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// SetChildWindowFont( hDlg );

			// _CAÕACRݒ
			SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)hIconInputText);

			if ( ml_itemname == NULL ) {
				SetWindowText(hDlg, "VK");
			}
			else {
				SetDlgItemText(hDlg, IDC_EDIT1, ml_itemname);
				SetDlgItemText(hDlg, IDC_EDIT2, ml_itemdata);
			}
			SetDlgItemText(hDlg, IDC_STATIC1, ml_col1);
			SetDlgItemText(hDlg, IDC_STATIC2, ml_col2);
			SendDlgItemMessage(hDlg, IDC_FILE_BROWSE0, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFileBrowse);
			SendDlgItemMessage(hDlg, IDC_FOLDER_BROWSE0, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFolderBrowse);
			SendDlgItemMessage(hDlg, IDC_FILE_BROWSE, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFileBrowse);
			SendDlgItemMessage(hDlg, IDC_FOLDER_BROWSE, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFolderBrowse);
			{
				HWND hTooltip;
				TOOLINFO ti;

				if (NULL == (hTooltip=CreateWindow(TOOLTIPS_CLASS,"",TTS_ALWAYSTIP,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hDlg,NULL,hInst,NULL)))
					return NULL;

				ZeroMemory(&ti, sizeof(ti));
				ti.cbSize = sizeof(TOOLINFO);
				ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;// uID̓c[`bv\EBhEʂnh / TuNXC
				ti.hwnd = hDlg;	// c[`bvEBhE

				ti.lpszText = ml_col1;// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_EDIT1);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_STATIC1);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = ml_col2;// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_EDIT2);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_STATIC2);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "t@Cꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FILE_BROWSE0);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FILE_BROWSE);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "tH_ꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FOLDER_BROWSE0);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FOLDER_BROWSE);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "͂eŌ肵A_CAO܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDOK);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "͂eLZA_CAO܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDCANCEL);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
			}

			// _CAÕRg[̃AJ[o^
			sizedlg = new SIZEDLG(hDlg, dlgitems);
			sizedlg->SetMinMaxInfo(sizedlg->GetDefWidth(), sizedlg->GetDefHeight(), -1, sizedlg->GetDefHeight());
			return TRUE;

		case WM_DESTROY:
			// ACRĂ{^j
			DestroyWindow(GetDlgItem(hDlg, IDC_FILE_BROWSE0));
			DestroyWindow(GetDlgItem(hDlg, IDC_FOLDER_BROWSE0));
			DestroyWindow(GetDlgItem(hDlg, IDC_FILE_BROWSE));
			DestroyWindow(GetDlgItem(hDlg, IDC_FOLDER_BROWSE));

			// TCŶ߂̏j
			if (sizedlg) {
				delete sizedlg;
				sizedlg = NULL;
			}
			return TRUE;

		case WM_GETMINMAXINFO:
			// _CAO̍ŏTCY߂
			if (sizedlg) {
				sizedlg->GetMinMaxInfo(lParam);
			}
			return TRUE;

		case WM_SIZE:
			// TCY
			if (sizedlg) {
				sizedlg->Resize(1);
			}
			return TRUE;

		case WM_DROPFILES: // ҏW{bNXt@Chbvꂽ
			{
				int n; // hbvꂽt@C̐
				int i; // JE^
				int len; // ҏW{bNXɂłɑ݂镶̃oCg
				char fname[MAX_PATH*2];
				char *buf;
				POINT pt;
				HWND hEdit; // ꂩ悤ƂҏW{bNX
				RECT rt;

				GetCursorPos( &pt );
				GetWindowRect(GetDlgItem(hDlg, IDC_STATIC2), &rt);

				// hbvƂ̃}EẌʒuAQ߂̃X^eBbNeLXgゾ
				if ( pt.y < rt.top ) { // P߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
					hEdit = GetDlgItem(hDlg, IDC_EDIT1);
				}
				else {  // łȂ΁AQ߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
					hEdit = GetDlgItem(hDlg, IDC_EDIT2);
				}

				n = DragQueryFile((HDROP)wParam, (UINT)-1, NULL, 0);
				for(i=0 ; i<n ; i++) {
					if (_countof(fname) > DragQueryFile((HDROP)wParam, i, fname, _countof(fname))) {
                        len = GetWindowTextLength( hEdit );
						if ( len > 0 ) { // łɕ񂪓Ăꍇ́AɃXy[XĂǉ
							buf = (char *)malloc( len + lstrlen(fname) + 2 );
							if ( buf ) {
								GetWindowText( hEdit, buf, len+1 );
								lstrcat(buf, " ");
								lstrcat(buf, fname);
								SetWindowText(hEdit, buf);
								safefree( buf );
							}
						}
						else { // ܂񂪓ĂȂꍇ́Â܂ܐݒ
                            SetWindowText(hEdit, fname);
						}
					}
				}
				DragFinish((HDROP)wParam);
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					{
						char *ml2_itemname = NULL, *ml2_itemdata = NULL;
						int len;

						// 1ڂ̒lȂ΃G[
						len = GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT1));
						if ( len == 0 ) {
							MessageBox(hDlg, "1ڂɉ͂Ă܂B", "`FbN", MB_OK | MB_ICONSTOP);
							return TRUE;
						}

						// 1ڂ̃f[^擾
						ml2_itemname = (char *)malloc( len+1 );
						if ( ml2_itemname == NULL ) {
							MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂B", "G[", MB_OK | MB_ICONSTOP);
							return TRUE;
						}
                        GetDlgItemText(hDlg, IDC_EDIT1, ml2_itemname, len+1);

						if ( ml_itemname != NULL && _stricmp(ml2_itemname, ml_itemname) == 0 )
							; // 1ڂɕωȂ΁A1ڂɂĂ͂̂܂
						else { // ωꍇ́Ȃ1ڂƂ̏dȂ`FbN
							int i, n;
							char *iname = (char *)malloc( len+2 ); // ݂̑1ڂꕶ߂ɒׂ΂悢

							if ( iname ) {
								n = ListView_GetItemCount( ml_hListView );
								
								for(i=0 ; i<n ; i++) {
									ListView_GetItemText( ml_hListView, i, 0, iname, len+2 );
									if ( _stricmp(iname, ml2_itemname) == 0 ) {
										MessageBox(hDlg, "1ڂAXg̑̍ڂƏdĂ܂B","`FbN",MB_OK | MB_ICONSTOP);
										safefree( iname );
										safefree( ml2_itemname );
										return TRUE;
									}
								}

								safefree( iname );
							}
							else {
								safefree( ml2_itemname );
								MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂B", "G[", MB_OK | MB_ICONSTOP);
								return TRUE;
							}
						}

						// OKȂ΃obt@̃|C^Rs[(̑Oɋobt@͉)
						safefree( ml_itemname );
						ml_itemname = ml2_itemname;

						len = GetWindowTextLength( GetDlgItem(hDlg, IDC_EDIT2) );
						ml2_itemdata = (char *)malloc( len+1 );
						if ( ml2_itemdata ) {
                            GetDlgItemText(hDlg, IDC_EDIT2, ml2_itemdata, len+1);
							safefree( ml_itemdata );
							ml_itemdata = ml2_itemdata;
							EndDialog( hDlg, IDOK );
						}
						else {
							MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂B", "G[", MB_OK | MB_ICONSTOP);
						}
						return TRUE;
					}

				case IDCANCEL:
					EndDialog( hDlg, IDCANCEL );
					return TRUE;

				case IDC_FILE_BROWSE0:
					{
						char fname[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT1, fname, _countof(fname));
						if ( openDialog( hDlg, FILETYPES, fname, _countof(fname), "t@C̑I", NULL ) ) {
							SetDlgItemText(hDlg, IDC_EDIT1, fname);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT1) );
						}
						return TRUE;
					}

				case IDC_FOLDER_BROWSE0:
					{
						char chPutFolder[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT1, chPutFolder, _countof(chPutFolder));
						if ( browseFolder( hDlg, chPutFolder, "tH_̑I" ) ) {
							SetDlgItemText(hDlg, IDC_EDIT1, chPutFolder);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT1) );
						}
						return TRUE;
					}

				case IDC_FILE_BROWSE:
					{
						char fname[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT2, fname, _countof(fname));
						if ( openDialog( hDlg, FILETYPES, fname, _countof(fname), "t@C̑I", NULL ) ) {
							SetDlgItemText(hDlg, IDC_EDIT2, fname);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT2) );
						}
						return TRUE;
					}

				case IDC_FOLDER_BROWSE:
					{
						char chPutFolder[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT2, chPutFolder, _countof(chPutFolder));
						if ( browseFolder( hDlg, chPutFolder, "tH_̑I" ) ) {
							SetDlgItemText(hDlg, IDC_EDIT2, chPutFolder);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT2) );
						}
						return TRUE;
					}
			}
			break;
	}
    return FALSE;
}

// ------------------------------------------------------------------------------------------------
// ValueList(key:1-value:1 AsWJ)
// ------------------------------------------------------------------------------------------------
BOOL lv_edititem_m(HWND hWnd, char **itemname, char **itemdata, char *col1, char *col2, char* pcDelim)
{
	ml_hWnd = hWnd;
	ml_itemname = *itemname;
	ml_col1 = col1;				// col1==NULL:PڕҏW[h
	ml_col2 = col2 ? col2 : "";
	ml_hListView = NULL;

	// ml_itemdatapcDelim[i]Asɒu
	if (pcDelim[0]) {
		// u̕JEg(pcDelim[i]\r\nɂ̂ŁApcDelim[i]̕2{ɂȂƂČvZ)
		int i1 = 0, i2 = 0, n1 = 0, n2 = 0;

		for(n1=0 ; (*itemdata)[n1] ; ++n1) {
			if (strchr(pcDelim, (*itemdata)[n1])) {
				++n2;
			}
			++n2;
		}

		ml_itemdata = zalloc(n2+2);

		for(i1=0 ; i1<n1 ; ++i1) {
			if (strchr(pcDelim, (*itemdata)[i1]) && !(i1 > 0 && isKanji1(*itemdata, i1-1)) ) {
				ml_itemdata[i2] = '\r';
				ml_itemdata[++i2] = '\n';
			}
			else {
				ml_itemdata[i2] = (*itemdata)[i1];
			}
			++i2;
		}

		free(*itemdata);
		*itemdata = ml_itemdata;
	}
	else {
		ml_itemdata = *itemdata;
	}

	if ( IDOK == DialogBox(hInst, (LPCTSTR)IDD_EDIT_LVM, hWnd, (DLGPROC)lvmeDialog) ) {
		*itemname = ml_itemname;

		// ml_itemdataɉsApcDelim[0]ɒu
		if (pcDelim[0]) {
			int i1 = 0, i2 = 0;

			for(i1=0 ; ml_itemdata[i1] ; ++i1) {
				if (ml_itemdata[i1] == '\r' && ml_itemdata[i1+1] == '\n') {
					ml_itemdata[i2] = pcDelim[0];
					++i1;
				}
				else {
					if (i1 != i2) {
						ml_itemdata[i2] = ml_itemdata[i1];
					}
				}
				++i2;
			}
			ml_itemdata[i2] = 0;
		}
		*itemdata = ml_itemdata;
        return TRUE;
	}
	else {
		return FALSE;
	}
}


// _CAÕAJ[Ɋւ
const DLGITEM dlgitems_ml[] = {
	{IDC_EDIT1,					ANCHOR_TOPLEFTRIGHT},
	{IDC_EDIT2,					ANCHOR_CENTER},
	{IDC_FILE_BROWSE0,			ANCHOR_TOPRIGHT},
	{IDC_FILE_BROWSE,			ANCHOR_TOPRIGHT},
	{IDC_FOLDER_BROWSE0,		ANCHOR_TOPRIGHT},
	{IDC_FOLDER_BROWSE,			ANCHOR_TOPRIGHT},
	{IDOK,						ANCHOR_BOTTOMRIGHT},
	{IDCANCEL,					ANCHOR_BOTTOMRIGHT},
	{0,0}
};

// ValueList̒ǉEҏW_CAOisҏW{bNXpj
static LRESULT CALLBACK lvmeDialog( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	static SIZEDLG *sizedlg;

	switch( message ) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// SetChildWindowFont( hDlg );

			// _CAÕACRݒ
			SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)hIconInputText);

			if ( ml_itemname == NULL ) {
				SetWindowText(hDlg, "VK");
			}
			else {
				if (ml_col1) SetDlgItemText(hDlg, IDC_EDIT1, ml_itemname);
				SetDlgItemText(hDlg, IDC_EDIT2, ml_itemdata);
			}

			if (ml_col1) {
				SetDlgItemText(hDlg, IDC_STATIC1, ml_col1);
				SendDlgItemMessage(hDlg, IDC_FILE_BROWSE0, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFileBrowse);
				SendDlgItemMessage(hDlg, IDC_FOLDER_BROWSE0, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFolderBrowse);
			}
			else { // PڕҏW[h
				ShowWindow(GetDlgItem(hDlg, IDC_STATIC1), SW_HIDE);
				ShowWindow(GetDlgItem(hDlg, IDC_EDIT1), SW_HIDE);
				ShowWindow(GetDlgItem(hDlg, IDC_FILE_BROWSE0), SW_HIDE);
				ShowWindow(GetDlgItem(hDlg, IDC_FOLDER_BROWSE0), SW_HIDE);
			}

			SetDlgItemText(hDlg, IDC_STATIC2, ml_col2);
			SendDlgItemMessage(hDlg, IDC_FILE_BROWSE, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFileBrowse);
			SendDlgItemMessage(hDlg, IDC_FOLDER_BROWSE, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFolderBrowse);
			{
				HWND hTooltip;
				TOOLINFO ti;

				if (NULL == (hTooltip=CreateWindow(TOOLTIPS_CLASS,"",TTS_ALWAYSTIP,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hDlg,NULL,hInst,NULL)))
					return NULL;

				ZeroMemory(&ti, sizeof(ti));
				ti.cbSize = sizeof(TOOLINFO);
				ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;// uID̓c[`bv\EBhEʂnh / TuNXC
				ti.hwnd = hDlg;	// c[`bvEBhE

				ti.lpszText = ml_col1;// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_EDIT1);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_STATIC1);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = ml_col2;// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_EDIT2);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_STATIC2);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "t@Cꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FILE_BROWSE0);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FILE_BROWSE);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "tH_ꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FOLDER_BROWSE0);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FOLDER_BROWSE);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "͂eŌ肵A_CAO܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDOK);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "͂eLZA_CAO܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDCANCEL);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
			}

			// _CAÕRg[̃AJ[o^
			sizedlg = new SIZEDLG(hDlg, dlgitems_ml);
			sizedlg->SetMinMaxInfo(sizedlg->GetDefWidth(), sizedlg->GetDefHeight(), -1, -1);
			return TRUE;

		case WM_DESTROY:
			// ACRĂ{^j
			DestroyWindow(GetDlgItem(hDlg, IDC_FILE_BROWSE0));
			DestroyWindow(GetDlgItem(hDlg, IDC_FOLDER_BROWSE0));
			DestroyWindow(GetDlgItem(hDlg, IDC_FILE_BROWSE));
			DestroyWindow(GetDlgItem(hDlg, IDC_FOLDER_BROWSE));

			// TCŶ߂̏j
			if (sizedlg) {
				delete sizedlg;
				sizedlg = NULL;
			}
			return TRUE;

		case WM_GETMINMAXINFO:
			// _CAO̍ŏTCY߂
			if (sizedlg) {
				sizedlg->GetMinMaxInfo(lParam);
			}
			return TRUE;

		case WM_SIZE:
			// TCY
			if (sizedlg) {
				sizedlg->Resize(1);
			}
			return TRUE;

		case WM_DROPFILES: // ҏW{bNXt@Chbvꂽ
			{
				int n; // hbvꂽt@C̐
				int i; // JE^
				int len; // ҏW{bNXɂłɑ݂镶̃oCg
				char fname[MAX_PATH*2];
				char *buf;
				POINT pt;
				HWND hEdit; // ꂩ悤ƂҏW{bNX
				RECT rt;
				int nBox; // Ԗڂ̕ҏW{bNXւ̃hbvH

				GetCursorPos( &pt );
				GetWindowRect(GetDlgItem(hDlg, IDC_STATIC2), &rt);

				// hbvƂ̃}EẌʒuAQ߂̃X^eBbNeLXgゾ
				if ( pt.y < rt.top ) { // P߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
					hEdit = GetDlgItem(hDlg, IDC_EDIT1);
					nBox = 0;
				}
				else {  // łȂ΁AQ߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
					hEdit = GetDlgItem(hDlg, IDC_EDIT2);
					nBox = 1;
				}

				n = DragQueryFile((HDROP)wParam, (UINT)-1, NULL, 0);
				for(i=0 ; i<n ; i++) {
					if (_countof(fname) > DragQueryFile((HDROP)wParam, i, fname, _countof(fname))) {
                        len = GetWindowTextLength( hEdit );
						if ( len > 0 ) { // łɕ񂪓Ăꍇ́AɃXy[XorsĂǉ
							buf = (char *)malloc( len + lstrlen(fname) + 3 );
							if ( buf ) {
								GetWindowText( hEdit, buf, len+1 );
								lstrcat(buf, nBox == 1 ? "\r\n" : " ");
								lstrcat(buf, fname);
								SetWindowText(hEdit, buf);
								safefree( buf );
							}
						}
						else { // ܂񂪓ĂȂꍇ́Â܂ܐݒ
                            SetWindowText(hEdit, fname);
						}
					}
				}
				DragFinish((HDROP)wParam);
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					{
						char *ml2_itemname = NULL, *ml2_itemdata = NULL;
						int len;

						// 1ڂ̒lȂ΃G[
						len = GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT1));
						if ( ml_col1 != NULL && len == 0 ) {
							MessageBox(hDlg, "1ڂɉ͂Ă܂B", "`FbN", MB_OK | MB_ICONSTOP);
							return TRUE;
						}

						// 1ڂ̃f[^擾
						ml2_itemname = (char *)malloc( len+1 );
						if ( ml2_itemname == NULL ) {
							MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂B", "G[", MB_OK | MB_ICONSTOP);
							return TRUE;
						}
                        GetDlgItemText(hDlg, IDC_EDIT1, ml2_itemname, len+1);

						// obt@̃|C^Rs[(̑Oɋobt@͉)
						safefree( ml_itemname );
						ml_itemname = ml2_itemname;

						len = GetWindowTextLength( GetDlgItem(hDlg, IDC_EDIT2) );
						ml2_itemdata = (char *)malloc( len+1 );
						if ( ml2_itemdata ) {
                            GetDlgItemText(hDlg, IDC_EDIT2, ml2_itemdata, len+1);
							safefree( ml_itemdata );
							ml_itemdata = ml2_itemdata;
							EndDialog( hDlg, IDOK );
						}
						else {
							MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂B", "G[", MB_OK | MB_ICONSTOP);
						}
						return TRUE;
					}

				case IDCANCEL:
					EndDialog( hDlg, IDCANCEL );
					return TRUE;

				case IDC_FILE_BROWSE0:
					{
						char fname[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT1, fname, _countof(fname));
						if ( openDialog( hDlg, FILETYPES, fname, _countof(fname), "t@C̑I", NULL ) ) {
							SetDlgItemText(hDlg, IDC_EDIT1, fname);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT1) );
						}
						return TRUE;
					}

				case IDC_FOLDER_BROWSE0:
					{
						char chPutFolder[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT1, chPutFolder, _countof(chPutFolder));
						if ( browseFolder( hDlg, chPutFolder, "tH_̑I" ) ) {
							SetDlgItemText(hDlg, IDC_EDIT1, chPutFolder);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT1) );
						}
						return TRUE;
					}

				case IDC_FILE_BROWSE:
					{
						char fname[MAX_PATH*2] = "";
						HWND hEdit = GetDlgItem(hDlg, IDC_EDIT2);
						
						GetWindowText(hEdit, fname, _countof(fname));
						if ( openDialog( hDlg, FILETYPES, fname, _countof(fname), "t@C̑I", NULL ) ) {
	                        int len = GetWindowTextLength( hEdit );
							if ( len > 0 ) { // łɕ񂪓Ăꍇ́AɉsĂǉ
								char *buf = (char *)malloc( len + lstrlen(fname) + 3 );
								if ( buf ) {
									GetWindowText( hEdit, buf, len+1 );
									lstrcat(buf, "\r\n");
									lstrcat(buf, fname);
									SetWindowText(hEdit, buf);
									safefree( buf );
								}
							}
							else { // ܂񂪓ĂȂꍇ́Â܂ܐݒ
								SetWindowText(hEdit, fname);
							}

							SetFocus(hEdit);
						}
						return TRUE;
					}

				case IDC_FOLDER_BROWSE:
					{
						char chPutFolder[MAX_PATH*2] = "";
						HWND hEdit = GetDlgItem(hDlg, IDC_EDIT2);

						GetWindowText(hEdit, chPutFolder, _countof(chPutFolder));
						if ( browseFolder( hDlg, chPutFolder, "tH_̑I" ) ) {
	                        int len = GetWindowTextLength( hEdit );
							if ( len > 0 ) { // łɕ񂪓Ăꍇ́AɉsĂǉ
								char *buf = (char *)malloc( len + lstrlen(chPutFolder) + 3 );
								if ( buf ) {
									GetWindowText( hEdit, buf, len+1 );
									lstrcat(buf, "\r\n");
									lstrcat(buf, chPutFolder);
									SetWindowText(hEdit, buf);
									safefree( buf );
								}
							}
							else { // ܂񂪓ĂȂꍇ́Â܂ܐݒ
								SetWindowText(hEdit, chPutFolder);
							}

							SetFocus(hEdit);
						}
						return TRUE;
					}
			}
			break;
	}
    return FALSE;
}

// ------------------------------------------------------------------------------------------------
// ValueList(key:1-value:n)
// ------------------------------------------------------------------------------------------------
int m_n, m_columns;
char **m_means;

// KeyList̒ǉEҏW ( n:ҏWڔԍB-1w肷ƐVK쐬 )
bool lv_edititem_n( HWND hWndParent, HWND hwndListView, int n, char **means )
{
	ml_hListView = hwndListView;
	m_n = n;
	m_means = means;

	for(m_columns=0 ; means[m_columns] ; ++m_columns)
		;

	return (IDOK == DialogBox(hInst, (LPCTSTR)IDD_EDIT_LV2, hWndParent, (DLGPROC)lvneDialog));
}

// KeyList̒ǉEҏW_CAO
static LRESULT CALLBACK lvneDialog( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	static HWND *edit_controls = NULL;
	static HWND *hBrowseButtons = NULL;
	static SIZEDLG *sizedlg;

	switch( message ) {
		case WM_INITDIALOG:
			edit_controls = NULL;
			hBrowseButtons = NULL;
			ml_itemname = NULL;

			// ݂́A_CAO MS P SVbNŌŒ
			// SetChildWindowFont( hDlg );

			// _CAÕACRݒ
			SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)hIconInputText);

			if ( m_n == -1 ) {
				SetWindowText(hDlg, "VK");
			}
			{
				HWND hTooltip;
				TOOLINFO ti;

				if (NULL == (hTooltip=CreateWindow(TOOLTIPS_CLASS,"",TTS_ALWAYSTIP,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,hDlg,NULL,hInst,NULL)))
					return NULL;

				ZeroMemory(&ti, sizeof(ti));
				ti.cbSize = sizeof(TOOLINFO);
				ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;// uID̓c[`bv\EBhEʂnh / TuNXC
				ti.hwnd = hDlg;	// c[`bvEBhE

				ti.lpszText = "t@Cꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FILE_BROWSE0);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FILE_BROWSE);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "tH_ꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FOLDER_BROWSE0);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDC_FOLDER_BROWSE);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "͂eŌ肵A_CAO܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDOK);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				ti.lpszText = "͂eLZA_CAO܂";// `bv
				ti.uId=(UINT_PTR)GetDlgItem(hDlg, IDCANCEL);
				SendMessage(hTooltip,TTM_ADDTOOL,0,(LPARAM)&ti);

				if ( m_n >= 0 ) { // uVK쐬vłȂƂmF
					char *pbuf = lvGetItemString( ml_hListView, m_n, 0 );

					if ( pbuf ) {
						SetDlgItemText( hDlg, IDC_EDIT1, pbuf ); // edit controlɕҏW镶Zbg
						ml_itemname = pbuf; // [OK]ꂽƂɔr̂łƂĂ
					}
					else {
						MessageBox( hDlg, "ҏWJn邽߂̃܂B", "G[", MB_OK | MB_ICONSTOP );
						EndDialog( hDlg, IDCANCEL );
                        return TRUE;
					}
				}
				else {
					ml_itemname = NULL;
				}
				SetDlgItemText( hDlg, IDC_STATIC1, m_means[0] ); // static controlɈӖZbg

				ti.lpszText = m_means[0];// `bv
				ti.uId = (UINT_PTR)GetDlgItem(hDlg, IDC_EDIT1);
				SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
				ti.uId = (UINT_PTR)GetDlgItem(hDlg, IDC_STATIC1);
				SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);

				SendDlgItemMessage(hDlg, IDC_FILE_BROWSE0, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFileBrowse);
				SendDlgItemMessage(hDlg, IDC_FOLDER_BROWSE0, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFolderBrowse);
				SendDlgItemMessage(hDlg, IDC_FILE_BROWSE, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFileBrowse);
				SendDlgItemMessage(hDlg, IDC_FOLDER_BROWSE, BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFolderBrowse);

				if ( m_columns == 1 ) { // 1 staticedit
					DestroyWindow( GetDlgItem(hDlg, IDC_STATIC2) );
					DestroyWindow( GetDlgItem(hDlg, IDC_EDIT2) );
					DestroyWindow( GetDlgItem(hDlg, IDC_FILE_BROWSE) );
					DestroyWindow( GetDlgItem(hDlg, IDC_FOLDER_BROWSE) );
				}
				else if ( m_columns == 2 ) {
					// ҏW{bNXE`[Û߂̔źAɍȂ(NULLɂȂĂ̂ŁA𗘗p)
					if ( m_n >= 0 ) { // uVK쐬vłȂƂmF
						char *pbuf = lvGetItemString( ml_hListView, m_n, 1 );

						if ( pbuf ) {
							SetDlgItemText( hDlg, IDC_EDIT2, pbuf ); // edit controlɕҏW镶Zbg
							safefree( pbuf );
						}
						else {
							MessageBox( hDlg, "ҏWJn邽߂̃܂B", "G[", MB_OK | MB_ICONSTOP );
							EndDialog( hDlg, IDCANCEL );
							return TRUE;
						}
					}
					SetDlgItemText( hDlg, IDC_STATIC2, m_means[1] ); // static controlɈӖZbg

					ti.lpszText = m_means[1];// `bv
					ti.uId = (UINT_PTR)GetDlgItem(hDlg, IDC_EDIT2);
					SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
					ti.uId = (UINT_PTR)GetDlgItem(hDlg, IDC_STATIC2);
					SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
				}
				else { // 3ȏiVstaticeditȂ΂ȂȂj
					RECT  rc, rc2, rc3, rc4;
					POINT pt;	// ScreenToClient() p
					int   height; // 1̃ACe߂鍂istatic+edit+󔒁j
					int   height_static; // static control ̍
					int   height_edit;	// edit control ̍
					int   width; // edit control̉
					int   width_static; // static control̉
					int   x_control; // eҏWRg[̍̍W
					int   x_control_static; // eX^eBbNRg[̍̍W
					int   y_control; // 2Ԗڂstatic control̏̍W
					int   x_button1; // t@CQƃ{^̍W
					int   x_button2; // tH_Qƃ{^̍W
					int   width_button; // Qƃ{^̕
					int   y_edit; // 2Ԗڂstatic controledit control̏̍W̍
					LONG_PTR  lEditStyle; // ҏWRg[̃X^C
					LONG_PTR  lEditStyleEx; // ҏWRg[̊gX^C


					// 2Ԗڂstaticedit̐ݒ
					if ( m_n >= 0 ) { // uVK쐬vłȂƂmF
						char *pbuf = lvGetItemString( ml_hListView, m_n, 1 );

						if ( pbuf ) {
							SetDlgItemText( hDlg, IDC_EDIT2, pbuf ); // edit controlɕҏW镶Zbg
							safefree( pbuf );

							ti.lpszText = m_means[1];// `bv
							ti.uId = (UINT_PTR)GetDlgItem(hDlg, IDC_EDIT2);
							SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
							ti.uId = (UINT_PTR)GetDlgItem(hDlg, IDC_STATIC2);
							SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
						}
						else {
							MessageBox( hDlg, "ҏWJn邽߂̃܂B", "G[", MB_OK | MB_ICONSTOP );
							EndDialog( hDlg, IDCANCEL );
							return TRUE;
						}
					}
					SetDlgItemText( hDlg, IDC_STATIC2, m_means[1] ); // static controlɈӖZbg

					// EBhE̍KvȕcɐL΂B
					// L΂TCYZo
					// ܂́Astatic1static2̊Ԃ̑傫𑪒
					GetWindowRect( GetDlgItem(hDlg, IDC_STATIC1), &rc );
					GetWindowRect( GetDlgItem(hDlg, IDC_STATIC2), &rc2 );
					GetWindowRect( GetDlgItem(hDlg, IDC_FILE_BROWSE), &rc3 );
					GetWindowRect( GetDlgItem(hDlg, IDC_FOLDER_BROWSE), &rc4 );
					height = rc2.top - rc.top;

					// static control̍vZ
					height_static = rc.bottom - rc.top;

					// static control̍̍W
					pt.x = rc.left;
					pt.y = rc.top;
					ScreenToClient(hDlg, &pt);
					x_control_static = pt.x;

					// edit control̍vZ
					GetWindowRect( GetDlgItem(hDlg, IDC_EDIT2), &rc );
					height_edit = rc.bottom - rc.top;

					// eRg[̕vZ
					width = rc.right - rc.left;				// ҏWRg[̕
					width_static = rc2.right - rc2.left;		// p̃Rg[̕
					width_button = rc3.right - rc3.left;

					// eҏWRg[̍̍W
					pt.x = rc.left;
					pt.y = rc.top;
					ScreenToClient(hDlg, &pt);
					x_control = pt.x;

					pt.x = rc3.left;
					pt.y = rc3.top;
					ScreenToClient(hDlg, &pt);
					x_button1 = pt.x;

					pt.x = rc4.left;
					pt.y = rc4.top;
					ScreenToClient(hDlg, &pt);
					x_button2 = pt.x;

					// 2Ԗڂstatic control̏̍W
					pt.x = rc2.left;
					pt.y = rc2.top;
					ScreenToClient(hDlg, &pt);
					y_control = pt.y;

					// 2Ԗڂstatic controledit control̏̍W̍
					GetWindowRect( GetDlgItem(hDlg, IDC_EDIT2), &rc );
					y_edit = rc.top - rc2.top;

					// ҏWRg[̃X^CEgX^Cǂݏo
					lEditStyle = GetWindowLongPtr(GetDlgItem(hDlg, IDC_EDIT2), GWL_STYLE);
					lEditStyleEx = GetWindowLongPtr(GetDlgItem(hDlg, IDC_EDIT2), GWL_EXSTYLE);

					// 3Ԗڈȍ~static controledit control
					int i;

					edit_controls = (HWND *)calloc( sizeof(HWND), m_columns-2 );
					hBrowseButtons = (HWND *)calloc( sizeof(HWND), (m_columns-1)*2 );
					if ( edit_controls && hBrowseButtons ) {
						hBrowseButtons[0] = GetDlgItem( hDlg, IDC_FILE_BROWSE );
						hBrowseButtons[1] = GetDlgItem( hDlg, IDC_FOLDER_BROWSE ); 
						HWND hStaticCtrl;

						for(i=0 ; i<m_columns-2 ; i++) {
							// static control̍쐬
							hStaticCtrl = CreateWindow( WC_EDIT, m_means[i+2], ES_AUTOHSCROLL|ES_READONLY|WS_CHILD|WS_VISIBLE|SS_LEFT, x_control_static, y_control+height*(i+1), width_static, height_static, hDlg, (HMENU)IDNO, hInst, NULL);
							if ( hStaticCtrl )
								SendMessage(hStaticCtrl, WM_SETFONT, (WPARAM)(HFONT)GetStockObject(DEFAULT_GUI_FONT), (LPARAM)FALSE);

							char *pbuf = NULL;

							if (m_n >= 0) { // VKڂ̍쐬łȂ
								pbuf = lvGetItemString( ml_hListView, m_n, i+2 );
								if ( pbuf == NULL ) {
									MessageBox( hDlg, "ҏWJn邽߂̃܂B", "G[", MB_OK | MB_ICONSTOP );
									EndDialog( hDlg, IDCANCEL );
									return TRUE;				
								}
							}
								
							// edit control̍쐬
							edit_controls[i] = CreateWindowEx( (DWORD)lEditStyleEx, WC_EDIT, pbuf?pbuf:"", (DWORD)lEditStyle, x_control, y_control+height*(i+1)+y_edit, width, height_edit, hDlg, (HMENU)IDNO, hInst, NULL);
							if ( edit_controls[i] ) {
								SendMessage(edit_controls[i], WM_SETFONT, (WPARAM)(HFONT)GetStockObject(DEFAULT_GUI_FONT), (LPARAM)FALSE);

								ti.lpszText = m_means[i+2];// `bv
								ti.uId = (UINT_PTR)edit_controls[i];
								SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
								ti.uId = (UINT_PTR)hStaticCtrl;
								SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);

								// BS_ICON X^CtCreateWindow
								hBrowseButtons[2+i*2] = CreateWindow( WC_BUTTON, "t@C̎Q...", WS_CHILD|WS_VISIBLE|WS_TABSTOP|BS_PUSHBUTTON|BS_ICON, x_button1, y_control+height*(i+1)+y_edit, width_button, height_edit, hDlg, (HMENU)IDC_FILE_BROWSE, hInst, NULL);
								if ( hBrowseButtons[i*2] ) {
									SendMessage(hBrowseButtons[2+i*2], WM_SETFONT, (WPARAM)(HFONT)GetStockObject(DEFAULT_GUI_FONT), (LPARAM)FALSE);
									SendMessage(hBrowseButtons[2+i*2], BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFileBrowse);

									ti.uId = (UINT_PTR)hBrowseButtons[2+i*2];
									ti.lpszText = "t@Cꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
									SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
								}

								hBrowseButtons[2+i*2+1] = CreateWindow( WC_BUTTON, "tH_̎Q...", WS_CHILD|WS_VISIBLE|WS_TABSTOP|BS_PUSHBUTTON|BS_ICON, x_button2, y_control+height*(i+1)+y_edit, width_button, height_edit, hDlg, (HMENU)IDC_FOLDER_BROWSE, hInst, NULL);
								if ( hBrowseButtons[i*2+1] ) {
									SendMessage(hBrowseButtons[2+i*2+1], WM_SETFONT, (WPARAM)(HFONT)GetStockObject(DEFAULT_GUI_FONT), (LPARAM)FALSE);
									SendMessage(hBrowseButtons[2+i*2+1], BM_SETIMAGE, IMAGE_ICON, (LPARAM)hIconFolderBrowse);

									ti.uId = (UINT_PTR)hBrowseButtons[2+i*2+1];
									ti.lpszText = "tH_ꗗ̒IсA̕ҏW{bNXɑ܂";// `bv
									SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
								}
							}
						}
						GetWindowRect(hDlg, &rc);
						SetWindowPos(hDlg, 0, 0, 0, rc.right-rc.left, rc.bottom-rc.top + height*i, SWP_NOMOVE | SWP_NOOWNERZORDER);

						// OK{^̈ړ
						GetWindowRect( GetDlgItem( hDlg, IDOK ), &rc );
						pt.x = rc.left;
						pt.y = rc.top;
						ScreenToClient( hDlg, &pt );
						SetWindowPos(GetDlgItem( hDlg, IDOK ), HWND_BOTTOM, pt.x, pt.y + height*i, 0, 0, SWP_NOSIZE );
						
						// Canecl{^̈ړ
						GetWindowRect( GetDlgItem( hDlg, IDCANCEL ), &rc );
						pt.x = rc.left;
						pt.y = rc.top;
						ScreenToClient( hDlg, &pt );
						SetWindowPos(GetDlgItem( hDlg, IDCANCEL ), HWND_BOTTOM, pt.x, pt.y + height*i, 0, 0, SWP_NOSIZE );
					}
				}
			}

			// EBhENCAgGAֈړ
			{ // ʒɃ_CAOړ
				RECT rct;

				GetWindowRect(hDlg, &rct);	// ݂̃_CAÖʒu𓾂āATCYvZ
				rct.right -= rct.left;
				rct.bottom -= rct.top;
				rct.left = (GetSystemMetrics(SM_CXMAXIMIZED) - rct.right) / 2;
				rct.top = (GetSystemMetrics(SM_CYMAXIMIZED) - rct.bottom) / 2;
				MoveWindow(hDlg, rct.left, rct.top, rct.right, rct.bottom, TRUE);
			}

			// _CAÕRg[̃AJ[o^
			sizedlg = new SIZEDLG(hDlg, dlgitems);
			if (sizedlg) {
				int i;
				// ǉ̕ҏW{bNXEI{^TCYNXɓo^
				for(i=0 ; i<m_columns-2 ; ++i) {
					sizedlg->Add(edit_controls [i], ANCHOR_TOPLEFTRIGHT);
				}
				for(i=1 ; i<m_columns-1 ; ++i) {
					sizedlg->Add(hBrowseButtons[i*2  ], ANCHOR_TOPRIGHT);
					sizedlg->Add(hBrowseButtons[i*2+1], ANCHOR_TOPRIGHT);
				}

				// cTCY̓TCYȂ悤ɐݒ
				sizedlg->SetMinMaxInfo(sizedlg->GetDefWidth(), sizedlg->GetDefHeight(), -1, sizedlg->GetDefHeight());
			}
			return TRUE;

		case WM_DESTROY:
			// ҏW{bNX̃nhׂꂽj
			safefree( edit_controls );
			// ACRĂ{^j
			DestroyWindow(GetDlgItem(hDlg, IDC_FILE_BROWSE0));
			DestroyWindow(GetDlgItem(hDlg, IDC_FOLDER_BROWSE0));
			if ( hBrowseButtons ) {
				for(int i=0 ; i<(m_columns-1)*2 ; ++i) {
					if ( hBrowseButtons[i] ) {
						DestroyWindow( hBrowseButtons[i] );
					}
				}
				safefree( hBrowseButtons );
			}

			// TCŶ߂̏j
			if (sizedlg) {
				delete sizedlg;
				sizedlg = NULL;
			}
			return TRUE;

		case WM_GETMINMAXINFO:
			// _CAO̍ŏTCY߂
			if (sizedlg) {
				sizedlg->GetMinMaxInfo(lParam);
			}
			return TRUE;

		case WM_SIZE:
			// TCY
			if (sizedlg) {
				sizedlg->Resize(1);
			}
			return TRUE;

		case WM_DROPFILES: // ҏW{bNXt@Chbvꂽ
			{
				int n; // hbvꂽt@C̐
				int i; // JE^
				int len; // ҏW{bNXɂłɑ݂镶̃oCg
				char fname[MAX_PATH*2];
				char *buf;
				POINT pt;
				HWND hEdit = NULL; // ꂩ悤ƂҏW{bNX
				RECT rt;

				GetCursorPos( &pt );

				// hbvƂ̃}EẌʒuŁAǂ̃GfBbg{bNXւ̃hbv𔻒
				if ( m_columns == 1 ) {
					// PҏW{bNXȂꍇ
					hEdit = GetDlgItem(hDlg, IDC_EDIT1);
				}
				else if ( m_columns == 2 ) { // Q̕ҏW{bNXꍇ
					GetWindowRect(GetDlgItem(hDlg, IDC_STATIC2), &rt);
					// hbvƂ̃}EẌʒuAQ߂̃X^eBbNeLXgゾ
					if ( pt.y < rt.top ) { // P߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
						hEdit = GetDlgItem(hDlg, IDC_EDIT1);
					}
					else {  // łȂ΁AQ߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
						hEdit = GetDlgItem(hDlg, IDC_EDIT2);
					}
				}
				else { // Rȏ̕ҏW{bNXꍇ
					// X^eBbNeLXg̈ʒuɁAǂ̕ҏW{bNXւ̃hbv𔻒肷
					for(i=m_columns-2-1 ; i>=0 ; i--) {
						GetWindowRect(edit_controls[i], &rt);
						if ( pt.y >= rt.top ) {
							hEdit = edit_controls[i];
                            break;
						}
					}
					if ( !hEdit ) {
						GetWindowRect(GetDlgItem(hDlg, IDC_STATIC2), &rt);
						// hbvƂ̃}EẌʒuAQ߂̃X^eBbNeLXgゾ
						if ( pt.y < rt.top ) { // P߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
							hEdit = GetDlgItem(hDlg, IDC_EDIT1);
						}
						else {  // łȂ΁AQ߂̕ҏW{bNXւ̃hbvƂ݂Ȃ
							hEdit = GetDlgItem(hDlg, IDC_EDIT2);
						}
					}
				}

				n = DragQueryFile((HDROP)wParam, (UINT)-1, NULL, 0);
				for(i=0 ; i<n ; i++) {
					if (_countof(fname) > DragQueryFile((HDROP)wParam, i, fname, MAX_PATH)) {
                        len = GetWindowTextLength( hEdit );
						if ( len > 0 ) { // łɕ񂪓Ăꍇ́AɃXy[XĂǉ
							buf = (char *)malloc( len + lstrlen(fname) + 2 );
							if ( buf ) {
								GetWindowText( hEdit, buf, len+1 );
								lstrcat(buf, " ");
								lstrcat(buf, fname);
								SetWindowText(hEdit, buf);
								safefree( buf );
							}
						}
						else { // ܂񂪓ĂȂꍇ́Â܂ܐݒ
                            SetWindowText(hEdit, fname);
						}
					}
				}
				SetFocus(hEdit);

				DragFinish((HDROP)wParam);
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					{
						char *ml2_itemname;
						int len;

						len = GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT1));
						if ( len == 0 ) {
							MessageBox(hDlg, "1ڂɉ͂Ă܂B","`FbN",MB_OK | MB_ICONSTOP);
							return TRUE;
						}

						// 1ڂǂݏo
						ml2_itemname = (char *)calloc( len+1, 1 );
						if ( ml2_itemname == NULL ) {
							MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂B", "G[", MB_OK | MB_ICONSTOP);
							return TRUE;
						}
						GetDlgItemText(hDlg, IDC_EDIT1, ml2_itemname, len+1);

						if ( ml_itemname && _stricmp(ml2_itemname, ml_itemname) == 0 )
							;// 1ڂɕωȂ΁A1ڂɂĂ͂̂܂
						else {// ωꍇ́Ȃ1ڂƂ̏dȂ`FbN
							int i, n;
							char *iname;

							iname = (char *)malloc( len+2 );// ݂̑1ڂꕶ߂ɒׂ΂悢
							if ( iname ) {
								n = ListView_GetItemCount( ml_hListView );
								
								for(i=0 ; i<n ; i++) {
									ListView_GetItemText( ml_hListView, i, 0, iname, len+2 );
									if ( _stricmp(iname, ml2_itemname) == 0 ) {
										MessageBox(hDlg, "1ڂAXg̑̍ڂƏdĂ܂B","`FbN",MB_OK | MB_ICONSTOP);
										safefree(ml2_itemname);
										safefree(iname);
										return TRUE;
									}
								}
							}
							else {
								safefree(ml2_itemname);
								MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂B", "G[", MB_OK | MB_ICONSTOP);
								return TRUE;
							}
						}

						// obt@EVobt@͉
						safefree(ml_itemname);
						safefree(ml2_itemname);
						{
							int i;

							if ( m_n == -1 ) { // VK쐬
								LVITEM lvitem;

								m_n = ListView_GetItemCount( ml_hListView );
								ListView_SetItemCount(ml_hListView, m_n+1);
								lvitem.mask = LVIF_TEXT;
								lvitem.iItem = m_n;
								lvitem.iSubItem = 0;
								lvitem.pszText = "";
								ListView_InsertItem(ml_hListView, &lvitem);
								ListView_SetItemState(ml_hListView, m_n, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
							}

							for(i=0 ; i<m_columns ; i++) {
								HWND hEdit;
								int  bufsize;
								char *pbuf;

								if ( i == 0 ) {
									hEdit = GetDlgItem(hDlg, IDC_EDIT1);
								}
								else if ( i == 1 ) {
									hEdit = GetDlgItem(hDlg, IDC_EDIT2);
								}
								else {
									hEdit = edit_controls[i-2];
								}

								bufsize = GetWindowTextLength(hEdit);
								pbuf = (char *)malloc( bufsize+1 );
								if ( pbuf ) {
									GetWindowText(hEdit, pbuf, bufsize+1);
									ListView_SetItemText( ml_hListView, m_n, i, pbuf);
									safefree(pbuf);
								}
								else {
									MessageBox(hDlg, "f[^̕ۑɕKvȃmۂł܂łBꕔ̃f[^͎܂B", "G[", MB_OK | MB_ICONSTOP);
									return TRUE;
								}
							}
						}

						EndDialog( hDlg, IDOK );
						return TRUE;
					}

				case IDCANCEL:
					EndDialog( hDlg, IDCANCEL );
					return TRUE;

				case IDC_FILE_BROWSE0:
					{
						char fname[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT1, fname, _countof(fname));
						if ( openDialog( hDlg, FILETYPES, fname, _countof(fname), "t@C̑I", NULL ) ) {
							SetDlgItemText(hDlg, IDC_EDIT1, fname);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT1) );
						}
						return TRUE;
					}

				case IDC_FOLDER_BROWSE0:
					{
						char chPutFolder[MAX_PATH*2] = "";

						GetDlgItemText(hDlg, IDC_EDIT1, chPutFolder, _countof(chPutFolder));
						if ( browseFolder( hDlg, chPutFolder, "tH_̑I" ) ) {
							SetDlgItemText(hDlg, IDC_EDIT1, chPutFolder);
							SetFocus( GetDlgItem(hDlg, IDC_EDIT1) );
						}
						return TRUE;
					}

				case IDC_FILE_BROWSE:
					{
						char fname[MAX_PATH*2] = "";
						int  i=0;
						HWND hEdit = NULL;

						if ( hBrowseButtons == NULL || hBrowseButtons[0] == (HWND)lParam ) {
							hEdit = GetDlgItem(hDlg, IDC_EDIT2);
							i = 0;
						}
						else {
							for(i=1 ; i<m_columns-1 ; i++) {
								if ( hBrowseButtons[i*2] == (HWND)lParam ) {
									hEdit = edit_controls[i-1];
									break;
								}
							}
						}
						if ( i < m_columns-1 ) {
							GetWindowText(hEdit, fname, _countof(fname)); // ftHg擾
							if ( openDialog( hDlg, FILETYPES, fname, _countof(fname), "t@C̑I", NULL ) ) {
								SetWindowText( hEdit, fname );
								SetFocus( hEdit );
							}
						}
						return TRUE;
					}

				case IDC_FOLDER_BROWSE:
					{
						char chPutFolder[MAX_PATH*2] = "";
						HWND hEdit = NULL;
						int i = 0;

						if ( hBrowseButtons == NULL || hBrowseButtons[1] == (HWND)lParam ) {
							hEdit = GetDlgItem(hDlg, IDC_EDIT2);
						}
						else {
							for(i=1 ; i<m_columns-1 ; i++) {
								if ( hBrowseButtons[i*2+1] == (HWND)lParam ) {
									hEdit = edit_controls[i-1];
									break;
								}
							}
						}

						if ( i < m_columns-1 ) {
							GetWindowText(hEdit, chPutFolder, _countof(chPutFolder)); // ftHg擾
							if( browseFolder( hDlg, chPutFolder, "tH_̑I" ) ) {
								SetWindowText(hEdit, chPutFolder);
								SetFocus( hEdit );
							}
						}
						return TRUE;
					}
			}
			break;
	}
    return FALSE;
}
