#include "stdafx.h"
#include "context.h"
#include "openarc.h"
#include "r7manifest.h"

// Oϐ錾
HINSTANCE hInst;								// ̃vÕCX^X
const char *szTitle = "Ext.CCM for Rnsf7";		// ̃vÕEBhE^Cg
//#ifndef _WIN64
//	BOOL  isNT;										// OS
//#endif /* _WIN64 */
WORD  winver;									// OSo[W

// vg^Cv錾
void EasySkrx( const char *path );
void AddApplicationPath( const char *path );
bool setWallPaper( char *bmp );
bool tChangeFileTimeDate( const char *fname );
bool showMD5file( const char *fname );
bool tCopyClipboard( const char *text );
bool t2CopyClipboard( const char *text );
bool CompareFiles( char *fname1 );

bool OpenExtractor( const char *arcfile, int oetype );
bool OpenExtractorDir( const char *arcfile, int oetype );
bool OpenExtractorDesktop( const char *arcfile, int oetype );
bool OpenExtractorCD( const char *arcfile, int oetype );
bool OpenExtractorOwnDir( const char *arcfile, int oetype );
bool makeCompressIcon( void );
bool ExpandLzh( const char *arcfile, const char *folder );
bool ExpandZip( const char *arcfile, const char *folder );
bool Expand7Zip( const char *arcfile, const char *folder );
bool makeShortcutIcon( const char *szShortcutName, const char *szParam, int iIconNum );

// Expand*** ֐ւ̔z
bool (*ExpandFunctions[3])( const char *arcfile, const char *folder ) = { ExpandLzh, ExpandZip, Expand7Zip };

LRESULT CALLBACK FTimeProc(HWND, UINT, WPARAM, LPARAM);

// XLbvXy[XłȂȂ邩Ԃ
int skipSpace( const char *cline )
{
	int i = 0;

	for(i=0 ; cline[i] == ' ' || cline[i] == '\t' ; i++)
		;

	if ( cline[i] ) {
		return i;
	}
	else {
		return -1;
	}
}

// ShellExecutẽG[󂯎聕G[bZ[Wo
// G[ĂȂꍇ́AsȂ
HINSTANCE SHE(HWND hWnd, HINSTANCE hInstSE)
{
	if ( (HINSTANCE)32 > hInstSE ) {
		char *pmes;
#pragma warning( disable:4311 )
		switch ( (UINT)hInstSE ) {
#pragma warning( default:4311 )
			case 0:
				pmes = "vOJnł܂B\n\nF܂̓\[XsĂ܂B";
				break;
			case SE_ERR_OOM:
				pmes = "vOJnł܂B\n\nFƂ邽߂̃܂B";
				break;
			case ERROR_FILE_NOT_FOUND:
				pmes = "vOJnł܂B\n\nFw肳ꂽt@C܂̓tH_܂łBV[gJbgw肳ꂽꍇAV[gJbg̃t@C܂̓tH_܂łB";
				break;
			case ERROR_PATH_NOT_FOUND:
				pmes = "vOJnł܂B\n\nFw肳ꂽpX܂łB";
				break;
			case ERROR_BAD_FORMAT:
				pmes = "vOJnł܂B\n\nFst@CłB";
				break;
			case SE_ERR_ACCESSDENIED:
				pmes = "vOJnł܂B\n\nFANZXۂ܂B";
				break;
			case SE_ERR_ASSOCINCOMPLETE:
				pmes = "vOJnł܂B\n\nFt@C̊֘AtsS܂͖łB";
				break;
			case SE_ERR_DDEBUSY:
			case SE_ERR_DDEFAIL:
			case SE_ERR_DDETIMEOUT:
				pmes = "vOJnł܂B\n\nFDDEG[B";
				break;
			case SE_ERR_DLLNOTFOUND:
				pmes = "vOJnł܂B\n\nFw肳ꂽDLL܂łB";
				break;
			case SE_ERR_NOASSOC:
				pmes = "vOJnł܂B\n\nFw肳ꂽgqɊ֘AtꂽvO܂B";
				break;
			case SE_ERR_SHARE:
				pmes = "vOJnł܂B\n\nFLᔽ܂B";
				break;
			default:
				pmes = "vOJnł܂B\n\nFsȃG[܂B";
				break;
		}
		MessageBox(hWnd, pmes, "vOsG[", MB_OK | MB_ICONSTOP);
	}

	return hInstSE;
}

char getFreeDrive()
{
	char rootpath[4] = "Z:\\";

	// ZhCutɑA݂ȂhCu𒲂ׂ
	for(rootpath[0]='Z' ; rootpath[0]>='A' ; --rootpath[0]) {
		if (DRIVE_NO_ROOT_DIR == GetDriveType(rootpath)) {
			return rootpath[0];
		}
	}

	return 0;
}

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE, LPTSTR lpCmdLine, int)
{
	hInst = hInstance;

#if _MSC_VER < 1500
#ifndef _WIN64
	isNT = tf_isNT();
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
	winver = tf_getWinVer();

	if ( lpCmdLine == NULL || lpCmdLine[0] == 0 ) {
		MessageBox( NULL, "̃vÓu[v(Rnsf7.exe)ԐړIɌĂяo܂B", szTitle, MB_OK | MB_ICONINFORMATION );
		return 1;
	}
	else if ( lpCmdLine[0] == '/' ) {
		// GNXv[Drag&DropiVistaȏUACgĂƁAbZ[WtB^̂Łj
		enableDropFiles();

		int i;
		// -------------------------------------------------------------------------
		if ( 0 == _stricmp(lpCmdLine, "/SHUTDOWN") ) {
			GetQuitRight();
			return ExitWindowsEx(EWX_SHUTDOWN | EWX_POWEROFF, 0)?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:SHUTDOWN") ) {
			if (IDOK == MessageBox(NULL, "WindowsI܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return ExitWindowsEx(EWX_SHUTDOWN | EWX_POWEROFF, 0)?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:SHUTDOWN") ) {
			return makeShortcutIcon("Windows̏I", "/A:SHUTDOWN", -138) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/REBOOT") ) {
			GetQuitRight();
			return ExitWindowsEx(EWX_REBOOT, 0)?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:REBOOT") ) {
			if (IDOK == MessageBox(NULL, "WindowsċN܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return ExitWindowsEx(EWX_REBOOT, 0)?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:REBOOT") ) {
			return makeShortcutIcon("Windows̍ċN", "/A:REBOOT", -137) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/LOGOFF") ) {
			GetQuitRight();
			return ExitWindowsEx(EWX_LOGOFF, 0)?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:LOGOFF") ) {
			if (IDOK == MessageBox(NULL, "OIt܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return ExitWindowsEx(EWX_LOGOFF, 0)?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:LOGOFF") ) {
			return makeShortcutIcon("OIt", "/A:LOGOFF", -136) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/SUSPEND") ) {
			GetQuitRight();
			return SetSystemPowerState( TRUE, FALSE )?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:SUSPEND") ) {
			if (IDOK == MessageBox(NULL, "TXyh܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return SetSystemPowerState( TRUE, FALSE )?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:SUSPEND") ) {
			return makeShortcutIcon("TXyh", "/A:SUSPEND", -135) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/HIBERNATION") || 0 == _stricmp(lpCmdLine, "/STANDBY") ) {
			GetQuitRight();
			return SetSystemPowerState( FALSE, FALSE )?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:HIBERNATION") ) {
			if (IDOK == MessageBox(NULL, "x~Ԃֈڍs܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return SetSystemPowerState( FALSE, FALSE )?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:STANDBY") ) {
			if (IDOK == MessageBox(NULL, "X^oCԂֈڍs܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return SetSystemPowerState( FALSE, FALSE )?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:HIBERNATION") ) {
			return makeShortcutIcon("x~Ԃ", "/A:HIBERNATION", -135) ? 0 : 1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:STANDBY") ) {
			return makeShortcutIcon("X^oC", "/A:STANDBY", -135) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/SHUTDOWN FORCE") ) {
			GetQuitRight();
			return ExitWindowsEx(EWX_SHUTDOWN | EWX_POWEROFF | EWX_FORCE, 0)?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:SHUTDOWN FORCE") ) {
			if (IDOK == MessageBox(NULL, "WindowsI܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return ExitWindowsEx(EWX_SHUTDOWN | EWX_POWEROFF | EWX_FORCE, 0)?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:SHUTDOWN FORCE") ) {
			return makeShortcutIcon("Windows̏I()", "/A:SHUTDOWN FORCE", -138) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/REBOOT FORCE") ) {
			GetQuitRight();
			return ExitWindowsEx(EWX_REBOOT | EWX_FORCE, 0)?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:REBOOT FORCE") ) {
			if (IDOK == MessageBox(NULL, "WindowsċN܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return ExitWindowsEx(EWX_REBOOT | EWX_FORCE, 0)?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:REBOOT FORCE") ) {
			return makeShortcutIcon("Windows̍ċN()", "/A:REBOOT FORCE", -137) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/LOGOFF FORCE") ) {
			GetQuitRight();
			return ExitWindowsEx(EWX_LOGOFF | EWX_FORCE, 0)?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:LOGOFF FORCE") ) {
			if (IDOK == MessageBox(NULL, "WindowsOIt܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return ExitWindowsEx(EWX_LOGOFF | EWX_FORCE, 0)?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:LOGOFF FORCE") ) {
			return makeShortcutIcon("OIt()", "/A:LOGOFF FORCE", -136) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/SUSPEND FORCE") ) {
			GetQuitRight();
			return SetSystemPowerState( TRUE, TRUE )?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:SUSPEND FORCE") ) {
			if (IDOK == MessageBox(NULL, "WindowsTXyh܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return SetSystemPowerState( TRUE, TRUE )?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:SUSPEND FORCE") ) {
			return makeShortcutIcon("TXyh()", "/A:SUSPEND FORCE", -135) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/HIBERNATION FORCE") || 0 == _stricmp(lpCmdLine, "/STANDBY FORCE") ) {
			GetQuitRight();
			return SetSystemPowerState( FALSE, TRUE )?0:1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:HIBERNATION FORCE") ) {
			if (IDOK == MessageBox(NULL, "WindowsIɋx~Ԃֈڍs܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return SetSystemPowerState( FALSE, TRUE )?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/A:STANDBY FORCE") ) {
			if (IDOK == MessageBox(NULL, "WindowsIɃX^oCԂֈڍs܂B", szTitle, MB_OKCANCEL | MB_ICONQUESTION)) {
				GetQuitRight();
				return SetSystemPowerState( FALSE, TRUE )?0:1;
			}
			else {
				return 0;
			}
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:HIBERNATION FORCE") ) {
			return makeShortcutIcon("x~Ԃ()", "/A:HIBERNATION FORCE", -135) ? 0 : 1;
		}
		else if ( 0 == _stricmp(lpCmdLine, "/B:STANDBY FORCE") ) {
			return makeShortcutIcon("X^oC()", "/A:STANDBY FORCE", -135) ? 0 : 1;
		}
		// -------------------------------------------------------------------------

		else if ( 0 == _stricmp(lpCmdLine, "/WriteManifestR7 asInvoker") || 0 == _stricmp(lpCmdLine, "/WriteManifestR7 highestAvailable") || 0 == _stricmp(lpCmdLine, "/WriteManifestR7 requireAdministrator") ) {
			SetCurrentDirectoryOwnDir();
			FILE *fp = NULL;

			if (0 == fopen_s(&fp, "RNSF7.EXE.manifest", "wb")) {
				int iWriteSize = fprintf_s(fp, r7manifest_utf8, &lpCmdLine[17]);
				fclose(fp);

				if (iWriteSize == 0) {
					return 1;
				}
			}
			else {
				return 1;
			}

			return 0;
		}
		else if ( 0 == _strnicmp(lpCmdLine, "/SUBST:", 7) ) {

			// 󂫃hCu𒲂ׂ
			char freedrive = getFreeDrive();

			if (freedrive == 0) {
				MessageBox(NULL, "󂫃hCu܂(/SUBST)", szTitle, MB_OK | MB_ICONSTOP);
				return 1;
			}
			else {
				const char *targetdir = &lpCmdLine[7];
				char subst_param[1025];

				wsprintf(subst_param, "/C SUBST %c: \"%s\"&IF ERRORLEVEL 1 PAUSE", freedrive, targetdir);
				SHE(NULL, ShellExecute(NULL, "open", "CMD.EXE", subst_param, ".", SW_SHOWNORMAL));
				return 0;
			}
		}
		else {
			switch ( lpCmdLine[1] ) {
				case 'A':
				case 'a': // AvP[VpXɓo^
					if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
						MessageBox( NULL, "p^̉͂Ɏs܂(/A)B", szTitle, MB_OK | MB_ICONSTOP );
						return 1;
					}			
					AddApplicationPath(&lpCmdLine[2+i]);
					break;

				case 'X':
				case 'x': // ȈՂs
					if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
						MessageBox( NULL, "p^̉͂Ɏs܂(/X)B", szTitle, MB_OK | MB_ICONSTOP );
						return 1;
					}			
					EasySkrx(&lpCmdLine[2+i]);
					break;

				case 'W':
				case 'w': // ǎɐݒ肷
					if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
						MessageBox( NULL, "p^̉͂Ɏs܂(/W)B", szTitle, MB_OK | MB_ICONSTOP );
						return 1;
					}			
					setWallPaper( &lpCmdLine[2+i] );
					break;

				case 'T':
				case 't': // t@C̕ύX
					if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
						MessageBox( NULL, "p^̉͂Ɏs܂(/T)B", szTitle, MB_OK | MB_ICONSTOP );
						return 1;
					}			
					tChangeFileTimeDate( &lpCmdLine[2+i] );
					break;

				case '5': // MD5̎Zo
					if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
						MessageBox( NULL, "p^̉͂Ɏs܂(/5)B", szTitle, MB_OK | MB_ICONSTOP );
						return 1;
					}
					CoInitialize( NULL );
					showMD5file( &lpCmdLine[2+i] );
					CoUninitialize();
					break;

				case 'C':
				case 'c':
					switch ( lpCmdLine[2] ) {
						case 'P':
						case 'p': // PɃNbv{[hփRs[
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/CP)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							tCopyClipboard( &lpCmdLine[3+i] );
							break;

						case 'D':
						case 'd': // \2dɂăNbv{[hփRs[
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/CD)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							t2CopyClipboard( &lpCmdLine[3+i] );
							break;

						case 'A':
						case 'a': // k_CAOJ
							OpenArchiver();
							break;

						case 'M':
						case 'm': // r_CAOJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/CM)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}
							CoInitialize( NULL );
							CompareFiles( &lpCmdLine[3+i] );
							CoUninitialize();
							break;
					}
					break;

				case 'L':
				case 'l': // LZHWJ
#ifdef _WIN64
					{
						// 64bit DLLȂꍇ́A32bitcontext.exeďoA32bit DLLs
						int rv_dll = call_unlha32(NULL, NULL);

						if (rv_dll == T_TF_DLLNOTFOUND || rv_dll == T_TF_ILLEGALDLL) {
							char exename[MAX_PATH * 2];
							char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], fname[_MAX_FNAME*2];
							char *new_fname;

							GetModuleFileName(NULL, exename, _countof(exename));
							_splitpath_s(exename, drv, _countof(drv), dir, _countof(dir), fname, _countof(fname), NULL, 0);
							if (lstrcmpi(fname, "context_noadm") == 0) {
								new_fname = "context_x86_noadm";
							}
							else {
								new_fname = "context_x86";
							}
							_makepath_s(exename, _countof(exename), drv, dir, new_fname, ".exe");

							SHE(NULL, ShellExecute(NULL, "open", exename, lpCmdLine, ".", SW_SHOWNORMAL));
							break;
						}
					}
#endif /* _WIN64 */
					switch ( lpCmdLine[2] ) {
						case 'H':
						case 'h': // 炩ߎw肳ꂽtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/LH)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractor( &lpCmdLine[3+i], OET_LZH );
							break;

						case 'D':
						case 'd': // ꂩtH_w肵ēWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/LD)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorDir( &lpCmdLine[3+i], OET_LZH );
							break;

						case 'A':
						case 'a': // fXNgbvɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/LA)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorDesktop( &lpCmdLine[3+i], OET_LZH );
							break;

						case 'C':
						case 'c': // JgtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/LC)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorCD( &lpCmdLine[3+i], OET_LZH );
							break;

						case 'X':
						case 'x': // ̃vÕJgtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/LX)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorOwnDir( &lpCmdLine[3+i], OET_LZH );
							break;
					}
					break;

				case 'Z':
				case 'z': // ZIPWJ
#ifdef _WIN64
					{
						// 64bit DLLȂꍇ́A32bitcontext.exeďoA32bit DLLs
						int rv_dll = call_unzip32(NULL, NULL);

						if (rv_dll == T_TF_DLLNOTFOUND || rv_dll == T_TF_ILLEGALDLL) {
							char exename[MAX_PATH * 2];
							char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], fname[_MAX_FNAME*2];
							char *new_fname;

							GetModuleFileName(NULL, exename, _countof(exename));
							_splitpath_s(exename, drv, _countof(drv), dir, _countof(dir), fname, _countof(fname), NULL, 0);
							if (lstrcmpi(fname, "context_noadm") == 0) {
								new_fname = "context_x86_noadm";
							}
							else {
								new_fname = "context_x86";
							}
							_makepath_s(exename, _countof(exename), drv, dir, new_fname, ".exe");

							SHE(NULL, ShellExecute(NULL, "open", exename, lpCmdLine, ".", SW_SHOWNORMAL));
							break;
						}
					}
#endif /* _WIN64 */
					switch ( lpCmdLine[2] ) {
						case 'I':
						case 'i': // 炩ߎw肳ꂽtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/ZI)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractor( &lpCmdLine[3+i], OET_ZIP );
							break;

						case 'D':
						case 'd': // ꂩtH_w肵ēWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/ZD)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorDir( &lpCmdLine[3+i], OET_ZIP );
							break;

						case 'A':
						case 'a': // fXNgbvɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/ZA)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorDesktop( &lpCmdLine[3+i], OET_ZIP );
							break;

						case 'C':
						case 'c': // JgtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/ZC)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorCD( &lpCmdLine[3+i], OET_ZIP );
							break;

						case 'X':
						case 'x': // ̃vÕJgtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/ZX)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorOwnDir( &lpCmdLine[3+i], OET_ZIP );
							break;
					}
					break;

				case '7': // 7ZipWJ
#ifdef _WIN64
					{
						// 64bit DLLȂꍇ́A32bitcontext.exeďoA32bit DLLs
						int rv_dll = call_7zip32(NULL, NULL);

						if (rv_dll == T_TF_DLLNOTFOUND || rv_dll == T_TF_ILLEGALDLL) {
							char exename[MAX_PATH * 2];
							char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], fname[_MAX_FNAME*2];
							char *new_fname;

							GetModuleFileName(NULL, exename, _countof(exename));
							_splitpath_s(exename, drv, _countof(drv), dir, _countof(dir), fname, _countof(fname), NULL, 0);
							if (lstrcmpi(fname, "context_noadm") == 0) {
								new_fname = "context_x86_noadm";
							}
							else {
								new_fname = "context_x86";
							}
							_makepath_s(exename, _countof(exename), drv, dir, new_fname, ".exe");

							SHE(NULL, ShellExecute(NULL, "open", exename, lpCmdLine, ".", SW_SHOWNORMAL));
							break;
						}
					}
#endif /* _WIN64 */

					switch ( lpCmdLine[2] ) {
						case 'I':
						case 'i': // 炩ߎw肳ꂽtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/7I)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractor( &lpCmdLine[3+i], OET_7Z );
							break;

						case 'D':
						case 'd': // ꂩtH_w肵ēWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/7D)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorDir( &lpCmdLine[3+i], OET_7Z );
							break;

						case 'A':
						case 'a': // fXNgbvɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/7A)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorDesktop( &lpCmdLine[3+i], OET_7Z );
							break;

						case 'C':
						case 'c': // JgtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/7C)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorCD( &lpCmdLine[3+i], OET_7Z );
							break;

						case 'X':
						case 'x': // ̃vÕJgtH_ɓWJ
							if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/7X)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}			
							OpenExtractorOwnDir( &lpCmdLine[3+i], OET_7Z );
							break;
					}
					break;

				case 'M':
				case 'm': // w肵tH_Et@C̈̃tH_ŁADOSvvgR}hvvgJ
					{
						char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], path[MAX_PATH*2];
						int  length;

						if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
							MessageBox( NULL, "p^̉͂Ɏs܂(/M)B", szTitle, MB_OK | MB_ICONSTOP );
							return 1;
						}			
						_splitpath_s( &lpCmdLine[3+i], drv, _countof(drv), dir, _countof(dir), NULL, 0, NULL, 0 );
						_makepath_s( path, _countof(path), drv, dir, NULL, NULL );
						length = lstrlen(path);
						if ( length > 3 && !isKanji1(path,length-2) && path[length-1] == '\\' ) {
							path[length-1] = 0;
						}

						switch ( lpCmdLine[2] ) {
							case 'D': // MS-DOSvvg
							case 'd':
								SHE(NULL, ShellExecute(NULL, "open", "COMMAND.COM", NULL, path, SW_SHOW));
								break;

							case 'C': // R}hvvg
							case 'c':
								SHE(NULL, ShellExecute(NULL, "open", "CMD.EXE", NULL, path, SW_SHOW));
								break;

							case 'P': // lbg[NpX\ŃR}hvvg
							case 'p':
								{
									char pushcmd[1025];
									wsprintf(pushcmd, "/K PUSHD \"%s\"", path);
									SHE(NULL, ShellExecute(NULL, "open", "CMD.EXE", pushcmd, ".", SW_SHOW));
								}
								break;
						}
					}
					break;

				case 'N':
				case 'n': // (context.exeǗғKvȃvOł邱Ƃ𗘗p)Ǘ҂ƂăR}hvvgJ
					if ( -1 == (i = skipSpace( &lpCmdLine[3] )) ) {
						MessageBox( NULL, "p^̉͂Ɏs܂(/N)B", szTitle, MB_OK | MB_ICONSTOP );
						return 1;
					}			

					switch ( lpCmdLine[2] ) {
						case 'D': // MS-DOSvvg
						case 'd':
							SHE(NULL, ShellExecute(NULL, "open", "COMMAND.COM", NULL, &lpCmdLine[3+i], SW_SHOW));
							break;

						case 'C': // R}hvvg
						case 'c':
							SHE(NULL, ShellExecute(NULL, "open", "CMD.EXE", NULL, &lpCmdLine[3+i], SW_SHOW));
							break;

						case 'P': // lbg[NpX\ŃR}hvvg
						case 'p':
							{
								char pushcmd[1025];
								wsprintf(pushcmd, "/K PUSHD \"%s\"", &lpCmdLine[3+i]);
								SHE(NULL, ShellExecute(NULL, "open", "CMD.EXE", pushcmd, ".", SW_SHOW));
							}
							break;

						case 'O': // command.comŔCӂ̃R}hs(/K c PsR}hsɕAȂ)
						case 'o':
							{
								char cmd[1025];
								wsprintf(cmd, "/K %s", &lpCmdLine[3+i]);
								SHE(NULL, ShellExecute(NULL, "open", "COMMAND.COM", cmd, ".", SW_SHOW));
							}
							break;
						case 'A': // cmd.exeŔCӂ̃R}hs(/K c PsR}hsɕAȂ)
						case 'a':
							{
								char cmd[1025];
								wsprintf(cmd, "/K %s", &lpCmdLine[3+i]);
								SHE(NULL, ShellExecute(NULL, "open", "CMD.EXE", cmd, ".", SW_SHOW));
							}
							break;

						case 'L': // command.comŔCӂ̃R}hs(/C c PsR}hsɕA)
						case 'l':
							{
								char cmd[1025];
								wsprintf(cmd, "/C %s", &lpCmdLine[3+i]);
								SHE(NULL, ShellExecute(NULL, "open", "COMMAND.COM", cmd, ".", SW_SHOW));
							}
							break;
						case 'N': // cmd.exeŔCӂ̃R}hs(/C c PsR}hsɕA)
						case 'n':
							{
								char cmd[1025];
								wsprintf(cmd, "/C %s", &lpCmdLine[3+i]);
								SHE(NULL, ShellExecute(NULL, "open", "CMD.EXE", cmd, ".", SW_SHOW));
							}
							break;
					}
					break;

				case 'B': // u-k-vACR쐬
				case 'b':
					CoInitialize( NULL );
					//CoInitializeEx(NULL, COINIT_MULTITHREADED);
					if ( false == makeCompressIcon() ) {
						MessageBox( NULL, "kACR̍쐬Ɏs܂B", szTitle, MB_OK | MB_ICONSTOP );
						CoUninitialize();
						return 1;
					}
					CoUninitialize();
					break;

				case 'I': // V[gJbg̃^[QbguĂtH_J
				case 'i':
				case 'J': // J:tH_\^
				case 'j':
				case 'O': // O:t@CiŌ\Ej͂Ŏ菜^
				case 'o':
					{
						char szLinkFile[MAX_PATH*2], target[MAX_PATH*2];
						char szExplorerOptions[MAX_PATH*2 + 20] = "/E,/SELECT,";
						int  i, iLen;

						if ( lpCmdLine[1] == 'I' || lpCmdLine[1] == 'i' ) {
							lstrcpy( szExplorerOptions, "/E,/SELECT," );
							if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/I)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}
						}
						else if ( lpCmdLine[1] == 'J' || lpCmdLine[1] == 'j' ) {
							lstrcpy( szExplorerOptions, "/SELECT," );
							if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/J)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}
						}
						else { // if ( lpCmdLine[1] == 'O' || lpCmdLine[1] == 'o' ) { z
							lpCmdLine[1] = 'O';
							if ( -1 == (i = skipSpace( &lpCmdLine[2] )) ) {
								MessageBox( NULL, "p^̉͂Ɏs܂(/O)B", szTitle, MB_OK | MB_ICONSTOP );
								return 1;
							}
						}

						if ( lpCmdLine[2+i] == '"' ) {
							lstrcpy( szLinkFile, &lpCmdLine[2+i+1] );
							iLen = lstrlen( szLinkFile );
							if ( szLinkFile[iLen-1] == '"' ) {
								szLinkFile[iLen-1] = 0;
							}
						}
						else {
							lstrcpy( szLinkFile, &lpCmdLine[2+i] );
						}

						CoInitialize( NULL );
						//CoInitializeEx(NULL, COINIT_MULTITHREADED);
						if ( FALSE == QueryLink(szLinkFile, target, NULL, NULL, NULL) ) {
							MessageBox( NULL, "V[gJbgt@C̓ǂݍ݂Ɏs܂B", szTitle, MB_OK | MB_ICONSTOP );
							CoUninitialize();
							return 1;
						}
						CoUninitialize();

						if ( lpCmdLine[1] == 'O' ) {
							// ͂ŃtH_𐶐ĊJ - ݊֘AÂĂAvɂĊJ
							// 납T[`āAŏɌ\̂ƂI[ɒu
							// cAJׂtH_
							i = lstrlen(target) - 1;
							for(; i>0 ; i--) {
								if ( target[i] == '\\' ) {
									target[i] = 0;
									break;
								}
							}

							// tH_(Folder)ɕWɊ֘AÂꂽvOTA
							// ShellExecutȇQɎw肷镶ƂB
							// ǂݏołȂꍇ́A]ʂ "open" ƂȂB
							REG   reg;
							char *szWay = NULL;

							if ( reg.OpenKey(HKEY_CLASSES_ROOT, "Folder\\shell", TREG_OPEN_READONLY) ) {
								szWay = reg.new_ReadString("", "open");
								reg.CloseKey();
							}

							SHE(NULL, ShellExecute(NULL, szWay?szWay:"open" , target, NULL, target, SW_SHOWNORMAL));
							safedelete(szWay);
						}
						else {
							// GNXv[ɂĊJ - 
							// ^[Qbg̃t@CɁAJ[\ZbgꂽԂŊJ(/SELECT)
							lstrcat(szExplorerOptions, target);
							SHE(NULL, ShellExecute(NULL, "open", "EXPLORER.EXE", szExplorerOptions, ".", SW_SHOWNORMAL));
						}
						break;
					}

				case 'S':
				case 's':
					{
#if _MSC_VER < 1500
#ifndef _WIN64
						unsigned char scanreg[4] = {0x90, 0x04, 0x00, 0x00};
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
						char szChkdskOptions[30];
						REG reg;

						switch( lpCmdLine[2] ) {
							case '0': // ʏ̃XL
#if _MSC_VER < 1500
#ifndef _WIN64
								if ( isNT ) {
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
									wsprintf(szChkdskOptions, "%c:", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "CHKDSK.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
#if _MSC_VER < 1500
#ifndef _WIN64
								}
								else {
									if (reg.OpenKey(HKEY_CURRENT_USER,"Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive", TREG_OPEN_CREATE)) {
										if (false == reg.ReadString("Settings",(char *)scanreg, 4)) {
											scanreg[0] = 0x90;
											scanreg[1] = 0x04;
											scanreg[2] = scanreg[3] = 0x00;
										}
										scanreg[1] |= 0x05;	// CȂ 05𗧂Ă
										scanreg[1] &= 0xfb;	// CȂ 04Q
										scanreg[0] |= 0x10; // NX^XLȂ
										reg.WriteBinary("Settings",(char *)scanreg,4);
										reg.CloseKey();
									}
									wsprintf(szChkdskOptions, "%c:", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "SCANDSKW.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
								}
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
								break;

							case '1': // Cs߂̃XL
#if _MSC_VER < 1500
#ifndef _WIN64
								if ( isNT ) {
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
									wsprintf(szChkdskOptions, "%c: /f", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "CHKDSK.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
#if _MSC_VER < 1500
#ifndef _WIN64
								}
								else {
									if (reg.OpenKey(HKEY_CURRENT_USER,"Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive", TREG_OPEN_CREATE)) {
										if (false == reg.ReadString("Settings",(char *)scanreg, 4)) {
											scanreg[0] = 0x90;
											scanreg[1] = 0x04;
											scanreg[2] = scanreg[3] = 0x00;
										}
										scanreg[1] &= 0xfa;	// KC 05̏
										scanreg[1] |= 0x04;	// KC 04𗧂Ă
										scanreg[0] |= 0x10; // NX^XLȂ
										reg.WriteBinary("Settings",(char *)scanreg,4);
										reg.CloseKey();
									}
									wsprintf(szChkdskOptions, "%c:", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "SCANDSKW.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
								}
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
								break;

							case '2': // ZN^^NX^XL𔺂CXL
#if _MSC_VER < 1500
#ifndef _WIN64
								if ( isNT ) {
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
									wsprintf(szChkdskOptions, "%c: /r", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "CHKDSK.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
#if _MSC_VER < 1500
#ifndef _WIN64
								}
								else {
									if (reg.OpenKey(HKEY_CURRENT_USER,"Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive", TREG_OPEN_CREATE)) {
										if (false == reg.ReadString("Settings",(char *)scanreg, 4)) {
											scanreg[0] = 0x90;
											scanreg[1] = 0x04;
											scanreg[2] = scanreg[3] = 0x00;
										}
										scanreg[1] |= 0x05;	// CȂ 05𗧂Ă
										scanreg[1] &= 0xfb;	// CȂ 04Q
										scanreg[0] &= (~0x10); // NX^XL
										reg.WriteBinary("Settings",(char *)scanreg,4);
										reg.CloseKey();
									}
									wsprintf(szChkdskOptions, "%c:", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "SCANDSKW.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
								}
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
								break;

							case '3': // ZN^^NX^XL𔺂CXL
#if _MSC_VER < 1500
#ifndef _WIN64
								if ( isNT ) {
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
									wsprintf(szChkdskOptions, "%c: /f /r", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "CHKDSK.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
#if _MSC_VER < 1500
#ifndef _WIN64
								}
								else {
									if (reg.OpenKey(HKEY_CURRENT_USER,"Software\\Microsoft\\Windows\\CurrentVersion\\Applets\\Check Drive", TREG_OPEN_CREATE)) {
										if (false == reg.ReadString("Settings",(char *)scanreg, 4)) {
											scanreg[0] = 0x90;
											scanreg[1] = 0x04;
											scanreg[2] = scanreg[3] = 0x00;
										}
										scanreg[1] &= 0xfa;	// KC 05̏
										scanreg[1] |= 0x04;	// KC 04𗧂Ă
										scanreg[0] &= (~0x10); // NX^XL
										reg.WriteBinary("Settings",(char *)scanreg,4);
										reg.CloseKey();
									}
									wsprintf(szChkdskOptions, "%c:", lpCmdLine[3]);
									SHE(NULL, ShellExecute(NULL, "open", "SCANDSKW.EXE", szChkdskOptions, ".", SW_SHOWNORMAL));
								}
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
								break;

						}
					}
					break;
			}
		}
	}
	else {
		int i;

		i = lstrlen( lpCmdLine );
		if ( i >= 5 ) { // Opera΍(w𖳎ăIvV̂܂ܓn悤Ȃ̂)
			if ( (lpCmdLine[i-4] == '.' && (lpCmdLine[i-3] == 'l' || lpCmdLine[i-3] == 'L') && (lpCmdLine[i-2] == 'z' || lpCmdLine[i-2] == 'Z') && (lpCmdLine[i-1] == 'h' || lpCmdLine[i-1] == 'H')) ||
			     (lpCmdLine[i-5] == '.' && (lpCmdLine[i-4] == 'l' || lpCmdLine[i-4] == 'L') && (lpCmdLine[i-3] == 'z' || lpCmdLine[i-3] == 'Z') && (lpCmdLine[i-2] == 'h' || lpCmdLine[i-2] == 'H') && lpCmdLine[i-1] == '\"') ) {
				OpenExtractor( lpCmdLine, OET_LZH );
				return 1;
			}
			else if ( (lpCmdLine[i-4] == '.' && (lpCmdLine[i-3] == 'z' || lpCmdLine[i-3] == 'Z') && (lpCmdLine[i-2] == 'i' || lpCmdLine[i-2] == 'I') && (lpCmdLine[i-1] == 'p' || lpCmdLine[i-1] == 'P')) ||
				      (lpCmdLine[i-5] == '.' && (lpCmdLine[i-4] == 'z' || lpCmdLine[i-4] == 'Z') && (lpCmdLine[i-3] == 'i' || lpCmdLine[i-3] == 'I') && (lpCmdLine[i-2] == 'p' || lpCmdLine[i-2] == 'P') && lpCmdLine[i-1] == '\"') ) {
				OpenExtractor( lpCmdLine, OET_ZIP );
				return 1;
			}
		}
	}

	return 0;
}

void EasySkrx( const char *path )
{
	char *mes;
	REG  reg;

	mes = zalloc(lstrlen(path) + 100);
    wsprintf(mes,"%s\n\ñvOȈՂs܂B\nċNĂ낵ł?", path);	

	if (IDYES == MessageBox(NULL, mes, "[", MB_YESNO | MB_ICONQUESTION)) {
		if (reg.OpenKey(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce", TREG_OPEN_CREATE)) {
			reg.WriteString("RnsfSkrx", path);
			reg.CloseKey();

			GetQuitRight();
			if ( 0 == ExitWindowsEx(EWX_REBOOT,0) ) {
				MessageBox(NULL, "ċNɎs܂Bs͎Nɍs܂B", "[", MB_OK | MB_ICONSTOP);
			}
		}
		else {
			MessageBox(NULL, "ȈՂso^郌WXgL[J܂łB", "[", MB_OK | MB_ICONSTOP);
		}
	}
	safefree(mes);
}

void AddApplicationPath( const char *path )
{
	char drive[MAX_PATH*2], dir[_MAX_DIR*2], fname[MAX_PATH*2], fext[_MAX_EXT*2];
	REG reg;

	_splitpath_s(path, drive, _countof(drive), dir, _countof(dir), fname, _countof(fname), fext, _countof(fext));	// ^ꂽtpX𕪗
	lstrcat(drive, dir);	// fBNg\
	lstrcat(fname, fext);	// t@C\
	if ( reg.OpenKey(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths", TREG_OPEN_CREATE) ) {
		REG reg2;

		if ( reg2.OpenKey(reg.GetHKey(), fname) ) {
			if ( IDYES == MessageBox(NULL, "Õt@CAłɃAvP[V pXɓo^Ă܂B\n㏑o^Ă낵ł?", fname, MB_YESNO | MB_ICONQUESTION) ) {
				reg2.WriteString( "", path, 2 );
				reg2.WriteString( "Path", drive, 2 );
				MessageBox(NULL, "AvP[V pXɓo^܂B\no^Ƃ́u[v́uAvP[V pXv폜ĉB", fname, MB_OK | MB_ICONINFORMATION);
			}
			reg2.CloseKey();
		}
		else if ( IDYES == MessageBox(NULL, "AvP[V pXɓo^ƁAut@Cw肵Ďsvt@C̓͂ŖړĨvOsł悤ɂȂ܂B\nAvP[V pXɓo^Ă낵ł?", fname, MB_YESNO | MB_ICONQUESTION) ) {
			if ( reg2.OpenKey(reg.GetHKey(), fname, TREG_OPEN_CREATE) ) {
				reg2.WriteString("", path, 2);
				reg2.WriteString("Path", drive, 2);
				reg2.CloseKey();
				MessageBox(NULL, "AvP[V pXɓo^܂B\no^Ƃ́u[v́uAvP[VpXv폜ĉB", fname, MB_OK | MB_ICONINFORMATION);
			}
			else
				MessageBox(NULL, "AvP[V pXɓo^ł܂łB", fname, MB_OK | MB_ICONSTOP);
		}
		reg.CloseKey();
	}
}

// ǎ̐ݒ
bool setWallPaper( char *bmp )
{
	REG reg;

	if (reg.OpenKey(HKEY_CURRENT_USER, "Control Panel\\desktop", TREG_OPEN_CREATE)) {
		reg.WriteString("Wallpaper", bmp);
		reg.CloseKey();
	}

	return (SystemParametersInfo(SPI_SETDESKWALLPAPER,0,bmp,SPIF_SENDCHANGE))?true:false;
}

list<string> fnames_tChangeFileTimeDate;

// t@CύXp_CAOvV[W
static LRESULT CALLBACK DlgProc_tChangeFileTimeDate( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message ) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// SetChildWindowFont(hDlg);
			{
				WIN32_FIND_DATA520 wfd;
				HANDLE handle;
				FILETIME   fct, fwt; // [Jt@C^CF쐬, ŏIXV
				SYSTEMTIME sct, swt; // VXe^CF쐬, ŏIXV

				SetDlgItemText(hDlg, IDC_EDIT_FNAME, fnames_tChangeFileTimeDate.front().c_str());
				handle = FindFirstFile520(fnames_tChangeFileTimeDate.front().c_str(), &wfd);
				if ( handle == INVALID_HANDLE_VALUE ) { // t@CȂ
					MessageBox(hDlg, "t@C܂B", "^CX^vύX", MB_OK | MB_ICONSTOP);
					EndDialog(hDlg, FALSE);
					return TRUE;
				}
				FindClose( handle );

				// UFTVXe^Ci₷`jɕϊ
				FileTimeToLocalFileTime(&wfd.ftCreationTime  , &fct);
				FileTimeToSystemTime(&fct, &sct);
				FileTimeToLocalFileTime(&wfd.ftLastWriteTime , &fwt);
				FileTimeToSystemTime(&fwt, &swt);
			
				// _CAO֊el
				SetDlgItemInt(hDlg, IDC_EDIT_CYEAR  , sct.wYear  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CMONTH , sct.wMonth , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CDAY   , sct.wDay   , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CHOUR  , sct.wHour  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CMINUTE, sct.wMinute, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CSECOND, sct.wSecond, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CMILSEC, sct.wMilliseconds, FALSE);

				SetDlgItemInt(hDlg, IDC_EDIT_WYEAR  , swt.wYear  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WMONTH , swt.wMonth , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WDAY   , swt.wDay   , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WHOUR  , swt.wHour  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WMINUTE, swt.wMinute, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WSECOND, swt.wSecond, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WMILSEC, swt.wMilliseconds, FALSE);

				// tH[JXŏ̔Nɐݒ
				SetFocus(GetDlgItem(hDlg, IDC_EDIT_CYEAR));
			}
			return FALSE; // tH[JXςĂ̂FALSEԂ

		case WM_DROPFILES:
			// GNXv[t@Chbv
			{
				WIN32_FIND_DATA520 wfd;
				HANDLE handle;
				FILETIME   fct, fwt; // [Jt@C^CF쐬, ŏIXV
				SYSTEMTIME sct, swt; // VXe^CF쐬, ŏIXV
				char fname[MAX_PATH*2] = "";

				DragQueryFile((HDROP)wParam, 0, fname, _countof(fname));
				
				handle = FindFirstFile520(fname, &wfd);
				if ( handle == INVALID_HANDLE_VALUE ) { // t@CȂ
					return TRUE;
				}
				FindClose( handle );

				// UFTVXe^Ci₷`jɕϊ
				FileTimeToLocalFileTime(&wfd.ftCreationTime  , &fct);
				FileTimeToSystemTime(&fct, &sct);
				FileTimeToLocalFileTime(&wfd.ftLastWriteTime , &fwt);
				FileTimeToSystemTime(&fwt, &swt);
			
				// _CAO֊el
				SetDlgItemInt(hDlg, IDC_EDIT_CYEAR  , sct.wYear  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CMONTH , sct.wMonth , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CDAY   , sct.wDay   , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CHOUR  , sct.wHour  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CMINUTE, sct.wMinute, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CSECOND, sct.wSecond, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_CMILSEC, sct.wMilliseconds, FALSE);

				SetDlgItemInt(hDlg, IDC_EDIT_WYEAR  , swt.wYear  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WMONTH , swt.wMonth , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WDAY   , swt.wDay   , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WHOUR  , swt.wHour  , FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WMINUTE, swt.wMinute, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WSECOND, swt.wSecond, FALSE);
				SetDlgItemInt(hDlg, IDC_EDIT_WMILSEC, swt.wMilliseconds, FALSE);

				DragFinish((HDROP)wParam);
			}
			return TRUE;


		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					{
						FILETIME   ufct, ufwt; // Ut@C^CF쐬, ŏIANZX, ŏIXV
						FILETIME   fct, fwt; // [Jt@C^CF쐬, ŏIANZX, ŏIXV
						SYSTEMTIME sct, swt; // VXe^CF쐬, ŏIANZX, ŏIXV
						HANDLE handle;
						DWORD  attr;
						BOOL   rv = FALSE;

						// _CAOel𓾂
						sct.wYear   = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_CYEAR  , NULL, FALSE);
						sct.wMonth  = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_CMONTH , NULL, FALSE);
						sct.wDay    = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_CDAY   , NULL, FALSE);
						sct.wHour   = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_CHOUR  , NULL, FALSE);
						sct.wMinute = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_CMINUTE, NULL, FALSE);
						sct.wSecond = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_CSECOND, NULL, FALSE);
						sct.wMilliseconds = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_CMILSEC, NULL, FALSE);

						swt.wYear   = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_WYEAR  , NULL, FALSE);
						swt.wMonth  = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_WMONTH , NULL, FALSE);
						swt.wDay    = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_WDAY   , NULL, FALSE);
						swt.wHour   = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_WHOUR  , NULL, FALSE);
						swt.wMinute = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_WMINUTE, NULL, FALSE);
						swt.wSecond = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_WSECOND, NULL, FALSE);
						swt.wMilliseconds = (WORD)GetDlgItemInt(hDlg, IDC_EDIT_WMILSEC, NULL, FALSE);

						// VXe^C`UFT֕ύX
						SystemTimeToFileTime(&sct, &fct);
						LocalFileTimeToFileTime(&fct, &ufct);
						SystemTimeToFileTime(&swt, &fwt);
						LocalFileTimeToFileTime(&fwt, &ufwt);

						const char *fname_tChangeFileTimeDate;
						for(list<string>::iterator iter = fnames_tChangeFileTimeDate.begin() ; iter != fnames_tChangeFileTimeDate.end() ; ++iter) {
							fname_tChangeFileTimeDate = iter->c_str();
							char errmes[80+MAX_PATH*2];

							// ꎞIɕύX
							attr = GetFileAttributes( fname_tChangeFileTimeDate );
							SetFileAttributes( fname_tChangeFileTimeDate, FILE_ATTRIBUTE_NORMAL );

							// t@CJĊeύX
							if ( INVALID_HANDLE_VALUE != (handle = CreateFile(fname_tChangeFileTimeDate, GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) ) {
								rv = SetFileTime(handle, &ufct, NULL, &ufwt);
								CloseHandle( handle );
								if (rv == 0) {
									wsprintf(errmes, "%s\nt@C̃^CX^vύXł܂B", fname_tChangeFileTimeDate);
									MessageBox(hDlg, errmes, "^CX^vύX", MB_OK | MB_ICONSTOP);
								}
							}
							else {
								wsprintf(errmes, "%s\nt@C݃[hŊJ܂B", fname_tChangeFileTimeDate);
								MessageBox(hDlg, errmes, "^CX^vύX", MB_OK | MB_ICONSTOP);
							}

							// ɖ߂
							SetFileAttributes( fname_tChangeFileTimeDate, attr );
						}
						EndDialog(hDlg, (INT_PTR)rv);
					}
					return TRUE;

				case IDCANCEL:
					EndDialog(hDlg, FALSE);
					return TRUE;
			}
			break;

		case WM_COPYDATA:
			// t@C̎M
			{
				COPYDATASTRUCT *pcpds = (COPYDATASTRUCT *)lParam;

				if (pcpds->dwData == FCHANGE_KDT) {
					fnames_tChangeFileTimeDate.push_back((const char *)(pcpds->lpData));
					int len = GetWindowTextLength(GetDlgItem(hDlg, IDC_EDIT_FNAME)) + 3 + lstrlen((const char *)(pcpds->lpData));
					char *buf = zalloc(len);

					if (buf) {
						GetDlgItemText(hDlg, IDC_EDIT_FNAME, buf, len);
						lstrcat(buf, ", ");
						lstrcat(buf, (const char *)(pcpds->lpData));
						SetDlgItemText(hDlg, IDC_EDIT_FNAME, buf);
						free(buf);
					}
					return TRUE;
				}
			}
			return FALSE;
	}
    return FALSE;
}

BOOL CALLBACK tChangeFileTimeDate_EnumWindow(HWND hWnd, LPARAM lParam)
{
	char title[80];

	if (0 < GetWindowText(hWnd, title, _countof(title))) {
		if (lstrcmp(title, "t@C̃^CX^vύX") == 0) {
			COPYDATASTRUCT cpds;

			cpds.dwData = FCHANGE_KDT;
			cpds.cbData = lstrlen((const char *)lParam) + 1;
			cpds.lpData = (PVOID)(const char *)lParam;

			if (TRUE == SendMessage(hWnd, WM_COPYDATA, 0, (LPARAM)&cpds)) {
				SetForegroundWindow(hWnd);
				return FALSE;
			}
		}
	}

	return TRUE;
}

// t@C̍ŏIXVȂǂύX
bool tChangeFileTimeDate( const char *fname )
{
	// mutexɂAvZXオĂ邩ǂ`FbN
	HWND mutexhd;

	mutexhd = (HWND)CreateMutex(NULL, true, "Rnsfldr_context_tChangeFileTimeDate");
	if (GetLastError() == ERROR_ALREADY_EXISTS) {
		// łɓvZXオĂꍇ́ÃvZXɑ΂t@C𑗐M
		Sleep(500); // ̑O 0.5s X[v
		EnumWindows(tChangeFileTimeDate_EnumWindow, (LPARAM)fname);
		return true;
	}
	else {
		// 1Ԗڂ̎sBlistɃt@C̒~ςJn
		fnames_tChangeFileTimeDate.clear();
		fnames_tChangeFileTimeDate.push_back(fname);
		bool rv = DialogBox(hInst, (LPCTSTR)IDD_CHANGE_FTIME, NULL, (DLGPROC)DlgProc_tChangeFileTimeDate)?true:false;
		CloseHandle(mutexhd);

		return rv;
	}
}

static volatile HWND cts_hdlg;				// MD5Zo_CAÕnh
static volatile bool th_md5_abort_flag = 1;	// MD5Zo~tO

// md5filẽR[obN֐B~̏ꍇFALSEԂBłȂꍇ͐i󋵂lNow/lMaxo
BOOL smd5_cbfunc(long lNow, long lMax)
{
	if (th_md5_abort_flag) return FALSE;

	SendDlgItemMessage(cts_hdlg, IDC_PROGRESS1, PBM_SETPOS, (WPARAM)lNow, 0);
	w7tbProgress(cts_hdlg, 2 /*TBPF_NORMAL*/, lNow, lMax); // Win7̃^XNo[vOX

	return TRUE;
}

typedef struct {
	HWND hDlg;
	const char *fname;
	long fsize;
} CTS, *PCTS;

// t@Cri߂l͌ʂj[ _beginthread() Ă΂ ]
static void th_md5_files(void *_cts)
{
	char md5[33] = "MD5ZoɎs܂";
	PCTS pcts = (PCTS)_cts;

	cts_hdlg = pcts->hDlg;
	SendDlgItemMessage(pcts->hDlg, IDC_PROGRESS1, PBM_SETRANGE32, 0, (LPARAM)pcts->fsize);
	if (FALSE == md5file(pcts->fname, md5, smd5_cbfunc)) {
		// ~
		SendDlgItemMessage(pcts->hDlg, IDC_PROGRESS1, PBM_SETPOS, (WPARAM)pcts->fsize, 0);
		w7tbProgress(pcts->hDlg, 4 /*TBPF_ERROR*/, 1, 1); // Win7̃^XNo[vOX
	}
	else {
		// 
		SetDlgItemText(pcts->hDlg, IDC_EDITMD5, md5);
		EnableWindow(GetDlgItem(pcts->hDlg, IDYES), TRUE);
	}

	w7tbProgress(NULL, 0, 0, 0); // Win7̃^XNo[vOX

	_endthread();
}

const static char *fname_showMD5file;

// MD5\p_CAOvV[W
static LRESULT CALLBACK DlgProc_showMD5file( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message ) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// SetChildWindowFont(hDlg);
			{
				char szSize[50] = "t@CJ܂B";
				long lsize;
				FILE *fp;
				
				SetDlgItemText(hDlg, IDC_EDITMD5, "MD5Zoł...");
				if ( 0 == fopen_s(&fp, fname_showMD5file, "rb") ) {
					char cmbuf[16], cmbuf2[16];

					fseek(fp, 0, SEEK_END);
					lsize = ftell(fp);
					fclose(fp);
					wsprintf(szSize, "%soCg (%sKB)", commaex(lsize, cmbuf), commaex((0 < lsize && lsize < 2048)?1:(lsize/1024), cmbuf2));
					SetDlgItemText(hDlg, IDC_EDIT_FNAME, fname_showMD5file);

					static CTS cts;
					cts.hDlg = hDlg;
					cts.fname = fname_showMD5file;
					cts.fsize = lsize;
					th_md5_abort_flag = 0;

					w7tbProgress(hDlg, 2 /*TBPF_NORMAL*/, 0, lsize); // Win7̃^XNo[vOX
					if( -1 == _beginthread( th_md5_files, 0, (void *)&cts ) ) {
						SetDlgItemText(hDlg, IDC_EDITMD5, "MD5̎ZoJnɎs܂B");
					}
				}
				SetDlgItemText(hDlg, IDC_EDITSIZE, szSize);
			}
			return TRUE;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDYES:
					{
						char md5[33] = "A", md5b[35] = "B";

						GetDlgItemText(hDlg, IDC_EDITMD5, md5, 33);
						GetDlgItemText(hDlg, IDC_EDIT_COMPARE, md5b, 34);

						if (lstrlen(md5b) == 0) {
							MessageBox(hDlg, "urvɁArMD5͂ĂB", "MD5r", MB_OK | MB_ICONINFORMATION );
						}
						else if (lstrlen(md5b) < 32) {
							MessageBox(hDlg, "urvMD5̕܂B32œ͂ĂB", "MD5r", MB_OK | MB_ICONINFORMATION );
						}
						else {
							MessageBox(hDlg, _stricmp(md5, md5b) == 0 ? "MD5v" : "MD5sv", "MD5r", MB_OK | MB_ICONINFORMATION );
						}
					}
					return TRUE;

				case IDCANCEL:
					th_md5_abort_flag = 1;
					EndDialog(hDlg, FALSE);
					return TRUE;

				case IDC_EDIT_COMPARE:
					if ( HIWORD(wParam) == EN_CHANGE ) {
						char md5b[35];

						GetDlgItemText(hDlg, IDC_EDIT_COMPARE, md5b, 34);
						if ( lstrlen(md5b) >= 33 ) {
                            md5b[32] = 0;
							SetDlgItemText(hDlg, IDC_EDIT_COMPARE, md5b);
						}
                    }
					return TRUE;
			}
			break;
	}
    return FALSE;
}

// t@C̍ŏIXVȂǂύX
bool showMD5file( const char *fname )
{
	fname_showMD5file = fname; // staticOϐfnameRs[
	return DialogBox(hInst, (LPCTSTR)IDD_SHOWMD5FILE, NULL, (DLGPROC)DlgProc_showMD5file)?true:false;
}

// textNbv{[hɃRs[
bool tCopyClipboard( const char *text )
{
	if( OpenClipboard(NULL) ) {
		char *pPtr;
		int gsize;
		HGLOBAL hMem;
		HANDLE hRet;

		gsize = lstrlen(text) + 1;
		if ( NULL != (hMem = GlobalAlloc(GHND, gsize)) ) {
			pPtr = (char *)::GlobalLock(hMem);
			if (pPtr) {
				lstrcpy(pPtr, text);
				GlobalUnlock( hMem );
				if (EmptyClipboard()) {
					hRet = SetClipboardData(CF_TEXT, hMem);
					if (hRet == NULL) {
						CloseClipboard();
						safegfree(hMem);
						MessageBox(NULL, "Nbv{[hւ̕ݒ蒆ɃG[܂B","[",MB_OK | MB_ICONSTOP);
						return false;
					}
					else {
						CloseClipboard();
						return true;
					}
				}
				else {
					CloseClipboard();
					safegfree(hMem);
					MessageBox(NULL, "Nbv{[hɂł܂B","[",MB_OK | MB_ICONSTOP);
					return false;
				}
			}
			else {
				CloseClipboard();
				safegfree(hMem);
				MessageBox(NULL, "GlobalLocksB","[",MB_OK | MB_ICONSTOP);
				return false;
			}
		}
		else {
			CloseClipboard();
			MessageBox(NULL, "Ɨp̃܂B","[",MB_OK | MB_ICONSTOP);
			return false;
		}
	}
	else {
		MessageBox(NULL, "Nbv{[hJ܂B","[",MB_OK | MB_ICONSTOP);
		return false;
	}
}

// text̒\2dɂăNbv{[hɃRs[
bool t2CopyClipboard( const char *text )
{
	int  i, j;
	bool rv = false;

	char *s = zalloc(lstrlen(text)*2 + 1);
	if ( s ) {
		for(i=j=0 ; text[i] ; i++,j++) {
			s[j] = text[i];
			if ( !isKanji1(s,j-1) && s[j] == '\\' ) {
				s[++j] = '\\';
			}
		}
		s[j] = 0;

		rv = tCopyClipboard(s);
		free(s);
	}

	return rv;
}

// dir  (lzhname̎t@C) gāAlzhWJoutputdir
static char *makeefolder(const char *dir, const char *arcfile, char *outputdir, size_t outputdirsize)
{
	if (dir && arcfile && outputdir) {
		int fnamesize = lstrlen(arcfile) + 1;
		char *fname = zalloc(fnamesize);
		if ( fname ) {
			_splitpath_s( arcfile, NULL, 0, NULL, 0, fname, fnamesize, NULL, 0);
			_makepath_s( outputdir, outputdirsize, NULL, dir, fname, NULL );
			free(fname);
			return outputdir;
		}
	}

	return NULL;
}

// lzht@C̓WJ
bool ExpandLzh( const char *arcfile, const char *folder )
{
	REG reg;
	size_t outdirsize;
	char *outdir;
	bool rv = false;
	int  rvd;
	char szOutputBuf[ARCDLL_OUTBUFSIZE+1];

	if (folder) {
		outdirsize = lstrlen(arcfile) + lstrlen(folder) + 1;
		outdir = zalloc(outdirsize);
		if (outdir == NULL) return rv;
		makeefolder(folder, arcfile, outdir, outdirsize);
		CreateDir( outdir );
	}
	else {
		outdirsize = 0;
		outdir = ".";
	}

	while(1) { // unlha32.dllgpꍇ̑΍F0.5bX[vretry
		rvd = call_unlha32d_log(NULL, arcfile, outdir, szOutputBuf, ARCDLL_OUTBUFSIZE);
		if (rvd == T_TF_SUCCESS) {
            rv = true;
			break;
		}
		else if (rvd == T_TF_DLLNOTFOUND) {
			MessageBox(NULL, UNLHA32DLL"܂B", UNLHA32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else if (rvd == T_TF_ILLEGALDLL) {
			MessageBox(NULL, UNLHA32DLL"܂B", UNLHA32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else if (rvd == T_TF_ILLEGALCALL) {
			MessageBox(NULL, "sȌĂяołB", UNLHA32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else {
			if ( call_unlha32_getrunning() ) {
				Sleep(500);
			}
			else {
				ShowOutputDlg( NULL, "WJɎsAf܂B", UNLHA32DLL, szOutputBuf, MB_ICONSTOP );
				RemoveDirectory( outdir );
				rv = false;
				break;
			}
		}
	}

	if ( rv ) {
		if( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY) ) {
			if ( 1 == reg.ReadInteger( "LzhZipOpenFolder" ) ) {
				SHE(NULL, ShellExecute(NULL, "explore", outdir, NULL, NULL, SW_SHOW));
			}
			reg.CloseKey();
		}
	}
	if (outdirsize != 0) free(outdir);
	return rv;
}

// zipt@C̓WJ
bool ExpandZip( const char *arcfile, const char *folder )
{
	REG reg;
	size_t outdirsize;
	char *outdir;
	bool rv = false;
	int  rvd;
	char szOutputBuf[ARCDLL_OUTBUFSIZE+1];

	if (folder) {
		outdirsize = lstrlen(arcfile) + lstrlen(folder) + 1;
		outdir = zalloc(outdirsize);
		if (outdir == NULL) return rv;
		makeefolder(folder, arcfile, outdir, outdirsize);
		CreateDir( outdir );
	}
	else {
		outdirsize = 0;
		outdir = ".";
	}

	while(1) { // unzip32.dllgpꍇ̑΍F0.5bX[vretry
		rvd = call_unzip32d_log(NULL, arcfile, outdir, szOutputBuf, ARCDLL_OUTBUFSIZE);
		if (rvd == T_TF_SUCCESS) {
            rv = true;
			break;
		}
		else if (rvd == T_TF_DLLNOTFOUND) {
			MessageBox(NULL, UNZIP32DLL"܂B", UNZIP32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else if (rvd == T_TF_ILLEGALDLL) {
			MessageBox(NULL, UNZIP32DLL"܂B", UNZIP32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else if (rvd == T_TF_ILLEGALCALL) {
			MessageBox(NULL, "sȌĂяołB", UNZIP32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else {
			if ( call_unzip32_getrunning() ) {
				Sleep(500);
			}
			else {
				char *szOutputBuf2 = replacestr(szOutputBuf, "\n", "\r\n");
				ShowOutputDlg( NULL, "WJɎsAf܂B", UNZIP32DLL, szOutputBuf2, MB_ICONSTOP );
				safefree(szOutputBuf2);
				RemoveDirectory( outdir );
				rv = false;
				break;
			}
		}
	}

	if ( rv ) {
		if( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY) ) {
			if ( 1 == reg.ReadInteger( "LzhZipOpenFolder" ) ) {
				SHE(NULL, ShellExecute(NULL, "explore", outdir, NULL, NULL, SW_SHOW));
			}
			reg.CloseKey();
		}
	}
	if (outdirsize != 0) safefree(outdir);
	return rv;
}

// 7Zipt@C̓WJ
bool Expand7Zip( const char *arcfile, const char *folder )
{
	REG reg;
	size_t outdirsize;
	char *outdir;
	bool rv = false;
	int  rvd;
	char szOutputBuf[ARCDLL_OUTBUFSIZE+1];

	if (folder) {
		outdirsize = lstrlen(arcfile) + lstrlen(folder) + 1;
		outdir = zalloc(outdirsize);
		if (outdir == NULL) return rv;
		makeefolder(folder, arcfile, outdir, outdirsize);
		CreateDir( outdir );
	}
	else {
		outdirsize = 0;
		outdir = ".";
	}

	while(1) { // 7zip32.dllgpꍇ̑΍F0.5bX[vretry
		rvd = call_7zip32d_log(NULL, arcfile, outdir, szOutputBuf, ARCDLL_OUTBUFSIZE);
		if (rvd == T_TF_SUCCESS) {
            rv = true;
			break;
		}
		else if (rvd == T_TF_DLLNOTFOUND) {
			MessageBox(NULL, SEVENZIP32DLL"܂B", SEVENZIP32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else if (rvd == T_TF_ILLEGALDLL) {
			MessageBox(NULL, SEVENZIP32DLL"܂B", SEVENZIP32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else if (rvd == T_TF_ILLEGALCALL) {
			MessageBox(NULL, "sȌĂяołB", SEVENZIP32DLL, MB_OK | MB_ICONSTOP);
			RemoveDirectory( outdir );
			rv = false;
			break;
		}
		else {
			if ( call_7zip32_getrunning() ) {
				Sleep(500);
			}
			else {
				ShowOutputDlg( NULL, "WJɎsAf܂B", SEVENZIP32DLL, szOutputBuf, MB_ICONSTOP );
				RemoveDirectory( outdir );
				rv = false;
				break;
			}
		}
	}

	if ( rv ) {
		if( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY) ) {
			if ( 1 == reg.ReadInteger( "LzhZipOpenFolder" ) ) {
				SHE(NULL, ShellExecute(NULL, "explore", outdir, NULL, NULL, SW_SHOW));
			}
			reg.CloseKey();
		}
	}
	if (outdirsize != 0) free(outdir);
	return rv;
}

// 炩ߎw肳ꂽtH_ɁAarcfile(.lzh) WJ
bool OpenExtractor( const char *arcfile, int oetype )
{
	REG reg;
	char *folder = NULL;
	bool rv;

	if( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY) ) {
		folder = reg.new_ReadString( "LzhZipFolder", NULL );
		reg.CloseKey();
	}

	if ( folder && folder[0] ) {
        rv = (ExpandFunctions[oetype])( arcfile, folder );
        safedelete(folder);
		return rv;
	}
	else { // WXgtH_ǂ߂ȂAtH_I
		safedelete(folder);
		return OpenExtractorDir( arcfile, oetype );
	}
}

// WJtH_w肵Aarcfile(.lzh) WJ
bool OpenExtractorDir( const char *arcfile, int oetype )
{
	BOOL			bRes;
	LPITEMIDLIST	pidlRetFolder;
	BROWSEINFO		stBInfo;
	char			dir[MAX_PATH*2]="", *title, fname[_MAX_FNAME*2], fext[_MAX_EXT*2];

	// ^Cgo[̐
	title = zalloc(_MAX_FNAME*2 + _MAX_EXT*2 + 30);
	_splitpath_s(arcfile, NULL, 0, NULL, 0, fname, _countof(fname), fext, _countof(fext));
	wsprintf(title, "%s%s̉𓀐tH_I", fname, fext);

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	//[gtH_łB
	stBInfo.hwndOwner = NULL;	//\_CAO̐eEBhẼnhłB
	stBInfo.pszDisplayName = dir;	//IĂtH_󂯂܂B
	stBInfo.lpszTitle = title;	//̕łB
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS;	//\tOłB
	stBInfo.lpfn = NULL;	//_CAOvV[Wւ̃|C^łB
	stBInfo.lParam = 0L;	//vV[Wɑp[^[łB

	//@_CAO{bNX\܂B
	pidlRetFolder = ::SHBrowseForFolder( &stBInfo );
	safefree(title);

	if( pidlRetFolder != NULL ) {
		//@tpX擾܂B
		bRes = ::SHGetPathFromIDList( pidlRetFolder, dir );
		if( bRes != FALSE ) {
			return (ExpandFunctions[oetype])( arcfile, dir );
		}
		::CoTaskMemFree( pidlRetFolder );
	}
	return false;
}

// fXNgbv arcfile(.lzh) WJ
bool OpenExtractorDesktop( const char *arcfile, int oetype )
{
	return (ExpandFunctions[oetype])( arcfile, GetDesktopFolder() );
}

// JgfBNg[t@CƓtH_] arcfile(.lzh) WJ
bool OpenExtractorCD( const char *arcfile, int oetype )
{
	char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], path[MAX_PATH*2];

	_splitpath_s(arcfile, drv, _countof(drv), dir, _countof(dir), NULL, 0, NULL, 0);
	_makepath_s(path, _countof(path), drv, dir, NULL, NULL);

	return (ExpandFunctions[oetype])( arcfile, path );
}

// JgfBNg[exeƓtH_] arcfile(.lzh) WJ
bool OpenExtractorOwnDir( const char *arcfile, int oetype )
{
	return (ExpandFunctions[oetype])( arcfile, NULL );
}

static volatile bool abort_flag = 1;
typedef struct {
	char *file1;
	char *file2;
	HWND hStaticCompare;
	HWND hProgressBar;
	DWORD fsize;
} CFS, *PCFS;
#define COMPARE_BUFSIZE (1024*1024)

// t@Cri߂l͌ʂj[ _beginthread() Ă΂ ]
static void comparefiles(void *_cfs)
{
	char   *buf1 , *buf2;
	HANDLE hFile1, hFile2;
	DWORD  read1, read2, read_size;
	char   *rv = "s";
	PCFS pcfs = (PCFS)_cfs;

	buf1 = (char *)malloc( COMPARE_BUFSIZE );
	if( buf1 == NULL ) {
		SetWindowText(pcfs->hStaticCompare, "sŔrł܂łB");
	}

	buf2 = (char *)malloc( COMPARE_BUFSIZE );
	if ( buf2 == NULL ) {
		safefree( buf1 );
		SetWindowText(pcfs->hStaticCompare, "sŔrł܂łB");
	}

	hFile1 = CreateFile(pcfs->file1, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	if ( hFile1 == INVALID_HANDLE_VALUE ) {
		safefree( buf1 );
		safefree( buf2 );
		SetWindowText(pcfs->hStaticCompare, "1t@CJ܂łB");
	}

	hFile2 = CreateFile(pcfs->file2, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	if ( hFile2 == INVALID_HANDLE_VALUE ) {
		safefree( buf1 );
		safefree( buf2 );
		CloseHandle( hFile1 );
		SetWindowText(pcfs->hStaticCompare, "2t@CJ܂łB");
	}

	read_size = 0;
	SendMessage(pcfs->hProgressBar, PBM_SETRANGE32, 0, (LPARAM)pcfs->fsize);
	while(1) {
		read1 = read2 = 0;
		ReadFile(hFile1, buf1, (DWORD)COMPARE_BUFSIZE, &read1, NULL);
		ReadFile(hFile2, buf2, (DWORD)COMPARE_BUFSIZE, &read2, NULL);

		read_size += read1;
		SendMessage(pcfs->hProgressBar, PBM_SETPOS, (WPARAM)read_size, 0);
		w7tbProgress(GetAncestor(pcfs->hProgressBar, GA_ROOTOWNER), 2 /*TBPF_NORMAL*/, read_size, pcfs->fsize); // Win7̃^XNo[vOX

		if ( abort_flag == 1 ) {
			rv = "f܂B";
			w7tbProgress(GetAncestor(pcfs->hProgressBar, GA_ROOTOWNER), 8 /*TBPF_PAUSED*/, 1, 1); // Win7̃^XNo[vOX
			break;
		}

		if ( read1 != read2 ) {
			rv = "eɈႢ邩AǂݏoG[łB";
			w7tbProgress(GetAncestor(pcfs->hProgressBar, GA_ROOTOWNER), 4 /*TBPF_ERROR*/, 1, 1); // Win7̃^XNo[vOX
			break;
		}
		else {
			if (read1 == 0 || 0 == memcmp(buf1, buf2, read1)) {
                if ( COMPARE_BUFSIZE != read1 ) {
                    rv = "t@C̓e͈vĂ܂B";
					w7tbProgress(GetAncestor(pcfs->hProgressBar, GA_ROOTOWNER), 2 /*TBPF_NORMAL*/, 1, 1); // Win7̃^XNo[vOX
					break;
				}
			}
			else {
				rv = "t@CeɈႢ܂B";
				w7tbProgress(GetAncestor(pcfs->hProgressBar, GA_ROOTOWNER), 2 /*TBPF_NORMAL*/, 1, 1); // Win7̃^XNo[vOX
				break;
			}
		}
	}

	SendMessage(pcfs->hProgressBar, PBM_SETPOS, (WPARAM)pcfs->fsize, 0);
	w7tbProgress(NULL, 0, 0, 0); // Win7̃^XNo[vOX

	safefree( buf1 );
	safefree( buf2 );
	CloseHandle( hFile1 );
	CloseHandle( hFile2 );

	abort_flag = 1;
	SetWindowText(pcfs->hStaticCompare, rv);
	_endthread();
}

static char *fname1, fname2[MAX_PATH*2];

// EBhEp_CAOvV[W
static LRESULT CALLBACK DlgProc_compare( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message ) {
		case WM_INITDIALOG:
			{
				OPENFILENAME ofn;
				WIN32_FIND_DATA520 wfd1, wfd2;
				HANDLE			hf1, hf2;
				char *title, fname[_MAX_FNAME*2], fext[_MAX_EXT*2];
				char *result;

				// rΏۂ̃t@CI
				// I_CAÕ^Cgo[̐
				title = zalloc(_MAX_FNAME*2 + _MAX_EXT*2 + 30);
				_splitpath_s(fname1, NULL, 0, NULL, 0, fname, _countof(fname), fext, _countof(fext));
				wsprintf(title, "%s%sƔrt@CI", fname, fext);

				fname2[0] = 0;

				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = NULL;
				ofn.lpstrFilter = "ׂẴt@C(*.*)\0*.*\0\0";
				ofn.nFilterIndex = 1;
				ofn.lpstrCustomFilter = (LPSTR) NULL;
				ofn.nMaxCustFilter = 0L;
				ofn.lpstrFile = fname2;
				ofn.nMaxFile = _countof(fname2);
				ofn.lpstrFileTitle = NULL;
				ofn.nMaxFileTitle = 0;
				ofn.lpstrInitialDir = NULL;
				ofn.lpstrTitle = title;
				ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
				ofn.nFileOffset = 0;
				ofn.nFileExtension = 0;
				ofn.lpstrDefExt = NULL; 

				if ( !GetOpenFileName(&ofn) ) {
					safefree(title);
					EndDialog(hDlg, FALSE);
					return TRUE;
				}
				safefree(title);

				// t@C̔r (FindFirstFileCompareFileTime)
				hf1 = FindFirstFile520(fname1, &wfd1);
				if ( hf1 == INVALID_HANDLE_VALUE  ) {
					char *s = zalloc(lstrlen(fname1) + 20);

					if ( s ) {
						wsprintf(s, "%s܂B", fname1);
						MessageBox(NULL, s, "ȈՔr", MB_OK);
						safefree(s);
					}
					EndDialog(hDlg, FALSE);
					return TRUE;
				}
				FindClose( hf1 );

				hf2 = FindFirstFile520(fname2, &wfd2);
				if ( hf2 == INVALID_HANDLE_VALUE  ) {
					char *s = zalloc(lstrlen(fname2) + 20);

					if ( s ) {
						wsprintf(s, "%s܂B", fname2);
						MessageBox(NULL, s, "ȈՔr", MB_OK);
						safefree(s);
					}
					EndDialog(hDlg, FALSE);
					return TRUE;
				}
				FindClose( hf2 );

				result = NULL;

				result = _strdup( fname1 );
				result = realloc_strcat( result, "(1t@C)" );
				result = realloc_strcat( result, fname2 );
				result = realloc_strcat( result, "(2t@C)̔rʂłB\n\n쐬F" );

				switch (CompareFileTime(&wfd1.ftCreationTime, &wfd2.ftCreationTime)) {
					case -1:result = realloc_strcat( result, "2t@C̕V" ); break;
					case  0:result = realloc_strcat( result, "" ); break;
					case  1:result = realloc_strcat( result, "1t@C̕V" ); break;
				}

				result = realloc_strcat( result, "\n\nXVF" );

				switch (CompareFileTime(&wfd1.ftLastWriteTime, &wfd2.ftLastWriteTime)) {
					case -1:result = realloc_strcat( result, "2t@C̕V" ); break;
					case  0:result = realloc_strcat( result, "" ); break;
					case  1:result = realloc_strcat( result, "1t@C̕V" ); break;
				}

				result = realloc_strcat( result, "\n\n傫F" );

				if ( wfd1.nFileSizeHigh > wfd2.nFileSizeHigh ) {
					result = realloc_strcat( result, "1t@C̕傫" );
				}
				else if ( wfd1.nFileSizeHigh < wfd2.nFileSizeHigh ) {
					result = realloc_strcat( result, "2t@C̕傫" );
				}
				else { // wfd1.nFileSizeHigh == wfd2.nFileSizeHigh
					if ( wfd1.nFileSizeLow > wfd2.nFileSizeLow ) {
						result = realloc_strcat( result, "1t@C̕傫" );
						SetDlgItemText(hDlg, IDC_STATIC_COMPARE, "");
					}
					else if ( wfd1.nFileSizeLow < wfd2.nFileSizeLow ) {
						result = realloc_strcat( result, "2t@C̕傫" );
						SetDlgItemText(hDlg, IDC_STATIC_COMPARE, "");
					}
					else if ( wfd1.nFileSizeLow == wfd2.nFileSizeLow ){
						static CFS cfs; // XbhŎg߁ÃubN𔲂ĂLłKv
						cfs.file1 = fname1;
						cfs.file2 = fname2;
						cfs.fsize = wfd1.nFileSizeLow;
						cfs.hProgressBar = GetDlgItem(hDlg, IDC_PROGRESS1);

						result = realloc_strcat( result, "" );
						cfs.hStaticCompare = GetDlgItem(hDlg, IDC_STATIC_COMPARE);
						
						abort_flag = 0;
						// RyApɃXbh𐶐
						if( -1 == _beginthread( comparefiles, 0, (void *)&cfs ) ) {
							SetDlgItemText(hDlg, IDC_STATIC_COMPARE, "RyÅJnɎs܂B");
						}
					}
				}

				SetDlgItemText( hDlg, IDC_STATIC_RESULT, result );
				safefree(result);
			}
			return TRUE;

		case WM_COMMAND:
			switch( LOWORD(wParam) ) {
				case IDCANCEL:
					if ( abort_flag == 1 ) {
						EndDialog(hDlg, 0);
					}
					else {
						abort_flag = 1;
					}
					return TRUE;
			}
	}
    return FALSE;
}

// t@Cmr
bool CompareFiles( char *_fname1 )
{
	fname1 = _fname1;
	return DialogBox(hInst, (LPCTSTR)IDD_DIALOG_COMPARE, NULL, (DLGPROC)DlgProc_compare) != 0 ? true : false;
}

// ȈՈkACRfXNgbvɍ쐬
bool makeCompressIcon( void )
{
	char DesktopLink[MAX_PATH*2], exename[MAX_PATH*2];

	GetModuleFileName(NULL, exename, _countof(exename));
	lstrcpy(DesktopLink, GetDesktopFolder());
#ifdef _WIN64
	lstrcat(DesktopLink, "\\-k- [x64].lnk");
#else
	lstrcat(DesktopLink, "\\-k-.lnk");
#endif

	return MakeLinkIcon(exename, "/CA", DesktopLink, exename, -133) ? true : false;

	// -133 c {vOĂAk\ACRB̐́A\[Xԍwł邱Ƃ\B
}

// Context.exeփV[gJbgfXNgbvɍ쐬
bool makeShortcutIcon( const char *szShortcutName, const char *szParam, int iIconNum )
{
	char DesktopLink[MAX_PATH*2], exename[MAX_PATH*2];
	char szMes[MAX_PATH*2];

	wsprintf(szMes, "%sACRfXNgbvɍ쐬܂?", szShortcutName);
	if (IDNO == MessageBox( NULL, szMes, szTitle, MB_YESNO | MB_ICONQUESTION )) {
		return false;
	}

	GetModuleFileName(NULL, exename, _countof(exename));
	lstrcpy(DesktopLink, GetDesktopFolder());
	lstrcat(DesktopLink, "\\");
	lstrcat(DesktopLink, szShortcutName);
	lstrcat(DesktopLink, ".lnk");

	CoInitialize( NULL );
	BOOL rv = MakeLinkIcon(exename, szParam, DesktopLink, exename, iIconNum);
	CoUninitialize();
	if (rv) {
		wsprintf(szMes, "%sACR쐬܂B", szShortcutName);
		MessageBox( NULL, szMes, szTitle, MB_OK | MB_ICONINFORMATION );
		return true;
	}
	else {
		wsprintf(szMes, "%sACR̍쐬Ɏs܂B", szShortcutName);
		MessageBox( NULL, "kACR̍쐬Ɏs܂B", szTitle, MB_OK | MB_ICONSTOP );
		return false;
	}
}
