// bootrund.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "bootrund.h"

#define APP_NAME "X^[gAbvWXgĎ"
#define TIMER_ID	3639
#define ST_ICON_ID	58971
#define MYWM_NOTIFYICON 0x400
#define CO_STATUS	1
#define CO_TURNOFF	2
#define CO_TURNON	3

#define VERSION		"1.10"
#define C_YEAR		"2009"

// O[oϐ :
HINSTANCE hInst;								// ݂̃C^[tFCX
const char *szTitle = APP_NAME;
const char *szWindowClass = "rnsf7bootrund";
HICON	hMainIcon;

// 萔
const char *rnsf7regkey = "Software\\InaSoftAns\\Rnsf7\\CurrentVersion";
const char *runkey      = "Software\\Microsoft\\Windows\\CurrentVersion\\run";
const char *runkeyl01   = "Software\\InaSoftAns\\Rnsf7\\CurrentVersion\\lrun";
const char *runkeyl02   = "Software\\InaSoftAns\\Rnsf7\\CurrentVersion\\crun";

// ̃R[h W[Ɋ܂܂֐̐錾]܂ :
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE, LPTSTR lpCmdLine, int)
{
	HWND	mutexhd;
	MSG		msg;
	int		iCmdOpt = 0;

	if ( _stricmp(lpCmdLine, "/status") == 0 ) {
		// R}hC /status ꍇc
		//   łɏ풓Ă ccc G[R[hO
		//   풓ĂȂ     ccc G[R[hP
		iCmdOpt = CO_STATUS;
	}
	else if ( _stricmp(lpCmdLine, "/off") == 0 ) {
		// R}hC /off ꍇc
		//   łɏ풓Ă ccc 풓AG[R[hO
		//   풓ĂȂ     ccc ȂiG[bZ[WoȂjAG[R[hP
		iCmdOpt = CO_TURNOFF;
	}
	else if ( _stricmp(lpCmdLine, "/on") == 0 ) {
		// R}hC /on ꍇc
		//   łɏ풓Ă ccc ȂiG[bZ[WoȂjAG[R[hP
		//   풓ĂȂ     ccc 풓
		iCmdOpt = CO_TURNON;
	}

	// R-ScriptŁA{vO߂l󂯎邽߂ɂ́ACallExe() ֐
	// g܂B
	// {vOGUI^̃vOł邽߁AR}hC^v^
	// 󂯎邱Ƃ͂ł܂B

	// dN̖h~
	mutexhd = (HWND)CreateMutex(NULL, TRUE, szWindowClass);
	if (GetLastError() == ERROR_ALREADY_EXISTS) {
		if ( iCmdOpt == CO_STATUS ) {
			// R}hC /status ꍇŁAłɏ풓Ă ccc G[R[hO
			return 0;
		}
		else if ( iCmdOpt == CO_TURNOFF ) {
			// R}hC /off ꍇŁAłɏ풓Ă
			// @ccc 풓AG[R[hO
			HWND hWnd = FindWindow(szWindowClass, NULL);

			if ( hWnd ) {
                SendMessage( hWnd, WM_DESTROY, 0, NULL );
			}
			return 0;
		}
		else if ( iCmdOpt == CO_TURNON ) {
			// R}hC /on ꍇŁAłɏ풓Ă
			// @ccc ȂiG[bZ[WoȂjAG[R[hP
			return 1;
		}

		if ( IDYES == MessageBox(NULL, APP_NAME"́AłɋNĂ܂B\ñvOI܂H", szTitle, MB_OK | MB_ICONQUESTION | MB_YESNO) ) {
			HWND hWnd = FindWindow(szWindowClass, NULL);

			if ( hWnd ) {
				SendMessage( hWnd, WM_DESTROY, 0, NULL );
			}
		}
		return 0;
	}

	if ( iCmdOpt == CO_STATUS || iCmdOpt == CO_TURNOFF ) {
		// R}hC /status ꍇŁA풓ĂȂccc G[R[hP
		// R}hC /off ꍇŁA@@@@@@@@@V
		return 1;
	}

	// ACRnh̎擾
	hMainIcon = LoadIcon(hInstance, (LPCTSTR)IDI_BOOTRUND);

	// O[oĂ܂B
	MyRegisterClass(hInstance);

	// AvP[V̏s܂B:
	if ( !InitInstance(hInstance) ) {
		return 1;
	}

	// C bZ[W [v :
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (int)msg.wParam;
}

ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= hMainIcon;
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= NULL;

	return RegisterClassEx(&wcex);
}

BOOL InitInstance(HINSTANCE hInstance)
{
   HWND hWnd;

   hInst = hInstance; // O[oϐɃCX^Xi[܂B

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd) {
      return FALSE;
   }

   ShowWindow(hWnd, SW_HIDE);

   return TRUE;
}

void deleteEntrys( REG &reg2, HKEY hKey, const char *mes )
{
	char *value, *data, *data2;	// value:li[pϐ data:l̃f[^i[pϐ
	DWORD len, len2;		// l̒擾p
	DWORD lend, len2d;		// l̃f[^̒擾p
	int   i;				// JԂp
	bool  bResult;			// 폜

	RegQueryInfoKey( hKey, NULL, NULL, NULL, NULL, NULL, NULL, NULL, &len2, &len2d, NULL, NULL);

	len = len2 = (len2+1)*2; // WinNTnł̑΍
	lend = len2d = (len2d+1)*2;

	value = zalloc( len2 );
	data = zalloc( len2d );

	if ( value && data ) {
		i = 0;
		while ( ERROR_SUCCESS == RegEnumValue( hKey, i, value, &len, NULL, NULL, (LPBYTE)data, &lend ) ) {
			data2 = reg2.new_ReadString( value );
			if ( data2 ) {
				if ( strcmp(data, data2) == 0 ) {
					// Gg̍폜
					bResult = reg2.DeleteValue( value );

					// 폜|OɎc
					FILE *fp;
					char logname[MAX_PATH*2];
					char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], fn[_MAX_FNAME*2];

					// st@C̃tpXAƂ肠lognameɓĂ
					GetModuleFileName( NULL, logname, MAX_PATH*2 );

					_splitpath_s( logname, drv, _countof(drv), dir, _countof(dir), fn, _countof(fn), NULL, 0 );
					_makepath_s( logname, _countof(logname), drv, dir, fn, ".log" );

					if ( 0 == fopen_s( &fp, logname, "at" ) ) {
						SYSTEMTIME st;

						GetLocalTime( &st );
						fprintf( fp, "%4d/%2d/%2d %2d:%02d:%02d %s(%s) - %s\n",
							st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond,
							value, mes, bResult?"폜":"폜s" );

						fclose( fp );
					}
				}
				safedelete(data2);
			}

			len = len2;
			lend = len2d;
			i++;
		}
	}

	safefree( value );
	safefree( data );
}

void about(HWND hWnd)
{
	MessageBox(hWnd, APP_NAME " version " VERSION "\nCopyright(C) 2004-" C_YEAR " \n\n{vO̐ݒ́A[sĉB\nIɂ́A^XNgC̃ACRENbNĂB", szTitle, MB_OK | MB_ICONINFORMATION | MB_TOPMOST | MB_SETFOREGROUND);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	volatile static bool flag = 0; // \Ȃx̃Z}tH(^C}p)
	volatile static bool flag2 = 0; // \Ȃx̃Z}tH(j[/_CAOp)
	static UINT interval = 10000, uNoTaskTrayIcon = 0;
	static UINT s_uTaskbarRestart;// ^XNo[č쐬bZ[WhcێÓIϐ
	static HMENU hMenuPopup, hMenuSub;	// ^XNgCACRp|bvAbvj[

	switch (message) {
		case WM_CREATE:
			// ^C}̐ݒ
			{
				REG  reg;

				if ( reg.OpenKey( HKEY_CURRENT_USER, rnsf7regkey, TREG_OPEN_READONLY ) ) {
					interval = reg.ReadInteger( "rnsf7bootrund_interval", 10000 );
					uNoTaskTrayIcon = reg.ReadInteger( "rnsf7bootrund_icond", 0 );
					reg.CloseKey();
				}

				if ( !uNoTaskTrayIcon ) {
					// VXegCɃACRo^
					TFI_TaskBarAddIcon(hWnd, ST_ICON_ID, hMainIcon, APP_NAME, MYWM_NOTIFYICON);
					// ^XNo[č쐬bZ[Whc擾(Win95+IE`)
					s_uTaskbarRestart = RegisterWindowMessage(TEXT("TaskbarCreated"));
				}

				// gCACRpj[
				hMenuPopup = LoadMenu(hInst, (LPCSTR)IDR_MENU1);
				if (hMenuPopup) {
					// ftHgڂ𑾎ŕ\
					hMenuSub = GetSubMenu(hMenuPopup, 0);
					SetMenuDefaultItem(hMenuSub, 0, TRUE);
				}
				else {
					hMenuSub = 0;
				}

				SetTimer(hWnd, TIMER_ID, interval, NULL);
			}
			break;

		case WM_TIMER:
			if ( wParam == TIMER_ID && flag == 0 ) {
				REG  reg, reg2, reg2L;	// reg:Rnsf7̃L[ reg2:ĎΏۂ̃L[ reg2L:ꎞ폜̃L[

				flag = 1;				// Z}tH
				if ( reg.OpenKey( HKEY_CURRENT_USER, rnsf7regkey, TREG_OPEN_READONLY ) ) {
					// S[U[ݒ̊Ď
					if ( reg.ReadInteger( "rnsf7bootrund_all", 0 ) ) {
						if ( reg2.OpenKey( HKEY_LOCAL_MACHINE, runkey, TREG_OPEN_CREATE ) ) {
							if ( reg2L.OpenKey( HKEY_CURRENT_USER, runkeyl01, TREG_OPEN_READONLY ) ) {
								deleteEntrys( reg2, reg2L.GetHKey(), "HKEY_LOCAL_MACHINE - run" );
								reg2L.CloseKey();
							}
							reg2.CloseKey();
						}
					}

					// lpݒ̊Ď
					if ( reg.ReadInteger( "rnsf7bootrund_user", 0 ) ) {
						if ( reg2.OpenKey( HKEY_CURRENT_USER, runkey, TREG_OPEN_CREATE ) ) {
							if ( reg2L.OpenKey( HKEY_CURRENT_USER, runkeyl02, TREG_OPEN_READONLY ) ) {
								deleteEntrys( reg2, reg2L.GetHKey(), "HKEY_CURRENT_USER - run" );
								reg2L.CloseKey();
							}
							reg2.CloseKey();
						}
					}

					reg.CloseKey();
				}			
	
				KillTimer(hWnd, TIMER_ID);
				SetTimer(hWnd, TIMER_ID, interval, NULL);
				flag = 0;
			}
			break;

		case WM_DESTROY:
			// VXegCACR폜
			TFI_TaskBarDeleteIcon(hWnd, ST_ICON_ID);
			// ^C}
			KillTimer(hWnd, TIMER_ID);
			// j[폜
			if (hMenuPopup) {
				DestroyMenu(hMenuPopup);
				hMenuPopup = 0;
			}
			// I
			PostQuitMessage(0);
			break;

		case MYWM_NOTIFYICON:
			switch((UINT)lParam) {
				case WM_LBUTTONUP:
					if (!flag2) {
						flag2 = 1;
						about(hWnd);
						flag2 = 0;
					}
					break;

				case WM_RBUTTONUP:
					if (!flag2) {
						POINT pt;
						flag2 = 1;
						
						GetCursorPos(&pt);
						if ( hMenuSub ) {
							SetForegroundWindow(hWnd); // OʂɎĂȂƁANbNɃj[ĂȂ

							// j[\
							UINT uiCmd = (UINT)TrackPopupMenuEx(hMenuSub, TPM_RETURNCMD, pt.x, pt.y, hWnd, NULL);

							PostMessage(hWnd, WM_NULL, 0, 0); // ăj[J悤ɂ邽߂̂܂Ȃ

							switch(uiCmd) {
								case ID_TASKTRAYMENU_ABOUT: // o[W_CAO̕\
									about(hWnd);
									break;

								case ID_TASKTRAYMENU_CANCEL: // 풓
									if (IDYES == MessageBox(hWnd, APP_NAME"I܂?", szTitle, MB_YESNO | MB_ICONQUESTION | MB_TOPMOST | MB_SETFOREGROUND)) {
										DestroyWindow(hWnd);
									}
									break;
							}
						}
						flag2 = 0;
					}
					break;
			}
			break;

		default:
			if ( !uNoTaskTrayIcon ) {
				if(message == s_uTaskbarRestart) {
					TFI_TaskBarAddIcon(hWnd, ST_ICON_ID, hMainIcon, APP_NAME, MYWM_NOTIFYICON);
					break;
				}
			}
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}
