/*

  toolfunc.h
  Copyright(C) 2002-2014 INASOFT /Ayacy

  toolfunc.lib (ėpc[Cu) 𗘗p邽߂̃wb_t@C

*/

#ifndef MYLIB__ISTTOOLFUNC__
#define MYLIB__ISTTOOLFUNC__

#ifndef OWN__TOOLFUNC__
#pragma comment(lib, "toolfunc.lib")
#endif  /* OWN__TOOLFUNC__ */

#ifndef LibExport

#ifdef __cplusplus

#define LibExport extern "C"

#else /* __cplusplus */

#define LibExport extern

#endif /* __cplusplus */

#endif  /* LibExport */

#define TOOLFUNC_H_VERSIONNUMBER 40035

// toolfunc.lib̃o[WԍԂ
// ~10000{~100{[XNo.
LibExport DWORD toolfunclib_GetVersion( VOID );


#ifdef _UNICODE
#define addResizableBorder	addResizableBorderW
#else  /* _UNICODE */
#define addResizableBorder	addResizableBorderA
#endif /* _UNICODE */

// _CAOg̃EBhEɑ΂TCYύXguǉvA
// TCYł悤Ƀj[̒ǉsB
LibExport BOOL addResizableBorderA(HWND hWnd, const char    *name_resizeitem);
LibExport BOOL addResizableBorderW(HWND hWnd, const wchar_t *name_resizeitem);

// [Wnh̃Rs[쐬AEBhEɓKp
LibExport int SetWindowRgn2(HWND hWnd, HRGN hRgn, BOOL bRedraw);

// fname̒ɃXy[XA_uR[e[VtĕԂ
LibExport char    *insert_dcA(char    *fname);
LibExport wchar_t *insert_dcW(wchar_t *fname);

#ifdef __cplusplus

#include <string>
using namespace std;
extern bool insert_dcA(string  &fname);
extern bool insert_dcW(wstring &fname);
extern bool delete_dcA(string  &fname);
extern bool delete_dcW(wstring &fname);

#endif /* __cplusplus */

// fname̒_uR[e[VŎn܂ĂA[_uR[e[Vň͂܂Ă
// ݂ȂĎ菜iconstł͂܂Bŗ^ꂽ𒼐ڂ܂j
LibExport char    *delete_dcA(char    *fname);
LibExport wchar_t *delete_dcW(wchar_t *fname);

#ifdef _UNICODE
#define insert_dc	insert_dcW
#define delete_dc	delete_dcW
#else  /* _UNICODE */
#define insert_dc	insert_dcA
#define delete_dc	delete_dcA
#endif /* _UNICODE */

// 260`519oCgɂȂ悤ȃt@CꍇANSIFindFirstFilep\
typedef struct _WIN32_FIND_DATA520A {
    DWORD dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD nFileSizeHigh;
    DWORD nFileSizeLow;
    DWORD dwReserved0;
    DWORD dwReserved1;
    CHAR   cFileName[ MAX_PATH*2 ];
    CHAR   cAlternateFileName[ 14 ];
#ifdef _MAC
    DWORD dwFileType;
    DWORD dwCreatorType;
    WORD  wFinderFlags;
#endif
} WIN32_FIND_DATA520A, *PWIN32_FIND_DATA520A, *LPWIN32_FIND_DATA520A;

#ifdef _UNICODE
#define WIN32_FIND_DATA520		WIN32_FIND_DATAW
#define PWIN32_FIND_DATA520		PWIN32_FIND_DATAW
#define LPWIN32_FIND_DATA520	LPWIN32_FIND_DATAW
#else  /* _UNICODE */
#define WIN32_FIND_DATA520		WIN32_FIND_DATA520A
#define PWIN32_FIND_DATA520		PWIN32_FIND_DATA520A
#define LPWIN32_FIND_DATA520	LPWIN32_FIND_DATA520A
#endif /* _UNICODE */

// 260`519oCgɂȂ悤ȃt@CꍇANSIFindFirstFile/FindNextFile
LibExport HANDLE FindFirstFile520A(LPCSTR lpFileName, LPWIN32_FIND_DATA520 lpFindFileData);
LibExport BOOL   FindNextFile520A(HANDLE hFindFile, LPWIN32_FIND_DATA520 lpFindFileData);

#ifdef _UNICODE
#define FindFirstFile520	FindFirstFileW
#define FindNextFile520		FindNextFileW
#else  /* _UNICODE */
#define FindFirstFile520	FindFirstFile520A
#define FindNextFile520		FindNextFile520A
#endif /* _UNICODE */

// t@C݂邩ǂ
LibExport BOOL tFileExistA(const char    *fname);
LibExport BOOL tFileExistW(const wchar_t *fname);

#ifdef _UNICODE
#define tFileExist	tFileExistW
#else  /* _UNICODE */
#define tFileExist	tFileExistA
#endif /* _UNICODE */

// fobOp̃bZ[Wo
LibExport void DebugMesA(const char    *mes);
LibExport void DebugMesW(const wchar_t *mes);

#ifdef _UNICODE
#define DebugMes	DebugMesW
#else  /* _UNICODE */
#define DebugMes	DebugMesA
#endif /* _UNICODE */

// Windows NT I̎擾
LibExport void GetQuitRight(void);

// l10i̕ɒ (Ԃ̂͊֐staticȃobt@ւ̃|C^ł邱Ƃɒ)
LibExport char    *itoa10A(unsigned int n);
LibExport wchar_t *itoa10W(unsigned int n);
LibExport char    *s_itoa10A(int n);
LibExport wchar_t *s_itoa10W(int n);

// l16i̕ɒ (Ԃ̂͊֐staticȃobt@ւ̃|C^ł邱Ƃɒ)
LibExport char    *itoa16A(int n);
LibExport wchar_t *itoa16W(int n);

#ifdef _UNICODE
#define itoa10		itoa10W
#define s_itoa10	s_itoa10W
#define itoa16		itoa16W
#else  /* _UNICODE */
#define itoa10		itoa10A
#define s_itoa10	s_itoa10A
#define itoa16		itoa16A
#endif /* _UNICODE */

// LR֐̍ē\ŁB11/12/9oCg̕񂪊i[łobt@n)
#define itoa10exA(n,buf)    _ultoa((unsigned long)(n),(buf),10)
#define s_itoa10exA(n,buf)  _itoa((int)(n),(buf),10)
#define itoa16exA(n,buf)    _ultoa((unsigned long)(n),(buf),16)

#define itoa10exW(n,buf)    _ultow((unsigned long)(n),(buf),10)
#define s_itoa10exW(n,buf)  _itow((int)(n),(buf),10)
#define itoa16exW(n,buf)    _ultow((unsigned long)(n),(buf),16)

#define itoa10ex(n,buf)    _ultot((unsigned long)(n),(buf),10)
#define s_itoa10ex(n,buf)  _itot((int)(n),(buf),10)
#define itoa16ex(n,buf)    _ultot((unsigned long)(n),(buf),16)

// ut@C,ԍvACRnh𓾂
LibExport HICON LoadIconFromFileA(HINSTANCE hInst, const char    *fname_num);
LibExport HICON LoadIconFromFileW(HINSTANCE hInst, const wchar_t *fname_num);

#ifdef _UNICODE
#define LoadIconFromFile	LoadIconFromFileW
#else  /* _UNICODE */
#define LoadIconFromFile	LoadIconFromFileA
#endif /* _UNICODE */

// ut@C,ԍvAACRnh𓾂B傫TCYƏTCY̗B
LibExport UINT LoadIconFromFileExA(const char    *fname_num, HICON *phIcon, HICON *phSmallIcon);
LibExport UINT LoadIconFromFileExW(const wchar_t *fname_num, HICON *phIcon, HICON *phSmallIcon);

#ifdef _UNICODE
#define LoadIconFromFileEx	LoadIconFromFileExW
#else  /* _UNICODE */
#define LoadIconFromFileEx	LoadIconFromFileExA
#endif /* _UNICODE */

// Xgr[̃J[\ʒu擾
// LibExport int  GetLVCursor(HWND hListView);
#define GetLVCursor(h) ListView_GetNextItem(h,-1,LVNI_SELECTED)

// Xgr[̃TCY
LibExport void ResizeListView(HWND hParent, HWND hStatusBar, HWND hListView);

// Xgr[̃X^CύX
LibExport void ChangeLVStyle(HWND hWnd, HWND hwndListView, int style, BOOL Repaint);

// Unlha32.dllĂяoāAo[W擾
LibExport DWORD call_unlha32_GetVersion(VOID);

// Unlha32.dllĂяoāAgpݒ肷
// englishflag = TRUE:pꃂ[h / FALSE:{ꃂ[h
LibExport BOOL call_unlha32_UseEnglishMode(BOOL englishflag);

// Unlha32.dllĂяoāAJgfBNglzhname𓀂(_log͏o̓O擾)
LibExport int call_unlha32A(HWND hWnd, LPCSTR lzhname);
LibExport int call_unlha32W(HWND hWnd, LPCWSTR lzhname);
LibExport int call_unlha32_logA(HWND hWnd, LPCSTR  lzhname, LPSTR  szOutput, DWORD dwOutputSize); 
LibExport int call_unlha32_logW(HWND hWnd, LPCWSTR lzhname, LPWSTR szOutput, DWORD dwOutputSize); 

// Unlha32.dllĂяoāAwfBNglzhname𓀂(_log͏o̓O擾)
LibExport int call_unlha32dA(HWND hWnd, LPCSTR  lzhname, LPCSTR  dir);
LibExport int call_unlha32dW(HWND hWnd, LPCWSTR lzhname, LPCWSTR dir);
LibExport int call_unlha32d_logA(HWND hWnd, LPCSTR  lzhname, LPCSTR  dir, LPSTR  szOutput, DWORD dwOutputSize);
LibExport int call_unlha32d_logW(HWND hWnd, LPCWSTR lzhname, LPCWSTR dir, LPWSTR szOutput, DWORD dwOutputSize);

// Unlha32.dllĂяoāAX|Xt@CŎw肳ꂽt@CQlzhnameɈk(_log͏o̓O擾)
LibExport int call_unlha32rA(HWND hWnd, LPCSTR  lzhname, LPCSTR  response_file, LPCSTR  option);
LibExport int call_unlha32rW(HWND hWnd, LPCWSTR lzhname, LPCWSTR response_file, LPCWSTR option);
LibExport int call_unlha32r_logA(HWND hWnd, LPCSTR  lzhname, LPCSTR  response_file, LPCSTR  option, LPSTR  szOutput, DWORD dwOutputSize);
LibExport int call_unlha32r_logW(HWND hWnd, LPCWSTR lzhname, LPCWSTR response_file, LPCWSTR option, LPWSTR szOutput, DWORD dwOutputSize);

// Unlha32.dllĂяoāAlzhexe(WinSFX32)ɕϊ(s -gw1)(_log͏o̓O擾)
LibExport int call_unlha32_toexeA(HWND hWnd, LPCSTR  lzhname);
LibExport int call_unlha32_toexeW(HWND hWnd, LPCWSTR lzhname);
LibExport int call_unlha32_toexe_logA(HWND hWnd, LPCSTR  lzhname, LPSTR  szOutput, DWORD dwOutputSize);
LibExport int call_unlha32_toexe_logW(HWND hWnd, LPCWSTR lzhname, LPWSTR szOutput, DWORD dwOutputSize);

#ifdef _UNICODE
#define call_unlha32			call_unlha32W
#define call_unlha32_log		call_unlha32_logW
#define call_unlha32d			call_unlha32dW
#define call_unlha32d_log		call_unlha32d_logW
#define call_unlha32r			call_unlha32rW
#define call_unlha32r_log		call_unlha32r_logW
#define call_unlha32_toexe		call_unlha32_toexeW
#define call_unlha32_toexe_log	call_unlha32_toexe_logW
#else  /* _UNICODE */
#define call_unlha32			call_unlha32A
#define call_unlha32_log		call_unlha32_logA
#define call_unlha32d			call_unlha32dA
#define call_unlha32d_log		call_unlha32d_logA
#define call_unlha32r			call_unlha32rA
#define call_unlha32r_log		call_unlha32r_logA
#define call_unlha32_toexe		call_unlha32_toexeA
#define call_unlha32_toexe_log	call_unlha32_toexe_logA
#endif /* _UNICODE */

// Unlha32.dllĂяoāAUnlha()gpǂm߂
LibExport BOOL call_unlha32_getrunning( void );

// Unzip32.dllĂяoāAJgfBNgzipname𓀂(_log͏o̓O擾)
LibExport int call_unzip32(HWND hWnd, LPCSTR zipname);
LibExport int call_unzip32_log(HWND hWnd, LPCSTR zipname, LPSTR szOutput, DWORD dwOutputSize);

// Unzip32.dllĂяoāAwfBNgzipname𓀂(_log͏o̓O擾)
LibExport int call_unzip32d(HWND hWnd, LPCSTR zipname, LPCSTR dir);
LibExport int call_unzip32d_log(HWND hWnd, LPCSTR zipname, LPCSTR dir, LPSTR szOutput, DWORD dwOutputSize);

// Unzip32.dllĂяoāAUnzip()gpǂm߂
LibExport BOOL call_unzip32_getrunning( void );

// Zip32.dllĂяoāAX|Xt@CŎw肳ꂽt@CQzipnameɈk(_log͏o̓O擾)
LibExport int call_zip32j(HWND hWnd, LPCSTR zipname, LPCSTR response_file, LPCSTR option);
LibExport int call_zip32j_log(HWND hWnd, LPCSTR zipname, LPCSTR response_file, LPCSTR option, LPSTR szOutput, DWORD dwOutputSize);

// zip32j.dllĂяoāAzipexe(SFX)ɕϊ(--sfx)(_log͏o̓O擾)
LibExport int call_zip32_toexe(HWND hWnd, LPCSTR zipname);
LibExport int call_zip32_toexe_log(HWND hWnd, LPCSTR zipname, LPSTR szOutput, DWORD dwOutputSize);

// Zip32.dllĂяoāAZip()gpǂm߂
LibExport BOOL call_zip32j_getrunning( void );

// 7-Zip32.dllĂяoāAJgfBNgszname𓀂(x)(_log͏o̓O擾)
LibExport int call_7zip32(HWND hWnd, LPCSTR szname);
LibExport int call_7zip32_log(HWND hWnd, LPCSTR szname, LPSTR szOutput, DWORD dwOutputSize);

// 7-Zip32.dllĂяoāAwfBNgszname𓀂(x -o<dir>)(_log͏o̓O擾)
LibExport int call_7zip32d(HWND hWnd, LPCSTR szname, LPCSTR dir);
LibExport int call_7zip32d_log(HWND hWnd, LPCSTR szname, LPCSTR dir, LPSTR szOutput, DWORD dwOutputSize);

// 7-Zip32.dllĂяoāAXgt@CŎw肳ꂽt@CQsznameɈk(a -t??? ***)(_log͏o̓O擾)
LibExport int call_7zip32r(HWND hWnd, LPCSTR szname, LPCSTR list_file, LPCSTR option);
LibExport int call_7zip32r_log(HWND hWnd, LPCSTR szname, LPCSTR list_file, LPCSTR option, LPSTR szOutput, DWORD dwOutputSize);

// 7-Zip32.dllĂяoāASevenZip()gpǂm߂
LibExport BOOL call_7zip32_getrunning( void );

// OSZipFolder@\𗘗pAw肵tH_itpXjցAzipt@CWJ
// Windows XPȍ~ŁAzipWJ@\Lł邱ƁBUnicodeŊ֐̂ݒ
// 炩 CoInitialize() Ă!!
LibExport int Shell_UnZipW(LPWSTR zipfile, LPWSTR outfolder);

// TFI_TaskBarAddIcon - ^XNo[̒ʒmGAɃACRǉ
LibExport BOOL TFI_TaskBarAddIconA(HWND hwnd, UINT uID, HICON hicon, LPCSTR  lpszTip, int messageID);
LibExport BOOL TFI_TaskBarAddIconW(HWND hwnd, UINT uID, HICON hicon, LPCWSTR lpszTip, int messageID);

#ifdef _UNICODE
#define TFI_TaskBarAddIcon	TFI_TaskBarAddIconW
#else  /* _UNICODE */
#define TFI_TaskBarAddIcon	TFI_TaskBarAddIconA
#endif /* _UNICODE */

// TFI_TaskBarModifyIcon - ^XNo[̒ʒmGAɒǉACRύX
LibExport BOOL TFI_TaskBarModifyIconA(HWND hwnd, UINT uID, HICON hicon, LPCSTR  lpszTip, int messageID);
LibExport BOOL TFI_TaskBarModifyIconW(HWND hwnd, UINT uID, HICON hicon, LPCWSTR lpszTip, int messageID);

#ifdef _UNICODE
#define TFI_TaskBarModifyIcon	TFI_TaskBarModifyIconW
#else  /* _UNICODE */
#define TFI_TaskBarModifyIcon	TFI_TaskBarModifyIconA
#endif /* _UNICODE */

// TFI_TaskBarDeleteIcon - ^XNo[̒ʒmGAɒǉACR폜
LibExport BOOL TFI_TaskBarDeleteIconA(HWND hwnd, UINT uID);
LibExport BOOL TFI_TaskBarDeleteIconW(HWND hwnd, UINT uID);

#ifdef _UNICODE
#define TFI_TaskBarDeleteIcon	TFI_TaskBarDeleteIconW
#else  /* _UNICODE */
#define TFI_TaskBarDeleteIcon	TFI_TaskBarDeleteIconA
#endif /* _UNICODE */

// SHEmptyRecycleBin ̃R[ (ݔɂ) testflag = 1 APIpł邩ǂmF
LibExport BOOL EmptyRecycleBinA(BOOL testflag);
LibExport BOOL EmptyRecycleBinW(BOOL testflag);

#ifdef _UNICODE
#define EmptyRecycleBin		EmptyRecycleBinW
#else  /* _UNICODE */
#define EmptyRecycleBin		EmptyRecycleBinA
#endif /* _UNICODE */

// JgfBNĝƂɃZbg
LibExport BOOL SetCurrentDirectoryOwnDirA( void );
LibExport BOOL SetCurrentDirectoryOwnDirW( void );

#ifdef _UNICODE
#define SetCurrentDirectoryOwnDir		SetCurrentDirectoryOwnDirW
#else  /* _UNICODE */
#define SetCurrentDirectoryOwnDir		SetCurrentDirectoryOwnDirA
#endif /* _UNICODE */

// V[gJbg̍쐬
LibExport BOOL MakeLinkA(LPCSTR  exe, LPCSTR  args, LPCSTR  lnk);
LibExport BOOL MakeLinkW(LPCWSTR exe, LPCWSTR args, LPCWSTR lnk);

#ifdef _UNICODE
#define MakeLink	MakeLinkW
#else  /* _UNICODE */
#define MakeLink	MakeLinkA
#endif /* _UNICODE */

// V[gJbg̓ǂݏo
LibExport int QueryLinkA(const char    *pszLinkFile, char    *pszTarget, char    *pszOption,
						       char    *pszIcon,     int     *piIconIndex);
LibExport int QueryLinkW(const wchar_t *pszLinkFile, wchar_t *pszTarget, wchar_t *pszOption,
						       wchar_t *pszIcon,     int     *piIconIndex);

#ifdef _UNICODE
#define QueryLink	QueryLinkW
#else  /* _UNICODE */
#define QueryLink	QueryLinkA
#endif /* _UNICODE */

// V[gJbg̍쐬iACRj
LibExport BOOL MakeLinkIconA(LPCSTR  exe, LPCSTR  args, LPCSTR  lnk, LPCSTR  icon, int no);
LibExport BOOL MakeLinkIconW(LPCWSTR exe, LPCWSTR args, LPCWSTR lnk, LPCWSTR icon, int no);

#ifdef _UNICODE
#define MakeLinkIcon	MakeLinkIconW
#else  /* _UNICODE */
#define MakeLinkIcon	MakeLinkIconA
#endif /* _UNICODE */

// strdupnew
LibExport char    *new_strcpyA(const char    *src);
LibExport wchar_t *new_strcpyW(const wchar_t *src);

#ifdef _UNICODE
#define new_strcpy	new_strcpyW
#else  /* _UNICODE */
#define new_strcpy	new_strcpyA
#endif /* _UNICODE */

// new_strcpystrcat
LibExport char    *new_strcatA(char    *ptr, const char    *str);
LibExport wchar_t *new_strcatW(wchar_t *ptr, const wchar_t *str);

#ifdef _UNICODE
#define new_strcat	new_strcatW
#else  /* _UNICODE */
#define new_strcat	new_strcatA
#endif /* _UNICODE */

// realloc g strcat
LibExport char    *realloc_strcatA( char    *str1, const char    *str2 );
LibExport wchar_t *realloc_strcatW( wchar_t *str1, const wchar_t *str2 );

#ifdef _UNICODE
#define realloc_strcat	realloc_strcatW
#else  /* _UNICODE */
#define realloc_strcat	realloc_strcatA
#endif /* _UNICODE */

// strnڂ́AShift JIS̑1oCgڂ?
LibExport BOOL isKanji1A( const char *str, int n );
LibExport BOOL isKanji1W( const wchar_t *, int );

#ifdef _UNICODE
#define isKanji1	isKanji1W
#else  /* _UNICODE */
#define isKanji1	isKanji1A
#endif /* _UNICODE */

// X^[gj[:vÕtH_il[U[pj𓾂
LibExport char    *GetProgramFolderA(void);
LibExport wchar_t *GetProgramFolderW(void);

#ifdef _UNICODE
#define GetProgramFolder	GetProgramFolderW
#else  /* _UNICODE */
#define GetProgramFolder	GetProgramFolderA
#endif /* _UNICODE */

// X^[gj[:vÕtH_iS[U[pj𓾂
LibExport char    *GetCommonProgramFolderA(void);
LibExport wchar_t *GetCommonProgramFolderW(void);

#ifdef _UNICODE
#define GetCommonProgramFolder	GetCommonProgramFolderW
#else  /* _UNICODE */
#define GetCommonProgramFolder	GetCommonProgramFolderA
#endif /* _UNICODE */

// fXNgbvtH_il[U[pj𓾂
LibExport char    *GetDesktopFolderA(void);
LibExport wchar_t *GetDesktopFolderW(void);

#ifdef _UNICODE
#define GetDesktopFolder	GetDesktopFolderW
#else  /* _UNICODE */
#define GetDesktopFolder	GetDesktopFolderA
#endif /* _UNICODE */

// fXNgbvtH_𓾂iS[U[pj
LibExport char    *GetCommonDesktopFolderA(void);
LibExport wchar_t *GetCommonDesktopFolderW(void);

#ifdef _UNICODE
#define GetCommonDesktopFolder	GetCommonDesktopFolderW
#else  /* _UNICODE */
#define GetCommonDesktopFolder	GetCommonDesktopFolderA
#endif /* _UNICODE */

// X^[gAbvtH_il[U[pj𓾂
LibExport char    *GetStartUpFolderA(void);
LibExport wchar_t *GetStartUpFolderW(void);

#ifdef _UNICODE
#define GetStartUpFolder	GetStartUpFolderW
#else  /* _UNICODE */
#define GetStartUpFolder	GetStartUpFolderA
#endif /* _UNICODE */

// X^[gAbvtH_𓾂iS[U[pj
LibExport char    *GetCommonStartUpFolderA(void);
LibExport wchar_t *GetCommonStartUpFolderW(void);

#ifdef _UNICODE
#define GetCommonStartUpFolder	GetCommonStartUpFolderW
#else  /* _UNICODE */
#define GetCommonStartUpFolder	GetCommonStartUpFolderA
#endif /* _UNICODE */

// NfBNg(WindowstH_ł͂Ȃ)𓾂
LibExport char    *GetBootDirectoryA(void);
LibExport wchar_t *GetBootDirectoryW(void);

#ifdef _UNICODE
#define GetBootDirectory	GetBootDirectoryW
#else  /* _UNICODE */
#define GetBootDirectory	GetBootDirectoryA
#endif /* _UNICODE */

// _CAO當ǂ݂ƂÂ܂ܗ̈悲ƕԂBƂ delete[] 邱ƁI
LibExport char    *new_GetDlgItemTextA(HWND hDlg, int nIDDlgItem);
LibExport wchar_t *new_GetDlgItemTextW(HWND hDlg, int nIDDlgItem);

#ifdef _UNICODE
#define new_GetDlgItemText	new_GetDlgItemTextW
#else  /* _UNICODE */
#define new_GetDlgItemText	new_GetDlgItemTextA
#endif /* _UNICODE */

// structure for CreateToolTip()
//
struct DEFTOOLTIPA {
	int cid;
	char *tip;
};
struct DEFTOOLTIPW {
	int cid;
	wchar_t *tip;
};

#ifdef _UNICODE
#define DEFTOOLTIP	DEFTOOLTIPW
#else  /* _UNICODE */
#define DEFTOOLTIP	DEFTOOLTIPA
#endif /* _UNICODE */

// c[`bv̍쐬
LibExport HWND CreateToolTipA(HINSTANCE hInst, HWND hWnd, const struct DEFTOOLTIPA *dtt);
LibExport HWND CreateToolTipW(HINSTANCE hInst, HWND hWnd, const struct DEFTOOLTIPW *dtt);

#ifdef _UNICODE
#define CreateToolTip	CreateToolTipW
#else  /* _UNICODE */
#define CreateToolTip	CreateToolTipA
#endif /* _UNICODE */

// w肵_CAO̎qEBhE(Rg[)̃tHg MS UI Gothic ɂĂ܂
LibExport void SetChildWindowFont(HWND hWnd);

// \B
LibExport BOOL TextOutLengthA(HDC hdc, const char    *str, int x0, int y0);
LibExport BOOL TextOutLengthW(HDC hdc, const wchar_t *str, int x0, int y0);
#define tTextOutA(h,x,y,s) TextOutLengthA(h,s,x,y)
#define tTextOutW(h,x,y,s) TextOutLengthW(h,s,x,y)

#ifdef _UNICODE
#define TextOutLength	TextOutLengthW
#define tTextOut		tTextOutW
#else  /* _UNICODE */
#define TextOutLength	TextOutLengthA
#define tTextOut		tTextOutA
#endif /* _UNICODE */

// w肳ꂽlp̒ɁA\(sAst)B
LibExport int DrawTextRectA(HDC hdc, const char    *str, int x0, int y0, int x1, int y1);
LibExport int DrawTextRectW(HDC hdc, const wchar_t *str, int x0, int y0, int x1, int y1);

#ifdef _UNICODE
#define DrawTextRect	DrawTextRectW
#else  /* _UNICODE */
#define DrawTextRect	DrawTextRectA
#endif /* _UNICODE */

// w肳ꂽEChE𔼓ɂ n:l
LibExport int SetExl(HWND hWnd, BYTE n);

// w肳ꂽEChẼl𓾂
LibExport int GetExl(HWND hWnd);

// GfBbg{bNX̒glǂāA 0 
LibExport BOOL CheckNumericDlgEdit(HWND hWnd, WORD id);

// 16i10i
LibExport int atoi16A(const char    *str);
LibExport int atoi16W(const wchar_t *str);

#ifdef _UNICODE
#define atoi16	atoi16W
#else  /* _UNICODE */
#define atoi16	atoi16A
#endif /* _UNICODE */

// 3Ƃ̃J}t (staticȗ̈Ԃ)
LibExport char    *commaA(unsigned int value);
LibExport wchar_t *commaW(unsigned int value);

#ifdef _UNICODE
#define comma	commaW
#else  /* _UNICODE */
#define comma	commaA
#endif /* _UNICODE */

// 3Ƃ̃J}t (ē\ŁB14oCg̕񂪊i[łobt@n)
LibExport char    *commaexA(unsigned int value, char    *buf);
LibExport wchar_t *commaexW(unsigned int value, wchar_t *buf);

#ifdef _UNICODE
#define commaex	commaexW
#else  /* _UNICODE */
#define commaex	commaexA
#endif /* _UNICODE */

// tpXt@C̕o (_uR[e[VƂ܂܂)
LibExport const char    *GetOnlyFileNameA(const char    *path);
LibExport const wchar_t *GetOnlyFileNameW(const wchar_t *path);

#ifdef _UNICODE
#define GetOnlyFileName	GetOnlyFileNameW
#else  /* _UNICODE */
#define GetOnlyFileName	GetOnlyFileNameA
#endif /* _UNICODE */

#define basenameA(fn) GetOnlyFileNameA(fn)
#define basenameW(fn) GetOnlyFileNameW(fn)

#ifdef _UNICODE
#define basename	basenameW
#else  /* _UNICODE */
#define basename	basenameA
#endif /* _UNICODE */

// tH_̍쐬(etH_ȂĂIɍ쐬)
LibExport int  CreateDirA(const char    *dirname);
LibExport int  CreateDirW(const wchar_t *dirname);

#ifdef _UNICODE
#define CreateDir	CreateDirW
#else  /* _UNICODE */
#define CreateDir	CreateDirA
#endif /* _UNICODE */

// UINT
LibExport unsigned atouA(const char    *str);
LibExport unsigned atouW(const wchar_t *str);

#ifdef _UNICODE
#define atou	atouW
#else  /* _UNICODE */
#define atou	atouA
#endif /* _UNICODE */

// fBNĝ݂𔲂o
// fullpath̃fBNg̕dirbufɏoB
// fullpath̃|C^dirbuf̃|C^wĂ悪ł悢
//  dirbuf ԂAsNULLԂ
LibExport char    *getDirectoryNameA(const char    *fullpath, char    *dirbuf, int dirbufsize);
LibExport wchar_t *getDirectoryNameW(const wchar_t *fullpath, wchar_t *dirbuf, int dirbufsize);

#ifdef _UNICODE
#define getDirectoryName	getDirectoryNameW
#else  /* _UNICODE */
#define getDirectoryName	getDirectoryNameA
#endif /* _UNICODE */

// gq菜𔲂o
// fullpath̃fBNg{t@C̕dirbufɏoB
// fullpath̃|C^dirbuf̃|C^wĂ悪ł悢
//  dirbuf ԂAsNULLԂ
LibExport char    *getFileNameOnlyA(const char    *fullpath, char    *fnamebuf, int fnamebufsize);
LibExport wchar_t *getFileNameOnlyW(const wchar_t *fullpath, wchar_t *fnamebuf, int fnamebufsize);

#ifdef _UNICODE
#define getFileNameOnly	getFileNameOnlyW
#else  /* _UNICODE */
#define getFileNameOnly	getFileNameOnlyA
#endif /* _UNICODE */

// Xgr[ hListview  n sڂ c ڂ̕𓾂āAcalloc ŊmۂzԂ
LibExport char    *lvGetItemStringA( HWND hListview, unsigned n, unsigned c );
LibExport wchar_t *lvGetItemStringW( HWND hListview, unsigned n, unsigned c );

#ifdef _UNICODE
#define lvGetItemString	lvGetItemStringW
#else  /* _UNICODE */
#define lvGetItemString	lvGetItemStringA
#endif /* _UNICODE */

// SJISł邱ƂlAstrlwr
LibExport char *sjislwr(char *str);

// SJISł邱ƂlAstrupr
LibExport char *sjisupr(char *str);

// SJISł邱ƂlAstrstr, strstriB
LibExport char *sjisstr( const char *str1, const char *str2 );
LibExport char *sjisstri( const char *str1, const char *str2 );

// 召łstrstr
LibExport char    *strstriA( const char    *str1, const char    *str2 );
LibExport wchar_t *strstriW( const wchar_t *str1, const wchar_t *str2 );

#ifdef _UNICODE
#define strstri	strstriW
#else  /* _UNICODE */
#define strstri	strstriA
#endif /* _UNICODE */

// strrep1rep2ɒu
// ߂lFϊ̕ւ̃|C^BgI邱
LibExport char    *replacestrA( const char    *str, const char    *rep1, const char    *rep2 );
LibExport wchar_t *replacestrW( const wchar_t *str, const wchar_t *rep1, const wchar_t *rep2 );

#ifdef _UNICODE
#define replacestr	replacestrW
#else  /* _UNICODE */
#define replacestr	replacestrA
#endif /* _UNICODE */

// GetLastError()̖߂lnƁAG[bZ[W𕶎ɂĕԋp(߂l͉Ȃ)
LibExport char    *getLastErrorStringMJPA(BOOL modeJP, DWORD errorcode);
LibExport wchar_t *getLastErrorStringMJPW(BOOL modeJP, DWORD errorcode);

#ifdef _UNICODE
#define getLastErrorString(X)	getLastErrorStringMJPW(1,X)
#define getLastErrorStringMJP   getLastErrorStringMJPW
#else  /* _UNICODE */
#define getLastErrorString(X)	getLastErrorStringMJPA(1,X)
#define getLastErrorStringMJP	getLastErrorStringMJPA
#endif /* _UNICODE */

// |Cg쐬
// @Fname = 쐬镜|Cgɕt閼O(MAX_DESCoCg܂)
// ߂lF ERROR_SUCCESS(0), s 0ȊO
LibExport UINT createRestorePointA( const char    *name );
LibExport UINT createRestorePointW( const wchar_t *name );

#ifdef _UNICODE
#define createRestorePoint	createRestorePointW
#else  /* _UNICODE */
#define createRestorePoint	createRestorePointA
#endif /* _UNICODE */

// Xgr[̎w肳ꂽڂ̃ACRԍ擾
LibExport int lvGetIconNumber( HWND hListView, int cur );

// Xgr[̎w肳ꂽڂLPARAM擾
LibExport LPARAM lvGetLParam( HWND hListView, int cur );

// t@Cw肵āAt@CTCY擾BAt@CTCY2GB܂ŁBt@C݂Ȃꍇ -1 Ԃ
LibExport DWORD getFileSizeA( const char    *fname );
LibExport DWORD getFileSizeW( const wchar_t *fname );

#ifdef _UNICODE
#define getFileSize	getFileSizeW
#else  /* _UNICODE */
#define getFileSize	getFileSizeA
#endif /* _UNICODE */

// t@Cw肵āAt@CTCY擾BAt@CTCY̏QWORD. t@C݂Ȃꍇ -1 Ԃ
LibExport UINT64 getFileSizeQA( const char    *fname );
LibExport UINT64 getFileSizeQW( const wchar_t *fname );

#ifdef _UNICODE
#define getFileSizeQ	getFileSizeQW
#else  /* _UNICODE */
#define getFileSizeQ	getFileSizeQA
#endif /* _UNICODE */

// Windows̃o[WA~100+ŕԂ
LibExport WORD tf_getWinVer( void );

// Windows̃vbgtH[IDԂ
LibExport DWORD tf_GetPlatform( void );

// Windows NTn
#define tf_isNT()	1

// dir + file sAdir Ɋi[(t@C_uR[e[Vň͂܂Ȃ)
LibExport char    *dir_add_fileA( char    *dir, const char    *fname );
LibExport wchar_t *dir_add_fileW( wchar_t *dir, const wchar_t *fname );

#ifdef _UNICODE
#define dir_add_file	dir_add_fileW
#else  /* _UNICODE */
#define dir_add_file	dir_add_fileA
#endif /* _UNICODE */

// dir ̌ \ tĂȂꍇ \ t(t@C_uR[e[Vň͂܂Ȃ)
LibExport char    *dir_add_bsA( char    *dir );
LibExport wchar_t *dir_add_bsW( wchar_t *dir );

#ifdef _UNICODE
#define dir_add_bs	dir_add_bsW
#else  /* _UNICODE */
#define dir_add_bs	dir_add_bsA
#endif /* _UNICODE */

// }`oCg烏ChLN^ւ̕ϊBт̋tB(gpfreeŊJ邱)
LibExport wchar_t *mb2wc( const char *mbstr );
LibExport char    *wc2mb( const wchar_t *wcstr );

// t@CMD5Zo
// fname : t@C
// md5   : char [33] ^zBMD5̎Zoʂ𕶎ɂĊi[
// cbfunc: i󋵂`邽߂̃R[obN֐BsvȏꍇNULLB߂lFALSȄꍇ͏f
// ߂l: =1As=0ismd5̎wAhX̒̃f[^͕ςȂj
typedef BOOL(*md5file_callback)(long lNow, long lMax);
LibExport BOOL md5fileA( const char    *fname, char    *md5, md5file_callback cbfunc );
LibExport BOOL md5fileW( const wchar_t *fname, wchar_t *md5, md5file_callback cbfunc );

#ifdef _UNICODE
#define md5file	md5fileW
#else  /* _UNICODE */
#define md5file	md5fileA
#endif /* _UNICODE */

// ̃f[^MD5Zo
// data  : f[^̊i[ꂽ̐擪AhX
// datalength : data̒ioCgPʁj
// md5   : char [33] ^zBMD5̎Zoʂ𕶎ɂĊi[
// ߂l: =1As=0ismd5̎wAhX̒̃f[^͕ςȂj
LibExport BOOL md5dataA( const void *data, int datalength, char    *md5 );
LibExport BOOL md5dataW( const void *data, int datalength, wchar_t *md5 );

#ifdef _UNICODE
#define md5data	md5dataW
#else  /* _UNICODE */
#define md5data	md5dataA
#endif /* _UNICODE */

// MD5l擾EriArMD5'x'32ȂrȂ
// fname    : `FbNΏۂ̃t@C(NULL̂Ƃ́AvOgp)
// root     : ŏINL^邽߂̃WXg̃nCu
// regkey   : ŏINL^邽߂̃WXg̃L[
// lasttime : O񐳏NԂ32oCgȏ̃GA(NULL̂Ƃ͖)
//   ȂAroot == NULL ̏ꍇ́Aregkey t@CƌȂāA֋L^B
//   regkey == NULL ̎́AL^sȂB
// ߂l = 0 : MD5svA 1 : MD5vA 2 : A 3 : vO擾s
LibExport int md5FileCheckA( const char    *fname, HKEY root, const char    *regkey, char    *lasttime );
LibExport int md5FileCheckW( const wchar_t *fname, HKEY root, const wchar_t *regkey, wchar_t *lasttime );

#ifdef _UNICODE
#define md5FileCheck	md5FileCheckW
#else  /* _UNICODE */
#define md5FileCheck	md5FileCheckA
#endif /* _UNICODE */

// WOW6432bitvZXƂĎsĂꍇATRUEԂBłȂꍇFALSEԂB
LibExport BOOL tf_IsWow64Process();

// w肳ꂽvZXAWOW6432bitvZXƂĎsĂꍇATRUEԂBłȂꍇFALSEԂB
LibExport BOOL tf_IsWow64ProcessHandle(HANDLE hProcess);


// ݂̃XbhɂAWOW64ɂt@C_CNV(System32SysWOW64)𖳌B0ȊO̒lԂB
// ɂ́Ã݂_CNg邩ǂ̏Ԃ邽߂̕ϐւ̃|C^w肷B
LibExport BOOL tf_Wow64DisableWow64FsRedirection(PVOID *pOldValue);

// ݂̃XbhɂAWOW64ɂt@C_CNV(System32SysWOW64)ȌԂɖ߂B0ȊO̒lԂB
// ɂ́Ã݂_CNg邩ǂ̏Ԃ邽߂̕ϐw肷B́AWow64DisableWow64FsRedirection
// ֓ꂽƂɓꂽlƂȂB܂AWow64DisableWow64FsRedirectionȌԂɕAƂƂɂȂB
LibExport BOOL tf_Wow64RevertWow64FsRedirection(PVOID OldValue);

// JgfBNgWindowsSystem32tH_ɈڂĂDLLLoad
LibExport HMODULE LoadLibrary_System32W(const wchar_t* pwzFileName);
LibExport HMODULE LoadLibrary_System32A(const char *pszFileName);

#ifdef _UNICODE
#define LoadLibrary_System32	LoadLibrary_System32W
#else  /* _UNICODE */
#define LoadLibrary_System32	LoadLibrary_System32A
#endif /* _UNICODE */

// ċAIɃtH_̃t@C폜
LibExport int emptyDirectoryW(LPCWSTR folder, FILETIME *bf_ft);	// [Unicode]
LibExport int emptyDirectoryA(LPCSTR folder, FILETIME *bf_ft);	// [ANSI]

#ifdef _UNICODE
#define emptyDirectory			emptyDirectoryW
#else  /* _UNICODE */
#define emptyDirectory			emptyDirectoryA
#endif /* _UNICODE */

// flags for call_unlha32x(), call_unzip32x() and call_zip32j()
//
#ifndef T_TF_SUCCESS
#define T_TF_SUCCESS		0
#define T_TF_DLLNOTFOUND	1
#define T_TF_ILLEGALDLL		2
#define T_TF_ERROR			3
#define T_TF_ILLEGALCALL	4
#endif /* T_TF_SUCCESS */

// flags for SHEmptyRecycleBin()
//
#ifndef SHERB_NOCONFIRMATION
#define SHERB_NOCONFIRMATION    0x00000001
#define SHERB_NOPROGRESSUI      0x00000002
#define SHERB_NOSOUND           0x00000004
#endif /* SHERB_NOCONFIRMATION */

// a flag for GetExl()/SetExl()
//
#ifndef WS_EX_LAYERED
  #define WS_EX_LAYERED		0x80000
  #define WS_EX_NOACTIVATE	0x8000000
#endif /* WS_EX_LAYERED */

// a flag for isKanji1()
//
#ifndef ISKANJI1M
#define ISKANJI1MA(x) ((0x81 <= ((unsigned char)(x)) && ((unsigned char)(x)) <= 0x9F) || (0xE0 <= ((unsigned char)(x)) && ((unsigned char)(x)) <= 0xEF) || (0xF0 <= ((unsigned char)(x)) && ((unsigned char)(x)) <= 0xFC))
#define ISKANJI1MW(x) (0)

#ifdef _UNICODE
#define ISKANJI1M	ISKANJI1MW
#else  /* _UNICODE */
#define ISKANJI1M	ISKANJI1MA
#endif /* _UNICODE */

#endif /* ISKANJI1M */

#ifndef UBOUND
// z̃TCYvZ(_countofƓ)
#define UBOUND(array) (sizeof(array)/sizeof(array[0]))
#endif /* UBOUND */

#ifndef mstrncmp
#define mstrncmp(str1,str2) strncmp((str1),(str2),strlen(str2))
#endif /* mstrncmp */

#ifndef mwcsncmp
#define mwcsncmp(str1,str2) wcsncmp((str1),(str2),wcslen(str2))
#endif /* mwcsncmp */

#ifndef debwrite
#define debwrite(str1) {FILE *fp;if(NULL!=(fp=fopen("temp.txt","at"))){fputs(str1,fp);fclose(fp);}}
#endif /* debwrite */

// 戵DLL
#define UNLHA32DLL	    "unlha32.dll"
#define L_UNLHA32DLL    L"unlha32.dll"
#define UNZIP32DLL	    "unzip32.dll"
#define ZIP32JDLL       "zip32j.dll"
#define SEVENZIP32DLL	"7-zip32.dll"

#ifdef _WIN64
#define UNLHA64DLL	    "unlha64.dll"
#define L_UNLHA64DLL    L"unlha64.dll"
#define UNZIP64DLL	    "unzip64.dll"
#define ZIP64JDLL       "zip64j.dll"
#define SEVENZIP64DLL	"7-zip64.dll"
#endif

// safefree() and safedelete() macro
//
#ifndef safefree
#define safefree(p)   {if(p){free((void *)(p));p=0;}}
#define safedelete(p) {if(p){delete[] p;p=0;}}
#define safedelete1(p) {if(p){delete p;p=0;}}
#define safegfree(h)  {if(h){GlobalFree(h);h=0;}}
#define zalloc(n)     ((char *)calloc((n),sizeof(char)))
#define walloc(n)     ((wchar_t *)calloc((n),sizeof(wchar_t)))
#define talloc(n)     ((TCHAR *)calloc((n),sizeof(TCHAR)))
#endif /* safefree */

// ATML`FbN
// ݂͖͉ꂽƌȂ̂ŁAK0Ԃ悤ɂB
#define ATML_ENABLED 0
// 1:`FbNNG, 0:`FbNOK
LibExport int checkAtmlA();
LibExport int checkAtmlW();

#ifdef _UNICODE
#define checkAtml	checkAtmlW
#else  /* _UNICODE */
#define checkAtml	checkAtmlA
#endif /* _UNICODE */

#endif /* MYLIB__ISTTOOLFUNC__ */
