// toolfunc.cpp : ėpc[Cu
/*

@Copyright(C) 2002-2014 INASOFT /Ayacy

@́ATOOLFUNC.LIB 𐶐邽߂̃\[XvOłB
@WindowsAʂDLLA̖ʓIɈ߂̃[eBeBn
@֐܂܂Ă܂B

*/

#include "stdafx.h"

#define OWN__TOOLFUNC__

#include "toolfunc.h"

// _CAOg̃EBhEɑ΂TCYύXguǉvA
// TCYł悤Ƀj[̒ǉsB
LibExport BOOL addResizableBorderA(HWND hWnd, const char    *name_resizeitem)
{
	if (hWnd && IsWindow(hWnd)) {
		// TCYύXgǉ
		LONG_PTR lpStyle = GetWindowLongPtr(hWnd, GWL_STYLE);
		if (0 != SetWindowLongPtr(hWnd, GWL_STYLE, lpStyle | WS_THICKFRAME)) {
			// TCYł悤Ƀj[ǉ
			HMENU hSysMenu = GetSystemMenu(hWnd, FALSE);
			if (hSysMenu) {
				if (AppendMenuA(hSysMenu, MF_STRING, SC_SIZE, name_resizeitem)) {
					return TRUE;
				}
			}
		}
	}
	
	return FALSE;
}

LibExport BOOL addResizableBorderW(HWND hWnd, const wchar_t *name_resizeitem)
{
	if (hWnd && IsWindow(hWnd)) {
		// TCYύXgǉ
		LONG_PTR lpStyle = GetWindowLongPtr(hWnd, GWL_STYLE);
		if (0 != SetWindowLongPtr(hWnd, GWL_STYLE, lpStyle | WS_THICKFRAME)) {
			// TCYł悤Ƀj[ǉ
			HMENU hSysMenu = GetSystemMenu(hWnd, FALSE);
			if (hSysMenu) {
				if (AppendMenuW(hSysMenu, MF_STRING, SC_SIZE, name_resizeitem)) {
					return TRUE;
				}
			}
		}
	}
	
	return FALSE;
}

// toolfunc.lib̃o[WԍԂ
// ~10000{~100{[XNo.
LibExport DWORD toolfunclib_GetVersion( VOID )
{
	return TOOLFUNC_H_VERSIONNUMBER;
}

// [WRs[ݒ
int SetWindowRgn2(HWND hWnd, HRGN hRgn, BOOL bRedraw)
{
	if ( hRgn == NULL ) {
		// [WNULLɐݒ
		return SetWindowRgn( hWnd, NULL, bRedraw );
	}
	else {
		HRGN hRgn2 = CreateRectRgn( 0, 0, 0, 0 ); 
		CombineRgn(hRgn2, hRgn, 0, RGN_COPY);
		int iRet = SetWindowRgn( hWnd, hRgn2, bRedraw );

		if ( iRet == 0 ) {
			// [W̐ݒɎs
			DeleteObject(hRgn2);
		}
		return iRet;
	}
}

// fname̒ɃXy[XA_uR[e[VtĕԂ
// fname̓eł̓_
LibExport char *insert_dcA(char *fname)
{
	int  i, n;
	char *fn;
	
	if ( fname ) {
		if ( fname[0] == '"' ) {
			return fname;
		}
		else {
			n = lstrlen(fname);

			for(i=0 ; i<n ; i++) {
				if (fname[i] == ' ') {
					fn = zalloc(n+1);
					lstrcpy(fn,fname);
					wsprintf(fname,"\"%s\"",fn);
					safefree(fn);
					break;
				}
			}

			return fname;
		}
	}
	return NULL;
}

LibExport wchar_t *insert_dcW(wchar_t *fname)
{
	int  i, n;
	wchar_t *fn;
	
	if ( fname ) {
		if ( fname[0] == L'"' ) {
			return fname;
		}
		else {
			n = lstrlenW(fname);

			for(i=0 ; i<n ; i++) {
				if (fname[i] == ' ') {
					fn = walloc(n+1);
					lstrcpyW(fn, fname);
					wsprintfW(fname, L"\"%s\"", fn);
					safefree(fn);
					break;
				}
			}

			return fname;
		}
	}
	return NULL;
}

// std::stringo[W
// _uR[e[V true Ԃ
bool insert_dcA(string &fname)
{
	if ( !fname.empty() ) {
		// 󕶎łȂ
		if ( fname[0] != '"' ) {
			// łɃ_uR[e[Vň͂܂Ă킯łȂ
			if ( fname.find(' ') != string::npos ) {
				// Xy[X܂܂ĂȂ
				// _uR[e[Vň͂
				fname.insert(0, "\"");
				fname.append("\"");
				return true;
			}
		}
	}

	return false;
}

bool insert_dcW(wstring &fname)
{
	if ( !fname.empty() ) {
		// 󕶎łȂ
		if ( fname[0] != L'"' ) {
			// łɃ_uR[e[Vň͂܂Ă킯łȂ
			if ( fname.find(L' ') != wstring::npos ) {
				// Xy[X܂܂ĂȂ
				// _uR[e[Vň͂
				fname.insert(0, L"\"");
				fname.append(L"\"");
				return true;
			}
		}
	}

	return false;
}

// fname̒_uR[e[VŎn܂ĂA[_uR[e[Vň͂܂Ă
// ݂ȂĎ菜iconstł͂܂Bŗ^ꂽ𒼐ڂ܂j
LibExport char *delete_dcA(char *fname)
{
	if ( fname != NULL && fname[0] == '"' ) {
		int n = lstrlen(fname) - 2;
		int i;

		for(i=0 ; i<n ; ++i) {
			fname[i] = fname[i+1];
		}

		fname[i] = 0;
	}
	return fname;
}

LibExport wchar_t *delete_dcW(wchar_t *fname)
{
	if ( fname != NULL && fname[0] == L'"' ) {
		int n = lstrlenW(fname) - 2;
		int i;

		for(i=0 ; i<n ; ++i) {
			fname[i] = fname[i+1];
		}

		fname[i] = 0;
	}
	return fname;
}

// std::stringo[W
// _uR[e[V菜 true Ԃ
bool delete_dcA(string &fname)
{
	if ( !fname.empty() ) {
		// 󕶎łȂ
		if ( fname[0] == '"' ) {
			// łɃ_uR[e[Vň͂܂Ă
			fname.erase(0, 1);
			fname.erase(fname.end()-1);
			return true;
		}
	}

	return false;
}

bool delete_dcW(wstring &fname)
{
	if ( !fname.empty() ) {
		// 󕶎łȂ
		if ( fname[0] == L'"' ) {
			// łɃ_uR[e[Vň͂܂Ă
			fname.erase(0, 1);
			fname.erase(fname.end()-1);
			return true;
		}
	}

	return false;
}

// 260`519oCgɂȂ悤ȃt@CꍇANSIFindFirstFile
LibExport HANDLE FindFirstFile520A(LPCSTR lpFileName, LPWIN32_FIND_DATA520 lpFindFileData)
{
	HANDLE hResult;

	if (lpFileName == NULL || lpFindFileData == NULL) { // ̓G[
		return INVALID_HANDLE_VALUE;
	}

	ZeroMemory(lpFindFileData, sizeof(LPWIN32_FIND_DATA520));
	if (tf_isNT()) {
		WIN32_FIND_DATAW ffd;

		ZeroMemory(&ffd, sizeof(ffd));

		wchar_t *strFileName = mb2wc(lpFileName);
		hResult = FindFirstFileW(strFileName, &ffd);
		free(strFileName);
		if (hResult != INVALID_HANDLE_VALUE) {
			lpFindFileData->dwFileAttributes = ffd.dwFileAttributes;
    		lpFindFileData->ftCreationTime = ffd.ftCreationTime;
    		lpFindFileData->ftLastAccessTime = ffd.ftLastAccessTime;
    		lpFindFileData->ftLastWriteTime = ffd.ftLastWriteTime;
    		lpFindFileData->nFileSizeHigh = ffd.nFileSizeHigh;
    		lpFindFileData->nFileSizeLow = ffd.nFileSizeLow;
    		lpFindFileData->dwReserved0 = ffd.dwReserved0;
    		lpFindFileData->dwReserved1 = ffd.dwReserved1;
			WideCharToMultiByte(GetACP(), 0, ffd.cFileName, -1,
				                lpFindFileData->cFileName, sizeof(lpFindFileData->cFileName), NULL, NULL);
			WideCharToMultiByte(GetACP(), 0, ffd.cAlternateFileName, -1,
				                lpFindFileData->cAlternateFileName, sizeof(lpFindFileData->cAlternateFileName), NULL, NULL);
			
#ifdef _MAC
    		lpFindFileData->dwFileType = ffd.dwFileType;
    		lpFindFileData->dwCreatorType = ffd.dwCreatorType;
    		lpFindFileData->wFinderFlags = ffd.wFinderFlags;
#endif
		}
	}
	else {
		WIN32_FIND_DATAA ffd;

		ZeroMemory(&ffd, sizeof(ffd));

		hResult = FindFirstFileA(lpFileName, &ffd);
		if (hResult != INVALID_HANDLE_VALUE) {
			lpFindFileData->dwFileAttributes = ffd.dwFileAttributes;
    		lpFindFileData->ftCreationTime = ffd.ftCreationTime;
    		lpFindFileData->ftLastAccessTime = ffd.ftLastAccessTime;
    		lpFindFileData->ftLastWriteTime = ffd.ftLastWriteTime;
    		lpFindFileData->nFileSizeHigh = ffd.nFileSizeHigh;
    		lpFindFileData->nFileSizeLow = ffd.nFileSizeLow;
    		lpFindFileData->dwReserved0 = ffd.dwReserved0;
    		lpFindFileData->dwReserved1 = ffd.dwReserved1;
    		memcpy(lpFindFileData->cFileName, ffd.cFileName, sizeof(ffd.cFileName));
    		memcpy(lpFindFileData->cAlternateFileName, ffd.cAlternateFileName, sizeof(ffd.cAlternateFileName));
#ifdef _MAC
    		lpFindFileData->dwFileType = ffd.dwFileType;
    		lpFindFileData->dwCreatorType = ffd.dwCreatorType;
    		lpFindFileData->wFinderFlags = ffd.wFinderFlags;
#endif
		}
	}

	return hResult;
}

// 260`519oCgɂȂ悤ȃt@CꍇANSIFindNextFile
LibExport BOOL   FindNextFile520A(HANDLE hFindFile, LPWIN32_FIND_DATA520 lpFindFileData)
{
	BOOL bResult;

	if (hFindFile == INVALID_HANDLE_VALUE || lpFindFileData == NULL) { // ̓G[
		return FALSE;
	}


	ZeroMemory(lpFindFileData, sizeof(LPWIN32_FIND_DATA520));
	if (tf_isNT()) {
		WIN32_FIND_DATAW ffd;

		ZeroMemory(&ffd, sizeof(ffd));

		bResult = FindNextFileW(hFindFile, &ffd);
		if (bResult != FALSE) {
			lpFindFileData->dwFileAttributes = ffd.dwFileAttributes;
    		lpFindFileData->ftCreationTime = ffd.ftCreationTime;
    		lpFindFileData->ftLastAccessTime = ffd.ftLastAccessTime;
    		lpFindFileData->ftLastWriteTime = ffd.ftLastWriteTime;
    		lpFindFileData->nFileSizeHigh = ffd.nFileSizeHigh;
    		lpFindFileData->nFileSizeLow = ffd.nFileSizeLow;
    		lpFindFileData->dwReserved0 = ffd.dwReserved0;
    		lpFindFileData->dwReserved1 = ffd.dwReserved1;
			WideCharToMultiByte(GetACP(), 0, ffd.cFileName, -1,
				                lpFindFileData->cFileName, sizeof(lpFindFileData->cFileName), NULL, NULL);
			WideCharToMultiByte(GetACP(), 0, ffd.cAlternateFileName, -1,
				                lpFindFileData->cAlternateFileName, sizeof(lpFindFileData->cAlternateFileName), NULL, NULL);
			
#ifdef _MAC
    		lpFindFileData->dwFileType = ffd.dwFileType;
    		lpFindFileData->dwCreatorType = ffd.dwCreatorType;
    		lpFindFileData->wFinderFlags = ffd.wFinderFlags;
#endif
		}
	}
	else {
		WIN32_FIND_DATAA ffd;

		ZeroMemory(&ffd, sizeof(ffd));

		bResult = FindNextFileA(hFindFile, &ffd);
		if (bResult != FALSE) {
			lpFindFileData->dwFileAttributes = ffd.dwFileAttributes;
    		lpFindFileData->ftCreationTime = ffd.ftCreationTime;
    		lpFindFileData->ftLastAccessTime = ffd.ftLastAccessTime;
    		lpFindFileData->ftLastWriteTime = ffd.ftLastWriteTime;
    		lpFindFileData->nFileSizeHigh = ffd.nFileSizeHigh;
    		lpFindFileData->nFileSizeLow = ffd.nFileSizeLow;
    		lpFindFileData->dwReserved0 = ffd.dwReserved0;
    		lpFindFileData->dwReserved1 = ffd.dwReserved1;
    		memcpy(lpFindFileData->cFileName, ffd.cFileName, sizeof(ffd.cFileName));
    		memcpy(lpFindFileData->cAlternateFileName, ffd.cAlternateFileName, sizeof(ffd.cAlternateFileName));
#ifdef _MAC
    		lpFindFileData->dwFileType = ffd.dwFileType;
    		lpFindFileData->dwCreatorType = ffd.dwCreatorType;
    		lpFindFileData->wFinderFlags = ffd.wFinderFlags;
#endif
		}
	}

	return bResult;
}

// t@C݂邩ǂ
LibExport BOOL tFileExistA(const char *fname)
{
	if ( fname ) {
		WIN32_FIND_DATA520 ffd;
		HANDLE hf;
		UINT uOldErrMode;
			
		uOldErrMode = SetErrorMode(SEM_FAILCRITICALERRORS);
		hf = FindFirstFile520(fname, &ffd);
		SetErrorMode( uOldErrMode );

		if (hf != INVALID_HANDLE_VALUE) {
			FindClose( hf );
			return TRUE; // t@C݂
		}
		else {
			return FALSE; // t@C݂Ȃ
		}
	}
	return FALSE; // G[
}

LibExport BOOL tFileExistW(const wchar_t *fname)
{
	if ( fname ) {
		WIN32_FIND_DATAW ffd;
		HANDLE hf;
		UINT uOldErrMode;

		uOldErrMode = SetErrorMode(SEM_FAILCRITICALERRORS);
		hf = FindFirstFileW(fname, &ffd);
		SetErrorMode( uOldErrMode );

		if (hf != INVALID_HANDLE_VALUE) {
			FindClose( hf );
			return TRUE; // t@C݂
		}
		else {
			return FALSE; // t@C݂Ȃ
		}
	}
	return FALSE; // G[
}

// fobOp̃bZ[Wo
LibExport void DebugMesA(const char *mes)
{
	if ( mes ) {
		MessageBox(NULL, mes, "DebugMes()", MB_OK | MB_TOPMOST);
	}
}

LibExport void DebugMesW(const wchar_t *mes)
{
	if ( mes ) {
		MessageBoxW(NULL, mes, L"DebugMes()", MB_OK | MB_TOPMOST);
	}
}

// Windows NT I̎擾
LibExport void GetQuitRight(void)
{
	HANDLE          hToken;
	TOKEN_PRIVILEGES    tkp;
#ifndef _WIN64
	OSVERSIONINFO	verinfo;

	verinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&verinfo);
	if ( verinfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
#endif /* _WIN64 */
	{
		if (OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken)) {
			if (LookupPrivilegeValue((LPSTR)NULL, SE_SHUTDOWN_NAME, &(tkp.Privileges[0].Luid))) {
				tkp.PrivilegeCount = 1;
				tkp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
				AdjustTokenPrivileges(hToken, FALSE, &tkp, sizeof(TOKEN_PRIVILEGES), (PTOKEN_PRIVILEGES)NULL, (PDWORD)NULL);
			}
		}
	}
}

// l10i̕ɒ (Ԃ̂͊֐staticȃobt@ւ̃|C^ł邱Ƃɒ)
LibExport char *itoa10A(UINT n)
{
	static char buf[11];

	if ( 0 == _ultoa_s((unsigned long)n, buf, UBOUND(buf), 10) ) {
		return buf;
	}
	else {
		return NULL;
	}
}

LibExport wchar_t *itoa10W(UINT n)
{
	static wchar_t buf[11];

	if ( 0 == _ultow_s((unsigned long)n, buf, UBOUND(buf), 10) ) {
		return buf;
	}
	else {
		return NULL;
	}
}

// ̕to[W (Ԃ̂͊֐staticȃobt@ւ̃|C^ł邱Ƃɒ)
LibExport char *s_itoa10A(int n)
{
	static char buf[12];

	if ( 0 == _itoa_s(n, buf, UBOUND(buf), 10) ) {
		return buf;
	}
	else {
		return NULL;
	}
}

LibExport wchar_t *s_itoa10W(int n)
{
	static wchar_t buf[12];

	if ( 0 == _itow_s(n, buf, UBOUND(buf), 10) ) {
		return buf;
	}
	else {
		return NULL;
	}
}

// l16i̕ɒ (Ԃ̂͊֐staticȃobt@ւ̃|C^ł邱Ƃɒ)
LibExport char *itoa16A(int n)
{
	static char buf[16];

	if ( 0 == _ultoa_s((unsigned long)n, buf, UBOUND(buf), 16) ) {
		return buf;
	}
	else {
		return NULL;
	}
}

LibExport wchar_t *itoa16W(int n)
{
	static wchar_t buf[16];

	if ( 0 == _ultow_s((unsigned long)n, buf, UBOUND(buf), 16) ) {
		return buf;
	}
	else {
		return NULL;
	}
}

// ut@C,ԍvACRnh𓾂
LibExport HICON LoadIconFromFileA(HINSTANCE hInst, const char *fname_num)
{
	int    i = 0, num = 0;
	char  *fnameonly = NULL;
	HICON  hicon = NULL;

	if (fname_num == NULL || fname_num[0] == 0) {
		fnameonly = _strdup("");
	}
	else {
		fnameonly = zalloc(lstrlen(fname_num)+1);
		do {
			if (fname_num[i] == ',') {
				fnameonly[i] = 0;
				num = atoi(&fname_num[i+1]);
				break;
			}
			fnameonly[i] = fname_num[i];
		} while(fname_num[i++]);
	}

	hicon = ExtractIcon(hInst, fnameonly, num);
#pragma warning( disable : 4311 )
	if ((int)hicon == 0 || (int)hicon == 1) 
#pragma warning( default : 4311 )
		hicon = NULL;

	safefree(fnameonly);
	return hicon;
}

LibExport HICON LoadIconFromFileW(HINSTANCE hInst, const wchar_t *fname_num)
{
	int      i = 0, num = 0;
	wchar_t  *fnameonly = NULL;
	HICON    hicon = NULL;

	if (fname_num == NULL || fname_num[0] == 0) {
		fnameonly = _wcsdup(L"");
	}
	else {
		fnameonly = walloc(lstrlenW(fname_num)+1);
		do {
			if (fname_num[i] == L',') {
				fnameonly[i] = 0;
				num = _wtoi(&fname_num[i+1]);
				break;
			}
			fnameonly[i] = fname_num[i];
		} while(fname_num[i++]);
	}

	hicon = ExtractIconW(hInst, fnameonly, num);
#pragma warning( disable : 4311 )
	if ((int)hicon == 0 || (int)hicon == 1) 
#pragma warning( default : 4311 )
		hicon = NULL;

	safefree(fnameonly);
	return hicon;
}

// ut@C,ԍvAACRnh𓾂B傫TCYƏTCY̗B
LibExport UINT LoadIconFromFileExA(const char *fname_num, HICON *phIcon, HICON *phSmallIcon)
{
	int    i = 0, num = 0;
	char  *fnameonly = NULL;
	UINT   uRet = 0;

	if (fname_num == NULL || fname_num[0] == 0) {
		fnameonly = _strdup("");
	}
	else {
		fnameonly = zalloc(lstrlen(fname_num)+1);
		do {
			if (fname_num[i] == ',') {
				fnameonly[i] = 0;
				num = atoi(&fname_num[i+1]);
				break;
			}
			fnameonly[i] = fname_num[i];
		} while(fname_num[i++]);
	}

	uRet = ExtractIconEx(fnameonly, num, phIcon, phSmallIcon, 1);

	safefree(fnameonly);
	return uRet;
}

LibExport UINT LoadIconFromFileExW(const wchar_t *fname_num, HICON *phIcon, HICON *phSmallIcon)
{
	int      i = 0, num = 0;
	wchar_t  *fnameonly = NULL;
	UINT     uRet = 0;

	if (fname_num == NULL || fname_num[0] == 0) {
		fnameonly = _wcsdup(L"");
	}
	else {
		fnameonly = walloc(lstrlenW(fname_num)+1);
		do {
			if (fname_num[i] == L',') {
				fnameonly[i] = 0;
				num = _wtoi(&fname_num[i+1]);
				break;
			}
			fnameonly[i] = fname_num[i];
		} while(fname_num[i++]);
	}

	uRet = ExtractIconExW(fnameonly, num, phIcon, phSmallIcon, 1);

	safefree(fnameonly);
	return uRet;
}

// Xgr[̃J[\ʒu擾(̃J[\uĂꍇ͍ŏ̂)
/*LibExport int  GetLVCursor(HWND hListView)
{
	int i, n;

	if ( hListView ) {
		n = ListView_GetItemCount(hListView);

		for(i=0 ; i<n ; i++) {
			if (LVIS_SELECTED == ListView_GetItemState(hListView,i,LVIS_SELECTED)) {
				return i;
			}
		}
	}
	return -1;
}*/
// ݂ł̓wb_t@CŃ}NWJĂ

// realloc g strcat
LibExport char *realloc_strcatA( char *str1, const char *str2 )
{
	if ( str2  ) {
		if ( str1 == NULL ) {
			str1 = _strdup( str2 );
		}
		else {
			size_t str1size = (strlen(str1)+strlen(str2)+1);

			str1 = (char *)realloc( str1, sizeof(char)*str1size );
			if ( str1 ) {
				strcat_s( str1, str1size, str2 );
			}
		}
	}
	return str1;
}

LibExport wchar_t *realloc_strcatW( wchar_t *str1, const wchar_t *str2 )
{
	if ( str2  ) {
		if ( str1 == NULL ) {
			str1 = _wcsdup( str2 );
		}
		else {
			size_t str1size = (wcslen(str1)+wcslen(str2)+1);

			str1 = (wchar_t *)realloc( str1, sizeof(wchar_t)*str1size );
			if ( str1 ) {
				wcscat_s( str1, str1size, str2 );
			}
		}
	}
	return str1;
}

// strnڂ́AShift JIS̑1oCgڂ?
LibExport BOOL isKanji1A( const char *str, int n )
{
	int i = 0;

	if ( n >= 0 ) {
		for(i=0 ; str[i] ; i++) {
			if ( ISKANJI1MA(str[i]) ) {
				if ( i == n ) {
					return TRUE;
				}
				if ( str[++i] == 0 ) {
					break;
				}
			}
			if ( i == n ) {
				return FALSE;
			}
		}
	}
	return FALSE;
}

LibExport BOOL isKanji1W( const wchar_t *, int )
{
	return FALSE;
}

// Xgr[̃X^CύX
LibExport void ChangeLVStyle(HWND hWnd, HWND hwndListView, int style, BOOL Repaint)
{

	if ( hWnd && hwndListView ) {
		LONG_PTR lpStyle = GetWindowLongPtr(hwndListView, GWL_STYLE);
		LONG_PTR lpNewStyle;

		switch(style) {
			case 1 :lpNewStyle = LVS_ICON;
					break;
			case 2 :lpNewStyle = LVS_SMALLICON;
					break;
			case 3 :lpNewStyle = LVS_LIST;
					break;
			default:lpNewStyle = LVS_REPORT;
					break;
		}

		SetWindowLongPtr(hwndListView, GWL_STYLE, (lpStyle & ~LVS_TYPEMASK) | lpNewStyle);
		if (Repaint) {
			InvalidateRect(hWnd, NULL, true);
		}
	}
}

// =====================================================================
// DLL̊֐Ăяo߂̏
typedef int(WINAPI *ARCFUNC)(const HWND, LPCSTR, LPSTR, const DWORD);
typedef int(WINAPI *ARCFUNCW)(const HWND, LPCWSTR, LPWSTR, const DWORD);
typedef BOOL(WINAPI *ARCFUNC_GETRUNNING)(VOID);
typedef WORD(WINAPI *ARCFUNC_GETVERSION)(VOID);
typedef BOOL(WINAPI *ARCFUNC_SETUSELANGUE)(VOID);

// ======================= UNLHA32.DLL =================================

// Unlha32.dllĂяoāAo[W擾
LibExport DWORD call_unlha32_GetVersion(VOID)
{
	HINSTANCE lib = NULL;

	lib = LoadLibrary_System32(UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNLHA64DLL);
		if (lib == NULL)
#endif
		return 0;
	}

	// W[o[WE}Ci[o[W擾
	ARCFUNC_GETVERSION UnArcGetVersion = (ARCFUNC_GETVERSION)GetProcAddress(lib, "UnlhaGetVersion");
	if ( UnArcGetVersion == NULL ) {
		return 0;
	}
	DWORD rv = UnArcGetVersion() * 10000;

	// Tuo[W擾
	UnArcGetVersion = (ARCFUNC_GETVERSION)GetProcAddress(lib, "UnlhaGetSubVersion");
	if ( UnArcGetVersion != NULL ) {
		rv |= UnArcGetVersion();
	}

	FreeLibrary( lib );
	return rv;
}

// Unlha32.dllĂяoāAgpݒ肷
// englishflag = TRUE:pꃂ[h / FALSE:{ꃂ[h
LibExport BOOL call_unlha32_UseEnglishMode(BOOL englishflag)
{
	HINSTANCE lib = NULL;

	lib = LoadLibrary_System32(UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNLHA64DLL);
		if (lib == NULL)
#endif
		return 0;
	}

	// ꃂ[hݒp֐ւ̃AhX擾
	ARCFUNC_SETUSELANGUE UnArcSetUseLangue = (ARCFUNC_SETUSELANGUE)GetProcAddress(lib, englishflag ? "SetLangueEnglish" : "SetLangueJapanese");
	if ( UnArcSetUseLangue == NULL ) {
		return FALSE;
	}
	BOOL rv = UnArcSetUseLangue();

	// CůJ
	FreeLibrary( lib );
	return rv;
}

// Unlha32.dllĂяoāAJgfBNglzhname𓀂(x -a1 -jf0)
LibExport int call_unlha32A(HWND hWnd, LPCSTR lzhname)
{
	return call_unlha32_logA(hWnd, lzhname, NULL, 0);
}
LibExport int call_unlha32W(HWND hWnd, LPCWSTR lzhname)
{
	return call_unlha32_logW(hWnd, lzhname, NULL, 0);
}

LibExport int call_unlha32_logA(HWND hWnd, LPCSTR lzhname, LPSTR szOutput, DWORD dwOutputSize)
{
	return call_unlha32d_logA(hWnd, lzhname, NULL, szOutput, dwOutputSize);
}
LibExport int call_unlha32_logW(HWND hWnd, LPCWSTR lzhname, LPWSTR szOutput, DWORD dwOutputSize)
{
	return call_unlha32d_logW(hWnd, lzhname, NULL, szOutput, dwOutputSize);
}

// Unlha32.dllĂяoāAwfBNglzhname𓀂(x -a1 -jf0)
LibExport int call_unlha32dA(HWND hWnd, LPCSTR lzhname, LPCSTR dir)
{
	return call_unlha32d_logA(hWnd, lzhname, dir, NULL, 0);
}
LibExport int call_unlha32dW(HWND hWnd, LPCWSTR lzhname, LPCWSTR dir)
{
	return call_unlha32d_logW(hWnd, lzhname, dir, NULL, 0);
}

LibExport int call_unlha32d_logA(HWND hWnd, LPCSTR lzhname, LPCSTR dir, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string lhacommand;			// Unlha() ɓnR}h@Fx -a1 -jf0 -gb"lzhname" "dir\"
	string dirname;				// 𓀐fBNg@@@@@F"dir\"
	string lzhfilename;			// lzht@C@@@@@@@ F"lzhname"
	int    i  = 0;
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNLHA64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC Unlha = (ARCFUNC)GetProcAddress(lib, "Unlha");

	if (Unlha == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( lzhname == NULL || lzhname[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// lzhfilename̐ - lzhnameɑ΂āAKv "" ň͂
			lzhfilename = lzhname;
			insert_dcA( lzhfilename );

			// dirname̐ - dirɑ΂āAKv "" ň͂AŌ \ Ȃ΁A\t
			// ӁF_uR[e[V̒ɁAŌ \ ̂ł̓_ŁA_uR[e[V̌
			//       Ȃ΂ȂȂlq
			if ( dir && dir[0] ) {
				dirname = dir;
				insert_dc( dirname );
				i = (int)dirname.length(); // dirname̒擾
				const char *c_dirname = dirname.c_str();

				if ( !isKanji1A(c_dirname,i-2) && c_dirname[i-1] == '\\' ) // \ŏIĂ΁Ał悢B
					;
				else { // I \ t
					dirname.append("\\");
				}
			}

			// R}hC̐
			lhacommand = "x -a1 -jf0 -gb";
			lhacommand += lzhfilename;
			if ( !dirname.empty() ) { // 𓀐fBNgw肪ꍇ
				lhacommand += " ";
				lhacommand += dirname;
			}

			if (0 != Unlha(hWnd, lhacommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}
	FreeLibrary( lib );
	return rv;
}
LibExport int call_unlha32d_logW(HWND hWnd, LPCWSTR lzhname, LPCWSTR dir, LPWSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	wstring lhacommand;			// UnlhaW() ɓnR}h@Fx -a1 -jf0 -gb"lzhname" "dir\"
	wstring dirname;				// 𓀐fBNg@@@@@F"dir\"
	wstring lzhfilename;			// lzht@C@@@@@@@ F"lzhname"
	int    i  = 0;
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32W(L_UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32W(L_UNLHA64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNCW UnlhaW = (ARCFUNCW)GetProcAddress(lib, "UnlhaW");

	if (UnlhaW == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( lzhname == NULL || lzhname[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// lzhfilename̐ - lzhnameɑ΂āAKv "" ň͂
			lzhfilename = lzhname;
			insert_dcW( lzhfilename );

			// dirname̐ - dirɑ΂āAKv "" ň͂AŌ \ Ȃ΁A\t
			// ӁF_uR[e[V̒ɁAŌ \ ̂ł̓_ŁA_uR[e[V̌
			//       Ȃ΂ȂȂlq
			if ( dir && dir[0] ) {
				dirname = dir;
				insert_dcW( dirname );
				i = (int)dirname.length(); // dirname̒擾
				const wchar_t *c_dirname = dirname.c_str();

				if ( c_dirname[i-1] == L'\\' ) // \ŏIĂ΁Ał悢B
					;
				else { // I \ t
					dirname.append(L"\\");
				}
			}

			// R}hC̐
			lhacommand = L"x -a1 -jf0 -gb";
			lhacommand += lzhfilename;
			if ( !dirname.empty() ) { // 𓀐fBNgw肪ꍇ
				lhacommand += L" ";
				lhacommand += dirname;
			}

			if (0 != UnlhaW(hWnd, lhacommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}
	FreeLibrary( lib );
	return rv;
}

// Unlha32.dllĂяoāAw肳ꂽt@CQlzhnameɈk(a -rxad)
LibExport int call_unlha32rA(HWND hWnd, LPCSTR lzhname, LPCSTR response_file, LPCSTR option)
{
	return call_unlha32r_logA(hWnd, lzhname, response_file, option, NULL, 0);
}
LibExport int call_unlha32rW(HWND hWnd, LPCWSTR lzhname, LPCWSTR response_file, LPCWSTR option)
{
	return call_unlha32r_logW(hWnd, lzhname, response_file, option, NULL, 0);
}

LibExport int call_unlha32r_logA(HWND hWnd, LPCSTR lzhname, LPCSTR response_file, LPCSTR option, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string lhacommand;	// Unlha() ɓnR}hBFa -rxad [option] -gb"lzhname" "@response_file"
	string respname;	// X|Xt@CB@@@@F"@response_file"
	string lzhfilename;	// lzht@CB@@@@@@ F"lzhname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNLHA64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC Unlha = (ARCFUNC)GetProcAddress(lib, "Unlha");

	if (Unlha == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( lzhname == NULL || lzhname[0] == 0 || response_file == NULL || response_file[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// lzhfilename̐ - lzhnameɑ΂āAKv "" ň͂
			lzhfilename = lzhname;
			insert_dc( lzhfilename );

			// respname̐ - response_fileɑ΂āAKv "" ň͂
			// (@̒ǉ́AR}hCɍs)
			respname = response_file;
			insert_dcA( respname );

			// R}h̐
			lhacommand = "a -rxad ";
			if ( option && option[0] ) {
				lhacommand += option;
				lhacommand += " ";
			}

			lhacommand += "-gb";
			lhacommand += lzhfilename;
			lhacommand += " @";
			lhacommand += respname;

			if (0 != Unlha(hWnd, lhacommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}

	FreeLibrary( lib );
	return rv;
}

LibExport int call_unlha32r_logW(HWND hWnd, LPCWSTR lzhname, LPCWSTR response_file, LPCWSTR option, LPWSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	wstring lhacommand;	// UnlhaW() ɓnR}hBFa -rxad [option] -gb"lzhname" "@response_file"
	wstring respname;	// X|Xt@CB@@@@F"@response_file"
	wstring lzhfilename;	// lzht@CB@@@@@@ F"lzhname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32W(L_UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32W(L_UNLHA64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNCW UnlhaW = (ARCFUNCW)GetProcAddress(lib, "UnlhaW");

	if (UnlhaW == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( lzhname == NULL || lzhname[0] == 0 || response_file == NULL || response_file[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// lzhfilename̐ - lzhnameɑ΂āAKv "" ň͂
			lzhfilename = lzhname;
			insert_dcW( lzhfilename );

			// respname̐ - response_fileɑ΂āAKv "" ň͂
			// (@̒ǉ́AR}hCɍs)
			respname = response_file;
			insert_dcW( respname );

			// R}h̐
			lhacommand = L"a -rxad ";
			if ( option && option[0] ) {
				lhacommand += option;
				lhacommand += L" ";
			}

			lhacommand += L"-gb";
			lhacommand += lzhfilename;
			lhacommand += L" @";
			lhacommand += respname;

			if (0 != UnlhaW(hWnd, lhacommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}

	FreeLibrary( lib );
	return rv;
}

// Unlha32.dllĂяoāAlzhexe(WinSFX32)ɕϊ(s -gw1)
LibExport int call_unlha32_toexeA(HWND hWnd, LPCSTR lzhname)
{
	return call_unlha32_toexe_logA(hWnd, lzhname, NULL, 0);
}
LibExport int call_unlha32_toexeW(HWND hWnd, LPCWSTR lzhname)
{
	return call_unlha32_toexe_logW(hWnd, lzhname, NULL, 0);
}

LibExport int call_unlha32_toexe_logA(HWND hWnd, LPCSTR lzhname, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string lhacommand;			// Unlha() ɓnR}hBF s -gw1 -gb"lzhname"
	string lzhfilename;			// lzht@CBF "lzhname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNLHA64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC Unlha = (ARCFUNC)GetProcAddress(lib, "Unlha");

	if (Unlha == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( lzhname == NULL || lzhname[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// lzhfilename̐ - lzhnameɑ΂āAKv "" ň͂
			lzhfilename = lzhname;
			insert_dcA( lzhfilename );

			// R}h̐
			lhacommand = "s -gw1 -gb";
			lhacommand += lzhfilename;

			if (0 != Unlha(hWnd, lhacommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}

	FreeLibrary( lib );
	return rv;
}

LibExport int call_unlha32_toexe_logW(HWND hWnd, LPCWSTR lzhname, LPWSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	wstring lhacommand;			// Unlha() ɓnR}hBF s -gw1 -gb"lzhname"
	wstring lzhfilename;		// lzht@CBF "lzhname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32W(L_UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32W(L_UNLHA64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNCW UnlhaW = (ARCFUNCW)GetProcAddress(lib, "Unlha");

	if (UnlhaW == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( lzhname == NULL || lzhname[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// lzhfilename̐ - lzhnameɑ΂āAKv "" ň͂
			lzhfilename = lzhname;
			insert_dcW( lzhfilename );

			// R}h̐
			lhacommand = L"s -gw1 -gb";
			lhacommand += lzhfilename;

			if (0 != UnlhaW(hWnd, lhacommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}

	FreeLibrary( lib );
	return rv;
}

// Unlha32.dllĂяoāAUnlha()gpǂm߂
LibExport BOOL call_unlha32_getrunning( void )
{
	HINSTANCE lib = NULL;
	BOOL	rv = FALSE;

	lib = LoadLibrary_System32(UNLHA32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNLHA64DLL);
		if (lib == NULL)
#endif
		return FALSE;
	}

	ARCFUNC_GETRUNNING UnlhaGetRunning = (ARCFUNC_GETRUNNING)GetProcAddress(lib,"UnlhaGetRunning");

	if ( UnlhaGetRunning ) {
		rv = UnlhaGetRunning();
	}

	FreeLibrary( lib );
	return rv;
}

// ================== UNZIP32.DLL/ZIP32J.DLL =========================
// Unzip32.dllĂяoāAJgfBNgzipname𓀂
LibExport int call_unzip32(HWND hWnd, LPCSTR zipname)
{
	return call_unzip32_log(hWnd, zipname, NULL, 0);
}
LibExport int call_unzip32_log(HWND hWnd, LPCSTR zipname, LPSTR szOutput, DWORD dwOutputSize)
{
	return call_unzip32d_log(hWnd, zipname, NULL, szOutput, dwOutputSize);
}

// Unzip32.dllĂяoāAwfBNgzipname𓀂
LibExport int call_unzip32d(HWND hWnd, LPCSTR zipname, LPCSTR dir)
{
	return call_unzip32d_log(hWnd, zipname, dir, NULL, 0);
}
LibExport int call_unzip32d_log(HWND hWnd, LPCSTR zipname, LPCSTR dir, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string zipcommand;	// UnZip() ɓnR}hBF"zipname" "dir\"
	string dirname;		// 𓀐fBNgB@@@@F"dir\"
	string zipfilename;	// lzht@CB@@@@@@ F"zipname"
	int    i = 0;
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(UNZIP32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNZIP64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC UnZip = (ARCFUNC)GetProcAddress(lib, "UnZip");

	if (UnZip == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( zipname == NULL || zipname[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// zipfilename̐ - zipnameɑ΂āAKv "" ň͂
			zipfilename = zipname;
			insert_dc( zipfilename );

			// dirname̐ - dirɑ΂āAKv "" ň͂AŌ \ Ȃ΁A\t
			if ( dir && dir[0] ) {
				dirname = dir;
				delete_dc( dirname );
				i = (int)dirname.length(); // dirname̒擾
				if ( !isKanji1A(dirname.c_str(),i-2) && dirname[i-1] == '\\' ) // \ŏIĂ΁Ał悢B
					;
				else { // I \ t
					dirname.append("\\");
				}
				insert_dc( dirname );
			}

			// R}hC̐
			zipcommand = zipfilename;
			if ( !dirname.empty() ) { // 𓀐fBNgw肪ꍇ
				zipcommand += " ";
				zipcommand += dirname;
			}

			if (0 != UnZip(hWnd, zipcommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}
	FreeLibrary( lib );
	return rv;
}

// Unzip32.dllĂяoāAUnzip()gpǂm߂
LibExport BOOL call_unzip32_getrunning( void )
{
	HINSTANCE lib = NULL;
	BOOL	rv = 0;

	lib = LoadLibrary_System32(UNZIP32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(UNZIP64DLL);
		if (lib == NULL)
#endif
		return FALSE;
	}

	ARCFUNC_GETRUNNING UnzipGetRunning = (ARCFUNC_GETRUNNING)GetProcAddress(lib,"UnzipGetRunning");

	if ( UnzipGetRunning ) {
		rv = UnzipGetRunning();
	}
	else {
		rv = FALSE;
	}

	FreeLibrary( lib );
	return rv;
}

// zip32j.dllĂяoāAw肳ꂽt@CQzipnameɈk
LibExport int call_zip32j(HWND hWnd, LPCSTR zipname, LPCSTR response_file, LPCSTR option)
{
	return call_zip32j_log(hWnd, zipname, response_file, option, NULL, 0);
}
LibExport int call_zip32j_log(HWND hWnd, LPCSTR zipname, LPCSTR response_file, LPCSTR option, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string zipcommand;		// Zip() ɓnR}hBF -r [option] "zipname" "@response_file"
	string respname;		// X|Xt@CB@@@F"@response_file"
	string zipfilename;		// zipt@CB@@@@@ F"zipname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(ZIP32JDLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(ZIP64JDLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC Zip = (ARCFUNC)GetProcAddress(lib, "Zip");

	if (Zip == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( zipname == NULL || zipname[0] == 0 || response_file == NULL || response_file[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// zipfilename̐ - zipnameɑ΂āAKv "" ň͂
			zipfilename = zipname;
			insert_dc( zipfilename );

			// respname̐ - response_fileɑ΂āAKv "" ň͂Aŏ@ǉ
			respname = response_file;
			insert_dc( respname );

			if ( respname[0] == '\"' ) { // "Ŏn܂Ăꍇ - "̎@}(R͂悭킩ȂAzip32j.dll̃[̂悤)
				if ( respname[1] != '@' ) {
					respname.insert(1, "@");
				}
			}
			else { // "Ŏn܂ĂȂꍇ - 擪@}
				if ( respname[0] != '@' ) {
					respname.insert(0, "@");
				}
			}

			// R}h̐
			zipcommand = "-r ";
			if ( option && option[0] ) {
				zipcommand += option;
				zipcommand += " ";
			}

			zipcommand += zipfilename;
			zipcommand += " ";
			zipcommand += respname;

			if (0 != Zip(hWnd, zipcommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}
	FreeLibrary( lib );
	return rv;
}

// zip32j.dllĂяoāAzipexe(SFX)ɕϊ(--sfx)
LibExport int call_zip32_toexe(HWND hWnd, LPCSTR zipname)
{
	return call_zip32_toexe_log(hWnd, zipname, NULL, 0);
}
LibExport int call_zip32_toexe_log(HWND hWnd, LPCSTR zipname, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string zipcommand;		// Zip() ɓnR}hBF --sfx "zipname"
	string zipfilename;		// zipt@CB@@@@@ F "zipname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(ZIP32JDLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(ZIP64JDLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC Zip = (ARCFUNC)GetProcAddress(lib, "Zip");

	if (Zip == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( zipname == NULL || zipname[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// zipfilename̐ - zipnameɑ΂āAKv "" ň͂
			zipfilename = zipname;
			insert_dc( zipfilename );

			// R}h̐
			zipcommand = "--sfx ";
			zipcommand += zipfilename;

			if (0 != Zip(hWnd, zipcommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}

	FreeLibrary( lib );
	return rv;
}

// Zip32j.dllĂяoāAUnzip()gpǂm߂
LibExport BOOL call_zip32j_getrunning( void )
{
	HINSTANCE lib = NULL;
	BOOL	  rv  = FALSE;

	lib = LoadLibrary_System32(ZIP32JDLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(ZIP64JDLL);
		if (lib == NULL)
#endif
		return FALSE;
	}

	ARCFUNC_GETRUNNING ZipGetRunning = (ARCFUNC_GETRUNNING)GetProcAddress(lib,"ZipGetRunning");

	if ( ZipGetRunning ) {
		rv = ZipGetRunning();
	}

	FreeLibrary( lib );
	return rv;
}

// ======================= 7-ZIP32.DLL ==============================
// 7-Zip32.dllĂяoāAJgfBNgszname𓀂(x)
LibExport int call_7zip32(HWND hWnd, LPCSTR szname)
{
	return call_7zip32_log(hWnd, szname, NULL, 0);
}
LibExport int call_7zip32_log(HWND hWnd, LPCSTR szname, LPSTR szOutput, DWORD dwOutputSize)
{
	return call_7zip32d_log(hWnd, szname, NULL, szOutput, dwOutputSize);
}

// 7-zip32.dllĂяoāAwfBNgszname𓀂(x -o<dir>)
LibExport int call_7zip32d(HWND hWnd, LPCSTR szname, LPCSTR dir)
{
	return call_7zip32d_log(hWnd, szname, dir, NULL, 0);
}
LibExport int call_7zip32d_log(HWND hWnd, LPCSTR szname, LPCSTR dir, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string szcommand;			// SevenZip() ɓnR}h@Fx -o"dir" -r -- "szname"
	string dirname;				// 𓀐fBNg@@@@@F"dir"
	string szfilename;			// 7zt@C @@@@@@@ F"szname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(SEVENZIP32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(SEVENZIP64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC SevenZip = (ARCFUNC)GetProcAddress(lib, "SevenZip");

	if (SevenZip == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( szname == NULL || szname[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// szfilename̐ - sznameɑ΂āAKv "" ň͂
			szfilename = szname;
			insert_dc( szfilename );

			// dirname̐ - dirɑ΂āAKv "" ň͂
			if ( dir && dir[0] ) {
				dirname = dir;
				insert_dc( dirname );
			}

			// R}hC̐
			szcommand = "x ";
			if ( !dirname.empty() ) { // 𓀐fBNgw肪ꍇ
				szcommand += "-o";	// Xy[X󂯂ɑăfBNg
				szcommand += dirname;
				szcommand += " ";
			}
			szcommand += "-r -- ";
			szcommand += szfilename;

			if (0 != SevenZip(hWnd, szcommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}
	FreeLibrary( lib );
	return rv;
}

// 7-Zip32.dllĂяoāAw肳ꂽt@CQsznameɈk(a -t??? ***)
# define SZTYPE_7Z		0	// 7z
# define SZTYPE_ZIP		1	// zip
# define SZTYPE_EXE		2	// exe(7z sfx)
LibExport int call_7zip32r(HWND hWnd, LPCSTR szname, LPCSTR list_file, LPCSTR option)
{
	return call_7zip32r_log(hWnd, szname, list_file, option, NULL, 0);
}
LibExport int call_7zip32r_log(HWND hWnd, LPCSTR szname, LPCSTR list_file, LPCSTR option, LPSTR szOutput, DWORD dwOutputSize)
{
	HINSTANCE lib = NULL;
	string szcommand;	// SevenZip() ɓnR}hBFa -t7z [option] (-ms=off) (-sfx) -r -- "szname" @"list_file"
	string listfile;	// kΏۃXgt@CB@@F@"list_file"
	string szfilename;	// 7zt@CB@@@ @@@ F"szname"
	int    rv = T_TF_SUCCESS;

	lib = LoadLibrary_System32(SEVENZIP32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(SEVENZIP64DLL);
		if (lib == NULL)
#endif
		return T_TF_DLLNOTFOUND;
	}

	ARCFUNC SevenZip = (ARCFUNC)GetProcAddress(lib, "SevenZip");

	if (SevenZip == NULL) {
		rv = T_TF_ILLEGALDLL;
	}
	else {
		if ( szname == NULL || szname[0] == 0 || list_file == NULL || list_file[0] == 0 ) {
			rv = T_TF_ILLEGALCALL;
		}
		else {
			// szfilename̐ - sznameɑ΂āAKv "" ň͂
			szfilename = szname;
			insert_dc( szfilename );

			// listfile̐ - list_fileɑ΂āAKv "" ň͂
			// (@̒ǉ́AR}hCɍs)
			listfile = list_file;
			insert_dc( listfile );

			// R}h̐
			szcommand = "a ";

			// kt@C̊gqāAIvV肷
			int i7zType = SZTYPE_7Z; // 0:7z, 1:zip, 2:exe(7z sfx)
			char szExt[_MAX_EXT*2];

			_splitpath_s(szname, NULL, 0, NULL, 0, NULL, 0, szExt, UBOUND(szExt));
			if (_strcmpi(szExt, ".zip") == 0 || _strcmpi(szExt, ".jar") == 0 || _strcmpi(szExt, ".xpi") == 0) {
				i7zType = SZTYPE_ZIP;
				szcommand += "-tzip ";
			}
			else if (_strcmpi(szExt, ".exe") == 0) {
				i7zType = SZTYPE_EXE;
				szcommand += "-t7z ";
			}
			else {
				szcommand += "-t7z ";
			}
			
			if ( option && option[0] ) {
				szcommand += option;
				szcommand += " ";

				if ( i7zType == SZTYPE_ZIP ) {
					// -mmt=on/off Ǝs炵̂Ŏ菜
					string::size_type ds;

					ds = szcommand.find("-mmt=on");
					if ( ds != string::npos ) {
						szcommand.erase(ds, 7);
					}
					else {
						ds = szcommand.find("-mmt=off");
						szcommand.erase(ds, 8);
					}
				}
			}

			if ( i7zType == SZTYPE_7Z || i7zType == SZTYPE_EXE ) {
				szcommand += "-ms=off ";
			}
			if ( i7zType == SZTYPE_EXE ) {
				szcommand += "-sfx ";
			}
			szcommand += "-r0 -- ";

			szcommand += szfilename;
			szcommand += " @";
			szcommand += listfile;

			if (0 != SevenZip(hWnd, szcommand.c_str(), szOutput, dwOutputSize)) {
				rv = T_TF_ERROR;
			}
		}
	}

	FreeLibrary( lib );
	return rv;
}

// 7-Zip32.dllĂяoāASevenZip()gpǂm߂
LibExport BOOL call_7zip32_getrunning( void )
{
	HINSTANCE lib = NULL;
	BOOL	  rv  = FALSE;

	lib = LoadLibrary_System32(SEVENZIP32DLL);
	if (lib == NULL) {
#ifdef _WIN64
		lib = LoadLibrary_System32(SEVENZIP64DLL);
		if (lib == NULL)
#endif
		return FALSE;
	}

	ARCFUNC_GETRUNNING SevenZipGetRunning = (ARCFUNC_GETRUNNING)GetProcAddress(lib,"SevenZipGetRunning");

	if ( SevenZipGetRunning ) {
		rv = SevenZipGetRunning();
	}

	FreeLibrary( lib );
	return rv;
}

// ==================================================================
//---------------------------------------------------------------------------
// TFI_TaskBarAddIcon() ^XNo[̃VXegCɃACRǉ
// ߂lFTRUE FALSEs
// hwnd - R[obÑEBhEnh
// uID - ǉACRID
// hicon - ǉACR̃nh
// lpszTip - ACRɃ}EXuƂɕ\eLXg
// messageID - MYWM_NOTIFYICON (hwndɃR[obN郁bZ[WƂĎgl)
//
// (̃\[XR[h́AMSDÑCû̂QlɍĂ܂)
//---------------------------------------------------------------------------
LibExport BOOL TFI_TaskBarAddIconA(HWND hwnd, UINT uID, HICON hicon, LPCSTR lpszTip, int messageID)
{
    NOTIFYICONDATAA tnid;

	ZeroMemory(&tnid, sizeof(tnid));
    tnid.cbSize = sizeof(tnid);
    tnid.hWnd = hwnd;
    tnid.uID = uID;

    tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    tnid.uCallbackMessage = messageID;
    tnid.hIcon = hicon;
	if (lpszTip) {
        lstrcpynA(tnid.szTip, lpszTip, _countof(tnid.szTip));
	}

    return Shell_NotifyIconA(NIM_ADD, &tnid);
}

LibExport BOOL TFI_TaskBarAddIconW(HWND hwnd, UINT uID, HICON hicon, LPCWSTR lpszTip, int messageID)
{
    NOTIFYICONDATAW tnid;

	ZeroMemory(&tnid, sizeof(tnid));
    tnid.cbSize = sizeof(tnid);
    tnid.hWnd = hwnd;
    tnid.uID = uID;

    tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    tnid.uCallbackMessage = messageID;
    tnid.hIcon = hicon;
	if (lpszTip) {
        lstrcpynW(tnid.szTip, lpszTip, _countof(tnid.szTip));
	}

    return Shell_NotifyIconW(NIM_ADD, &tnid);
}

//---------------------------------------------------------------------------
// TFI_TaskBarModifyIcon() ^XNo[̃VXegCɃACRύX
// ߂lFTRUE FALSEs
// hwnd - R[obÑEBhEnhiύXΏۂƂ́j
// uID - ǉACRIDiύXΏۂƂ́j
// hicon - ǉACR̃nh
// lpszTip - ACRɃ}EXuƂɕ\eLXg
// messageID - MYWM_NOTIFYICON (hwndɃR[obN郁bZ[WƂĎgl)
//---------------------------------------------------------------------------
LibExport BOOL TFI_TaskBarModifyIconA(HWND hwnd, UINT uID, HICON hicon, LPCSTR lpszTip, int messageID)
{
    NOTIFYICONDATA tnid;

	ZeroMemory(&tnid, sizeof(tnid));
    tnid.cbSize = sizeof(tnid);
    tnid.hWnd = hwnd;
    tnid.uID = uID;

    tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    tnid.uCallbackMessage = messageID;
    tnid.hIcon = hicon;
	if (lpszTip) {
        lstrcpynA(tnid.szTip, lpszTip, _countof(tnid.szTip));
	}

	return Shell_NotifyIconA(NIM_MODIFY, &tnid);
}

LibExport BOOL TFI_TaskBarModifyIconW(HWND hwnd, UINT uID, HICON hicon, LPCWSTR lpszTip, int messageID)
{
    NOTIFYICONDATAW tnid;

	ZeroMemory(&tnid, sizeof(tnid));
    tnid.cbSize = sizeof(tnid);
    tnid.hWnd = hwnd;
    tnid.uID = uID;

    tnid.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
    tnid.uCallbackMessage = messageID;
    tnid.hIcon = hicon;
	if (lpszTip) {
        lstrcpynW(tnid.szTip, lpszTip, _countof(tnid.szTip));
	}

	return Shell_NotifyIconW(NIM_MODIFY, &tnid);
}

//---------------------------------------------------------------------------
// TFI_TaskBarDeleteIcon() ^XNo[̃VXegCACR폜
// ߂lFTRUE FALSEs
// hwnd - ACRǉEBhEnh
// uID - ǉƂɎw肵ID
//
// (̃\[XR[h́AMSDÑCû̂QlɍĂ܂)
//---------------------------------------------------------------------------
LibExport BOOL TFI_TaskBarDeleteIconA(HWND hwnd, UINT uID)
{
    NOTIFYICONDATAA tnid;

	ZeroMemory(&tnid, sizeof(tnid));
    tnid.cbSize = sizeof(tnid);
    tnid.hWnd = hwnd;
    tnid.uID = uID;

    return Shell_NotifyIconA(NIM_DELETE, &tnid);
}

LibExport BOOL TFI_TaskBarDeleteIconW(HWND hwnd, UINT uID)
{
    NOTIFYICONDATAW tnid;

	ZeroMemory(&tnid, sizeof(tnid));
    tnid.cbSize = sizeof(tnid);
    tnid.hWnd = hwnd;
    tnid.uID = uID;

    return Shell_NotifyIconW(NIM_DELETE, &tnid);
}

// SHEmptyRecycleBin ̃R[ (ݔɂ) testflag = 1 APIpł邩ǂmF
LibExport BOOL EmptyRecycleBinA(BOOL testflag)
{
	if (testflag) {
		return 1;
	}

	if (S_OK == SHEmptyRecycleBin(NULL, NULL, SHERB_NOCONFIRMATION | SHERB_NOSOUND)) {
		return 1;
	}
	else {
		return 0;
	}
}

typedef DWORD (WINAPI *PFUNC_SHEmptyRecycleBinW)(HWND,LPCWSTR,DWORD);

LibExport BOOL EmptyRecycleBinW(BOOL testflag)
{
	HMODULE hDLL;
	PFUNC_SHEmptyRecycleBinW pFunc;  

	hDLL = LoadLibrary_System32W(L"SHELL32.DLL");
	if (hDLL == NULL)
		return 0;
	pFunc=(PFUNC_SHEmptyRecycleBinW)GetProcAddress(hDLL, "SHEmptyRecycleBinW");
	if (pFunc == NULL) {
		FreeLibrary( hDLL );
		return 0;
	}

	if (testflag) {
		FreeLibrary( hDLL );
		return 1;
	}

	if (S_OK == pFunc(NULL, NULL, SHERB_NOCONFIRMATION | SHERB_NOSOUND)) {
		FreeLibrary( hDLL );
		return 1;
	}
	else {
		FreeLibrary( hDLL );
		return 0;
	}
}

// JgfBNĝƂɃZbg
LibExport BOOL SetCurrentDirectoryOwnDirA( void )
{
	char exename[MAX_PATH*2];

	if ( GetModuleFileNameA(NULL, exename, _countof(exename)) ) {
		int i = lstrlenA(exename);

		do {
			i--;
		} while(i>0 && (exename[i] != '\\' || isKanji1A(exename,i-1)));
		if (i > 0) {
			if (i > 4) {
				exename[i] = 0;
			}
			else {
				exename[i+1] = 0;
			}
			return SetCurrentDirectoryA(exename);
		}
		else {
			return FALSE;
		}
	}
	return FALSE;
}

LibExport BOOL SetCurrentDirectoryOwnDirW( void )
{
	wchar_t exename[MAX_PATH];

	if ( GetModuleFileNameW(NULL, exename, _countof(exename)) ) {
		int i = lstrlenW(exename);

		do {
			i--;
		} while(i>0 && (exename[i] != L'\\'));
		if (i > 0) {
			if (i > 4) {
				exename[i] = 0;
			}
			else {
				exename[i+1] = 0;
			}
			return SetCurrentDirectoryW(exename);
		}
		else {
			return FALSE;
		}
	}
	return FALSE;
}

// V[gJbg̍쐬
LibExport BOOL MakeLinkA(LPCSTR exe, LPCSTR args, LPCSTR lnk)
{
	return MakeLinkIcon(exe, args, lnk, NULL, 0);
}
LibExport BOOL MakeLinkW(LPCWSTR exe, LPCWSTR args, LPCWSTR lnk)
{
	return MakeLinkIconW(exe, args, lnk, NULL, 0);
}

// V[gJbg̍쐬iACRwj
// ̃\[XR[h́Aǂ̃TCg(Y܂)̃TvꕔėpĂ܂
LibExport BOOL MakeLinkIconA(LPCSTR exe, LPCSTR args, LPCSTR lnk, LPCSTR icon, int no)
{
	IShellLink	*m_pShellLink = NULL;
	IPersistFile	*m_pPersistFile = NULL;
	OLECHAR	ochLinkFile[MAX_PATH*2];
	HRESULT hRes = 0;

/*	// OLEgpȌ -- ̊֐ĂяovO̖`ŁA͂܂ĂƁI
	hRes = CoInitialize( NULL );

	if( hRes == E_OUTOFMEMORY || hRes == E_INVALIDARG || hRes == E_UNEXPECTED )
		return FALSE;
*/
	// 
	hRes = CoCreateInstance( CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (LPVOID *)&m_pShellLink );

	if( false == SUCCEEDED(hRes) ) {
		return FALSE;
	}

	// IPersistFile𐶐
	hRes = m_pShellLink->QueryInterface( IID_IPersistFile, (LPVOID *)&m_pPersistFile );

	if( false == SUCCEEDED(hRes) ) {
		return FALSE;
	}

	// N̍쐬
	m_pShellLink->SetPath( exe );		//Nexet@CB
	m_pShellLink->SetShowCmd( SW_SHOW );	//W̕\B
	m_pShellLink->SetWorkingDirectory( "" );	//JgtH_ȂB
	m_pShellLink->SetIconLocation( icon, no );	//ACR̎w(icon=NULL, no=0 ŕʂ̃ACR)
	m_pShellLink->SetHotkey( 0 );			//zbgL[iVB
	m_pShellLink->SetDescription( "" );	//^CgiVB
	m_pShellLink->SetArguments( args );	//wB

	// jR[hϊ
	MultiByteToWideChar( GetACP(), MB_PRECOMPOSED, lnk, -1, ochLinkFile, _countof(ochLinkFile) );

	// V[gJbgt@C̏
	hRes = m_pPersistFile->Save( ochLinkFile, TRUE );

	// IPersistFile
	m_pPersistFile->Release();

	// IShellLink
	m_pShellLink->Release();

/*	CoUninitialize(); */ // - ̊֐ĂяovO̍ŌŁA͍sĂ

	return ((hRes == S_OK) ? TRUE : FALSE);
}

LibExport BOOL MakeLinkIconW(LPCWSTR exe, LPCWSTR args, LPCWSTR lnk, LPCWSTR icon, int no)
{
	IShellLinkW	*m_pShellLink = NULL;
	IPersistFile	*m_pPersistFile = NULL;
	HRESULT hRes = 0;

/*	// OLEgpȌ -- ̊֐ĂяovO̖`ŁA͂܂ĂƁI
	hRes = CoInitialize( NULL );

	if( hRes == E_OUTOFMEMORY || hRes == E_INVALIDARG || hRes == E_UNEXPECTED )
		return FALSE;
*/

	// 
	hRes = CoCreateInstance( CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLinkW, (LPVOID *)&m_pShellLink );

	if( false == SUCCEEDED(hRes) ) {
		return FALSE;
	}

	// IPersistFile𐶐
	hRes = m_pShellLink->QueryInterface( IID_IPersistFile, (LPVOID *)&m_pPersistFile );

	if( false == SUCCEEDED(hRes) ) {
		return FALSE;
	}

	// N̍쐬
	m_pShellLink->SetPath( exe );		//Nexet@CB
	m_pShellLink->SetShowCmd( SW_SHOW );	//W̕\B
	m_pShellLink->SetWorkingDirectory( L"" );	//JgtH_ȂB
	m_pShellLink->SetIconLocation( icon, no );	//ACR̎w(icon=NULL, no=0 ŕʂ̃ACR)
	m_pShellLink->SetHotkey( 0 );			//zbgL[iVB
	m_pShellLink->SetDescription( L"" );	//^CgiVB
	m_pShellLink->SetArguments( args );	//wB

	// V[gJbgt@C̏
	hRes = m_pPersistFile->Save( lnk, TRUE );

	// IPersistFile
	m_pPersistFile->Release();

	// IShellLink
	m_pShellLink->Release();

/*	CoUninitialize(); */ // - ̊֐ĂяovO̍ŌŁA͍sĂ

	return ((hRes == S_OK) ? TRUE : FALSE);
}

// V[gJbg̓ǂݏo
// ̃\[XR[h́AlbgɌJĂTvꕔėpĂ܂
LibExport BOOL QueryLinkA(const char *pszLinkFile, char *pszTarget, char *pszOption,
						        char *pszIcon, int *piIconIndex) {

    IShellLink      *ShellLink = NULL;
    IPersistFile    *PersistFile = NULL;
    HRESULT         hResult = 0;
    WCHAR           wszShortcutFile[MAX_PATH*2];
    WIN32_FIND_DATA wfd;
	BOOL            bResult = TRUE;

	if ( pszLinkFile == NULL ) {
		return FALSE;
	}

/*	// OLEgpȌ -- ̊֐ĂяovO̖`ŁA͂܂ĂƁI
	hRes = CoInitialize( NULL );

	if( hRes == E_OUTOFMEMORY || hRes == E_INVALIDARG || hRes == E_UNEXPECTED )
		return FALSE;
*/

    //  IShellLinkIuWFNg̎擾
    hResult = CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink,
                               (void **)&ShellLink);

    if (false == SUCCEEDED(hResult)) {
        return FALSE;
    }

    //  IPersistFileC^[tFCX̎擾
    hResult = ShellLink->QueryInterface(IID_IPersistFile, (void **)&PersistFile);
    if (false == SUCCEEDED(hResult)) {
		ShellLink->Release();
        return FALSE;
    }

    //  V[gJbgt@C̓ǂݍ
    MultiByteToWideChar(GetACP(), 0, pszLinkFile, -1, wszShortcutFile, _countof(wszShortcutFile));
    hResult = PersistFile->Load(wszShortcutFile, STGM_READ);
    if ( SUCCEEDED(hResult) ) {
		if ( pszTarget ) {
			// ^[Qbgt@C̎擾
			ZeroMemory(&wfd, sizeof(WIN32_FIND_DATA));
			hResult = ShellLink->GetPath(pszTarget, MAX_PATH*2, &wfd, SLGP_UNCPRIORITY);
			if ( false == SUCCEEDED(hResult) ) {
				bResult = FALSE;
			}
		}

		if ( pszOption ) {
			// IvV̎擾
			hResult = ShellLink->GetArguments(pszOption, MAX_PATH*2);
			if ( false == SUCCEEDED(hResult) ) {
				bResult = FALSE;
			}
		}

		if ( pszIcon && piIconIndex ) {
			//  ACR̎擾
			hResult = ShellLink->GetIconLocation(pszIcon, MAX_PATH*2, piIconIndex);
			if ( false == SUCCEEDED(hResult) ) {
				bResult = FALSE;
			}
		}
	}
	else {
		bResult = FALSE;
	}

    //  IPersistFileC^[tFCX̉
    PersistFile->Release();

    //  IShellLinkIuWFNg̉
    ShellLink->Release();

/*	CoUninitialize(); */ // - ̊֐ĂяovO̍ŌŁA͍sĂ

    return bResult;
}

LibExport BOOL QueryLinkW(const wchar_t *pszLinkFile, wchar_t *pszTarget, wchar_t *pszOption,
						        wchar_t *pszIcon, int *piIconIndex) {

    IShellLinkW     *ShellLink = NULL;
    IPersistFile    *PersistFile = NULL;
    HRESULT         hResult = 0;
    WIN32_FIND_DATAW wfd;
	BOOL            bResult = TRUE;

	if ( pszLinkFile == NULL ) {
		return FALSE;
	}

/*	// OLEgpȌ -- ̊֐ĂяovO̖`ŁA͂܂ĂƁI
	hRes = CoInitialize( NULL );

	if( hRes == E_OUTOFMEMORY || hRes == E_INVALIDARG || hRes == E_UNEXPECTED )
		return FALSE;
*/

    //  IShellLinkIuWFNg̎擾
    hResult = CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLinkW,
                               (void **)&ShellLink);

    if (false == SUCCEEDED(hResult)) {
        return FALSE;
    }

    //  IPersistFileC^[tFCX̎擾
    hResult = ShellLink->QueryInterface(IID_IPersistFile, (void **)&PersistFile);
    if (false == SUCCEEDED(hResult)) {
		ShellLink->Release();
        return FALSE;
    }

    //  V[gJbgt@C̓ǂݍ
    hResult = PersistFile->Load(pszLinkFile, STGM_READ);
    if ( SUCCEEDED(hResult) ) {
		if ( pszTarget ) {
			// ^[Qbgt@C̎擾
			ZeroMemory(&wfd, sizeof(WIN32_FIND_DATAW));
			hResult = ShellLink->GetPath(pszTarget, MAX_PATH, &wfd, SLGP_UNCPRIORITY);
			if ( false == SUCCEEDED(hResult) ) {
				bResult = FALSE;
			}
		}

		if ( pszOption ) {
			// IvV̎擾
			hResult = ShellLink->GetArguments(pszOption, MAX_PATH);
			if ( false == SUCCEEDED(hResult) ) {
				bResult = FALSE;
			}
		}

		if ( pszIcon && piIconIndex ) {
			//  ACR̎擾
			hResult = ShellLink->GetIconLocation(pszIcon, MAX_PATH, piIconIndex);
			if ( false == SUCCEEDED(hResult) ) {
				bResult = FALSE;
			}
		}
	}
	else {
		bResult = FALSE;
	}

    //  IPersistFileC^[tFCX̉
    PersistFile->Release();

    //  IShellLinkIuWFNg̉
    ShellLink->Release();

/*	CoUninitialize(); */ // - ̊֐ĂяovO̍ŌŁA͍sĂ

    return bResult;
}

// _strdupnew
LibExport char *new_strcpyA(const char *src)
{
	char *des;

	if ( src ) {
		des = new char [lstrlen(src)+1];
		if ( des ) {
			return lstrcpy(des, src);
		}
	}
	return NULL;
}
LibExport wchar_t *new_strcpyW(const wchar_t *src)
{
	wchar_t *des;

	if ( src ) {
		des = new wchar_t [lstrlenW(src)+1];
		if ( des ) {
			return lstrcpyW(des, src);
		}
	}
	return NULL;
}

// new_strcpystrcat
LibExport char *new_strcatA(char *ptr, const char *str)
{
	char *des;

	if ( str ) {
		if ( ptr ) {
			des = new char [lstrlen(str)+lstrlen(ptr)+1];
			if ( des ) {
				lstrcpy(des, ptr);
				delete[] ptr;
				lstrcat(des, str);
			}
			else
				return NULL;
		}
		else {
			des = new_strcpy(str);
		}

		return des;
	}
	else {
		return ptr;
	}
}

LibExport wchar_t *new_strcatW(wchar_t *ptr, const wchar_t *str)
{
	wchar_t *des;

	if ( str ) {
		if ( ptr ) {
			des = new wchar_t [lstrlenW(str)+lstrlenW(ptr)+1];
			if ( des ) {
				lstrcpyW(des, ptr);
				delete[] ptr;
				lstrcatW(des, str);
			}
			else
				return NULL;
		}
		else {
			des = new_strcpyW(str);
		}

		return des;
	}
	else {
		return ptr;
	}
}

// X^[gj[:vÕtH_ilpj𓾂
LibExport char *GetProgramFolderA(void)
{
	char	        chPath[MAX_PATH*2];
	static char    *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@vOtH_ilj
		SHGetSpecialFolderLocation( NULL, CSIDL_PROGRAMS, &pidl );
		SHGetPathFromIDList( pidl, chPath );
		return_p = _strdup( chPath );
	}
	return return_p;
}

LibExport wchar_t *GetProgramFolderW(void)
{
	wchar_t	        chPath[MAX_PATH];
	static wchar_t  *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@vOtH_ilj
		SHGetSpecialFolderLocation( NULL, CSIDL_PROGRAMS, &pidl );
		SHGetPathFromIDListW( pidl, chPath );
		return_p = _wcsdup( chPath );
	}
	return return_p;
}

// X^[gj[:vÕtH_iS[U[pj𓾂
LibExport char *GetCommonProgramFolderA(void)
{
	char	        chPath[MAX_PATH*2];
	static char    *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@vOtH_iS[U[j
		SHGetSpecialFolderLocation( NULL, CSIDL_COMMON_PROGRAMS, &pidl );
		SHGetPathFromIDList( pidl, chPath );
		return_p = _strdup( chPath );
	}
	return return_p;
}

LibExport wchar_t *GetCommonProgramFolderW(void)
{
	wchar_t	        chPath[MAX_PATH];
	static wchar_t  *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@vOtH_iS[U[j
		SHGetSpecialFolderLocation( NULL, CSIDL_COMMON_PROGRAMS, &pidl );
		SHGetPathFromIDListW( pidl, chPath );
		return_p = _wcsdup( chPath );
	}
	return return_p;
}

// fXNgbvtH_ilpj𓾂
LibExport char *GetDesktopFolderA(void)
{
	char	        chPath[MAX_PATH*2];
	static char    *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@fXNgbvtH_ilj
		SHGetSpecialFolderLocation( NULL, CSIDL_DESKTOPDIRECTORY, &pidl );
		SHGetPathFromIDList( pidl, chPath );
		return_p = _strdup( chPath );
	}
	return return_p;
}

LibExport wchar_t *GetDesktopFolderW(void)
{
	wchar_t	        chPath[MAX_PATH];
	static wchar_t *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@fXNgbvtH_ilj
		SHGetSpecialFolderLocation( NULL, CSIDL_DESKTOPDIRECTORY, &pidl );
		SHGetPathFromIDListW( pidl, chPath );
		return_p = _wcsdup( chPath );
	}
	return return_p;
}

// fXNgbvtH_iS[U[pj𓾂
LibExport char *GetCommonDesktopFolderA(void)
{
	char	        chPath[MAX_PATH*2];
	static char    *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@fXNgbvtH_iS[U[j
		SHGetSpecialFolderLocation( NULL, CSIDL_COMMON_DESKTOPDIRECTORY, &pidl );
		SHGetPathFromIDList( pidl, chPath );
		return_p = _strdup( chPath );
	}
	return return_p;
}

LibExport wchar_t *GetCommonDesktopFolderW(void)
{
	wchar_t	        chPath[MAX_PATH];
	static wchar_t *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@fXNgbvtH_iS[U[j
		SHGetSpecialFolderLocation( NULL, CSIDL_COMMON_DESKTOPDIRECTORY, &pidl );
		SHGetPathFromIDListW( pidl, chPath );
		return_p = _wcsdup( chPath );
	}
	return return_p;
}

// X^[gAbvtH_ilpj𓾂
LibExport char *GetStartUpFolderA(void)
{
	char	        chPath[MAX_PATH*2];
	static char    *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@X^[gAbvtH_ilj
		SHGetSpecialFolderLocation( NULL, CSIDL_STARTUP, &pidl );
		SHGetPathFromIDList( pidl, chPath );
		return_p = _strdup( chPath );
	}
	return return_p;
}

LibExport wchar_t *GetStartUpFolderW(void)
{
	wchar_t	        chPath[MAX_PATH];
	static wchar_t *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@X^[gAbvtH_ilj
		SHGetSpecialFolderLocation( NULL, CSIDL_STARTUP, &pidl );
		SHGetPathFromIDListW( pidl, chPath );
		return_p = _wcsdup( chPath );
	}
	return return_p;
}

// X^[gAbvtH_iS[U[pj𓾂
LibExport char *GetCommonStartUpFolderA(void)
{
	char	        chPath[MAX_PATH*2];
	static char    *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@X^[gAbvtH_iS[U[j
		SHGetSpecialFolderLocation( NULL, CSIDL_COMMON_STARTUP, &pidl );
		SHGetPathFromIDList( pidl, chPath );
		return_p = _strdup( chPath );
	}
	return return_p;
}

LibExport wchar_t *GetCommonStartUpFolderW(void)
{
	wchar_t	        chPath[MAX_PATH];
	static wchar_t *return_p = NULL;
	LPITEMIDLIST	pidl;

	if ( !return_p ) {
		//@X^[gAbvtH_iS[U[j
		SHGetSpecialFolderLocation( NULL, CSIDL_COMMON_STARTUP, &pidl );
		SHGetPathFromIDListW( pidl, chPath );
		return_p = _wcsdup( chPath );
	}
	return return_p;
}

// NfBNg(WindowstH_ł͂Ȃ)𓾂
LibExport char *GetBootDirectoryA(void)
{
	char	        chPath[MAX_PATH*2];
	static char    *return_p = NULL;

	if ( !return_p ) {
		//@WXg𓾂邪AȂƂ̂߂ WindowsfBNg̐B
		GetWindowsDirectory(chPath, _countof(chPath));
		chPath[3] = 0;

		// HKLM\Software\Microsoft\Windows\CurrentVersion\Setup  BootDir
		HKEY  hkey;
		char  regPath[MAX_PATH*2];
		DWORD regtype, regPathSize = _countof(regPath);

		if ( ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Windows\\CurrentVersion\\Setup", NULL, KEY_QUERY_VALUE, &hkey ) ) {
			if ( ERROR_SUCCESS == RegQueryValueEx(hkey, "BootDir", NULL, &regtype, (LPBYTE)regPath, &regPathSize) ) {
				if ( regtype == REG_SZ || regtype == REG_EXPAND_SZ ) {
                    lstrcpy( chPath, regPath );
				}
			}
			RegCloseKey( hkey );
		}

		return_p = _strdup( chPath );
	}
	return return_p;
}

LibExport wchar_t *GetBootDirectoryW(void)
{
	wchar_t	        chPath[MAX_PATH];
	static wchar_t  *return_p = NULL;

	if ( !return_p ) {
		//@WXg𓾂邪AȂƂ̂߂ WindowsfBNg̐B
		GetWindowsDirectoryW(chPath, _countof(chPath));
		chPath[3] = 0;

		// HKLM\Software\Microsoft\Windows\CurrentVersion\Setup  BootDir
		HKEY  hkey;
		wchar_t  regPath[MAX_PATH];
		DWORD regtype, regPathSize = _countof(regPath);

		if ( ERROR_SUCCESS == RegOpenKeyExW(HKEY_LOCAL_MACHINE, L"Software\\Microsoft\\Windows\\CurrentVersion\\Setup", NULL, KEY_QUERY_VALUE, &hkey ) ) {
			if ( ERROR_SUCCESS == RegQueryValueExW(hkey, L"BootDir", NULL, &regtype, (LPBYTE)regPath, &regPathSize) ) {
				if ( regtype == REG_SZ || regtype == REG_EXPAND_SZ ) {
                    lstrcpyW( chPath, regPath );
				}
			}
			RegCloseKey( hkey );
		}

		return_p = _wcsdup( chPath );
	}
	return return_p;
}

// _CAO當ǂ݂ƂÂ܂ܗ̈悲ƕԂBƂ delete[] 邱ƁI
LibExport char *new_GetDlgItemTextA(HWND hDlg, int nIDDlgItem)
{
	int n;
	char *str;

	n = GetWindowTextLength(GetDlgItem(hDlg, nIDDlgItem))+1;
	str = new char [n];
	if ( str ) {
		GetDlgItemText(hDlg, nIDDlgItem, str, n);
	}
	return str;
}

LibExport wchar_t *new_GetDlgItemTextW(HWND hDlg, int nIDDlgItem)
{
	int n;
	wchar_t *str;

	n = GetWindowTextLengthW(GetDlgItem(hDlg, nIDDlgItem))+1;
	str = new wchar_t [n];
	if ( str ) {
		GetDlgItemTextW(hDlg, nIDDlgItem, str, n);
	}
	return str;
}

// c[`bv̍쐬
LibExport HWND CreateToolTipA(HINSTANCE hInst, HWND hWnd, const struct DEFTOOLTIP *dtt)
{
	HWND hTooltip;
	TOOLINFO ti;

	if (NULL == (hTooltip=CreateWindow(TOOLTIPS_CLASS, "", TTS_ALWAYSTIP, CW_USEDEFAULT, CW_USEDEFAULT,
		                               CW_USEDEFAULT, CW_USEDEFAULT, hWnd, NULL, hInst, NULL)))
		return NULL;

	ZeroMemory(&ti, sizeof(ti));
	ti.cbSize = sizeof(ti);
	ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;// uID̓c[`bv\EBhEʂnh / TuNXC
	ti.hwnd=hWnd;	// c[`bvEBhE

	while(dtt->cid != 0 && dtt->tip != NULL) {
#pragma warning( disable : 4311 )
		ti.uId = (UINT)GetDlgItem(hWnd, dtt->cid);
#pragma warning( default : 4311 )
		ti.lpszText = dtt->tip;// `bv
		SendMessage(hTooltip, TTM_ADDTOOL, 0, (LPARAM)&ti);
		dtt++;
	}
	return hTooltip;
}

LibExport HWND CreateToolTipW(HINSTANCE hInst, HWND hWnd, const struct DEFTOOLTIPW *dtt)
{
	HWND hTooltip;
	TOOLINFOW ti;

	if (NULL == (hTooltip=CreateWindowW(TOOLTIPS_CLASSW, L"", TTS_ALWAYSTIP, CW_USEDEFAULT, CW_USEDEFAULT,
		                                CW_USEDEFAULT, CW_USEDEFAULT, hWnd, NULL, hInst, NULL)))
		return NULL;

	ZeroMemory(&ti, sizeof(ti));
	ti.cbSize = sizeof(ti);
	ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;// uID̓c[`bv\EBhEʂnh / TuNXC
	ti.hwnd=hWnd;	// c[`bvEBhE

	while(dtt->cid != 0 && dtt->tip != NULL) {
#pragma warning( disable : 4311 )
		ti.uId = (UINT)GetDlgItem(hWnd, dtt->cid);
#pragma warning( default : 4311 )
		ti.lpszText = dtt->tip;// `bv
		SendMessageW(hTooltip, TTM_ADDTOOLW, 0, (LPARAM)&ti);
		dtt++;
	}
	return hTooltip;
}

// 񋓂ꂽqEBhE󂯎 (SetChildWindowFontŎg)
static BOOL CALLBACK EnumChildProc(HWND hWnd, LPARAM)
{
	SendMessage(hWnd,WM_SETFONT, (WPARAM)GetStockObject(DEFAULT_GUI_FONT), 0);
	return TRUE;
}

// w肵_CAO̎qEBhE(Rg[)̃tHg MS UI Gothic ɂĂ܂
LibExport void SetChildWindowFont(HWND hWnd)
{
	EnumChildWindows(hWnd, EnumChildProc, 0);
}

// \B
LibExport BOOL TextOutLengthA(HDC hdc, const char *str, int x0, int y0)
{
	return TextOut(hdc, x0, y0, str, lstrlen(str));
}
LibExport BOOL TextOutLengthW(HDC hdc, const wchar_t *str, int x0, int y0)
{
	return TextOutW(hdc, x0, y0, str, lstrlenW(str));
}

// w肳ꂽlp̒ɁA\(sAst)B
LibExport int DrawTextRectA(HDC hdc, const char *str, int x0, int y0, int x1, int y1)
{
	RECT rt;

	rt.left   = x0;
	rt.top    = y0;
	rt.right  = x1;
	rt.bottom = y1;

	return DrawText( hdc, str, lstrlen(str), &rt, DT_LEFT | DT_NOPREFIX | DT_WORDBREAK );
}
LibExport int DrawTextRectW(HDC hdc, const wchar_t *str, int x0, int y0, int x1, int y1)
{
	RECT rt;

	rt.left   = x0;
	rt.top    = y0;
	rt.right  = x1;
	rt.bottom = y1;

	return DrawTextW( hdc, str, lstrlenW(str), &rt, DT_LEFT | DT_NOPREFIX | DT_WORDBREAK );
}

typedef DWORD (WINAPI *PFUNC_SetLayeredWindowAttributes)(HWND,DWORD,BYTE,DWORD);
typedef DWORD (WINAPI *QFUNC_GetLayeredWindowAttributes)(HWND,LPDWORD,LPBYTE,LPDWORD);

// w肳ꂽEChE𔼓ɂ n:l
LibExport int SetExl(HWND hWnd, BYTE n)
{
	if (n != 255) {
		SetWindowLongPtr(hWnd, GWL_EXSTYLE, GetWindowLongPtr(hWnd, GWL_EXSTYLE) | WS_EX_LAYERED);
	}
	SetLayeredWindowAttributes(hWnd, 0, n, 2);
	if (n == 255) {
		SetWindowLongPtr(hWnd, GWL_EXSTYLE, GetWindowLongPtr(hWnd, GWL_EXSTYLE) & (~WS_EX_LAYERED));
	}
	return 1;
}

// w肳ꂽEChẼl𓾂
LibExport int GetExl(HWND hWnd)
{
	BYTE n = 255;

	if (GetLayeredWindowAttributes(hWnd,NULL,&n,NULL)) {
		return (int)n;
	}
	else {
		return 255;
	}
}

// GfBbg{bNX̒glǂāA 0 
LibExport BOOL CheckNumericDlgEdit(HWND hWnd, WORD id) 
{
	static volatile bool flag=0; // ē`FbN
	UINT   value;
	char   buf[12]="";

	if (flag == 1) {
		return TRUE;
	}

	if (GetWindowLongPtr(GetDlgItem(hWnd,id), GWL_STYLE) & ES_NUMBER) {
		flag = 1;
		value = GetDlgItemInt(hWnd, id, NULL, 0);
		GetDlgItemText(hWnd, id, buf, 11);
		if (buf[0] && 0 != _ultoa_s(value, buf, UBOUND(buf), 10)) {
			SetDlgItemInt(hWnd, id, value, 0);
		}
		flag = 0;
	}
	return FALSE;
}

// 16i10i
LibExport int atoi16A(const char *str)
{
	int rv = 0;

	if ( str ) {
		while( *str ) {
			rv <<= 4;
			switch( *str ) {
				case '1': rv |= 0x1; break;
				case '2': rv |= 0x2; break;
				case '3': rv |= 0x3; break;
				case '4': rv |= 0x4; break;
				case '5': rv |= 0x5; break;
				case '6': rv |= 0x6; break;
				case '7': rv |= 0x7; break;
				case '8': rv |= 0x8; break;
				case '9': rv |= 0x9; break;
				case 'A':
				case 'a': rv |= 0xa; break;
				case 'B':
				case 'b': rv |= 0xb; break;
				case 'C':
				case 'c': rv |= 0xc; break;
				case 'D':
				case 'd': rv |= 0xd; break;
				case 'E':
				case 'e': rv |= 0xe; break;
				case 'F':
				case 'f': rv |= 0xf; break;
			}
			str++;
		}
	}
	return rv;
}
LibExport int atoi16W(const wchar_t *str)
{
	int rv = 0;

	if ( str ) {
		while( *str ) {
			rv <<= 4;
			switch( *str ) {
				case L'1': rv |= 0x1; break;
				case L'2': rv |= 0x2; break;
				case L'3': rv |= 0x3; break;
				case L'4': rv |= 0x4; break;
				case L'5': rv |= 0x5; break;
				case L'6': rv |= 0x6; break;
				case L'7': rv |= 0x7; break;
				case L'8': rv |= 0x8; break;
				case L'9': rv |= 0x9; break;
				case L'A':
				case L'a': rv |= 0xa; break;
				case L'B':
				case L'b': rv |= 0xb; break;
				case L'C':
				case L'c': rv |= 0xc; break;
				case L'D':
				case L'd': rv |= 0xd; break;
				case L'E':
				case L'e': rv |= 0xe; break;
				case L'F':
				case L'f': rv |= 0xf; break;
			}
			str++;
		}
	}
	return rv;
}

// 3Ƃ̃J}t (Ԃ̂͊֐staticȃobt@ւ̃|C^ł邱Ƃɒ)
LibExport char *commaA(unsigned int value)
{
	static char s[2][14];          // return ɂÄ悪c
	static volatile bool flag = 0;

	flag = !flag;
	return commaexA(value, s[flag]);
}
LibExport wchar_t *commaW(unsigned int value)
{
	static wchar_t s[2][14];          // return ɂÄ悪c
	static volatile bool flag = 0;

	flag = !flag;
	return commaexW(value, s[flag]);
}

// 3Ƃ̃J}t (ē\ŁB14oCg̕񂪊i[łobt@n)
LibExport char *commaexA(unsigned int value, char *rp)
{
	char s1[11], n1, n2;

	if ( rp ) {
		wsprintf(s1, "%10u", value);

		rp[13] = 0;
		for(n1=0,n2=0 ; n1<11 ; n1++,n2++) {
			rp[12-n2] = s1[9-n1];
			if (s1[8-n1] == ' ') {
				rp = &rp[12-n2];
				break;
			}
			if (n1==2 || n1==5 || n1==8) {
				rp[12-(++n2)] = ',';
			}
		}
	}

    return rp;
}
LibExport wchar_t *commaexW(unsigned int value, wchar_t *rp)
{
	wchar_t s1[11], n1, n2;

	if ( rp ) {
		wsprintfW(s1, L"%10u", value);

		rp[13] = 0;
		for(n1=0,n2=0 ; n1<11 ; n1++,n2++) {
			rp[12-n2] = s1[9-n1];
			if (s1[8-n1] == L' ') {
				rp = &rp[12-n2];
				break;
			}
			if (n1==2 || n1==5 || n1==8) {
				rp[12-(++n2)] = L',';
			}
		}
	}

    return rp;
}

// tpXt@C̕o (_uR[e[VƂ܂܂)
LibExport const char *GetOnlyFileNameA(const char *path)
{
	int i;

	if ( path ) {
		for(i=lstrlen(path) ; i>=0 ; i--) {
			if ((path[i] == '\\' || path[i] == ':') && !isKanji1A(path, i-1) ) {
				i++;
				break;
			}
		}

		return &path[i];
	}
	else {
		return NULL;
	}
}

LibExport const wchar_t *GetOnlyFileNameW(const wchar_t *path)
{
	int i;

	if ( path ) {
		for(i=lstrlenW(path) ; i>=0 ; i--) {
			if ( path[i] == L'\\' || path[i] == L':' ) {
				i++;
				break;
			}
		}

		return &path[i];
	}
	else {
		return NULL;
	}
}

// CreateDir⏕֐
static int  aux_CreateDirA(char *dirname)
{
	char cdir[MAX_PATH*2]; // ݂̃JgtH_ۑ
	int  i;

	GetCurrentDirectory(_countof(cdir), cdir);
	if (SetCurrentDirectory(dirname)) {
		SetCurrentDirectory(cdir);
		return 1;
	}
	else {
		SetCurrentDirectory(cdir);
		for(i=0 ; dirname[i] ; i++) {
			if ( !isKanji1A(dirname,i-1) && dirname[i] == '\\' ) {
				dirname[i] = 0;
				CreateDirectory(dirname,NULL);
				dirname[i] = '\\';
			}
		}
		if ( !isKanji1A(dirname,i-1) && dirname[i-1] == '\\' )
			dirname[i-1] = 0;
		return CreateDirectory(dirname, NULL);
	}
}

static int  aux_CreateDirW(wchar_t *dirname)
{
	wchar_t cdir[MAX_PATH]; // ݂̃JgtH_ۑ
	int  i;

	GetCurrentDirectoryW(_countof(cdir), cdir);
	if (SetCurrentDirectoryW(dirname)) {
		SetCurrentDirectoryW(cdir);
		return 1;
	}
	else {
		SetCurrentDirectoryW(cdir);
		for(i=0 ; dirname[i] ; i++) {
			if ( dirname[i] == L'\\' ) {
				dirname[i] = 0;
				CreateDirectoryW(dirname, NULL);
				dirname[i] = L'\\';
			}
		}
		if ( dirname[i-1] == L'\\' )
			dirname[i-1] = 0;
		return CreateDirectoryW(dirname,NULL);
	}
}

// tH_̍쐬(etH_ȂĂIɍ쐬)
LibExport int  CreateDirA(const char *dirname)
{
	char *mdir = _strdup(dirname);
	int  result = 0;

	if ( mdir ) {
		result = aux_CreateDirA( mdir );
		safefree(mdir);
	}

	return result;
}

LibExport int  CreateDirW(const wchar_t *dirname)
{
	wchar_t *mdir = _wcsdup(dirname);
	int  result = 0;

	if ( mdir ) {
		result = aux_CreateDirW( mdir );
		safefree(mdir);
	}

	return result;
}

// UINT
LibExport unsigned atouA(const char *str)
{
	unsigned int i, result = 0;

	for(i=0 ; i<10 ; i++) {
		if ( '0' <= str[i] && str[i] <= '9' ) {
			result *= 10;
			result += (str[i]-'0');
		}
		else {
			break;
		}
	}

	return result;
}

LibExport unsigned atouW(const wchar_t *str)
{
	unsigned int i, result = 0;

	for(i=0 ; i<10 ; i++) {
		if ( L'0' <= str[i] && str[i] <= L'9' ) {
			result *= 10;
			result += (str[i]-L'0');
		}
		else {
			break;
		}
	}

	return result;
}

// fBNĝ݂𔲂o
// fullpath̃fBNg̕dirbufɏoB
// fullpath̃|C^dirbuf̃|C^wĂ悪ł悢
//  dirbuf ԂAsNULLԂ
LibExport char *getDirectoryNameA(const char *fullpath, char *dirbuf, int dirbufsize)
{
	int len, i;
	char *buf;

	if ( fullpath && dirbuf ) {
		len = lstrlen(fullpath);
		buf = zalloc(len+1);

		if ( buf ) {
			lstrcpy( buf, fullpath );
			for(i=len ; i>0 && !isKanji1A(buf,i-1) && buf[i] != ':' && buf[i] != '\\' ; i--)
				;
			if ( i > 0 ) {
				buf[i+1] = 0;
			}
			else {
				buf[0] = 0;
			}

			if ( lstrlen(buf) < dirbufsize ) {
				lstrcpy(dirbuf, buf);
				safefree(buf);
				return dirbuf;
			}
			else {
				safefree(buf);
			}
		}
	}

	return NULL; // fullpath ܂ dirbuf  NULL AȂȂǂ̗RŎs
}

LibExport wchar_t *getDirectoryNameW(const wchar_t *fullpath, wchar_t *dirbuf, int dirbufsize)
{
	int len, i;
	wchar_t *buf;

	if ( fullpath && dirbuf ) {
		len = lstrlenW(fullpath);
		buf = walloc(len+1);

		if ( buf ) {
			lstrcpyW( buf, fullpath );
			for(i=len ; i>0 && buf[i] != L':' && buf[i] != L'\\' ; i--)
				;
			if ( i > 0 ) {
				buf[i+1] = 0;
			}
			else {
				buf[0] = 0;
			}

			if ( lstrlenW(buf) < dirbufsize ) {
				lstrcpyW(dirbuf, buf);
				safefree(buf);
				return dirbuf;
			}
			else {
				safefree(buf);
			}
		}
	}

	return NULL; // fullpath ܂ dirbuf  NULL AȂȂǂ̗RŎs
}

// gq菜𔲂o
// fullpath̃fBNg{t@C̕dirbufɏoB
// fullpath̃|C^dirbuf̃|C^wĂ悪ł悢
//  dirbuf ԂAsNULLԂ
LibExport char *getFileNameOnlyA(const char *fullpath, char *fnamebuf, int fnamebufsize)
{
	int len, i;
	char *buf;

	if ( fullpath && fnamebuf ) {
		len = lstrlen(fullpath);
		buf = zalloc(len+1);

		if ( buf ) {
			lstrcpy( buf, fullpath );
			for(i=len ; i>0 && buf[i] != ':' && buf[i] != '\\' && buf[i] != '.' ; i--)
				;
			if ( buf[i] == '.' ) {
				buf[i] = 0;
			}

			if ( lstrlen(buf) < fnamebufsize ) {
				lstrcpy(fnamebuf, buf);
				safefree(buf);
				return fnamebuf;
			}
			else {
				safefree(buf);
			}
		}
	}

	return NULL; // fullpath ܂ fnamebuf  NULL AȂȂǂ̗RŎs
}

LibExport wchar_t *getFileNameOnlyW(const wchar_t *fullpath, wchar_t *fnamebuf, int fnamebufsize)
{
	int len, i;
	wchar_t *buf;

	if ( fullpath && fnamebuf ) {
		len = lstrlenW(fullpath);
		buf = walloc(len+1);

		if ( buf ) {
			lstrcpyW( buf, fullpath );
			for(i=len ; i>0 && buf[i] != L':' && buf[i] != L'\\' && buf[i] != L'.' ; i--)
				;
			if ( buf[i] == L'.' ) {
				buf[i] = 0;
			}

			if ( lstrlenW(buf) < fnamebufsize ) {
				lstrcpyW(fnamebuf, buf);
				safefree(buf);
				return fnamebuf;
			}
			else {
				safefree(buf);
			}
		}
	}

	return NULL; // fullpath ܂ fnamebuf  NULL AȂȂǂ̗RŎs
}

LibExport char *lvGetItemStringA( HWND hListview, unsigned n, unsigned c )
{
	UINT bufsize = 256, lb;
	char *buf = NULL;

	while( 1 ) {
		buf = zalloc(bufsize);
		if ( buf ) {
			ListView_GetItemText( hListview, n, c, buf, bufsize );
			buf[bufsize-1] = 0;

			if ( (UINT)lstrlen(buf) == bufsize-1 ) {
				// obt@̃TCYȂ\
				free( buf ); buf = NULL;
				lb = bufsize;
				bufsize *= 2; // obt@TCY2{ɂĂ蒼
				if( lb > bufsize ) { // I[o[t[(mۂɎs)
					return NULL;
				}
                continue;
			}
			else {
				// ]ɊmۂĂ܂Ă̂ŁA؂߂
				char *tmp = (char *)realloc( buf, sizeof(char)*(lstrlen(buf)+1) );

				if ( tmp ) {
					buf = tmp;
				}
				return buf;
			}
		}
		else {
			return NULL; // mۂɎs
		}
	}
}

#define ListView_GetItemTextW(hwndLV, i, iSubItem_, pszText_, cchTextMax_) \
{ LV_ITEMW _ms_lvi;\
  _ms_lvi.iSubItem = iSubItem_;\
  _ms_lvi.cchTextMax = cchTextMax_;\
  _ms_lvi.pszText = pszText_;\
  SendMessageW((hwndLV), LVM_GETITEMTEXTW, (WPARAM)(i), (LPARAM)&_ms_lvi);\
}

LibExport wchar_t *lvGetItemStringW( HWND hListview, unsigned n, unsigned c )
{
	UINT bufsize = 256, lb;
	wchar_t *buf = NULL;

	while( 1 ) {
		buf = walloc(bufsize);
		if ( buf ) {
			LV_ITEMW _ms_lvi;
			_ms_lvi.iSubItem = c;
			_ms_lvi.cchTextMax = bufsize;
			_ms_lvi.pszText = buf;
			SendMessageW(hListview, LVM_GETITEMTEXTW, (WPARAM)n, (LPARAM)&_ms_lvi);

			buf[bufsize-1] = 0;

			if ( (UINT)lstrlenW(buf) == bufsize - 1 ) {
				// obt@̃TCYȂ\
				free( buf ); buf = NULL;
				lb = bufsize;
				bufsize *= 2; // obt@TCY2{ɂĂ蒼
				if( lb > bufsize ) { // I[o[t[(mۂɎs)
					return NULL;
				}
                continue;
			}
			else {
				// ]ɊmۂĂ܂Ă̂ŁA؂߂
				wchar_t *tmp = (wchar_t *)realloc( buf, sizeof(wchar_t)*(lstrlenW(buf)+1) );

				if ( tmp ) {
					buf = tmp;
				}
				return buf;
			}
		}
		else {
			return NULL; // mۂɎs
		}
	}
}

// SJISł邱ƂlAstrlwr
LibExport char *sjislwr(char *str)
{
	if (str) {
		char *p = str;
		while(*p) {
			if (ISKANJI1M(*p)) {	// SJIS}`oCgPڂ
				++p;				// ͋̕XLbv
				if (*p == 0) {		// ˔@ƂďI[FI
					break;
				}
			}
			else {
				// nˑłA啶ϊ
				if ('A' <= (unsigned char)*p && (unsigned char)*p <= 'Z') {
					*p += ('a' - 'A');
				}
			}
			++p;
		}
	}
	return str;
}

// SJISł邱ƂlAstrupr
LibExport char *sjisupr(char *str)
{
	if (str) {
		char *p = str;
		while(*p) {
			if (ISKANJI1M(*p)) {	// SJIS}`oCgPڂ
				++p;				// ͋̕XLbv
				if (*p == 0) {		// ˔@ƂďI[FI
					break;
				}
			}
			else {
				// nˑłA啶ϊ
				if ('a' <= (unsigned char)*p && (unsigned char)*p <= 'z') {
					*p -= ('a' - 'A');
				}
			}
			++p;
		}
	}
	return str;
}

// SJISł邱ƂlAstrstr
LibExport char *sjisstr( const char *str1, const char *str2 )
{
	if (str1 != NULL && str2 != NULL) {
		if (str2[0] == 0) {
			// str2ɒ0̕񂪗^ꂽAstr1Ԃ
			return (char *)str1;
		}

		size_t str1len = strlen(str1);
		size_t str2len = strlen(str2);
		size_t i = 0;

		while(str1len - i >= str2len) {
			if (0 == memcmp(&str1[i], str2, str2len)) {
				// 
				return (char *)&str1[i];
			}

			if (ISKANJI1M(str1[i])) {
				// قǔȓPoCgڂA
				// }`oCgƂĂ̑PoCgڂ
				i += 2;
			}
			else {
				++i;
			}
		}
	}
	return NULL;	// Ȃ
}

// SJISł邱ƂlAstrstriB
LibExport char *sjisstri( const char *str1, const char *str2 )
{
	char *p, *q, *r = NULL;
	UINT i = 0;

	if (str1 != NULL && str2 != NULL) {
		p = _strdup( str1 );
		if ( p ) {
			q = _strdup( str2 );
			if ( q ) {
				r = sjisstr(sjislwr(p), sjislwr(q));
				i = (UINT)(r - p);
				free( q );
			}
			free( p );
		}
		return r?(char *)(str1 + i):NULL;
	}
	else {
		return NULL;
	}
}

// case sensitivełȂstrstr
LibExport char *strstriA( const char *str1, const char *str2 )
{
	char *p, *q, *r = NULL;
	UINT i = 0;

	if (str1 != NULL && str2 != NULL) {
		p = _strdup( str1 );
		if ( p ) {
			q = _strdup( str2 );
			if ( q ) {
#pragma warning( disable : 4996 )
				r = strstr(_strlwr(p), _strlwr(q));
#pragma warning( default : 4996 )
				i = (UINT)(r - p);
				free( q );
			}
			free( p );
		}
		return r?(char *)(str1 + i):NULL;
	}
	else {
		return NULL;
	}
}

LibExport wchar_t *strstriW( const wchar_t *str1, const wchar_t *str2 )
{
	wchar_t *p, *q, *r = NULL;
	UINT i = 0;

	if (str1 != NULL && str2 != NULL) {
		p = _wcsdup( str1 );
		if ( p ) {
			q = _wcsdup( str2 );
			if ( q ) {
#pragma warning( disable : 4996 )
				r = wcsstr(_wcslwr(p), _wcslwr(q));
#pragma warning( default : 4996 )
				i = (UINT)(r - p);
				free( q );
			}
			free( p );
		}
		return r?(wchar_t *)(str1 + i):NULL;
	}
	else {
		return NULL;
	}
}

// strrep1ׂrep2ɒu
// ߂lFϊ̕ւ̃|C^BgI(free)邱
LibExport char *replacestrA( const char *str, const char *rep1, const char *rep2 )
{
	wchar_t *vw = NULL;	// [NGA

	if ( str && rep1 && rep1[0] ) {
		if ( rep2 == NULL ) {
            rep2 = "";
		}

		try {
			// ΏەEEuAꂼwidecharɕϊ
			// ܂͌Ώە
			vw = mb2wc(str);
			wstring w_str(vw);
			safefree(vw);

			// Ɍ
			vw = mb2wc(rep1);
			wstring w_rep1(vw);
			safefree(vw);
			wstring::size_type w_rep1_length = w_rep1.length();

			// Ōɒu㕶
			vw = mb2wc(rep2);
			wstring w_rep2(vw);
			safefree(vw);
			wstring::size_type w_rep2_length = w_rep2.length();

			// str̎n߂̕rep1T[`Arep2ɒuĂ
			wstring::size_type p = 0;	// T[`̈ʒu
			wstring::size_type rp;		// rep1ʒu

			while(1) {
				rp = w_str.find(w_rep1, p);
				if ( rp == wstring::npos ) {
					break;
				}
				else {
					w_str.replace(rp, w_rep1_length, w_rep2);
					p = rp + w_rep2_length;
				}
			}

			// u㕶WideCharł邽߁AMultiByteɕϊĂԋp
			// ԋpĺAƂfree()Kv
			return wc2mb(w_str.c_str());
		}
		catch(...) {
			safefree(vw);
			return NULL;
		}
	}
	else {
		return NULL;
	}
}

LibExport wchar_t *replacestrW( const wchar_t *str, const wchar_t *rep1, const wchar_t *rep2 )
{
	if ( str && rep1 && rep1[0] ) {
		if ( rep2 == NULL ) {
            rep2 = L"";
		}

		try {
			// ΏەEEuAꂼwstringɑ
			// ܂͌Ώە
			wstring w_str(str);

			// Ɍ
			wstring w_rep1(rep1);
			wstring::size_type w_rep1_length = w_rep1.length();

			// Ōɒu㕶
			wstring w_rep2(rep2);
			wstring::size_type w_rep2_length = w_rep2.length();

			// str̎n߂̕rep1T[`Arep2ɒuĂ
			wstring::size_type p = 0;	// T[`̈ʒu
			wstring::size_type rp;		// rep1ʒu

			while(1) {
				rp = w_str.find(w_rep1, p);
				if ( rp == wstring::npos ) {
					break;
				}
				else {
					w_str.replace(rp, w_rep1_length, w_rep2);
					p = rp + w_rep2_length;
				}
			}

			// uʂ_wcsdup(_strdup)ĕԂ
			return _wcsdup(w_str.c_str());
		}
		catch(...) {
			return NULL;
		}
	}
	else {
		return NULL;
	}
}

	
// GetLastError()̖߂lnƁAG[bZ[W𕶎ɂĕԋp(߂l͉Ȃ)
LibExport char *getLastErrorStringMJPA(BOOL modeJP, DWORD errorcode)
{
    char *buf = NULL;
	static char *stbuf = NULL;

	safefree( stbuf );

    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_FROM_SYSTEM,
                  NULL, errorcode, modeJP ? MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT) : MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US), (LPSTR)&buf,
                  0, NULL);

    if( buf ) {
        stbuf = zalloc(lstrlen( buf ) + 1);
		if ( stbuf ) {
			int i, l = lstrlen(buf);
			for(i=0 ; i<l ; i++) { // Rg[R[hAXy[XɒuĂ
				if ( 0 < buf[i] && buf[i] < ' ' ) {
					buf[i] = ' ';
				}
			}
            lstrcpy(stbuf, buf);
		}
        LocalFree(buf);
    }
	else {
        return "FormatMessage() error";
	}

	return stbuf ? stbuf : "calloc() error";
}

LibExport wchar_t *getLastErrorStringMJPW(BOOL modeJP, DWORD errorcode)
{
    wchar_t *buf = NULL;
	static wchar_t *stbuf = NULL;

	safefree( stbuf );

    FormatMessageW(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_FROM_SYSTEM,
                   NULL, errorcode, modeJP ? MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT) : MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US), (LPWSTR)&buf,
                   0, NULL);

    if( buf ) {
        stbuf = walloc(lstrlenW( buf ) + 1);
		if ( stbuf ) {
			int i, l = lstrlenW(buf);
			for(i=0 ; i<l ; i++) { // Rg[R[hAXy[XɒuĂ
				if ( 0 < buf[i] && buf[i] < L' ' ) {
					buf[i] = L' ';
				}
			}
            lstrcpyW(stbuf, buf);
		}
        LocalFree(buf);
    }
	else {
        return L"FormatMessage() error";
	}

	return stbuf ? stbuf : L"calloc() error";
}

typedef BOOL (WINAPI *SR_SET_RESTORE_POINT)(PRESTOREPOINTINFO, PSTATEMGRSTATUS);
typedef BOOL (WINAPI *SR_SET_RESTORE_POINTW)(PRESTOREPOINTINFOW, PSTATEMGRSTATUS);

// |Cg쐬
// @Fname = 쐬镜|Cgɕt閼O(MAX_DESCoCg܂)
// ߂lF ERROR_SUCCESS(0), s 0ȊO
//   s̒ĺASRSetRestorePointSTATEMGRSTATUSnStatusɐݒ肷l
//     ASRSetRestorePointȊO(DLL̃A^b`)ł̎s0xffffffff
LibExport UINT createRestorePointA( const char *name )
{
	SR_SET_RESTORE_POINT pfSRSetRestorePoint = NULL;
	HMODULE          hDLL = NULL;
	RESTOREPOINTINFO RstPt;
	STATEMGRSTATUS   MgrStat;
	UINT             result = 0;

	// ϐ̏
	ZeroMemory( &RstPt, sizeof(RstPt) );
	ZeroMemory( &MgrStat, sizeof(MgrStat) );

	hDLL = ::LoadLibrary_System32("srclient.dll");
	if ( hDLL ) {
		pfSRSetRestorePoint = (SR_SET_RESTORE_POINT)::GetProcAddress(hDLL,"SRSetRestorePointA");
	}

	if ( pfSRSetRestorePoint ) {
		RstPt.dwEventType = BEGIN_SYSTEM_CHANGE;
		RstPt.dwRestorePtType = MODIFY_SETTINGS;
		lstrcpyn(RstPt.szDescription, name?name:"Restore Point", MAX_DESC-1);

		// |Cg̍쐬i1ڂ̌Ăяoj
		if ( pfSRSetRestorePoint(&RstPt, &MgrStat) ) {
			RstPt.dwEventType = END_SYSTEM_CHANGE;
			RstPt.llSequenceNumber = MgrStat.llSequenceNumber;

			// |Cg̍쐬i2ڂ̌Ăяoj- R~bg
			//  ł́APɕ|Cg邾Ȃ̂ŁAɊmo^Ƃ
			pfSRSetRestorePoint(&RstPt, &MgrStat);
		}

		// s̒ĺASRSetRestorePointSTATEMGRSTATUSnStatusɐݒ肷l
		// ̏ꍇ́A 0 ĂĂ
		result = MgrStat.nStatus;
	}
	else {
		// ̗̑Rł̎śA0xffffffff ԋp
		result = 0xffffffff;
	}

	if ( hDLL ) {
		FreeLibrary( hDLL );
	}

	// ӁF0ԋp܂
	return result;
}

LibExport UINT createRestorePointW( const wchar_t *name )
{
	SR_SET_RESTORE_POINTW pfSRSetRestorePoint = NULL;
	HMODULE          hDLL = NULL;
	RESTOREPOINTINFOW RstPt;
	STATEMGRSTATUS   MgrStat;
	UINT             result = 0;

	// ϐ̏
	ZeroMemory( &RstPt, sizeof(RstPt) );
	ZeroMemory( &MgrStat, sizeof(MgrStat) );

	{ // Windows XP
		hDLL = ::LoadLibrary_System32W(L"srclient.dll");
		if ( hDLL ) {
			pfSRSetRestorePoint = (SR_SET_RESTORE_POINTW)::GetProcAddress(hDLL,"SRSetRestorePointW");
		}
	}

	if ( pfSRSetRestorePoint ) {
		RstPt.dwEventType = BEGIN_SYSTEM_CHANGE;
		RstPt.dwRestorePtType = MODIFY_SETTINGS;
		lstrcpynW(RstPt.szDescription, name?name:L"Restore Point", MAX_DESC-1);

		// |Cg̍쐬i1ڂ̌Ăяoj
		if ( pfSRSetRestorePoint(&RstPt, &MgrStat) ) {
			RstPt.dwEventType = END_SYSTEM_CHANGE;
			RstPt.llSequenceNumber = MgrStat.llSequenceNumber;

			// |Cg̍쐬i2ڂ̌Ăяoj- R~bg
			//  ł́APɕ|Cg邾Ȃ̂ŁAɊmo^Ƃ
			pfSRSetRestorePoint(&RstPt, &MgrStat);
		}

		// s̒ĺASRSetRestorePointSTATEMGRSTATUSnStatusɐݒ肷l
		// ̏ꍇ́A 0 ĂĂ
		result = MgrStat.nStatus;
	}
	else {
		// ̗̑Rł̎śA0xffffffff ԋp
		result = 0xffffffff;
	}

	if ( hDLL ) {
		FreeLibrary( hDLL );
	}

	// ӁF0ԋp܂
	return result;
}

LibExport int lvGetIconNumber( HWND hListView, int cur )
{
	LVITEM lvItem;

	ZeroMemory( &lvItem, sizeof(LVITEM) );
	lvItem.mask = LVIF_IMAGE;
	lvItem.iItem = cur;
	ListView_GetItem( hListView, &lvItem );

	return lvItem.iImage;
}

LibExport LPARAM lvGetLParam( HWND hListView, int cur )
{
	LVITEM lvItem;

	ZeroMemory( &lvItem, sizeof(LVITEM) );
	lvItem.mask = LVIF_PARAM;
	lvItem.iItem = cur;
	ListView_GetItem( hListView, &lvItem );

	return lvItem.lParam;
}

// t@Cw肵āAt@CTCY擾BAt@CTCY2GB܂ŁB
// t@C݂Ȃꍇ -1 Ԃ
LibExport DWORD getFileSizeA( const char *fname )
{
	HANDLE hFile;
	DWORD dwFileSizeLow = (DWORD)-1;

	hFile = CreateFile( fname, 0, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
		                OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( hFile ) {
		dwFileSizeLow = GetFileSize(hFile, NULL);
		CloseHandle(hFile);
	}
	return dwFileSizeLow;
}

LibExport DWORD getFileSizeW( const wchar_t *fname )
{
	HANDLE hFile;
	DWORD dwFileSizeLow = (DWORD)-1;

	hFile = CreateFileW( fname, 0, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
		                 OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( hFile ) {
		dwFileSizeLow = GetFileSize(hFile, NULL);
		CloseHandle(hFile);
	}
	return dwFileSizeLow;
}

// t@Cw肵āAt@CTCY擾BAt@CTCY̏QWORD.
// t@C݂Ȃꍇ -1 Ԃ
LibExport UINT64 getFileSizeQA( const char *fname )
{
	HANDLE hFile;
	DWORD dwFileSizeLow = (DWORD)-1, dwFileSizeHigh = (DWORD)-1;

	hFile = CreateFile( fname, 0, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
		                OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( hFile ) {
		dwFileSizeLow = GetFileSize(hFile, &dwFileSizeHigh);
		if ( dwFileSizeLow == -1 ) {
			if ( GetLastError() != NO_ERROR ) {
				CloseHandle(hFile);
				return (UINT64)-1;
			}
		}
		CloseHandle(hFile);
	}
	return (UINT64)0x100000000 * (UINT64)dwFileSizeHigh + (UINT64)dwFileSizeLow;
}
LibExport UINT64 getFileSizeQW( const wchar_t *fname )
{
	HANDLE hFile;
	DWORD dwFileSizeLow = (DWORD)-1, dwFileSizeHigh = (DWORD)-1;

	hFile = CreateFileW( fname, 0, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
		                 OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( hFile ) {
		dwFileSizeLow = GetFileSize(hFile, &dwFileSizeHigh);
		if ( dwFileSizeLow == -1 ) {
			if ( GetLastError() != NO_ERROR ) {
				CloseHandle(hFile);
				return (UINT64)-1;
			}
		}
		CloseHandle(hFile);
	}
	return (UINT64)0x100000000 * (UINT64)dwFileSizeHigh + (UINT64)dwFileSizeLow;
}

// Windows̃o[WA~100+ŕԂ
LibExport WORD tf_getWinVer( void )
{
	OSVERSIONINFO verinfo;

	verinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx( &verinfo );

	if ( verinfo.dwPlatformId != VER_PLATFORM_WIN32_NT ) {
		if (HIWORD(verinfo.dwBuildNumber)) {
			verinfo.dwMajorVersion = (DWORD)(HIWORD(verinfo.dwBuildNumber) >> 8);
			verinfo.dwMinorVersion = (DWORD)(HIWORD(verinfo.dwBuildNumber) & 0xff);
		}
		else { // Windows XPɂWindows 95ɋUĂ
			verinfo.dwMajorVersion = 4;
			verinfo.dwMinorVersion = 0;
		}
	}

	return (WORD)(verinfo.dwMajorVersion*100 + verinfo.dwMinorVersion);
}

// Windows̃vbgtH[IDԂ
// NTn̖邩Ȃ̂ŁAVER_PLATFORM_WIN32_NTԂ悤ȂƂ͂Ȃ
LibExport DWORD tf_GetPlatform( void )
{
	OSVERSIONINFO verinfo;

	verinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx( &verinfo );

	return verinfo.dwPlatformId;
}

#if _MSC_VER < 1500
#ifndef _WIN64
// WindowsNTnł΁ATRUEԂ
LibExport BOOL tf_isNT( void )
{
	return (tf_GetPlatform() == VER_PLATFORM_WIN32_NT)?TRUE:FALSE;
}
#endif /* _WIN64 */
#endif // _MSC_VER < 1500
// ݂ł̓}N`ŁuɂPvƂȂi{o[WWinXPȍ~̓łAKNTnƂȂ̂Łj

// dir + file sAdir Ɋi[(t@C_uR[e[Vň͂܂Ȃ)
LibExport char *dir_add_fileA( char *dir, const char *fname )
{
	if ( dir && fname ) {
		// diȑI肪\ŏIĂꍇ́A\ǉȂ
		dir_add_bsA(dir);
		lstrcat(dir, fname);
	}
	return dir;
}

LibExport wchar_t *dir_add_fileW( wchar_t *dir, const wchar_t *fname )
{
	if ( dir && fname ) {
		// diȑI肪\ŏIĂꍇ́A\ǉȂ
		dir_add_bsW(dir);
		lstrcatW(dir, fname);
	}
	return dir;
}

// dir ̌ \ tĂȂꍇ \ t(t@C_uR[e[Vň͂܂Ȃ)
LibExport char *dir_add_bsA( char *dir )
{
	if ( dir ) {
		// diȑI肪\ŏIĂꍇ́A\ǉȂ
		int iLen = lstrlen( dir );
		if ( !(iLen > 0 && dir[iLen-1] == '\\' && !isKanji1A(dir, iLen-2)) ) {
			lstrcat(dir, "\\");
		}
		return dir;
	}
	return NULL;
}

LibExport wchar_t *dir_add_bsW( wchar_t *dir )
{
	if ( dir ) {
		// diȑI肪\ŏIĂꍇ́A\ǉȂ
		int iLen = lstrlenW( dir );
		if ( !(iLen > 0 && dir[iLen-1] == L'\\') ) {
			lstrcatW(dir, L"\\");
		}
		return dir;
	}
	return NULL;
}

// }`oCg烏ChLN^ւ̕ϊB(gpfreeŊJ邱)
LibExport wchar_t *mb2wc( const char *mbstr )
{
	wchar_t *wcstr = NULL;

	if ( mbstr ) {
		int i = MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, mbstr, -1, NULL, 0);
		if ( i != 0 ) {
			++i;
			wcstr = walloc(i);
			if ( wcstr ) {
				if ( 0 == MultiByteToWideChar(GetACP(), MB_PRECOMPOSED, mbstr, -1, wcstr, i) ) {
					free( wcstr );
					return NULL;
				}
			}
		}
	}
	return wcstr;
}

// ChLN^}`oCgւ̕ϊB(gpfreeŊJ邱)
LibExport char *wc2mb( const wchar_t *wcstr )
{
	char *mbstr = NULL;

	if ( wcstr ) {
		int i = WideCharToMultiByte(GetACP(), 0, wcstr, -1, NULL, 0, NULL, NULL);
		if ( i != 0 ) {
			++i;
			mbstr = zalloc(i);
			if ( mbstr ) {
				if ( 0 == WideCharToMultiByte(GetACP(), 0, wcstr, -1, mbstr, i, NULL, NULL) ) {
					free( mbstr );
					return NULL;
				}
			}
		}
	}
	return mbstr;
}


// -------------------------------- MD5Zo --------------------------------
// L\[XR[h́AIWi MD5  C\[XR[hQlɍ
// ܂B
/* Data structure for MD5 (Message Digest) computation */
typedef struct {
  ULONG i[2];                   /* number of _bits_ handled mod 2^64 */
  ULONG buf[4];                                    /* scratch buffer */
  unsigned char in[64];                              /* input buffer */
  unsigned char digest[16];     /* actual digest after MD5Final call */
} MD5_CTX;

void MD5Init( MD5_CTX *mdContext );
void MD5Update( MD5_CTX *mdContext, unsigned char *inBuf, unsigned int inLen );
void MD5Final( MD5_CTX *mdContext );
static void Transform( ULONG *buf, ULONG *in );

static unsigned char PADDING[64] = {
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* F, G and H are basic MD5 functions: selection, majority, parity */
#define F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z))) 

/* ROTATE_LEFT rotates x left n bits */
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4 */
/* Rotation is separate from addition to prevent recomputation */
#define FF(a, b, c, d, x, s, ac) \
  {(a) += F ((b), (c), (d)) + (x) + (ULONG)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define GG(a, b, c, d, x, s, ac) \
  {(a) += G ((b), (c), (d)) + (x) + (ULONG)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define HH(a, b, c, d, x, s, ac) \
  {(a) += H ((b), (c), (d)) + (x) + (ULONG)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define II(a, b, c, d, x, s, ac) \
  {(a) += I ((b), (c), (d)) + (x) + (ULONG)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }

void MD5Init( MD5_CTX *mdContext )
{
  mdContext->i[0] = mdContext->i[1] = (ULONG)0;

  /* Load magic initialization constants.
   */
  mdContext->buf[0] = (ULONG)0x67452301;
  mdContext->buf[1] = (ULONG)0xefcdab89;
  mdContext->buf[2] = (ULONG)0x98badcfe;
  mdContext->buf[3] = (ULONG)0x10325476;
}

void MD5Update( MD5_CTX *mdContext, unsigned char *inBuf, unsigned int inLen )
{
  ULONG in[16];
  int mdi;
  unsigned int i, ii;

  /* compute number of bytes mod 64 */
  mdi = (int)((mdContext->i[0] >> 3) & 0x3F);

  /* update number of bits */
  if ((mdContext->i[0] + ((ULONG)inLen << 3)) < mdContext->i[0])
    mdContext->i[1]++;
  mdContext->i[0] += ((ULONG)inLen << 3);
  mdContext->i[1] += ((ULONG)inLen >> 29);

  while (inLen--) {
    /* add new character to buffer, increment mdi */
    mdContext->in[mdi++] = *inBuf++;

    /* transform if necessary */
    if (mdi == 0x40) {
      for (i = 0, ii = 0; i < 16; i++, ii += 4)
        in[i] = (((ULONG)mdContext->in[ii+3]) << 24) |
                (((ULONG)mdContext->in[ii+2]) << 16) |
                (((ULONG)mdContext->in[ii+1]) << 8) |
                ((ULONG)mdContext->in[ii]);
      Transform (mdContext->buf, in);
      mdi = 0;
    }
  }
}

void MD5Final( MD5_CTX *mdContext )
{
  ULONG in[16];
  int mdi;
  unsigned int i, ii;
  unsigned int padLen;

  /* save number of bits */
  in[14] = mdContext->i[0];
  in[15] = mdContext->i[1];

  /* compute number of bytes mod 64 */
  mdi = (int)((mdContext->i[0] >> 3) & 0x3F);

  /* pad out to 56 mod 64 */
  padLen = (mdi < 56) ? (56 - mdi) : (120 - mdi);
  MD5Update (mdContext, PADDING, padLen);

  /* append length in bits and transform */
  for (i = 0, ii = 0; i < 14; i++, ii += 4)
    in[i] = (((ULONG)mdContext->in[ii+3]) << 24) |
            (((ULONG)mdContext->in[ii+2]) << 16) |
            (((ULONG)mdContext->in[ii+1]) << 8) |
            ((ULONG)mdContext->in[ii]);
  Transform (mdContext->buf, in);

  /* store buffer in digest */
  for (i = 0, ii = 0; i < 4; i++, ii += 4) {
    mdContext->digest[ii] = (unsigned char)(mdContext->buf[i] & 0xFF);
    mdContext->digest[ii+1] =
      (unsigned char)((mdContext->buf[i] >> 8) & 0xFF);
    mdContext->digest[ii+2] =
      (unsigned char)((mdContext->buf[i] >> 16) & 0xFF);
    mdContext->digest[ii+3] =
      (unsigned char)((mdContext->buf[i] >> 24) & 0xFF);
  }
}

/* Basic MD5 step. Transform buf based on in.
 */
static void Transform( ULONG *buf, ULONG *in )
{
  ULONG a = buf[0], b = buf[1], c = buf[2], d = buf[3];

  /* Round 1 */
#define S11 7
#define S12 12
#define S13 17
#define S14 22
  FF ( a, b, c, d, in[ 0], S11, 3614090360); /* 1 */
  FF ( d, a, b, c, in[ 1], S12, 3905402710); /* 2 */
  FF ( c, d, a, b, in[ 2], S13,  606105819); /* 3 */
  FF ( b, c, d, a, in[ 3], S14, 3250441966); /* 4 */
  FF ( a, b, c, d, in[ 4], S11, 4118548399); /* 5 */
  FF ( d, a, b, c, in[ 5], S12, 1200080426); /* 6 */
  FF ( c, d, a, b, in[ 6], S13, 2821735955); /* 7 */
  FF ( b, c, d, a, in[ 7], S14, 4249261313); /* 8 */
  FF ( a, b, c, d, in[ 8], S11, 1770035416); /* 9 */
  FF ( d, a, b, c, in[ 9], S12, 2336552879); /* 10 */
  FF ( c, d, a, b, in[10], S13, 4294925233); /* 11 */
  FF ( b, c, d, a, in[11], S14, 2304563134); /* 12 */
  FF ( a, b, c, d, in[12], S11, 1804603682); /* 13 */
  FF ( d, a, b, c, in[13], S12, 4254626195); /* 14 */
  FF ( c, d, a, b, in[14], S13, 2792965006); /* 15 */
  FF ( b, c, d, a, in[15], S14, 1236535329); /* 16 */

  /* Round 2 */
#define S21 5
#define S22 9
#define S23 14
#define S24 20
  GG ( a, b, c, d, in[ 1], S21, 4129170786); /* 17 */
  GG ( d, a, b, c, in[ 6], S22, 3225465664); /* 18 */
  GG ( c, d, a, b, in[11], S23,  643717713); /* 19 */
  GG ( b, c, d, a, in[ 0], S24, 3921069994); /* 20 */
  GG ( a, b, c, d, in[ 5], S21, 3593408605); /* 21 */
  GG ( d, a, b, c, in[10], S22,   38016083); /* 22 */
  GG ( c, d, a, b, in[15], S23, 3634488961); /* 23 */
  GG ( b, c, d, a, in[ 4], S24, 3889429448); /* 24 */
  GG ( a, b, c, d, in[ 9], S21,  568446438); /* 25 */
  GG ( d, a, b, c, in[14], S22, 3275163606); /* 26 */
  GG ( c, d, a, b, in[ 3], S23, 4107603335); /* 27 */
  GG ( b, c, d, a, in[ 8], S24, 1163531501); /* 28 */
  GG ( a, b, c, d, in[13], S21, 2850285829); /* 29 */
  GG ( d, a, b, c, in[ 2], S22, 4243563512); /* 30 */
  GG ( c, d, a, b, in[ 7], S23, 1735328473); /* 31 */
  GG ( b, c, d, a, in[12], S24, 2368359562); /* 32 */

  /* Round 3 */
#define S31 4
#define S32 11
#define S33 16
#define S34 23
  HH ( a, b, c, d, in[ 5], S31, 4294588738); /* 33 */
  HH ( d, a, b, c, in[ 8], S32, 2272392833); /* 34 */
  HH ( c, d, a, b, in[11], S33, 1839030562); /* 35 */
  HH ( b, c, d, a, in[14], S34, 4259657740); /* 36 */
  HH ( a, b, c, d, in[ 1], S31, 2763975236); /* 37 */
  HH ( d, a, b, c, in[ 4], S32, 1272893353); /* 38 */
  HH ( c, d, a, b, in[ 7], S33, 4139469664); /* 39 */
  HH ( b, c, d, a, in[10], S34, 3200236656); /* 40 */
  HH ( a, b, c, d, in[13], S31,  681279174); /* 41 */
  HH ( d, a, b, c, in[ 0], S32, 3936430074); /* 42 */
  HH ( c, d, a, b, in[ 3], S33, 3572445317); /* 43 */
  HH ( b, c, d, a, in[ 6], S34,   76029189); /* 44 */
  HH ( a, b, c, d, in[ 9], S31, 3654602809); /* 45 */
  HH ( d, a, b, c, in[12], S32, 3873151461); /* 46 */
  HH ( c, d, a, b, in[15], S33,  530742520); /* 47 */
  HH ( b, c, d, a, in[ 2], S34, 3299628645); /* 48 */

  /* Round 4 */
#define S41 6
#define S42 10
#define S43 15
#define S44 21
  II ( a, b, c, d, in[ 0], S41, 4096336452); /* 49 */
  II ( d, a, b, c, in[ 7], S42, 1126891415); /* 50 */
  II ( c, d, a, b, in[14], S43, 2878612391); /* 51 */
  II ( b, c, d, a, in[ 5], S44, 4237533241); /* 52 */
  II ( a, b, c, d, in[12], S41, 1700485571); /* 53 */
  II ( d, a, b, c, in[ 3], S42, 2399980690); /* 54 */
  II ( c, d, a, b, in[10], S43, 4293915773); /* 55 */
  II ( b, c, d, a, in[ 1], S44, 2240044497); /* 56 */
  II ( a, b, c, d, in[ 8], S41, 1873313359); /* 57 */
  II ( d, a, b, c, in[15], S42, 4264355552); /* 58 */
  II ( c, d, a, b, in[ 6], S43, 2734768916); /* 59 */
  II ( b, c, d, a, in[13], S44, 1309151649); /* 60 */
  II ( a, b, c, d, in[ 4], S41, 4149444226); /* 61 */
  II ( d, a, b, c, in[11], S42, 3174756917); /* 62 */
  II ( c, d, a, b, in[ 2], S43,  718787259); /* 63 */
  II ( b, c, d, a, in[ 9], S44, 3951481745); /* 64 */

  buf[0] += a;
  buf[1] += b;
  buf[2] += c;
  buf[3] += d;
}
// -------------------------------- MD5Zo[END] --------------------------------

// ̃f[^MD5Zo
// data  : f[^̊i[ꂽ̐擪AhX
// datalength : data̒ioCgPʁj
// md5   : char [33] ^zBMD5̎Zoʂ𕶎ɂĊi[
// ߂l: =1As=0ismd5̎wAhX̒̃f[^͕ςȂj
LibExport BOOL md5dataA( const void *data, int datalength, char *md5 )
{
	MD5_CTX mdContext;

	if ( !data || !datalength || !md5 ) {
		return FALSE;
	}

	MD5Init( &mdContext );
	MD5Update(&mdContext, (unsigned char *)data, datalength);
	MD5Final( &mdContext );

	wsprintf(md5, "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
		mdContext.digest[0],
		mdContext.digest[1],
		mdContext.digest[2],
		mdContext.digest[3],
		mdContext.digest[4],
		mdContext.digest[5],
		mdContext.digest[6],
		mdContext.digest[7],
		mdContext.digest[8],
		mdContext.digest[9],
		mdContext.digest[10],
		mdContext.digest[11],
		mdContext.digest[12],
		mdContext.digest[13],
		mdContext.digest[14],
		mdContext.digest[15]);

	return true;
}

LibExport BOOL md5dataW( const void *data, int datalength, wchar_t *md5 )
{
	MD5_CTX mdContext;

	if ( !data || !datalength || !md5 ) {
		return FALSE;
	}

	MD5Init( &mdContext );
	MD5Update(&mdContext, (unsigned char *)data, datalength);
	MD5Final( &mdContext );

	wsprintfW(md5, L"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
		mdContext.digest[0],
		mdContext.digest[1],
		mdContext.digest[2],
		mdContext.digest[3],
		mdContext.digest[4],
		mdContext.digest[5],
		mdContext.digest[6],
		mdContext.digest[7],
		mdContext.digest[8],
		mdContext.digest[9],
		mdContext.digest[10],
		mdContext.digest[11],
		mdContext.digest[12],
		mdContext.digest[13],
		mdContext.digest[14],
		mdContext.digest[15]);

	return true;
}

// t@CMD5Zo
// fname : t@C
// md5   : char [33] ^zBMD5̎Zoʂ𕶎ɂĊi[
// ߂l: =1As=0ismd5̎wAhX̒̃f[^͕ςȂj
LibExport BOOL md5fileA( const char *fname, char *md5, md5file_callback cbfunc )
{
	FILE *fp;
	MD5_CTX mdContext;
	unsigned int bytes;
	unsigned char data[1024];

	if ( !fname || !md5 ) {
		return FALSE;
	}

	if ( 0 != fopen_s(&fp, fname, "rb") ) {
		return FALSE;
	}

	fseek(fp, 0, SEEK_END);
	long fsize = ftell(fp);
	fseek(fp, 0, SEEK_SET);

	MD5Init( &mdContext );
	while ((bytes = (unsigned int)fread(data, 1, 1024, fp)) != 0) {
		MD5Update(&mdContext, data, bytes);
		if (cbfunc) {
			if (FALSE == cbfunc(ftell(fp), fsize)) {
				fclose(fp);
				return FALSE;
			}
		}
	}

	MD5Final( &mdContext );
	fclose(fp);

	wsprintf(md5, "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
		mdContext.digest[0],
		mdContext.digest[1],
		mdContext.digest[2],
		mdContext.digest[3],
		mdContext.digest[4],
		mdContext.digest[5],
		mdContext.digest[6],
		mdContext.digest[7],
		mdContext.digest[8],
		mdContext.digest[9],
		mdContext.digest[10],
		mdContext.digest[11],
		mdContext.digest[12],
		mdContext.digest[13],
		mdContext.digest[14],
		mdContext.digest[15]);

	return TRUE;
}

LibExport BOOL md5fileW( const wchar_t *fname, wchar_t *md5, md5file_callback cbfunc )
{
	FILE *fp;
	MD5_CTX mdContext;
	unsigned int bytes;
	unsigned char data[1024];

	if ( !fname || !md5 ) {
		return FALSE;
	}

	if ( 0 != _wfopen_s(&fp, fname, L"rb") ) {
		return FALSE;
	}

	fseek(fp, 0, SEEK_END);
	long fsize = ftell(fp);
	fseek(fp, 0, SEEK_SET);

	MD5Init( &mdContext );
	while ((bytes = (unsigned int)fread(data, 1, 1024, fp)) != 0) {
		MD5Update(&mdContext, data, bytes);
		if (cbfunc) {
			if (FALSE == cbfunc(ftell(fp), fsize)) {
				fclose(fp);
				return FALSE;
			}
		}
	}

	MD5Final( &mdContext );
	fclose(fp);

	wsprintfW(md5, L"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
		mdContext.digest[0],
		mdContext.digest[1],
		mdContext.digest[2],
		mdContext.digest[3],
		mdContext.digest[4],
		mdContext.digest[5],
		mdContext.digest[6],
		mdContext.digest[7],
		mdContext.digest[8],
		mdContext.digest[9],
		mdContext.digest[10],
		mdContext.digest[11],
		mdContext.digest[12],
		mdContext.digest[13],
		mdContext.digest[14],
		mdContext.digest[15]);

	return TRUE;
}

// MD5l擾EriArMD5'x'32ȂrȂ
// fname    : `FbNΏۂ̃t@C(NULL̂Ƃ́AvOgp)
// root     : ŏINL^邽߂̃WXg̃nCu
// regkey   : ŏINL^邽߂̃WXg̃L[
// lasttime : O񐳏NԂ32oCgȏ̃GA(NULL̂Ƃ͖)
//   ȂAroot == NULL ̏ꍇ́Aregkey t@CƌȂāA֋L^B
//   regkey == NULL ̎́AL^sȂB
// ߂l = 0 : MD5svA 1 : MD5vA 2 : A 3 : vO擾s
int md5FileCheckA( const char *fname, HKEY root, const char *regkey, char *lasttime )
{
	// σ`FbNp
	const static char sz_exe_md5[16+32+2] = "XX_SZ_EXE_MD5_XXxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
	const char *exename;
	char ownname[MAX_PATH*2];
	char datetime[32];
	UINT a, b;
	int  rc = 2;
	HKEY  hkey;

	// OŏINǂݏo
	if ( regkey && lasttime ) {
		HKEY  hkey;

		if ( root ) {
			if ( ERROR_SUCCESS == RegOpenKeyEx(root, regkey, NULL, KEY_QUERY_VALUE, &hkey ) ) {
				DWORD dwSize = 32 * sizeof(char);

				RegQueryValueEx(hkey, "LastNormalBoot", NULL, NULL, (LPBYTE)lasttime, &dwSize);
				RegCloseKey( hkey );
			}
		}
		else {
            GetPrivateProfileString( "MD5Check", "LastNormalBoot", "None", lasttime, 32, regkey );
		}
	}

	// ǂ̃t@CgH
	if ( fname ) {
		exename = fname;
	}
	else {	// NULL̂Ƃ́AvOgp
		// st@C̎擾
		if ( !GetModuleFileName(NULL, ownname, _countof(ownname)) ) {
			return 3;
		}
		exename = ownname;
    }
	
	for(b=0,a=0 ; a<32 ; ++a) {
		if ( sz_exe_md5[16+a] != 'x' ) {
			b = 1;
			break;
		}
	}

	if ( b == 1 ) {
		char md5[33] = "error";
		unsigned char *fdata;
		FILE *fp;

		if ( 0 == fopen_s(&fp, exename, "rb") ) {
			fseek(fp, 0, SEEK_END);
			long fsize = ftell(fp);
			fseek(fp, 0, SEEK_SET);

			// m
			fdata = (unsigned char *)zalloc(fsize);
			if ( fdata ) {
				// t@Cǂ݂
				fread(fdata, fsize, 1, fp);
				// XX_SZ_EXE_MD5_XX 32̃oCgxŖ߂ĂMD5̎擾
				for(a=0 ; a<(UINT)(fsize/sizeof(char))-16 ; ++a) {
                    if ( fdata[a   ] == (unsigned char)sz_exe_md5[0] &&
						 fdata[a+ 1] == (unsigned char)sz_exe_md5[1] &&
						 fdata[a+ 2] == (unsigned char)sz_exe_md5[2] &&
						 fdata[a+ 3] == (unsigned char)sz_exe_md5[3] &&
						 fdata[a+ 4] == (unsigned char)sz_exe_md5[4] &&
						 fdata[a+ 5] == (unsigned char)sz_exe_md5[5] &&
						 fdata[a+ 6] == (unsigned char)sz_exe_md5[6] &&
						 fdata[a+ 7] == (unsigned char)sz_exe_md5[7] &&
						 fdata[a+ 8] == (unsigned char)sz_exe_md5[8] &&
						 fdata[a+ 9] == (unsigned char)sz_exe_md5[9] &&
						 fdata[a+10] == (unsigned char)sz_exe_md5[10] &&
						 fdata[a+11] == (unsigned char)sz_exe_md5[11] &&
						 fdata[a+12] == (unsigned char)sz_exe_md5[12] &&
						 fdata[a+13] == (unsigned char)sz_exe_md5[13] &&
						 fdata[a+14] == (unsigned char)sz_exe_md5[14] &&
						 fdata[a+15] == (unsigned char)sz_exe_md5[15] ) {

						for(b=0 ; b<32 ; ++b) {
                            fdata[a+16+b] = 'x';
						}

						if ( md5dataA(fdata, fsize, md5) ) {
							if ( lstrcmpi(md5, &sz_exe_md5[16]) != 0 ) {
								// MD5sv
								rc = 0;
							}
							else {
								// MD5v
                                rc = 1;

								// ݓL^
								if ( regkey ) {
									SYSTEMTIME st;

									GetLocalTime(&st);
									wsprintf(datetime, "%5d/%2d/%2d %2d:%02d:%02d",
										st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond );
									if ( root ) {
										if ( ERROR_SUCCESS == RegOpenKeyEx(root, regkey, NULL, KEY_WRITE, &hkey ) ) {
											RegSetValueEx(hkey, "LastNormalBoot", NULL, REG_SZ, (LPBYTE)datetime, sizeof(char)*(lstrlen(datetime)+1));
											RegCloseKey( hkey );
										}
									}
									else {
                                        WritePrivateProfileString( "MD5Check", "LastNormalBoot", datetime, regkey );
									}
								}
							}
						}
						break;
					}
				}
				safefree(fdata);
			}
			fclose(fp);
		}
	}

	return rc;
}

int md5FileCheckW( const wchar_t *fname, HKEY root, const wchar_t *regkey, wchar_t *lasttime )
{
	// σ`FbNp
	const static wchar_t sz_exe_md5[16+32+2] = L"XX_SZ_EXE_MD5_XXxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
	const wchar_t *exename;
	wchar_t ownname[MAX_PATH];
	wchar_t datetime[32];
	UINT a, b;
	int  rc = 2;
	HKEY  hkey;

	// OŏINǂݏo
	if ( regkey && lasttime ) {
		HKEY  hkey;

		if ( root ) {
			if ( ERROR_SUCCESS == RegOpenKeyExW(root, regkey, NULL, KEY_QUERY_VALUE, &hkey ) ) {
				DWORD dwSize = 32 * sizeof(wchar_t);

				RegQueryValueExW(hkey, L"LastNormalBoot", NULL, NULL, (LPBYTE)lasttime, &dwSize);
				RegCloseKey( hkey );
			}
		}
		else {
            GetPrivateProfileStringW( L"MD5Check", L"LastNormalBoot", L"None", lasttime, 32, regkey );
		}
	}

	// ǂ̃t@CgH
	if ( fname ) {
		exename = fname;
	}
	else {	// NULL̂Ƃ́AvOgp
		// st@C̎擾
		if ( !GetModuleFileNameW(NULL, ownname, _countof(ownname)) ) {
			return 3;
		}
		exename = ownname;
    }
	
	for(b=0,a=0 ; a<32 ; ++a) {
		if ( sz_exe_md5[16+a] != L'x' ) {
			b = 1;
			break;
		}
	}

	if ( b == 1 ) {
		wchar_t md5[33] = L"error";
		wchar_t *fdata;
		FILE *fp;

		if ( 0 == _wfopen_s(&fp, exename, L"rb") ) {
			fseek(fp, 0, SEEK_END);
			long fsize = ftell(fp);
			fseek(fp, 0, SEEK_SET);

			// m
			fdata = (wchar_t *)walloc(fsize);
			if ( fdata ) {
				// t@Cǂ݂
				fread(fdata, fsize, 1, fp);
				// XX_SZ_EXE_MD5_XX 32̃oCgxŖ߂ĂMD5̎擾
				for(a=0 ; a<(UINT)(fsize/sizeof(wchar_t))-16 ; ++a) {
                    if ( fdata[a   ] == (wchar_t)sz_exe_md5[0] &&
						 fdata[a+ 1] == (wchar_t)sz_exe_md5[1] &&
						 fdata[a+ 2] == (wchar_t)sz_exe_md5[2] &&
						 fdata[a+ 3] == (wchar_t)sz_exe_md5[3] &&
						 fdata[a+ 4] == (wchar_t)sz_exe_md5[4] &&
						 fdata[a+ 5] == (wchar_t)sz_exe_md5[5] &&
						 fdata[a+ 6] == (wchar_t)sz_exe_md5[6] &&
						 fdata[a+ 7] == (wchar_t)sz_exe_md5[7] &&
						 fdata[a+ 8] == (wchar_t)sz_exe_md5[8] &&
						 fdata[a+ 9] == (wchar_t)sz_exe_md5[9] &&
						 fdata[a+10] == (wchar_t)sz_exe_md5[10] &&
						 fdata[a+11] == (wchar_t)sz_exe_md5[11] &&
						 fdata[a+12] == (wchar_t)sz_exe_md5[12] &&
						 fdata[a+13] == (wchar_t)sz_exe_md5[13] &&
						 fdata[a+14] == (wchar_t)sz_exe_md5[14] &&
						 fdata[a+15] == (wchar_t)sz_exe_md5[15] ) {

						for(b=0 ; b<32 ; ++b) {
                            fdata[a+16+b] = L'x';
						}

						if ( md5dataW(fdata, fsize, md5) ) {
							if ( lstrcmpiW(md5, &sz_exe_md5[16]) != 0 ) {
								// MD5sv
								rc = 0;
							}
							else {
								// MD5v
                                rc = 1;

								// ݓL^
								if ( regkey ) {
									SYSTEMTIME st;

									GetLocalTime(&st);
									wsprintfW(datetime, L"%5d/%2d/%2d %2d:%02d:%02d",
										st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond );
									if ( root ) {
										if ( ERROR_SUCCESS == RegOpenKeyExW(root, regkey, NULL, KEY_WRITE, &hkey ) ) {
											RegSetValueExW(hkey, L"LastNormalBoot", NULL, REG_SZ, (LPBYTE)datetime, sizeof(wchar_t)*(lstrlenW(datetime)+1));
											RegCloseKey( hkey );
										}
									}
									else {
                                        WritePrivateProfileStringW( L"MD5Check", L"LastNormalBoot", datetime, regkey );
									}
								}
							}
						}
						break;
					}
				}
				safefree(fdata);
			}
			fclose(fp);
		}
	}

	return rc;
}

// WOW6432bitvZXƂĎsĂꍇATRUEԂBłȂꍇFALSEԂB
BOOL tf_IsWow64Process()
{
#ifndef _WIN64
	return tf_IsWow64ProcessHandle(GetCurrentProcess());
#else  // _WIN64
	return FALSE; // ݂̃vZXx64Ȃ΁AWOW64zœƂ͗L蓾Ȃ
#endif // _WIN64
}

// w肳ꂽvZXWOW6432bitvZXƂĎsĂꍇATRUEԂBłȂꍇFALSEԂB
BOOL tf_IsWow64ProcessHandle(HANDLE hProcess)
{
	typedef BOOL (WINAPI *LPFN_ISWOW64PROCESS) (HANDLE hProcess, PBOOL Wow64Process);
	LPFN_ISWOW64PROCESS fnIsWow64Process = (LPFN_ISWOW64PROCESS)GetProcAddress(GetModuleHandle("kernel32"), "IsWow64Process");
 
	if (NULL != fnIsWow64Process) {
		BOOL bIsWow64 = FALSE;

		if (fnIsWow64Process(hProcess, &bIsWow64)) {
			return bIsWow64;
		}
	}

	return FALSE;
}


// ݂̃XbhɂAWOW64ɂt@C_CNV(System32SysWOW64)𖳌B0ȊO̒lԂB
// ɂ́Ã݂_CNg邩ǂ̏Ԃ邽߂̕ϐւ̃|C^w肷B
BOOL tf_Wow64DisableWow64FsRedirection(PVOID *pOldValue)
{
	typedef BOOL (WINAPI *LPFN_WOW64DISABLEWOW64FSREDIRECTION) (PVOID*);
	LPFN_WOW64DISABLEWOW64FSREDIRECTION fnWow64DisableWow64FsRedirection =
		(LPFN_WOW64DISABLEWOW64FSREDIRECTION)GetProcAddress(GetModuleHandle("kernel32"), "Wow64DisableWow64FsRedirection");
 
	if (NULL != fnWow64DisableWow64FsRedirection) {
		return fnWow64DisableWow64FsRedirection(pOldValue);
	}

	return FALSE;
}

// ݂̃XbhɂAWOW64ɂt@C_CNV(System32SysWOW64)ȌԂɖ߂B0ȊO̒lԂB
// ɂ́Ã݂_CNg邩ǂ̏Ԃ邽߂̕ϐw肷B́AWow64DisableWow64FsRedirection
// ֓ꂽƂɓꂽlƂȂB܂AWow64DisableWow64FsRedirectionȌԂɕAƂƂɂȂB
BOOL tf_Wow64RevertWow64FsRedirection(PVOID OldValue)
{
	typedef BOOL (WINAPI *LPFN_WOW64REVERTWOW64FSREDIRECTION) (PVOID);
	LPFN_WOW64REVERTWOW64FSREDIRECTION fnWow64RevertWow64FsRedirection =
		(LPFN_WOW64REVERTWOW64FSREDIRECTION)GetProcAddress(GetModuleHandle("kernel32"), "Wow64RevertWow64FsRedirection");
 
	if (NULL != fnWow64RevertWow64FsRedirection) {
		return fnWow64RevertWow64FsRedirection(OldValue);
	}

	return FALSE;
}

// JgfBNgWindowsSystem32tH_ɈڂĂDLLLoad
LibExport HMODULE LoadLibrary_System32W(const wchar_t* pwzFileName)
{
    static wchar_t wzSystem[MAX_PATH];
    wchar_t wzCurDir[MAX_PATH];
    HMODULE hMod = NULL;

    if(wzSystem[0] == L'\0') {
		if(GetSystemDirectoryW(wzSystem, _countof(wzSystem)) == 0) {
            return NULL; // ُI
		}
    }

    // ݂̃JgfBNgҔ
	if(GetCurrentDirectoryW(_countof(wzCurDir), wzCurDir) == 0) {
        wzCurDir[0] = L'\0';
	}

    SetCurrentDirectoryW(wzSystem);		// System32fBNgփJgfBNgړ
    hMod = LoadLibraryW(pwzFileName);		// SDLLǂݍ
    SetCurrentDirectoryW(wzCurDir);		// JgfBNgɖ߂

	return hMod;
}

LibExport HMODULE LoadLibrary_System32A(const char *pszFileName)
{
    static char szSystem[MAX_PATH*2];
    char szCurDir[MAX_PATH*2];
    HMODULE hMod = NULL;

    if(szSystem[0] == L'\0') {
		if(GetSystemDirectoryA(szSystem, _countof(szSystem)) == 0) {
            return NULL; // ُI
		}
    }

    // ݂̃JgfBNgҔ
	if(GetCurrentDirectoryA(_countof(szCurDir), szCurDir) == 0) {
        szCurDir[0] = L'\0';
	}

    SetCurrentDirectoryA(szSystem);		// System32fBNgփJgfBNgړ
    hMod = LoadLibraryA(pszFileName);		// SDLLǂݍ
    SetCurrentDirectoryA(szCurDir);		// JgfBNgɖ߂

	return hMod;
}

// ċAIɃtH_̃t@C폜[Unicode]
LibExport int emptyDirectoryW(LPCWSTR folder, FILETIME *bf_ft)
{
	HANDLE hFind;
	WIN32_FIND_DATAW wfd;
	int iResult = 1;
	wchar_t NowDir[MAX_PATH];

	// ݂̃JgfBNgҔAw肳ꂽfBNgփJgڂ
	if (0 == GetCurrentDirectoryW(_countof(NowDir), NowDir)) {
		return 0; // 1ȏ̎s
	}
	if (0 == SetCurrentDirectoryW(folder)) {
		return 0; // 1ȏ̎s
	}

	// t@CEtH_T[`
	hFind = FindFirstFileW(L"*.*", &wfd);
	if (hFind == INVALID_HANDLE_VALUE) {
		return 0; // 1ȏ̎s
	}
	do {
		if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			if (wfd.cFileName[0] == L'.') {
				// ȃfBNg͖
			}
			else {
				// ʏ̃fBNg̏ꍇ͍ċAďoɂ蒆̃t@Cׂč폜ĂAtH_폜
				if (0 == emptyDirectoryW(wfd.cFileName, bf_ft)) {
					iResult = 0; // 1ȏ̎s
				}
				else {
					// gɂȂ̂ŃtH_폜
					SetFileAttributesW(wfd.cFileName, FILE_ATTRIBUTE_NORMAL); // ܂͑̕ύX
					if (0 == RemoveDirectoryW(wfd.cFileName)){ // tH_폜
						iResult = 0; // tH_폜s
					}
				}
			}
		}
		else {
			// t@C폜 c tw肳ĂȂAtw肳Ăꍇ͂̓tߋA폜
			if (bf_ft == NULL || CompareFileTime(&(wfd.ftLastWriteTime), bf_ft) < 0) {
				SetFileAttributesW(wfd.cFileName, FILE_ATTRIBUTE_NORMAL); // ܂͑̕ύX
				if (0 == DeleteFileW(wfd.cFileName)) { // t@C폜
					iResult = 0; // 1ȏ̎s
				}
			}
		}
	} while(FindNextFileW(hFind, &wfd));

	FindClose(hFind);

	// JgfBNgɖ߂
	SetCurrentDirectoryW(NowDir);

	return iResult;
}

// ċAIɃtH_̃t@C폜[ANSI]
LibExport int emptyDirectoryA(LPCSTR folder, FILETIME *bf_ft)
{
	HANDLE hFind;
	WIN32_FIND_DATAA wfd;
	int iResult = 1;
	char NowDir[MAX_PATH];

	// ݂̃JgfBNgҔAw肳ꂽfBNgփJgڂ
	if (0 == GetCurrentDirectoryA(_countof(NowDir), NowDir)) {
		return 0; // 1ȏ̎s
	}
	if (0 == SetCurrentDirectoryA(folder)) {
		return 0; // 1ȏ̎s
	}

	// t@CEtH_T[`
	hFind = FindFirstFileA("*.*", &wfd);
	if (hFind == INVALID_HANDLE_VALUE) {
		return 0; // 1ȏ̎s
	}
	do {
		if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
			if (wfd.cFileName[0] == '.') {
				// ȃfBNg͖
			}
			else {
				// ʏ̃fBNg̏ꍇ͍ċAďoɂ蒆̃t@Cׂč폜ĂAtH_폜
				if (0 == emptyDirectoryA(wfd.cFileName, bf_ft)) {
					iResult = 0; // 1ȏ̎s
				}
				else {
					// gɂȂ̂ŃtH_폜
					SetFileAttributesA(wfd.cFileName, FILE_ATTRIBUTE_NORMAL); // ܂͑̕ύX
					if (0 == RemoveDirectoryA(wfd.cFileName)){ // tH_폜
						iResult = 0; // tH_폜s
					}
				}
			}
		}
		else {
			// t@C폜 c tw肳ĂȂAtw肳Ăꍇ͂̓tߋA폜
			if (bf_ft == NULL || CompareFileTime(&(wfd.ftLastWriteTime), bf_ft) < 0) {
				SetFileAttributesA(wfd.cFileName, FILE_ATTRIBUTE_NORMAL); // ܂͑̕ύX
				if (0 == DeleteFileA(wfd.cFileName)) { // t@C폜
					iResult = 0; // 1ȏ̎s
				}
			}
		}
	} while(FindNextFileA(hFind, &wfd));

	FindClose(hFind);

	// JgfBNgɖ߂
	SetCurrentDirectoryA(NowDir);

	return iResult;
}


// OSZipFolder@\𗘗pAw肵tH_itpXjցAzipt@CWJ
// Windows XPȍ~ŁAzipWJ@\Lł邱ƁBUnicodeŊ֐̂ݒ
// 炩 CoInitialize() Ă!!
// QƌTCgFEternalWindows ( http://eternalwindows.jp/installer/zip/zip01.html )

// 火 Visual Studio 2005ŃRpCɂ͒`sĂ̂ŒǉB
#if _MSC_VER < 1500
extern "C++"
{
    template<typename T> void** IID_PPV_ARGS_Helper(T** pp) 
    {
        static_cast<IUnknown*>(*pp);    // make sure everyone derives from IUnknown
        return reinterpret_cast<void**>(pp);
    }
}
#endif // _MSC_VER < 1500

#define IID_PPV_ARGS(ppType) __uuidof(**(ppType)), IID_PPV_ARGS_Helper(ppType)
// ܂Ł

// IShellDispatchɂzipt@C̓WJ
BOOL Unzip_fldr(IShellDispatch *pShellDispatch, LPWSTR lpszZipPath, LPWSTR lpszOutPath)
{
	HRESULT     hr;
	VARIANT     varOutDir, varZip, varItem, varOptions;
	Folder      *pOutFolder, *pZipFile;
	FolderItems *pZipFileItems;
	
	VariantInit(&varOutDir);
	varOutDir.vt = VT_BSTR;
	varOutDir.bstrVal = SysAllocString(lpszOutPath);
	hr = pShellDispatch->NameSpace(varOutDir, &pOutFolder);
	VariantClear(&varOutDir);
	if (hr != S_OK)
		return FALSE;

	VariantInit(&varZip);
	varZip.vt = VT_BSTR;
	varZip.bstrVal = SysAllocString(lpszZipPath);
	hr = pShellDispatch->NameSpace(varZip, &pZipFile);
	VariantClear(&varZip);
	if (hr != S_OK) {
		pOutFolder->Release();
		return FALSE;
	}

	hr = pZipFile->Items(&pZipFileItems);
	if (hr != S_OK) {
		pZipFile->Release();
		pOutFolder->Release();
		return FALSE;
	}

	VariantInit(&varItem);
	varItem.vt = VT_DISPATCH;
	varItem.pdispVal = pZipFileItems;
	VariantInit(&varOptions);
	varOptions.vt = VT_I4;
	varOptions.lVal = 4;
	hr = pOutFolder->CopyHere(varItem, varOptions);
	if (hr != S_OK) {
		pZipFileItems->Release();
		pZipFile->Release();
		pOutFolder->Release();
		return FALSE;
	}

	pZipFileItems->Release();
	pZipFile->Release();
	pOutFolder->Release();

	return TRUE;
}

// Windows XPȍ~OS@\𗘗pzipt@CWJ
//  zipfile : WJzipt@CBtpXŎw肷邱ƁB
//  outfolder : o͐tH_BtpXŎw肷邱ƁB
LibExport int Shell_UnZipW(LPWSTR zipfile, LPWSTR outfolder)
{
	HRESULT        hr;
	IShellDispatch *pShellDispatch;

	hr = CoCreateInstance(CLSID_Shell, NULL, CLSCTX_INPROC_SERVER, IID_PPV_ARGS(&pShellDispatch));
	if (FAILED(hr)) {
		// ďos
		return FALSE;
	}

	if (Unzip_fldr(pShellDispatch, zipfile, outfolder)) {
		// WJirŃLZꍇɂȂlqj
		return TRUE;
	}
	else {
		// WJs
		return FALSE;
	}
}

// ATML`FbNs
LibExport int checkAtmlA()
{
	int   rv = 0;

#if (ATML_ENABLED == 1)
	// ̃WXgL[݂ĂA`FbNNGƂ
	HKEY  hkey;
	if ( ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\TrendMicro", NULL, KEY_QUERY_VALUE, &hkey ) || 
		 ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE\\TrendMicro", NULL, KEY_QUERY_VALUE, &hkey ) || 
		 ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SOFTWARE\\Wow6432Node\\TrendMicro", NULL, KEY_QUERY_VALUE, &hkey ) ) {
		RegCloseKey( hkey );
		rv = 1; // `FbNNG
	}
#endif

	return rv;
}

LibExport int checkAtmlW()
{
	int   rv = 0;

#if (ATML_ENABLED == 1)
	// ̃WXgL[݂ĂA`FbNNGƂ
	HKEY  hkey;
	if ( ERROR_SUCCESS == RegOpenKeyExW(HKEY_CURRENT_USER, L"Software\\TrendMicro", NULL, KEY_QUERY_VALUE, &hkey ) || 
		 ERROR_SUCCESS == RegOpenKeyExW(HKEY_LOCAL_MACHINE, L"SOFTWARE\\TrendMicro", NULL, KEY_QUERY_VALUE, &hkey ) || 
		 ERROR_SUCCESS == RegOpenKeyExW(HKEY_LOCAL_MACHINE, L"SOFTWARE\\Wow6432Node\\TrendMicro", NULL, KEY_QUERY_VALUE, &hkey ) ) {
		RegCloseKey( hkey );
		rv = 1; // `FbNNG
	}
#endif

	return rv;
}
