/*
	opendlg.h
	t@CJAt@C̕ۑAtH_J_CAO
*/

#include "stdafx.h"
#include "Rnsf7.h"
#include "opendlg.h"
#include "filetypes.h"

// t@CJ_CAOJ
BOOL openDialog( HWND hWnd, const char *filetypes, char *filename, int maxfilename, const char *title, const char *defext )
{
	OPENFILENAME ofn;

	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFilter = filetypes;
	ofn.nFilterIndex = 1;
	ofn.lpstrCustomFilter = (LPSTR)NULL;
	ofn.nMaxCustFilter = 0L;
	ofn.lpstrFile = filename;
	ofn.nMaxFile = maxfilename;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = title;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = defext; 

	if ( GetOpenFileName(&ofn) )
		return TRUE;
	else {
		if ((DWORD)FNERR_INVALIDFILENAME == CommDlgExtendedError()) {
			filename[0] = 0;
			if ( GetOpenFileName(&ofn) )
				return TRUE;
		}
		filename[0] = 0;
		return FALSE;
	}
}

// t@Cۑ_CAOJ
BOOL saveDialog( HWND hWnd, const char *filetypes, char *filename, int maxfilename, const char *title, const char *defext )
{
	OPENFILENAME ofn;

	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFilter = filetypes;
	ofn.nFilterIndex = 1;
	ofn.lpstrCustomFilter = (LPSTR)NULL;
	ofn.nMaxCustFilter = 0L;
	ofn.lpstrFile = filename;
	ofn.nMaxFile = maxfilename;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = title;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_OVERWRITEPROMPT;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = defext; 

	if ( GetSaveFileName(&ofn) ) {
		return TRUE;
	}
	else {
		if ((DWORD)FNERR_INVALIDFILENAME == CommDlgExtendedError()) {
			filename[0] = 0;
			if ( GetSaveFileName(&ofn) )
				return TRUE;
		}
		filename[0] = 0;
		return FALSE;
	}
}

// tH_I_CAȌݒ^邽߂̃R[obN֐
int CALLBACK BrowseCallbackProc(HWND hDlg,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
    if(uMsg == BFFM_INITIALIZED){
        SendMessage(hDlg, BFFM_SETSELECTION, (WPARAM)TRUE, lpData);
    }
    return 0;
}

// tH_J_CAOJ
BOOL browseFolder( HWND hWnd, char *foldername, const char *info )
{
	BOOL         bRes;
	LPITEMIDLIST pidlRetFolder;
	BROWSEINFO   stBInfo;

	//@\̂܂B
	ZeroMemory(&stBInfo, sizeof(stBInfo));
	stBInfo.pidlRoot = NULL;	// [gtH_
	stBInfo.hwndOwner = hWnd;	// \_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = foldername;	// tH_擾obt@̃|C^
	stBInfo.lpszTitle = info;	// _CAO̒ɕ\镶
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;	//\tO
	if (foldername[0] == 0) {
		// tH_I_CAOɏݒȂ
		stBInfo.lpfn = NULL;
		stBInfo.lParam = 0L;
	}
	else {
		// tH_I_CAOɏݒ肠
		stBInfo.lpfn = BrowseCallbackProc;
		stBInfo.lParam = (LPARAM)foldername;
	}

	//@_CAO{bNX\܂B
	pidlRetFolder = SHBrowseForFolder( &stBInfo );

	if( pidlRetFolder != NULL ) {
		//@tpX擾܂B
		bRes = SHGetPathFromIDList( pidlRetFolder, foldername );
		if ( bRes == FALSE ) {
			foldername[0] = 0;
		}
		CoTaskMemFree( pidlRetFolder );	
		return bRes;
	}
	else {
		foldername[0] = 0;
		return FALSE;
	}
}
