/* -*-c-*-  KM-yacc parser model file (standard version) */

/* -p option renames following identifiers */

/* User declarations and token definitions */


#include "stdafx.h"
#include "interprete.h"
#include "token.h"
#include "symbol.h"
#include "function.h"
#include "addctrl.h"

#pragma warning(disable : 4102)
#pragma warning(disable : 4996)

static	char	*yaccReturnValue;	/* result output */
static	char	**bufs = NULL;
static	unsigned num_bufs = 0;
static	HWND	hSubDlg;

typedef union {
	unsigned dval;
	char    *text;
	struct ARGS *args;
} YYSTYPE;

#define YYERRTOK 256
#define EOL 257
#define NUMBER 258
#define STRING 259
#define NAME 260
#define NAME_D 261
#define IF 262
#define ELSE 263
#define GOTO 264
#define GOSUB 265
#define EXIT 266
#define ABORT 267
#define ARRAY 268
#define WHILE 269
#define RETURN 270
#define RESIZE 271
#define FOR 272
#define F0R 273
#define ANDAND 274
#define OROR 275
#define E_ADDOP 276
#define E_SUBOP 277
#define E_ANDOP 278
#define E_OROP 279
#define E_MULOP 280
#define E_DIVOP 281
#define E_MODOP 282
#define E_RSHIFT 283
#define E_LSHIFT 284
#define E_XOROP 285
#define ELARGE 286
#define ESMALL 287
#define EEQUAL 288
#define NEQUAL 289
#define EEEQUAL 290
#define NEEQUAL 291
#define INC 292
#define DEC 293
#define RSHIFT 294
#define LSHIFT 295
#define MINUS 296


#ifndef YYMAXDEPTH
# define YYMAXDEPTH 200
#endif /* !YYMAXDEPTH */

#ifndef YYASP
# define YYASP(n) yyasp[-n]
#endif /* !YYASP */

#define yyclearin (yychar = -1)
#define yyerrok (yyerrflag = 0)
#define YYRECOVERING (yyerrflag != 0)

#if YYACTFUN
# include <setjmp.h>
  static jmp_buf yyjmp;
# define YYACCEPT  longjmp(yyjmp, 1)
# define YYABORT  longjmp(yyjmp, 2)
#endif /* YYACTFUN */

#if !YYACTFUN
# define YYACCEPT  return (0)
# define YYABORT  return (1)
# define YYERROR  goto yyerrlab
#endif /* !YYACTFUN */


int yychar;
static int yyerrflag;

#if YYDEBUG
int yydebug;
#endif /* YYDEBUG */

int yylex();
int yyparse();
int yyerror();

YYSTYPE yylval;

static YYSTYPE *yyasp, yyval;

#if YYACTFUN

static void yydef()
{
}
#endif /* YYACTFUN */


/* Following line will be replaced by parser tables */


char *regimemory(char *p)
{
	if (p) { // o^
		char **tmp;
		if (NULL != (tmp = (char **)realloc(bufs, (num_bufs + 1) * sizeof(char*)))) {
			bufs = tmp;
			bufs[num_bufs++] = p;
		}
	}
	return p;
}

static void	free_memorys(void)
{
	// ꎞIɊmۂ
	if (bufs) {
		unsigned i;
		for(i=0 ; i<num_bufs ; i++)
			safefree(bufs[i]);
		safefree(bufs);
		num_bufs = 0;	
	}
}

char	*interprete(HWND hWnd, const char *buf)
{
	hSubDlg = hWnd;
	set_input_buffer (buf);
	yyparse();
	free_memorys();
	return(yaccReturnValue);
}

static	void rtn_result(char *text1, char *text2)
{
	safefree(yaccReturnValue);
	yaccReturnValue = malloc(strlen(text1) + strlen(text2) + 1);
	if (yaccReturnValue) {
		strcpy(yaccReturnValue, text1);
		strcat(yaccReturnValue, text2);
	}
}

static	void rtn_result_n(char *text1, unsigned n, char *text2)
{
	safefree(yaccReturnValue);
	yaccReturnValue = malloc(strlen(text1) + 15 + strlen(text2) + 1);
	if (yaccReturnValue) {
		char itbuf[16];
		strcpy(yaccReturnValue, text1);
		strcat(yaccReturnValue, "[");
		strcat(yaccReturnValue, itoa10ex(n, itbuf));
		strcat(yaccReturnValue, "]");
		strcat(yaccReturnValue, text2);
	}
}

static	int yyerror(char *msg)
{
	safefree(yaccReturnValue);
	yaccReturnValue = _strdup(msg);
	return 0;
}

int yywrap(void)
{
	return 1;
}

#ifdef YYDEBUG
#define YYMINTOK 256
#define YYMAXTOK 296
static char *yytnames[] = {
 "error",
 "EOL",
 "NUMBER",
 "STRING",
 "NAME",
 "NAME_D",
 "IF",
 "ELSE",
 "GOTO",
 "GOSUB",
 "EXIT",
 "ABORT",
 "ARRAY",
 "WHILE",
 "RETURN",
 "RESIZE",
 "FOR",
 "F0R",
 "ANDAND",
 "OROR",
 "E_ADDOP",
 "E_SUBOP",
 "E_ANDOP",
 "E_OROP",
 "E_MULOP",
 "E_DIVOP",
 "E_MODOP",
 "E_RSHIFT",
 "E_LSHIFT",
 "E_XOROP",
 "ELARGE",
 "ESMALL",
 "EEQUAL",
 "NEQUAL",
 "EEEQUAL",
 "NEEQUAL",
 "INC",
 "DEC",
 "RSHIFT",
 "LSHIFT",
 "MINUS",
  0 };

static char *yyntnames[] = {
  "$start",
  "expr",
  "string",
  "args",
  "arg",
  "s",
};

static short yyrstates[] = {
     4,     5,     6,     7,     9,    10,    14,    20,    23,    24,
    25,    26,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    44,    45,    46,    47,    48,
    49,    52,    54,    55,    62,    63,    67,    71,    77,    78,
    79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
    89,    90,    91,    92,    93,    94,    95,    97,    98,    99,
   100,   101,   102,   103,   104,   105,   106,   109,   110,   113,
   114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
   124,   125,   126,   130,   131,   132,   133,   134,   141,   142,
   147,   148,   151,   152,   153,   154,   156,   157,   158,   159,
   160,   161,   168,   169,   170,   171,   173,   180,   189,   191,
   194,   196,   197,   206,   207,   210,   211,   214,   215,   216,
   217,   218,   219,   223,   224,   225,   226,   227,   228,   229,
   230,   231,   232,   233,   238,   239,   256,   257,   258,   259,
   260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
   270,   271,   272,   275,   276,   277,   278,   287,   288,   289,
   290,   291,   295,   296,   297,   298,   299,   300,   301,   302,
   303,   304,   312,   313,   314,   315,   316,   317,   318,   319,
   320,   330,   331,   332,   333,   338,   339,   340,   341,   354,
   355,   356,     0,     8,    11,    12,    13,    15,    16,    17,
    18,    19,    21,    22,    27,    43,    50,    51,    53,    56,
    57,    60,    61,    65,    66,    68,    69,    72,    73,   107,
   108,   111,   112,   127,   128,   129,   138,   140,   143,   145,
   149,   150,   162,   163,   164,   165,   166,   167,   174,   175,
   176,   179,   181,   182,   183,   184,   185,   186,   187,   188,
   192,   195,   199,   200,   201,   202,   203,   208,   209,   212,
   213,   236,   237,   241,   243,   244,   245,   246,   247,   250,
   251,   252,   253,   279,   280,   292,   293,   294,   307,   308,
   309,   310,   311,   321,   322,   323,   324,   325,   326,   327,
   328,   329,   334,   335,   336,   337,   342,   343,   344,   345,
   346,   347,   348,   349,   357,   358,   359,   360,   361,   362,
   363,   364,   365,   366,   367,   368,   369,   374,   375,   376,
   377,   378,   379,   380,   381,   386,   387,   388,   389,     1,
     2,     3,    41,    42,    58,    59,    64,    70,    74,    75,
    76,    96,   135,   136,   137,   139,   144,   146,   155,   172,
   177,   178,   190,   193,   198,   204,   205,   220,   221,   222,
   234,   235,   240,   242,   248,   249,   254,   255,   273,   274,
   281,   282,   283,   284,   285,   286,   305,   306,   350,   351,
   352,   353,   370,   371,   372,   373,   382,   383,   384,   385,
   390,   391,   392,   393,
};
#endif /* YYDEBUG */

#define YYPASS 16384
#define YYLAST 700
static short yynext[] = {
    29,   206, 16425, 16477,    34,   337,   338,   339,   343,    25,
    67,    69,    70,    72,    74,    75,    76,    77,    78,    79,
    80,    81,    82,    67,    83,    84,    86, 16425, 16422,    88,
    27,   231,   208, 16427,    94, 16429,    98,    99,   100,   232,
   233,   234,   235,   236,   237,   102,   103,   104,   105,   106,
   238,   239,   240,   350,   351,   241,   225,   134,     9,   348,
   250,   256,   120,   122,   108,     2,   362, 16477,   209, 16447,
     7,   363,   263,   159,   394,   158, 16425,   264, 16422,    31,
   169,   334,   168,   201, 16478,   335, 16425,   336,   113,   114,
   115,   116, 16425,   260,   117,   118, 16425,    36, 16447,   215,
 16425, 16425, 16425, 16477,   157,   211,   212,    69,    67,    67,
    67,   167,   216,   178, 16508,   177,   186,   136,   185,   138,
    66,   140,   142,   144,   145,   146,   147,   148,   149,   150,
   151,   152,   153,   155, 16478,   227, 16425,    59,   251,    58,
    57,   359,   261,   262,   252,   213,   214, 16425,   267, 16425,
 16425,     8,   268,   269,   270,   162,   163,   164,   165,   166,
   223,   224,    55,    56, 16508,   172,   173,   174,   175,   176,
   219,   220,    66,   123,   217,   181,   182,   183,   184,   218,
   228,   229,    90,   189,   190,   191,   304,    12,   366,    59,
    10,    58,    57,   205,    30,   207,    33,   210,    35,   367,
    95,   278,   287,   353,    68,    91,    71,    73,    14,    92,
    93,    96,    97,   110,    10,   111,   112,    68,   354,    85,
    87,    54,    47,    89, 16641,   253,    52,    50,   272,    51,
 16641,    53,   101,   355,    66, 16658, 16659,   254,   109,   356,
   257,   258,   349,   340,    42,    28,    41,    40,    83,   107,
   242,   243,   244,   245,   246,   247,   248,   249,   352,     9,
 16641, 16641, 16641, 16641,   368,   369,     2,   265,   266,   364,
   273,     7,   135,   365,   271,   274,   370,   275,    49,   371,
   372,   373,   329,   330,   331,     0,     1,     3,   193,     4,
     5,   194,   195,   196,     6,   197,   198,   199,   200,   160,
   161,   374,    68,    68,    68,   375,   170,   171,    48, 16658,
 16659,   376,   137,   283,   139,   141,   143,   202,   203,   358,
   377,   284,   276,    54,    47,   277,   154,   156,    52,    50,
   285,    51,   286,    53,   345,   292,   293,   296,   294,   179,
   180,   295,   187,   188,   226,   297,    42,   298,    41,    40,
    54,    47,     8,   299,   378,    52,    50,   379,    51,   380,
    53,   381,   309,    60,    61,    62,    63,    64,    65,   310,
   305,   121,   311,    42,   312,    41,    40,    54,    47,   382,
    49,   316,    52,    50,    11,    51,   347,    53,   124,   125,
   126,   127,   128,   129,   130,   131,   132,   133,   306,   307,
    42,   308,    41,    40,   360,   361,   383,    49,    11,   384,
    48,   385,   321,   317,   322,    60,    61,    62,    63,    64,
    65,   318,   323,    15,    16,    17,    18,    19,    20,    21,
    22,    23,    24,   319,    49,   324,   386,    48,   320,   332,
   333,    54,    47,   387,   388,   389,    52,    50,    26,    51,
   325,    53,   326,   327,   328,   390,   391,   392,    38,    39,
   393, 16477, 16641,   341,    48,   346,   357,    13, 16425,   342,
    43,    44,    45,    46,   230,   255,   259,   119,    55,    56,
   279,   280,   281,   282,   330,   331,     0,     1,   288,   289,
   290,   291,   300,   301,   302,   303,   313,   314,    49,   315,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,   202,   203,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,    48, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767,   344, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
    38,    39, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767,    43,    44,    45,    46, 32767, 32767, 32767, 32767,
    55,    56, 32767, 32767, 32767, 32767, 32767,    38,    39, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,    43,
    44,    45,    46, 32767, 32767, 32767, 32767,    55,    56, 32767,
 32767, 32767, 32767, 32767,    38,    39, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767,    43,    44,    45,    46,
 32767, 32767, 32767, 32767,    55,    56, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
 32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,    55,    56,
};

#define YY2TABSTATES 192
#define YYLR1STATES 329
#define YYNSTATES 394
#define YYNXR 395
#define YYSTATE0 192
static short yybase[] = {
   376,   357,   368,   368,   -26,    10,   368,   368,   368,   368,
   -14,   206,   -90,   368,   368,   368,   368,   368,   368,   368,
   368,   368,   368,   368,   368,   -90,   368,   368,   368,   428,
   -33,   368,   427,   208,   416,   -27,   368,   205,   368,   368,
   368,   368,   368,   368,   368,   368,   368,   368,   368,   368,
   368,   368,   368,   368,   368,   368,   368,   368,   368,   368,
   368,   368,   368,   368,   368,   368,   368,   427,   205,    45,
   -39,   205,   -39,   205,   -39,   -39,   -39,   -39,   -39,   -39,
   -39,   -39,   -39,    51,   -39,   205,   -39,   205,   417,     3,
   368,   368,   368,   368,   432,   368,   368,   368,   -39,   -39,
   419,     4,    40,    40,    40,   -10,   -10,     5,   -10,   373,
   -90,   -90,   -90,    55,    59,    60,    61,    95,   106,   368,
   368,   368,   368,   368,   368,   368,   368,   368,   368,   368,
   368,   368,   368,   368,   368,   368,    35,     6,    35,     6,
   -39,   205,   -39,   205,   -39,   -39,   -39,   -39,   -39,   -39,
   -39,   -39,   -39,   -39,   205,   -39,   205,   368,   368,   368,
   368,   368,   108,   439,   440,   441,   442,   368,   368,   368,
   368,   368,   109,   447,   448,   449,   450,   368,   368,   368,
   368,   451,   452,   453,   454,   368,   368,   368,   368,   455,
   456,   458,    25,  -183,  -176,  -172,  -155,  -170,  -115,    57,
  -173,  -148,   -86,   -81,    74,  -100,   286,    77,   -80,   -79,
   129,    91,   114,   118,   119,   160,    25,   120,   121,   147,
   -31,   162,   169,   175,   176,   177,   -35,   -23,   -24,   -18,
   -20,   -19,   404,   404,   404,   404,   404,   404,  -132,  -132,
  -132,   313,   191,   191,   191,   191,   191,   191,   191,   191,
   226,   112,    -4,  -191,  -186,     7,     8,    12,    16,    14,
   184,   223,   224,   212,   217,    19,    22,    23,    24,    44,
    48,    13,    17,    62,    65,    20,    54,    63,    53,   255,
   263,   272,   274,    75,    76,    78,    81,    56,   279,   287,
   289,   295,    97,   100,   102,   104,   110,   138,   139,   141,
   304,   311,   314,   316,   340,   122,   149,   152,   154,   153,
   161,   173,   178,   354,   356,   364,   377,   179,   186,   187,
   188,   190,   192,   193,   194,   198,   199,   200,   203,
};

static short yybase2[] = {
   147,   -31,   226,   226,   226,   226,   226,   226,   226,   226,
   340,   129,   226,   226,   226,   226,   226,   226,   226,   226,
   226,   226,   226,   226,   226,   226,   226,   226,   226,   340,
   129,   226,   340,   129,   313,    77,   226,   129,   226,   226,
   226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
   226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
   226,   226,   226,   226,   226,   226,   226,   340,   129,   340,
   340,   129,   340,   129,   340,   340,   340,   340,   340,   340,
   340,   340,   340,   340,   340,   129,   340,   129,   313,    77,
   226,   226,   226,   226,   184,   226,   226,   226,   340,   340,
   313,    77,   404,   404,   404,   404,   404,    77,   404,   226,
   226,   226,   226,   340,   340,   340,   340,   340,   340,   226,
   226,   226,   226,   226,   226,   226,   226,   226,   226,   226,
   226,   226,   226,   226,   226,   226,   340,   129,   340,   129,
   340,   129,   340,   129,   340,   340,   340,   340,   340,   340,
   340,   340,   340,   340,   129,   340,   129,   226,   226,   226,
   226,   226,   340,   340,   340,   340,   340,   226,   226,   226,
   226,   226,   340,   340,   340,   340,   340,   226,   226,   226,
   226,   340,   340,   340,   340,   226,   226,   226,   226,   340,
   340,   340,
};

static short yydefault[] = {
   110,   126,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   135,   136,    -1,
    49,    51,    78,    80,    82,    92,    94,    84,    86,    88,
    96,    98,    90,    -1,   122,   118,   124,   120,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    67,    68,
    -1,    -1,    69,    70,    71,    42,    43,    -1,   115,    -1,
   134,   134,   134,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    75,   116,    76,   117,
    50,    52,    79,    81,    83,    93,    95,    85,    87,    89,
    97,    99,    91,   123,   119,   125,   121,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   104,   106,   110,
   126,    -1,   133,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    53,    54,    55,    56,    57,    58,    44,    45,
    46,    -1,    59,    60,    61,    62,    63,    65,    64,    66,
    -1,   111,   127,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    40,
   109,   131,   100,   102,    34,    35,    33,    47,    74,    77,
     1,     2,    48,   128,     7,    12,    31,    32,    41,   108,
    72,    73,   114,   112,   129,    29,    30,   137,   138,   132,
   101,   103,     3,     8,     6,    11,   105,   107,   113,   130,
     5,    10,    36,    37,    38,    39,     4,     9,    19,    15,
    17,    13,    27,    23,    25,    21,    20,    16,    18,    14,
    28,    24,    26,    22,
};

static short yycheck[] = {
   260,   261,    40,   262,   264,   265,   269,    45,   126,    33,
    -1,    -2,    40,    91,    61,   276,   277,   278,   279,   280,
   281,   282,   283,   284,   285,    40,    91,    61,   276,    -1,
    -2,   262,    -1,    -2,    -1,    -2,    40,    -2,   274,   275,
    63,    62,    60,   286,   287,   288,   289,    38,   124,    94,
    43,    45,    42,    47,    37,   294,   295,    63,    62,    60,
   286,   287,   288,   289,   290,   291,    43,    -1,    -2,    -1,
    -1,    -2,    -1,    -2,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -2,    -1,    -2,    -1,    -2,
    91,    91,    91,    91,    -1,    40,    91,    91,    -1,    -1,
    -1,    -2,    -1,    -1,    -1,    -1,    -1,    -2,    -1,    91,
    44,    40,    40,    -1,    -1,    -1,    -1,    -1,    -1,    58,
    58,    58,    58,    61,   276,   277,   278,   279,   280,   281,
   282,   283,   284,   285,    61,   276,    -1,    -2,    -1,    -2,
    -1,    -2,    -1,    -2,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -2,    -1,    -2,    91,    62,    60,
   286,   287,    -1,    -1,    -1,    -1,    -1,    91,    62,    60,
   286,   287,    -1,    -1,    -1,    -1,    -1,    62,    60,   286,
   287,    -1,    -1,    -1,    -1,    62,    60,   286,   287,    -1,
    -1,    -1, 32767,   263,   266,   267,   268,   270,   271,   272,
   273,    58,   292,   293,    -5,    46,    -1,    -2,    58,    58,
    -2,   260,   261,   260,   261,   272,   260,   260,   260,   260,
   261,    -3,    -4,   260,   261,    -3,    58,    58,   260,   260,
    58,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -2,    -2,    -2,    -2,    -2,    -2,    -2,    -2,
    91,    93,    93,   260,   260,    58,    58,   260,   260,    44,
    -1,    -3,    -3,   263,   263,   260,   260,    93,    93,    93,
    93,   260,    44,    58,    58,   260,   260,   260,    93,    41,
    41,    41,    41,    58,    58,    58,    58,    93,    41,    41,
    41,    41,   260,   260,   260,   260,    58,    58,    58,    58,
    41,    41,    41,    41,    -1,   260,   260,   260,   260,    58,
    58,    58,    58,    41,    41,    41,    41,   260,   260,   260,
   260,    58,    58,    58,    58,   260,   260,   260,   260,   257,
   258,   259,   292,   293,   257,   257,   257,    -1,    -1,    -1,
   257,   257,    41,    41,   257,   257,   257,   257,    -5,    -2,
    -1,    -1,    -2,    41,    41,   257,   257,    93,    93,    -3,
   292,   293,   257,   257,   257,   257,    93,    93,    41,    41,
   257,   257,   257,   257,   257,   257,   257,   257,   257,   257,
   257,   257,   257,   257,   257,   257,   257,   257,   257,   257,
   257,   257,   257,   257,
    74,
};

static short yyrederr[] = {
     0,
};

static short yygbase[] = {
 32767,    -2,   192,    31, 32767,  -157,
};

static short yydefgoto[] = {
     0,    32,    37,   221,   222,   204,
};

static char yyleft[] = {
     0,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     3,     3,     3,     4,     4,     4,     4,
};

static char yylen[] = {
     1,     2,     2,     5,     8,     6,     5,     3,     5,     8,
     6,     5,     3,    11,    14,    11,    14,    11,    14,    11,
    14,    12,    15,    12,    15,    12,    15,    12,    15,     4,
     4,     3,     3,     2,     2,     2,     6,     6,     6,     6,
     1,     3,     3,     3,     3,     3,     3,     2,     3,     3,
     6,     3,     6,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     2,     5,     5,     2,     3,     6,
     3,     6,     3,     6,     3,     6,     3,     6,     3,     6,
     3,     6,     3,     6,     3,     6,     3,     6,     3,     6,
     2,     5,     2,     5,     2,     5,     2,     5,     3,     1,
     1,     4,     4,     6,     3,     3,     5,     5,     3,     6,
     3,     6,     3,     6,     3,     6,     1,     4,     3,     4,
     6,     1,     3,     1,     0,     1,     1,     3,     3,
};




#if !YYDEBUG

#define YYTRACE_DCL
#define YYTRACE_NEWSTATE()
#define YYTRACE_READ()
#define YYTRACE_SHIFT(tok)
#define YYTRACE_ACCEPT()
#define YYTRACE_REDUCE()
#define YYTRACE_POP()
#define YYTRACE_DISCARD()

#endif /* !YYDEBUG */


#if YYDEBUG

#ifndef EOF
#include <stdio.h>
#endif

#ifndef YYTRACEF
#define YYTRACEF stderr
#endif /* !YYTRACEF */

static char *yytokname(n)
    int n;
{
    static char buf[10];

    if (YYMINTOK <= n && n <= YYMAXTOK && yytnames[n - YYMINTOK])
	return yytnames[n - YYMINTOK];
    switch (n) {
    case 0:
	return ("end-of-file");
    case '\n':
	return ("'\\n'");
    case '\t':
	return ("'\\t'");
    default:
	if (n < 0x20 || n > 0x7e) {
	    sprintf(buf, "<%d>", n);
	} else {
	    buf[0] = '\'';
	    buf[1] = n;
	    buf[2] = '\'';
	    buf[3] = '\0';
	}
	return (buf);
    }
}


#if YYDEBUG == 2

/* Traditional Debug Mode */

#define YYTRACE_DCL /* empty */

#define YYTRACE_NEWSTATE() \
    if (yydebug) \
	fprintf(YYTRACEF, "%%%% State %d, Lookahead %s\n", \
		yyrstates[yystate], yychar < 0 ? "--none--" : yytokname(yychar))

#define YYTRACE_READ() \
    if (yydebug) \
	fprintf(YYTRACEF, "%%%% Reading %s\n", yytokname(yychar))

#define YYTRACE_SHIFT(tok) \
    if (yydebug) \
	fprintf(YYTRACEF, "%%%% Shift %s\n", yytokname(yychar))

#define YYTRACE_ACCEPT() \
    if (yydebug) fprintf(YYTRACEF, "%%%% Accepted.\n")

#define YYTRACE_REDUCE() \
    if (yydebug) { \
	int sym; \
	short *p; \
	fprintf(YYTRACEF, "%%%% Reduce by (%d) %s :", \
		yyn, yyntnames[yyleft[yyn]]); \
	if (yyl == 0) \
	    fprintf(YYTRACEF, " /* empty */"); \
	for (p = yyssp - yyl + 1; p <= yyssp; p++) { \
	    sym = yycheck[*p]; \
	    fprintf(YYTRACEF, " %s", sym >= 0 ? yytokname(sym) : yyntnames[-sym]); \
	} \
	fputc('\n', YYTRACEF); \
    }

#define YYTRACE_POP() \
    if (yydebug) \
	fprintf(YYTRACEF, "%%%% Recovering, uncovers state %d\n", \
		yyrstates[yystate])

#define YYTRACE_DISCARD() \
    if (yydebug) fprintf(YYTRACEF, "%%%% Discard %s\n", yytokname(yychar))

#endif /* YYDEBUG == 2 */

#if YYDEBUG != 2
/* Messy Debug Mode */

#ifndef YYMAXSTKSHOWN
#define YYMAXSTKSHOWN 50
#endif /* YYMAXSTKSHOWN */

static void yyshowstack(sstk, ssp, mark)
    short *sstk;
    short *ssp;
    short *mark;
{
    short *p;
    int sym, len;
    int strlen();

    len = 1;
    for (p = ssp; p >= sstk; --p) {
	sym = yycheck[*p];
	len += 1 + strlen(sym >= 0 ? yytokname(sym) : yyntnames[-sym]);
	if (len > YYMAXSTKSHOWN)
	    break;
    }
    p++;
    if (mark && p > mark) p = mark;
    if (p != sstk) fprintf(YYTRACEF, "...");
    for (; p <= ssp; p++) {
	if (p == mark)
	    fputc('[', YYTRACEF);
	else
	    fputc(' ', YYTRACEF);
	sym = yycheck[*p];
	fprintf(YYTRACEF, "%s", sym >= 0 ? yytokname(sym) : yyntnames[-sym]);
    }
    if (mark) {
	if (p == mark)
	    fputc('[', YYTRACEF);
	fputc(']', YYTRACEF);
    } else
	fputc(' ', YYTRACEF);
}

#define YYTRACE_DCL /* empty */

#define YYTRACE_NEWSTATE() \
    if (yydebug) { \
	fprintf(YYTRACEF, "%%%%%3d:", yyrstates[yystate]); \
	yyshowstack(yysstk + 1, yyssp, 0); \
	if (yychar >= 0) \
	    fprintf(YYTRACEF, "  <<< %s", yytokname(yychar)); \
	fprintf(YYTRACEF, "\n"); \
    }

#define YYTRACE_READ() \
    if (yydebug) \
	fprintf(YYTRACEF, "%%%% Reading %s\n", yytokname(yychar))

#define YYTRACE_SHIFT(tok)

#define YYTRACE_ACCEPT() \
    if (yydebug) fprintf(YYTRACEF, "%%%% Accepted.\n")

#define YYTRACE_REDUCE() \
    if (yydebug) { \
	fprintf(YYTRACEF, "%%%%%3d:", yyrstates[yystate]); \
	yyshowstack(yysstk + 1, yyssp, yyssp - yyl + 1); \
	fprintf(YYTRACEF, " --> %s, by (%d)\n", yyntnames[yyleft[yyn]], yyn); \
    }

#define YYTRACE_POP() \
    if (yydebug) { \
	fprintf(YYTRACEF, "%%%%%3d:", yyrstates[yystate]); \
	yyshowstack(yysstk + 1, yyssp, 0); \
	fprintf(YYTRACEF, "  (Recovering)\n", yyrstates[yystate]); \
    }

#define YYTRACE_DISCARD() \
    if (yydebug) fprintf(YYTRACEF, "%%%% Discard %s\n", yytokname(yychar))

#endif /* YYDEBUG == 2 */

#endif /* YYDEBUG */



int yyparse()
{
    YYSTYPE yyastk[YYMAXDEPTH];
    short yysstk[YYMAXDEPTH];
    short *yyssp;
    int yystate;
    int yyn;
    int yyl;
    YYTRACE_DCL

#if YYACTFUN    
    if ((yyn = setjmp(yyjmp)) != 0)
	return (yyn - 1);
#endif /* YYACTFUN */
    yyssp = yysstk;
    yyasp = yyastk - 1;
    *yyssp = yystate = YYSTATE0;
    yychar = -1;
    yyerrflag = 0;
    for (;;) {
	YYTRACE_NEWSTATE();

	if (yystate >= YYLR1STATES)
	    goto yydeflt;

	if (yychar < 0) {
	    if ((yychar = yylex()) <= 0) yychar = 0;
	    YYTRACE_READ();
	}

	if ((yyn = yybase[yystate] + yychar) >= 0 && yyn < YYLAST) {
	    if ((yyn = yynext[yyn]) < YYNSTATES) {
		if (yycheck[yyn] == yychar)
		    goto yyshift;
	    } else if (yyn < YYNXR) {
		if (yycheck[yyn] == yybase[yystate]) {
		    yyn = yyrederr[yyn - YYNSTATES];
		    goto yyaction;
		}
	    } else if (yyn - YYPASS == yychar)
		goto yydeflt;
	}

	if (yystate >= YY2TABSTATES
	    || (yyn = yybase2[yystate] + yychar) < 0 || YYLAST <= yyn
	    || (yyn = yynext[yyn]) >= YYNSTATES || yycheck[yyn] != yychar)
	    goto yydeflt;

    yyshift:
	YYTRACE_SHIFT(yychar);
	if (yyssp >= yysstk + YYMAXDEPTH) {
	    yyerror("parser stack overflow");
	    return (2);
	}
	*++yyssp = yystate = yyn;
	*++yyasp = yylval;
	yychar = -1;
	if (yyerrflag > 0)
	    yyerrflag--;
	continue;

    yydeflt:
	yyn = yydefault[yystate];

    yyaction:
	/* reduce/error */
	if (yyn == 0) {
	    /* accept */
	    YYTRACE_ACCEPT();
	    return (0);
	} else if (yyn > 0) {
	    /* reduce */
	    yyl = yylen[yyn];
	    YYTRACE_REDUCE();
	    yyval = yyasp[1 - yyl]; /* default value */
#if YYACTFUN
	    (*yya[yyn])();
#endif /* YYACTFUN */

#if !YYACTFUN
	    switch (yyn) {
		/* Following line will be replaced by actions */
case 1:
{ 
				rtn_result("", "");
				YYACCEPT;
			} break;
case 2:
{ 
				rtn_result("", "");
				YYACCEPT;
			} break;
case 3:
{ 
				if (YYASP(3).dval)	rtn_result(":", YYASP(1).text);
				else rtn_result("", "");
				YYACCEPT;
			} break;
case 4:
{ 
				if (YYASP(6).dval)	rtn_result(":", YYASP(4).text);
				else rtn_result(":", YYASP(1).text);
				YYACCEPT;
			} break;
case 5:
{ 
				if (YYASP(3).dval)	rtn_result("", "");
				else rtn_result(":", YYASP(1).text);
				YYACCEPT;
			} break;
case 6:
{ 
				if (YYASP(3).dval)	rtn_result("", "");
				else rtn_result(":", YYASP(1).text);
				YYACCEPT;
			} break;
case 7:
{ 
				if (YYASP(1).dval)	rtn_result("", "");
				else rtn_result("nextline", "");
				YYACCEPT;
			} break;
case 8:
{ 
				if (YYASP(3).text[0]) rtn_result(":", YYASP(1).text);
				else rtn_result("", "");
				YYACCEPT;
			} break;
case 9:
{ 
				if (YYASP(6).text[0]) rtn_result(":", YYASP(4).text);
				else rtn_result(":", YYASP(1).text);
				YYACCEPT;
			} break;
case 10:
{ 
				if (YYASP(3).text[0]) rtn_result("", "");
				else rtn_result(":", YYASP(1).text);
				YYACCEPT;
			} break;
case 11:
{ 
				if (YYASP(3).text[0]) rtn_result("", "");
				else rtn_result(":", YYASP(1).text);
				YYACCEPT;
			} break;
case 12:
{ 
				if (YYASP(1).text[0]) rtn_result("", "");
				else rtn_result("nextline", "");
				YYACCEPT;
			} break;
case 13:
{ 
				unsigned r;
				if (0 == setVariable(YYASP(6).text, r = YYASP(8).dval)) {
					if (r <= YYASP(4).dval) rtn_result("nextline", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 14:
{ 
				unsigned r;
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, r = YYASP(11).dval)) {
					if (r <= YYASP(4).dval) rtn_result("nextline", "");
					else            rtn_result(":", YYASP(1).text);
				}
				else
					rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 15:
{ 
				unsigned r;
				if (0 == setVariable(YYASP(6).text, r = YYASP(8).dval)) {
					if (r < YYASP(4).dval) rtn_result("nextline", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 16:
{ 
				unsigned r;
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, r = YYASP(11).dval)) {
					if (r < YYASP(4).dval) rtn_result("nextline", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 17:
{ 
				unsigned r;
				if (0 == setVariable(YYASP(6).text, r = YYASP(8).dval)) {
					if (r >= YYASP(4).dval) rtn_result("nextline", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 18:
{ 
				unsigned r;
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, r = YYASP(11).dval)) {
					if (r >= YYASP(4).dval) rtn_result("nextline", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 19:
{ 
				unsigned r;

				if (0 == setVariable(YYASP(6).text, r = YYASP(8).dval)) {
					if (r > YYASP(4).dval) rtn_result("nextline", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 20:
{ 
				unsigned r;
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, r = YYASP(11).dval)) {
					if (r > YYASP(4).dval) rtn_result("nextline", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 21:
{ 
				unsigned r;
				if (0 == setVariable(YYASP(6).text, r = getVariable(YYASP(6).text)+1)) {
					if (r <= YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 22:
{ 
				unsigned r;
				getVariable_a(YYASP(9).text, YYASP(7).dval, &r);
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, ++r))  {
					if (r <= YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 23:
{ 
				unsigned r;
				if (0 == setVariable(YYASP(6).text, r = getVariable(YYASP(6).text)+1)) {
					if (r < YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 24:
{ 
				unsigned r;
				getVariable_a(YYASP(9).text, YYASP(7).dval, &r);
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, ++r)) {
					if (r < YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 25:
{ 
				unsigned r;
				if (0 == setVariable(YYASP(6).text, r = getVariable(YYASP(6).text)-1)) {
					if (r >= YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 26:
{ 
				unsigned r;
				getVariable_a(YYASP(9).text, YYASP(7).dval, &r);
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, --r)) {
					if (r >= YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 27:
{ 
				unsigned r;
				if (0 == setVariable(YYASP(6).text, r = getVariable(YYASP(6).text)-1)) {
					if (r > YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result(YYASP(6).text, ":gĂϐ܂B");
				YYACCEPT;
			} break;
case 28:
{ 
				unsigned r;
				getVariable_a(YYASP(9).text, YYASP(7).dval, &r);
				if (0 == setVariable_a(YYASP(9).text, YYASP(7).dval, --r)) {
					if (r > YYASP(4).dval) rtn_result("", "");
					else rtn_result(":", YYASP(1).text);
				}
				else rtn_result_n(YYASP(9).text, YYASP(7).dval, ":錾̔z񂩁Avf傫܂B");
				YYACCEPT;
			} break;
case 29:
{ 
				rtn_result(":", YYASP(1).text);
				YYACCEPT;
			} break;
case 30:
{ 
				rtn_result("GOSUB :", YYASP(1).text);
				YYACCEPT;
			} break;
case 31:
{ 
				if (YYASP(1).text[0] == ':') rtn_result(YYASP(1).text, "");
				else rtn_result("GOTOx:Ŏn܂Ă܂ - ", YYASP(1).text);
				YYACCEPT;
			} break;
case 32:
{ 
				if (YYASP(1).text[0] == ':') rtn_result("GOSUB ", YYASP(1).text);
				else rtn_result("GOSUBx:Ŏn܂Ă܂ - ", YYASP(1).text);
				YYACCEPT;
			} break;
case 33:
{ 
				rtn_result("return", "");
				YYACCEPT;
			} break;
case 34:
{ 
				rtn_result("exit", "");
				YYACCEPT;
			} break;
case 35:
{ 
				rtn_result("abort", "");
				YYACCEPT;
			} break;
case 36:
{	
				if (array_variables(YYASP(4).text, YYASP(2).dval) == 1) 
					 rtn_result_n(YYASP(4).text, YYASP(2).dval, ":gpς݂̕ϐA錾ς݂̔z񂩁A܂B");
				else rtn_result("", "");
				YYACCEPT;
			} break;
case 37:
{	
				if (array_variables_d(YYASP(4).text, YYASP(2).dval) == 1) 
					 rtn_result_n(YYASP(4).text, YYASP(2).dval, ":gpς݂̕ϐA錾ς݂̔z񂩁A܂B");
				else rtn_result("", "");
				YYACCEPT;
			} break;
case 38:
{	
				if (resize_variables(YYASP(4).text, YYASP(2).dval) == 1)	
					 rtn_result_n(YYASP(4).text, YYASP(2).dval, ":܂B");
				else rtn_result("", "");
				YYACCEPT;
			} break;
case 39:
{	
				if (resize_variables_d(YYASP(4).text, YYASP(2).dval) == 1) 
					 rtn_result_n(YYASP(4).text, YYASP(2).dval, ":܂B");
				else rtn_result("", "");
				YYACCEPT;
			} break;
case 41:
{ 
				rtn_result("", "");
				YYACCEPT;
			} break;
case 42:
{	yyval.dval = YYASP(2).dval + YYASP(0).dval; } break;
case 43:
{	yyval.dval = YYASP(2).dval - YYASP(0).dval; } break;
case 44:
{ yyval.dval = YYASP(2).dval * YYASP(0).dval; } break;
case 45:
{
				if(YYASP(0).dval == 0) {
					rtn_result("0ɂ鏜ZB", "");
					YYACCEPT;
				} else
					yyval.dval = YYASP(2).dval / YYASP(0).dval;
			} break;
case 46:
{
				if(YYASP(0).dval == 0.0) {
					rtn_result("0ɂ鏜ZB", "");
					YYACCEPT;
				} else
					yyval.dval = YYASP(2).dval % YYASP(0).dval;
			} break;
case 47:
{ yyval.dval = 0-YYASP(0).dval; /* 0x100000000 - $2 ̒lɂȂ */ } break;
case 48:
{ yyval.dval = YYASP(1).dval; } break;
case 49:
{
				if (0 == setVariable(YYASP(2).text, YYASP(0).dval))
					yyval.dval = YYASP(0).dval;
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 50:
{
				if (0 == setVariable_a(YYASP(5).text, YYASP(3).dval, YYASP(0).dval))
					yyval.dval = YYASP(0).dval;
				else {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
			} break;
case 51:
{
				unsigned i;
				if (0 == setVariable(YYASP(2).text, i = atoi(YYASP(0).text)))
					yyval.dval = i;
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 52:
{
				unsigned i;
				if (0 == setVariable_a(YYASP(5).text, YYASP(3).dval, i = atou(YYASP(0).text)))
					yyval.dval = i;
				else {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
			} break;
case 53:
{ yyval.dval = (unsigned)((YYASP(2).dval > YYASP(0).dval)?1:0); } break;
case 54:
{ yyval.dval = (unsigned)((YYASP(2).dval < YYASP(0).dval)?1:0); } break;
case 55:
{ yyval.dval = (unsigned)((YYASP(2).dval >= YYASP(0).dval)?1:0); } break;
case 56:
{ yyval.dval = (unsigned)((YYASP(2).dval <= YYASP(0).dval)?1:0); } break;
case 57:
{ yyval.dval = (unsigned)((YYASP(2).dval == YYASP(0).dval)?1:0); } break;
case 58:
{ yyval.dval = (unsigned)((YYASP(2).dval != YYASP(0).dval)?1:0); } break;
case 59:
{ yyval.dval = (unsigned)((strcmp(YYASP(2).text,YYASP(0).text) < 0)?1:0); } break;
case 60:
{ yyval.dval = (unsigned)((strcmp(YYASP(2).text,YYASP(0).text) > 0)?1:0); } break;
case 61:
{ yyval.dval = (unsigned)((strcmp(YYASP(2).text,YYASP(0).text) >= 0)?1:0); } break;
case 62:
{ yyval.dval = (unsigned)((strcmp(YYASP(2).text,YYASP(0).text) <= 0)?1:0); } break;
case 63:
{ yyval.dval = (unsigned)((strcmp(YYASP(2).text,YYASP(0).text) == 0)?1:0); } break;
case 64:
{ yyval.dval = (unsigned)((strcmpi(YYASP(2).text,YYASP(0).text) == 0)?1:0); } break;
case 65:
{ yyval.dval = (unsigned)((strcmp(YYASP(2).text,YYASP(0).text) != 0)?1:0); } break;
case 66:
{ yyval.dval = (unsigned)((strcmpi(YYASP(2).text,YYASP(0).text) != 0)?1:0); } break;
case 67:
{ yyval.dval = (unsigned)((YYASP(2).dval != 0) && (YYASP(0).dval != 0)); } break;
case 68:
{ yyval.dval = (unsigned)((YYASP(2).dval != 0) || (YYASP(0).dval != 0)); } break;
case 69:
{ yyval.dval = ((unsigned)YYASP(2).dval & (unsigned)YYASP(0).dval); } break;
case 70:
{ yyval.dval = ((unsigned)YYASP(2).dval | (unsigned)YYASP(0).dval); } break;
case 71:
{ yyval.dval = ((unsigned)YYASP(2).dval ^ (unsigned)YYASP(0).dval); } break;
case 72:
{ yyval.dval = ((unsigned)YYASP(2).dval >> (unsigned)YYASP(0).dval); } break;
case 73:
{ yyval.dval = ((unsigned)YYASP(2).dval << (unsigned)YYASP(0).dval); } break;
case 74:
{ yyval.dval = (~(unsigned)YYASP(0).dval); } break;
case 75:
{ yyval.dval = (YYASP(4).dval ? YYASP(2).dval : YYASP(0).dval); } break;
case 76:
{ yyval.dval = (YYASP(4).text[0] ? YYASP(2).dval : YYASP(0).dval); } break;
case 77:
{ yyval.dval = !(YYASP(0).dval); } break;
case 78:
{
				if (0 == setVariable(YYASP(2).text, getVariable(YYASP(2).text) + YYASP(0).dval))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 79:
{
				int r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r += YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 80:
{
				if (0 == setVariable(YYASP(2).text, getVariable(YYASP(2).text) + atoi(YYASP(0).text)))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 81:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r += atou(YYASP(0).text));
					yyval.dval = r;
				}
			} break;
case 82:
{
				if (0 == setVariable(YYASP(2).text, getVariable(YYASP(2).text) - YYASP(0).dval))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text,":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 83:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r -= YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 84:
{
				if (0 == setVariable(YYASP(2).text, getVariable(YYASP(2).text) * YYASP(0).dval))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 85:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r *= YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 86:
{
				if(YYASP(0).dval == 0) {
					rtn_result("0ɂ鏜ZB", "");
					YYACCEPT;
				}
				else {
					if (0 == setVariable(YYASP(2).text, getVariable(YYASP(2).text) / YYASP(0).dval))
						yyval.dval = getVariable(YYASP(2).text);
					else {
						rtn_result(YYASP(2).text, ":gĂϐ܂B");
						YYACCEPT;
					}
				}
			} break;
case 87:
{
				unsigned r;
				if(YYASP(0).dval == 0) {
					rtn_result("0ɂ鏜ZB", "");
					YYACCEPT;
				}
				else if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r /= YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 88:
{
				if(YYASP(0).dval == 0) {
					rtn_result("0ɂ鏜ZB", "");
					YYACCEPT;
				}
				else {
					if (0 == setVariable(YYASP(2).text, getVariable(YYASP(2).text) % YYASP(0).dval))
						yyval.dval = getVariable(YYASP(2).text);
					else {
						rtn_result(YYASP(2).text, ":gĂϐ܂B");
						YYACCEPT;
					}
				}
			} break;
case 89:
{
				unsigned r;
				if(YYASP(0).dval == 0) {
					rtn_result(":0ɂ鏜ZB", "");
					YYACCEPT;
				}
				else if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r %= YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 90:
{
				if (0 == (setVariable(YYASP(2).text, ((unsigned)getVariable(YYASP(2).text) ^ (unsigned)YYASP(0).dval))))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 91:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, ((unsigned)r ^= (unsigned)YYASP(0).dval));
					yyval.dval = r;
				}
			} break;
case 92:
{
				if (0 == (setVariable(YYASP(2).text, ((unsigned)getVariable(YYASP(2).text) & (unsigned)YYASP(0).dval))))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 93:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, ((unsigned)r &= (unsigned)(YYASP(0).dval)));
					yyval.dval = r;
				}
			} break;
case 94:
{
				if (0 == (setVariable(YYASP(2).text, getVariable(YYASP(2).text) | YYASP(0).dval)))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 95:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r |= YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 96:
{
				if (0 == (setVariable(YYASP(2).text, getVariable(YYASP(2).text) >> YYASP(0).dval)))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text,":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 97:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r >>= YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 98:
{
				if (0 == (setVariable(YYASP(2).text, getVariable(YYASP(2).text) << YYASP(0).dval)))
					yyval.dval = getVariable(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 99:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(5).text, YYASP(3).dval, &r)) {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(5).text, YYASP(3).dval, r <<= YYASP(0).dval);
					yyval.dval = r;
				}
			} break;
case 100:
{
				unsigned r = getVariable(YYASP(1).text);
				if (0 == (setVariable(YYASP(1).text, r + 1)))
					yyval.dval = r;
				else {
					rtn_result(YYASP(1).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 101:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(4).text, YYASP(2).dval, &r)) {
					rtn_result_n(YYASP(4).text, YYASP(2).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(4).text, YYASP(2).dval, r+1);
					yyval.dval = r;
				}
			} break;
case 102:
{
				unsigned r = getVariable(YYASP(1).text);
				if (0 == (setVariable(YYASP(1).text, r - 1)))
					yyval.dval = r;
				else {
					rtn_result(YYASP(1).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 103:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(4).text, YYASP(2).dval, &r)) {
					rtn_result_n(YYASP(4).text, YYASP(2).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(4).text, YYASP(2).dval, r-1);
					yyval.dval = r;
				}
			} break;
case 104:
{
				unsigned r = getVariable(YYASP(0).text) + 1;
				if (0 == (setVariable(YYASP(0).text, r)))
					yyval.dval = r;
				else {
					rtn_result(YYASP(0).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 105:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(3).text, YYASP(1).dval, &r)) {
					rtn_result_n(YYASP(3).text, YYASP(1).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(3).text, YYASP(1).dval, ++r);
					yyval.dval = r;
				}
			} break;
case 106:
{
				unsigned r = getVariable(YYASP(0).text) - 1;
				if (0 == (setVariable(YYASP(0).text, r)))
					yyval.dval = r;
				else {
					rtn_result(YYASP(0).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 107:
{
				unsigned r;
				if (1 == getVariable_a(YYASP(3).text, YYASP(1).dval, &r)) {
					rtn_result_n(YYASP(3).text, YYASP(1).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else {
					setVariable_a(YYASP(3).text, YYASP(1).dval, --r);
					yyval.dval = r;
				}
			} break;
case 108:
{
				yyval.dval = YYASP(2).dval + atoi(YYASP(0).text);
			} break;
case 109:
{
				yyval.dval = YYASP(0).dval;
			} break;
case 110:
{
				yyval.dval = getVariable(YYASP(0).text);
			} break;
case 111:
{
				unsigned r;
				if (getVariable_a(YYASP(3).text, YYASP(1).dval, &r) == 1) {
					rtn_result_n(YYASP(3).text, YYASP(1).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else
					yyval.dval = r;
			} break;
case 112:
{ 
				BYTE result;
				yyval.dval = funccall(hSubDlg, YYASP(3).text, YYASP(1).args, &result);
				switch(result) {
					case UFC_UNKNOWN_FUNCNAME:
						rtn_result(YYASP(3).text, "():֐Ⴂ܂B");
						YYACCEPT;
						break;

					case UFC_MISSMATCH_ARGS:
						rtn_result(YYASP(3).text, "():̎ނ܂B");
						YYACCEPT;
						break;

					case UFS_NEED_DOLLAR:
						rtn_result(YYASP(3).text, "():֐̌$LKvłB");
						YYACCEPT;
						break;

					case UFS_NOTFOUNDDLL:
						rtn_result(YYASP(1).args->v.text, ":w肳ꂽDLL܂B");
						YYACCEPT;
						break;

					case UFS_NOTFOUNDDLLFUNC:
						rtn_result(YYASP(1).args->next->v.text, "():w肳ꂽ֐DLLɌ܂B");
						YYACCEPT;
						break;

					case UFC_CANTRUNEXE:
						rtn_result(YYASP(1).args->v.text, ":w肳ꂽt@Csł܂B");
						YYACCEPT;
						break;
				}
			} break;
case 113:
{ 
				BYTE result;
				struct ARGS a_dll, a_func;
				char *buf = malloc(strlen(YYASP(5).text)+5);
				if (buf) {
					strcpy(buf, YYASP(5).text);
					strcat(buf, ".dll");
					
					a_dll.type = UFCT_ARG_STRING;
					a_dll.v.text = buf;
					a_dll.next = &a_func;

					a_func.type = UFCT_ARG_STRING;
					a_func.v.text = YYASP(3).text;
					a_func.next = YYASP(1).args;

					yyval.dval = rfunc_CallDll(hSubDlg, &a_dll, &result);
					switch(result) {
						case UFC_UNKNOWN_FUNCNAME:
							rtn_result(YYASP(3).text, "():֐Ⴂ܂B");
							YYACCEPT;
							break;

						case UFC_MISSMATCH_ARGS:
							rtn_result(YYASP(3).text, "():̎ނ܂B");
							YYACCEPT;
							break;

						case UFS_NEED_DOLLAR:
							rtn_result(YYASP(3).text, "():֐̌$LKvłB");
							YYACCEPT;
							break;

						case UFS_NOTFOUNDDLL:
							rtn_result(YYASP(5).text, ":w肳ꂽDLL܂B");
							YYACCEPT;
							break;

						case UFS_NOTFOUNDDLLFUNC:
							rtn_result(YYASP(3).text, "():w肳ꂽ֐DLLɌ܂B");
							YYACCEPT;
							break;

						case UFC_CANTRUNEXE:
							rtn_result(YYASP(3).text, ":w肳ꂽt@Csł܂B");
							YYACCEPT;
							break;
					}
					
					safefree(buf);
				}
				else {
					rtn_result(YYASP(3).text, ":Ȃ߁Aspł܂B");
					YYACCEPT;				
				}
			} break;
case 114:
{
				yyval.text = RM(malloc(strlen(YYASP(2).text) + strlen (YYASP(0).text) + 1));
				strcpy(yyval.text, YYASP(2).text);
				strcat(yyval.text, YYASP(0).text);
			} break;
case 115:
{
				yyval.text = RM(malloc(strlen(YYASP(2).text) + 12));
				sprintf(yyval.text, "%s%u", YYASP(2).text, YYASP(0).dval);
			} break;
case 116:
{
				yyval.text = (YYASP(4).dval ? YYASP(2).text : YYASP(0).text);
			} break;
case 117:
{
				yyval.text = (YYASP(4).text[0] ? YYASP(2).text : YYASP(0).text);
			} break;
case 118:
{
				if (setVariable_d(YYASP(2).text, YYASP(0).text) == 0)
					yyval.text = YYASP(0).text;
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 119:
{
				if (setVariable_d_a(YYASP(5).text, YYASP(3).dval, YYASP(0).text) == 0)
					yyval.text = YYASP(0).text;
				else {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
			} break;
case 120:
{
				if (addVariable_d(YYASP(2).text, YYASP(0).text) == 0)
					yyval.text = getVariable_d(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 121:
{
				if (addVariable_d_a(YYASP(5).text, YYASP(3).dval, YYASP(0).text) == 0)
					yyval.text = getVariable_d_a(YYASP(5).text, YYASP(3).dval);
				else {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
			} break;
case 122:
{
				char itbuf[16];
				if (setVariable_d(YYASP(2).text, itoa10ex(YYASP(0).dval, itbuf)) == 0)
					yyval.text = getVariable_d(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 123:
{
				char itbuf[16];
				if (setVariable_d_a(YYASP(5).text, YYASP(3).dval, itoa10ex(YYASP(0).dval, itbuf)) == 0)
					yyval.text = getVariable_d_a(YYASP(5).text, YYASP(3).dval);
				else {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
			} break;
case 124:
{
				char itbuf[16];
				if (addVariable_d(YYASP(2).text, itoa10ex(YYASP(0).dval, itbuf)) == 0)
					yyval.text = getVariable_d(YYASP(2).text);
				else {
					rtn_result(YYASP(2).text, ":gĂϐ܂B");
					YYACCEPT;
				}
			} break;
case 125:
{
				char itbuf[16];
				if (addVariable_d_a(YYASP(5).text, YYASP(3).dval, itoa10ex(YYASP(0).dval, itbuf)) == 0)
					yyval.text = getVariable_d_a(YYASP(5).text, YYASP(3).dval);
				else {
					rtn_result_n(YYASP(5).text, YYASP(3).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
			} break;
case 126:
{	yyval.text = getVariable_d(YYASP(0).text);	} break;
case 127:
{
				char *s;
				if (NULL == (s = getVariable_d_a(YYASP(3).text, YYASP(1).dval))) {
					rtn_result_n(YYASP(3).text, YYASP(1).dval, ":錾̔z񂩁Avf傫܂B");
					YYACCEPT;
				}
				else
					yyval.text = s;
			} break;
case 128:
{	yyval.text = YYASP(1).text;	} break;
case 129:
{ 
				BYTE result;
				char *tmp;

				tmp = funccall_d(hSubDlg, YYASP(3).text, YYASP(1).args, &result);
				switch(result) {
					case UFC_UNKNOWN_FUNCNAME:
						rtn_result(YYASP(3).text, "():֐Ⴂ܂B");
						YYACCEPT;
						break;

					case UFC_MISSMATCH_ARGS:
						rtn_result(YYASP(3).text, "():̎ނ܂B");
						YYACCEPT;
						break;

					case UFS_NOTFOUNDDLL:
						rtn_result(YYASP(1).args->v.text, ":w肳ꂽDLL܂B");
						YYACCEPT;
						break;

					case UFS_NOTFOUNDDLLFUNC:
						rtn_result(YYASP(1).args->next->v.text, ":w肳ꂽ֐DLLɌ܂B");
						YYACCEPT;
						break;
				}
				
				if (tmp)
					yyval.text = RM(tmp);
				else
					yyval.text = "";
			} break;
case 130:
{ 
				BYTE result;
				char *tmp, *dllname, *funcname, *p;
				struct ARGS a_dll, a_func;

				dllname = malloc(strlen(YYASP(5).text) + 5);
				if (dllname) {
					funcname = _strdup(YYASP(3).text);
					if (funcname) {
						
						strcpy(dllname, YYASP(5).text);
						strcat(dllname, ".dll");
						a_dll.type = UFCT_ARG_STRING;
						a_dll.v.text = dllname;
						a_dll.next = &a_func;

						
						p = strchr(funcname, '$');
						if (p)
							*p = 0;
						a_func.type = UFCT_ARG_STRING;
						a_func.v.text = funcname;
						a_func.next = YYASP(1).args;
						
						tmp = rfunc_CallDll_dd(hSubDlg, &a_dll, &result);
						switch(result) {
							case UFC_UNKNOWN_FUNCNAME:
								rtn_result(YYASP(3).text, "():֐Ⴂ܂B");
								YYACCEPT;
								break;

							case UFC_MISSMATCH_ARGS:
								rtn_result(YYASP(3).text, "():̎ނ܂B");
								YYACCEPT;
								break;

							case UFS_NOTFOUNDDLL:
								rtn_result(YYASP(5).text, ":w肳ꂽDLL܂B");
								YYACCEPT;
								break;

							case UFS_NOTFOUNDDLLFUNC:
								rtn_result(YYASP(3).text, ":w肳ꂽ֐DLLɌ܂B");
								YYACCEPT;
								break;
						}
						
						if (tmp)
							yyval.text = RM(tmp);
						else
							yyval.text = "";
							
						safefree(funcname);
						safefree(dllname);
					}
					else {
						safefree(dllname);
						rtn_result(YYASP(3).text, ":Ȃ߁Aspł܂B");
						YYACCEPT;
					}
				}
				else {
					rtn_result(YYASP(3).text, ":Ȃ߁Aspł܂B");
					YYACCEPT;
				}
			} break;
case 131:
{ yyval.text = YYASP(0).text; } break;
case 132:
{
				YYASP(2).args->next = YYASP(0).args;
				yyval.args = YYASP(2).args;
			} break;
case 133:
{	yyval.args = YYASP(0).args;	} break;
case 134:
{	yyval.args = NULL;	} break;
case 135:
{
				struct ARGS *arg = (struct ARGS *)RM(malloc(sizeof(struct ARGS)));
				arg->next = NULL;
				arg->type = UFCT_ARG_INT;
				arg->v.integer = YYASP(0).dval;
				yyval.args = arg;				
			} break;
case 136:
{
				struct ARGS *arg = (struct ARGS *)RM(malloc(sizeof(struct ARGS)));
				arg->next = NULL;
				arg->type = UFCT_ARG_STRING;
				arg->v.text = YYASP(0).text;
				yyval.args = arg;
			} break;
case 137:
{
				struct ARGS *arg = (struct ARGS *)RM(malloc(sizeof(struct ARGS)));
				arg->next = NULL;
				arg->type = UFCT_ARG_INTS;
				arg->v.text = YYASP(2).text;
				yyval.args = arg;
			} break;
case 138:
{
				struct ARGS *arg = (struct ARGS *)RM(malloc(sizeof(struct ARGS)));
				arg->next = NULL;
				arg->type = UFCT_ARG_STRINGS;
				arg->v.text = YYASP(2).text;
				yyval.args = arg;
			} break;

	    }
#endif /* !YYACTFUN */
	    if (yyssp >= yysstk + YYMAXDEPTH) {
		yyerror("parser stack overflow");
		return (2);
	    }
	    yyasp -= yyl;
	    yyssp -= yyl;
	    yystate = yygbase[yyn = yyleft[yyn]] + *yyssp;
	    if (yystate < 0 || YYLAST <= yystate
		|| (yystate = yynext[yystate]) >= YYNSTATES
		|| -yycheck[yystate] != yyn)
		yystate = yydefgoto[yyn];
	    *++yyssp = yystate;
	    *++yyasp = yyval;
	} else {
	    /* error */
	    switch (yyerrflag) {
	    case 0:
	    yyerrlab:
		yyerror("syntax error");
	    case 1:
	    case 2:
		yyerrflag = 3;
		for (;;) {
		    yyn = yybase[yystate] + YYERRTOK;
		    if (0 <= yyn && yyn < YYLAST) {
			if ((yyn = yynext[yyn]) < YYNSTATES
			    && yycheck[yyn] == YYERRTOK)
			    break;
			if (yyn - YYPASS == YYERRTOK)
			    goto yyskip;
		    }
		    if (yystate < YY2TABSTATES
			&& (yyn = yybase2[yystate] + YYERRTOK) >= 0
			&& yyn < YYLAST
			&& (yyn = yynext[yyn]) < YYNSTATES
			&& yycheck[yyn] == YYERRTOK)
			break;
		yyskip:
		    if (yyssp <= yysstk)
			return (1);
		    yystate = *--yyssp;
		    yyasp--;
		    YYTRACE_POP();
		}
		YYTRACE_SHIFT(YYERRTOK);
		*++yyssp = yystate = yyn;
		++yyasp;
		break;

	    case 3:
		YYTRACE_DISCARD();
		if (yychar == 0)
		    return (1);
		yychar = -1;
		break;
	    }
	}
    }
}
