// MainStatusBar.cpp :
// Xe[^Xo[ɑ郁bZ[W

#include "stdafx.h"
#include "RNSF7.h"
#include "MainWindow.h"
#include "MainNavigator.h"
#include "MainListview.h"
#include "commfunc.h"

static WNDPROC OrgStatusBarProc;
static 

// Xe[^Xo[ɑ郁bZ[W
LRESULT CALLBACK NewStatusBarProc(HWND hWnd, UINT mes, WPARAM wParam, LPARAM lParam)
{
	switch (mes) {
		case WM_MOUSEMOVE:
			MoveMouseOnNavigator( GetParent(hWnd), -1, -1 );
			break;
	}

	return (CallWindowProc(OrgStatusBarProc, hWnd, mes, wParam, lParam));
}

// Xe[^Xo[̐
HWND createStatusBar( HWND hWnd )
{
	HWND hStatusBar;

	hStatusBar = CreateStatusWindow(WS_CHILD | WS_VISIBLE | (ccpu32_GetComCtl32Ver()>=471?SBT_TOOLTIPS:0), "NĂ܂...", hWnd, ID_STATUSBAR);

	OrgStatusBarProc = (WNDPROC)GetWindowLongPtr(hStatusBar, GWLP_WNDPROC);
	SetWindowLongPtr(hStatusBar, GWLP_WNDPROC, (LONG_PTR)NewStatusBarProc); // bZ[W󂯎邽߂̃tbN

	

	if (GetTickCount()%7 == 0) {
		int aWidths[2] = {500, -1};

		SendMessage(hStatusBar, SB_SETPARTS, (WPARAM)2, (LPARAM)aWidths);
		SendMessage(hStatusBar, SB_SETTEXT, (WPARAM)(SBT_POPOUT | 1), (LPARAM)"ߣƭ̢̨ޯAzPv]ێv]҂Ă܂");
		SendMessage(hStatusBar, SB_SETICON, (WPARAM)1, (LPARAM)hIconMail);
		SendMessage(hStatusBar, SB_SETTIPTEXT, (WPARAM)1, (LPARAM)"ߣƭ̢̨ޯAzPv]ێv]҂Ă܂");
	}

	return hStatusBar;
}

// Xe[^Xo[ɕ\
LRESULT setStatusBarText( const char *text, short level )
{
	static char *lasttext;

	if ( text == NULL ) { // textNULLAȂĂ\Ƃ̕ݒ
		int sel_n = GetLVCursor( hMainListView );
		if ( sel_n < 0 || wLVStyle == 0 ) { // Xgr[ɃJ[\uĂȂA\X^Cuڍׁvł
			text = bCategory?"̶ú؈ꗗ番ޖIËꗗҏWڂJ܂ܰތ(Ctrl+K)ɂi݂ł܂":
				             "ݒҏWڂJĉBL[[h(Ctrl+K)ɂi荞݂ł܂B";
		}
		else {
			text = mlvi[(int)lvGetLParam(hMainListView, sel_n)].info;
		}
	}

	{ //if ( ccpu32_GetComCtl32Ver() >= 471 ) {
		SendMessage(hStatusBar, SB_SETTIPTEXT, 0, (LPARAM)text);
	}

	if ( lasttext ) {
		if ( 0 == strcmp( lasttext, text ) ) { // Oɕ\eLXgƁA\悤ƂeLXg牽Ȃ
			return 0;
		}
		safefree( lasttext );
	}
    
	lasttext = _strdup( text );
	return SendMessage(hStatusBar, SB_SETTEXT, level==1?SBT_NOBORDERS:level==2?SBT_POPOUT:0, (LPARAM)text);
}

// Xe[^Xo[ɁAj[ڂ̃wv̂߂̕\
bool setStatusBarHelp( UINT uItem )
{
	const char *ptext = NULL;

	switch( uItem ) {
		case ID_SETTINGS_OPEN:
			ptext = "ݑIĂݒ荀ڂҏW܂B";
			break;

		case ID_SETTINGS_FILEOPEN:
			ptext = "XNvgt@CIĕҏW_CAOJA_CAOԒ`t@CIđKp܂B";
			break;

		case ID_SETTINGS_SETTING:
			ptext = SOFTWARENAME"g̐ݒҏW܂BRnsf7.rscKvłB";
			break;

		case ID_SETTINGS_HISTORY:
			ptext = SOFTWARENAME"̕ҏW_CAOȊÕ_CAO̗t̗͗ҏW܂BR7hist.rscKvłB";
			break;

		case IDSAVE:
			ptext = "̋@\ڂ̃_CAOԂꊇĎwtH_֕ۑ܂B";
			break;

		case IDLOAD:
			ptext = "̋@\ڂ̃_CAOԂꊇĎwtH_ǂݏo܂B";
			break;

		case ID_SETTINGS_OPENDIR:
			ptext = "XNvgꗗ̑{stH_(Rnsf7.exêtH_)J܂B";
			break;

		case ID_SETTINGS_REBOOTWINDOWS:
			ptext = (((isNT || winver >= 490) && rnsf7RegRead("QReboot", 0))?"݂̃[U[OIt܂Bݒ肪LɂȂȂꍇɗpĉB":"WindowsċN܂Bݒ肪LɂȂȂƂȂǂɎgpĉB");
			break;

		case ID_SETTINGS_REFRESH:
			ptext = "ACȒ傫uύXāAVFɕ\̍XV𑣂܂B";
			break;

		case ID_SETTINGS_NOTIFY:
			ptext = "̃^XNWM_SETTINGSCHANGEbZ[Wu[hLXg܂B";
			break;

		case SC_CLOSE:
		case IDM_SETTINGS_EXIT:
			ptext = SOFTWARENAME"I܂B";
			break;

		case IDC_CONTROLPANEL:
			ptext = "Windows̈ʓIȐݒύXł܂B";
			break;

		case ID_TOOLS_REGEDIT:
			ptext = "WXg𒼐ڕҏW܂B";
			break;

		case ID_TOOLS_KEYREGEDIT:
			ptext = "WXgL[w肵āAWXg GfB^J܂B";
			break;

		case ID_TOOLS_SYSEDIT:
			ptext = "VXe GfB^NAAutoexec.bat, Config.sys, Win.ini, System.ini𒼐ڕҏW܂B";
			break;

		case ID_TOOLS_MSCONFIG:
			ptext = "VXe\[eBeB(Msconfig)N܂BX^[gAbvAT[rX}ł܂B";
			break;

		case ID_TOOLS_WIN7GM:
			ptext = "Windows̊Ǘ@\W񂵂uGodModevĂяo܂B";
			break;

		case ID_TOOLS_BACKUPREGISTRY:
			ptext = "WXgobNAbvc[Ăяo܂B";
			break;

		case ID_TOOLS_RESTOREREGISTRY:
			ptext = "\ȂAȑOɂƂWXg̃obNAbv𕜌c[Ăяo܂(܂́AWXg̎菇܂)B";
			break;

		case ID_TOOLS_SYSTEMRESTORE:
			ptext = "uVXe̕vĂяoA_̏dvt@C̃obNAbv쐬A肵܂B";
			break;

		case ID_TOOLS_MAKERPXP:
			ptext = "u"SOFTWARENAME"vƂ̂̕|Cg쐬܂B";
			break;

		case ID_TOOLS_OPTIMIZEREGISTRY:
			ptext = "WXg̏Cs܂(܂́AWXgC菇܂)B";
			break;

		case ID_TOOLS_LOGOFF:
			ptext = "݂̃[U[烍OIt܂̓TCAEg܂Bݒ肪LɂȂȂꍇȂǂɎgp܂B";
			break;

		case ID_TOOLS_REBOOT:
			ptext = "WindowsċN܂Bݒ肪LɂȂȂꍇȂǂɗp܂B";
			break;

		case ID_TOOLS_FORCEREBOOT:
			ptext = "ʏ̍ċN܂ȂꍇɁAIvVtōċNs܂B";
			break;

		case ID_TOOLS_SHUTDOWN:
			ptext = "WindowsI܂B";
			break;

		case IDM_HELP_HELP:
			ptext = "wvJ܂BRnsf7.chmKvłB";
			break;

		case IDHELP_RSCRIPT:
			ptext = "R-Script("SOFTWARENAME"̊e@\ڂ\XNvg)ɊւwvJ܂BRnsf7.chmKvłB";
			break;

		case IDHELP_DOCLIB:
			ptext = "hLgCu(wv̒mE)J܂BRnsf7.chmKvłB";
			break;

		case IDM_FEEDBACK:
			ptext = "҂֘AAzAPv]邢͌ێv]ȂǂCyɑ肽ꍇɗp܂BC^[lbgڑKvłB";
			break;

		case ID_HELP_GOWEBSITE:
			ptext = "INASOFTWebTCgJ܂BOSɕWݒ肳ꂽWebuEUKvłB";
			break;

		case ID_HELP_UPDATECHECK:
			ptext = "C^[lbgoRŁAŐV́u"SOFTWARENAME"vJĂ邩ǂmF܂B";
			break;

		case ID_HELP_UPDATECHECKSET:
			ptext = "C^[lbgoR̍XVmF@\Ɋւݒs܂BR7update.rscKvłB";
			break;

		case IDM_HELP_KIFU:
			ptext = "Jx̎tɂďڍׂ\܂B";
			break;

		case ID_HELP_CCPU:
			ptext = "p̊Ɋւ(CCPU)\܂B҂ɏQ񍐂⎿oۂɂpB";
			break;

		case IDM_HELP_ABOUT:
			ptext = "̃vOɊւE쌠EӎȂǂ\܂B";
			break;

		case ICO_LARGE:
			ptext = "eҏWڂ傫ACRƖOŕ\܂B";
			break;
		case ICO_SMALL:
			ptext = "eҏWڂACRƖOŕ\܂B";
			break;
		case ICO_LIST:
			ptext = "eҏWڂ̖Oꗗ\܂B";
			break;
		case ICO_REPORT:
			ptext = "eҏWڂ̐\܂B";
			break;
		case IDM_VIEW_RELOAD:
			ptext = "ݒ荀ڂ̈ꗗAJgtH_ǂݏo܂B";
			break;

		case IDM_VIEW_ITEM:
			ptext = "EBhE̍ڂAږŕבւ܂B";
			break;

		case IDM_VIEW_INFORMATION:
			ptext = "EBhE̍ڂAŕבւ܂B";
			break;

		case IDM_VIEW_FILE:
			ptext = "EBhE̍ڂAt@Cŕבւ܂B";
			break;

		case IDM_VIEW_TIME:
			ptext = "EBhE̍ڂAŏIXVŕבւ܂B";
			break;

		case IDM_VIEW_SIZE:
			ptext = "EBhE̍ڂATCYŕבւ܂B";
			break;

		case IDM_VIEW_AUTHOR:
			ptext = "EBhE̍ڂAҖŕבւ܂B";
			break;

		case IDM_VIEW_AUTOCOLUMN:
			ptext = "ڍו\̃JAeJ̍ڂ̍ő̒ŎIɒ܂B";
			break;

		case IDM_VIEW_FIRSTITEMFILE:
			ptext = "ڍו\̑1(̕\@ł͕\鍀ڂ̂)t@Cɂ܂B";
			break;

		case IDM_VIEW_GROUPVIEW:
			ptext = "JeSŃO[vĕ\܂B";
			break;

		case IDM_VIEW_LISTBOX:
			ptext = "@\ڂJeSɕނĕ\܂B";
			break;

		case IDM_VIEW_NAVIGATOR:
			ptext = "CEBhE̍ɁA@\ڂ̐⑀쓙\܂B";
			break;

		case IDM_FIND:
			ptext = "ꗗɕ\ł邷ׂĂ̋@\ڂ̃XNvgA܂B";
			break;

		case IDM_SEARCH:
			ptext = "S@\ڂL[[hs܂B1ȏ̕ɂi荞݂ł܂B";
			break;

		case IDM_ITEMHELP:
			ptext = "̕ҏWڂ̃wv\܂B";
			break;

		case ID_ITEMWEB:
			ptext = "̕ҏWڂJĂWebTCgJ܂B";
			break;

		case IDM_HELP_RNSF7T:
			ptext = "`[gA܂͊O񋟂̃wvJ܂BĂяo\ȃt@C̈ꗗƗD揇ʂ́AwvQƂĉB";
			break;

		case ID_ITEMEDIT:
			{ REG reg;
				if ( reg.OpenKey( HKEY_CLASSES_ROOT, "rscfile\\shell\\edit\\command" ) ) {
					ptext = "̕ҏWڂ̃XNvgҏW܂B";
					reg.CloseKey();                            
				}
				else {
					ptext = "j[́uݒvuIvVv́ursct@CҏWAvP[Vvݒ肷ƁÃj[p\ɂȂ܂B";
				}
			}							
			break;

		case IDM_VIEWSOURCE:
			ptext = "̕ҏWڂ̃XNvgƕ\܂BIncludeŎw肳ꂽt@Cɑĕ\܂B";
			break;

		case IDM_ITEMPROP:
			ptext = "̕ҏWڂɊւvpeB\܂B";
			break;

		case IDM_FAVORITE_ADD:
			ptext = "ݑI𒆂̋@\ڂACɓɉ܂B";
			break;

		case IDM_FAVORITE_EDIT:
			ptext = "CɓҏW(ǉ/C/폜)܂Bł͈ꗗɕ\Ȃ@\ڂ̒ǉł܂BR7fav.rscKvłB";
			break;

		case IDM_CREATESHORTCUT:
			ptext = "fXNgbvɂ̕ҏWڂ𒼐ڊJ߂̃V[gJbg쐬܂B";
			break;

		case SC_SIZE:
			ptext = "EBhẼTCYύX܂B";
			break;
		case SC_MAXIMIZE:
			ptext = "EBhEő剻܂B";
			break;
		case SC_MINIMIZE:
			ptext = "EBhEŏă^XNo[̒ɓ܂B";
			break;
		case SC_RESTORE:
			ptext = "EBhE̍ő剻/ŏÃTCYɖ߂܂B";
			break;
		case SC_MOVE:
			ptext = "EBhËʒuύX܂B";
			break;

		default:
			{
				UINT i;

				for(i=ID_RECENT_1 ; i<=ID_RECENT_10 ; i++) {
					if ( uItem == i ) {
                        ptext = "ŋߎg@\ڂĂяo܂B";
						break;
					}
				}

				if ( ptext == NULL ) {
					for(i=IDM_FAVORITE_001 ; i<=IDM_FAVORITE_100 ; i++) {
						if ( uItem == i ) {
							ptext = "o^ꂽ@\ڂĂяo܂B";
							break;
						}
					}
				}
			}
			break;
	}

	if ( ptext ) {
		setStatusBarText( ptext, 1 );
		return false;
	}
	else {
        return true; // T[`AEg
	}
}
