// MainMenu.cpp :
// CEChẼXgr[

#include "stdafx.h"
#include "RNSF7.h"
#include "MainWindow.h"
#include "MainListview.h"
#include "commfunc.h"
#include "helpdlg.h"
#include "MainNavigator.h"

static WNDPROC OrgMainListViewProc;
short wLVStyle;						// Xgr[̃X^C
bool bLVFirstItemFile; // Xgr[̑1ڂt@Cɂ
bool bLVGroupView;		// O[vĕ\
HWND hBar  = NULL;	// Xgr[ƃJeSr[uĂo[
HWND hBarh = NULL;	// JeSr[ƃirQ[^uĂo[
int  lbdx  = 0;		// JeSƃXgr[̊Ԃ̃o[hbOĂƂAo[̍[ƃ}EXʒu̍i0̂ƂFhbOԁj
int  lbdy  = 0;		// JeSƃirQ[^̊Ԃ̃o[hbOĂƂAo[̏[ƃ}EẌʒu̍i0̂ƂFhbOԁj
int  iBarVx = -1, iBarHy = -1; // WXgǂݏoꂽo[ʒu

// Xgr[ŉꂽEnterL[Ԃǂ
LRESULT CALLBACK NewMainListViewProc(HWND hWnd, UINT mes, WPARAM wParam, LPARAM lParam)
{
	switch (mes) {
		case WM_KEYDOWN:
			switch( wParam ) {
				case VK_RETURN:
					SendMessage( GetParent(hWnd), WM_COMMAND, ID_SETTINGS_OPEN, 0 );
					break;

				case VK_TAB:
				case VK_ESCAPE:
					if ( bCategory && hCategoryTreeView ) {
						SetFocus( hCategoryTreeView );
					}
					break;
			}
			break;

		case WM_LBUTTONUP:
			SendMessage( GetParent(hWnd), mes, wParam, lParam );
			break;

		case WM_MOUSEMOVE:
			{
				HWND hParent = GetParent(hWnd);
				POINT po;
				po.x = LOWORD(lParam);  // horizontal position of cursor 
				po.y = HIWORD(lParam);  // vertical position of cursor 

				ClientToScreen(hWnd, &po);
				rebarMove( hParent, (int)wParam, &po );
				MoveMouseOnNavigator( hParent, -1, -1 );
			}
			break;
	}

	return (CallWindowProc(OrgMainListViewProc, hWnd, mes, wParam, lParam));
}

const char *columntext[6] = { "", "", "t@C", "ŏIXV", "TCY", "Җ" };

// CXgr[̍쐬
HWND createListView(HWND hWnd)
{
	REG	reg;
	LV_COLUMN	lvColumn;
	HIMAGELIST	himlSmall;
	HIMAGELIST  himlLarge;
	int			i;
	HWND		hMainListView;

	hMainListView = CreateWindowEx(WS_EX_CLIENTEDGE, WC_LISTVIEW, "ListView",
				                   WS_TABSTOP | WS_CHILD | WS_VISIBLE | LVS_AUTOARRANGE | LVS_REPORT | LVS_SINGLESEL | LVS_SHOWSELALWAYS,
								   0, 0, 0, 0, hWnd, (HMENU)IDC_LISTVIEW, hInst, NULL);
	if( !hMainListView ) {
		return NULL;
	}

	// ACRXgr[̃C[Wɒǉ
	himlSmall = ImageList_Create(16, 16, ILC_COLOR32 /*ILC_COLORDDB */ | ILC_MASK, ItemCount, 0);
	for(i=0 ; i<ItemCount ; i++) {
		ImageList_AddIcon(himlSmall, mlvi[i].hSmallIcon ? mlvi[i].hSmallIcon :
	                                 mlvi[i].hicon      ? mlvi[i].hicon      :
	                                                      hDefaultRscSmallIcon);
	}
	ListView_SetImageList(hMainListView, himlSmall, LVSIL_SMALL);

	// 傫ACRXgr[̃C[Wɒǉ
	himlLarge = ImageList_Create(32, 32, ILC_COLOR32 /*ILC_COLORDDB */ | ILC_MASK, ItemCount, 0);
	for(i=0 ; i<ItemCount ; i++) {
		ImageList_AddIcon(himlLarge, mlvi[i].hicon      ? mlvi[i].hicon      :
	                                 mlvi[i].hSmallIcon ? mlvi[i].hSmallIcon :
	                                                      hDefaultRscIcon);
	}
	ListView_SetImageList(hMainListView, himlLarge, LVSIL_NORMAL);

	lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT;
	// 
	lvColumn.fmt = LVCFMT_LEFT;
	lvColumn.pszText = (LPSTR)( bLVFirstItemFile?columntext[2]:columntext[0] );
	lvColumn.cx = bLVFirstItemFile?120:150; // ̒l
	ListView_InsertColumn(hMainListView, 0, &lvColumn);
	lvColumn.pszText = (LPSTR)( bLVFirstItemFile?columntext[0]:columntext[1] );
	lvColumn.cx = bLVFirstItemFile?150:405; // ̒l
	ListView_InsertColumn(hMainListView, 1, &lvColumn);
	lvColumn.pszText = (LPSTR)( bLVFirstItemFile?columntext[1]:columntext[2] );
	lvColumn.cx = bLVFirstItemFile?405:120; // ̒l
	ListView_InsertColumn(hMainListView, 2, &lvColumn);
	lvColumn.pszText = (LPSTR)columntext[3];
	lvColumn.cx = 120; // ̒l
	ListView_InsertColumn(hMainListView, 3, &lvColumn);

	// E
	lvColumn.fmt = LVCFMT_RIGHT;
	lvColumn.pszText = (LPSTR)columntext[4];
	lvColumn.cx = 120; // ̒l
	ListView_InsertColumn(hMainListView, 4, &lvColumn);

	// 
	lvColumn.fmt = LVCFMT_LEFT;
	lvColumn.pszText = (LPSTR)columntext[5];
	lvColumn.cx = 150; // ̒l
	ListView_InsertColumn(hMainListView, 5, &lvColumn);

	{ //if (ccpu32_GetComCtl32Ver() >= 471) { // comctl32.dll̃o[W4.71ȍ~ȂAinfotipt悤ɂ
		ListView_SetExtendedListViewStyleEx(hMainListView, LVS_EX_INFOTIP /*| LVS_EX_BORDERSELECT*/, LVS_EX_INFOTIP /*| LVS_EX_BORDERSELECT*/);
	}

	// \
	showListView(hMainListView, -1);

	// 1ڂւ̃J[\̃ZbgƁAJTCY̎
	if (ItemCount > 0) {
		ListView_SetItemState(hMainListView, 0, LVIS_FOCUSED, LVIS_FOCUSED);
		for(i=0 ; i<NUMCOLUMN ; i++) {
			ListView_SetColumnWidth(hMainListView, i, LVSCW_AUTOSIZE);
		}
	}

	// WXgɃJ̃TCYꍇ́AD
	if ( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY) ) {
		char lvColumnWidthValue[30];

		// Xgr[̊eJ̃TCY
		for(i=0 ; i<NUMCOLUMN ; i++) {
			int s;

			wsprintf( lvColumnWidthValue, "lvColumnWidth%d", i );

			s = reg.ReadInteger(lvColumnWidthValue, (DWORD)LVSCW_AUTOSIZE);
			ListView_SetColumnWidth(hMainListView, i, s);
		}
		reg.CloseKey();
	}

	OrgMainListViewProc = (WNDPROC)GetWindowLongPtr(hMainListView, GWLP_WNDPROC);
	SetWindowLongPtr(hMainListView, GWLP_WNDPROC, (LONG_PTR)NewMainListViewProc); // Enter, TABL[󂯎邽߂̃tbN

	return hMainListView;
}

// Xgr[̕\iJeSj
void showListView(HWND hListview, int cn)
{
	int i, j, n;
	LVITEM_XP lvitem;
	char szTimeDate[80];
	SYSTEMTIME st;

	// ACeEO[vAListViewRg[փACe
	ListView_DeleteAllItems(hListview);
	if (winver >= 501) ListView_RemoveAllGroups(hListview);
	ListView_SetItemCount(hListview, ItemCount);

	if ( mlvi ) {
		if (winver >= 501 && categorys) { // O[v\̂߂̏
			LVGROUP lvgGroup;
			for(n=0 ; categorys[n] ; ++n) {
				ZeroMemory(&lvgGroup, sizeof(lvgGroup));
				lvgGroup.cbSize = sizeof(lvgGroup);
				lvgGroup.mask = LVGF_GROUPID | LVGF_HEADER;
				lvgGroup.iGroupId = n;
				lvgGroup.pszHeader = mb2wc(categorys[n]);
				if (lvgGroup.pszHeader) {
					lvgGroup.cchHeader = lstrlenW(lvgGroup.pszHeader) * sizeof(wchar_t);
					ListView_InsertGroup(hListview, n, &lvgGroup);
					free(lvgGroup.pszHeader);
				}
			}
		}

		for(i=j=0 ; i<ItemCount ; i++) {
			if ( cn == -1 || ( cn == -2 && mlvi[i].foundflag == 1 ) || categorys[cn] == 0 || mlvi[i].category == categorys[cn] ) {
				ZeroMemory(&lvitem, sizeof(lvitem));
				lvitem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
				lvitem.iImage = i;
				lvitem.iItem = j;
				lvitem.iSubItem = 0;
				lvitem.pszText = bLVFirstItemFile?mlvi[i].rsc_fname:mlvi[i].item;
				lvitem.lParam = (LPARAM)i; // \[gp
				lvitem.state = (j==0) ? LVIS_FOCUSED : 0;
				lvitem.stateMask = LVIS_FOCUSED;
				if (winver >= 501 && categorys) { // O[v\̂߂̏
					lvitem.mask |= LVIF_GROUPID;
					// ނĂJeS̔ԍ𒲂ׂ
					for(n=0 ; categorys[n] ; ++n) {
						if (strcmp(mlvi[i].category, categorys[n]) == 0) {
							lvitem.iGroupId = n;
						}
					}
				}
				ListView_InsertItem(hListview, (LVITEM *)&lvitem);
				ListView_SetItemText(hListview, j, 1, bLVFirstItemFile ? mlvi[i].item : mlvi[i].info);
				ListView_SetItemText(hListview, j, 2, bLVFirstItemFile ? mlvi[i].info : mlvi[i].rsc_fname);

				// VXe^CɕϊĂ當ɕϊ
				FileTimeToSystemTime(&(mlvi[i].ft), &st);
				// t͕K2(1̏ꍇ0𓪂ɎĂ)ŕ\BXy[XƋl܂̂ŁAڏdiGNXv[̕\`ɍ킹Ăj
				wsprintf(szTimeDate, "%04d/%02d/%02d %2d:%02d:%02d", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wDay );
				ListView_SetItemText(hListview, j, 3, szTimeDate);

				// t@CTCY͕ɕϊĂi[
				char itbuf[16];

				if ( 0 == _ultoa_s(mlvi[i].fsize, itbuf, _countof(itbuf), 10) ) {
					ListView_SetItemText(hListview, j, 4, itbuf);
				}

				// Җ
				ListView_SetItemText(hListview, j, 5, mlvi[i].author);

				j++;
			}
		}
	}
}

// Xgr[\[g
int CALLBACK pfnCompare(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	switch( (int)lParamSort ) {
		case LVORDER_NAME_ASC:  // O
			return _stricmp(mlvi[(int)lParam1].item, mlvi[(int)lParam2].item);
		case LVORDER_NAME_DESC: // Ot
			return -_stricmp(mlvi[(int)lParam1].item, mlvi[(int)lParam2].item);
		case LVORDER_INFO_ASC:	// 
			return _stricmp(mlvi[(int)lParam1].info, mlvi[(int)lParam2].info);
		case LVORDER_INFO_DESC: // t
			return -_stricmp(mlvi[(int)lParam1].info, mlvi[(int)lParam2].info);
		case LVORDER_FILE_ASC:  // t@C
			return _stricmp(mlvi[(int)lParam1].rsc_fname, mlvi[(int)lParam2].rsc_fname);
		case LVORDER_FILE_DESC: // t@Ct
			return -_stricmp(mlvi[(int)lParam1].rsc_fname, mlvi[(int)lParam2].rsc_fname);
		case LVORDER_DATE_ASC:  // ^CX^v
			return CompareFileTime(&(mlvi[(int)lParam1].ft), &(mlvi[(int)lParam2].ft));
		case LVORDER_DATE_DESC: // ^CX^vt
			return -CompareFileTime(&(mlvi[(int)lParam1].ft), &(mlvi[(int)lParam2].ft));
		case LVORDER_SIZE_ASC:  // TCY
			return (int)mlvi[(int)lParam1].fsize - (int)mlvi[(int)lParam2].fsize;
		case LVORDER_SIZE_DESC: // TCYt
			return (int)mlvi[(int)lParam2].fsize - (int)mlvi[(int)lParam1].fsize;
		case LVORDER_AUTH_ASC:  // ҏ
			return _stricmp(mlvi[(int)lParam1].author, mlvi[(int)lParam2].author);
		case LVORDER_AUTH_DESC: // ҋt
			return -_stricmp(mlvi[(int)lParam1].author, mlvi[(int)lParam2].author);
	}
	return 1;
}

// Xgr[̍ڂ̃\[gJn : n - בւ@( 0 ŁAݎw肳ꂽя )
LRESULT startListviewSort( HWND hwndListView, int n )
{
	int last_n = rnsf7RegRead("LastSort", 3);
	int i;
	char new_columntext[20];

	if (n == 0) {
		n = last_n;
	}
	else {
		if (n == last_n && n != LVORDER_GROUPVIEW) {
			n = -n;
		}

		rnsf7RegWrite("LastSort", n);
	}

	for(i=1 ; i<=6 ; i++) {
		lstrcpy(new_columntext, columntext[i-1]);
		if (i == n) {
            lstrcat(new_columntext, " ");
		}
		else if (i == -n) {
			lstrcat(new_columntext, " ");
		}

		LVCOLUMN lvc;

		ZeroMemory(&lvc, sizeof(LVCOLUMN));
		lvc.mask = LVCF_TEXT;
		lvc.pszText = new_columntext;
		// lvc.cchTextMax = sizeof(new_columntext); - ̃o͂ł͎g܂B
		if (bLVFirstItemFile) { // 1ԖڂɃt@CĂ
			if (i == 1)
				ListView_SetColumn(hwndListView, 1, &lvc);
			else if (i == 2)
				ListView_SetColumn(hwndListView, 2, &lvc);
			else if (i == 3)
				ListView_SetColumn(hwndListView, 0, &lvc);
			else
				ListView_SetColumn(hwndListView, i-1, &lvc);
		}
		else
			ListView_SetColumn(hwndListView, i-1, &lvc);
	}

	if (n == LVORDER_GROUPVIEW && winver >= 501) {
		return ListView_EnableGroupView(hwndListView, TRUE);
	}
	else {
		if (winver >= 501) ListView_EnableGroupView(hwndListView, FALSE);
		return ListView_SortItems(hwndListView, (PFNLVCOMPARE)pfnCompare, (LPARAM)n);
	}
}

// w肳ꂽ iImage Xgr[̔ԍԂ
int  search_iImage(HWND hwndListView, int iImage)
{
	int n, i;
	LVITEM item;

	if ( hwndListView ) {
		n = ListView_GetItemCount( hwndListView );
		item.mask = LVIF_IMAGE;
		item.iSubItem = 0;
		for(i=0 ; i<n ; i++) {
			item.iItem = i;
			ListView_GetItem(hwndListView, &item);
			if ( item.iImage == iImage ) {
				return i;
			}
		}
	}

	return -1;
}

// o[̃TCY
bool rebarMove( HWND hMainWindow, int fwKeys, POINT *po )
{
	RECT rc, rch;

	if ( lbdx != 0 ) {
		if ( hBar && (fwKeys & MK_LBUTTON) ) {
			ScreenToClient(hMainWindow, po);
			if ( po->x-lbdx > RBAR_WIDTH ) {
				SetWindowPos( hBar, 0, po->x-lbdx, 0, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
			}
			else {
				SetWindowPos( hBar, 0, RBAR_WIDTH, 0, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
			}
			InvalidateRect( hBar, NULL, TRUE );
			SetCursor(LoadCursor(NULL, IDC_SIZEWE));
			return true;
		}
		else {
			ReleaseCapture();
			lbdx = 0;
		}
	}
	else if ( lbdy != 0 ) {
		if ( hBarh && (fwKeys & MK_LBUTTON) ) {
			ScreenToClient(hMainWindow, po);
			if ( po->y-lbdy > RBAR_WIDTH ) {
				SetWindowPos( hBarh, 0, 0, po->y-lbdy, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
			}
			else {
				SetWindowPos( hBarh, 0, 0, RBAR_WIDTH, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
			}
			InvalidateRect( hBarh, NULL, TRUE );
			SetCursor(LoadCursor(NULL, IDC_SIZENS));
			return true;
		}
		else {
			ReleaseCapture();
			lbdy = 0;
		}
	}
	if ( hBar ) {
		GetWindowRect(hBar, &rc);
	}
	else {
		ZeroMemory( &rc, sizeof(rc) );
	}
	if ( hBarh ) {
		GetWindowRect(hBarh, &rch);
	}
	else {
		ZeroMemory( &rch, sizeof(rch) );
	}

	if ( rc.left < po->x && po->x < rc.right && rc.top < po->y && po->y < rc.bottom ) {
		SetCursor(LoadCursor(NULL, IDC_SIZEWE));
		return true;
	}
	else if ( rch.left < po->x && po->x < rch.right && rch.top < po->y && po->y < rch.bottom ) {
		SetCursor(LoadCursor(NULL, IDC_SIZENS));
		return true;
	}
	else {
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		return false;
	}
}

// Xgr[̃TCY
void resizeListView(HWND hParent, HWND hListCategory, HWND hStatusBar, HWND hListView)
{
	RECT  rc, rc2, rc3, rcb, rcbh;

	if ( hParent && hStatusBar && hListView ) {
		if ( IsIconic(hParent) ) { // ACR(^XNo[Ɏ[)ĂAȂɂȂ
			return;
		}

		GetClientRect(hParent, &rc);
		GetClientRect(hStatusBar, &rc2);

		// o[̃TCY
		if ( hBar ) {
			GetWindowRect(hBar, &rcb);
			POINT po;
			po.x = rcb.left; po.y = rcb.top;
			ScreenToClient( hParent, &po );
			rcb.left = po.x; rcb.top = po.y;
		}
		else {
			rcb.left = (iBarVx == -1 ? 128 : iBarVx);
		}
		// ľ
		if ( rcb.left < RBAR_WIDTH ) {
			rcb.left = RBAR_WIDTH;
		}
		else if ( rcb.left > 32000 ) {
			rcb.left = RBAR_WIDTH;
		}
		else if ( rcb.left > rc.right-RBAR_WIDTH*4 ) {
			rcb.left = rc.right - RBAR_WIDTH*4;
		}

		// co[̃TCY
		if ( hBarh ) {
			GetWindowRect(hBarh, &rcbh);
			POINT po;
			po.x = rcbh.left; po.y = rcbh.top;
			ScreenToClient( hParent, &po );
			rcbh.left = po.x; rcbh.top = po.y;
		}
		else{
			rcbh.top = (iBarHy == -1 ? rc.bottom / 2 : iBarHy);
		}
		// ľ
		if ( rcbh.top < RBAR_WIDTH ) {
			rcbh.top = RBAR_WIDTH;
		}
		else if ( rcbh.top > 32000 ) {
			rcbh.top = RBAR_WIDTH;
		}
		else if ( rcbh.top > rc.bottom-rc2.bottom-RBAR_WIDTH*4 ) {
			rcbh.top = rc.bottom - rc2.bottom - RBAR_WIDTH*4;
		}

		if ( hListCategory ) { // JeS\ĂꍇiirQ[^ꍇ܂ށj
			rc3.left = rc.left;
			rc3.top = rc.top;
			rc3.right = rcb.left;
			rc3.bottom = rc.bottom - rc.top - (rc2.bottom - rc2.top); // ł͏cTCYvZĂ
			if ( bNavigator ) {
				// AJeS{bNXƓɃirQ[^pĂ悤ȂAJeS{bNX̍𔼕ɂB
				rc3.bottom = rcbh.top;
			}

			rc.left += rc3.right; // CXgr[̕\ʒu炷
		}
		else if ( bNavigator ) { // irQ[^PƂŕ\Ăꍇ
			rc.left += rcb.left; // CXgr[̕\ʒu炷
		}

		if ( !hListCategory && !bNavigator ) { // JeSirQ[^\ĂȂꍇ
			if ( hBar ) {
				DestroyWindow( hBar );
				hBar = NULL;
				iBarVx = -1;
			}
		}
		else { // JeSirQ[^\Ăꍇ
			if ( hBar ) {
                MoveWindow( hBar, rcb.left, 0, RBAR_WIDTH, rc.bottom - rc.top - (rc2.bottom - rc2.top), FALSE );
				SetWindowLongPtr( hBar, GWL_STYLE, WS_CHILD|WS_VISIBLE );
				InvalidateRect( hBar, NULL, TRUE );
			}
			else {
				hBar = CreateWindow("STATIC", "", WS_CHILD|WS_VISIBLE, rc.left, 0, RBAR_WIDTH, rc.bottom - rc.top - (rc2.bottom - rc2.top), hParent, (HMENU)IDC_STATIC, hInst, NULL);
			}
			rc.left += RBAR_WIDTH;
		}

		if ( hListCategory && bNavigator ) { // JeSƃirQ[^\Ăꍇ
			if ( hBarh ) {
                MoveWindow( hBarh, 0, rcbh.top, rc3.right, RBAR_WIDTH, FALSE );
				SetWindowLongPtr( hBarh, GWL_STYLE, WS_CHILD|WS_VISIBLE );
				InvalidateRect( hBarh, NULL, TRUE );
			}
			else {
				hBarh = CreateWindow("STATIC", "", WS_CHILD|WS_VISIBLE, 0, rc3.bottom, rc3.right, RBAR_WIDTH, hParent, (HMENU)IDC_STATIC, hInst, NULL);
			}
		}
		else { // JeSirQ[^̕Е\ĂꍇA܂́AJeSirQ[^\ĂȂꍇ
			if ( hBarh ) {
				DestroyWindow( hBarh );
				hBarh = NULL;
				iBarHy = -1;
			}
		}

		if ( hListCategory ) { // JeS\ĂꍇiirQ[^ꍇ܂ށj
			// JeS̕\ʒum
			MoveWindow(hListCategory, rc3.left, rc3.top, rc3.right, rc3.bottom, TRUE);
		}

		// Xgr[̕\ʒum
		MoveWindow(hListView, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top - (rc2.bottom - rc2.top), TRUE);
	}
}

// wvĂяo(WinHelp)
bool callhelp( HWND hWnd, const char *helpfile, UINT contextid )
{
	int i;

	if ( helpfile == NULL || helpfile[0] == 0 || _stricmp(helpfile, "none" ) == 0 )
		return false;

	if ( _stricmp(helpfile, "dynamic") == 0 ) {
		HWND rhWnd = helpdoc_open( hWnd, 0 );
		return rhWnd ? true : false;
	}

	i = lstrlen( helpfile );
	if ( _stricmp( &helpfile[i-4], ".HLP" ) == 0 ) {
		if ( !WinHelp(hWnd, helpfile, HELP_CONTEXT, contextid) )
			return false;
	}
	else {
		char cdir[MAX_PATH*2];

		GetCurrentDirectory( _countof(cdir), cdir );
		if ( (HINSTANCE)32 >= ShellExecute( hWnd, "open", helpfile, NULL, cdir, SW_SHOWNORMAL) ) {
			MessageBox(hWnd, "wvĂяo܂B", szTitle, MB_OK | MB_ICONSTOP);
			return false;
		}
	}

	return true;
}

// wvĂяo(HtmlHelp)
bool callhelp2(HWND hWnd, const char *htmlfile)
{
	char hhurl[MAX_PATH*2];

	if ( htmlfile ) {
		wsprintf(hhurl, _T(".\\RNSF7.CHM::/_RESOURCE/%s"), htmlfile);
		// Helpfile.chm::/Html/Overview/Topic.htm[>Window name] `
	}
	else {
		lstrcpy(hhurl, _T(".\\RNSF7.CHM"));
	}

	if ( HtmlHelp(hWnd, hhurl, HH_DISPLAY_TOPIC, NULL) ) {
		return TRUE;
	}
	else {
		// sÁAwvJĂŒ
		return FALSE;
	}
}
