#include "stdafx.h"

#include "context.h"
#include "openarc.h"

// IDLL̏
static const char *dllexts[] = {".lzh", ".zip", ".7z", NULL};

// _CAÕAJ[Ɋւ
const DLGITEM dlgitems[] = {
	{IDC_STATIC1,    ANCHOR_TOPLEFT},
	{IDC_RADIO_LZH,  ANCHOR_TOPLEFT},
	{IDC_RADIO_ZIP,  ANCHOR_TOPLEFT},
	{IDC_RADIO_7Z,   ANCHOR_TOPLEFT},
	{IDC_STATIC2,    ANCHOR_TOPLEFT},
	{IDC_STATIC4,    ANCHOR_TOPRIGHT},
	{IDC_STATIC5,    ANCHOR_TOPRIGHT},
	{IDC_SELFORM_LZH,ANCHOR_TOPRIGHT},
	{IDC_SELFORM_ZIP,ANCHOR_TOPRIGHT},
	{IDC_SELFORM_7Z, ANCHOR_TOPRIGHT},
	{IDC_CHECK_MT,   ANCHOR_TOPRIGHT},
	{IDC_EDIT1,      ANCHOR_TOPLEFTRIGHT},
	{IDC_BUTTON_BROWSE,   ANCHOR_TOPRIGHT},
	{IDC_STATIC3,    ANCHOR_TOPLEFT},
	{IDC_EDIT_FILES, ANCHOR_CENTER},
	{IDC_BUTTON_CLEAR,ANCHOR_TOPRIGHT},
	{IDC_BUTTON_BROWSE_FILE,   ANCHOR_BOTTOMRIGHT},
	{IDC_BUTTON_BROWSE_FOLDER, ANCHOR_BOTTOMRIGHT},
	{IDC_CHECK_NOTCLOSE, ANCHOR_BOTTOMLEFT},
	{IDC_CHECK_FINISHMESSAGE, ANCHOR_BOTTOMLEFT},
	{IDC_COMBO_SHUTDOWN, ANCHOR_BOTTOMLEFT},
	{IDC_STATIC_PASSWORD, ANCHOR_BOTTOMLEFTRIGHT},
	{IDC_EDIT_PASSWORD, ANCHOR_BOTTOMLEFTRIGHT},
	{IDOK,   ANCHOR_BOTTOMRIGHT},
	{IDCANCEL, ANCHOR_BOTTOMRIGHT},
	{IDHELP, ANCHOR_BOTTOMRIGHT},
	{0,0}
};

// {^̏Ƀ}EX悹Ƃ̏
static const struct DEFTOOLTIP oa_tooltips[] = {
	{IDC_RADIO_LZH, "Unlha32.dllpāAlzh`̈kt@C̍쐬s܂Bk̃t@C̊gqexeɂ΁Aȉ𓀏ɂ쐬\ł"},
	{IDC_RADIO_ZIP, "zip32j.dll, zip32.dllpāAzip`̈kt@C̍쐬s܂Bk̃t@C̊gqexeɂ΁Aȉ𓀏ɂ쐬\ł"},
	{IDC_RADIO_7Z,  "7-zip32.dllpāA7-zipzip`̈kt@C̍쐬s܂Bk̃t@C̊gqexeɂ΁Aȉ𓀏ɂ쐬\ł"},
	{IDC_SELFORM_LZH,"k`I܂Bʏ́ulh5(W)v݂̂IłBʂȎƂ̂݁AIĉ"},
	{IDC_SELFORM_ZIP,"kI܂BʓIɈkȂ΁AԂȂ܂"},
	{IDC_SELFORM_7Z, "kI܂BʓIɈkȂ΁AԂȂ܂"},
	{IDC_CHECK_MT,  "p\ł΁A}`Xbhł̈ks܂"},
	{IDC_BUTTON_BROWSE, "k̃t@C͂邽߂̂_CAOJ܂"},
	{IDC_BUTTON_CLEAR,         "kΏۃt@C̓͗NA܂"},
	{IDC_BUTTON_BROWSE_FILE,   "kΏۂ̃t@CꗗIł܂"},
	{IDC_BUTTON_BROWSE_FOLDER, "kΏۂ̃tH_ꗗIł܂"},
	{IDC_EDIT_PASSWORD, "zip܂7-zip`̃t@C(ȉ𓀏ɂ)pX[htō쐬ꍇɁApX[h͂܂"},
	{IDC_CHECK_NOTCLOSE, "kɁA_CAO͓̓eėpĎ̎sł܂"},
	{IDC_CHECK_FINISHMESSAGE, "kIꍇbZ[W_CAO\܂"},
	{IDC_COMBO_SHUTDOWN, "kI̓ݒ肵܂"},
	{IDOK,     "kJn܂"},
	{IDCANCEL, "̃_CAO܂"},
	{IDHELP,   "̃_CAOɊւwv\܂"},
	{0,0}};

// k_CAÖkt@C̗Ǘ
static ComboboxQueue *cbq;

// OpenArchiver̃_CAOŁAݑI𒆂DLLԂ
static int selectedDll( HWND hDlg )
{
	if ( BST_CHECKED == SendDlgItemMessage(hDlg, IDC_RADIO_ZIP, BM_GETCHECK, 0, NULL) ) {
		return OET_ZIP;
	}
	else if ( BST_CHECKED == SendDlgItemMessage(hDlg, IDC_RADIO_7Z, BM_GETCHECK, 0, NULL) ) {
		return OET_7Z;
	}
	return OET_LZH;
}

// I𒆂̃A[JCoɂAR{{bNX̓eςAMultiThread`FbN肷
static void hide_listbox_change_ext( HWND hDlg )
{
	int iDll = selectedDll(hDlg);

	switch( iDll ) {
		case OET_LZH:
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_LZH), SW_SHOW);
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_ZIP), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_7Z ), SW_HIDE);
			EnableWindow(GetDlgItem(hDlg, IDC_CHECK_MT), FALSE);
			break;

		case OET_ZIP:
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_LZH), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_ZIP), SW_SHOW);
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_7Z ), SW_HIDE);
			EnableWindow(GetDlgItem(hDlg, IDC_CHECK_MT), FALSE);
			break;

		case OET_7Z:
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_LZH), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_ZIP), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_SELFORM_7Z ), SW_SHOW);
			EnableWindow(GetDlgItem(hDlg, IDC_CHECK_MT), TRUE);
			break;

		default:
			return;
	}

	// kt@C͂ĂāAgqA
	// E.exe,
	// EݑI𒆂dllΉgq(.lzh, .zip, 7z)
	// ̂ǂłȂꍇAgq␳B
	{
		char arcname[MAX_PATH*2];
		char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], fnamebase[_MAX_FNAME*2], fext[_MAX_EXT*2];
		const char *c_ext = dllexts[iDll];

		if ( 1 < GetDlgItemText(hDlg, IDC_EDIT1, arcname, _countof(arcname)) ) {
			_splitpath_s(arcname, drv, _countof(drv), dir, _countof(dir), fnamebase, _countof(fnamebase), fext, _countof(fext));
			if (lstrcmpi(fext, ".exe") != 0 && lstrcmpi(fext, c_ext) != 0) {
				// gqւ
				_makepath_s(arcname, _countof(arcname), drv, dir, fnamebase, c_ext);
				SetDlgItemText(hDlg, IDC_EDIT1, arcname);
			}
		}
	}
}

static LPCSTR DlgProc_ShowOutputDlg_szMessage;
static LPCSTR DlgProc_ShowOutputDlg_szTitle;
static LPCSTR DlgProc_ShowOutputDlg_szOutput;
static int    DlgProc_ShowOutputDlg_flag;

// A[JCoDLL̏o̓bZ[W\邽߂̃_CAO
static LRESULT CALLBACK DlgProc_ShowOutputDlg( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch( message ) {
		case WM_INITDIALOG:
			{
				LPSTR iKindIcon = 0;

				// flag\ׂACR̎ނm
				if ( DlgProc_ShowOutputDlg_flag & MB_ICONINFORMATION ) {
					iKindIcon = IDI_INFORMATION;
				}
				else if ( DlgProc_ShowOutputDlg_flag & MB_ICONQUESTION ) {
					iKindIcon = IDI_QUESTION;
				}
				else if ( DlgProc_ShowOutputDlg_flag & MB_ICONEXCLAMATION ) {
					iKindIcon = IDI_WARNING;
				}
				else if ( DlgProc_ShowOutputDlg_flag & MB_ICONSTOP ) {
					iKindIcon = IDI_ERROR;
				}

				// WACRǂݏoĐݒ
				if ( iKindIcon ) {
					HICON hIcon = LoadIcon(NULL, iKindIcon);
					if ( hIcon ) {
						SendDlgItemMessage(hDlg, IDC_STATIC_ICON, STM_SETICON, (WPARAM)hIcon, NULL);
					}
				}

				// bZ[W\
				SetWindowText(GetDlgItem(hDlg, IDC_STATIC_TEXT), DlgProc_ShowOutputDlg_szMessage);

				// ^Cgo[ݒ
				SetWindowText(hDlg, DlgProc_ShowOutputDlg_szTitle);

				// o̓bZ[Wݒ
				SetWindowText(GetDlgItem(hDlg, IDC_OUTPUTLOG), DlgProc_ShowOutputDlg_szOutput);

				// J[\ԍŌɈړ
				SendDlgItemMessage(hDlg, IDC_OUTPUTLOG, EM_LINESCROLL, 0, lstrlen(DlgProc_ShowOutputDlg_szOutput));
				SendDlgItemMessage(hDlg, IDC_OUTPUTLOG, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
			}
			break;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDCANCEL:
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
			}
			break;
	}
    return FALSE;	
}

// o̓_CAO̕\
INT_PTR ShowOutputDlg( HWND hDlg, LPCSTR szMessage, LPCSTR szTitle, LPCSTR szOutput, int flag )
{
	DlgProc_ShowOutputDlg_szMessage = szMessage ? szMessage : "";
	DlgProc_ShowOutputDlg_szTitle   = szTitle   ? szTitle   : "";
	DlgProc_ShowOutputDlg_szOutput  = szOutput  ? szOutput  : "";
	DlgProc_ShowOutputDlg_flag      = flag;

	return DialogBox(hInst, (LPCTSTR)IDD_OUTPUTDLG, NULL, (DLGPROC)DlgProc_ShowOutputDlg);
}

// xxbc̃_CAÕbZ[WJX^}CY
static char *shutdown_countdown_message = "?";
static char *shutdown_button_message = "?";

// xxb_CAÕvV[W
LRESULT CALLBACK DlgProc_sleepBeforeShutdown( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	static UINT uCount;

	switch( message ) {
		case WM_INITDIALOG:
			{
				char buf[100];

				uCount = 20;
				wsprintf( buf, shutdown_countdown_message, uCount );
				SetDlgItemText( hDlg, IDC_STATIC_SLEEP, buf );
				SetDlgItemText( hDlg, IDOK, shutdown_button_message );

				SetTimer( hDlg, SLP_TIMERID, 1000, NULL );
			}
			return TRUE;

		case WM_TIMER:
			if ( (int)wParam == SLP_TIMERID ) {
				if ( uCount-- > 0 ) {
					char buf[100];

					wsprintf( buf, shutdown_countdown_message, uCount );
					SetDlgItemText( hDlg, IDC_STATIC_SLEEP, buf );
				}
				else {
					KillTimer( hDlg, SLP_TIMERID );
					EndDialog( hDlg, IDOK );
				}
			}
			return TRUE;

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					KillTimer( hDlg, SLP_TIMERID );
					EndDialog( hDlg, IDOK );
					return TRUE;

				case IDCANCEL:
					KillTimer( hDlg, SLP_TIMERID );
					EndDialog( hDlg, IDCANCEL );
					return TRUE;

				case IDC_PAUSE: // ꎞ~
					if ( SendDlgItemMessage(hDlg, IDC_PAUSE, BM_GETCHECK, 0, 0) == BST_CHECKED ) {
						KillTimer( hDlg, SLP_TIMERID );
					}
					else {
						SetTimer( hDlg, SLP_TIMERID, 1000, NULL );
					}
					return TRUE;
			}
			break;
	}
    return FALSE;
}

// hbOhbvkpEBhEp_CAOvV[W̃`FbN{bNX̊^񊈐Ǘ
void DlgProc_OpenArchiver_CheckDisable( HWND hDlg )
{
	BOOL bFlag;

	// _CAOȂƂAVbg_E͂łȂ
	// IbZ[W\ƂAVbg_E͂łȂ
	if (SendDlgItemMessage(hDlg, IDC_CHECK_NOTCLOSE, BM_GETCHECK, 0, 0) == BST_CHECKED ||
		SendDlgItemMessage(hDlg, IDC_CHECK_FINISHMESSAGE, BM_GETCHECK, 0, 0) == BST_CHECKED ) {
		bFlag = FALSE;
	}
	else {
		bFlag = TRUE;
	}
	EnableWindow(GetDlgItem(hDlg, IDC_COMBO_SHUTDOWN), bFlag);
	if ( bFlag == TRUE ) {
		// Vbg_EƂA_CAOȂ^bZ[W̕\͂łȂ
		if (SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_GETCURSEL, 0, 0) != 0) {
			bFlag = FALSE;
		}
		else {
			bFlag = TRUE;
		}
		EnableWindow(GetDlgItem(hDlg, IDC_CHECK_NOTCLOSE), bFlag);
		EnableWindow(GetDlgItem(hDlg, IDC_CHECK_FINISHMESSAGE), bFlag);
	}
}

// kt@C͂ĂȂꍇ́A툳kt@C玩
// hWnd  : _CAOEChEnh
// fname : kΏۂ̃t@CŜA\̂́B̃t@C̊gqւāA
//         kt@Ĉ̖쐬B
static bool automake_compressedfilename(HWND hWnd, const char *fname)
{
	// kt@C͂ĂȂꍇ
	if ( GetWindowTextLength(GetDlgItem(hWnd, IDC_EDIT1)) == 0 ) {
		// kt@Cix[XjEhCuEfBNg
		char compname[_MAX_FNAME*2];
		char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2];
		char compressedfname[MAX_PATH*2];

		// IĂ鈳kpDLL̕Wgq͉H
		const char *ext = dllexts[selectedDll(hWnd)];
	
		// kt@C̐ƕҏW{bNXւ̑
		_splitpath_s(fname, drv, _countof(drv), dir, _countof(dir), compname, _countof(compname), NULL, 0);
		_makepath_s(compressedfname, _countof(compressedfname), drv, dir, compname, ext);
        SetDlgItemText(hWnd, IDC_EDIT1, compressedfname);

		return true;
	}

	return false;
}

// GNXv[t@Chbv
// (hbvꂽt@CAҏW{bNX(IDC_EDIT_FILES)ɗ)
static bool oa_DropFiles(HWND hWnd, HDROP hDrop)
{
	char fname[MAX_PATH*2];	// kΏۃt@Ci[郏[NGApϐ

	// hbvꂽEBhEwʂɉBƂȂ̂ŁA܂͋Iɕ\
	SetForegroundWindow(hWnd);

	// ҏW{bNXA݂̔툳kt@C̃Xg擾
	// (񓊓ꂽt@C̃XǵǍɒǉ)
	int iFileListSize = GetWindowTextLength(GetDlgItem(hWnd, IDC_EDIT_FILES)) + 1;
	char *pszFileList = (char *)calloc(iFileListSize, sizeof(char)); // Xg擾pm

	if ( !pszFileList ) {
		DragFinish(hDrop);
		MessageBox(hWnd, "Ƃ𑱍s邽߂̃܂B", "-k-", MB_OK | MB_ICONSTOP);
		return false;
	}
	GetDlgItemText(hWnd, IDC_EDIT_FILES, pszFileList, iFileListSize);
	string strFileList(pszFileList);

	// pszFileListłȂAŌ̕\nŏIĂȂꍇ́A\r\nǉ
	if (iFileListSize > 1 && pszFileList[iFileListSize-2] != '\n') {
		strFileList.append("\r\n");
	}

	safefree(pszFileList);

	// hbOhbvꂽt@C̐𓾂
	UINT n = DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);

	// hbOhbvꂽt@CApszFileListɒǉĂi؂\r\nj
	for(UINT i=0 ; i<n ; ++i) {
		DragQueryFile(hDrop, i, fname, _countof(fname));
		strFileList.append(fname);
		strFileList.append("\r\n");

		if (i == 0) {
			// kt@C͂ĂȂꍇ́A1Ԗڂ̔툳kt@C玩
			// (hbvꂽŏ̃t@C̖OAgqւ`ňkt@C𐶐)
			automake_compressedfilename(hWnd, fname);
		}
	}

	// hbvɍۂ鏈̏I
	DragFinish(hDrop);

	// ҏW{bNXɁAt@CQ̕߂
	SetDlgItemText(hWnd, IDC_EDIT_FILES, strFileList.c_str());
	// J[\ԍŌɈړ
	SendDlgItemMessage(hWnd, IDC_EDIT_FILES, EM_LINESCROLL, 0, strFileList.length()-1);
	SendDlgItemMessage(hWnd, IDC_EDIT_FILES, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
	// tH[JXҏW{bNXֈړ
	SetFocus(GetDlgItem(hWnd, IDC_EDIT_FILES));

	return true;
}

// ut@CQƁv{^
static bool oa_SelectFiles(HWND hWnd)
{
	OPENFILENAME ofn;
	char fname[MAX_PATH*2*64];

	ZeroMemory(fname, _countof(fname));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.lpstrFilter = "ׂẴt@C(*.*)\0*.*\0\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrCustomFilter = (LPSTR) NULL;
	ofn.nMaxCustFilter = 0L;
	ofn.lpstrFile = fname;
	ofn.nMaxFile = _countof(fname);
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = "kΏۂ̃t@CI";
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_ALLOWMULTISELECT | OFN_EXPLORER;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = NULL; 

	if ( GetOpenFileName(&ofn) ) {
		// ҏW{bNXA݂̔툳kt@C̃Xg擾
		int iFileListSize = GetWindowTextLength(GetDlgItem(hWnd, IDC_EDIT_FILES)) + 1;
		char *pszFileList = (char *)calloc(iFileListSize, sizeof(char)); // Xg擾pm

		if ( !pszFileList ) {
			MessageBox(hWnd, "Ƃ𑱍s邽߂̃܂B", "-k-", MB_OK | MB_ICONSTOP);
			return false;
		}
		GetDlgItemText(hWnd, IDC_EDIT_FILES, pszFileList, iFileListSize);
		string strFileList(pszFileList);

		// pszFileListłȂAŌ̕\nŏIĂȂꍇ́A\r\nǉ
		if (iFileListSize > 1 && pszFileList[iFileListSize-2] != '\n') {
			strFileList.append("\r\n");
		}

		safefree(pszFileList);

		// t@Cǉ鏈

		// t@C͕I邱ƂAPIIŏB
		//   PȈꍇ cc tpX\0\0
		//   Ȉꍇ cc tH_\0t@CP\0t@CQ\0...t@C\0\0
		// ܂AtH_́A[gtH_Ȃ\AȊOł͕tȂ

		// p APvf̂wBꂪ\0Ȃ΁AtpXPŏIƌȂ
		char *p = fname + lstrlen(fname) + 1;

		if ( *p == '\0' ) {
			// P̃tpX
			strFileList.append(fname);
			strFileList.append("\r\n");

			// kt@C͂ĂȂꍇ́A툳kt@C玩
			// (QƓ͂ꂽt@C̖OAgqւ`ňkt@C𐶐)
			automake_compressedfilename(hWnd, fname);
		}
		else {
			// ̃pX c fname:tH_, p:t@C
			char fullpath[MAX_PATH*2];
			bool firstflag = true;

			while(*p) {
				_makepath_s(fullpath, _countof(fullpath), NULL, fname, p, NULL);
				strFileList.append(fullpath);
				strFileList.append("\r\n");
				p += (lstrlen(p)+1);

				if (firstflag) {
					// kt@C͂ĂȂꍇ́A1Ԗڂ̔툳kt@C玩
					// (QƓ͂ꂽŏ̃t@C̖OAgqւ`ňkt@C𐶐)
					automake_compressedfilename(hWnd, fullpath);
					firstflag = false;
				}
			}
		}

		// ҏW{bNX
		SetDlgItemText(hWnd, IDC_EDIT_FILES, strFileList.c_str()); 
		// J[\ԍŌɈړ
		SendDlgItemMessage(hWnd, IDC_EDIT_FILES, EM_LINESCROLL, 0, strFileList.length()-1);
		SendDlgItemMessage(hWnd, IDC_EDIT_FILES, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
		// tH[JXҏW{bNXֈړ
		SetFocus(GetDlgItem(hWnd, IDC_EDIT_FILES));
	}

	return true;
}

// utH_QƁv{^
static bool oa_SelectFolder(HWND hWnd)
{
	BOOL         bRes;
	LPITEMIDLIST pidlRetFolder;
	BROWSEINFO   stBInfo;
	char         foldername[MAX_PATH*2];

	//@\̂܂B
	stBInfo.pidlRoot = NULL;	// [gtH_
	stBInfo.hwndOwner = hWnd;	// \_CAO̐eEBhẼnh
	stBInfo.pszDisplayName = foldername;	// tH_擾obt@̃|C^
	stBInfo.lpszTitle = "tH_I";	// _CAO̒ɕ\镶
	stBInfo.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;	//\tO
	stBInfo.lpfn = NULL;
	stBInfo.lParam = 0L;

	//@_CAO{bNX\܂B
	pidlRetFolder = SHBrowseForFolder( &stBInfo );

	if( pidlRetFolder != NULL ) {
		//@tpX擾܂B
		bRes = SHGetPathFromIDList( pidlRetFolder, foldername );
		CoTaskMemFree( pidlRetFolder );	
		if ( bRes == TRUE ) {
			// ҏW{bNXA݂̔툳kt@C̃Xg擾
			int iFileListSize = GetWindowTextLength(GetDlgItem(hWnd, IDC_EDIT_FILES)) + 1;
			char *pszFileList = (char *)calloc(iFileListSize, sizeof(char)); // Xg擾pm

			if ( !pszFileList ) {
				MessageBox(hWnd, "Ƃ𑱍s邽߂̃܂B", "-k-", MB_OK | MB_ICONSTOP);
				return false;
			}
			GetDlgItemText(hWnd, IDC_EDIT_FILES, pszFileList, iFileListSize);
			string strFileList(pszFileList);

			// pszFileListłȂAŌ̕\nŏIĂȂꍇ́A\r\nǉ
			if (iFileListSize > 1 && pszFileList[iFileListSize-2] != '\n') {
				strFileList.append("\r\n");
			}

			safefree(pszFileList);

			// tH_ǉ
			strFileList.append(foldername);
			strFileList.append("\r\n");

			// kt@C͂ĂȂꍇ́A툳ktH_玩
			// (QƓ͂ꂽtH_̖OAgqt`ňkt@C𐶐)
			automake_compressedfilename(hWnd, foldername);

			// ҏW{bNXɖ߂
			SetDlgItemText(hWnd, IDC_EDIT_FILES, strFileList.c_str()); 

			// J[\ԍŌɈړ
			SendDlgItemMessage(hWnd, IDC_EDIT_FILES, EM_LINESCROLL, 0, strFileList.length()-1);
			SendDlgItemMessage(hWnd, IDC_EDIT_FILES, EM_SETSEL, (WPARAM)-1, (LPARAM)-1);
			// tH[JXҏW{bNXֈړ
			SetFocus(GetDlgItem(hWnd, IDC_EDIT_FILES));
			return true;
		}
	}
	return false;
}

// ukJnv{^
static bool CallArchive(HWND hWnd)
{
	// IĂ鈳kpDLL̕Wgq͉H
	int         selDll        = selectedDll(hWnd);
	const char *p_default_ext = dllexts[selDll];
	char        szOldCurrentDir[MAX_PATH*2];

	// kΏۂ̃t@C󂾂ꍇ
	if ( GetWindowTextLength(GetDlgItem(hWnd, IDC_EDIT_FILES)) == 0 ) {
		MessageBox(hWnd, "kΏۂ̃t@Cw肵ĂB", "-k-", MB_OK | MB_ICONEXCLAMATION);
		return false;
	}

	// t@C͂ĂāAgqWƈقȂĂꍇ́A
	// gq̂܂܂ł悢AmFB
	char arcfile[MAX_PATH*2];
	{
		char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], fname[_MAX_FNAME*2], fext[_MAX_EXT*2];
		
		GetDlgItemText(hWnd, IDC_EDIT1, arcfile, _countof(arcfile));
		if ( arcfile[0] == 0 ) {
			MessageBox(hWnd, "kt@Cw肵ĂB", "-k-", MB_OK | MB_ICONEXCLAMATION);
			return false;
		}

		_splitpath_s(arcfile, drv, _countof(drv), dir, _countof(dir), fname, _countof(fname), fext, _countof(fext));

		if (fext[0] != 0 && _stricmp(fext, ".exe") != 0 && _stricmp(fext, p_default_ext) != 0 &&
			!(selDll == OET_ZIP && (_stricmp(fext, ".jar") == 0 || _stricmp(fext, ".xpi") == 0))  &&
			!(selDll == OET_7Z && (_stricmp(fext, ".zip") == 0 || _stricmp(fext, ".jar") == 0 || _stricmp(fext, ".xpi") == 0)) ) {
			// gq̏ꍇ́AƂ⊮邩ǂƂāA
			// exe(ȉ)łȂAWgqłȂꍇ͊mFKvB
			// AselDll  OET_ZIP ̏ꍇAjar  xpi  OK
			//                   OET_7Z  ̏ꍇAzip, jar, xpi OK
			char mes[100];

			wsprintf(mes, "kt@C̊gqA%słȂA.exeł܂B%sɕ␳܂?",
						  p_default_ext, p_default_ext);
			switch( MessageBox(hWnd, mes, "-k-", MB_YESNOCANCEL | MB_ICONQUESTION) ) {
				case IDYES:
					// gq̕␳s
					_makepath_s(arcfile, _countof(arcfile), drv, dir, fname, p_default_ext);
					SetDlgItemText(hWnd, IDC_EDIT1, arcfile);
					break;

				case IDCANCEL:
					// k̎
					return false;
			}
		}
	}

	// R{{bNXɓo^	
	cbq->Add(arcfile);

	// JnÕJgfBNg擾
	GetCurrentDirectory(_countof(szOldCurrentDir), szOldCurrentDir);

	char   arcfile2[MAX_PATH*2];
	char   respname[MAX_PATH*2], tmppath[MAX_PATH*2] ,lzhname_wexe[MAX_PATH*2];
	char   password[MAX_PATH*2];
	int    fnl;
	bool   notclose = 0;
	bool   finmessage = 0;
	int    iAfter = 0;
	bool   abort = 0;
	HANDLE handle;
	REG    reg;

	// _CAOԂ̒o
	notclose   = (BST_CHECKED == SendDlgItemMessage(hWnd, IDC_CHECK_NOTCLOSE, BM_GETCHECK, 0, NULL))?1:0;
	finmessage = (BST_CHECKED == SendDlgItemMessage(hWnd, IDC_CHECK_FINISHMESSAGE, BM_GETCHECK, 0, NULL))?1:0;
	if (finmessage == 0) {
		iAfter = (int)SendDlgItemMessage(hWnd, IDC_COMBO_SHUTDOWN, CB_GETCURSEL, 0, NULL);
	}

	GetDlgItemText(hWnd, IDC_EDIT_PASSWORD, password, _countof(password));
	if (strlen(password) > 0) {
		if (selDll == OET_LZH) {
			password[0] = 0;
			MessageBox(hWnd, "LHAł̓pX[h͈܂BpX[hw͖܂B", "-k-", MB_OK | MB_ICONWARNING);
		}
		else {
			if (strchr(password, ' ') != NULL || strchr(password, '"') != NULL) {
				MessageBox(hWnd, "pX[hɂ̓Xy[X_uR[eBV͎g܂B", "-k-", MB_OK | MB_ICONERROR);
				return false;
			}
		}
	}

	// Vbg_EꍇA{ɂł悢mF
	if ( iAfter != 0 ) {
		char *p;
		switch(iAfter) {
			case 1:
				p = "kɃRs[^Vbg_E܂B낵ł?";
				break;

			case 2:
				p = "kɃRs[^ċN܂B낵ł?";
				break;

			case 3:
				p = "kɃRs[^TXyh܂B낵ł?";
				break;

			case 4:
				p = "kɃRs[^x~Ԃɂ܂B낵ł?";
				break;

			default:
				p = "?";
				break;
		}
		if ( IDYES != MessageBox(hWnd, p, "-k-", MB_YESNO | MB_ICONQUESTION) ) {
			return false;
		}
	}

	// e|tH_ɃX|Xt@C쐬
	GetTempPath(_countof(tmppath), tmppath);
	GetTempFileName(tmppath, "lh", 0, respname);

	lstrcpy(arcfile2, arcfile); // _CAO爳k̃t@CF

	if ( arcfile[0] == '-' && selDll == OET_ZIP ) {
		if ( IDYES != MessageBox(hWnd, "IĂA[JCoł́ApnCt(-)Ŏn܂t@C舵ƂłȂ\܂Bs܂?", "-k-", MB_YESNO | MB_ICONQUESTION) ) {
			return false;
		}
	}

	// X|Xt@C̍쐬
	if ( INVALID_HANDLE_VALUE != (handle = CreateFile(respname, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) ) {
		DWORD wtn;
		char  mfile[_MAX_PATH*2+4];
		char  fname[_MAX_FNAME*2];
		char  ext[_MAX_EXT*2];
		bool  deldirinfo = 1; // fBNgj邩ǂtO(1:j)

		// kt@C̈ꗗ擾(s؂)
		char *flist;
		char *next, *token;
		int  iFListSize;
		list<string> files;
		list<string>::iterator it;

		iFListSize = GetWindowTextLength(GetDlgItem(hWnd, IDC_EDIT_FILES)) + 1;
		flist = (char *)calloc(iFListSize, sizeof(char));
		if ( flist == NULL ) {
			MessageBox(hWnd, "Ƃ𑱍s邽߂̃܂B", "-k-", MB_OK | MB_ICONSTOP);
			return false;
		}
		GetDlgItemText(hWnd, IDC_EDIT_FILES, flist, iFListSize);
		token = strtok_s(flist, "\r\n", &next);
		while( token ) {
			// t@CɃ_uR[e[Vꍇ͎菜
			if (token[0] == '"') {
				string fname(token + 1);

				list<string>::size_type sz = fname.length();

				if (sz > 0) {
					fname.erase(sz-1);
					files.push_back(fname);
				}
			}
			else {
				files.push_back(token);
			}
			
			token = strtok_s(NULL, "\r\n", &next);
		}
		safefree( flist );

		// kΏۂ̃t@C󂾂ꍇ
		if ( files.empty() ) {
			MessageBox(hWnd, "kΏۂ̃t@Cw肵ĂB", "-k-", MB_OK | MB_ICONEXCLAMATION);
			return false;
		}

		list<string>::iterator its = files.begin();
		list<string>::iterator ite = files.end();

		// ܂ŏɁAJgfBNgZbg
		{ // JgfBNgZbg
			char cdir[MAX_PATH*2], cdir2[MAX_PATH*2];
			char drive[_MAX_DRIVE*2];
			char dir[_MAX_DIR*2];

			it = its;
			_splitpath_s(it->c_str(), drive, _countof(drive), dir, _countof(dir), NULL, 0, NULL, 0);
			_makepath_s(cdir, _countof(cdir), drive, dir, NULL, NULL);
			SetCurrentDirectory( cdir );

			// 2Ԗڈȍ~̃t@C̃fBNgƔrA
			// ׂẴfBNgƓAfBNg͔jB
            // 1łfBNgĂAfBNg͔jȂB
			++it;
			for(; it != ite ; ++it) {
				_splitpath_s(it->c_str(), drive, _countof(drive), dir, _countof(dir), NULL, 0, NULL, 0);
				_makepath_s(cdir2, _countof(cdir2), drive, dir, NULL, NULL);
				if ( _stricmp(cdir2, cdir) != 0 ) {
                    deldirinfo = 0;
					break;
				}
			}
		}

		// t@CX|Xt@Cɏ
		const char *pfname;
		for(it=its ; it != ite ; ++it) {
			// Unlha32gꍇ́At@C̑O -gb 
			if ( selDll == OET_LZH ) {
				WriteFile(handle, "-gb", 3, &wtn, NULL);
			}

			pfname = it->c_str();

			if ( deldirinfo ) {
				// hCuEfBNg͕̕
				_splitpath_s(pfname, NULL, 0, NULL, 0, fname, _countof(fname), ext, _countof(ext));
				_makepath_s(mfile, _countof(mfile), NULL, NULL, fname, ext);

				if ( mfile[0] == '-' && selDll == OET_ZIP ) {
					if ( IDYES != MessageBox(hWnd, "IĂA[JCoł́ApnCt(-)Ŏn܂t@C舵ƂłȂ\܂B̃t@C܂?", mfile, MB_YESNO | MB_ICONQUESTION) ) {
						continue;
					}
				}

				WriteFile(handle, "\"", 1, &wtn, NULL);
				WriteFile(handle, mfile, lstrlen(mfile), &wtn, NULL);
				WriteFile(handle, "\"\r\n", 3, &wtn, NULL);
			}
			else {
				// hCuEfBNg𕪗Ȃ
				if ( pfname[0] == '-' && selDll == OET_ZIP ) {
					if ( IDYES != MessageBox(hWnd, "IĂA[JCoł́ApnCt(-)Ŏn܂t@C舵ƂłȂ\܂B̃t@C܂?", pfname, MB_YESNO | MB_ICONQUESTION) ) {
						continue;
					}
				}

				WriteFile(handle, "\"", 1, &wtn, NULL);
				WriteFile(handle, pfname, lstrlen(pfname), &wtn, NULL);
				WriteFile(handle, "\"\r\n", 3, &wtn, NULL);
			}
		}
		CloseHandle( handle );
	}
	else {
        MessageBox(hWnd, "X|Xt@C܂̓Xgt@C쐬ł܂łB", "-k-", MB_OK | MB_ICONSTOP);
		if ( !notclose ) {
			EndDialog(hWnd, FALSE);
		}
		return false;
	}

	fnl = lstrlen( arcfile );
	if ( selDll != OET_7Z && fnl >= 5 && ( arcfile[fnl-1] == 'e' || arcfile[fnl-1] == 'E' ) && ( arcfile[fnl-2] == 'x' || arcfile[fnl-2] == 'X' ) && ( arcfile[fnl-3] == 'e' || arcfile[fnl-3] == 'E' ) && arcfile[fnl-4] == '.' ) {
		arcfile[fnl-4] = 0;
        fnl = 1; // ȉ𓀏ɂtO
		lstrcpy( lzhname_wexe, arcfile );
		lstrcat( lzhname_wexe, dllexts[selDll] );
	}
	else {
		char drv[_MAX_DRIVE*2], dir[_MAX_DIR*2], fname[_MAX_FNAME*2], fext[_MAX_EXT*2], arcfname[MAX_PATH*2];
		fnl = 0; // ȉ𓀏ɂ͍Ȃ(ʏ̏)

		// ̈kt@C݂ƒǋLɂȂĂ܂߁AłǂǂmF
		_splitpath_s( arcfile, drv, _countof(drv), dir, _countof(dir), fname, _countof(fname), fext, _countof(fext) );
		if ( fext[0] == 0 ) {
			lstrcpy( fext, dllexts[selDll]);
		}                    
		_makepath_s( arcfname, _countof(arcfname), drv, dir, fname, fext );

		if ( tFileExist( arcfname ) ) {
			switch( MessageBox( hWnd, "łɓ̈kt@C݂Ă܂B̂܂܈ksƁÄkt@C֒ǋL܂B낵ł?\n\n[͂]c̈kt@C֒ǋL\n[]c̈kt@C͍폜AVɈkt@C쐬\n[LZ]ck𒆎~", "-k-", MB_ICONQUESTION | MB_YESNOCANCEL ) ) {
				/* case IDYES : break; */ // ȗ
				case IDNO:
					DeleteFile( arcfile );
					break;

				case IDCANCEL:
					abort = 1;
					break;
			}
		}
	}

	if ( abort == 0 ) {
		char szOption[MAX_PATH*2+16] = "";
		int  iSel;
		char szOutputBuf[ARCDLL_OUTBUFSIZE+1];

		if ( !notclose ) {
			// EBhEB
			ShowWindow( hWnd, SW_HIDE );
		}

		ZeroMemory(szOutputBuf, ARCDLL_OUTBUFSIZE+1);
		switch ( selDll ) {
			case OET_ZIP:
				lstrcpy( szOption, "-#" );
				iSel = (int)SendDlgItemMessage(hWnd, IDC_SELFORM_ZIP, CB_GETCURSEL, 0, NULL);
				szOption[1] = '0' + (char)iSel;
				
				if (password[0] != 0) {
					strcat(szOption, " -P ");
					strcat(szOption, password);
				}

				{
					if ( T_TF_SUCCESS != call_zip32j_log(hWnd, arcfile, respname, szOption, szOutputBuf, ARCDLL_OUTBUFSIZE) ) {
						char *szOutputBuf2 = replacestr(szOutputBuf, "\n", "\r\n");
						ShowOutputDlg(hWnd, "kɎsAf܂B", "ZIPňk", szOutputBuf2, MB_ICONSTOP | MB_OK);
						safefree(szOutputBuf2);
					}
					else {
						if ( fnl ) {
							if ( T_TF_SUCCESS != call_zip32_toexe_log(hWnd, lzhname_wexe, szOutputBuf, ARCDLL_OUTBUFSIZE) ) {
								char *szOutputBuf2 = replacestr(szOutputBuf, "\n", "\r\n");
								ShowOutputDlg(hWnd, "ȉ𓀏ɂ̍쐬LZAs܂B", "ZIPňk", szOutputBuf2, MB_ICONSTOP | MB_OK);
								safefree(szOutputBuf2);
							}
							else {
								// ȉ𓀏ɂ֕ϊÕt@C폜
								DeleteFile( lzhname_wexe );

								// gqEXE啶ɂȂĂ܂߁AۂɃ[Uw肵t@CɃl[
								MoveFile(arcfile2, arcfile2);
							}                                                        
						}
						else {
							if ( finmessage ) {
								char *szOutputBuf2 = replacestr(szOutputBuf, "\n", "\r\n");
								ShowOutputDlg(hWnd, "k܂B", "ZIPňk", szOutputBuf2, MB_ICONINFORMATION | MB_OK);
								safefree(szOutputBuf2);
							}
						}
					}
				}
				break;

			case OET_7Z:
				lstrcpy( szOption, "-mx=" );
				iSel = (int)SendDlgItemMessage(hWnd, IDC_SELFORM_7Z, CB_GETCURSEL, 0, NULL);
				switch( iSel ) {
					case 0:
						lstrcat( szOption, "0" );
						break;
					case 1:
						lstrcat( szOption, "1" );
						break;
					case 2:
						lstrcat( szOption, "5" );
						break;
					case 3:
						lstrcat( szOption, "7" );
						break;
					case 4:
						lstrcat( szOption, "9" );
						break;
				}
				if ( BST_CHECKED == SendDlgItemMessage(hWnd, IDC_CHECK_MT, BM_GETCHECK, 0, NULL) ) {
					lstrcat( szOption, " -mmt=on" );
				}
				else {
					lstrcat( szOption, " -mmt=off" );
				}

				if (password[0] != 0) {
					strcat(szOption, " -p");
					strcat(szOption, password);
				}

				// gqexe̎ȉ𓀏ɂ́ACu͂ŌĂ邽߁AŔ蕶͓Ȃ
				if ( T_TF_SUCCESS != call_7zip32r_log(hWnd, arcfile, respname, szOption, szOutputBuf, ARCDLL_OUTBUFSIZE) ) {
					ShowOutputDlg(hWnd, "kɎsAf܂B", "7-ZIPňk", szOutputBuf, MB_ICONSTOP | MB_OK);
				}
				else {
					if ( finmessage ) {
						ShowOutputDlg(hWnd, "k܂B", "7-ZIPňk", szOutputBuf, MB_ICONINFORMATION | MB_OK);
					}
				}
				break;

			default: // LZH`
				lstrcpy( szOption, "-jm" );
				iSel = (int)SendDlgItemMessage(hWnd, IDC_SELFORM_LZH, CB_GETCURSEL, 0, NULL);
				switch( iSel ) {
					case 0:
						lstrcat( szOption, "0" );
						break;
					case 1:
						lstrcat( szOption, "1" );
						break;
					case 2:
						lstrcat( szOption, "2" );
						break;
					case 3:
						lstrcat( szOption, "3" );
						break;
					case 4:
						lstrcat( szOption, "4" );
						break;
					case 5:
						lstrcat( szOption, "a" );
						break;
					case 6:
						lstrcat( szOption, "5" );
						break;
					case 7:
						lstrcat( szOption, "6" );
						break;
					case 8:
						lstrcat( szOption, "7" );
						break;
					case 9:
						lstrcat( szOption, "8" );
						break;
				}
				if ( T_TF_SUCCESS != call_unlha32r_log(hWnd, arcfile, respname, szOption, szOutputBuf, ARCDLL_OUTBUFSIZE) ) {
					ShowOutputDlg(hWnd, "kɎsAf܂B", "LHAňk", szOutputBuf, MB_ICONSTOP | MB_OK);
				}
				else {
					if ( fnl ) {
						if ( T_TF_SUCCESS != call_unlha32_toexe_log(hWnd, arcfile, szOutputBuf, ARCDLL_OUTBUFSIZE) ) {
							ShowOutputDlg(hWnd, "ȉ𓀏ɂ̍쐬LZAs܂B", "LHAňk", szOutputBuf, MB_ICONSTOP | MB_OK);
						}
						else {
							// ȉ𓀏ɂ֕ϊÕt@C폜
							DeleteFile( lzhname_wexe );

							// gqEXE啶ɂȂĂ܂߁AۂɃ[Uw肵t@CɃl[
							MoveFile(arcfile2, arcfile2);
						}                                                        
					}
					else {
						if ( finmessage ) {
							// Ȉꍇ̂݁A_CAOo͑OɃJgfBNg߂
							SetCurrentDirectory(szOldCurrentDir);

							ShowOutputDlg(hWnd, "k܂B", "LHAňk", szOutputBuf, MB_ICONINFORMATION | MB_OK);
						}
					}
				}
				break;
		}
	}

	// JgfBNgɖ߂
	SetCurrentDirectory(szOldCurrentDir);

	// X|Xt@C폜
	DeleteFile( respname );

	// IiJn̎Nȍꍇ́AʂȂj
	if ( abort == 0 ) {
		if ( !notclose ) {
			EndDialog(hWnd, TRUE);
			if ( iAfter ) {
				switch (iAfter) {
					case 1:
						shutdown_countdown_message = " %u bŃVbg_E܂B";
						shutdown_button_message = "ɃVbg_E(&S)";
						break;
					case 2:
						shutdown_countdown_message = " %u bōċN܂B";
						shutdown_button_message = "ɍċN(&S)";
						break;
					case 3:
						shutdown_countdown_message = " %u bŃTXyh܂B";
						shutdown_button_message = "ɃTXyh(&S)";
						break;
					case 4:
						shutdown_countdown_message = " %u bŋx~Ԃɓ܂B";
						shutdown_button_message = "ɋx~Ԃɓ(&S)";
						break;
					default:
						shutdown_countdown_message = "?? [%u]";
						break;
				}

				if ( IDOK == DialogBox(hInst, (LPCTSTR)IDD_COUNTDOWN, NULL, (DLGPROC)DlgProc_sleepBeforeShutdown) ) {
					GetQuitRight();
					switch (iAfter) {
						case 1:
							if ( 0 == ExitWindowsEx(EWX_SHUTDOWN | EWX_POWEROFF, 0) ) {
								MessageBox(hWnd, "Windows̏IɎs܂B", "-k-", MB_OK | MB_ICONSTOP);
							}
							break;
						case 2:
							if ( 0 == ExitWindowsEx(EWX_REBOOT, 0) ) {
								MessageBox(hWnd, "Windows̍ċNɎs܂B", "-k-", MB_OK | MB_ICONSTOP);
							}
							break;
						case 3:
							if ( 0 == SetSystemPowerState( TRUE, FALSE ) ) {
								MessageBox(hWnd, "TXyhɎs܂B", "-k-", MB_OK | MB_ICONSTOP);
							}
							break;
						case 4:
							if ( 0 == SetSystemPowerState( FALSE, FALSE ) ) {
								MessageBox(hWnd, "x~Ԃւ̈ڍsɎs܂B", "-k-", MB_OK | MB_ICONSTOP);
							}
							break;
					}
				}
			}
		}
		else {
			SetDlgItemText(hWnd, IDCANCEL, "(&X)");
		}
	}


	return true;
}

// ҏW{bNX̃TuNXpEBhEvV[W
static WNDPROC re_OldEditProc;

// TvEBhE̕ҏW{bNX̃TuNXpEBhEvV[W
LRESULT CALLBACK re_NewEditProc(HWND hEdit, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch( message ) {
		case WM_CHAR: // SÎ߂ Ctrl+A 󂯎̂
			if( (int)wParam == 1 ) {
				SendMessage( hEdit, EM_SETSEL, (WPARAM)0, (LPARAM)-1 );  
				return 0; // ftHg̃vV[WĂ΂ɂ̂܂܏I
			}
			break;
	}

	// ftHg̃vV[WR[
	return CallWindowProc(re_OldEditProc, hEdit, message, wParam, lParam);
}

// hbOhbvkpEBhEp_CAOvV[W
static LRESULT CALLBACK DlgProc_OpenArchiver( HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam )
{
	static SIZEDLG *sizedlg;

	switch( message ) {
		case WM_INITDIALOG:
			// ݂́A_CAO MS P SVbNŌŒ
			// SetChildWindowFont(hDlg);
			// ^Cgo[̃ACR̐ݒ
			{
				HICON hDialogIcon = (HICON)LoadImage(hInst, (LPCSTR)133, IMAGE_ICON, 0, 0,
					                                 LR_DEFAULTSIZE | LR_SHARED);

				SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_BIG, (LPARAM)hDialogIcon);
				SendMessage(hDlg, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)hDialogIcon);
			}
			{
				REG reg;
				int drvs[3]; // ǂDLLL?(ÝAOET_***ɂ̂܂܊Y)

				drvs[OET_LZH] = call_unlha32(NULL, NULL);
				drvs[OET_ZIP] = call_zip32j(NULL, NULL, NULL, NULL);
				drvs[OET_7Z]  = call_7zip32(NULL, NULL);

				// gps̍ڂOCAEg
				// (DLLLł΁AT_TF_ILLEGALCALLԂĂĂ͂)
				if ( drvs[OET_LZH] != T_TF_ILLEGALCALL ) {
					EnableWindow(GetDlgItem(hDlg, IDC_RADIO_LZH), FALSE);
				}
				if ( drvs[OET_ZIP] != T_TF_ILLEGALCALL ) {
					EnableWindow(GetDlgItem(hDlg, IDC_RADIO_ZIP), FALSE);
				}
				if ( drvs[OET_7Z]  != T_TF_ILLEGALCALL ) {
					EnableWindow(GetDlgItem(hDlg, IDC_RADIO_7Z), FALSE);
				}

				// kɗpDLĹAftHg̑Iݒ
				// (DLLLł΁AT_TF_ILLEGALCALLԂĂĂ͂)
				if ( drvs[OET_LZH] == T_TF_ILLEGALCALL ) {
					SendDlgItemMessage(hDlg, IDC_RADIO_LZH, BM_SETCHECK, BST_CHECKED, NULL);
				}
				else if ( drvs[OET_ZIP] == T_TF_ILLEGALCALL ) {
					SendDlgItemMessage(hDlg, IDC_RADIO_ZIP, BM_SETCHECK, BST_CHECKED, NULL);
				}
				else if ( drvs[OET_7Z]  == T_TF_ILLEGALCALL ) {
					SendDlgItemMessage(hDlg, IDC_RADIO_7Z,  BM_SETCHECK, BST_CHECKED, NULL);
				}

				// k`^k̑I
				// [LZH]
				SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lh0 (k)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lh1 (LHarc݊)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lh5 (W)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lh6 (k)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lh7 (Vk)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"œKȌ`I");
				if ( call_unlha32_GetVersion() >= 2400100 ) {
					SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lh2 (LH.EXE 1.9x݊)");
					SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lh3 (LH.EXE 1.9x݊)");
					SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lzs (LArc݊)");
					SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_ADDSTRING, 0, (LPARAM)"lz5 (LArc݊)");
				}
				// ftHg̑I
				SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_SETCURSEL, (WPARAM)2, (LPARAM)NULL);

				// [ZIP]
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -0 (k)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -1 (/k)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -2");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -3");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -4");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -5");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -6 (W)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -7");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -8");
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_ADDSTRING, 0, (LPARAM)" -9 (ᑬ/k)");
				// ftHg̑I
				SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_SETCURSEL, (WPARAM)6, (LPARAM)NULL);

				// [7z]
				SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_ADDSTRING, 0, (LPARAM)"x=0 (k)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_ADDSTRING, 0, (LPARAM)"x=1 (k)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_ADDSTRING, 0, (LPARAM)"x=5 (Wk)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_ADDSTRING, 0, (LPARAM)"x=7 (ōk)");
				SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_ADDSTRING, 0, (LPARAM)"x=9 (k)");
				// ftHg̑I
				SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_SETCURSEL, (WPARAM)2, (LPARAM)NULL);

				// Vbg_ȆI
				SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_ADDSTRING, 0, (LPARAM)"kɃG[ȂĂAɉȂ");
				SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_ADDSTRING, 1, (LPARAM)"kɃG[Ȃ΃Vbg_E");
				SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_ADDSTRING, 2, (LPARAM)"kɃG[Ȃ΍ċN");
				SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_ADDSTRING, 3, (LPARAM)"kɃG[Ȃ΃TXyh");
				SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_ADDSTRING, 4, (LPARAM)"kɃG[Ȃ΋x~Ԃɓ");
				// ftHg̑I
				SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN,  CB_SETCURSEL, (WPARAM)0, (LPARAM)NULL);

				// Õ`FbNԂWXgǂݍ
				if ( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY) ) {
					int iSel;

					switch ( reg.ReadInteger("arc_lzh_or_zip", 0) ) {
						case OET_LZH:
							if ( drvs[OET_LZH] == T_TF_ILLEGALCALL ) {
								SendDlgItemMessage(hDlg, IDC_RADIO_LZH, BM_SETCHECK, BST_CHECKED, NULL);
								SendDlgItemMessage(hDlg, IDC_RADIO_ZIP, BM_SETCHECK, BST_UNCHECKED, NULL);
								SendDlgItemMessage(hDlg, IDC_RADIO_7Z,  BM_SETCHECK, BST_UNCHECKED, NULL);
							}
							break;
						case OET_ZIP:
							if ( drvs[OET_ZIP] == T_TF_ILLEGALCALL ) {
								SendDlgItemMessage(hDlg, IDC_RADIO_LZH, BM_SETCHECK, BST_UNCHECKED, NULL);
								SendDlgItemMessage(hDlg, IDC_RADIO_ZIP, BM_SETCHECK, BST_CHECKED, NULL);
								SendDlgItemMessage(hDlg, IDC_RADIO_7Z,  BM_SETCHECK, BST_UNCHECKED, NULL);
							}
							break;
						case OET_7Z:
							if ( drvs[OET_7Z]  == T_TF_ILLEGALCALL ) {
								SendDlgItemMessage(hDlg, IDC_RADIO_LZH, BM_SETCHECK, BST_UNCHECKED, NULL);
								SendDlgItemMessage(hDlg, IDC_RADIO_ZIP, BM_SETCHECK, BST_UNCHECKED, NULL);
								SendDlgItemMessage(hDlg, IDC_RADIO_7Z,  BM_SETCHECK, BST_CHECKED, NULL);
							}
							break;
					}
					if ( 1 == reg.ReadInteger("arc_lzh_or_zip_disclose", 0) ) {
						SendDlgItemMessage(hDlg, IDC_CHECK_NOTCLOSE, BM_SETCHECK, BST_CHECKED, NULL);
					}
					if ( 1 == reg.ReadInteger("arc_lzh_or_zip_finmessage", 0) ) {
						SendDlgItemMessage(hDlg, IDC_CHECK_FINISHMESSAGE, BM_SETCHECK, BST_CHECKED, NULL);
					}
					iSel = reg.ReadInteger("arc_lzh_or_zip_shutdown", 0);
					if ( 0 <= iSel && iSel <= 4 ) {
						SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_SETCURSEL, iSel, NULL);
					}

					// k`^k̑OIIIB
					// [LZH]
					iSel = reg.ReadInteger("arc_lzh_lhx", 2);
					if ( 0 <= iSel && iSel <= 9 ) {
						SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_SETCURSEL, iSel, NULL);
					}
					
					// [ZIP]
					iSel = reg.ReadInteger("arc_zip_zipx", 6);
					if ( 0 <= iSel && iSel <= 9 ) {
						SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_SETCURSEL, iSel, NULL);
					}

					// [7z]
					iSel = reg.ReadInteger("arc_7z_7zx", 2);
					if ( 0 <= iSel && iSel <= 4 ) {
						SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_SETCURSEL, iSel, NULL);
					}

					// }`Xbhpǂ
					if ( reg.ReadInteger("arc_lz_mt", 0) == 1 ) {
						SendDlgItemMessage(hDlg, IDC_CHECK_MT, BM_SETCHECK, BST_CHECKED, NULL);
					}

					// Õt@CWXgǂݍށiR{{bNXƂ͕ʐj
					reg.ReadStringForEditbox("arc_lastname", hDlg, IDC_EDIT1);

					// I𒆂łȂDLL̃Xg{bNXB
					hide_listbox_change_ext(hDlg);

					reg.CloseKey();
				}
			
				// gps̃`FbN{bNXOCAEg
				DlgProc_OpenArchiver_CheckDisable( hDlg );

				// _CAÕTCŶ߂̏
				sizedlg = new SIZEDLG(hDlg, dlgitems);

				// c[`bv̒ǉ
				CreateToolTip(hInst, hDlg, oa_tooltips);

				// R{{bNX̃Xg
				cbq = new ComboboxQueue();
				cbq->Init(hDlg, IDC_EDIT1, 16, HKEY_CURRENT_USER, RNSF7REGKEY, "arc_lastname_combo");

				// TuNX
				HWND hEdit = GetDlgItem(hDlg, IDC_EDIT_FILES);
				re_OldEditProc = (WNDPROC)GetWindowLongPtr( hEdit, GWLP_WNDPROC );
				SetWindowLongPtr( hEdit, GWLP_WNDPROC, (LONG_PTR)re_NewEditProc );
			}
			return TRUE;

		case WM_DROPFILES:
			// GNXv[t@Chbv
			oa_DropFiles(hDlg, (HDROP)wParam);
			return TRUE;

		case WM_DESTROY:
			{
				REG reg;

				// `FbN{bNX̏Ԃۑ
				if ( reg.OpenKey(HKEY_CURRENT_USER, RNSF7REGKEY, TREG_OPEN_CREATE) ) {
					reg.WriteInteger("arc_lzh_or_zip", selectedDll(hDlg) );
					reg.WriteInteger("arc_lzh_or_zip_disclose", BST_CHECKED == SendDlgItemMessage(hDlg, IDC_CHECK_NOTCLOSE, BM_GETCHECK, 0, NULL)?1:0 );
					reg.WriteInteger("arc_lzh_or_zip_finmessage", BST_CHECKED == SendDlgItemMessage(hDlg, IDC_CHECK_FINISHMESSAGE, BM_GETCHECK, 0, NULL)?1:0 );
					reg.WriteInteger("arc_lzh_or_zip_shutdown", (int)SendDlgItemMessage(hDlg, IDC_COMBO_SHUTDOWN, CB_GETCURSEL, 0, NULL) );

					// k`^k̑Iۑ
					// [LZH]
					reg.WriteInteger("arc_lzh_lhx", (DWORD)SendDlgItemMessage(hDlg, IDC_SELFORM_LZH, CB_GETCURSEL, 0, NULL));
					
					// [ZIP]
					reg.WriteInteger("arc_zip_zipx", (DWORD)SendDlgItemMessage(hDlg, IDC_SELFORM_ZIP, CB_GETCURSEL, 0, NULL));

					// [7z]
					reg.WriteInteger("arc_7z_7zx", (DWORD)SendDlgItemMessage(hDlg, IDC_SELFORM_7Z,  CB_GETCURSEL, 0, NULL));
					// }`Xbhpǂ
					reg.WriteInteger("arc_lz_mt", BST_CHECKED == SendDlgItemMessage(hDlg, IDC_CHECK_MT, BM_GETCHECK, 0, NULL) ? 1 : 0);

					// Õt@CƂāAt@CWXg֏ށiR{{bNXƂ͕ʐj
					reg.WriteStringFromEditbox("arc_lastname", hDlg, IDC_EDIT1);

					reg.CloseKey();
				}

				// TCŶ߂̏j
				delete sizedlg;
				sizedlg = NULL;

				// R{{bNX̏j
				delete cbq;
				cbq = NULL;
			}
			return TRUE;

		case WM_SIZE:
			sizedlg->Resize(1);
			return TRUE;

		case WM_GETMINMAXINFO:
			return sizedlg->GetMinMaxInfo(lParam);

		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case IDOK:
					CallArchive(hDlg);
					return TRUE;

				case IDHELP:
					{
						// JgtH_Ă\邽߁AexeƓʒuɂhlp
						// T
						char hlpname[MAX_PATH*2];
						int i;

						if ( GetModuleFileNameA(NULL, hlpname, _countof(hlpname)) ) {
							int i = lstrlen(hlpname);

							do {
								i--;
							} while(i>0 && (hlpname[i] != '\\' || isKanji1A(hlpname,i-1)));
							if (i > 0) {
								hlpname[i] = 0;
							}
						}
						lstrcat(hlpname, "\\RNSF7.CHM::/_RESOURCE/HLP000187.html");

						HtmlHelp(hDlg, hlpname, HH_DISPLAY_TOPIC, NULL);
					}
					return TRUE;

				case IDCANCEL:
					EndDialog(hDlg, FALSE);
					return TRUE;

				case IDC_BUTTON_BROWSE:
					{
						OPENFILENAME ofn;
						char fname[MAX_PATH*2]="";
						int  selDll = selectedDll(hDlg);

						GetDlgItemText(hDlg, IDC_EDIT1, fname, _countof(fname));

						ofn.lStructSize = sizeof(OPENFILENAME);
						ofn.hwndOwner = hDlg;
						ofn.lpstrFilter = (selDll == OET_LZH?"LZH(*.lzh)\0*.lzh\0ȉ𓀏(*.exe)\0*.exe\0ׂẴt@C(*.*)\0*.*\0\0":
							               selDll == OET_ZIP?"ZIP(*.zip;*.jar;*.xpi)\0*.zip;*.jar;*.xpi\0ȉ𓀏(*.exe)\0*.exe\0ׂẴt@C(*.*)\0*.*\0\0":
										                     "7-ZIP(*.7z)\0*.7z\0ZIP(*.zip;*.jar;*.xpi)\0*.zip;*.jar;*.xpi\0ȉ𓀏(*.exe)\0*.exe\0ׂẴt@C(*.*)\0*.*\0\0");
						ofn.nFilterIndex = 1;
						ofn.lpstrCustomFilter = (LPSTR) NULL;
						ofn.nMaxCustFilter = 0L;
						ofn.lpstrFile = fname;
						ofn.nMaxFile = _countof(fname);
						ofn.lpstrFileTitle = NULL;
						ofn.nMaxFileTitle = 0;
						ofn.lpstrInitialDir = NULL;
						ofn.lpstrTitle = "k̃t@Cw";
						ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_OVERWRITEPROMPT;
						ofn.nFileOffset = 0;
						ofn.nFileExtension = 0;
						ofn.lpstrDefExt = (selDll == OET_LZH?"lzh":
							               selDll == OET_ZIP?"zip":
										                     "7z"); 

						if (GetSaveFileName(&ofn)) {
							SetDlgItemText(hDlg, IDC_EDIT1, fname);
						}
					}			
					SetFocus(GetDlgItem(hDlg,IDC_EDIT1));
					return TRUE;

				case IDC_RADIO_LZH:
				case IDC_RADIO_ZIP:
				case IDC_RADIO_7Z:
					// I𒆂łȂDLL̃Xg{bNXB
					hide_listbox_change_ext(hDlg);
					return TRUE;

				case IDC_COMBO_SHUTDOWN:
					if ( HIWORD(wParam) != CBN_SELCHANGE ) {
						return TRUE;
					}
					// ̂܂܉
				case IDC_CHECK_NOTCLOSE:
				case IDC_CHECK_FINISHMESSAGE:
					DlgProc_OpenArchiver_CheckDisable(hDlg);
					return TRUE;

				case IDC_BUTTON_BROWSE_FILE:	// t@CI
					oa_SelectFiles(hDlg);
					return TRUE;

				case IDC_BUTTON_BROWSE_FOLDER:	// tH_I
					oa_SelectFolder(hDlg);
					return TRUE;

				case IDC_BUTTON_CLEAR: // NA
					SetDlgItemText(hDlg, IDC_EDIT_FILES, "");
					return TRUE;
			}
			break;
	}
    return FALSE;
}

// hbOhbvkpEBhE
bool OpenArchiver( void )
{
	int drvl = call_unlha32(NULL, NULL);
	int drvz = call_zip32j(NULL, NULL, NULL, NULL);
	int drv7z = call_7zip32(NULL, NULL);

	if ( (drvl == T_TF_DLLNOTFOUND || drvl == T_TF_ILLEGALDLL) &&
		 (drvz == T_TF_DLLNOTFOUND || drvz == T_TF_ILLEGALDLL) &&
		 (drv7z == T_TF_DLLNOTFOUND || drv7z == T_TF_ILLEGALDLL) ) {
		MessageBox(NULL, UNLHA32DLL"A"ZIP32JDLL"A"SEVENZIP32DLL"ȂA܂B", 
#ifdef _WIN64
			"-k- [x64]",
#else
			"-k-",
#endif
			MB_OK | MB_ICONSTOP);
		return false;
	}
	return DialogBox(hInst, (LPCTSTR)IDD_OPEN_ARCHIVER, NULL, (DLGPROC)DlgProc_OpenArchiver)?true:false;
}
