﻿Imports System
Imports System.Text
Imports System.Reflection
Imports System.Text.RegularExpressions
Imports Microsoft.Win32
Imports System.Globalization
Imports System.Threading

Module Module1

    Public Const rKeyName As String = "Software\InaSoftAns\mlrep\CurrentVersion" ' レジストリキー
    Public modeJP As Boolean = True
    Public Function MJP(jstr As String, estr As String) As String
        If modeJP Then
            Return jstr
        Else
            Return estr
        End If
    End Function

    Function Main(ByVal cmdArgs() As String) As Integer

        ' check culture and set en, if not ja.
        ' あるいは、環境変数MLREP_LANG=JAでないならば英語モード
        Dim mlreplang As String = Environment.GetEnvironmentVariable("MLREP_LANG")

        If (Not mlreplang Is Nothing AndAlso mlreplang.ToUpper = "JA") Then
            Thread.CurrentThread.CurrentUICulture = New CultureInfo("ja", False)
        ElseIf ((Not mlreplang Is Nothing AndAlso mlreplang.ToUpper <> "JA") OrElse _
            (Not Thread.CurrentThread.CurrentUICulture.Name.StartsWith("ja") AndAlso Not Thread.CurrentThread.CurrentUICulture.Name.StartsWith("en"))) Then
            Thread.CurrentThread.CurrentUICulture = New CultureInfo("en", False)
            modeJP = False
        ElseIf Thread.CurrentThread.CurrentUICulture.Name.StartsWith("en") Then
            modeJP = False
        End If

        ' ■引数が指定されていなかった場合はコマンドライン引数の情報を表示する
        If cmdArgs.Length = 0 OrElse (cmdArgs.Length > 0 AndAlso (cmdArgs(0) = "/?" OrElse cmdArgs(0) = "-?")) Then
            If (modeJP) Then
                Console.WriteLine("複数行置換コマンドライン版 ver.1.89  (C)2012-2015 T.Yabuki")
                Console.WriteLine("テキストファイルに対する複数行文字列の置換を行います。このプログラムを実行するには、複数行置換GUI版(mlrep.exe) ver.1.82以上が必要です。")
                Console.WriteLine()
                Console.WriteLine("mlrepc [options] </e:置換前文字列 | /e@置換前文字列記述ファイル> </a:置換後文字列 | /a@置換後文字列記述ファイル> [/d:対象フォルダ名のフルパス] </n:対象ファイル名>")
                Console.WriteLine()
                Console.WriteLine("■options")
                Console.WriteLine("　/S  … サブフォルダも検索する。")
                Console.WriteLine("　/KB … 置換前ファイルを ～.bak という名前で待避する。")
                Console.WriteLine("　/KC:待避先フォルダ … 置換前ファイルを待避先フォルダへ待避する。")
                Console.WriteLine("　/R  … 置換前文字列の指定に正規表現を利用する。")
                Console.WriteLine("　/I  … /R利用時に、英大小文字を区別しない。")
                Console.WriteLine("　/G  … /R利用時に、単一行モードとして動作する。")
                Console.WriteLine("　/M  … /R利用時に、複数行モードとして動作する。")
                Console.WriteLine("　/U  … ファイルの文字コードを自動判別する。")
                Console.WriteLine("　       (誤判断があり得るのでバックアップ取得を奨励)")
                Console.WriteLine("　/O:文字コード … /Uを利用しない場合、あるいは/Uで判断不可となった場合に")
                Console.WriteLine("　                 採用される文字コード。")
                Console.WriteLine("　/F:文字コード … 置換前および置換後文字列記述ファイルの文字コード。省略")
                Console.WriteLine("　                 するとUTF-8を仮定する。")
                Console.WriteLine()
                Console.WriteLine("■文字コード")
                Console.WriteLine("　文字コードには、次のいずれかを指定します。")
                Console.WriteLine("　sjis, euc, jis, utf7, utf8, utf8n, utf16, utf16n, utf16be, utf16ben, utf32, utf32n, utf32be, utf32ben, ebcdic, 任意のコードページ")
                Console.WriteLine()
                Console.WriteLine("■対象フォルダ・対象ファイル・置換前後文字列の指定方法について")
                Console.WriteLine("　GUI版と異なり、カンマ区切りなどにより複数指定はありません。本コマンドラインを複数回実行することを想定しています。")
                Console.WriteLine()
                Console.WriteLine("■ファイル名の指定方法について")
                Console.WriteLine("　/nのファイル名指定の中で、フォルダ名やドライブ名は指定できません。/dを利用して下さい。")

            Else
                Console.WriteLine("Multiline Replace ver.1.88 [needs mlrep.exe] (C)2012-2015 T.Yabuki")
                Console.WriteLine()
                Console.WriteLine("mlrepc [options] </e:before | /e@beforefile> </a:after | /a@afterfile> [/d:target_dir] </n:target_file>")
                Console.WriteLine()
                Console.WriteLine("*options")
                Console.WriteLine("　/S  ... Search in subfolders")
                Console.WriteLine("　/KB ... Backup to *.bak files")
                Console.WriteLine("　/KC:folder ... Backup to folder")
                Console.WriteLine("　/R  ... Use regular expressions")
                Console.WriteLine("　/I  ... Ignore case (with /R)")
                Console.WriteLine("　/G  ... Single line mode (with /R)")
                Console.WriteLine("　/M  ... Multi line mode (with /R)")
                Console.WriteLine("　/U  ... Auto detect for charcter code.")
                Console.WriteLine("　/O:char_code ... Character code of target files. (Not auto detect)")
                Console.WriteLine("　/F:char_code ... Character code of beforefile and afterfile. (def:UTF-8)")
                Console.WriteLine()
                Console.WriteLine("*char_code")
                Console.WriteLine("　sjis, euc, jis, utf7, utf8, utf8n, utf16, utf16n, utf16be, utf16ben, utf32, utf32n, utf32be, utf32ben, ebcdic and other code page.")

            End If

            Console.WriteLine()
            Return 0
        End If

        Dim i As Integer

        Dim bSubFolder As Boolean = False
        Dim bBakB As Boolean = False
        Dim bBakC As Boolean = False
        Dim strBakC As String = ""
        Dim bRegExp As Boolean = False
        Dim bRegExpI As Boolean = False
        Dim bRegExpG As Boolean = False
        Dim bRegExpM As Boolean = False
        Dim bAutoDetect As Boolean = False
        Dim iCharCode As Integer = 0
        Dim iCharCodeOther As Integer = 0
        Dim BAFileEncode As Encoding = New UTF8Encoding(True)

        Dim strBefore As String = Nothing
        Dim strAfter As String = Nothing
        Dim strFolder As String = "."
        Dim strFile As String = Nothing

        Dim strBeforeFile As String = Nothing
        Dim strAfterFile As String = Nothing

        ' 引数の解析
        For i = 0 To cmdArgs.Length - 1
            If cmdArgs(i).Chars(0) = "/"c OrElse cmdArgs(i).Chars(0) = "-"c Then
                If cmdArgs(i).Length = 2 AndAlso Char.ToUpper(cmdArgs(i).Chars(1)) = "S"c Then
                    bSubFolder = True

                ElseIf cmdArgs(i).Length = 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "K"c AndAlso Char.ToUpper(cmdArgs(i).Chars(2)) = "B"c Then
                    If bBakC = True Then
                        Console.WriteLine("mlrepc: " + MJP("不正なオプション - /KB と /KC を同時に指定できません。", "Parameter error - /KB and /KC can not be specified at the same time."))
                        Return 1
                    End If
                    bBakB = True

                ElseIf cmdArgs(i).Length > 4 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "K"c AndAlso Char.ToUpper(cmdArgs(i).Chars(2)) = "C"c AndAlso cmdArgs(i).Chars(3) = ":"c Then
                    If bBakB = True Then
                        Console.WriteLine("mlrepc: " + MJP("不正なオプション - /KB と /KC を同時に指定できません。", "Parameter error - /KB and /KC can not be specified at the same time."))
                        Return 1
                    End If
                    bBakC = True
                    strBakC = cmdArgs(i).Substring(4)

                ElseIf cmdArgs(i).Length = 2 AndAlso Char.ToUpper(cmdArgs(i).Chars(1)) = "R"c Then
                    bRegExp = True

                ElseIf cmdArgs(i).Length = 2 AndAlso Char.ToUpper(cmdArgs(i).Chars(1)) = "I"c Then
                    bRegExpI = True

                ElseIf cmdArgs(i).Length = 2 AndAlso Char.ToUpper(cmdArgs(i).Chars(1)) = "G"c Then
                    bRegExpG = True

                ElseIf cmdArgs(i).Length = 2 AndAlso Char.ToUpper(cmdArgs(i).Chars(1)) = "M"c Then
                    bRegExpM = True

                ElseIf cmdArgs(i).Length = 2 AndAlso Char.ToUpper(cmdArgs(i).Chars(1)) = "U"c Then
                    bAutoDetect = True

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "O"c AndAlso cmdArgs(i).Chars(2) = ":"c Then
                    iCharCode = getCharCodeIndex(cmdArgs(i).Substring(3))
                    If iCharCode = -1 Then
                        Console.WriteLine("mlrepc: " + MJP("不正な文字コード指定", "Wrong character code") + " - " + cmdArgs(i))
                        Return 1
                    ElseIf iCharCode = 15 Then
                        ' 任意のコードページ
                        iCharCodeOther = CInt(cmdArgs(i).Substring(3))
                    End If

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "F"c AndAlso cmdArgs(i).Chars(2) = ":"c Then
                    Dim iFileEncode As Integer = getCharCodeIndex(cmdArgs(i).Substring(3))
                    If iFileEncode = -1 Then
                        Console.WriteLine("mlrepc: " + MJP("不正な文字コード指定", "Wrong character code") + " - " + cmdArgs(i))
                        Return 1
                    Else
                        BAFileEncode = getIndex2CharEncode(iFileEncode)
                        If BAFileEncode Is Nothing Then
                            BAFileEncode = Encoding.GetEncoding(CInt(cmdArgs(i).Substring(3)))
                        End If
                    End If

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "E"c AndAlso cmdArgs(i).Chars(2) = ":"c Then
                    strBefore = cmdArgs(i).Substring(3)

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "E"c AndAlso cmdArgs(i).Chars(2) = "@"c Then
                    strBeforeFile = cmdArgs(i).Substring(3)

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "A"c AndAlso cmdArgs(i).Chars(2) = ":"c Then
                    strAfter = cmdArgs(i).Substring(3)

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "A"c AndAlso cmdArgs(i).Chars(2) = "@"c Then
                    strAfterFile = cmdArgs(i).Substring(3)

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "D"c AndAlso cmdArgs(i).Chars(2) = ":"c Then
                    strFolder = cmdArgs(i).Substring(3)

                ElseIf cmdArgs(i).Length > 3 AndAlso
                       Char.ToUpper(cmdArgs(i).Chars(1)) = "N"c AndAlso cmdArgs(i).Chars(2) = ":"c Then
                    strFile = cmdArgs(i).Substring(3)

                    If strFile.IndexOf("\"c) <> -1 OrElse strFile.IndexOf(":"c) <> -1 Then
                        Console.WriteLine("mlrepc: " + MJP("/n 指定のファイル名の中にフォルダ名やドライブ名は指定できません。フォルダ名やドライブ名は /d で指定して下さい。", "If you specify a directory name, you use parameter /d."))
                        Return 1
                    End If

                Else
                    Console.WriteLine("mlrepc: " + MJP("不正なオプション", "Parameter error") + " - " + cmdArgs(i))
                    If cmdArgs(i) = "" AndAlso modeJP Then
                        Console.WriteLine("mlrepc: オプション指定の中にスペースや、 < や > などの文字を使用したい場合は、引数をダブルコーテーション("")で囲って下さい。")
                    End If
                    Return 1

                End If

            Else
                Console.WriteLine("mlrepc: " + MJP("不正な引数", "Parameter error") + " - " + cmdArgs(i))
                Return 1

            End If

        Next

        If Not strBeforeFile Is Nothing Then
            ' 置換前文字列記述ファイルを指定
            Try
                strBefore = My.Computer.FileSystem.ReadAllText(strBeforeFile, BAFileEncode)
            Catch ex As System.IO.FileNotFoundException
                Console.WriteLine("mlrepc: " + MJP("置換前文字列記述ファイルが見つかりません", "Cannot open the file") + " - " + strBeforeFile)
                Return 1
            Catch ex As Exception
                Console.WriteLine("mlrepc: " + MJP("置換前文字列記述ファイルを開けません", "Cannot open the file") + " - " + strBeforeFile)
                Console.WriteLine(ex.ToString)
                Return 1
            End Try
        End If

        If Not strAfterFile Is Nothing Then
            ' 置換後文字列記述ファイルを指定
            Try
                strAfter = My.Computer.FileSystem.ReadAllText(strAfterFile, BAFileEncode)
            Catch ex As System.IO.FileNotFoundException
                Console.WriteLine("mlrepc: " + MJP("置換後文字列記述ファイルが見つかりません", "Cannot open the file") + " - " + strAfterFile)
                Return 1
            Catch ex As Exception
                Console.WriteLine("mlrepc: " + MJP("置換後文字列記述ファイルを開けません", "Cannot open the file") + " - " + strAfterFile)
                Console.WriteLine(ex.ToString)
                Return 1
            End Try

        End If

        If strBefore Is Nothing OrElse strAfter Is Nothing OrElse strFolder Is Nothing OrElse strFile Is Nothing Then
            Console.WriteLine("mlrepc: " + MJP("必要な引数がそろっていません。最低でも、置換前文字列、置換後文字列、ファイル名は指定する必要があります。", "Parameter is not enough."))
            Return 1
        End If



        ' ■レジストリへの書き込み
        Try
            Dim rKey As RegistryKey = Registry.CurrentUser.CreateSubKey(rKeyName)
            If Not rKey Is Nothing Then
                With rKey
                    .SetValue("FolderName", strFolder)
                    .SetValue("FileName", strFile)
                    .SetValue("CheckBox_SubFolder", bSubFolder)
                    .SetValue("CheckBox_MultiCSVDir", 0)
                    .SetValue("CheckBox_MultiCSV", 0)
                    .SetValue("CheckBox_Backup", IIf(bBakB OrElse bBakC, 1, 0))
                    .SetValue("CheckBox_RegExp", bRegExp)
                    .SetValue("Check_ICase", bRegExpI)
                    .SetValue("Check_Single", bRegExpG)
                    .SetValue("Check_Multiline", bRegExpM)
                    .SetValue("ComboBox_Encodings_Index", iCharCode)
                    .SetValue("Other_Encoding_CP", iCharCodeOther)
                    .SetValue("Check_AutoDetect", bAutoDetect)
                    .SetValue("TextBox_Before", strBefore)
                    .SetValue("TextBox_After", strAfter)
                    .SetValue("Radio_BakSel", IIf(bBakB, 0, 1))
                    .SetValue("TextBox_BakFolder", strBakC)
                    .SetValue("CheckBox_SelectFiles", 0)
                    .SetValue("chkMore", 0)
                    .SetValue("CheckBox_IgnoreErr", 0)

                    ' 開いたレジストリキーを閉じる
                    .Close()
                End With
            End If

        Catch ex As Exception
            Console.WriteLine("mlrepc: " + MJP("レジストリキーを開けません - ", "Cannot open the registry key - ") + rKeyName)
            Console.WriteLine(ex.ToString)

            Return 1

        End Try

        ' ■mlrepプロセスのプログラム名称の決定
        Dim moduleArray() As [Module]

        moduleArray = [Assembly].GetExecutingAssembly().GetModules(False)
        Dim myModule As [Module] = moduleArray(0)
        Dim exename As String = myModule.FullyQualifiedName
        Dim reg As New Regex("\\mlrepc.exe$", RegexOptions.IgnoreCase)
        exename = reg.Replace(exename, "\\mlrep.exe")


        ' ■mlrepプロセスの実行
        Dim p As New Process
        p.StartInfo.UseShellExecute = False
        p.StartInfo.RedirectStandardOutput = True
        p.StartInfo.FileName = exename
        p.StartInfo.Arguments = "/CUIMODE"
        p.Start()


        ' ■ウェイト
        'p.WaitForInputIdle()
        'p.WaitForExit()
        ' キックしたEXEの標準出力をパイプで読み出しコンソールへ書き込み
        Dim reader As System.IO.StreamReader = p.StandardOutput
        Do
            Do While reader.Peek > 0

                Dim buf(1000) As Char
                Dim len As Integer

                len = reader.Read(buf, 0, buf.Length)

                Dim strRead As New String(buf, 0, len)
                Console.Write(strRead)
            Loop

        Loop Until p.WaitForExit(100)

        ' 最後まで
        Console.Write(reader.ReadToEnd())

        ' ■プロセスの終了
        Return p.ExitCode

    End Function

    ' 文字コードインデックスを、文字コードに書き換える
    Function getIndex2CharEncode(ByVal iCodeIndex As Integer) As Encoding
        Select Case iCodeIndex
            Case 0 ' Shift-JIS
                Return Encoding.GetEncoding(932)

            Case 1 ' UTF-16  LE(BOM付き)
                Return New UnicodeEncoding(False, True)

            Case 2 ' EUC-JP
                Return Encoding.GetEncoding(51932)

            Case 3 ' JIS [iso-2022-jp]
                Return Encoding.GetEncoding(50220)

            Case 4 ' UTF-7
                Return New UTF7Encoding

            Case 5 ' UTF-8     (BOM付き)
                Return New UTF8Encoding(True)

            Case 6 ' UTF-32  LE(BOM付き)
                Return New UTF32Encoding(False, True)

            Case 7 ' UTF-16N LE(BOMなし)
                Return New UnicodeEncoding(False, False)

            Case 8 ' UTF-8N    (BOMなし)
                Return New UTF8Encoding(False)

            Case 9 ' UTF-32N LE(BOMなし)
                Return New UTF32Encoding(False, False)

            Case 10 ' UTF-16  BE(BOM付き)
                Return New UnicodeEncoding(True, True)

            Case 11 ' UTF-32  BE(BOM付き)
                Return New UTF32Encoding(True, True)

            Case 12 ' UTF-16N BE(BOMなし)
                Return New UnicodeEncoding(True, False)

            Case 13 ' UTF-32N BE(BOMなし)
                Return New UTF32Encoding(True, False)

            Case 14 ' IBM EBCDIC (Katakana)
                Return Encoding.GetEncoding(20290)

            Case 15 ' 任意のコードページ。ここでは処理できない
                Return Nothing

            Case Else ' -1を想定。UTF-8N
                Return New UTF8Encoding(True)

        End Select

    End Function

    ' 文字コード名称を、mlrep内のインデックスに書き換える
    Function getCharCodeIndex(ByVal strCharCode As String) As Integer
        ' sjis, euc, jis, utf7, utf8, utf8n, utf16, utf16n, utf16be, utf16ben, utf32, utf32n, utf32be, utf32ben, ebcdic
        strCharCode = strCharCode.ToLower()

        If strCharCode = "sjis" OrElse strCharCode = "shiftjis" OrElse strCharCode = "shift-jis" Then
            Return 0

        ElseIf strCharCode = "utf16" OrElse strCharCode = "utf-16" Then
            Return 1

        ElseIf strCharCode = "euc" OrElse strCharCode = "eucjp" OrElse strCharCode = "euc-jp" Then
            Return 2

        ElseIf strCharCode = "jis" OrElse strCharCode = "iso-2022-jp" Then
            Return 3

        ElseIf strCharCode = "utf7" OrElse strCharCode = "utf-7" Then
            Return 4

        ElseIf strCharCode = "utf8" OrElse strCharCode = "utf-8" Then
            Return 5

        ElseIf strCharCode = "utf32" OrElse strCharCode = "utf-32" OrElse strCharCode = "utf32le" OrElse strCharCode = "utf-32le" Then
            Return 6

        ElseIf strCharCode = "utf16n" OrElse strCharCode = "utf-16n" OrElse strCharCode = "utf16nle" OrElse strCharCode = "utf-16nle" Then
            Return 7

        ElseIf strCharCode = "utf8n" OrElse strCharCode = "utf-8n" Then
            Return 8

        ElseIf strCharCode = "utf32n" OrElse strCharCode = "utf-32n" OrElse strCharCode = "utf32nle" OrElse strCharCode = "utf-32nle" Then
            Return 9

        ElseIf strCharCode = "utf16be" OrElse strCharCode = "utf-16be" Then
            Return 10

        ElseIf strCharCode = "utf32be" OrElse strCharCode = "utf-32be" Then
            Return 11

        ElseIf strCharCode = "utf16ben" OrElse strCharCode = "utf-16ben" Then
            Return 12

        ElseIf strCharCode = "utf32ben" OrElse strCharCode = "utf-32ben" Then
            Return 13

        ElseIf strCharCode = "ebcdic" OrElse strCharCode = "ebcdik" Then
            Return 14

        ElseIf Regex.IsMatch(strCharCode, "^[0-9]{1,5}$") Then
            Return 15

        Else
            Return -1

        End If

    End Function

End Module
