Imports System
Imports System.Threading
Imports System.IO
Imports System.Text
Imports System.Text.RegularExpressions
Imports System.Collections.Generic
Imports Microsoft.Win32

Structure CODELIST
    Public strName As String
    Public enc As Encoding

    Sub New(ByVal Name As String, ByVal En As Encoding)
        strName = Name
        enc = En
    End Sub
End Structure

Public Class Form1

    Private g_iReplacedFilesCount As Integer          ' ut@CJEg邽߂̕ϐ
    Private g_iFoundFileCount As Integer              ' t@CJEg邽߂̕ϐiuǂɊւ炸j
    Private strTitle As String                        ' EBhE^Cg
    Private ReadOnly strVersion As String = mw.MJP(" ver.1.89", " ver.1.89")  ' o[Wԍ
    Public Shared strHelpFileName As String                 ' wvt@C̖
    Public Const rKeyName As String = "Software\InaSoftAns\mlrep\CurrentVersion" ' WXgL[

    Public Shared bCuiMode As Boolean = False

    Public intRadioBak As Integer = 0                   ' uOt@C̃obNAbv@̑I
    Public strBakFolder As String = String.Empty        ' uOt@C̃obNAbvtH_

    Public aryTargetFiles As List(Of String)               ' uΏۃt@CXg
    Const STF_MODE_REPLACE As Integer = 0               ' SearchTargetFiles̓샂[h:0 c t@CЂ[u(ftHg)
    Const STF_MODE_MAKELIST As Integer = 1              ' SearchTargetFiles̓샂[h:1 c aryTargetFilesɒu쐬iu͍sȂj

    Private bCancelFlag As Byte = 0                     ' fw

    Private bIgnoreErrorByFile As Boolean = False       ' t@CɂG[Ăp
    Private bIgnoreErrorByDir As Boolean = False        ' t@CɂG[Ăp

    Private clCodeList As CODELIST()

    Private Sub TextBox_FolderName_DragDrop(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs)
        'hbvꂽtH_擾
        Dim FolderName As String

        FolderName = e.Data.GetData(DataFormats.FileDrop)(0)
        If Directory.Exists(FolderName) Then
            TextBox_FolderName.Text = FolderName
        End If
    End Sub

    Private Sub TextBox_FolderName_DragEnter(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DragEventArgs)
        'hbOĂe^ɕϊ\ȏꍇ
        If e.Data.GetDataPresent(DataFormats.FileDrop) Then
            'Rs[
            e.Effect = DragDropEffects.Copy
        End If
    End Sub

    Private Sub Button_Browse_Folder_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Browse_Folder.Click
        'tH_ꗗIԂ߂̃_CAO\
        If DialogResult.OK = FolderBrowserDialog1.ShowDialog() Then
            '擾tH_eLXg{bNX֑
            TextBox_FolderName.Text = FolderBrowserDialog1.SelectedPath
        End If
    End Sub

    Private Sub Button_Cancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Cancel.Click, IXToolStripMenuItem.Click
        If Button_OK.Enabled = True Then
            ' OK{^ȂAvP[VI
            Application.Exit()
        Else
            ' OK{^񊈐Ȃu^XN𒆒fw
            Thread.VolatileWrite(bCancelFlag, 1)
        End If

    End Sub

    Private Sub Button_About_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles o[WAToolStripMenuItem.Click
        ' o[W_CAO\
        MsgBox(strTitle + strVersion + Environment.NewLine + "Copyright(C) 2006-2015 " + mw.MJP("", "T.Yabuki"), _
               MsgBoxStyle.Information, mw.MJP("o[W", "About"))
    End Sub

    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        ' NA{^
        ' TextBox_FolderName.Text = ""
        ' TextBox_FileName.Text = ""
        TextBox_Before.Text = ""
        TextBox_After.Text = ""
    End Sub

    Private Sub Button_Help_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles wvHToolStripMenuItem1.Click
        ' \
        Try
            System.Diagnostics.Process.Start(strHelpFileName)
        Catch ex As Exception
            MsgBox(mw.MJP("wvt@CJ܂B", "Cannot open the help file.") + Environment.NewLine + strHelpFileName, _
                MsgBoxStyle.Critical, strTitle)
        End Try
    End Sub

    Private Sub Button_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_OK.Click
        ' K{͍̓ڂ͂Ă邩ǂ`FbN
        If TextBox_FolderName.Text.Equals(String.Empty) Then
            MsgBox(mw.MJP("tH_w肳Ă܂B", "Specify a target folder."), MsgBoxStyle.Critical, strTitle)
            Return
        End If

        If TextBox_FileName.Text.Equals(String.Empty) Then
            MsgBox(mw.MJP("t@Cw肳Ă܂B", "Specify a target filename."), MsgBoxStyle.Critical, strTitle)
            Return
        ElseIf (Not bCuiMode) AndAlso (TextBox_FileName.Text.LastIndexOf("\"c) <> -1 OrElse TextBox_FileName.Text.LastIndexOf(":"c) <> -1) Then
            MsgBox(mw.MJP("t@C̗ɂ̓hCutH_wł܂B", "Do not include a folder or drive in the file name."), MsgBoxStyle.Critical, strTitle)
            Return
        End If

        If TextBox_Before.Text.Equals(String.Empty) AndAlso (chkMore.Checked = False OrElse count_more.Text = mw.MJP("(0wς)", "(0 pairs)")) Then
            MsgBox(mw.MJP("uOw肵ĂB", "Specify the 'before.'"), MsgBoxStyle.Critical, strTitle)
            Return
        End If

        If (clCodeList(ComboBox_Encodings.SelectedIndex).enc Is Nothing) Then
            If Not Regex.IsMatch(txtOtherCP.Text, "^[0-9]{1,5}$") Then
                MsgBox(mw.MJP("R[hy[W𐔒lŎw肵ĉB", "Specify the code page numerically."), MsgBoxStyle.Critical, strTitle)
                Return
            End If
        End If

        If (Not bCuiMode) Then
            If TextBox_FileName.Text.Equals("*.*") OrElse TextBox_FileName.Text.Equals("*") Then
                If (MsgBoxResult.No = MsgBox(mw.MJP("t@C̎w肪St@CɂȂĂ܂Bw肳ꂽtH_ɒuꂽׂẴt@CΏۂƂȂ܂BJnĂ낵łH", "You have to specify the *.* or * in the file name . Are you sure you want to continue?"), _
                                             MsgBoxStyle.YesNo Or MsgBoxStyle.Exclamation, strTitle)) Then
                    Return
                End If
            Else
                ' uJnĂǂmF
                If (MsgBoxResult.Yes <> MsgBox(mw.MJP("uJnĂ낵łH", "Are you sure you want to continue?"), _
                                               MsgBoxStyle.YesNo Or MsgBoxStyle.Question, strTitle)) Then
                    Return
                End If
            End If
        End If

        If CheckBox_Backup.Checked AndAlso Me.intRadioBak = BackupSetDlg.IRB_CPFLDR AndAlso Me.strBakFolder = "" Then
            MsgBox(mw.MJP("uOt@CwtH_֑ҔݒɂȂĂ̂ɁAҔtH_w肳Ă܂B" + vbNewLine + _
                   "uҔ̕@Iv{^AҔtH_w肵ĉB", "Specify the backup folder name."), MsgBoxStyle.Critical, Me.Text)
            Return
        End If

        If (Not bCuiMode) Then
            ' e̓{bNXOK{^񊈐A{^̕ς
            EnableControls(False)

            ' R{{bNX֒ǉ
            ComboBoxAdd.ComboBoxAdd(TextBox_FolderName, TextBox_FolderName.Text)
            ComboBoxAdd.ComboBoxAdd(TextBox_FileName, TextBox_FileName.Text)

            ' u͕ʃXbhŎs
            Thread.VolatileWrite(bCancelFlag, 0)
            Dim threadA As New Thread(New ThreadStart(AddressOf ReplaceThreadMethod))
            threadA.Start()
        Else
            ' CUIł̓C\bĥ܂܂ł悢
            ReplaceThreadMethod()

        End If

    End Sub

    ' sɊւRg[E񊈐ɂ
    Private Sub EnableControls(ByVal bEnabled As Boolean)
        TextBox_FolderName.Enabled = bEnabled
        Button_Browse_Folder.Enabled = bEnabled
        TextBox_FileName.Enabled = bEnabled
        CheckBox_SubFolder.Enabled = bEnabled
        CheckBox_MultiCSVDir.Enabled = bEnabled
        CheckBox_MultiCSV.Enabled = bEnabled
        CheckBox_Backup.Enabled = bEnabled
        Button_Backup.Enabled = bEnabled
        CheckBox_RegExp.Enabled = bEnabled
        Check_Single.Enabled = bEnabled
        Check_Multiline.Enabled = bEnabled
        check_AutoDetect.Enabled = bEnabled
        ComboBox_Encodings.Enabled = bEnabled
        btnClear.Enabled = bEnabled
        TextBox_Before.Enabled = bEnabled
        TextBox_After.Enabled = bEnabled
        CheckBox_SelectFiles.Enabled = bEnabled
        Button_OK.Enabled = bEnabled
        CheckBox_IgnoreErr.Enabled = bEnabled

        If (bEnabled) Then
            Button_OK.Text = mw.MJP("ϊJn(&T)", "S&tart Replacement")
            Button_Cancel.Text = mw.MJP("I(&X)", "E&xit")
        Else
            Button_OK.Text = mw.MJP("...", "Processing...")
            Button_Cancel.Text = mw.MJP("~(&X)", "Abort(&X)")
        End If

    End Sub


    ' ʃXbhœ삳郁\bh
    Private Sub ReplaceThreadMethod()
        Dim bAbort As Boolean = False

        bIgnoreErrorByFile = CheckBox_IgnoreErr.Checked
        bIgnoreErrorByDir = CheckBox_IgnoreErr.Checked

        ' ΏۃtH_
        Dim targets As New Generic.List(Of String)
        If CheckBox_MultiCSVDir.Checked Then
            ' J}؂苖̃`FbN{bNXȈꍇ
            Dim dirbuf As New StringBuilder ' t@Cgݗėpobt@
            Dim bDblQt As Boolean = False     ' _uR[e[VH
            Dim iPos As Integer = 0
            Dim cPos As Char

            For iPos = 0 To TextBox_FolderName.Text.Length - 1
                cPos = TextBox_FolderName.Text.Chars(iPos)
                Select Case cPos
                    Case """"c
                        ' _uR[e[V
                        bDblQt = Not bDblQt

                    Case ","c, " "c
                        ' J}orXy[XꍇA_uR[e[VȂ當ƂđA
                        ' łȂ΋؂Ƃđ()
                        If bDblQt Then
                            ' _uR[e[VȂ̗p
                            dirbuf.Append(cPos)
                        Else
                            ' ƂĒǉ
                            targets.Add(dirbuf.ToString)
                            dirbuf.Length = 0
                        End If

                    Case Else
                        dirbuf.Append(cPos)

                End Select
            Next

            If dirbuf.Length > 0 Then
                ' Ō̂Pǉ
                targets.Add(dirbuf.ToString)
            End If

            ' \[gĂd(p召Ń\[gEr)
            Dim cmp As StringComparer = StringComparer.OrdinalIgnoreCase
            targets.Sort(cmp)
            iPos = 1
            While iPos < targets.Count
                If cmp.Compare(targets(iPos - 1), targets(iPos)) = 0 Then
                    targets.RemoveAt(iPos)
                Else
                    iPos += 1
                End If
            End While

        Else
            targets.Add(TextBox_FolderName.Text)
        End If


        ' uƂJn
        Try
            If CheckBox_SelectFiles.Checked Then
                ' uΏۂƂȂt@CIꍇ
                aryTargetFiles = New List(Of String)
                aryTargetFiles.Clear()
                ' ut@C̃JEgϐ
                g_iReplacedFilesCount = 0
                g_iFoundFileCount = 0
                ' t@C̃T[`
                For Each target As String In targets
                    If False = SearchTargetFiles(target, STF_MODE_MAKELIST) Then
                        Return
                    End If
                Next

                If aryTargetFiles.Count = 0 Then
                    Dim frmRsltDlg As New ResultDlg
                    frmRsltDlg.SetInfo(Me, mw.MJP("uΏۃt@C܂łB", "No target files."), g_iFoundFileCount, 0)
                    frmRsltDlg.ShowMessage()
                    Return

                Else
                    ' Xg\ăt@CIiaryTargetFilesj
                    Dim f1 As New SelectFilesListDlg
                    ' ut@C̃JEgϐ
                    g_iReplacedFilesCount = 0

                    f1.Owner = Me
                    If f1.ShowDialog() = DialogResult.OK Then
                        If CheckBox_Backup.Checked AndAlso Me.intRadioBak = BackupSetDlg.IRB_CPFLDR Then
                            ' wtH_֑Ҕ
                            CopyDir.CopyDirectory(TextBox_FolderName.Text, strBakFolder, CheckBox_SubFolder.Checked)
                        End If

                        ' us
                        For Each aTargetFile As String In aryTargetFiles
                            If AbortCancel() Then
                                bAbort = True
                                Exit For ' f
                            End If
                            If (ReplaceFileText(aTargetFile) = False) Then
                                Exit For ' f
                            End If
                        Next

                    Else
                        Return

                    End If
                End If
            Else
                If CheckBox_Backup.Checked AndAlso Me.intRadioBak = BackupSetDlg.IRB_CPFLDR Then
                    ' wtH_֑Ҕ
                    CopyDir.CopyDirectory(TextBox_FolderName.Text, strBakFolder, CheckBox_SubFolder.Checked)
                End If

                ' ut@C̃JEgϐ
                g_iReplacedFilesCount = 0
                g_iFoundFileCount = 0
                ' t@CЂ[uꍇ
                For Each target As String In targets
                    If False = SearchTargetFiles(target) Then
                        bAbort = True
                    End If
                Next
            End If

            ' uIBut@C\
            If g_iReplacedFilesCount = 0 Then
                If bAbort Then
                    ' ~̏ꍇŉĂȂ΁AȂ
                Else
                    Dim frmRsltDlg As New ResultDlg
                    frmRsltDlg.SetInfo(Me, mw.MJP("uΏۉӏ܂łB", "No target files."), g_iFoundFileCount, 0)
                    frmRsltDlg.ShowMessage()
                End If

            Else
                Dim frmRsltDlg As New ResultDlg

                If bAbort Then
                    frmRsltDlg.SetInfo(Me, mw.MJP("u𒆎~܂B" + vbCrLf + "~܂łɏt@C͎̐̒ʂłB", "Aborted."), g_iFoundFileCount, g_iReplacedFilesCount)
                Else
                    frmRsltDlg.SetInfo(Me, mw.MJP("u܂B", "Finished."), g_iFoundFileCount, g_iReplacedFilesCount)
                End If

                frmRsltDlg.ShowMessage()
            End If

        Catch ex As Exception
            ' OAƂ肠Lb`
            MsgBox(ex.ToString(), MsgBoxStyle.Critical, strTitle)

        Finally
            ' e̓{^OK{^A{^̕߂
            EnableControls(True)
        End Try

    End Sub

    '' bZ[W\
    'Structure POINTAPI
    '    Public x As Int32   ' xW
    '    Public y As Int32   ' yW
    'End Structure 'POINTAPI
    'Structure MSG
    '    Public HWnd As Int32  ' EBhEEnh
    '    Public Msg As Int32   ' bZ[WID
    '    Public WParam As Int32  ' WParamtB[hibZ[WIDƂɈقȂj
    '    Public LParam As Int32  ' LParamtB[hibZ[WIDƂɈقȂj
    '    Public Time As Int32  ' 
    '    Public Pt As POINTAPI   ' J[\ʒuiXN[Wj
    'End Structure 'MSG

    ' Win32 APĨC|[g
    'Private Declare Function PeekMessage Lib "user32" (ByRef lpMsg As MSG, ByVal hwnd As UIntPtr, ByVal wMsgFilterMin As UInt32, ByVal wMsgFilterMax As UInt32, ByVal wRemoveMsg As UInt32) As Boolean
    Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Keys) As Short
    Private Declare Function GetForegroundWindow Lib "user32" () As IntPtr

    ' EscL[̒f
    Private Function AbortCancel() As Boolean
        ' 炪tHAOEhEBhE̎̂ݍs
        If GetForegroundWindow() = Me.Handle Then
            If Thread.VolatileRead(bCancelFlag) = 1 OrElse GetAsyncKeyState(Keys.Escape) < 0 Then
                If bCuiMode OrElse MsgBox(mw.MJP("~{^EscL[܂B~܂?", "Are you sure you want to abort?"), MsgBoxStyle.Question + MsgBoxStyle.YesNo, mw.MJP("~", "Abort")) = MsgBoxResult.Yes Then
                    Thread.VolatileWrite(bCancelFlag, 0)
                    Return True
                Else
                    Thread.VolatileWrite(bCancelFlag, 0)
                    Return False
                End If
            End If
        End If
        Return False
    End Function

    ' Ώۃt@CT[`iċAďoj
    Private Function SearchTargetFiles(ByVal TargetFolder As String, Optional ByVal iStfMode As Integer = STF_MODE_REPLACE) As Boolean
        Try
            ' ^[QbgtH_̑Ώۃt@C
            Dim fnames As New Generic.List(Of String)
            If CheckBox_MultiCSV.Checked Then
                ' J}؂苖̃`FbN{bNXȈꍇ
                Dim fnamebuf As New StringBuilder ' t@Cgݗėpobt@
                Dim bDblQt As Boolean = False     ' _uR[e[VH
                Dim iPos As Integer = 0
                Dim cPos As Char

                For iPos = 0 To TextBox_FileName.Text.Length - 1
                    cPos = TextBox_FileName.Text.Chars(iPos)
                    Select Case cPos
                        Case """"c
                            ' _uR[e[V
                            bDblQt = Not bDblQt

                        Case ","c, " "c
                            ' J}orXy[XꍇA_uR[e[VȂ當ƂđA
                            ' łȂ΋؂Ƃđ()
                            If bDblQt Then
                                ' _uR[e[VȂ̗p
                                fnamebuf.Append(cPos)
                            Else
                                ' ƂĒǉ
                                fnames.AddRange(Directory.GetFiles(TargetFolder, fnamebuf.ToString))
                                fnamebuf.Length = 0
                            End If

                        Case Else
                            fnamebuf.Append(cPos)

                    End Select
                Next

                If fnamebuf.Length > 0 Then
                    ' Ō̂Pǉ
                    fnames.AddRange(Directory.GetFiles(TargetFolder, fnamebuf.ToString))
                End If

                ' \[gĂd(p召Ń\[gEr)
                Dim cmp As StringComparer = StringComparer.OrdinalIgnoreCase
                fnames.Sort(cmp)
                iPos = 1
                While iPos < fnames.Count
                    If cmp.Compare(fnames(iPos - 1), fnames(iPos)) = 0 Then
                        fnames.RemoveAt(iPos)
                    Else
                        iPos += 1
                    End If
                End While

            Else
                ' ̃t@C̏ꍇ
                fnames.AddRange(Directory.GetFiles(TargetFolder, TextBox_FileName.Text))
            End If


            ' 񋓂t@CԂɒuĂ
            For Each fname As String In fnames
                g_iFoundFileCount += 1
                If AbortCancel() Then Return False ' f
                If (ReplaceFileText(fname, iStfMode) = False) Then
                    Return False ' f
                End If
            Next

            ' TutH_Ώۂ̏ꍇ́AtH_̗񋓂s
            If CheckBox_SubFolder.Checked Then
                Dim dirs As String() = Directory.GetDirectories(TargetFolder)

                ' 񋓂tH_ԂɃT[`ĂiċAďoj
                For Each dir As String In dirs
                    If AbortCancel() Then Return False ' f
                    If False = SearchTargetFiles(dir, iStfMode) Then
                        Return False ' f`B
                    End If
                Next
            End If

            Return True ' s

        Catch ex As Exception
            If bIgnoreErrorByDir = False Then
                If (bCuiMode) Then
                    Console.WriteLine(ex.ToString())
                    Return True ' s

                Else
                    Dim rslt As MsgBoxResult

                    rslt = MsgBox(mw.MJP( _
                                  "tH_ɃG[܂Bȍ~ÃG[𖳎܂?" + vbCrLf + _
                                  "[͂] c sAȍ~̃bZ[W\܂B" + vbCrLf + _
                                  "[] c sAȍ~̃bZ[W\܂B" + vbCrLf + _
                                  "[LZ] c 𒆎~܂B", _
                                  "An error occured. Are you sure you want to ignore this error message?") _
                                  + vbCrLf + _
                                  "---------------------------------------" + vbCrLf + _
                                  ex.ToString(), _
                                  MsgBoxStyle.YesNoCancel + MsgBoxStyle.Exclamation, _
                                  Me.Text)

                    If rslt = MsgBoxResult.Yes Then
                        bIgnoreErrorByDir = True ' ȍ~
                        Return True ' s

                    ElseIf rslt = MsgBoxResult.No Then
                        Return True ' s

                    Else
                        Return False ' f

                    End If

                End If

            Else
                Return True ' s

            End If

        End Try

    End Function

    ' uƎw肷v̕WXgǂݏo
    Private Function GetMoreText(ByVal iMoreNum As Integer, ByRef txtBefore As String, ByRef txtAfter As String) As Boolean
        Try
            ' WXgL[̃pXw肵ăWXgJ
            Dim rKey As RegistryKey = Registry.CurrentUser.OpenSubKey(rKeyName)
            If Not rKey Is Nothing Then
                ' WXg̒l擾
                With rKey
                    Dim strValue As String

                    strValue = "more" + iMoreNum.ToString("D3") + "Before"
                    txtBefore = .GetValue(strValue)
                    If Not txtBefore Is Nothing Then
                        strValue = "more" + iMoreNum.ToString("D3") + "After"
                        txtAfter = .GetValue(strValue)

                        If Not txtAfter Is Nothing Then
                            .Close()    ' JWXgL[
                            Return True
                        End If
                    End If

                    .Close()    ' JWXgL[
                    Return False
                End With
            Else
                Return False
            End If
        Catch ex As Exception
            ' ǂݍ݂Ɏs
            MsgBox(mw.MJP("WXgǂݍ߂܂B", "Cannot load from registry.") + Environment.NewLine + Environment.NewLine + ex.ToString(), MsgBoxStyle.Critical, strTitle)
            Return False
        End Try

    End Function

    ' t@C̕u
    Private Function ReplaceFileText(ByVal fname As String, Optional ByVal iStfMode As Integer = STF_MODE_REPLACE) As Boolean
        Try
            Dim enc As System.Text.Encoding = Nothing

            If check_AutoDetect.Checked Then
                ' R[hʂ̏ꍇ

                ' Ƃ肠t@CI[܂ŃoCgƂēǂݏo
                Dim br As New System.IO.FileStream(fname, IO.FileMode.Open, IO.FileAccess.Read)
                Dim len As Integer = br.Length

                If len = 0 Then Return True ' t@CTCY[ȂΏI

                Dim binData() As Byte = New Byte(len - 1) {}

                ' fBXNoCgPʂŃt@Cǂݍ
                br.Read(binData, 0, len)

                'Xg[
                br.Close()
                br = Nothing

                ' GR[h𒲂ׁAɂBOM݂Ȃ΁Aʊ
                If len >= 3 AndAlso binData(0) = &HEF AndAlso binData(1) = &HBB AndAlso binData(2) = &HBF Then  ' UTF-8 BOM
                    enc = New UTF8Encoding(True)
                ElseIf len >= 4 AndAlso binData(0) = &HFF AndAlso binData(1) = &HFE AndAlso binData(2) = &H0 AndAlso binData(3) = &H0 Then    ' UTF-32LE BOM
                    enc = New UTF32Encoding(False, True)
                ElseIf len >= 2 AndAlso binData(0) = &HFF AndAlso binData(1) = &HFE Then  ' UTF-16LE BOM
                    enc = New UnicodeEncoding(False, True)
                ElseIf len >= 4 AndAlso binData(0) = &H0 AndAlso binData(1) = &H0 AndAlso binData(2) = &HFE AndAlso binData(3) = &HFF Then    ' UTF-32BE BOM
                    enc = New UTF32Encoding(True, True)
                ElseIf len >= 2 AndAlso binData(0) = &HFE AndAlso binData(1) = &HFF Then  ' UTF-16BE BOM
                    enc = New UnicodeEncoding(True, True)
                Else    ' BOMȂʃ\bȟĂяo
                    enc = AutoDetect.GetCode(binData)
                End If
            End If

            ' ̎_ŃGR[h܂ĂȂ΁A[U[w̃GR[h̗p
            If enc Is Nothing Then
                enc = clCodeList(ComboBox_Encodings.SelectedIndex).enc
                If enc Is Nothing Then
                    ' Cӂ̃R[hy[Ww̏ꍇ
                    enc = Encoding.GetEncoding(CInt(txtOtherCP.Text))
                End If
            End If

            Dim sr As StreamReader = New StreamReader(fname, enc)
            Dim OriginalText As String  ' uOt@Ce
            Dim ReplacedText As String  ' ut@Ce

            ' uOt@C̓eŌ܂œǂݍ
            OriginalText = sr.ReadToEnd()
            sr.Close()
            sr = Nothing

            If OriginalText.Length = 0 Then
                ' t@CTCY0ȂAu̕KvȂ
                Return True
            End If

            ' uÕt@Ce𑖍AsR[hF
            Dim num_CRLF As UInteger = 0
            Dim num_CR As UInteger = 0
            Dim num_LF As UInteger = 0
            Dim strNewLineCode As String
            For uIdx As UInteger = 0 To OriginalText.Length - 1
                If OriginalText.Chars(uIdx) = vbCr Then
                    If uIdx + 1 < OriginalText.Length AndAlso OriginalText.Chars(uIdx + 1) = vbLf Then
                        uIdx += 1
                        num_CRLF += 1
                    Else
                        num_CR += 1
                    End If
                End If
                If OriginalText.Chars(uIdx) = vbLf Then
                    num_LF += 1
                End If
            Next

            ' esR[h̐𐔂āAł̂𔻒
            If num_CRLF >= num_CR AndAlso num_CRLF >= num_LF Then
                strNewLineCode = vbCrLf
            ElseIf num_LF >= num_CR Then
                strNewLineCode = vbLf
            Else
                strNewLineCode = vbCr
            End If

            Dim OriginalText2 As String ' sR[h̒uOt@Ce
            Dim TextBox_BeforeText As String ' u
            Dim TextBox_AfterText As String ' u㕶

            ' sꂳĂȂƓŝŁAsLLF݂̂ɒu
            If num_CRLF > 0 OrElse num_CR > 0 Then
                OriginalText2 = OriginalText.Replace(vbCrLf, vbLf).Replace(vbCr, vbLf)
            Else
                OriginalText2 = OriginalText
            End If
            If Not Environment.NewLine = vbLf Then
                TextBox_BeforeText = TextBox_Before.Text.Replace(Environment.NewLine, vbLf)
                TextBox_AfterText = TextBox_After.Text.Replace(Environment.NewLine, vbLf)
            Else
                TextBox_BeforeText = TextBox_Before.Text
                TextBox_AfterText = TextBox_After.Text
            End If

            ' K\p̏ꍇ
            If CheckBox_RegExp.Checked Then

                ' IvV𐮗
                Dim opt As RegexOptions = RegexOptions.None

                ' p召ʂȂ
                If Check_ICase.Checked Then
                    opt = opt Or RegexOptions.IgnoreCase
                End If

                ' Ps[h
                If Check_Single.Checked Then
                    opt = opt Or RegexOptions.Singleline
                End If

                's[h
                If Check_Multiline.Checked Then
                    opt = opt Or RegexOptions.Multiline
                End If

                ' K\peLXg̒u
                If TextBox_BeforeText <> "" Then
                    ReplacedText = Regex.Replace(OriginalText2, TextBox_BeforeText, TextBox_AfterText, opt)
                Else
                    ReplacedText = OriginalText2
                End If

                If (chkMore.Checked) Then   ' uƎw肷vw肳Ăꍇ
                    Dim txtBefore As String
                    Dim txtAfter As String
                    For i As Integer = 0 To 999
                        txtBefore = Nothing
                        txtAfter = Nothing
                        If GetMoreText(i, txtBefore, txtAfter) Then
                            ReplacedText = Regex.Replace(ReplacedText, txtBefore, txtAfter, opt)
                        End If
                    Next
                End If
            Else ' K\gpȂꍇ
                If TextBox_BeforeText <> "" Then
                    ReplacedText = OriginalText2.Replace(TextBox_BeforeText, TextBox_AfterText)
                Else
                    ReplacedText = OriginalText2
                End If

                If (chkMore.Checked) Then   ' uƎw肷vw肳Ăꍇ
                    Dim txtBefore As String
                    Dim txtAfter As String
                    For i As Integer = 0 To 999
                        txtBefore = Nothing
                        txtAfter = Nothing
                        If GetMoreText(i, txtBefore, txtAfter) Then
                            ReplacedText = ReplacedText.Replace(txtBefore, txtAfter)
                        End If
                    Next
                End If
            End If

            ' uOƒuœeɈႢoĂA݂s
            If Not OriginalText2.Equals(ReplacedText) Then
                If iStfMode = STF_MODE_MAKELIST Then
                    ' Xg邾̃[h̏ꍇ
                    aryTargetFiles.Add(fname)

                Else

                    ' sR[hɖ߂
                    If Not strNewLineCode = vbLf Then
                        ReplacedText = ReplacedText.Replace(vbLf, strNewLineCode)
                    End If

                    ' t@C̃obNAbv擾ꍇ(.baktꍇ)́AobNAbv
                    If CheckBox_Backup.Checked AndAlso Me.intRadioBak = BackupSetDlg.IRB_ADDBAK Then
                        File.Copy(fname, fname + ".bak", True)
                    End If

                    Dim sw As StreamWriter = New StreamWriter(fname, False, enc)
                    sw.Write(ReplacedText)
                    sw.Close()
                    sw = Nothing
                End If

                ' 
                OriginalText = Nothing
                ReplacedText = Nothing

                ' ut@CJEgAbv
                g_iReplacedFilesCount += 1

            End If

            Return True ' s

        Catch ex As Exception
            If bIgnoreErrorByFile = False Then
                If bCuiMode Then
                    Console.WriteLine(ex.ToString)
                    Return True

                Else
                    Dim rslt As MsgBoxResult

                    rslt = MsgBox(mw.MJP( _
                                  "t@CɃG[܂Bȍ~ÃG[𖳎܂?" + vbCrLf + _
                                  "[͂] c sAȍ~̃bZ[W\܂B" + vbCrLf + _
                                  "[] c sAȍ~̃bZ[W\܂B" + vbCrLf + _
                                  "[LZ] c 𒆎~܂B", _
                                  "An error occured. Are you want to ignore this error message?") + vbCrLf + _
                                  "---------------------------------------" + vbCrLf + _
                                  ex.ToString(), _
                                  MsgBoxStyle.YesNoCancel + MsgBoxStyle.Exclamation, _
                                  Me.Text)

                    If rslt = MsgBoxResult.Yes Then
                        bIgnoreErrorByFile = True ' ȍ~
                        Return True ' s

                    ElseIf rslt = MsgBoxResult.No Then
                        Return True ' s

                    Else
                        Return False ' f

                    End If

                End If

            Else
                Return True ' s

            End If

        End Try

    End Function

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' KvȂAĂяõR\[ƂЂt
        If System.Environment.GetCommandLineArgs.Length > 1 AndAlso System.Environment.GetCommandLineArgs(1) = "/CUIMODE" Then
            Form1.bCuiMode = True
        End If

        ' eLXgGR[ḧꗗ쐬ipIłȂ̂ŁASo͍폜j
        'Dim i As Integer
        'Dim enc As System.Text.Encoding
        '
        'ComboBox_Encodings.Items.Clear()
        'For i = 0 To 65535
        'Try
        '   enc = System.Text.Encoding.GetEncoding(i)
        '   Dim encname As New System.Text.StringBuilder(80)
        '   ' encname.AppendFormat("{0,5:D}:", i)
        '   encname.Append(enc.WebName)
        '   ' encname.Append(enc.EncodingName)
        '   ComboBox_Encodings.Items.Add(encname.ToString)
        '   Catch ex As Exception
        '   End Try
        'Next

        strTitle = Me.Text

        If mw.modejp Then
            clCodeList = New CODELIST() {New CODELIST("SHIFT-JIS", Encoding.GetEncoding(932)), _
                                         New CODELIST("UTF-16  LE(BOMt) c o̓t@C擪ɎʕuFF FEvt܂", New UnicodeEncoding(False, True)), _
                                         New CODELIST("EUC-JP", Encoding.GetEncoding(51932)), _
                                         New CODELIST("JIS [iso-2022-jp]", Encoding.GetEncoding(50220)), _
                                         New CODELIST("UTF-7", New UTF7Encoding), _
                                         New CODELIST("UTF-8     (BOMt) c o̓t@C擪ɎʕuEF BB BFvt܂", New UTF8Encoding(True)), _
                                         New CODELIST("UTF-32  LE(BOMt) c o̓t@C擪ɎʕuFF FE 00 00vt܂", New UTF32Encoding(False, True)), _
                                         New CODELIST("UTF-16N LE(BOMȂ)", New UnicodeEncoding(False, False)), _
                                         New CODELIST("UTF-8N    (BOMȂ)", New UTF8Encoding(False)), _
                                         New CODELIST("UTF-32N LE(BOMȂ)", New UTF32Encoding(False, False)), _
                                         New CODELIST("UTF-16  BE(BOMt) c o̓t@C擪ɎʕuFE FFvt܂ArbOGfBA", New UnicodeEncoding(True, True)), _
                                         New CODELIST("UTF-32  BE(BOMt) c o̓t@C擪Ɏʕu00 00 FE FFvt܂ArbOGfBA", New UTF32Encoding(True, True)), _
                                         New CODELIST("UTF-16N BE(BOMȂ) c rbOGfBA", New UnicodeEncoding(True, False)), _
                                         New CODELIST("UTF-32N BE(BOMȂ) c rbOGfBA", New UTF32Encoding(True, False)), _
                                         New CODELIST("IBM EBCDIC (Katakana)", Encoding.GetEncoding(20290)), _
                                         New CODELIST("̑̕R[h (EɃR[hy[Ww)", Nothing)}

        Else
            clCodeList = New CODELIST() {New CODELIST("SHIFT-JIS", Encoding.GetEncoding(932)), _
                                         New CODELIST("UTF-16  LE(with BOM) BOM = FF FE", New UnicodeEncoding(False, True)), _
                                         New CODELIST("EUC-JP", Encoding.GetEncoding(51932)), _
                                         New CODELIST("JIS [iso-2022-jp]", Encoding.GetEncoding(50220)), _
                                         New CODELIST("UTF-7", New UTF7Encoding), _
                                         New CODELIST("UTF-8     (with BOM) BOM = EF BB BF", New UTF8Encoding(True)), _
                                         New CODELIST("UTF-32  LE(with BOM) BOM = FF FE 00 00", New UTF32Encoding(False, True)), _
                                         New CODELIST("UTF-16N LE(without BOM)", New UnicodeEncoding(False, False)), _
                                         New CODELIST("UTF-8N    (without BOM)", New UTF8Encoding(False)), _
                                         New CODELIST("UTF-32N LE(without BOM)", New UTF32Encoding(False, False)), _
                                         New CODELIST("UTF-16  BE(with BOM) BOM = FE FF", New UnicodeEncoding(True, True)), _
                                         New CODELIST("UTF-32  BE(with BOM) BOM = 00 00 FE FF", New UTF32Encoding(True, True)), _
                                         New CODELIST("UTF-16N BE(without BOM)", New UnicodeEncoding(True, False)), _
                                         New CODELIST("UTF-32N BE(without BOM)", New UTF32Encoding(True, False)), _
                                         New CODELIST("IBM EBCDIC (Katakana)", Encoding.GetEncoding(20290)), _
                                         New CODELIST("Other Character code        CodePage -->", Nothing)}

        End If


        For Each clc As CODELIST In clCodeList
            ComboBox_Encodings.Items.Add(clc.strName)
        Next
        ComboBox_Encodings.SelectedIndex = 0

        ' et@C̊m
        ' st@Ĉ̖Awvt@Cxmlt@Cm肷
        ' WinNTnł́AApplication.ExecutablePathɂ̓tpX̖̂ȂƂ邪
        ' (R}hCw肳ꂽt@Cɓ)̏ꍇ͂̏ꍇ
        ' Ȃ͂B
        Dim strExeFilename As String = Application.ExecutablePath
        strHelpFileName = Path.ChangeExtension(strExeFilename, ".chm")

        ' tB[hobN̐\̂́AVɂP
        If DateTime.Now.Second() Mod 7 = 0 Then
            lblFeedback.Visible = True
        End If

        'WXg珉f[^̓ǂݏo
        Try
            ' WXgL[̃pXw肵ăWXgJ
            Dim rKey As RegistryKey = Registry.CurrentUser.OpenSubKey(rKeyName)
            If Not rKey Is Nothing Then
                ' WXg̒l擾
                With rKey
                    TextBox_FolderName.Text = .GetValue("FolderName")
                    TextBox_FileName.Text = .GetValue("FileName")
                    CheckBox_SubFolder.Checked = .GetValue("CheckBox_SubFolder")
                    CheckBox_MultiCSVDir.Checked = .GetValue("CheckBox_MultiCSVDir")
                    CheckBox_MultiCSV.Checked = .GetValue("CheckBox_MultiCSV")
                    CheckBox_Backup.Checked = .GetValue("CheckBox_Backup")
                    CheckBox_RegExp.Checked = .GetValue("CheckBox_RegExp")
                    Check_ICase.Checked = .GetValue("Check_ICase")
                    Check_Single.Checked = .GetValue("Check_Single")
                    Check_Multiline.Checked = .GetValue("Check_Multiline")
                    CheckBox_IgnoreErr.Checked = .GetValue("CheckBox_IgnoreErr")
                    Try
                        ComboBox_Encodings.SelectedIndex = .GetValue("ComboBox_Encodings_Index")
                    Catch ex As System.ArgumentOutOfRangeException
                        ' ͈͊O̒lWXgɓĂꍇ́AftHglɂ
                        ComboBox_Encodings.SelectedIndex = 0
                    End Try

                    If clCodeList(ComboBox_Encodings.SelectedIndex).enc Is Nothing Then
                        ' Cӂ̃R[hw̏ꍇ
                        txtOtherCP.Text = .GetValue("Other_Encoding_CP")
                        txtOtherCP.Enabled = True
                    Else
                        txtOtherCP.Text = "-"
                        txtOtherCP.Enabled = False
                    End If

                    check_AutoDetect.Checked = .GetValue("Check_AutoDetect")
                    TextBox_Before.Text = .GetValue("TextBox_Before")
                    TextBox_After.Text = .GetValue("TextBox_After")

                    intRadioBak = .GetValue("Radio_BakSel")
                    Select Case intRadioBak
                        Case BackupSetDlg.IRB_ADDBAK
                            intRadioBak = BackupSetDlg.IRB_ADDBAK

                        Case Else
                            intRadioBak = BackupSetDlg.IRB_CPFLDR
                    End Select

                    strBakFolder = .GetValue("TextBox_BakFolder")
                    If strBakFolder Is Nothing Then
                        strBakFolder = String.Empty
                    End If

                    CheckBox_SelectFiles.Checked = .GetValue("CheckBox_SelectFiles")
                    chkMore.Checked = .GetValue("chkMore")

                    ' JWXgL[
                    .Close()
                End With
            End If

            ' R{{bNXԂ̓ǂݏo
            ComboBoxAdd.ComboBoxLoad(TextBox_FolderName, rKeyName, "ComboBox_FolderName", ".")
            ComboBoxAdd.ComboBoxLoad(TextBox_FileName, rKeyName, "ComboBox_FileName", "*.txt")

        Catch ex As Exception
            ' ǂݍ݂Ɏs
            MsgBox(mw.MJP("tH[̏Ԃ̈ꕔ܂͑Ŝǂݍ߂܂B", "Cannot read from Form1.") + Environment.NewLine + Environment.NewLine + ex.ToString(), MsgBoxStyle.Exclamation, strTitle)
        End Try

        ' uƎw肷v֘Aڂ̍XV
        updateMoreInfo()

        If (bCuiMode) Then
            ' R}hC̎sȂÂ܂܎sJn
            Button_OK_Click(sender, Nothing)

            ' I炻̂܂܏I
            Me.Close()
        End If
    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        'WXgɃtH[̏ԂL^
        Try
            ' WXgL[VK쐬ĊJ
            Dim rKey As RegistryKey = Registry.CurrentUser.CreateSubKey(rKeyName)

            ' WXg̒lݒ
            With rKey
                .SetValue("FolderName", TextBox_FolderName.Text)
                .SetValue("FileName", TextBox_FileName.Text)
                .SetValue("CheckBox_SubFolder", CheckBox_SubFolder.Checked)
                .SetValue("CheckBox_MultiCSVDir", CheckBox_MultiCSVDir.Checked)
                .SetValue("CheckBox_MultiCSV", CheckBox_MultiCSV.Checked)
                .SetValue("CheckBox_Backup", CheckBox_Backup.Checked)
                .SetValue("CheckBox_RegExp", CheckBox_RegExp.Checked)
                .SetValue("Check_ICase", Check_ICase.Checked)
                .SetValue("Check_Single", Check_Single.Checked)
                .SetValue("Check_Multiline", Check_Multiline.Checked)
                .SetValue("ComboBox_Encodings_Index", ComboBox_Encodings.SelectedIndex)
                .SetValue("Other_Encoding_CP", txtOtherCP.Text)
                .SetValue("Check_AutoDetect", check_AutoDetect.Checked)
                .SetValue("TextBox_Before", TextBox_Before.Text)
                .SetValue("TextBox_After", TextBox_After.Text)
                .SetValue("Radio_BakSel", intRadioBak)
                .SetValue("TextBox_BakFolder", strBakFolder)
                .SetValue("CheckBox_SelectFiles", CheckBox_SelectFiles.Checked)
                .SetValue("chkMore", chkMore.Checked)
                .SetValue("CheckBox_IgnoreErr", CheckBox_IgnoreErr.Checked)

                ' JWXgL[
                .Close()
            End With

            ' R{{bNXԂ̕ۑ
            ComboBoxAdd.ComboBoxSave(TextBox_FolderName, rKeyName, "ComboBox_FolderName")
            ComboBoxAdd.ComboBoxSave(TextBox_FileName, rKeyName, "ComboBox_FileName")

        Catch ex As Exception
            ' OAƂ肠Lb`
            MsgBox(mw.MJP("tH[̏Ԃ̈ꕔ܂͑Sۑł܂B", "Cannot save data in Form1.") + Environment.NewLine + Environment.NewLine + ex.ToString(), MsgBoxStyle.Exclamation, strTitle)
        End Try
    End Sub


    Private Sub btnFeedback_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tB[hobNFToolStripMenuItem.Click
        ' tB[hobNy[W\
        Try
            System.Diagnostics.Process.Start("http://www.inasoft.org/ifa.php?MLREP")
        Catch ex As Exception
            MsgBox(mw.MJP("tB[hobNy[WJ܂B" + Environment.NewLine + "蓮 http://www.inasoft.org/ifa.php?MLREP JĂB", "Cannot open feedback page."), _
                MsgBoxStyle.Critical, strTitle)
        End Try
    End Sub

    Private Sub Button_Backup_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Backup.Click
        ' Ҕ@I
        Dim FrmBakSetDlg As New BackupSetDlg

        FrmBakSetDlg.Owner = Me
        FrmBakSetDlg.ShowDialog()

    End Sub

    Dim fmRegexCheck As New RegexCheck
    Private Sub btnCheckRegex_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCheckRegex.Click
        If fmRegexCheck.IsDisposed Then
            fmRegexCheck = New RegexCheck
        End If

        ' K\`FbN
        If Not fmRegexCheck.Visible Then
            fmRegexCheck.Init(Me)
            fmRegexCheck.Show()
        End If
    End Sub

    Private Sub ݒۑSToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ݒۑSToolStripMenuItem.Click
        Try
            If DialogResult.OK = SaveFileDialog1.ShowDialog() Then
                'XmlSerializerIuWFNg쐬
                'ރIuWFNǧ^w肷
                Dim serializer As New System.Xml.Serialization.XmlSerializer(GetType(SettingCls))

                ' ݒVACYpNXւۑ
                Dim scls As New SettingCls
                scls.Save(Me)

                't@CJ
                Dim fs As New System.IO.FileStream(SaveFileDialog1.FileName, System.IO.FileMode.Create)
                'VAAXMLt@Cɕۑ
                serializer.Serialize(fs, scls)
                '
                fs.Close()
            End If

        Catch ex As Exception
            MsgBox(ex.ToString, MsgBoxStyle.Critical, mw.MJP("ݒۑ", "Save Settings"))

        End Try

    End Sub

    Private Sub ݒǍLToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ݒǍLToolStripMenuItem.Click
        Try
            If DialogResult.OK = OpenFileDialog1.ShowDialog() Then
                'XmlSerializerIuWFNg쐬
                'ރIuWFNǧ^w肷
                Dim serializer As New System.Xml.Serialization.XmlSerializer(GetType(SettingCls))

                '󔒁EsR[hێ邽߂PreserveWhitespaceLɂ
                Dim doc As New System.Xml.XmlDocument()
                doc.PreserveWhitespace = True

                'XmlReadergēǂݍŋtVA
                Dim scls As SettingCls
                doc.Load(OpenFileDialog1.FileName)
                Using reader As New System.Xml.XmlNodeReader(doc.DocumentElement)
                    Dim o As Object = serializer.Deserialize(reader)
                    scls = DirectCast(o, SettingCls)
                End Using

                ' ݒVACYpNXǂݍ
                scls.Load(Me)
            End If

        Catch ex As Exception
            MsgBox(ex.ToString, MsgBoxStyle.Critical, mw.MJP("ݒǍ", "Load Settings"))

        End Try
    End Sub

    Private btnSlotBtn As Button

    Private Sub btnSlot_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLoadBefore.Click, btnSaveBefore.Click, _
                                                                                                  btnLoadAfter.Click, btnSaveAfter.Click
        Dim strRegSlotName As String
        Dim strShowText As String
        Dim i As Integer

        ' ꂽ{^NameAǂݏoׂXbg擾
        btnSlotBtn = DirectCast(sender, Button)
        If btnSlotBtn.Name = btnLoadBefore.Name OrElse _
           btnSlotBtn.Name = btnSaveBefore.Name Then
            strRegSlotName = "SlotBefore"
        Else
            strRegSlotName = "SlotAfter"
        End If

        ' XbgIp̃j[ڂNA
        ContextMenuStrip1.Items.Clear()

        ' WXg猻̃Xbge擾
        Dim rKey As RegistryKey = Registry.CurrentUser.OpenSubKey(rKeyName)
        If Not rKey Is Nothing Then
            ' WXg̒l擾
            With rKey
                For i = 0 To 9
                    ' WXgǂ񂾕32𒴂ĂBFj[\p̕Ȃ̂
                    strShowText = .GetValue(strRegSlotName & i, "(None)")
                    If strShowText.Length > 32 Then
                        strShowText = strShowText.Substring(0, 32)
                    End If

                    ' ɁAsiXy[Xɒuj
                    strShowText = strShowText.Replace(vbCrLf, " ")

                    ' j[ڂƂĒǉ
                    ContextMenuStrip1.Items.Add("Slot" & i & ":" & strShowText)
                Next

                .Close()
            End With
        Else
            For i = 0 To 9
                ContextMenuStrip1.Items.Add("Slot" & i & ":(None)")
            Next
        End If

        ' ŌɃLZǉ
        ContextMenuStrip1.Items.Add("-")
        ContextMenuStrip1.Items.Add(mw.MJP("LZ", "Cancel"))

        ' ReLXgj[I[v
        ContextMenuStrip1.Show(Control.MousePosition)

    End Sub

    Private Sub ContextMenuStrip1_ItemClicked(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ToolStripItemClickedEventArgs) Handles ContextMenuStrip1.ItemClicked
        ' Iꂽj[̐擪4 "Slot" łȂ΁ALZƌȂďI
        If Not e.ClickedItem.Text.Substring(0, 4) = "Slot" Then
            Return
        End If

        ' IꂽXbgԍ擾
        Dim intSelectedSlot As Integer = Int(e.ClickedItem.Text.Substring(4, 1))

        ' ꂽ{^NameAǂݏoׂXbg擾
        Dim strRegSlotName As String
        Dim txtTextControl As TextBox
        If btnSlotBtn.Name = btnLoadBefore.Name OrElse _
           btnSlotBtn.Name = btnSaveBefore.Name Then
            strRegSlotName = "SlotBefore"
            txtTextControl = TextBox_Before
        Else
            strRegSlotName = "SlotAfter"
            txtTextControl = TextBox_After
        End If

        ' ǂނ̂ĤH
        If btnSlotBtn.Name = btnLoadBefore.Name OrElse _
           btnSlotBtn.Name = btnLoadAfter.Name Then
            ' ǂ
            Dim rKey As RegistryKey = Registry.CurrentUser.OpenSubKey(rKeyName)
            If Not rKey Is Nothing Then
                ' WXg̒l擾
                txtTextControl.Text = rKey.GetValue(strRegSlotName & intSelectedSlot, "")
                rKey.Close()
            Else
                txtTextControl.Text = ""
            End If
        Else
            ' 
            Try
                Dim rKey As RegistryKey = Registry.CurrentUser.CreateSubKey(rKeyName)
                If Not rKey Is Nothing Then
                    ' WXg̒l擾
                    rKey.SetValue(strRegSlotName & intSelectedSlot, txtTextControl.Text)
                    rKey.Close()
                End If

            Catch ex As Exception
                MsgBox(mw.MJP("WXgւ̕ۑɎs܂B", "Cannot save to registry.") + Environment.NewLine + Environment.NewLine + ex.ToString(), MsgBoxStyle.Exclamation, strTitle)

            End Try

        End If

    End Sub

    Private Sub btnMore_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMore.Click
        ' uƎw肷vI[v
        Dim fm As New moreEdit
        If DialogResult.OK = fm.ShowDialog() Then
            updateMoreInfo()
        End If
    End Sub

    Private Sub JxtToolStripMenuItem3_Click(sender As System.Object, e As System.EventArgs) Handles JxtToolStripMenuItem3.Click
        System.Diagnostics.Process.Start("http://www.inasoft.org/kifu.html")
    End Sub

    Private Sub FileMenu_ComboClear_Click(sender As System.Object, e As System.EventArgs) Handles FileMenu_ComboClear.Click
        If (MsgBoxResult.Ok = MsgBox(mw.MJP("t@CEtH_̗͗NAĂ낵ł?", "Are you sure you want to reset histories in files and folders?"), MsgBoxStyle.OkCancel + MsgBoxStyle.Question, Me.Text)) Then
            TextBox_FolderName.Items.Clear()
            TextBox_FolderName.Items.Add(".")
            TextBox_FileName.Items.Clear()
            TextBox_FileName.Items.Add("*.txt")
        End If
    End Sub

    ' Ctrl+Ȁ
    Private Sub txtKeyDown(sender As System.Object, e As System.Windows.Forms.KeyEventArgs) Handles TextBox_Before.KeyDown, TextBox_After.KeyDown
        If e.KeyCode = Keys.A AndAlso e.Control Then
            If TypeOf sender Is TextBox Then
                Dim txt As TextBox = sender
                txt.SelectionStart = 0
                txt.SelectionLength = txt.Text.Length
            End If
        End If
    End Sub

    ' uƎw肷v`FbNON/OFF
    Private Sub chkMore_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkMore.CheckedChanged
        updateMoreInfo()
    End Sub

    ' uƎw肷v֌W̉ʕ\XV
    Private Sub updateMoreInfo()
        ' `FbN{bNXONSĂꍇ
        btnMore.Enabled = chkMore.Checked
        count_more.Enabled = chkMore.Checked

        ' w萔XV
        Dim j As Integer = 0
        ' WXgL[̃pXw肵ăWXgJ
        Dim rKey As RegistryKey = Registry.CurrentUser.OpenSubKey(Form1.rKeyName)
        If Not rKey Is Nothing Then
            ' WXg̒l擾
            With rKey
                Dim i As Integer
                Dim strValue As String
                Dim strBefore As String
                Dim strAfter As String

                For i = 0 To 999
                    strValue = "more" + i.ToString("D3") + "Before"
                    strBefore = .GetValue(strValue)
                    If Not strBefore Is Nothing Then
                        strValue = "more" + i.ToString("D3") + "After"
                        strAfter = .GetValue(strValue)

                        If Not strAfter Is Nothing Then
                            j += 1
                        End If
                    End If
                Next

                ' JWXgL[
                .Close()
            End With
        End If
        count_more.Text = mw.MJP("(" & j & "wς)", "(" & j & " pairs)")

    End Sub

    ' GR[h̃R{{bNX̓eς
    Private Sub ComboBox_Encodings_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBox_Encodings.SelectedIndexChanged
        If (clCodeList(ComboBox_Encodings.SelectedIndex).enc Is Nothing) Then
            txtOtherCP.Enabled = True
            txtOtherCP.Text = ""
        Else
            txtOtherCP.Enabled = False
            txtOtherCP.Text = "-"
        End If

    End Sub
End Class
