﻿Imports Microsoft.Win32

Public Class ComboBoxAdd
    ' コンボボックスへの文字列追加
    Public Shared Sub ComboBoxAdd(cb As ComboBox, text As String)
        Dim iNo As Integer

        ' すでにその文字列が存在していたら削除してから追加
        iNo = cb.Items.IndexOf(text)

        If iNo = 0 Then
            ' 0番目ならばなにもせず終了でよい
            Return

        ElseIf iNo > 0 Then
            cb.Items.RemoveAt(iNo)

        End If

        ' テキストを０番目に挿入
        cb.Items.Insert(0, text)

        ' この時点でリストが16を超えていたら、最後を削除
        If cb.Items.Count > 16 Then
            cb.Items.RemoveAt(16)
        End If
    End Sub

    ' コンボボックスの内容をレジストリから読み込み
    Public Shared Function ComboBoxLoad(cb As ComboBox, txtRegKey As String, txtRegValue As String, txtDefalut As String) As Boolean
        cb.Items.Clear()

        ' レジストリキーのパスを指定してレジストリを開く
        Dim rKey As RegistryKey = Registry.CurrentUser.OpenSubKey(txtRegKey)
        If Not rKey Is Nothing Then
            ' レジストリの値を取得
            With rKey
                Dim items As String() = rKey.GetValue(txtRegValue)
                Dim rv As Boolean = True

                If items Is Nothing Then
                    ' 値が存在しない…デフォルト値を設定
                    cb.Items.Add(txtDefalut)
                    rv = False

                Else
                    ' 値を1つずつコンボボックスへ追加
                    For Each item As String In items
                        cb.Items.Add(item)

                    Next

                End If

                .Close()    ' 開いたレジストリキーを閉じる
                Return rv
            End With

        Else
            ' はじめての読み込み
            cb.Items.Add(txtDefalut)
            Return False

        End If

    End Function

    ' コンボボックスの内容をレジストリへ書き込み
    Public Shared Sub ComboBoxSave(cb As ComboBox, txtRegKey As String, txtRegValue As String)
        ' レジストリキーを新規作成して開く
        Dim rKey As RegistryKey = Registry.CurrentUser.CreateSubKey(txtRegKey)

        ' レジストリの値を設定
        With rKey
            ' レジストリへ書き込むための文字列群を作成
            Dim items(cb.Items.Count - 1) As String

            For i As Integer = 0 To cb.Items.Count - 1
                items(i) = cb.Items.Item(i)
            Next

            .SetValue(txtRegValue, items)

            ' 開いたレジストリキーを閉じる
            .Close()
        End With

    End Sub

End Class
