Imports System.Text

Public Class AutoDetect
    ' R[h̎
    ' http://dobon.net/vb/dotnet/string/detectcode.html
    ' oCgnƁÃoCg񂩂z肳镶R[h Encoding ^ŕԋpBʂłȂꍇ Nothing ԂB
    ' UTF-7, UTF-32 ̔ɂ͖Ή. EBCDIC ɂRΉ
    Public Shared Function GetCode(ByVal byts() As Byte) As System.Text.Encoding
        Const bESC As Byte = &H1B
        Const bAT As Byte = &H40
        Const bDollar As Byte = &H24
        Const bAnd As Byte = &H26
        Const bOP As Byte = &H28 '(
        Const bB As Byte = &H42
        Const bD As Byte = &H44
        Const bJ As Byte = &H4A
        Const bI As Byte = &H49

        Dim len As Integer = byts.Length
        Dim [binary] As Integer = 0
        Dim ucs2 As Integer = 0
        Dim sjis As Integer = 0
        Dim euc As Integer = 0
        Dim utf8 As Integer = 0
        Dim b1, b2 As Byte

        Dim i As Integer
        For i = 0 To len - 1
            If byts(i) <= &H6 OrElse byts(i) = &H7F OrElse byts(i) = &HFF Then
                ''binary'
                [binary] += 1
                If len - 1 > i AndAlso byts(i) = &H0 AndAlso _
                i > 0 AndAlso byts(i - 1) <= &H7F Then
                    'smells like raw unicode
                    ucs2 += 1
                End If
            End If
        Next i

        If [binary] > 0 Then
            If ucs2 > 0 Then
                'JIS
                'ucs2(Unicode)
                Return New UnicodeEncoding(False, False)
                'binary
            Else
                Return Nothing
            End If
        End If

        For i = 0 To len - 2
            b1 = byts(i)
            b2 = byts(i + 1)

            If b1 = bESC Then
                If b2 >= &H80 Then
                    'not Japanese
                    'ASCIIAƂ肠Shift-JISƂďs
                    Return System.Text.Encoding.GetEncoding(932) 'System.Text.Encoding.ASCII
                Else
                    If len - 2 > i AndAlso _
                    b2 = bDollar AndAlso byts(i + 2) = bAT Then
                        'JIS_0208 1978
                        'JIS
                        Return System.Text.Encoding.GetEncoding(50220)
                    ElseIf len - 2 > i AndAlso _
                    b2 = bDollar AndAlso byts(i + 2) = bB Then
                        'JIS_0208 1983
                        'JIS
                        Return System.Text.Encoding.GetEncoding(50220)
                    ElseIf len - 5 > i AndAlso _
                    b2 = bAnd AndAlso byts(i + 2) = bAT AndAlso _
                    byts(i + 3) = bESC AndAlso byts(i + 4) = bDollar AndAlso _
                    byts((i + 5)) = bB Then
                        'JIS_0208 1990
                        'JIS
                        Return System.Text.Encoding.GetEncoding(50220)
                    ElseIf len - 3 > i AndAlso _
                    b2 = bDollar AndAlso byts(i + 2) = bOP AndAlso _
                    byts(i + 3) = bD Then
                        'JIS_0212
                        'JIS
                        Return System.Text.Encoding.GetEncoding(50220)
                    ElseIf len - 2 > i AndAlso b2 = bOP AndAlso _
                    (byts(i + 2) = bB OrElse byts(i + 2) = bJ) Then
                        'JIS_ASC
                        'JIS
                        Return System.Text.Encoding.GetEncoding(50220)
                    ElseIf len - 2 > i AndAlso _
                    b2 = bOP AndAlso byts(i + 2) = bI Then
                        'JIS_KANA
                        'JIS
                        Return System.Text.Encoding.GetEncoding(50220)
                    End If
                End If
            End If
        Next i

        For i = 0 To len - 2
            b1 = byts(i)
            b2 = byts(i + 1)
            If ((b1 >= &H81 AndAlso b1 <= &H9F) OrElse _
            (b1 >= &HE0 AndAlso b1 <= &HFC)) AndAlso _
            ((b2 >= &H40 AndAlso b2 <= &H7E) OrElse _
            (b2 >= &H80 AndAlso b2 <= &HFC)) Then
                sjis += 2
                i += 1
            End If
        Next i

        For i = 0 To len - 2
            b1 = byts(i)
            b2 = byts(i + 1)
            If ((b1 >= &HA1 AndAlso b1 <= &HFE) AndAlso _
            (b2 >= &HA1 AndAlso b2 <= &HFE)) OrElse _
            (b1 = &H8E AndAlso (b2 >= &HA1 AndAlso b2 <= &HDF)) Then
                euc += 2
                i += 1
            ElseIf len - 2 > i AndAlso b1 = &H8F AndAlso _
            (b2 >= &HA1 AndAlso b2 <= &HFE) AndAlso _
            (byts(i + 2) >= &HA1 AndAlso byts(i + 2) <= &HFE) Then
                euc += 3
                i += 2
            End If
        Next i

        For i = 0 To len - 2
            b1 = byts(i)
            b2 = byts(i + 1)
            If (b1 >= &HC0 AndAlso b1 <= &HDF) AndAlso _
            (b2 >= &H80 AndAlso b2 <= &HBF) Then
                utf8 += 2
                i += 1
            ElseIf len - 2 > i AndAlso _
            (b1 >= &HE0 AndAlso b1 <= &HEF) AndAlso _
            (b2 >= &H80 AndAlso b2 <= &HBF) AndAlso _
            (byts(i + 2) >= &H80 AndAlso byts(i + 2) <= &HBF) Then
                utf8 += 3
                i += 2
            End If
        Next i

        If euc > sjis AndAlso euc > utf8 Then
            'EUC
            Return System.Text.Encoding.GetEncoding(51932)
        ElseIf sjis > euc AndAlso sjis > utf8 Then
            'SJIS
            Return System.Text.Encoding.GetEncoding(932)
        ElseIf utf8 > euc AndAlso utf8 > sjis Then
            'UTF8
            Return New UTF8Encoding(False)
        End If
        Return Nothing
    End Function
End Class
