﻿Imports Microsoft.Win32

Public Class Form1

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' 日本語でWindows 10ならYu Gochicに
        If (mw.modeJP AndAlso Environment.OSVersion.Version.Major >= 10) Then
            Dim f As Font = New Font("Yu Gothic UI", 9)
            Me.Font = f
        End If

        Select Case mw.intFormat
            Case mw.cPng
                rbPng.Checked = True
            Case mw.cBmp
                rbBmp.Checked = True
            Case Else
                rbJpeg.Checked = True
        End Select

        ' クリップボード読み出しディレイ
        Me.ComboBoxDelay.SelectedIndex = mw.intDelay

        ' 簡易設定
        Me.txtFileNameBase.Text = mw.strFileName

        Me.chkUseNumber.Checked = mw.bAddNumber
        Me.txtNumber.Enabled = mw.bAddNumber

        Me.chkDateTime.Checked = mw.bAddDateTime
        Me.txtNumber.Value = mw.intNumber

        ' 詳細設定
        Me.txtFileNameFormat.Text = mw.strFileName2
        Me.txtNumber2.Value = mw.intNumber

        ' 簡易指定か詳細指定か？
        If mw.bolShosai = False Then
            TabControl1.SelectedIndex = 0
        Else
            TabControl1.SelectedIndex = 1
        End If

        ' 保存ダイアログは１つしか開かないようにする
        Me.chkSingle.Checked = mw.bolSingle

        ' ファイル名修正を省略する
        Me.chkSkipDlg.Checked = mw.bolSkipDlg

        ' 音とアイコン変化
        Me.chkSound.Checked = mw.bolSound

        ' テキストと認識されるものも処理対象
        Me.chkDoText.Checked = mw.bolDoText

        ' グレースケールに変換
        Me.chkGrayScale.Checked = mw.bolGrayScale

        ' 回転と反転
        Me.cmbRotateFlip.SelectedIndex = mw.intRotateFlip

        ' 拡大・縮小
        Select Case (mw.intZoomKind)
            Case 1
                rbPixel1.Checked = True

            Case 2
                rbPixel2.Checked = True

            Case Else
                rbPercent.Checked = True
        End Select
        textboxWidth.Value = mw.intZoomWidth
        textboxHeight.Value = mw.intZoomHeight

        ' 補完方式
        cmbInterpolationMode.SelectedIndex = mw.intInterpolationMode

        ' JPEG画質
        numJPEGQuality.Value = mw.intJpegQuality

        ' 日付時刻の埋め込み
        chkDrawDateTime.Checked = mw.bolDrawDT_DateTime   ' 画像に日付時刻を埋め込む
        cbDrawDT_Place.SelectedIndex = mw.intDrawDT_Place ' 位置指定
        txtDrawDT_Format.Text = mw.strDrawDT_Format       ' 書式

        ' フォントの生成
        If mw.strDrawDT_FontName <> "" Then
            Dim newStyle As System.Drawing.FontStyle = FontStyle.Regular
            If mw.bolDrawDT_FontBold Then
                newStyle = newStyle Or FontStyle.Bold
            End If
            If mw.bolDrawDT_FontItalic Then
                newStyle = newStyle Or FontStyle.Italic
            End If
            If mw.bolDrawDT_FontUnderline Then
                newStyle = newStyle Or FontStyle.Underline
            End If
            If mw.bolDrawDT_FontStrikeout Then
                newStyle = newStyle Or FontStyle.Strikeout
            End If
            FontDialog1.Font = New Font(mw.strDrawDT_FontName, mw.intDrawDT_FontSize, newStyle)

            FontDialog1.Color = Color.FromArgb(mw.intDrawDT_FontColor)     ' 色
        Else
            ' フォントが未設定の場合はMainWindowが採用しているフォントを仮採用する。文字色は白。
            FontDialog1.Font = mw.Font
            FontDialog1.Color = Color.White
        End If

        chkDrawDT_BackFillColor.Checked = mw.bolDrawDT_BackFillColor ' 背景色の塗り潰し
        ColorDialog1.Color = Color.FromArgb(mw.intDrawDT_BGColor)    ' 背景色

        ' 日付時刻埋め込みに関するチェックボックスとダイアログ項目有効無効の設定
        chkDrawDateTime_CheckedChanged(Nothing, Nothing)

        ' ホットキーの設定
        CheckBox_PS_SHIFT.Checked = mw.bolHotkeyPSShift
        CheckBox_PS_CTRL.Checked = mw.bolHotkeyPSCtrl
        CheckBox_PS_ALT.Checked = mw.bolHotkeyPSAlt
        ComboBox_PS.SelectedIndex = SelKeyIndex.getKeyIndex(mw.intHotkeyPSKeycd)
    End Sub

    ' 数値入力項目のチェック
    Private Function checkNumber(ByVal txtMean As String, ByVal txtValue As String, ByVal intMinValue As Integer, ByVal intMaxValue As Integer) As Boolean
        Try
            Dim intTemp As Integer = Integer.Parse(txtValue)

            If (intTemp < intMinValue OrElse intMaxValue < intTemp) Then
                MessageBox.Show(mw.MJP(txtMean + "には" & intMinValue & "～" & intMaxValue & "を指定してください。", txtMean + ":You must specify between " & intMinValue & " and " & intMaxValue & "."), mw.MJP("設定", "Settings"), MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return False
            End If
        Catch ex As System.FormatException
            MessageBox.Show(mw.MJP(txtMean + "には" & intMinValue & "～" & intMaxValue & "を指定してください。", txtMean + ":You must specify between " & intMinValue & " and " & intMaxValue & "."), mw.MJP("設定", "Settings"), MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        Catch ex As Exception
            ErrorDialog.ShowMessage(mw.MJP(txtMean + "には" & intMinValue & "～" & intMaxValue & "を指定してください。", txtMean + ":You must specify between " & intMinValue & " and " & intMaxValue & "."), ex.ToString(), mw.MJP("設定", "Settings"))
            Return False
        End Try

        Return True
    End Function

    Private Sub btnOK_Click(sender As System.Object, e As System.EventArgs) Handles btnOK.Click
        ' 設定をレジストリに保存してから、設定ダイアログを閉じる

        ' ■まずは入力検定
        If TabControl1.SelectedIndex = 0 Then
            ' 簡易設定の場合
            If Me.txtFileNameBase.Text = "" Then
                MessageBox.Show(mw.MJP("「出力先のフォルダ名＋ファイル名（拡張子を除く）の基礎部分」は、空にできません。", "'Base of the folder and file name' cannot be empty."), mw.MJP("設定", "Settings"), MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return
            End If

            ' 番号として数値が入力されているか
            If checkNumber(mw.MJP("連番の次番号", "Next"), Me.txtNumber.Text, 0, 99999999) = False Then
                Return
            End If

            Try
                ' フォルダの存在確認
                Dim strDirName As String = System.IO.Path.GetDirectoryName(Me.txtFileNameBase.Text)
                If Not System.IO.Directory.Exists(strDirName) Then
                    If strDirName Is Nothing Then
                        If DialogResult.Cancel = MessageBox.Show(mw.MJP("ルートフォルダが直接指定された可能性があります。設定を続行してもよろしいですか?", "The root folder may have been specified directly. Are you sure you continue?"), mw.MJP("設定", "Settings"), MessageBoxButtons.OKCancel, MessageBoxIcon.Question) Then
                            Return
                        End If
                    ElseIf DialogResult.Cancel = MessageBox.Show(mw.MJP("フォルダ " + strDirName + " は存在しません。設定を続行してもよろしいですか?", strDirName + " is not exist. Are you sure you continue?"), mw.MJP("設定", "Settings"), MessageBoxButtons.OKCancel, MessageBoxIcon.Question) Then
                        Return
                    End If
                End If
            Catch ex As System.ArgumentException
                MessageBox.Show(mw.MJP("「出力先のフォルダ名＋ファイル名の基礎部分」にフォルダ名として指定できない文字が含まれています。入力内容を見直してください。", "'Base of the folder and file name' contains unusable characters."), mw.MJP("設定", "Settings"), MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return
            Catch ex As Exception
                ErrorDialog.ShowMessage(mw.MJP("「出力先のフォルダ名＋ファイル名の基礎部分」が不正です。", "'Base of the folder and file name' is invalid."), ex.ToString(), mw.MJP("設定", "Settings"))
                Return
            End Try
        Else
            ' 詳細設定の場合
            If Me.txtFileNameFormat.Text = "" Then
                MessageBox.Show(mw.MJP("「出力先のフォルダ名＋ファイル名のフォーマット」は、空にできません。", "'Format of folder and File name' cannot be empty."), mw.MJP("設定", "Settings"), MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return
            End If

            ' 番号として数値が入力されているか
            If checkNumber(mw.MJP("連番の次番号", "Next Number"), Me.txtNumber2.Text, 0, 99999999) = False Then
                Return
            End If

            Try
                ' フォルダの存在確認
                Dim strDirName As String = System.IO.Path.GetDirectoryName(Me.txtFileNameBase.Text)
                If Not System.IO.Directory.Exists(strDirName) Then
                    ' フォルダの存在確認については、年月日や連番など不定なモノが入る可能性がアリ
                    ' とりあえずここでは存在を確認するフリだけ実施し、不正な文字を利用していた場合の
                    ' 例外の発生を誘う。
                End If
            Catch ex As System.ArgumentException
                MessageBox.Show(mw.MJP("「出力先のフォルダ名＋ファイル名のフォーマット」にフォルダ名として指定できない文字が含まれています。入力内容を見直してください。", "'Format of folder and File name' contains unusable characters."), mw.MJP("設定", "Settings"), MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return
            Catch ex As Exception
                ErrorDialog.ShowMessage(mw.MJP("「出力先のフォルダ名＋ファイル名のフォーマット」が不正です。", "'Format of folder and File name' is invalid."), ex.ToString(), mw.MJP("設定", "Settings"))
                Return
            End Try

        End If

        ' 拡大縮小幅として数値が入力されているか
        If checkNumber(mw.MJP("幅", "Width"), Me.textboxWidth.Text, 1, 9999) = False Then
            Return
        End If

        ' 拡大縮小高として数値が入力されているか
        If checkNumber(mw.MJP("高さ", "Height"), Me.textboxHeight.Text, 1, 9999) = False Then
            Return
        End If

        ' 画質
        If checkNumber(mw.MJP("JPEG画質", "JPEG Quality"), Me.numJPEGQuality.Text, 1, 100) = False Then
            Return
        End If

        ' ここまではロールバック
        ' ------------------------
        ' ここから書き込みコミット
        ' ■ダイアログ内容の読み出しとコミット

        ' 連番制御
        If TabControl1.SelectedIndex = 0 Then
            mw.intNumber = CInt(Me.txtNumber.Value)
        Else
            mw.intNumber = CInt(Me.txtNumber2.Value)
        End If

        ' まずはいったん、ダイアログから設定値を読み出す
        If rbJpeg.Checked Then
            mw.intFormat = mw.cJpeg
        ElseIf rbPng.Checked Then
            mw.intFormat = mw.cPng
        Else
            mw.intFormat = mw.cBmp
        End If

        ' 保存ダイアログは１つしか開かないようにする
        mw.bolSingle = chkSingle.Checked

        ' ファイル名修正を省略する
        mw.bolSkipDlg = chkSkipDlg.Checked

        ' 音とアイコン変化
        mw.bolSound = chkSound.Checked

        ' テキストと認識されるものも処理対象
        mw.bolDoText = chkDoText.Checked

        ' グレースケールに変換する
        mw.bolGrayScale = chkGrayScale.Checked

        ' 回転と反転
        mw.intRotateFlip = cmbRotateFlip.SelectedIndex

        ' 拡大・縮小
        If rbPercent.Checked Then
            mw.intZoomKind = 0
        ElseIf rbPixel1.Checked Then
            mw.intZoomKind = 1
        Else
            mw.intZoomKind = 2
        End If

        mw.intZoomWidth = CInt(Me.textboxWidth.Value)
        mw.intZoomHeight = CInt(Me.textboxHeight.Value)

        ' 補完方式
        mw.intInterpolationMode = Me.cmbInterpolationMode.SelectedIndex

        ' JPEG画質
        mw.intJpegQuality = CInt(Me.numJPEGQuality.Value)

        ' クリップボード読み出しディレイ
        mw.intDelay = ComboBoxDelay.SelectedIndex

        ' 簡易指定か詳細指定か
        If TabControl1.SelectedIndex = 1 Then
            mw.bolShosai = True
        Else
            mw.bolShosai = False
        End If

        ' [簡易指定の場合]
        mw.strFileName = Me.txtFileNameBase.Text
        mw.bAddDateTime = chkDateTime.Checked
        mw.bAddNumber = chkUseNumber.Checked

        ' [詳細指定の場合]
        mw.strFileName2 = Me.txtFileNameFormat.Text

        ' [日付時刻の埋め込み]
        mw.bolDrawDT_DateTime = chkDrawDateTime.Checked   ' 画像に日付時刻を埋め込む
        mw.intDrawDT_Place = cbDrawDT_Place.SelectedIndex ' 位置指定
        mw.strDrawDT_Format = txtDrawDT_Format.Text       ' 書式
        mw.strDrawDT_FontName = FontDialog1.Font.Name           ' フォント名
        mw.intDrawDT_FontSize = CInt(FontDialog1.Font.Size)     ' フォントサイズ
        mw.bolDrawDT_FontBold = FontDialog1.Font.Bold           ' 太字指定
        mw.bolDrawDT_FontItalic = FontDialog1.Font.Italic       ' 斜体指定
        mw.bolDrawDT_FontUnderline = FontDialog1.Font.Underline ' 下線
        mw.bolDrawDT_FontStrikeout = FontDialog1.Font.Strikeout ' 取消線
        mw.intDrawDT_FontColor = FontDialog1.Color.ToArgb       ' フォント色
        mw.bolDrawDT_BackFillColor = chkDrawDT_BackFillColor.Checked ' 背景色の塗り潰し
        mw.intDrawDT_BGColor = ColorDialog1.Color.ToArgb             ' 背景色

        ' 日付時刻埋め込みに関するチェックボックスとダイアログ項目有効無効の設定
        chkDrawDateTime_CheckedChanged(Nothing, Nothing)

        ' ホットキーの設定
        mw.bolHotkeyPSShift = CheckBox_PS_SHIFT.Checked
        mw.bolHotkeyPSCtrl = CheckBox_PS_CTRL.Checked
        mw.bolHotkeyPSAlt = CheckBox_PS_ALT.Checked
        mw.intHotkeyPSKeycd = SelKeyIndex.getKeyCd(ComboBox_PS.SelectedIndex)
        SelKeyIndex.UnregisterHotKey(mw.Handle, mw.WM_PAUSE_SWITCH)
        If ComboBox_PS.SelectedIndex <> 0 Then
            Dim modPS As Integer = 0
            If mw.bolHotkeyPSShift Then
                modPS = modPS + SelKeyIndex.MOD_SHIFT
            End If
            If mw.bolHotkeyPSCtrl Then
                modPS = modPS + SelKeyIndex.MOD_CONTROL
            End If
            If mw.bolHotkeyPSAlt Then
                modPS = modPS + SelKeyIndex.MOD_ALT
            End If
            If 0 = SelKeyIndex.RegisterHotKey(mw.Handle, mw.WM_PAUSE_SWITCH, _
                                              modPS, _
                                              mw.intHotkeyPSKeycd) Then
                ' ホットキー設定失敗
                MessageBox.Show(mw.MJP("ホットキーを登録できませんでした。", "Cannot Register a Hotkey."), mw.MJP("ホットキーの登録", "Hotkey"), MessageBoxButtons.OK, MessageBoxIcon.Warning)
            End If
        End If

        Try
            ' レジストリキーのパスを指定してレジストリを開く or iniファイル指定
            Dim hc As New HybridConfig

            If mw.bUseIni Then
                hc.OpenIniFile(mw.strIniName, mw.strIniSection)
            Else
                hc.OpenRegKey(Registry.CurrentUser.CreateSubKey(mw.strRegName))
            End If

            ' レジストリの値を取得
            With hc
                ' 簡易指定か詳細指定か
                .SetBolValue("Shosai", mw.bolShosai)

                ' ファイル名のベース
                .SetStrValue("FileNameBase", mw.strFileName)

                ' ファイル名のフォーマット
                .SetStrValue("FileNameFormat", mw.strFileName2)

                ' 日付時刻を付与する
                .SetBolValue("AddDateTime", mw.bAddDateTime)

                ' 連番を付けるか
                .SetBolValue("AddNumber", mw.bAddNumber)

                ' 保存形式
                .SetIntValue("SaveFormat", mw.intFormat)

                ' 保存ダイアログは1つしか開かないようにする
                .SetBolValue("Single", mw.bolSingle)

                ' ファイル名修正は省略する
                .SetBolValue("SkipDlg", mw.bolSkipDlg)

                ' 音とアイコン変化
                .SetBolValue("Sound", mw.bolSound)

                ' テキストと認識されるものも処理対象
                .SetBolValue("DoText", mw.bolDoText)

                ' グレースケールに変換
                .SetBolValue("GrayScale", mw.bolGrayScale)

                ' 回転と反転
                .SetIntValue("RotateFlip", mw.intRotateFlip)

                ' 拡大・縮小
                .SetIntValue("ZoomKind", mw.intZoomKind)
                .SetIntValue("ZoomWidth", mw.intZoomWidth)
                .SetIntValue("ZoomHeight", mw.intZoomHeight)

                ' 補完モード
                .SetIntValue("InterpolationMode", mw.intInterpolationMode)

                ' JPEG画質
                .SetIntValue("JpegQuality", mw.intJpegQuality)

                ' クリップボード読み出しディレイ
                .SetIntValue("Delay", mw.intDelay)

                ' 日付時刻の埋め込み
                .SetBolValue("bolDrawDT_DateTime", mw.bolDrawDT_DateTime)
                .SetIntValue("intDrawDT_Place", mw.intDrawDT_Place)
                .SetStrValue("strDrawDT_Format", mw.strDrawDT_Format)
                .SetStrValue("strDrawDT_FontName", mw.strDrawDT_FontName)
                .SetIntValue("intDrawDT_FontSize", mw.intDrawDT_FontSize)
                .SetBolValue("bolDrawDT_FontBold", mw.bolDrawDT_FontBold)
                .SetBolValue("bolDrawDT_FontItalic", mw.bolDrawDT_FontItalic)
                .SetBolValue("bolDrawDT_FontUnderline", mw.bolDrawDT_FontUnderline)
                .SetBolValue("bolDrawDT_FontStrikeout", mw.bolDrawDT_FontStrikeout)
                .SetIntValue("intDrawDT_FontColor", mw.intDrawDT_FontColor)
                .SetBolValue("bolDrawDT_BackFillColor", mw.bolDrawDT_BackFillColor)
                .SetIntValue("intDrawDT_BGColor", mw.intDrawDT_BGColor)

                ' ホットキー
                .SetBolValue("bolHotkeyPSShift", mw.bolHotkeyPSShift)
                .SetBolValue("bolHotkeyPSCtrl", mw.bolHotkeyPSCtrl)
                .SetBolValue("bolHotkeyPSAlt", mw.bolHotkeyPSAlt)
                .SetIntValue("intHotkeyPSKeycd", mw.intHotkeyPSKeycd)

                ' 起動時ダイアログを二度と表示しない
                .SetBolValue("boolNoShow", mw.boolNoShow)

                .Close()    ' 開いたレジストリキーを閉じる
            End With
        Catch ex As Exception
            ' レジストリへ書き込み失敗
            If mw.bUseIni Then
                ErrorDialog.ShowMessage(mw.MJP("iniファイルへ設定値を書込めません。", "Cannot write to the ini file."), ex.ToString(), mw.MJP("設定", "Settings"))
            Else
                ErrorDialog.ShowMessage(mw.MJP("レジストリへ設定値を書込めません。", "Cannot write to the registry."), ex.ToString(), mw.MJP("設定", "Settings"))
            End If

        End Try

        Me.Visible = False

        If mw.bFirstBoot Then
            mw.bFirstBoot = False
        End If

        Me.Close()

    End Sub

    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        ' 設定をレジストリに保存しないで、設定ダイアログを閉じる
        Me.Close()

        'bFirstBootが設定されていたとしても、クリアせずにダイアログを閉じる。これにより、呼び出し元にキャンセルを伝える仕組み
        'If mw.bFirstBoot Then
        'End If
    End Sub

    ' 参照ボタン押下（簡易）
    Private Sub btnBrowse_Click(sender As System.Object, e As System.EventArgs) Handles btnBrowse.Click
        FolderBrowserDialog1.SelectedPath = Me.txtFileNameBase.Text

        If FolderBrowserDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Me.txtFileNameBase.Text = FolderBrowserDialog1.SelectedPath

            ' 最後が \ で終わっていなかったら \ を付ける
            If Me.txtFileNameBase.Text.Length >= 1 Then
                If Me.txtFileNameBase.Text.Chars(Me.txtFileNameBase.Text.Length - 1) <> "\"c Then
                    Me.txtFileNameBase.Text += "\"
                End If
            End If

        End If
    End Sub

    ' 参照ボタン押下（詳細）
    Private Sub btnBrowse2_Click(sender As System.Object, e As System.EventArgs) Handles btnBrowse2.Click
        FolderBrowserDialog1.SelectedPath = Me.txtFileNameFormat.Text

        If FolderBrowserDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Me.txtFileNameFormat.Text = FolderBrowserDialog1.SelectedPath

            ' 最後が \ で終わっていなかったら \ を付ける
            If Me.txtFileNameFormat.Text.Length >= 1 Then
                If Me.txtFileNameFormat.Text.Chars(Me.txtFileNameFormat.Text.Length - 1) <> "\"c Then
                    Me.txtFileNameFormat.Text += "\"
                End If
            End If

        End If
    End Sub

    Private Sub chkUseNumber_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkUseNumber.CheckedChanged
        ' チェックボックスのON/OFFと番号入力欄の活性状態は連動する
        txtNumber.Enabled = chkUseNumber.Checked
    End Sub

    Private Sub Form1_Shown(sender As System.Object, e As System.EventArgs) Handles MyBase.Shown
        ' 最初は必ず最前面に表示されるように
        Me.TopMost = True
        Me.Refresh()
        Me.TopMost = False
    End Sub

    Private Sub rbPercent_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles rbPercent.CheckedChanged
        If rbPercent.Checked Then
            lblWidthUnit.Text = "%"
            lblHeightUnit.Text = "%"
        Else
            lblWidthUnit.Text = "px"
            lblHeightUnit.Text = "px"
        End If
    End Sub

    Private Sub btnHelp_Click(sender As System.Object, e As System.EventArgs) Handles btnHelp.Click
        mw.miHelp_Click(sender, e)
    End Sub

    ' 日付時刻埋め込みのチェックボックスとダイアログ項目有効化の対応
    Private Sub chkDrawDateTime_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkDrawDateTime.CheckedChanged, chkDrawDT_BackFillColor.CheckedChanged
        pnlDrawDT.Enabled = chkDrawDateTime.Checked
        btnDrawDT_BGColor.Enabled = chkDrawDT_BackFillColor.Checked
    End Sub

    ' [日付時刻埋め込み]フォントの指定
    Private Sub btnDrawDT_Font_Click(sender As System.Object, e As System.EventArgs) Handles btnDrawDT_Font.Click
        FontDialog1.ShowDialog()
    End Sub

    ' [日付時刻埋め込み]背景色の指定
    Private Sub btnDrawDT_BGColor_Click(sender As System.Object, e As System.EventArgs) Handles btnDrawDT_BGColor.Click
        ColorDialog1.ShowDialog()
    End Sub

End Class
