﻿Imports System.Runtime.InteropServices

Public Class SelKeyIndex
    ' ホットキーのキーインデックスの取得と設定
    Private Shared ReadOnly keyIndex As Integer() = {
        &H0,
        &H41,
        &H42,
        &H43,
        &H44,
        &H45,
        &H46,
        &H47,
        &H48,
        &H49,
        &H4A,
        &H4B,
        &H4C,
        &H4D,
        &H4E,
        &H4F,
        &H50,
        &H51,
        &H52,
        &H53,
        &H54,
        &H55,
        &H56,
        &H57,
        &H58,
        &H59,
        &H5A,
        &H30,
        &H31,
        &H32,
        &H33,
        &H34,
        &H35,
        &H36,
        &H37,
        &H38,
        &H39,
        &H70,
        &H71,
        &H72,
        &H73,
        &H74,
        &H75,
        &H76,
        &H77,
        &H78,
        &H79,
        &H7A,
        &H7B,
        &H7C,
        &H7D,
        &H7E,
        &H7F,
        &H80,
        &H81,
        &H82,
        &H83,
        &H84,
        &H85,
        &H86,
        &H87}

    ' キーコードからキーインデックスを求める
    ' 道のキーコードを与えられた場合は0を返す
    Public Shared Function getKeyIndex(keycd As Integer) As Integer
        Dim i As Integer

        For i = 0 To UBound(keyIndex)
            If keyIndex(i) = keycd Then
                Return i
            End If
        Next

        Return 0
    End Function

    ' キーインデックスからキーコードを求める
    ' 範囲外の場合は0を返す
    Public Shared Function getKeyCd(ki As Integer) As Integer
        If 0 <= ki AndAlso ki <= UBound(keyIndex) Then
            Return keyIndex(ki)
        End If

        Return 0
    End Function

    ' ホットキーを登録する
    <DllImport("user32", EntryPoint:="RegisterHotKey")> _
    Public Shared Function RegisterHotKey( _
        ByVal hWnd As IntPtr, _
        ByVal id As Integer, _
        ByVal fsModifier As Integer, _
        ByVal vk As Integer) _
        As Integer
    End Function

    ' ホットキーを解除する
    <DllImport("user32", EntryPoint:="UnregisterHotKey")> _
    Public Shared Function UnregisterHotKey( _
        ByVal hWnd As IntPtr, _
        ByVal id As Integer) _
        As Integer
    End Function

    ' ホットキーの修飾キー
    Public Const MOD_ALT As Byte = &H1
    Public Const MOD_CONTROL As Byte = &H2
    Public Const MOD_SHIFT As Byte = &H4


End Class
