﻿Imports Microsoft.Win32
Imports System.Runtime.InteropServices
Imports System.Globalization
Imports System.Threading
Imports System.Text
Imports System.IO

Public Class mw

    Declare Auto Sub AddClipboardFormatListener Lib "user32.dll" _
     Alias "AddClipboardFormatListener" (ByVal hwnd As IntPtr)

    Declare Auto Sub RemoveClipboardFormatListener Lib "user32.dll" _
     Alias "RemoveClipboardFormatListener" (ByVal hwnd As IntPtr)

    Public strSoftwareTitle As String
    Public strVersion As String
    Public strCopyright As String
    Public Const strBetaVer As String = "β"    ' ←β版の場合は"β", α版の場合は"α", 無印の場合は "" にしておくこと
    Public Const strURL As String = "https://www.inasoft.org/"
    Public Const strRegName As String = "Software\InaSoftAns\CaptureSaveAs\CurrentVersion"
    Public Const strIniName As String = ".\CaptureSaveAs.ini"
    Public Const strIniSection As String = "Settings"
    Public Const strHelpFileName As String = ".\CaptureSaveAs.chm"

    Public Const cJpeg As Integer = 0
    Public Const cPng As Integer = 1
    Public Const cBmp As Integer = 2

    ' ポータブルモードか
    Public bUseIni As Boolean = False

    ' 隠し機能はDLLが存在していれば使える
    ' Public bEnableCreateBarCode As Boolean = False

    ' 一時的にオフになっているか
    Public Shared bPause As Boolean = False

    ' [設定]
    ' 保存形式(Jpeg or PNG)
    Public Shared intFormat As Integer = cJpeg
    ' 簡易指定になっているか？　詳細指定になっているか？
    Public Shared bolShosai As Boolean = False
    ' クリップボード読み出しディレイ
    Public Shared intDelay As Integer = 0

    ' [設定] - 簡易指定
    ' 保存先のフォルダ名＋ファイル名のベース
    Public Shared strFileName As String = ""
    ' ファイル名に日付時刻を付与するか
    Public Shared bAddDateTime As Boolean = True
    ' ファイル名に連番を付けるか
    Public Shared bAddNumber As Boolean = True
    Public Shared intNumber As Integer = 1

    ' [設定] - 詳細指定
    ' 保存先のフォルダ名＋ファイル名のフォーマット
    Public Shared strFileName2 As String = ""

    ' [一般]
    ' 保存ダイアログは１つしか開かないようにする
    Public Shared bolSingle As Boolean = False
    ' ファイル名修正を省略する
    Public Shared bolSkipDlg As Boolean = False

    ' 音を鳴らす
    Public Shared bolSound As Boolean = False

    ' [加工]
    ' グレースケールに変換する
    Public Shared bolGrayScale As Boolean = False

    ' 回転と反転
    Public Shared intRotateFlip As Integer = 0      ' RotateFlip enumの値そのまま

    ' 拡大・縮小
    Public Shared intZoomKind As Integer = 0        ' 0:相対、1:絶対、2:絶対（アスペクト比固定）
    Public Shared intZoomWidth As Integer = 100     ' 拡大率または固定値
    Public Shared intZoomHeight As Integer = 100    ' 拡大率または固定値

    ' 拡大縮小補完方式
    Public Shared intInterpolationMode As Integer = 0

    ' JPEG画質
    Public Shared intJpegQuality As Integer = 80

    ' テキスト的なモノも処理対象にする
    Public Shared bolDoText As Boolean = False

    ' [日付時刻の埋め込み]
    ' 画像に日付時刻を埋め込む
    Public Shared bolDrawDT_DateTime As Boolean

    ' 位置指定（0:左上、1:中上、2:右上、3:左中、4:画像中央、5:右中、6:左下、7:中下、8:右下）
    Public Shared intDrawDT_Place As Integer = 8

    ' 書式（フォーマットはファイル名の詳細指定と同じ）
    Public Shared strDrawDT_Format As String = "<%t4y>/<%t0m>/<%t0d> <%t0h>:<%t0n>:<%t0s>"

    ' フォント
    Public Shared strDrawDT_FontName As String                ' フォント名
    Public Shared intDrawDT_FontColor As Integer = &HFF000000 ' フォント色
    Public Shared intDrawDT_FontSize As Integer               ' フォントサイズ
    Public Shared bolDrawDT_FontBold As Boolean               ' 太字指定
    Public Shared bolDrawDT_FontItalic As Boolean             ' 斜体指定
    Public Shared bolDrawDT_FontUnderline As Boolean          ' 下線
    Public Shared bolDrawDT_FontStrikeout As Boolean          ' 取消線

    ' 背景を単色で塗りつぶす
    Public Shared bolDrawDT_BackFillColor As Boolean

    ' 背景色
    Public Shared intDrawDT_BGColor As Integer = &HFFFFFFFF

    ' ホットキー
    Public Shared bolHotkeyPSShift As Boolean = False
    Public Shared bolHotkeyPSCtrl As Boolean = False
    Public Shared bolHotkeyPSAlt As Boolean = False
    Public Shared intHotkeyPSKeycd As Integer = 0


    ' 初回起動？
    Public Shared bFirstBoot As Boolean = False
    ' クリップボード監視中？
    Public Shared bClipboardListening As Boolean = False

    ' 起動時ダイアログを二度と表示しない
    Public Shared boolNoShow As Boolean = False

    ' キャプチャウィンドウのプール
    Public Shared CaptureWindowPool As New Dictionary(Of ULong, CaptureWindow)

    ' 起動時ダイアログのインスタンス
    Dim dlgOpening As OpeningDlg

    ' SendMessage APIの宣言
    Public Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" _
        (ByVal hwnd As IntPtr, ByVal msg As UInteger, ByVal wParam As IntPtr, ByVal lParam As IntPtr) As IntPtr

    <DllImport("user32.dll", CharSet:=CharSet.Auto, SetLastError:=True)> _
    Public Shared Function FindWindow(lpClassName As String, _
        lpWindowName As String) As IntPtr
    End Function

    ' 独自ウィンドウメッセージ
    Public Const WM_DESTROY As Int32 = &H2
    Public Const WM_APP As Int32 = &H800
    Public Const WM_PAUSE_SWITCH As Int32 = WM_APP + 0
    Public Const WM_PAUSE_ON As Int32 = WM_APP + 1
    Public Const WM_PAUSE_OFF As Int32 = WM_APP + 2
    Public Const WM_HOTKEY As Int32 = &H312

    ' バージョン情報取得
    Private Sub GetVersionInfo()
        'AssemblyTitleの取得
        Dim asmttl As System.Reflection.AssemblyTitleAttribute = _
            CType(Attribute.GetCustomAttribute( _
                System.Reflection.Assembly.GetExecutingAssembly(), _
                GetType(System.Reflection.AssemblyTitleAttribute)),  _
                    System.Reflection.AssemblyTitleAttribute)
        strSoftwareTitle = asmttl.Title

        'AssemblyCopyrightの取得
        Dim asmcpy As System.Reflection.AssemblyCopyrightAttribute = _
            CType(Attribute.GetCustomAttribute( _
                System.Reflection.Assembly.GetExecutingAssembly(), _
                GetType(System.Reflection.AssemblyCopyrightAttribute)),  _
                    System.Reflection.AssemblyCopyrightAttribute)
        strCopyright = asmcpy.Copyright + vbCrLf + vbCrLf + "https://www.inasoft.org/"

        '自分自身のバージョン情報を取得する
        Dim ver As System.Diagnostics.FileVersionInfo = _
            System.Diagnostics.FileVersionInfo.GetVersionInfo( _
            System.Reflection.Assembly.GetExecutingAssembly().Location)
        strVersion = "" & ver.FileMajorPart & "." & ver.FileMinorPart & ver.FileBuildPart & strBetaVer

    End Sub

    Public Shared modeJP As Boolean = True
    Public Shared Function MJP(jstr As String, estr As String) As String
        If mw.modeJP Then
            Return jstr
        Else
            Return estr
        End If
    End Function

    Private Sub MainWindow_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' check culture and set en, if not ja.
        ' あるいは、環境変数CSA_LANG=JAでないならば英語モード
        Dim envlang As String = Environment.GetEnvironmentVariable("CSA_LANG")
        Dim strOuputFileName As String = Nothing

        If (Not envlang Is Nothing AndAlso envlang.ToUpper = "JA") Then
            Thread.CurrentThread.CurrentUICulture = New CultureInfo("ja", False)
        ElseIf ((Not envlang Is Nothing AndAlso envlang.ToUpper <> "JA") OrElse _
            (Not Thread.CurrentThread.CurrentUICulture.Name.StartsWith("ja") AndAlso Not Thread.CurrentThread.CurrentUICulture.Name.StartsWith("en"))) Then
            Thread.CurrentThread.CurrentUICulture = New CultureInfo("en", False)
            mw.modeJP = False
        ElseIf Thread.CurrentThread.CurrentUICulture.Name.StartsWith("en") Then
            mw.modeJP = False
        End If

        If Not mw.modeJP Then
            miSettings.Text = "Settings..."
            miPause.Text = "&Pause"
            miOpenFolder.Text = "Open &Folder"
            miHelp.Text = "&Help (Japanese)"
            miAbout.Text = "&About"
            miExit.Text = "E&xit"
        End If

        ' 日本語でWindows 10ならYu Gochicに
        If (mw.modeJP AndAlso Environment.OSVersion.Version.Major >= 10) Then
            Dim f As Font = New Font("Yu Gothic UI", 9)
            Me.Font = f
        End If

        'コマンドラインオプションの解析
        Dim cmds As String() = System.Environment.GetCommandLineArgs()
        If (cmds.Length >= 2) Then
            If cmds(1).Equals("/X", StringComparison.OrdinalIgnoreCase) Then ' サイレントに終了
                Dim hWnd As IntPtr = FindWindow(Nothing, Me.Text + " - WaitWindow0")
                If hWnd <> IntPtr.Zero Then
                    SendMessage(hWnd, WM_DESTROY, IntPtr.Zero, IntPtr.Zero)
                End If
                Me.Close()
                Return

            ElseIf cmds(1).Equals("/P", StringComparison.OrdinalIgnoreCase) Then ' ポーズ状態のスイッチ
                Dim ps() As Process = Diagnostics.Process.GetProcessesByName(Diagnostics.Process.GetCurrentProcess.ProcessName)

                For Each p As Process In ps
                    ' 常駐済みのプロセス（同名で自プロセス以外のプロセス）に対して、ポーズ状態のスイッチを指示する
                    ' 指示相手がいない場合は、ポーズ状態で起動する
                    Dim hWnd As IntPtr = FindWindow(Nothing, Me.Text + " - WaitWindow0")
                    If hWnd <> IntPtr.Zero Then
                        SendMessage(hWnd, WM_PAUSE_SWITCH, IntPtr.Zero, IntPtr.Zero)
                        Me.Close()
                        Return
                    End If
                Next

                ' 指示相手がいなかったので、自らへの指示と解釈する。
                ' 起動時は必ず動作状態なので、一時停止にする。
                miPause_Click(Nothing, Nothing)

            ElseIf cmds(1).Equals("/P:ON", StringComparison.OrdinalIgnoreCase) Then ' 動作状態へスイッチ
                Dim ps() As Process = Diagnostics.Process.GetProcessesByName(Diagnostics.Process.GetCurrentProcess.ProcessName)

                For Each p As Process In ps
                    ' 常駐済みのプロセス（同名で自プロセス以外のプロセス）に対して、動作状態になるよう指示する
                    ' 指示相手がいない場合は、動作状態で起動する（つまり、普通に起動する）
                    Dim hWnd As IntPtr = FindWindow(Nothing, Me.Text + " - WaitWindow0")
                    If hWnd <> IntPtr.Zero Then
                        SendMessage(hWnd, WM_PAUSE_ON, IntPtr.Zero, IntPtr.Zero)
                        Me.Close()
                        Return
                    End If
                Next

                ' 指示相手がいなかったので、自らへの指示と解釈する。
                ' 起動時は必ず動作状態なので、ぶっちゃけ、ここでは何もしない。

            ElseIf cmds(1).Equals("/P:OFF", StringComparison.OrdinalIgnoreCase) Then ' 一時停止状態へスイッチ
                Dim ps() As Process = Diagnostics.Process.GetProcessesByName(Diagnostics.Process.GetCurrentProcess.ProcessName)

                For Each p As Process In ps
                    ' 常駐済みのプロセス（同名で自プロセス以外のプロセス）に対して、ポーズ状態のスイッチを指示する
                    ' 指示相手がいない場合は、ポーズ状態で起動する
                    Dim hWnd As IntPtr = FindWindow(Nothing, Me.Text + " - WaitWindow0")
                    If hWnd <> IntPtr.Zero Then
                        SendMessage(hWnd, WM_PAUSE_OFF, IntPtr.Zero, IntPtr.Zero)
                        Me.Close()
                        Return
                    End If
                Next

                ' 指示相手がいなかったので、自らへの指示と解釈する。
                ' 起動時は必ず動作状態なので、一時停止にする。
                miPause_Click(Nothing, Nothing)

            ElseIf cmds(1).Equals("/O", StringComparison.OrdinalIgnoreCase) Then ' ポータブルモード
                bUseIni = True

                ' ファイルへ保存して終了
            ElseIf cmds(1).Length >= 3 AndAlso cmds(1).Substring(0, 3).Equals("/F:", StringComparison.OrdinalIgnoreCase) Then
                strOuputFileName = cmds(1).Substring(3)

            ElseIf cmds(1).Equals("/F", StringComparison.OrdinalIgnoreCase) Then
                strOuputFileName = String.Empty

            End If

        End If
        cmds = Nothing

        ' プログラムファイル名が _o.exe で終わっているならばポータブルモード
        Dim ownexepath As String = System.Reflection.Assembly.GetExecutingAssembly().Location
        If (ownexepath.Length >= 6 AndAlso String.Compare(ownexepath.Substring(ownexepath.Length - 6, 6), "_o.exe", True) = 0) Then
            bUseIni = True
        End If
        ownexepath = Nothing

        '二重起動をチェックする
        If Diagnostics.Process.GetProcessesByName( _
            Diagnostics.Process.GetCurrentProcess.ProcessName).Length > 1 Then
            'すでに起動していると判断する
            Me.NotifyIcon1.Dispose()
            ''MessageBox.Show(mw.MJP("多重起動はできません。", "Already running."), strSoftwareTitle, MessageBoxButtons.OK, MessageBoxIcon.Error)

            ' 一般の警告音を鳴らす
            System.Media.SystemSounds.Beep.Play()

            ' 二重起動時ダイアログの表示
            Dim dbForm As New DblBoot
            dbForm.ShowDialog()

            Me.Close()
            Return
        End If

        '' 隠し機能のためのDLLの存在チェック
        'If System.IO.File.Exists(My.Computer.FileSystem.CombinePath(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location), "DotNetBarcode.dll")) Then
        '   bEnableCreateBarCode = True
        'End If

        ' バージョン情報の取得
        GetVersionInfo()

        ' はじめて本ソフトを開いたときは、保存先を設定させるためにデフォルトで表示
        Try
            ' レジストリキーのパスを指定してレジストリを開く
            Dim hc As New HybridConfig

            If bUseIni Then
                hc.OpenIniFile(strIniName, strIniSection)
            Else
                hc.OpenRegKey(Registry.CurrentUser.OpenSubKey(strRegName))
            End If

            ' 設定値の読込
            With hc
                ' 簡易指定か詳細指定か
                bolShosai = .GetBolValue("Shosai", False)

                ' ファイル名のベース[簡易指定の場合]
                strFileName = .GetStrValue("FileNameBase", "")

                ' ファイル名のフォーマット[詳細指定の場合]
                strFileName2 = .GetStrValue("FileNameFormat", "")

                ' 日付時刻付与[簡易指定の場合]
                bAddDateTime = .GetBolValue("AddDateTime", True)

                ' 連番を付けるか[簡易指定の場合]
                bAddNumber = .GetBolValue("AddNumber", True)

                ' 保存形式
                Select Case .GetIntValue("SaveFormat", 0)
                    Case cPng
                        intFormat = cPng ' Png
                    Case cBmp
                        intFormat = cBmp ' BMP
                    Case Else
                        intFormat = cJpeg ' Jpeg
                End Select

                ' 保存ダイアログは１つしか開かないようにする
                bolSingle = .GetBolValue("Single", False)

                ' ファイル名修正を省略する
                bolSkipDlg = .GetBolValue("SkipDlg", False)

                ' 音とアイコン変化
                bolSound = .GetBolValue("Sound", False)

                ' テキストと認識されるものも処理
                bolDoText = .GetBolValue("DoText", False)

                ' グレースケールに変換
                bolGrayScale = .GetBolValue("GrayScale", False)

                ' 回転と反転
                intRotateFlip = .GetIntValue("RotateFlip", 0)
                If (intRotateFlip < 0 OrElse 7 < intRotateFlip) Then
                    intRotateFlip = 0
                End If

                ' 拡大縮小
                intZoomKind = .GetIntValue("ZoomKind", 0)
                If (intZoomKind < 0 OrElse 2 < intZoomKind) Then
                    intZoomKind = 0
                    intZoomWidth = 100
                    intZoomHeight = 100
                Else
                    intZoomWidth = .GetIntValue("ZoomWidth", 0)
                    If (intZoomWidth < 1 OrElse 9999 < intZoomWidth) Then
                        intZoomWidth = 100
                    End If
                    intZoomHeight = .GetIntValue("ZoomHeight", 0)
                    If (intZoomHeight < 1 OrElse 9999 < intZoomHeight) Then
                        intZoomHeight = 100
                    End If
                End If

                ' 補完方式
                intInterpolationMode = .GetIntValue("InterpolationMode", 0)
                If (intInterpolationMode < 0 OrElse 7 < intInterpolationMode) Then
                    intInterpolationMode = 0
                End If

                ' JPEG画質
                intJpegQuality = .GetIntValue("JpegQuality", 0)
                If (intJpegQuality < 1 OrElse 100 < intJpegQuality) Then
                    intJpegQuality = 80
                End If

                ' クリップボード読み出しディレイ
                intDelay = .GetIntValue("Delay", 0)

                ' 日付時刻の埋め込み
                bolDrawDT_DateTime = .GetBolValue("bolDrawDT_DateTime", False)
                intDrawDT_Place = .GetIntValue("intDrawDT_Place", 8)
                If intDrawDT_Place < 0 OrElse 8 < intDrawDT_Place Then
                    intDrawDT_Place = 8
                End If
                strDrawDT_Format = .GetStrValue("strDrawDT_Format", "<%t4y>/<%t0m>/<%t0d> <%t0h>:<%t0n>:<%t0s>")
                strDrawDT_FontName = .GetStrValue("strDrawDT_FontName", "")
                intDrawDT_FontSize = .GetIntValue("intDrawDT_FontSize", 10)
                If intDrawDT_FontSize < 6 OrElse 72 < intDrawDT_FontSize Then
                    intDrawDT_FontSize = 10
                End If
                bolDrawDT_FontBold = .GetBolValue("bolDrawDT_FontBold", False)
                bolDrawDT_FontItalic = .GetBolValue("bolDrawDT_FontItalic", False)
                bolDrawDT_FontUnderline = .GetBolValue("bolDrawDT_FontUnderline", False)
                bolDrawDT_FontStrikeout = .GetBolValue("bolDrawDT_FontStrikeout", False)
                intDrawDT_FontColor = .GetIntValue("intDrawDT_FontColor", &HFF000000)
                bolDrawDT_BackFillColor = .GetBolValue("bolDrawDT_BackFillColor", False)
                intDrawDT_BGColor = .GetIntValue("intDrawDT_BGColor", &HFFFFFFFF)

                boolNoShow = .GetBolValue("boolNoShow", False)

                ' ホットキー
                bolHotkeyPSShift = .GetBolValue("bolHotkeyPSShift", False)
                bolHotkeyPSCtrl = .GetBolValue("bolHotkeyPSCtrl", False)
                bolHotkeyPSAlt = .GetBolValue("bolHotkeyPSAlt", False)
                intHotkeyPSKeycd = .GetIntValue("intHotkeyPSKeycd", 0)
                If intHotkeyPSKeycd <> 0 Then
                    Dim modPS As Integer = 0
                    If mw.bolHotkeyPSShift Then
                        modPS = modPS + SelKeyIndex.MOD_SHIFT
                    End If
                    If mw.bolHotkeyPSCtrl Then
                        modPS = modPS + SelKeyIndex.MOD_CONTROL
                    End If
                    If mw.bolHotkeyPSAlt Then
                        modPS = modPS + SelKeyIndex.MOD_ALT
                    End If
                    If 0 = SelKeyIndex.RegisterHotKey(Me.Handle, WM_PAUSE_SWITCH, _
                                                      modPS, _
                                                      intHotkeyPSKeycd) Then
                        ' ホットキー設定失敗
                        MessageBox.Show(mw.MJP("ホットキーを登録できませんでした。", "Cannot Register a Hotkey."), mw.MJP("ホットキーの登録", "Hotkey"), MessageBoxButtons.OK, MessageBoxIcon.Warning)
                    End If
                End If


                .Close()    ' 開いたレジストリキーを閉じる
            End With
        Catch ex As Exception
            ' 読み込みに失敗
            ' 失敗でも、とりあえず何もしない
            ' (後にファイル名が空だった場合のルートがあるので、そこにゆだねる)
        End Try

        ' 過去β版との互換のため、値が存在しなければ別に初期化
        If strFileName2 = "" Then
            strFileName2 = System.Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory) + "\Base-<%t4y><%t0m><%t0d>-<%t0h><%t0n><%t0s>-<%n8>-*"
        End If

        ' パラメータが '/F' または '/F:ファイル名' のときは、ファイル出力して即終了
        If Not strOuputFileName Is Nothing Then
            ' コマンドライン指定でファイル名
            If strOuputFileName <> String.Empty Then
                bolShosai = False
                mw.strFileName = strOuputFileName
            ElseIf mw.strFileName = "" Then
                ' 一度も起動されていない場合は、ファイル名は簡易指定のデフォルトとする
                mw.strFileName = System.Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory) + "\Base-"
            End If

            ' 保存ボタン押下はスキップ
            mw.bolSkipDlg = True
            ' 音は鳴らさない
            mw.bolSound = False

            Try
                'If (Clipboard.ContainsImage() OrElse (bEnableCreateBarCode AndAlso Clipboard.ContainsText())) Then
                ' 中身がイメージ または、(QRコード変換されようとする)テキストだったら
                If (Clipboard.ContainsImage()) Then
                    ' 中身がイメージだったら

                    'If (Clipboard.ContainsImage()) Then
                    ' クリップボード内の画像をファイル出力
                    TimerForDelay_Tick(Nothing, Nothing)

                    'Else
                    ' テキストと認識されるモノの場合
                    '   If bolDoText = False Then
                    '        MessageBox.Show(mw.MJP("クリップボードの中身は画像ではありません。", "Clipboard does not contains an image."), mw.MJP("クリップボードの画像を保存", "Save image in clipboard"), MessageBoxButtons.OK, MessageBoxIcon.Error)
                    '   Else
                    '        ' 隠し機能（文字列のバーコード化：【DotNetBarcodeV2.4.0クラスライブラリ(DotNetBarcode.dll)】使用
                    '       CopyBarcode()
                    '       ' これでクリップボードに画像としてQRコードがコピーされたので、改めて画像保存する
                    '       TimerForDelay_Tick(Nothing, Nothing)

                    '   End If

                    'End If

                Else
                    MessageBox.Show(mw.MJP("クリップボードの中身が画像等ではありません。", "Clipboard dose not contain an image."), mw.MJP("クリップボードの画像を保存", "Save image in clipboard"), MessageBoxButtons.OK, MessageBoxIcon.Error)

                End If
            Catch ex As Exception
                MessageBox.Show(mw.MJP("クリップボードの画像を保存中にエラーが発生しました。" + vbCrLf + ex.ToString(), "Cannot save image in clipboard." + vbCrLf + ex.ToString()), mw.MJP("クリップボードの画像を保存", "Save image in clipboard"), MessageBoxButtons.OK, MessageBoxIcon.Error)
            End Try

            ' 設定を保存せずに終了
            Me.Close()
            Return

        End If

        ' 起動時ダイアログの表示（日本語モードのみ）
        If mw.modeJP AndAlso boolNoShow = False Then
            dlgOpening = New OpeningDlg
            dlgOpening.Show()
        End If

        ' ファイル名が空だった場合は、初回と見なし、設定ダイアログを開く
        ' 初期値はデスクトップ\Base-
        If strFileName = "" Then
            bFirstBoot = True
            strFileName = System.Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory) + "\Base-"
            miSettings_Click(sender, e)
            If bFirstBoot = True Then
                ' キャンセルされた
                Me.Close()
                Return
            End If
        End If

        ' クリップボード監視の開始
        AddClipboardFormatListener(Me.Handle)
        bClipboardListening = True

        ' ウィンドウ名の加工
        Me.Text += " - WaitWindow0"
    End Sub

    Private Sub ContextMenuStrip1_Opening(sender As System.Object, e As System.ComponentModel.CancelEventArgs) Handles ContextMenuStrip1.Opening
        ' メニューが開いたら、一時停止状態をチェック状態として反映
        miPause.Checked = bPause
    End Sub

    Private Sub miSettings_Click(sender As System.Object, e As System.EventArgs) Handles miSettings.Click
        ' 設定ダイアログを開く
        Static f1 As Form1 = Nothing

        If f1 Is Nothing Then
            ' まだ表示していなければロードして表示
            f1 = New Form1
            f1.ShowDialog()
            f1 = Nothing
        Else
            ' すでに設定ダイアログが表示済みなら、最前面に表示するだけ
            f1.TopMost = True
            f1.Refresh()
            f1.TopMost = False
        End If

    End Sub

    Private Sub miPause_Click(sender As System.Object, e As System.EventArgs) Handles miPause.Click
        ' 一時停止状態の変更
        bPause = Not bPause
        If bPause Then
            Me.NotifyIcon1.Icon = My.Resources.CaptureSaveAsPause
        Else
            Me.NotifyIcon1.Icon = Form1.Icon
        End If
    End Sub

    Public Shared Sub miHelp_Click(sender As System.Object, e As System.EventArgs) Handles miHelp.Click
        ' ドキュメントの表示
        Try
            System.Diagnostics.Process.Start(strHelpFileName)
        Catch ex As Exception
            ErrorDialog.ShowMessage(strHelpFileName + mw.MJP("を開けません。", ": Cannot open."), ex.ToString(), mw.MJP("ヘルプを開く", "Show Help"))
        End Try
    End Sub

    Private Sub miAbout_Click(sender As System.Object, e As System.EventArgs) Handles miAbout.Click
        ' バージョン情報の表示
        Static dlgAboutBox As AboutDialog = Nothing

        If dlgAboutBox Is Nothing Then
            ' まだ表示していなければロードして表示
            dlgAboutBox = New AboutDialog
            dlgAboutBox.ShowDialog()
            dlgAboutBox = Nothing
        Else
            ' すでに設定ダイアログが表示済みなら、最前面にするだけ
            dlgAboutBox.TopMost = True
            dlgAboutBox.Refresh()
            dlgAboutBox.TopMost = False
        End If

    End Sub

    Private Sub miExit_Click(sender As System.Object, e As System.EventArgs) Handles miExit.Click
        ' 終了
        If CaptureWindowPool.Count > 0 Then
            If DialogResult.Cancel = MessageBox.Show(mw.MJP("未保存の画像があります。終了してもよろしいですか?", "There are some pictures of the unsaved. Are you sure you want to quit?"), strSoftwareTitle, MessageBoxButtons.OKCancel, MessageBoxIcon.Question) Then
                ' キャンセル
                Return
            End If
        End If

        If bClipboardListening Then
            RemoveClipboardFormatListener(Me.Handle)
        End If

        ' ホットキーを登録していたら解除
        If mw.intHotkeyPSKeycd <> 0 Then
            SelKeyIndex.UnregisterHotKey(Me.Handle, WM_PAUSE_SWITCH)
        End If

        NotifyIcon1.Dispose()
        Me.Close()
    End Sub

    Private Sub NotifyIcon1_MouseDoubleClick(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles NotifyIcon1.MouseDoubleClick
        ' タスクトレイアイコンをダブルクリックしたら、設定を開く
        miSettings_Click(sender, e)
    End Sub

    ' メインウィンドウのカスタムメッセージ受信
    Protected Overrides Sub WndProc(ByRef m As Message)
        Select Case m.Msg
            Case &H31D ' クリップボード監視 - クリップボードが変更されたら
                If bPause = False Then ' 一時停止中ではないこと
                    'If (Clipboard.ContainsImage() OrElse (bEnableCreateBarCode AndAlso Clipboard.ContainsText())) Then
                    ' 中身がイメージ または、(QRコード変換されようとする)テキストだったら
                    If (Clipboard.ContainsImage()) Then
                        ' 中身がイメージ だったら

                        If bolDoText = False AndAlso Clipboard.ContainsText() Then
                            ' テキストと認識されるモノの場合
                            '（Excelセルのようなものもそうだし、QRコード生成されようとしているテキストかもしれない）
                            ' なにもしない
                        Else
                            ' ディレイ時間確定（クリップボードを扱う他のプログラムとの相性問題があるときのため）
                            Dim DelayMsec As Integer = 0

                            Select Case mw.intDelay
                                Case 1
                                    DelayMsec = 100

                                Case 2
                                    DelayMsec = 200

                                Case 3
                                    DelayMsec = 500

                                Case 4
                                    DelayMsec = 700

                                Case 5
                                    DelayMsec = 1000

                                Case Else
                                    DelayMsec = 0
                            End Select

                            If DelayMsec = 0 Then
                                TimerForDelay_Tick(Nothing, Nothing)
                            Else
                                TimerForDelay.Interval = DelayMsec
                                TimerForDelay.Start()
                            End If
                        End If
                    End If
                End If

                ' 処理は即座に返す
                m.Result = IntPtr.Zero

            Case WM_HOTKEY
                ' ホットキー検知
                If CInt(m.WParam) = WM_PAUSE_SWITCH Then
                    ' Pause ON/OFF Switch
                    miPause_Click(Nothing, Nothing)
                    m.Result = IntPtr.Zero
                End If

            Case WM_PAUSE_SWITCH
                ' /Pオプション
                miPause_Click(Nothing, Nothing)
                m.Result = IntPtr.Zero

            Case WM_PAUSE_OFF
                ' /P:OFF - 一時停止状態へ
                bPause = False
                miPause_Click(Nothing, Nothing) ' bPauseの状態を反転させる
                m.Result = IntPtr.Zero

            Case WM_PAUSE_ON
                ' /P:ON - 動作状態へ
                bPause = True
                miPause_Click(Nothing, Nothing) ' bPauseの状態を反転させる
                m.Result = IntPtr.Zero

            Case Else
                MyBase.WndProc(m)

        End Select
    End Sub

    ' 隠し機能（文字列のバーコード化：【DotNetBarcodeV2.4.0クラスライブラリ(DotNetBarcode.dll)】使用
    'Private Sub CopyBarcode()
    '    Dim bc1 As DotNetBarcode = New DotNetBarcode(DotNetBarcode.Types.QRCode)
    '    bc1.CopyToClipboard(Clipboard.GetText(), 640, 640)

    '    If (Not Clipboard.ContainsImage()) Then
    '        ' イメージが空っぽならばバーコード生成失敗とみなす。
    '        ' バルーンでお知らせ
    '        NotifyIcon1.BalloonTipIcon = ToolTipIcon.Warning
    '        NotifyIcon1.BalloonTipTitle = "CaptureSaveAs"
    '        NotifyIcon1.BalloonTipText = mw.MJP("QRコードの生成に失敗しました。", "Cannot create a QR code.")
    '        NotifyIcon1.ShowBalloonTip(3000)
    '    End If

    'End Sub

    ' ディレイ用タイマ（すぐの場合も呼び出される）
    Private Sub TimerForDelay_Tick(sender As System.Object, e As System.EventArgs) Handles TimerForDelay.Tick
        TimerForDelay.Stop()

        ' キャプチャウィンドウを生成して読み出しをさせる
        ' キャプチャウィンドウはリストにプールしておき、並列動作できるようにしておく
        Static newPrivateNumber As ULong = 0 ' なるべくたっぷり振れるような固有番号

        If (Clipboard.ContainsImage()) Then
            If bolSingle = True AndAlso CaptureWindowPool.Count > 0 Then
                ' １つの保存ダイアログを開くことしか認められておらず、１つ以上のウィンドウが開いている場合
                ' (とはいえ、ここまでの経緯で複数のウィンドウが既に開かれてしまっているかもしれない。
                '  最終的に開いているウィンドウ位置と入力中の名前を使うことにする)

                ' 最後のキーを取得する
                Dim ulLastKey As ULong
                For Each ulKey As ULong In CaptureWindowPool.Keys
                    ulLastKey = ulKey
                Next

                ' 画像の再読み出し
                Dim dmy As Boolean
                Dim use_cw As New CaptureWindow
                use_cw = CaptureWindowPool.Item(ulLastKey)
                use_cw.loadImage(Now(), dmy)

                use_cw.Show()
                use_cw.TopMost = True
                use_cw.Refresh()
                use_cw.TopMost = False

            Else
                Dim new_cw As New CaptureWindow
                new_cw.ulPrivateNumber = newPrivateNumber
                new_cw.Show()
                new_cw.TopMost = True
                new_cw.Refresh()
                new_cw.TopMost = False

                ' ウィンドウをリストに追加し、固有番号を記憶する。固有番号はカウントアップ
                CaptureWindowPool.Add(newPrivateNumber, new_cw)
                newPrivateNumber += 1UL

            End If

            'Else ' ContainsText()を想定
            '    Try
            '        ' 隠し機能（文字列のバーコード化：【DotNetBarcodeV2.4.0クラスライブラリ(DotNetBarcode.dll)】使用
            '        CopyBarcode()
            '        ' QRcode画像がクリップボードにコピーされるため、以降はその流れに身をゆだねる
            '    Catch ex As System.IO.FileNotFoundException
            '        ' DLLがなければ無視
            '    End Try

            '    Return

        End If

        ' 音を鳴らして、アイコンを変化させる
        If (mw.bolSound) Then
            System.Media.SystemSounds.Beep.Play()
            IconFlash()
        End If

    End Sub

    ' キャプチャウィンドウのリリース
    Public Shared Sub DelCaptureWindow(ByRef ulPrivateNumber As ULong)
        ' 上で振った固有番号を使ってリリースする
        CaptureWindowPool.Remove(ulPrivateNumber)
    End Sub

    ' アイコンのマウスクリック
    ' (右クリックの場合も、まずはここに反応する)
    ' すでに表示済みのウィンドウを再表示
    Private Sub NotifyIcon1_MouseClick(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles NotifyIcon1.MouseClick
        For Each Values As CaptureWindow In CaptureWindowPool.Values
            Values.TopMost = True
            Values.Refresh()
            Values.TopMost = False
        Next
    End Sub

    ' アイコンフラッシュ
    Private Sub IconFlash()
        NotifyIcon1.Icon = My.Resources.CaptureSaveAs2
        TimerForIcon.Start()
    End Sub

    Private Sub TimerForIcon_Tick(sender As System.Object, e As System.EventArgs) Handles TimerForIcon.Tick
        TimerForIcon.Stop()
        NotifyIcon1.Icon = Form1.Icon
    End Sub

    ' 保存先フォルダを開く
    Private Sub miOpenFolder_Click(sender As System.Object, e As System.EventArgs) Handles miOpenFolder.Click
        ' ファイル名の組み立て
        Dim stFileName As StringBuilder
        Dim dtNow As Date = Now()
        Dim intSelectCount As Integer = 0
        Dim bolINumberUsed As Boolean = False

        Try
            If mw.bolShosai = False Then
                ' [簡易指定の場合]
                ' ベースファイル名の取得
                stFileName = New StringBuilder(mw.strFileName)

                ' 日付時刻
                If mw.bAddDateTime Then
                    stFileName.Append(dtNow.ToString("yyyyMMdd-HHmmss-"))
                    intSelectCount += 16
                End If

                ' 通番部分
                If mw.bAddNumber Then
                    stFileName.Append(mw.intNumber.ToString("D8"))
                    bolINumberUsed = True   ' 通番利用フラグ
                    intSelectCount += 8     ' カーソル位置
                End If
            Else
                ' [詳細指定の場合]
                stFileName = New StringBuilder(CaptureWindow.makeFormat(mw.strFileName2, dtNow, bolINumberUsed))
            End If

            ' ファイル名作成処理はここまでで打ち切って、フォルダ名部分のみを取り出す
            Dim strFolderName As String = Path.GetDirectoryName(stFileName.ToString)

            ' エクスプローラでフォルダを開く
            If strFolderName Is Nothing Then
                ' ルートフォルダが指定されていた場合
                System.Diagnostics.Process.Start(stFileName.ToString)
            Else
                System.Diagnostics.Process.Start(strFolderName)
            End If


        Catch ex As Exception
            MessageBox.Show(mw.MJP("保存先フォルダを開けませんでした。" + vbCrLf + ex.ToString(), "Cannot open the folder." + vbCrLf + ex.ToString()), mw.MJP("保存先フォルダを開く", "Open Folder"), MessageBoxButtons.OK, MessageBoxIcon.Error)


        End Try


    End Sub
End Class