﻿Public Class ErrorDialog

    Public Shared Function ShowMessage(ByVal strErrorText As String, ByVal strErrorInfo As String, Optional ByVal strErrorTitle As String = "エラー") As DialogResult
        Dim ed As New ErrorDialog

        ed.m_strErrorTitle = strErrorTitle
        ed.m_strErrorText = strErrorText
        ed.m_strErrorInfo = strErrorInfo

        Return ed.ShowDialog()
    End Function

    Public m_strErrorTitle As String = ""
    Public m_strErrorText As String = ""
    Public m_strErrorInfo As String = ""

    Private Sub ErrorDialog_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' 日本語でWindows 10ならYu Gochicに
        If (mw.modeJP AndAlso Environment.OSVersion.Version.Major >= 10) Then
            Dim f As Font = New Font("Yu Gothic UI", 9)
            Me.Font = f
        End If

        '描画先とするImageオブジェクトを作成する
        Dim canvas As New Bitmap(PictureBox1.Width, PictureBox1.Height)
        'ImageオブジェクトのGraphicsオブジェクトを作成する
        Dim g As Graphics = Graphics.FromImage(canvas)
        'システムのエラーアイコン(WIN32: IDI_ERROR)
        g.DrawIcon(SystemIcons.Error, 0, 0)
        g.Dispose()

        'PictureBox1に表示する
        PictureBox1.Image = canvas

        Me.Text = Me.m_strErrorTitle
        lblErrorText.Text = Me.m_strErrorText
        txtErrorInfo.Text = Me.m_strErrorInfo
    End Sub

    Private Sub btnOK_Click(sender As System.Object, e As System.EventArgs) Handles btnOK.Click
        DialogResult = Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub
End Class