﻿Imports System
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Text

Public Class CaptureWindow

    Public ulPrivateNumber As ULong

    Public Shared Function makeFormat(ByVal strFormat As String, ByVal dtNow As Date, ByRef bolNumberReplace As Boolean) As String
        Dim stFileName As StringBuilder = New StringBuilder(strFormat)

        ' ファイル名のフォーマットを1つずつ変換
        '<%t4y> : 年(4桁)
        stFileName.Replace("<%t4y>", dtNow.ToString("yyyy"))
        '<%t2y> : 年(2桁)
        stFileName.Replace("<%t2y>", dtNow.ToString("yy"))
        '<%t0m> : 月(2桁)(1桁のときは、10の位は0)
        stFileName.Replace("<%t0m>", dtNow.ToString("MM"))
        '<%tm>  : 月(1桁)(1桁のときは、10の位は無し)
        stFileName.Replace("<%tm>", dtNow.ToString("%M"))
        '<%tem> : 月(英語表記)
        stFileName.Replace("<%tem>", dtNow.ToString("MMMM"))
        '<%tsem>: 月(英語表記省略形)
        stFileName.Replace("<%tsem>", dtNow.ToString("MMM"))
        '<%t0d> : 日(2桁)(1桁のときは、10の位は0)
        stFileName.Replace("<%t0d>", dtNow.ToString("dd"))
        '<%td>  : 日(1桁)(1桁のときは、10の位は無し)
        stFileName.Replace("<%td>", dtNow.ToString("%d"))
        '<%t0h> : 時(2桁)(1桁のときは、10の位は0)
        stFileName.Replace("<%t0h>", dtNow.ToString("HH"))
        '<%th>  : 時(1桁)(1桁のときは、10の位は無し)
        stFileName.Replace("<%th>", dtNow.ToString("%H"))
        '<%t0n> : 分(2桁)(1桁のときは、10の位は0)
        stFileName.Replace("<%t0n>", dtNow.ToString("mm"))
        '<%tn>  : 分(1桁)(1桁のときは、10の位は無し)
        stFileName.Replace("<%tn>", dtNow.ToString("%m"))
        '<%t0s> : 秒(2桁)(1桁のときは、10の位は0)
        stFileName.Replace("<%t0s>", dtNow.ToString("ss"))
        '<%ts>  : 秒(1桁)(1桁のときは、10の位は無し)
        stFileName.Replace("<%ts>", dtNow.ToString("%s"))
        '<%tms> : ミリ秒
        stFileName.Replace("<%tms>", dtNow.ToString("fff"))

        ' 連番置換前
        Dim strBeforeReplaceNumber As String = stFileName.ToString

        '<%n?>   : 連番(最低?桁)
        stFileName.Replace("<%n8>", mw.intNumber.ToString("D8"))
        stFileName.Replace("<%n7>", mw.intNumber.ToString("D7"))
        stFileName.Replace("<%n6>", mw.intNumber.ToString("D6"))
        stFileName.Replace("<%n5>", mw.intNumber.ToString("D5"))
        stFileName.Replace("<%n4>", mw.intNumber.ToString("D4"))
        stFileName.Replace("<%n3>", mw.intNumber.ToString("D3"))
        stFileName.Replace("<%n2>", mw.intNumber.ToString("D2"))
        stFileName.Replace("<%n1>", mw.intNumber.ToString("D1"))

        ' 連番置換後
        Dim strAfterReplaceNumber As String = stFileName.ToString

        ' 連番置換が発生していたら、bolNumberReplaceをTrueにする
        ' (ここ以前にbolNumberReplaceがTrueになっている可能性があるので、連番置換が発生していなかった
        '  からといって、あえてFalseにはしない)
        If strBeforeReplaceNumber <> strAfterReplaceNumber Then
            bolNumberReplace = True
        End If

        Return strAfterReplaceNumber
    End Function


    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        ' キャンセル
        Me.Close()
    End Sub

    Private Sub btnSave_Click(sender As System.Object, e As System.EventArgs) Handles btnSave.Click
        ' 保存

        Dim strExt As String
        Dim strFileName As String = txtFileName.Text

        Try
            ' 拡張子部分の取り出し
            strExt = System.IO.Path.GetExtension(txtFileName.Text).ToLower

            ' ■フォルダの存在確認
            ' フォルダ名部分の取り出し
            Dim strDirName As String = System.IO.Path.GetDirectoryName(strFileName)

            ' ファイル名形式のチェック(この時点で、* と ? はチェックをすり抜けているので、個別にチェックする)
            ' (ちなみに、不正な位置に : がある場合は、残念ながらすり抜けることになる)
            If (strDirName Is Nothing) Then
                MessageBox.Show("ファイル名の指定が不正です(ルートディレクトリが指定されているなど)。ファイル名を見直してください。", "ファイルへ保存", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return
            ElseIf (strDirName.IndexOf("*"c) <> -1 OrElse strDirName.IndexOf("?"c) <> -1) Then
                MessageBox.Show("ファイル名の指定が不正です。ファイル名を見直してください。", "ファイルへ保存", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return
            End If

            If Not System.IO.Directory.Exists(strDirName) Then
                If DialogResult.No = MessageBox.Show("フォルダ " + strDirName + " は存在しません。フォルダを新規作成しますか?。", "ファイルへ保存", MessageBoxButtons.YesNo, MessageBoxIcon.Question) Then
                    Return
                End If

                Try
                    System.IO.Directory.CreateDirectory(strDirName)
                Catch ex As Exception
                    ErrorDialog.ShowMessage("新規フォルダを作成できません。フォルダ名を見直してください。", ex.ToString(), "ファイルへ保存")
                    Return
                End Try
            End If
        Catch ex As Exception
            ErrorDialog.ShowMessage("ファイル名の指定が不正です。ファイル名を見直してください。", ex.ToString(), "ファイルへ保存")
            Return
        End Try

        Try
            Select Case mw.intFormat
                Case mw.cPng
                    ' Pngで保存
                    If Not strExt = ".png" Then
                        strFileName += ".png"
                    End If

                Case mw.cBmp
                    If Not strExt = ".bmp" Then
                        strFileName += ".bmp"
                    End If

                Case Else
                    ' Jpegで保存
                    If Not (strExt = ".jpg" OrElse strExt = ".jpeg") Then
                        strFileName += ".jpg"
                    End If

            End Select

            If System.IO.File.Exists(strFileName) Then
                If DialogResult.Cancel = MessageBox.Show(strFileName + "はすでに存在します。上書きしますか?", "ファイルへ保存", MessageBoxButtons.OKCancel, MessageBoxIcon.Question) Then
                    Return
                End If
            End If

            Select Case mw.intFormat
                Case mw.cPng
                    ' Pngで保存
                    PictureBox1.Image.Save(strFileName, System.Drawing.Imaging.ImageFormat.Png)

                Case mw.cBmp
                    ' BMPで保存
                    PictureBox1.Image.Save(strFileName, System.Drawing.Imaging.ImageFormat.Bmp)

                Case Else
                    ' Jpegで保存
                    'EncoderParameter(1つ分) - 画質のみを指定
                    Dim eps As New System.Drawing.Imaging.EncoderParameters(1)
                    Dim ep As New System.Drawing.Imaging.EncoderParameter( _
                        System.Drawing.Imaging.Encoder.Quality, CLng(mw.intJpegQuality))
                    'EncoderParametersにセットする
                    eps.Param(0) = ep

                    'イメージエンコーダに関する情報を取得する
                    Dim ici As System.Drawing.Imaging.ImageCodecInfo = GetEncoderInfo(System.Drawing.Imaging.ImageFormat.Jpeg)

                    PictureBox1.Image.Save(strFileName, ici, eps)

            End Select

            btnCancel.Visible = False
            btnSave.Visible = False
            txtFileName.Enabled = False

            lblInfo.Visible = False
            lblInfo2.Visible = True

            ' 1500ミリ秒後にクローズ
            Timer_End.Start()

        Catch ex As System.NotSupportedException
            ErrorDialog.ShowMessage(strFileName + "へ保存できません。ファイル名の形式が不正であるため、ファイル名を見直してください。", ex.ToString(), "ファイルへ保存")

        Catch ex As System.ArgumentException
            ErrorDialog.ShowMessage(strFileName + "へ保存できません。ファイル名に不正な文字が含まれているため、ファイル名を見直してください。", ex.ToString(), "ファイルへ保存")

        Catch ex As Exception
            ErrorDialog.ShowMessage(strFileName + "へ保存できません。", ex.ToString(), "ファイルへ保存")
        End Try
    End Sub

    ' JPEGエンコーダの取得（MSDNライブラリより）
    Private Shared Function GetEncoderInfo(ByVal format As ImageFormat) As ImageCodecInfo
        Dim j As Integer
        Dim encoders() As ImageCodecInfo
        encoders = ImageCodecInfo.GetImageEncoders()

        j = 0
        While j < encoders.Length
            If encoders(j).FormatID = format.Guid Then
                Return encoders(j)
            End If
            j += 1
        End While
        Return Nothing

    End Function

    Private Sub CaptureWindow_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim dtNow As Date = Now()
        Dim intSelectCount As Integer = 0
        Dim bolINumberUsed As Boolean = False

        ' 日本語でWindows 10ならYu Gochicに
        If (mw.modeJP AndAlso Environment.OSVersion.Version.Major >= 10) Then
            Dim f As Font = New Font("Yu Gothic UI", 9)
            Me.Font = f
        End If

        ' クリップボードからの画像取得
        loadImage(dtNow, bolINumberUsed)

        ' ファイル名の組み立て
        Dim stFileName As StringBuilder

        If mw.bolShosai = False Then
            ' [簡易指定の場合]
            ' ベースファイル名の取得
            stFileName = New StringBuilder(mw.strFileName)

            ' 日付時刻
            If mw.bAddDateTime Then
                stFileName.Append(dtNow.ToString("yyyyMMdd-HHmmss-"))
                intSelectCount += 16
            End If

            ' 通番部分
            If mw.bAddNumber Then
                stFileName.Append(mw.intNumber.ToString("D8"))
                bolINumberUsed = True   ' 通番利用フラグ
                intSelectCount += 8     ' カーソル位置
            End If
        Else
            ' [詳細指定の場合]
            stFileName = New StringBuilder(makeFormat(mw.strFileName2, dtNow, bolINumberUsed))
        End If

        ' 拡張子を付与
        Select Case mw.intFormat
            Case mw.cPng
                ' Pngで保存
                stFileName.Append(".png")

            Case mw.cBmp
                ' Pngで保存
                stFileName.Append(".bmp")

            Case Else
                ' Jpegで保存
                stFileName.Append(".jpg")

        End Select

        ' ファイル名の完成
        txtFileName.Text = stFileName.ToString

        If mw.bolShosai = False Then
            ' [簡易指定の場合]
            ' 通番部分・日付部分がある場合は、通番を選択状態にする
            ' 通番部分・日付部分がない場合は、通番・日付があるはずの位置にカーソルを合わせる
            txtFileName.Select(mw.strFileName.Length, intSelectCount)
        Else
            ' [詳細指定の場合]
            '*  : カーソル位置(始めの1つのみが有効)
            Dim intSelectedStartPos As Integer

            intSelectedStartPos = txtFileName.Text.IndexOf("*"c)
            If intSelectedStartPos <> -1 Then
                txtFileName.Text = txtFileName.Text.Replace("*", "")
                txtFileName.Select(intSelectedStartPos, 0)
            Else
                txtFileName.Select(txtFileName.Text.Length - 4, 0)
            End If
        End If

        ' プライマリ画面を取得し、自身が表示されるべき場所を取得
        Me.Top = Screen.GetWorkingArea(Me).Height - Me.Height
        Me.Left = Screen.GetWorkingArea(Me).Width - Me.Width

        ' 通番が利用されたらカウントアップ
        If bolINumberUsed Then
            mw.intNumber += 1 ' 次回通番を+1
            If (mw.intNumber > 99999999) Then
                ' 99999999を超えたら0にする(初期値は1だが、この場合だけ0で)
                mw.intNumber = 0
            End If
        End If

        ' ファイル名修正をスキップする場合は、保存ボタン押下をシミュレート
        If mw.bolSkipDlg Then
            btnSave_Click(sender, e)
        End If

    End Sub

    ' グレースケールのイメージに変換する
    Public Function get_grayscale_img(ByVal img As Image) As Image
        'グレースケールの描画先となるImageオブジェクトを作成
        Dim newImg As New Bitmap(img.Width, img.Height)
        'newImgのGraphicsオブジェクトを取得
        Dim g As Graphics = Graphics.FromImage(newImg)

        'ColorMatrixオブジェクトの作成
        'グレースケールに変換するための行列を指定する
        Dim cm As New System.Drawing.Imaging.ColorMatrix( _
            New Single()() { _
                New Single() {0.299F, 0.299F, 0.299F, 0, 0}, _
                New Single() {0.587F, 0.587F, 0.587F, 0, 0}, _
                New Single() {0.114F, 0.114F, 0.114F, 0, 0}, _
                New Single() {0, 0, 0, 1, 0}, _
                New Single() {0, 0, 0, 0, 1} _
            })
        'ImageAttributesオブジェクトの作成
        Dim ia As New System.Drawing.Imaging.ImageAttributes()
        'ColorMatrixを設定する
        ia.SetColorMatrix(cm)

        'ImageAttributesを使用してグレースケールを描画
        g.DrawImage(img, New Rectangle(0, 0, img.Width, img.Height), _
                    0, 0, img.Width, img.Height, GraphicsUnit.Pixel, ia)

        'リソースを解放する
        g.Dispose()
        Return newImg
    End Function

    ' サイズ拡大縮小
    Public Function imgZoom(ByRef img As Image) As Image
        Dim canvas As Bitmap
        Dim g As Graphics
        Dim intNewWidth As Integer, intNewHeight As Integer

        Select Case (mw.intZoomKind)
            Case 0 ' 相対指定
                intNewWidth = img.Width * mw.intZoomWidth \ 100
                intNewHeight = img.Height * mw.intZoomHeight \ 100

            Case 1 ' 絶対指定
                intNewWidth = mw.intZoomWidth
                intNewHeight = mw.intZoomHeight

            Case 2 ' 絶対指定（縦横比固定）
                If (img.Width / img.Height < mw.intZoomWidth / mw.intZoomHeight) Then
                    intNewWidth = CInt(mw.intZoomHeight / (img.Height / img.Width))
                    intNewHeight = mw.intZoomHeight
                Else
                    intNewWidth = mw.intZoomWidth
                    intNewHeight = CInt(mw.intZoomWidth / (img.Width / img.Height))
                End If
        End Select

        canvas = New Bitmap(intNewWidth, intNewHeight)
        g = Graphics.FromImage(canvas)
        g.InterpolationMode = CType(mw.intInterpolationMode, Drawing2D.InterpolationMode)
        g.DrawImage(img, 0, 0, intNewWidth, intNewHeight)
        g.Dispose()

        Return canvas
    End Function

    Public Sub drawDateTime(ByRef img As Image, ByVal dtNow As Date, ByRef bolNumberReplace As Boolean)
        If mw.bolDrawDT_DateTime Then
            Dim canvas As Bitmap
            Dim g As Graphics
            Dim text As String
            Dim fFont As Font
            Dim cColor As Color
            Dim sSizeF As SizeF
            Dim pPointF As PointF
            Dim bBrush As Brush

            ' 埋め込みテキストの作成
            text = makeFormat(mw.strDrawDT_Format, dtNow, bolNumberReplace)

            ' 描画領域の作成
            canvas = New Bitmap(img.Width, img.Height)
            g = Graphics.FromImage(canvas)

            ' フォントの生成
            If mw.strDrawDT_FontName <> "" Then
                Dim newStyle As System.Drawing.FontStyle = FontStyle.Regular
                If mw.bolDrawDT_FontBold Then
                    newStyle = newStyle Or FontStyle.Bold
                End If
                If mw.bolDrawDT_FontItalic Then
                    newStyle = newStyle Or FontStyle.Italic
                End If
                If mw.bolDrawDT_FontUnderline Then
                    newStyle = newStyle Or FontStyle.Underline
                End If
                If mw.bolDrawDT_FontStrikeout Then
                    newStyle = newStyle Or FontStyle.Strikeout
                End If
                fFont = New Font(mw.strDrawDT_FontName, mw.intDrawDT_FontSize, newStyle)

                cColor = Color.FromArgb(mw.intDrawDT_FontColor)     ' 色
            Else
                ' フォントが未設定の場合はMainWindowが採用しているフォントを仮採用する。文字色は白。
                fFont = mw.Font
                cColor = Color.White
            End If

            ' 描画サイズを測定
            sSizeF = g.MeasureString(text, fFont)
            sSizeF.Width += 4
            Dim iMargin As Integer = 0 'CInt(sSizeF.Height / 2)

            ' 描画位置に応じて、座標を計算
            Select Case mw.intDrawDT_Place
                Case 0     ' 左上
                    pPointF.X = 0 + iMargin
                    pPointF.Y = 0 + iMargin
                Case 1     ' 上部中央
                    pPointF.X = img.Width \ 2 - CInt(sSizeF.Width) \ 2
                    pPointF.Y = 0 + iMargin
                Case 2     ' 右上
                    pPointF.X = img.Width - CInt(sSizeF.Width) - iMargin
                    pPointF.Y = 0 + iMargin
                Case 3     ' 左側（高さは中央）
                    pPointF.X = 0 + iMargin
                    pPointF.Y = img.Height \ 2 - CInt(sSizeF.Height) \ 2
                Case 4     ' 中央
                    pPointF.X = img.Width \ 2 - CInt(sSizeF.Width) \ 2
                    pPointF.Y = img.Height \ 2 - CInt(sSizeF.Height) \ 2
                Case 5     ' 右側（高さは中央）
                    pPointF.X = img.Width - CInt(sSizeF.Width) - iMargin
                    pPointF.Y = img.Height \ 2 - CInt(sSizeF.Height) \ 2
                Case 6     ' 左下
                    pPointF.X = 0 + iMargin
                    pPointF.Y = img.Height - CInt(sSizeF.Height) - iMargin
                Case 7     ' 下部中央
                    pPointF.X = img.Width \ 2 - CInt(sSizeF.Width) \ 2
                    pPointF.Y = img.Height - CInt(sSizeF.Height) - iMargin
                Case Else  ' 右下
                    pPointF.X = img.Width - CInt(sSizeF.Width) - iMargin
                    pPointF.Y = img.Height - CInt(sSizeF.Height) - iMargin
            End Select

            ' ブラシの作成
            bBrush = New SolidBrush(cColor)

            ' 画像の描画
            g.DrawImage(img, 0, 0)

            ' 背景色を指定している場合
            If mw.bolDrawDT_BackFillColor Then
                Dim bBrushBG As Brush = New SolidBrush(Color.FromArgb(mw.intDrawDT_BGColor))

                ' 背景の描画
                g.FillRectangle(bBrushBG, pPointF.X, pPointF.Y, sSizeF.Width, sSizeF.Height)

            End If

            ' 画像の上から文字列を描画
            g.DrawString(text, fFont, bBrush, pPointF)

            ' 描画されたキャンバスをイメージに戻す
            img = canvas

            ' 解放
            g.Dispose()
        End If
    End Sub

    Public Sub loadImage(ByVal dtNow As Date, ByRef bolNumberReplace As Boolean)
        ' フォームが開かれたら
        ' クリップボードから画像を取り出す
        ' (クリップボードの中身が画像でなければフォームを閉じる)
        Try
            If Clipboard.ContainsImage() Then
                'クリップボードにあるデータの取得
                Dim img As Image = Clipboard.GetImage()
                If img IsNot Nothing Then
                    'データが取得できたときは表示する

                    ' サイズ拡大縮小
                    If (Not (mw.intZoomKind = 0 AndAlso mw.intZoomWidth = 100 AndAlso mw.intZoomHeight = 100)) Then
                        Dim img_tmp As Image = imgZoom(img)
                        img.Dispose()
                        img = img_tmp
                    End If

                    ' 日付時刻等の埋め込み
                    drawDateTime(img, dtNow, bolNumberReplace)

                    ' 回転と反転
                    img.RotateFlip(CType(mw.intRotateFlip, RotateFlipType))

                    If mw.bolGrayScale Then
                        ' グレースケールに変換
                        PictureBox1.Image = get_grayscale_img(img)
                        img.Dispose()
                    Else
                        ' そのまま
                        PictureBox1.Image = img
                    End If

                End If
            End If

        Catch ex As Exception
            btnCancel.Visible = False
            btnSave.Visible = False
            txtFileName.Enabled = False

            ErrorDialog.ShowMessage("クリップボードからのデータ取得に失敗しました。", ex.ToString(), "ファイルへ保存")

            ' 1500ミリ秒後にクローズ
            Timer_End.Start()
        End Try

        ' 現在時刻の表示
        lblInfo.Text = dtNow.ToString()

    End Sub

    Private Sub CaptureWindow_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        ' クローズする際はフォーム１にプールからの削除を依頼する
        mw.DelCaptureWindow(ulPrivateNumber)
    End Sub

    Private Sub Timer1_Tick(sender As System.Object, e As System.EventArgs) Handles Timer_End.Tick, lblInfo2.Click
        Timer_End.Stop()
        Me.Close()
    End Sub

    Private Sub Timer_Start_Tick(sender As System.Object, e As System.EventArgs) Handles Timer_Start.Tick
        ' 最初は必ず最前面に表示されつつも、以降は最前面にならないようにするため
        Timer_Start.Stop()
        'Me.TopMost = True
        Me.Refresh()
        Me.TopMost = False
    End Sub

    Private Sub btnBrowse_Click(sender As System.Object, e As System.EventArgs) Handles btnBrowse.Click
        ' 参照ボタンの押下

        ' 保存形式によって、保存ダイアログのフィルタや付与拡張子を変える
        Select Case mw.intFormat
            Case mw.cPng
                ' Pngで保存
                SaveFileDialog1.DefaultExt = ".png"
                SaveFileDialog1.Filter = "PNGファイル|*.png|すべてのファイル|*.*"

            Case mw.cBmp
                ' BMPで保存
                SaveFileDialog1.DefaultExt = ".bmp"
                SaveFileDialog1.Filter = "BMPファイル|*.bmp|すべてのファイル|*.*"

            Case Else
                ' Jpegで保存
                SaveFileDialog1.DefaultExt = ".jpg"
                SaveFileDialog1.Filter = "JPEGファイル|*.jpg|すべてのファイル|*.*"

        End Select

        ' デフォルトのフォルダ
        Try
            SaveFileDialog1.InitialDirectory = System.IO.Path.GetDirectoryName(txtFileName.Text)
        Catch ex As Exception
            ' 特に何もしない。初期ディレクトリが代入されないだけ
        End Try

        ' デフォルトのファイル名
        SaveFileDialog1.FileName = txtFileName.Text

        If DialogResult.OK = SaveFileDialog1.ShowDialog() Then
            txtFileName.Text = SaveFileDialog1.FileName
        End If

    End Sub
End Class