﻿Public Class AboutDialog

    Private Sub AboutDialog_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' 日本語でWindows 10ならYu Gochicに
        If (mw.modeJP AndAlso Environment.OSVersion.Version.Major >= 10) Then
            Dim f As Font = New Font("Yu Gothic UI", 9)
            Me.Font = f
        End If

        '自分自身のバージョン情報を取得する
        Dim ver As System.Diagnostics.FileVersionInfo = _
            System.Diagnostics.FileVersionInfo.GetVersionInfo( _
            System.Reflection.Assembly.GetExecutingAssembly().Location)

        Dim strBetaVer As String = mw.strBetaVer
        If Not mw.modeJP Then
            strBetaVer = strBetaVer.Replace("β", "beta")
            strBetaVer = strBetaVer.Replace("α", "alpha")
        End If


        'AssemblyTitleの取得
        Dim asmttl As System.Reflection.AssemblyTitleAttribute = _
            CType(Attribute.GetCustomAttribute( _
                System.Reflection.Assembly.GetExecutingAssembly(), _
                GetType(System.Reflection.AssemblyTitleAttribute)),  _
                    System.Reflection.AssemblyTitleAttribute)
        lblSoftwareNameVer.Text = asmttl.Title & " version " & ver.FileMajorPart & "." & ver.FileMinorPart & ver.FileBuildPart & strBetaVer

        'AssemblyCopyrightの取得
        Dim asmcpy As System.Reflection.AssemblyCopyrightAttribute = _
            CType(Attribute.GetCustomAttribute( _
                System.Reflection.Assembly.GetExecutingAssembly(), _
                GetType(System.Reflection.AssemblyCopyrightAttribute)),  _
                    System.Reflection.AssemblyCopyrightAttribute)
        lblCopyright.Text = asmcpy.Copyright
        If Not mw.modeJP Then
            lblCopyright.Text = lblCopyright.Text.Replace("矢吹拓也", "T.Yabuki")
        End If

        ' URL
        lblLinkLabel.Text = mw.strURL
    End Sub

    Private Sub lblLinkLabel_LinkClicked(sender As System.Object, e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles lblLinkLabel.LinkClicked
        Try
            System.Diagnostics.Process.Start(lblLinkLabel.Text)
            lblLinkLabel.LinkVisited = True
        Catch ex As Exception
            ErrorDialog.ShowMessage(mw.MJP("URLを開けません。", "Cannot open the URL."), ex.ToString(), Me.Text)
        End Try
    End Sub

    Private Sub lblLink1_LinkClicked(sender As System.Object, e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles lblLink1.LinkClicked
        Try
            System.Diagnostics.Process.Start("https://www.inasoft.org/ifa.php?CASAVEAS")
            lblLink1.LinkVisited = True
        Catch ex As Exception
            ErrorDialog.ShowMessage(mw.MJP("URLを開けません。", "Cannot open the URL."), ex.ToString(), Me.Text)
        End Try
    End Sub

    Private Sub lblLink2_LinkClicked(sender As System.Object, e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles lblLink2.LinkClicked
        Try
            System.Diagnostics.Process.Start("https://www.inasoft.org/kifu.html")
            lblLink2.LinkVisited = True
        Catch ex As Exception
            ErrorDialog.ShowMessage(mw.MJP("URLを開けません。", "Cannot open the URL."), ex.ToString(), Me.Text)
        End Try
    End Sub
End Class
