﻿Imports Microsoft.Win32

Public Class OpeningDlg

    Private Sub OpeningDlg_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' 日本語でWindows 10ならYu Gochicに
        If (mw.modeJP AndAlso Environment.OSVersion.Version.Major >= 10) Then
            Dim f As Font = New Font("Yu Gothic UI", 9)
            Me.Font = f
        End If
    End Sub

    Private Sub btnClose_Click(sender As System.Object, e As System.EventArgs) Handles btnClose.Click
        Close()
    End Sub

    Private Sub OpeningDlg_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        If chkNoShow.Checked Then
            mw.boolNoShow = True
            Me.Hide()

            Try
                ' レジストリキーのパスを指定してレジストリを開く or iniファイル指定
                Dim hc As New HybridConfig

                If mw.bUseIni Then
                    hc.OpenIniFile(mw.strIniName, mw.strIniSection)
                Else
                    hc.OpenRegKey(Registry.CurrentUser.CreateSubKey(mw.strRegName))
                End If

                ' レジストリの値を取得
                With hc
                    ' 起動時ダイアログを二度と表示しない
                    .SetBolValue("boolNoShow", mw.boolNoShow)

                    .Close()    ' 開いたレジストリキーを閉じる
                End With

            Catch ex As Exception
                ' レジストリへ書き込み失敗
                If mw.bUseIni Then
                    ErrorDialog.ShowMessage(mw.MJP("iniファイルへ設定値を書き込めません。", "Cannot write to the ini file."), ex.ToString(), mw.MJP("設定", "Settings"))
                Else
                    ErrorDialog.ShowMessage(mw.MJP("レジストリへ設定値を書き込めません。", "Cannot write to the registry."), ex.ToString(), mw.MJP("設定", "Settings"))
                End If

            End Try

        End If
    End Sub
End Class